/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Instance;

public class PlayerID
extends Instance
implements INetworkPacket {
    protected IsoPlayer player;
    protected byte playerIndex;

    public void set(IsoPlayer isoPlayer) {
        super.set(isoPlayer.OnlineID);
        this.playerIndex = (byte)(isoPlayer.isLocal() ? (int)isoPlayer.getPlayerNum() : -1);
        this.player = isoPlayer;
    }

    public void parsePlayer(UdpConnection udpConnection) {
        if (GameServer.bServer) {
            this.player = udpConnection != null && this.playerIndex != -1 ? GameServer.getPlayerFromConnection(udpConnection, this.playerIndex) : GameServer.IDToPlayerMap.get(this.ID);
        } else if (GameClient.bClient) {
            this.player = GameClient.IDToPlayerMap.get(this.ID);
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.playerIndex = byteBuffer.get();
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        byteBufferWriter.putByte(this.playerIndex);
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.getCharacter() != null;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tPlayer [ player " + (String)(this.player == null ? "?" : "\"" + this.player.getUsername() + "\"") + " ]";
    }

    public IsoPlayer getCharacter() {
        return this.player;
    }
}

