/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.packets.DeadCharacterPacket;
import zombie.network.packets.INetworkPacket;

public class DeadPlayerPacket
extends DeadCharacterPacket
implements INetworkPacket {
    private byte playerFlags;
    private float infectionLevel;
    private IsoPlayer player;

    @Override
    public void set(IsoGameCharacter isoGameCharacter) {
        super.set(isoGameCharacter);
        this.player = (IsoPlayer)isoGameCharacter;
        if (GameClient.bClient) {
            this.id = (short)this.player.getPlayerNum();
        }
        this.infectionLevel = this.player.getBodyDamage().getInfectionLevel();
        this.playerFlags = (byte)(this.playerFlags | (byte)(this.player.getBodyDamage().isInfected() ? 1 : 0));
    }

    @Override
    public void process() {
        if (this.player != null) {
            this.character.setHealth(0.0f);
            this.player.getBodyDamage().setOverallBodyHealth(0.0f);
            this.player.getBodyDamage().setInfected((this.playerFlags & 1) != 0);
            this.player.getBodyDamage().setInfectionLevel(this.infectionLevel);
            super.process();
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.infectionLevel = byteBuffer.getFloat();
        if (GameServer.bServer) {
            this.player = GameServer.getPlayerFromConnection(udpConnection, this.id);
        } else if (GameClient.bClient) {
            this.player = GameClient.IDToPlayerMap.get(this.id);
        }
        if (this.player != null) {
            this.character = this.player;
            this.parseCharacterInventory(byteBuffer);
            this.character.setHealth(0.0f);
            this.character.getBodyDamage().setOverallBodyHealth(0.0f);
            this.character.getNetworkCharacterAI().setDeadBody(this);
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        byteBufferWriter.putFloat(this.infectionLevel);
        this.writeCharacterInventory(byteBufferWriter);
    }

    @Override
    public String getDescription() {
        return super.getDescription() + String.format(" | isInfected=%b infectionLevel=%f", (this.playerFlags & 1) != 0, Float.valueOf(this.infectionLevel));
    }

    public IsoPlayer getPlayer() {
        return this.player;
    }
}

