/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoDeadBody;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.packets.INetworkPacket;

public abstract class DeadCharacterPacket
implements INetworkPacket {
    public short id;
    protected float x;
    protected float y;
    protected float z;
    protected float angle;
    protected IsoDirections direction;
    protected byte characterFlags;
    protected IsoGameCharacter killer;
    protected IsoGameCharacter character;

    public void set(IsoGameCharacter isoGameCharacter) {
        this.character = isoGameCharacter;
        this.id = isoGameCharacter.getOnlineID();
        this.killer = isoGameCharacter.getAttackedBy();
        this.x = isoGameCharacter.getX();
        this.y = isoGameCharacter.getY();
        this.z = isoGameCharacter.getZ();
        this.angle = isoGameCharacter.getAnimAngleRadians();
        this.direction = isoGameCharacter.getDir();
        this.characterFlags = (byte)(isoGameCharacter.isFallOnFront() ? 1 : 0);
    }

    public void process() {
        if (this.character != null) {
            boolean bl;
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y, this.z);
            if (this.character.getCurrentSquare() != isoGridSquare) {
                DebugLog.Multiplayer.warn(String.format("Corpse %s(%d) teleport: position (%f ; %f) => (%f ; %f)", this.character.getClass().getSimpleName(), this.id, Float.valueOf(this.character.x), Float.valueOf(this.character.y), Float.valueOf(this.x), Float.valueOf(this.y)));
                this.character.setX(this.x);
                this.character.setY(this.y);
                this.character.setZ(this.z);
            }
            if (this.character.getAnimAngleRadians() - this.angle > 1.0E-4f) {
                DebugLog.Multiplayer.warn(String.format("Corpse %s(%d) teleport: direction (%f) => (%f)", this.character.getClass().getSimpleName(), this.id, Float.valueOf(this.character.getAnimAngleRadians()), Float.valueOf(this.angle)));
                if (this.character.hasAnimationPlayer() && this.character.getAnimationPlayer().isReady() && !this.character.getAnimationPlayer().isBoneTransformsNeedFirstFrame()) {
                    this.character.getAnimationPlayer().setAngle(this.angle);
                } else {
                    this.character.getForwardDirection().setDirection(this.angle);
                }
            }
            boolean bl2 = bl = (this.characterFlags & 1) != 0;
            if (bl != this.character.isFallOnFront()) {
                DebugLog.Multiplayer.warn(String.format("Corpse %s(%d) teleport: pose (%s) => (%s)", this.character.getClass().getSimpleName(), this.id, this.character.isFallOnFront() ? "front" : "back", bl ? "front" : "back"));
                this.character.setFallOnFront(bl);
            }
            this.character.setCurrent(isoGridSquare);
            this.character.dir = this.direction;
            this.character.setAttackedBy(this.killer);
            this.character.becomeCorpse();
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.id = byteBuffer.getShort();
        this.x = byteBuffer.getFloat();
        this.y = byteBuffer.getFloat();
        this.z = byteBuffer.getFloat();
        this.angle = byteBuffer.getFloat();
        this.direction = IsoDirections.fromIndex(byteBuffer.get());
        this.characterFlags = byteBuffer.get();
        byte by = byteBuffer.get();
        short s = -1;
        if (GameServer.bServer) {
            switch (by) {
                case 0: {
                    this.killer = null;
                    break;
                }
                case 1: {
                    s = byteBuffer.getShort();
                    this.killer = ServerMap.instance.ZombieMap.get(s);
                    break;
                }
                case 2: {
                    s = byteBuffer.getShort();
                    this.killer = GameServer.IDToPlayerMap.get(s);
                    break;
                }
                default: {
                    Exception exception = new Exception("killerIdType:" + by);
                    exception.printStackTrace();
                    break;
                }
            }
        } else {
            switch (by) {
                case 0: {
                    this.killer = null;
                    break;
                }
                case 1: {
                    s = byteBuffer.getShort();
                    this.killer = (IsoGameCharacter)GameClient.IDToZombieMap.get(s);
                    break;
                }
                case 2: {
                    s = byteBuffer.getShort();
                    this.killer = GameClient.IDToPlayerMap.get(s);
                    break;
                }
                default: {
                    Exception exception = new Exception("killerIdType:" + by);
                    exception.printStackTrace();
                }
            }
        }
    }

    protected IsoDeadBody getDeadBody() {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.x, this.y, this.z);
        if (isoGridSquare != null) {
            for (IsoMovingObject isoMovingObject : isoGridSquare.getStaticMovingObjects()) {
                if (!(isoMovingObject instanceof IsoDeadBody) || ((IsoDeadBody)isoMovingObject).getOnlineID() != this.id) continue;
                return (IsoDeadBody)isoMovingObject;
            }
        }
        return null;
    }

    protected void parseDeadBodyInventory(IsoDeadBody isoDeadBody, ByteBuffer byteBuffer) {
        String string = isoDeadBody.readInventory(byteBuffer);
        isoDeadBody.getContainer().setType(string);
    }

    protected void parseDeadBodyHumanVisuals(IsoDeadBody isoDeadBody, ByteBuffer byteBuffer) {
        HumanVisual humanVisual = isoDeadBody.getHumanVisual();
        if (humanVisual != null) {
            try {
                humanVisual.load(byteBuffer, IsoWorld.getWorldVersion());
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "Parse dead body HumanVisuals failed", LogSeverity.Error);
            }
        }
    }

    protected void parseCharacterInventory(ByteBuffer byteBuffer) {
        if (this.character != null) {
            if (this.character.getContainer() != null) {
                this.character.getContainer().clear();
            }
            if (this.character.getInventory() != null) {
                this.character.getInventory().clear();
            }
            if (this.character.getWornItems() != null) {
                this.character.getWornItems().clear();
            }
            if (this.character.getAttachedItems() != null) {
                this.character.getAttachedItems().clear();
            }
            this.character.getInventory().setSourceGrid(this.character.getCurrentSquare());
            String string = this.character.readInventory(byteBuffer);
            this.character.getInventory().setType(string);
            this.character.resetModelNextFrame();
        }
    }

    protected void writeCharacterInventory(ByteBufferWriter byteBufferWriter) {
        if (this.character != null) {
            this.character.writeInventory(byteBufferWriter.bb);
        }
    }

    protected void writeCharacterHumanVisuals(ByteBufferWriter byteBufferWriter) {
        if (this.character != null) {
            int n = byteBufferWriter.bb.position();
            byteBufferWriter.putByte((byte)1);
            try {
                byteBufferWriter.putBoolean(this.character.isFemale());
                this.character.getVisual().save(byteBufferWriter.bb);
            }
            catch (Exception exception) {
                byteBufferWriter.bb.put(n, (byte)0);
                DebugLog.Multiplayer.printException(exception, "Write character HumanVisuals failed", LogSeverity.Error);
            }
        }
    }

    protected void parseCharacterHumanVisuals(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (this.character != null && by != 0) {
            try {
                this.character.setFemale(byteBuffer.get() != 0);
                this.character.getVisual().load(byteBuffer, IsoWorld.getWorldVersion());
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "Parse character HumanVisuals failed", LogSeverity.Error);
            }
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putShort(this.id);
        byteBufferWriter.putFloat(this.x);
        byteBufferWriter.putFloat(this.y);
        byteBufferWriter.putFloat(this.z);
        byteBufferWriter.putFloat(this.angle);
        byteBufferWriter.putByte((byte)this.direction.index());
        byteBufferWriter.putByte(this.characterFlags);
        if (this.killer == null) {
            byteBufferWriter.putByte((byte)0);
        } else {
            if (this.killer instanceof IsoZombie) {
                byteBufferWriter.putByte((byte)1);
            } else {
                byteBufferWriter.putByte((byte)2);
            }
            byteBufferWriter.putShort(this.killer.getOnlineID());
        }
    }

    @Override
    public String getDescription() {
        String string = this.getDeathDescription() + "\n\t";
        if (this.character != null) {
            string = string + " isDead=" + this.character.isDead();
            string = string + " isOnDeathDone=" + this.character.isOnDeathDone();
            string = string + " isOnKillDone=" + this.character.isOnKillDone();
            string = string + " | health=" + this.character.getHealth();
            if (this.character.getBodyDamage() != null) {
                string = string + " | bodyDamage=" + this.character.getBodyDamage().getOverallBodyHealth();
            }
            string = string + " | states=( " + this.character.getPreviousActionContextStateName() + " > " + this.character.getCurrentActionContextStateName() + " )";
        }
        return string;
    }

    public String getDeathDescription() {
        return this.getClass().getSimpleName() + " id(" + this.id + ") | killer=" + (String)(this.killer == null ? "Null" : this.killer.getClass().getSimpleName() + "(" + this.killer.getOnlineID() + ")") + " | pos=(x=" + this.x + ",y=" + this.y + ",z=" + this.z + ";a=" + this.angle + ") | dir=" + this.direction.name() + " | isFallOnFront=" + ((this.characterFlags & 1) != 0);
    }

    @Override
    public boolean isConsistent() {
        return this.character != null;
    }
}

