/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.chat;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import zombie.GameWindow;
import zombie.characters.Faction;
import zombie.characters.IsoPlayer;
import zombie.chat.ChatBase;
import zombie.chat.ChatMessage;
import zombie.chat.ChatTab;
import zombie.chat.ChatUtility;
import zombie.chat.ServerChatMessage;
import zombie.chat.defaultChats.AdminChat;
import zombie.chat.defaultChats.FactionChat;
import zombie.chat.defaultChats.GeneralChat;
import zombie.chat.defaultChats.RadioChat;
import zombie.chat.defaultChats.SafehouseChat;
import zombie.chat.defaultChats.SayChat;
import zombie.chat.defaultChats.ServerChat;
import zombie.chat.defaultChats.ShoutChat;
import zombie.chat.defaultChats.WhisperChat;
import zombie.core.Core;
import zombie.core.logger.LoggerManager;
import zombie.core.logger.ZLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.areas.SafeHouse;
import zombie.network.PacketTypes;
import zombie.network.ServerOptions;
import zombie.network.chat.ChatType;

public class ChatServer {
    private static ChatServer instance = null;
    private static final Stack<Integer> availableChatsID;
    private static int lastChatId;
    private static final HashMap<ChatType, ChatBase> defaultChats;
    private static final ConcurrentHashMap<Integer, ChatBase> chats;
    private static final ConcurrentHashMap<String, FactionChat> factionChats;
    private static final ConcurrentHashMap<String, SafehouseChat> safehouseChats;
    private static AdminChat adminChat;
    private static GeneralChat generalChat;
    private static ServerChat serverChat;
    private static RadioChat radioChat;
    private static boolean inited;
    private static final HashSet<Short> players;
    private static final String logName = "chat";
    private static ZLogger logger;
    private static final HashMap<String, ChatTab> tabs;
    private static final String mainTabID = "main";
    private static final String adminTabID = "admin";

    public static ChatServer getInstance() {
        if (instance == null) {
            instance = new ChatServer();
        }
        return instance;
    }

    public static boolean isInited() {
        return inited;
    }

    private ChatServer() {
    }

    public void init() {
        if (inited) {
            return;
        }
        LoggerManager.createLogger(logName, Core.bDebug);
        logger = LoggerManager.getLogger(logName);
        logger.write("Start chat server initialization...", "info");
        ChatTab chatTab = new ChatTab(0, "UI_chat_main_tab_title_id");
        ChatTab chatTab2 = new ChatTab(1, "UI_chat_admin_tab_title_id");
        boolean bl = ServerOptions.getInstance().DiscordEnable.getValue();
        GeneralChat generalChat = new GeneralChat(this.getNextChatID(), chatTab, bl);
        SayChat sayChat = new SayChat(this.getNextChatID(), chatTab);
        ShoutChat shoutChat = new ShoutChat(this.getNextChatID(), chatTab);
        RadioChat radioChat = new RadioChat(this.getNextChatID(), chatTab);
        AdminChat adminChat = new AdminChat(this.getNextChatID(), chatTab2);
        ServerChat serverChat = new ServerChat(this.getNextChatID(), chatTab);
        chats.put(generalChat.getID(), generalChat);
        chats.put(sayChat.getID(), sayChat);
        chats.put(shoutChat.getID(), shoutChat);
        chats.put(radioChat.getID(), radioChat);
        chats.put(adminChat.getID(), adminChat);
        chats.put(serverChat.getID(), serverChat);
        defaultChats.put(generalChat.getType(), generalChat);
        defaultChats.put(sayChat.getType(), sayChat);
        defaultChats.put(shoutChat.getType(), shoutChat);
        defaultChats.put(serverChat.getType(), serverChat);
        defaultChats.put(radioChat.getType(), radioChat);
        tabs.put(mainTabID, chatTab);
        tabs.put(adminTabID, chatTab2);
        ChatServer.generalChat = generalChat;
        ChatServer.adminChat = adminChat;
        ChatServer.serverChat = serverChat;
        ChatServer.radioChat = radioChat;
        inited = true;
        logger.write("General chat has id = " + generalChat.getID(), "info");
        logger.write("Say chat has id = " + sayChat.getID(), "info");
        logger.write("Shout chat has id = " + shoutChat.getID(), "info");
        logger.write("Radio chat has id = " + radioChat.getID(), "info");
        logger.write("Admin chat has id = " + adminChat.getID(), "info");
        logger.write("Server chat has id = " + ChatServer.serverChat.getID(), "info");
        logger.write("Chat server successfully initialized", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPlayer(short s) {
        SafeHouse safeHouse;
        Faction faction;
        logger.write("Player with id = '" + s + "' tries to connect", "info");
        Serializable serializable = players;
        synchronized (serializable) {
            if (players.contains(s)) {
                logger.write("Player already connected!", "warning");
                return;
            }
        }
        logger.write("Adding player '" + s + "' to chat server", "info");
        serializable = ChatUtility.findPlayer(s);
        UdpConnection udpConnection = ChatUtility.findConnection(s);
        if (udpConnection == null || serializable == null) {
            logger.write("Player or connection is not found on server!", "error");
            logger.write((udpConnection == null ? "connection = null " : "") + (serializable == null ? "player = null" : ""), "error");
            return;
        }
        this.sendInitPlayerChatPacket(udpConnection);
        this.addDefaultChats(s);
        logger.write("Player joined to default chats", "info");
        if (udpConnection.accessLevel == 32) {
            this.joinAdminChat(s);
        }
        if ((faction = Faction.getPlayerFaction(serializable)) != null) {
            this.addMemberToFactionChat(faction.getName(), s);
        }
        if ((safeHouse = SafeHouse.hasSafehouse(serializable)) != null) {
            this.addMemberToSafehouseChat(safeHouse.getId(), s);
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.PlayerConnectedToChat.doPacket(byteBufferWriter);
        PacketTypes.PacketType.PlayerConnectedToChat.send(udpConnection);
        HashSet<Short> hashSet = players;
        synchronized (hashSet) {
            players.add(s);
        }
        logger.write("Player " + ((IsoPlayer)serializable).getUsername() + "(" + s + ") joined to chat server successfully", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageFromPlayerPacket(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        ConcurrentHashMap<Integer, ChatBase> concurrentHashMap = chats;
        synchronized (concurrentHashMap) {
            ChatBase chatBase = chats.get(n);
            ChatMessage chatMessage = chatBase.unpackMessage(byteBuffer);
            logger.write("Got message:" + chatMessage, "info");
            if (!ChatUtility.chatStreamEnabled(chatBase.getType())) {
                logger.write("Message ignored by server because the chat disabled by server settings", "warning");
                return;
            }
            this.sendMessage(chatMessage);
            logger.write("Message " + chatMessage + " sent to chat (id = " + chatBase.getID() + ") members", "info");
        }
    }

    public void processPlayerStartWhisperChatPacket(ByteBuffer byteBuffer) {
        logger.write("Whisper chat starting...", "info");
        if (!ChatUtility.chatStreamEnabled(ChatType.whisper)) {
            logger.write("Message for whisper chat is ignored because whisper chat is disabled by server settings", "info");
            return;
        }
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        logger.write("Player '" + string + "' attempt to start whispering with '" + string2 + "'", "info");
        IsoPlayer isoPlayer = ChatUtility.findPlayer(string);
        IsoPlayer isoPlayer2 = ChatUtility.findPlayer(string2);
        if (isoPlayer == null) {
            logger.write("Player '" + string + "' is not found!", "error");
            throw new RuntimeException("Player not found");
        }
        if (isoPlayer2 == null) {
            logger.write("Player '" + string + "' attempt to start whisper dialog with '" + string2 + "' but this player not found!", "info");
            UdpConnection udpConnection = ChatUtility.findConnection(isoPlayer.getOnlineID());
            this.sendPlayerNotFoundMessage(udpConnection, string2);
            return;
        }
        logger.write("Both players found", "info");
        WhisperChat whisperChat = new WhisperChat(this.getNextChatID(), tabs.get(mainTabID), string, string2);
        whisperChat.addMember(isoPlayer.getOnlineID());
        whisperChat.addMember(isoPlayer2.getOnlineID());
        chats.put(whisperChat.getID(), whisperChat);
        logger.write("Whisper chat (id = " + whisperChat.getID() + ") between '" + isoPlayer.getUsername() + "' and '" + isoPlayer2.getUsername() + "' started", "info");
    }

    private void sendPlayerNotFoundMessage(UdpConnection udpConnection, String string) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.PlayerNotFound.doPacket(byteBufferWriter);
        byteBufferWriter.putUTF(string);
        PacketTypes.PacketType.PlayerNotFound.send(udpConnection);
        logger.write("'Player not found' packet was sent", "info");
    }

    public ChatMessage unpackChatMessage(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        return chats.get(n).unpackMessage(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectPlayer(short s) {
        logger.write("Player " + s + " disconnecting...", "info");
        Serializable serializable = chats;
        synchronized (serializable) {
            for (ChatBase chatBase : chats.values()) {
                chatBase.removeMember(s);
                if (chatBase.getType() != ChatType.whisper) continue;
                this.closeChat(chatBase.getID());
            }
        }
        serializable = players;
        synchronized (serializable) {
            players.remove(s);
        }
        logger.write("Disconnecting player " + s + " finished", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChat(int n) {
        Serializable serializable = chats;
        synchronized (serializable) {
            if (!chats.containsKey(n)) {
                throw new RuntimeException("Chat '" + n + "' requested to close but it's not exists.");
            }
            ChatBase chatBase = chats.get(n);
            chatBase.close();
            chats.remove(n);
        }
        serializable = availableChatsID;
        synchronized (serializable) {
            availableChatsID.push(n);
        }
    }

    public void joinAdminChat(short s) {
        if (adminChat == null) {
            logger.write("Admin chat is null! Can't add player to it", "warning");
            return;
        }
        adminChat.addMember(s);
        logger.write("Player joined admin chat", "info");
    }

    public void leaveAdminChat(short s) {
        logger.write("Player " + s + " are leaving admin chat...", "info");
        UdpConnection udpConnection = ChatUtility.findConnection(s);
        if (adminChat == null) {
            logger.write("Admin chat is null. Can't leave it! ChatServer", "warning");
            return;
        }
        if (udpConnection == null) {
            logger.write("Connection to player is null. Can't leave admin chat! ChatServer.leaveAdminChat", "warning");
            return;
        }
        adminChat.leaveMember(s);
        tabs.get(adminTabID).sendRemoveTabPacket(udpConnection);
        logger.write("Player " + s + " leaved admin chat", "info");
    }

    public FactionChat createFactionChat(String string) {
        logger.write("Creating faction chat '" + string + "'", "info");
        if (factionChats.containsKey(string)) {
            logger.write("Faction chat '" + string + "' already exists!", "warning");
            return factionChats.get(string);
        }
        FactionChat factionChat = new FactionChat(this.getNextChatID(), tabs.get(mainTabID));
        chats.put(factionChat.getID(), factionChat);
        factionChats.put(string, factionChat);
        logger.write("Faction chat '" + string + "' created", "info");
        return factionChat;
    }

    public SafehouseChat createSafehouseChat(String string) {
        logger.write("Creating safehouse chat '" + string + "'", "info");
        if (safehouseChats.containsKey(string)) {
            logger.write("Safehouse chat already has chat with name '" + string + "'", "warning");
            return safehouseChats.get(string);
        }
        SafehouseChat safehouseChat = new SafehouseChat(this.getNextChatID(), tabs.get(mainTabID));
        chats.put(safehouseChat.getID(), safehouseChat);
        safehouseChats.put(string, safehouseChat);
        logger.write("Safehouse chat '" + string + "' created", "info");
        return safehouseChat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFactionChat(String string) {
        int n;
        logger.write("Removing faction chat '" + string + "'...", "info");
        ConcurrentHashMap<String, FactionChat> concurrentHashMap = factionChats;
        synchronized (concurrentHashMap) {
            if (!factionChats.containsKey(string)) {
                String string2 = "Faction chat '" + string + "' tried to delete but it's not exists.";
                logger.write(string2, "error");
                RuntimeException runtimeException = new RuntimeException(string2);
                logger.write(runtimeException);
                throw runtimeException;
            }
            FactionChat factionChat = factionChats.get(string);
            n = factionChat.getID();
            factionChats.remove(string);
        }
        this.closeChat(n);
        logger.write("Faction chat '" + string + "' removed", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSafehouseChat(String string) {
        int n;
        logger.write("Removing safehouse chat '" + string + "'...", "info");
        ConcurrentHashMap<String, SafehouseChat> concurrentHashMap = safehouseChats;
        synchronized (concurrentHashMap) {
            if (!safehouseChats.containsKey(string)) {
                String string2 = "Safehouse chat '" + string + "' tried to delete but it's not exists.";
                logger.write(string2, "error");
                RuntimeException runtimeException = new RuntimeException(string2);
                logger.write(runtimeException);
                throw runtimeException;
            }
            SafehouseChat safehouseChat = safehouseChats.get(string);
            n = safehouseChat.getID();
            safehouseChats.remove(string);
        }
        this.closeChat(n);
        logger.write("Safehouse chat '" + string + "' removed", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFactionChatMembers(String string, String string2, ArrayList<String> arrayList) {
        logger.write("Start syncing faction chat '" + string + "'...", "info");
        if (string == null || string2 == null || arrayList == null) {
            logger.write("Faction name or faction owner or players is null", "warning");
            return;
        }
        ConcurrentHashMap<String, FactionChat> concurrentHashMap = factionChats;
        synchronized (concurrentHashMap) {
            if (!factionChats.containsKey(string)) {
                logger.write("Faction chat '" + string + "' is not exist", "warning");
                return;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
            arrayList2.add(string2);
            FactionChat factionChat = factionChats.get(string);
            factionChat.syncMembersByUsernames(arrayList2);
            StringBuilder stringBuilder = new StringBuilder("These members were added: ");
            for (short s : factionChat.getJustAddedMembers()) {
                stringBuilder.append("'").append(ChatUtility.findPlayerName(s)).append("', ");
            }
            stringBuilder.append(". These members were removed: ");
            for (short s : factionChat.getJustRemovedMembers()) {
                stringBuilder.append("'").append(ChatUtility.findPlayerName(s)).append("', ");
            }
            logger.write(stringBuilder.toString(), "info");
        }
        logger.write("Syncing faction chat '" + string + "' finished", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncSafehouseChatMembers(String string, String string2, ArrayList<String> arrayList) {
        logger.write("Start syncing safehouse chat '" + string + "'...", "info");
        if (string == null || string2 == null || arrayList == null) {
            logger.write("Safehouse name or Safehouse owner or players is null", "warning");
            return;
        }
        ConcurrentHashMap<String, SafehouseChat> concurrentHashMap = safehouseChats;
        synchronized (concurrentHashMap) {
            if (!safehouseChats.containsKey(string)) {
                logger.write("Safehouse chat '" + string + "' is not exist", "warning");
                return;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
            arrayList2.add(string2);
            SafehouseChat safehouseChat = safehouseChats.get(string);
            safehouseChat.syncMembersByUsernames(arrayList2);
            StringBuilder stringBuilder = new StringBuilder("These members were added: ");
            for (short s : safehouseChat.getJustAddedMembers()) {
                stringBuilder.append("'").append(ChatUtility.findPlayerName(s)).append("', ");
            }
            stringBuilder.append("These members were removed: ");
            for (short s : safehouseChat.getJustRemovedMembers()) {
                stringBuilder.append("'").append(ChatUtility.findPlayerName(s)).append("', ");
            }
            logger.write(stringBuilder.toString(), "info");
        }
        logger.write("Syncing safehouse chat '" + string + "' finished", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberToSafehouseChat(String string, short s) {
        if (!safehouseChats.containsKey(string)) {
            logger.write("Safehouse chat is not initialized!", "warning");
            return;
        }
        ConcurrentHashMap<String, SafehouseChat> concurrentHashMap = safehouseChats;
        synchronized (concurrentHashMap) {
            SafehouseChat safehouseChat = safehouseChats.get(string);
            safehouseChat.addMember(s);
        }
        logger.write("Player joined to chat of safehouse '" + string + "'", "info");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberToFactionChat(String string, short s) {
        if (!factionChats.containsKey(string)) {
            logger.write("Faction chat is not initialized!", "warning");
            return;
        }
        ConcurrentHashMap<String, FactionChat> concurrentHashMap = factionChats;
        synchronized (concurrentHashMap) {
            FactionChat factionChat = factionChats.get(string);
            factionChat.addMember(s);
        }
        logger.write("Player joined to chat of faction '" + string + "'", "info");
    }

    public void sendServerAlertMessageToServerChat(String string, String string2) {
        serverChat.sendMessageToChatMembers(serverChat.createMessage(string, string2, true));
        logger.write("Server alert message: '" + string2 + "' by '" + string + "' sent.");
    }

    public void sendServerAlertMessageToServerChat(String string) {
        serverChat.sendMessageToChatMembers(serverChat.createServerMessage(string, true));
        logger.write("Server alert message: '" + string + "' sent.");
    }

    public ChatMessage createRadiostationMessage(String string, int n) {
        return radioChat.createBroadcastingMessage(string, n);
    }

    public void sendMessageToServerChat(UdpConnection udpConnection, String string) {
        ServerChatMessage serverChatMessage = serverChat.createServerMessage(string, false);
        serverChat.sendMessageToPlayer(udpConnection, (ChatMessage)serverChatMessage);
    }

    public void sendMessageToServerChat(String string) {
        ServerChatMessage serverChatMessage = serverChat.createServerMessage(string, false);
        serverChat.sendMessageToChatMembers(serverChatMessage);
    }

    public void sendMessageFromDiscordToGeneralChat(String string, String string2) {
        if (string != null && string2 != null) {
            logger.write("Got message '" + string2 + "' by author '" + string + "' from discord");
        }
        ChatMessage chatMessage = generalChat.createMessage(string2);
        chatMessage.makeFromDiscord();
        chatMessage.setAuthor(string);
        if (ChatUtility.chatStreamEnabled(ChatType.general)) {
            this.sendMessage(chatMessage);
            logger.write("Message '" + string2 + "' send from discord to general chat members");
        } else {
            generalChat.sendToDiscordGeneralChatDisabled();
            logger.write("General chat disabled so error message sent to discord", "warning");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextChatID() {
        Stack<Integer> stack = availableChatsID;
        synchronized (stack) {
            if (availableChatsID.isEmpty()) {
                availableChatsID.push(++lastChatId);
            }
            return availableChatsID.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(ChatMessage chatMessage) {
        ConcurrentHashMap<Integer, ChatBase> concurrentHashMap = chats;
        synchronized (concurrentHashMap) {
            if (!chats.containsKey(chatMessage.getChatID())) {
                return;
            }
            ChatBase chatBase = chats.get(chatMessage.getChatID());
            chatBase.sendMessageToChatMembers(chatMessage);
        }
    }

    private void sendInitPlayerChatPacket(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.InitPlayerChat.doPacket(byteBufferWriter);
        byteBufferWriter.putShort((short)tabs.size());
        for (ChatTab chatTab : tabs.values()) {
            byteBufferWriter.putShort(chatTab.getID());
            byteBufferWriter.putUTF(chatTab.getTitleID());
        }
        PacketTypes.PacketType.InitPlayerChat.send(udpConnection);
    }

    private void addDefaultChats(short s) {
        for (Map.Entry<ChatType, ChatBase> entry : defaultChats.entrySet()) {
            ChatBase chatBase = entry.getValue();
            chatBase.addMember(s);
        }
    }

    public void sendMessageToAdminChat(String string) {
        ServerChatMessage serverChatMessage = adminChat.createServerMessage(string);
        adminChat.sendMessageToChatMembers(serverChatMessage);
    }

    static {
        lastChatId = -1;
        adminChat = null;
        generalChat = null;
        serverChat = null;
        radioChat = null;
        inited = false;
        availableChatsID = new Stack();
        defaultChats = new HashMap();
        chats = new ConcurrentHashMap();
        factionChats = new ConcurrentHashMap();
        safehouseChats = new ConcurrentHashMap();
        tabs = new HashMap();
        players = new HashSet();
    }
}

