/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import se.krka.kahlua.vm.LuaClosure;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.debug.DebugLog;

public class SpawnRegions {
    private Region parseRegionTable(KahluaTable kahluaTable) {
        Object object = kahluaTable.rawget("name");
        Object object2 = kahluaTable.rawget("file");
        Object object3 = kahluaTable.rawget("serverfile");
        if (object instanceof String && object2 instanceof String) {
            Region region = new Region();
            region.name = (String)object;
            region.file = (String)object2;
            return region;
        }
        if (object instanceof String && object3 instanceof String) {
            Region region = new Region();
            region.name = (String)object;
            region.serverfile = (String)object3;
            return region;
        }
        return null;
    }

    private ArrayList<Profession> parseProfessionsTable(KahluaTable kahluaTable) {
        ArrayList<Profession> arrayList = null;
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            ArrayList<Point> arrayList2;
            Object object = kahluaTableIterator.getKey();
            Object object2 = kahluaTableIterator.getValue();
            if (!(object instanceof String) || !(object2 instanceof KahluaTable) || (arrayList2 = this.parsePointsTable((KahluaTable)object2)) == null) continue;
            Profession profession = new Profession();
            profession.name = (String)object;
            profession.points = arrayList2;
            if (arrayList == null) {
                arrayList = new ArrayList<Profession>();
            }
            arrayList.add(profession);
        }
        return arrayList;
    }

    private ArrayList<Point> parsePointsTable(KahluaTable kahluaTable) {
        ArrayList<Point> arrayList = null;
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            Point point;
            Object object = kahluaTableIterator.getValue();
            if (!(object instanceof KahluaTable) || (point = this.parsePointTable((KahluaTable)object)) == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Point>();
            }
            arrayList.add(point);
        }
        return arrayList;
    }

    private Point parsePointTable(KahluaTable kahluaTable) {
        Object object = kahluaTable.rawget("worldX");
        Object object2 = kahluaTable.rawget("worldY");
        Object object3 = kahluaTable.rawget("posX");
        Object object4 = kahluaTable.rawget("posY");
        Object object5 = kahluaTable.rawget("posZ");
        if (object instanceof Double && object2 instanceof Double && object3 instanceof Double && object4 instanceof Double) {
            Point point = new Point();
            point.worldX = ((Double)object).intValue();
            point.worldY = ((Double)object2).intValue();
            point.posX = ((Double)object3).intValue();
            point.posY = ((Double)object4).intValue();
            point.posZ = object5 instanceof Double ? ((Double)object5).intValue() : 0;
            return point;
        }
        return null;
    }

    public ArrayList<Region> loadRegionsFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        try {
            Object[] objectArray;
            LuaManager.env.rawset("SpawnRegions", null);
            LuaManager.loaded.remove(file.getAbsolutePath().replace("\\", "/"));
            LuaManager.RunLua(file.getAbsolutePath());
            Object object = LuaManager.env.rawget("SpawnRegions");
            if (object instanceof LuaClosure && (objectArray = LuaManager.caller.pcall(LuaManager.thread, object, new Object[0])).length > 1 && objectArray[1] instanceof KahluaTable) {
                ArrayList<Region> arrayList = new ArrayList<Region>();
                KahluaTableIterator kahluaTableIterator = ((KahluaTable)objectArray[1]).iterator();
                while (kahluaTableIterator.advance()) {
                    Region region;
                    Object object2 = kahluaTableIterator.getValue();
                    if (!(object2 instanceof KahluaTable) || (region = this.parseRegionTable((KahluaTable)object2)) == null) continue;
                    arrayList.add(region);
                }
                return arrayList;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String fmtKey(String object) {
        if (((String)object).contains("\\")) {
            object = ((String)object).replace("\\", "\\\\");
        }
        if (((String)object).contains("\"")) {
            object = ((String)object).replace("\"", "\\\"");
        }
        if (((String)object).contains(" ") || ((String)object).contains("\\")) {
            object = "\"" + (String)object + "\"";
        }
        if (((String)object).startsWith("\"")) {
            return "[" + (String)object + "]";
        }
        return object;
    }

    private String fmtValue(String string) {
        if (string.contains("\\")) {
            string = string.replace("\\", "\\\\");
        }
        if (string.contains("\"")) {
            string = string.replace("\"", "\\\"");
        }
        return "\"" + string + "\"";
    }

    public boolean saveRegionsFile(String string, ArrayList<Region> arrayList) {
        boolean bl;
        File file = new File(string);
        DebugLog.log("writing " + string);
        FileWriter fileWriter = new FileWriter(file);
        try {
            String string2 = System.lineSeparator();
            fileWriter.write("function SpawnRegions()" + string2);
            fileWriter.write("\treturn {" + string2);
            for (Region region : arrayList) {
                if (region.file != null) {
                    fileWriter.write("\t\t{ name = " + this.fmtValue(region.name) + ", file = " + this.fmtValue(region.file) + " }," + string2);
                    continue;
                }
                if (region.serverfile != null) {
                    fileWriter.write("\t\t{ name = " + this.fmtValue(region.name) + ", serverfile = " + this.fmtValue(region.serverfile) + " }," + string2);
                    continue;
                }
                if (region.professions == null) continue;
                fileWriter.write("\t\t{ name = " + this.fmtValue(region.name) + "," + string2);
                fileWriter.write("\t\t\tpoints = {" + string2);
                for (Profession profession : region.professions) {
                    fileWriter.write("\t\t\t\t" + this.fmtKey(profession.name) + " = {" + string2);
                    for (Point point : profession.points) {
                        fileWriter.write("\t\t\t\t\t{ worldX = " + point.worldX + ", worldY = " + point.worldY + ", posX = " + point.posX + ", posY = " + point.posY + ", posZ = " + point.posZ + " }," + string2);
                    }
                    fileWriter.write("\t\t\t\t}," + string2);
                }
                fileWriter.write("\t\t\t}" + string2);
                fileWriter.write("\t\t}," + string2);
            }
            fileWriter.write("\t}" + string2);
            fileWriter.write("end" + System.lineSeparator());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        fileWriter.close();
        return bl;
    }

    public ArrayList<Profession> loadPointsFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        try {
            Object[] objectArray;
            LuaManager.env.rawset("SpawnPoints", null);
            LuaManager.loaded.remove(file.getAbsolutePath().replace("\\", "/"));
            LuaManager.RunLua(file.getAbsolutePath());
            Object object = LuaManager.env.rawget("SpawnPoints");
            if (object instanceof LuaClosure && (objectArray = LuaManager.caller.pcall(LuaManager.thread, object, new Object[0])).length > 1 && objectArray[1] instanceof KahluaTable) {
                ArrayList<Profession> arrayList = this.parseProfessionsTable((KahluaTable)objectArray[1]);
                return arrayList;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean savePointsFile(String string, ArrayList<Profession> arrayList) {
        boolean bl;
        File file = new File(string);
        DebugLog.log("writing " + string);
        FileWriter fileWriter = new FileWriter(file);
        try {
            String string2 = System.lineSeparator();
            fileWriter.write("function SpawnPoints()" + string2);
            fileWriter.write("\treturn {" + string2);
            for (Profession profession : arrayList) {
                fileWriter.write("\t\t" + this.fmtKey(profession.name) + " = {" + string2);
                for (Point point : profession.points) {
                    fileWriter.write("\t\t\t{ worldX = " + point.worldX + ", worldY = " + point.worldY + ", posX = " + point.posX + ", posY = " + point.posY + ", posZ = " + point.posZ + " }," + string2);
                }
                fileWriter.write("\t\t}," + string2);
            }
            fileWriter.write("\t}" + string2);
            fileWriter.write("end" + System.lineSeparator());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        fileWriter.close();
        return bl;
    }

    public KahluaTable loadPointsTable(String string) {
        ArrayList<Profession> arrayList = this.loadPointsFile(string);
        if (arrayList == null) {
            return null;
        }
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        for (int i = 0; i < arrayList.size(); ++i) {
            Profession profession = arrayList.get(i);
            KahluaTable kahluaTable2 = LuaManager.platform.newTable();
            for (int j = 0; j < profession.points.size(); ++j) {
                Point point = profession.points.get(j);
                KahluaTable kahluaTable3 = LuaManager.platform.newTable();
                kahluaTable3.rawset("worldX", (Object)point.worldX);
                kahluaTable3.rawset("worldY", (Object)point.worldY);
                kahluaTable3.rawset("posX", (Object)point.posX);
                kahluaTable3.rawset("posY", (Object)point.posY);
                kahluaTable3.rawset("posZ", (Object)point.posZ);
                kahluaTable2.rawset(j + 1, (Object)kahluaTable3);
            }
            kahluaTable.rawset(profession.name, (Object)kahluaTable2);
        }
        return kahluaTable;
    }

    public boolean savePointsTable(String string, KahluaTable kahluaTable) {
        ArrayList<Profession> arrayList = this.parseProfessionsTable(kahluaTable);
        if (arrayList != null) {
            return this.savePointsFile(string, arrayList);
        }
        return false;
    }

    public ArrayList<Region> getDefaultServerRegions() {
        ArrayList<Region> arrayList = new ArrayList<Region>();
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) throws IOException {
                return Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("spawnpoints.lua"), new LinkOption[0]);
            }
        };
        String string = ZomboidFileSystem.instance.getMediaPath("maps");
        Path path = FileSystems.getDefault().getPath(string, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return arrayList;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path2 : directoryStream) {
                Region region = new Region();
                region.name = path2.getFileName().toString();
                region.file = "media/maps/" + region.name + "/spawnpoints.lua";
                arrayList.add(region);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList<Profession> getDefaultServerPoints() {
        ArrayList<Profession> arrayList = new ArrayList<Profession>();
        Profession profession = new Profession();
        profession.name = "unemployed";
        profession.points = new ArrayList();
        arrayList.add(profession);
        Point point = new Point();
        point.worldX = 40;
        point.worldY = 22;
        point.posX = 67;
        point.posY = 201;
        point.posZ = 0;
        profession.points.add(point);
        return arrayList;
    }

    public static class Region {
        public String name;
        public String file;
        public String serverfile;
        public ArrayList<Profession> professions;
    }

    public static class Profession {
        public String name;
        public ArrayList<Point> points;
    }

    public static class Point {
        public int worldX;
        public int worldY;
        public int posX;
        public int posY;
        public int posZ;
    }
}

