/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.secure.PZcrypt;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.network.DBResult;
import zombie.network.DBSchema;
import zombie.network.DBTicket;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.Userlog;
import zombie.util.PZSQLUtils;

public class ServerWorldDatabase {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static ServerWorldDatabase instance = new ServerWorldDatabase();
    public String CommandLineAdminUsername = "admin";
    public String CommandLineAdminPassword;
    public boolean doAdmin = true;
    public DBSchema dbSchema = null;
    static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
    Connection conn;
    private static final String nullChar = String.valueOf('\u0000');

    public DBSchema getDBSchema() {
        if (this.dbSchema == null) {
            this.dbSchema = new DBSchema(this.conn);
        }
        return this.dbSchema;
    }

    public void executeQuery(String string, KahluaTable kahluaTable) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        int n = 1;
        while (kahluaTableIterator.advance()) {
            preparedStatement.setString(n++, (String)kahluaTableIterator.getValue());
        }
        preparedStatement.executeUpdate();
    }

    public ArrayList<DBResult> getTableResult(String string) throws SQLException {
        ArrayList<DBResult> arrayList = new ArrayList<DBResult>();
        String string2 = "SELECT * FROM " + string;
        if ("userlog".equals(string)) {
            string2 = string2 + " ORDER BY lastUpdate DESC";
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet2 = databaseMetaData.getColumns(null, null, string, null);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        DBResult dBResult = new DBResult();
        while (resultSet2.next()) {
            String string3 = resultSet2.getString(4);
            if (string3.equals("world") || string3.equals("moderator") || string3.equals("admin") || string3.equals("password") || string3.equals("encryptedPwd") || string3.equals("pwdEncryptType") || string3.equals("transactionID")) continue;
            arrayList2.add(string3);
        }
        dBResult.setColumns(arrayList2);
        dBResult.setTableName(string);
        while (resultSet.next()) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string4 = arrayList2.get(i);
                String string5 = resultSet.getString(string4);
                if ("'false'".equals(string5)) {
                    string5 = "false";
                }
                if ("'true'".equals(string5)) {
                    string5 = "true";
                }
                if (string5 == null) {
                    string5 = "";
                }
                dBResult.getValues().put(string4, string5);
            }
            arrayList.add(dBResult);
            dBResult = new DBResult();
            dBResult.setColumns(arrayList2);
            dBResult.setTableName(string);
        }
        preparedStatement.close();
        return arrayList;
    }

    public void saveAllTransactionsID(HashMap<String, Integer> hashMap) {
        try {
            Iterator<String> iterator = hashMap.keySet().iterator();
            PreparedStatement preparedStatement = null;
            while (iterator.hasNext()) {
                String string = iterator.next();
                Integer n = hashMap.get(string);
                preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET transactionID = ? WHERE username = ?");
                preparedStatement.setString(1, n.toString());
                preparedStatement.setString(2, string);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveTransactionID(String string, Integer n) {
        try {
            if (!this.containsUser(string)) {
                this.addUser(string, "");
            }
            PreparedStatement preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET transactionID = ? WHERE username = ?");
            preparedStatement.setString(1, n.toString());
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean containsUser(String string) {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, Core.GameSaveWorld);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                preparedStatement.close();
                return true;
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public boolean containsCaseinsensitiveUser(String string) {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE LOWER(username) = LOWER(?) AND world = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, Core.GameSaveWorld);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                preparedStatement.close();
                return true;
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public String changeUsername(String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, Core.GameSaveWorld);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            String string3 = resultSet.getString("id");
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET username = ? WHERE id = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            return "Changed " + string + " user's name into " + string2;
        }
        if (!ServerOptions.instance.getBoolean("Open").booleanValue()) {
            return "User \"" + string + "\" is not in the whitelist, use /adduser first";
        }
        return "Changed's name " + string + " into " + string2;
    }

    public String addUser(String string, String string2) throws SQLException {
        if (this.containsCaseinsensitiveUser(string)) {
            return "A user with this name already exists";
        }
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, Core.GameSaveWorld);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                preparedStatement.close();
                return "User " + string + " already exist.";
            }
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement("INSERT INTO whitelist (world, username, password, encryptedPwd, pwdEncryptType) VALUES (?, ?, ?, 'true', '2')");
            preparedStatement.setString(1, Core.GameSaveWorld);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return "User " + string + " created with the password " + string2;
    }

    public void updateDisplayName(String string, String string2) {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, Core.GameSaveWorld);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                preparedStatement.close();
                preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET displayName = ? WHERE username = ?");
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public String getDisplayName(String string) {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, Core.GameSaveWorld);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString("displayName");
                preparedStatement.close();
                return string2;
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public String removeUser(String string) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("DELETE FROM whitelist WHERE world = ? and username = ?");
            preparedStatement.setString(1, Core.GameSaveWorld);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return "User " + string + " removed from white list";
    }

    public void removeUserLog(String string, String string2, String string3) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("DELETE FROM userlog WHERE username = ? AND type = ? AND text = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void create() throws SQLException, ClassNotFoundException {
        AutoCloseable autoCloseable;
        Object object;
        PreparedStatement preparedStatement;
        Wrapper wrapper;
        File file = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "db");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "db" + File.separator + GameServer.ServerName + ".db");
        file2.setReadable(true, false);
        file2.setExecutable(true, false);
        file2.setWritable(true, false);
        DebugLog.log("user database \"" + file2.getPath() + "\"");
        if (!file2.exists()) {
            try {
                file2.createNewFile();
                this.conn = PZSQLUtils.getConnection(file2.getAbsolutePath());
                wrapper = this.conn.createStatement();
                wrapper.executeUpdate("CREATE TABLE [whitelist] ([id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL,[world] TEXT DEFAULT '" + GameServer.ServerName + "' NULL,[username] TEXT  NULL,[password] TEXT  NULL, [admin] BOOLEAN DEFAULT false NULL, [moderator] BOOLEAN DEFAULT false NULL, [banned] BOOLEAN DEFAULT false NULL, [priority] BOOLEAN DEFAULT false NULL,  [lastConnection] TEXT NULL)");
                wrapper.executeUpdate("CREATE UNIQUE INDEX [id] ON [whitelist]([id]  ASC)");
                wrapper.executeUpdate("CREATE UNIQUE INDEX [username] ON [whitelist]([username]  ASC)");
                wrapper.executeUpdate("CREATE TABLE [bannedip] ([ip] TEXT NOT NULL,[username] TEXT NULL, [reason] TEXT NULL)");
                wrapper.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DebugLog.log("failed to create user database, server shut down");
                System.exit(1);
            }
        }
        if (this.conn == null) {
            try {
                this.conn = PZSQLUtils.getConnection(file2.getAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DebugLog.log("failed to open user database, server shut down");
                System.exit(1);
            }
        }
        wrapper = this.conn.getMetaData();
        ResultSet resultSet = wrapper.getColumns(null, null, "whitelist", "admin");
        Statement statement = this.conn.createStatement();
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'admin' BOOLEAN NULL DEFAULT false");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "moderator");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'moderator' BOOLEAN NULL DEFAULT false");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "banned");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'banned' BOOLEAN NULL DEFAULT false");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "priority");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'priority' BOOLEAN NULL DEFAULT false");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "lastConnection");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'lastConnection' TEXT NULL");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "encryptedPwd");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'encryptedPwd' BOOLEAN NULL DEFAULT false");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "pwdEncryptType");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'pwdEncryptType' INTEGER NULL DEFAULT 1");
        }
        resultSet.close();
        if (SteamUtils.isSteamModeEnabled()) {
            resultSet = wrapper.getColumns(null, null, "whitelist", "steamid");
            if (!resultSet.next()) {
                statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'steamid' TEXT NULL");
            }
            resultSet.close();
            resultSet = wrapper.getColumns(null, null, "whitelist", "ownerid");
            if (!resultSet.next()) {
                statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'ownerid' TEXT NULL");
            }
            resultSet.close();
        }
        if (!(resultSet = wrapper.getColumns(null, null, "whitelist", "accesslevel")).next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'accesslevel' TEXT NULL");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "transactionID");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'transactionID' INTEGER NULL");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "displayName");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'whitelist' ADD 'displayName' TEXT NULL");
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM sqlite_master WHERE type = 'index' AND sql LIKE '%UNIQUE%' and name = 'username'");
        if (!resultSet.next()) {
            try {
                statement.executeUpdate("CREATE UNIQUE INDEX [username] ON [whitelist]([username]  ASC)");
            }
            catch (Exception exception) {
                System.out.println("Can't create the username index because some of the username in the database are in double, will drop the double username.");
                statement.executeUpdate("DELETE FROM whitelist WHERE whitelist.rowid > (SELECT rowid FROM whitelist dbl WHERE whitelist.rowid <> dbl.rowid AND  whitelist.username = dbl.username);");
                statement.executeUpdate("CREATE UNIQUE INDEX [username] ON [whitelist]([username]  ASC)");
            }
        }
        if (!(resultSet = wrapper.getTables(null, null, "bannedip", null)).next()) {
            statement.executeUpdate("CREATE TABLE [bannedip] ([ip] TEXT NOT NULL,[username] TEXT NULL, [reason] TEXT NULL)");
        }
        resultSet.close();
        resultSet = wrapper.getTables(null, null, "bannedid", null);
        if (!resultSet.next()) {
            statement.executeUpdate("CREATE TABLE [bannedid] ([steamid] TEXT NOT NULL, [reason] TEXT NULL)");
        }
        resultSet.close();
        resultSet = wrapper.getTables(null, null, "userlog", null);
        if (!resultSet.next()) {
            statement.executeUpdate("CREATE TABLE [userlog] ([id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL,[username] TEXT  NULL,[type] TEXT  NULL, [text] TEXT  NULL, [issuedBy] TEXT  NULL, [amount] INTEGER NULL, [lastUpdate] TEXT NULL)");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "userlog", "lastUpdate");
        if (!resultSet.next()) {
            statement.executeUpdate("ALTER TABLE 'userlog' ADD 'lastUpdate' TEXT NULL");
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "moderator");
        if (resultSet.next()) {
            // empty if block
        }
        resultSet.close();
        resultSet = wrapper.getColumns(null, null, "whitelist", "admin");
        if (resultSet.next()) {
            resultSet.close();
            preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist where admin = 'true'");
            object = preparedStatement.executeQuery();
            while (object.next()) {
                autoCloseable = this.conn.prepareStatement("UPDATE whitelist set accesslevel = 'admin' where id = ?");
                autoCloseable.setString(1, object.getString("id"));
                System.out.println(object.getString("username"));
                autoCloseable.executeUpdate();
            }
        }
        if (!(resultSet = wrapper.getTables(null, null, "tickets", null)).next()) {
            statement.executeUpdate("CREATE TABLE [tickets] ([id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL, [message] TEXT NOT NULL, [author] TEXT NOT NULL,[answeredID] INTEGER,[viewed] BOOLEAN NULL DEFAULT false)");
        }
        resultSet.close();
        preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ?");
        preparedStatement.setString(1, this.CommandLineAdminUsername);
        resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            preparedStatement.close();
            object = this.CommandLineAdminPassword;
            if (object == null || ((String)object).isEmpty()) {
                autoCloseable = new Scanner(new InputStreamReader(System.in));
                System.out.println("User 'admin' not found, creating it ");
                System.out.println("Command line admin password: " + this.CommandLineAdminPassword);
                System.out.println("Enter new administrator password: ");
                object = ((Scanner)autoCloseable).nextLine();
                while (object == null || "".equals(object)) {
                    System.out.println("Enter new administrator password: ");
                    object = ((Scanner)autoCloseable).nextLine();
                }
                System.out.println("Confirm the password: ");
                String string = ((Scanner)autoCloseable).nextLine();
                while (string == null || "".equals(string) || !((String)object).equals(string)) {
                    System.out.println("Wrong password, confirm the password: ");
                    string = ((Scanner)autoCloseable).nextLine();
                }
            }
            preparedStatement = this.doAdmin ? this.conn.prepareStatement("INSERT INTO whitelist (username, password, accesslevel, encryptedPwd, pwdEncryptType) VALUES (?, ?, 'admin', 'true', '2')") : this.conn.prepareStatement("INSERT INTO whitelist (username, password, encryptedPwd, pwdEncryptType) VALUES (?, ?, 'true', '2')");
            preparedStatement.setString(1, this.CommandLineAdminUsername);
            preparedStatement.setString(2, PZcrypt.hash(ServerWorldDatabase.encrypt((String)object)));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            System.out.println("Administrator account '" + this.CommandLineAdminUsername + "' created.");
        } else {
            preparedStatement.close();
        }
        statement.close();
        if (this.CommandLineAdminPassword != null && !this.CommandLineAdminPassword.isEmpty()) {
            object = PZcrypt.hash(ServerWorldDatabase.encrypt(this.CommandLineAdminPassword));
            autoCloseable = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ?");
            autoCloseable.setString(1, this.CommandLineAdminUsername);
            resultSet = autoCloseable.executeQuery();
            if (resultSet.next()) {
                autoCloseable.close();
                autoCloseable = this.conn.prepareStatement("UPDATE whitelist SET password = ? WHERE username = ?");
                autoCloseable.setString(1, (String)object);
                autoCloseable.setString(2, this.CommandLineAdminUsername);
                autoCloseable.executeUpdate();
                System.out.println("admin password changed via -adminpassword option");
            } else {
                System.out.println("ERROR: -adminpassword ignored, no '" + this.CommandLineAdminUsername + "' account in db");
            }
            autoCloseable.close();
        }
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static boolean isValidUserName(String string) {
        if (string == null || string.trim().isEmpty() || string.contains(";") || string.contains("@") || string.contains("$") || string.contains(",") || string.contains("/") || string.contains(".") || string.contains("'") || string.contains("?") || string.contains("\"") || string.trim().length() < 3 || string.length() > 20) {
            return false;
        }
        if (string.contains(nullChar)) {
            return false;
        }
        if (string.trim().equals("admin")) {
            return true;
        }
        return !string.trim().toLowerCase().startsWith("admin");
    }

    public LogonResult authClient(String string, String string2, String string3, long l) {
        System.out.println("User " + string + " is trying to connect.");
        LogonResult logonResult = new LogonResult();
        if (!ServerOptions.instance.AllowNonAsciiUsername.getValue() && !asciiEncoder.canEncode(string)) {
            logonResult.bAuthorized = false;
            logonResult.dcReason = "NonAsciiCharacters";
            return logonResult;
        }
        if (!ServerWorldDatabase.isValidUserName(string)) {
            logonResult.bAuthorized = false;
            logonResult.dcReason = "InvalidUsername";
            return logonResult;
        }
        try {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            if (!SteamUtils.isSteamModeEnabled() && !string3.equals("127.0.0.1")) {
                preparedStatement = this.conn.prepareStatement("SELECT * FROM bannedip WHERE ip = ?");
                preparedStatement.setString(1, string3);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    logonResult.bAuthorized = false;
                    logonResult.bannedReason = resultSet.getString("reason");
                    logonResult.banned = true;
                    preparedStatement.close();
                    return logonResult;
                }
                preparedStatement.close();
            }
            if (ServerWorldDatabase.isNullOrEmpty(string2) && ServerOptions.instance.Open.getValue() && ServerOptions.instance.AutoCreateUserInWhiteList.getValue()) {
                logonResult.dcReason = "UserPasswordRequired";
                logonResult.bAuthorized = false;
                return logonResult;
            }
            preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE LOWER(username) = LOWER(?) AND world = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, Core.GameSaveWorld);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                PreparedStatement preparedStatement2;
                String string4;
                String string5;
                if (!ServerWorldDatabase.isNullOrEmpty(resultSet.getString("password")) && (resultSet.getString("encryptedPwd").equals("false") || resultSet.getString("encryptedPwd").equals("N"))) {
                    string5 = resultSet.getString("password");
                    string4 = ServerWorldDatabase.encrypt(string5);
                    preparedStatement2 = this.conn.prepareStatement("UPDATE whitelist SET encryptedPwd = 'true' WHERE username = ? and password = ?");
                    preparedStatement2.setString(1, string);
                    preparedStatement2.setString(2, string5);
                    preparedStatement2.executeUpdate();
                    preparedStatement2.close();
                    preparedStatement2 = this.conn.prepareStatement("UPDATE whitelist SET password = ? WHERE username = ? AND password = ?");
                    preparedStatement2.setString(1, string4);
                    preparedStatement2.setString(2, string);
                    preparedStatement2.setString(3, string5);
                    preparedStatement2.executeUpdate();
                    preparedStatement2.close();
                    resultSet = preparedStatement.executeQuery();
                }
                if (!ServerWorldDatabase.isNullOrEmpty(resultSet.getString("password")) && resultSet.getInt("pwdEncryptType") == 1) {
                    string5 = resultSet.getString("password");
                    string4 = PZcrypt.hash(string5);
                    preparedStatement2 = this.conn.prepareStatement("UPDATE whitelist SET pwdEncryptType = '2', password = ? WHERE username = ? AND password = ?");
                    preparedStatement2.setString(1, string4);
                    preparedStatement2.setString(2, string);
                    preparedStatement2.setString(3, string5);
                    preparedStatement2.executeUpdate();
                    preparedStatement2.close();
                    resultSet = preparedStatement.executeQuery();
                }
                if (!ServerWorldDatabase.isNullOrEmpty(resultSet.getString("password")) && !resultSet.getString("password").equals(string2)) {
                    logonResult.bAuthorized = false;
                    preparedStatement.close();
                    logonResult.dcReason = ServerWorldDatabase.isNullOrEmpty(string2) ? "DuplicateAccount" : "InvalidUsernamePassword";
                    return logonResult;
                }
                logonResult.bAuthorized = true;
                logonResult.admin = "true".equals(resultSet.getString("admin")) || "Y".equals(resultSet.getString("admin"));
                logonResult.accessLevel = resultSet.getString("accesslevel");
                if (logonResult.accessLevel == null) {
                    logonResult.accessLevel = "";
                    if (logonResult.admin) {
                        logonResult.accessLevel = "admin";
                    }
                    this.setAccessLevel(string, logonResult.accessLevel);
                }
                boolean bl = logonResult.banned = "true".equals(resultSet.getString("banned")) || "Y".equals(resultSet.getString("banned"));
                if (logonResult.banned) {
                    logonResult.bAuthorized = false;
                }
                logonResult.transactionID = resultSet.getString("transactionID") == null ? 0 : Integer.parseInt(resultSet.getString("transactionID"));
                logonResult.priority = resultSet.getString("priority").equals("true");
                preparedStatement.close();
                return logonResult;
            }
            if (ServerOptions.instance.Open.getValue()) {
                if (!this.isNewAccountAllowed(string3, l)) {
                    preparedStatement.close();
                    logonResult.bAuthorized = false;
                    logonResult.dcReason = "MaxAccountsReached";
                    return logonResult;
                }
                logonResult.bAuthorized = true;
                logonResult.newUser = true;
                preparedStatement.close();
                return logonResult;
            }
            logonResult.bAuthorized = false;
            logonResult.dcReason = "UnknownUsername";
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return logonResult;
    }

    public LogonResult authClient(long l) {
        String string = SteamUtils.convertSteamIDToString(l);
        System.out.println("Steam client " + string + " is initiating a connection.");
        LogonResult logonResult = new LogonResult();
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM bannedid WHERE steamid = ?");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                logonResult.bAuthorized = false;
                logonResult.bannedReason = resultSet.getString("reason");
                logonResult.banned = true;
                preparedStatement.close();
                return logonResult;
            }
            preparedStatement.close();
            logonResult.bAuthorized = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return logonResult;
    }

    public LogonResult authOwner(long l, long l2) {
        String string = SteamUtils.convertSteamIDToString(l);
        String string2 = SteamUtils.convertSteamIDToString(l2);
        System.out.println("Steam client " + string + " borrowed the game from " + string2);
        LogonResult logonResult = new LogonResult();
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM bannedid WHERE steamid = ?");
            preparedStatement.setString(1, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                logonResult.bAuthorized = false;
                logonResult.bannedReason = resultSet.getString("reason");
                logonResult.banned = true;
                preparedStatement.close();
                return logonResult;
            }
            preparedStatement.close();
            logonResult.bAuthorized = true;
            preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET ownerid = ? where steamid = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return logonResult;
    }

    private boolean isNewAccountAllowed(String string, long l) {
        int n = ServerOptions.instance.MaxAccountsPerUser.getValue();
        if (n <= 0) {
            return true;
        }
        if (!SteamUtils.isSteamModeEnabled()) {
            return true;
        }
        String string2 = SteamUtils.convertSteamIDToString(l);
        int n2 = 0;
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE steamid = ? AND ((accessLevel = ?) OR (accessLevel is NULL))");){
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, "");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ++n2;
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "Query execution failed", LogSeverity.Error);
            return true;
        }
        DebugLog.Multiplayer.debugln("IsNewAccountAllowed: steam-id=%d count=%d/%d", l, n2, n);
        return n2 < n;
    }

    public static String encrypt(String string) {
        if (ServerWorldDatabase.isNullOrEmpty(string)) {
            return "";
        }
        byte[] byArray = null;
        try {
            byArray = MessageDigest.getInstance("MD5").digest(string.getBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Can't encrypt password");
            noSuchAlgorithmException.printStackTrace();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i]);
            if (string2.length() == 1) {
                stringBuilder.append('0');
                stringBuilder.append(string2.charAt(string2.length() - 1));
                continue;
            }
            stringBuilder.append(string2.substring(string2.length() - 2));
        }
        return stringBuilder.toString();
    }

    public String changePwd(String string, String string2, String string3) throws SQLException {
        String string4 = string3;
        PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND password = ? AND world = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, Core.GameSaveWorld);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET pwdEncryptType = '2', password = ? WHERE username = ? and password = ?");
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            return "Your new password is " + string3;
        }
        preparedStatement.close();
        return "Wrong password for user " + string;
    }

    public String grantAdmin(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, Core.GameSaveWorld);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET admin = ? WHERE username = ?");
            preparedStatement.setString(1, bl ? "true" : "false");
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (bl) {
                return "User " + string + " is now admin";
            }
            return "User " + string + " is no longer admin";
        }
        preparedStatement.close();
        return "User \"" + string + "\" is not in the whitelist, use /adduser first";
    }

    public String setAccessLevel(String string, String string2) throws SQLException {
        string2 = string2.trim();
        if (!this.containsUser(string)) {
            this.addUser(string, "");
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, Core.GameSaveWorld);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET accesslevel = ? WHERE username = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (string2.equals("")) {
                return "User " + string + " no longer has access level";
            }
            return "User " + string + " is now " + string2;
        }
        preparedStatement.close();
        return "User \"" + string + "\" is not in the whitelist, use /adduser first";
    }

    public ArrayList<Userlog> getUserlog(String string) {
        ArrayList<Userlog> arrayList = new ArrayList<Userlog>();
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM userlog WHERE username = ?");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(new Userlog(string, resultSet.getString("type"), resultSet.getString("text"), resultSet.getString("issuedBy"), resultSet.getInt("amount"), resultSet.getString("lastUpdate")));
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return arrayList;
    }

    public void addUserlog(String string, Userlog.UserlogType userlogType, String string2, String string3, int n) {
        try {
            PreparedStatement preparedStatement;
            boolean bl = true;
            String string4 = dateFormat.format(Calendar.getInstance().getTime());
            if (userlogType == Userlog.UserlogType.LuaChecksum || userlogType == Userlog.UserlogType.DupeItem) {
                preparedStatement = this.conn.prepareStatement("SELECT * FROM userlog WHERE username = ? AND type = ?");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, userlogType.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    bl = false;
                    n = Integer.parseInt(resultSet.getString("amount")) + 1;
                    preparedStatement.close();
                    PreparedStatement preparedStatement2 = this.conn.prepareStatement("UPDATE userlog set amount = ?, lastUpdate = ?, text = ? WHERE username = ? AND type = ?");
                    preparedStatement2.setString(1, String.valueOf(n));
                    preparedStatement2.setString(2, string4);
                    preparedStatement2.setString(3, string2);
                    preparedStatement2.setString(4, string);
                    preparedStatement2.setString(5, userlogType.toString());
                    preparedStatement2.executeUpdate();
                    preparedStatement2.close();
                }
            } else if (userlogType == Userlog.UserlogType.Kicked || userlogType == Userlog.UserlogType.Banned || userlogType == Userlog.UserlogType.SuspiciousActivity || userlogType == Userlog.UserlogType.UnauthorizedPacket) {
                preparedStatement = this.conn.prepareStatement("SELECT * FROM userlog WHERE username = ? AND type = ? AND text = ? AND issuedBy = ?");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, userlogType.toString());
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, string3);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    bl = false;
                    n = Integer.parseInt(resultSet.getString("amount")) + 1;
                    preparedStatement.close();
                    PreparedStatement preparedStatement3 = this.conn.prepareStatement("UPDATE userlog set amount = ?, lastUpdate = ? WHERE username = ? AND type = ? AND text = ? AND issuedBy = ?");
                    preparedStatement3.setString(1, String.valueOf(n));
                    preparedStatement3.setString(2, string4);
                    preparedStatement3.setString(3, string);
                    preparedStatement3.setString(4, userlogType.toString());
                    preparedStatement3.setString(5, string2);
                    preparedStatement3.setString(6, string3);
                    preparedStatement3.executeUpdate();
                    preparedStatement3.close();
                }
            }
            if (bl) {
                preparedStatement = this.conn.prepareStatement("INSERT INTO userlog (username, type, text, issuedBy, amount, lastUpdate) VALUES (?, ?, ?, ?, ?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, userlogType.toString());
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, string3);
                preparedStatement.setString(5, String.valueOf(n));
                preparedStatement.setString(6, string4);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String banUser(String string, boolean bl) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, Core.GameSaveWorld);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl2 = resultSet.next();
        if (bl && !bl2) {
            object = this.conn.prepareStatement("INSERT INTO whitelist (world, username, password, encryptedPwd) VALUES (?, ?, 'bogus', 'false')");
            object.setString(1, Core.GameSaveWorld);
            object.setString(2, string);
            object.executeUpdate();
            object.close();
            resultSet = preparedStatement.executeQuery();
            bl2 = true;
        }
        if (bl2) {
            object = "true";
            if (!bl) {
                object = "false";
            }
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET banned = ? WHERE username = ?");
            preparedStatement.setString(1, (String)object);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (SteamUtils.isSteamModeEnabled()) {
                preparedStatement = this.conn.prepareStatement("SELECT steamid FROM whitelist WHERE username = ? AND world = ?");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, Core.GameSaveWorld);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    String string2 = resultSet.getString("steamid");
                    preparedStatement.close();
                    if (string2 != null && !string2.isEmpty()) {
                        this.banSteamID(string2, "", bl);
                    }
                } else {
                    preparedStatement.close();
                }
            }
            if (bl) {
                return "User " + string + " is now banned";
            }
            return "User " + string + " is now un-banned";
        }
        preparedStatement.close();
        return "User \"" + string + "\" is not in the whitelist, use /adduser first";
    }

    public String banIp(String string, String string2, String string3, boolean bl) throws SQLException {
        if (bl) {
            PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO bannedip (ip, username, reason) VALUES (?, ?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } else {
            PreparedStatement preparedStatement;
            if (string != null) {
                preparedStatement = this.conn.prepareStatement("DELETE FROM bannedip WHERE ip = ?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            preparedStatement = this.conn.prepareStatement("DELETE FROM bannedip WHERE username = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        return "";
    }

    public String banSteamID(String string, String string2, boolean bl) throws SQLException {
        if (bl) {
            PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO bannedid (steamid, reason) VALUES (?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } else {
            PreparedStatement preparedStatement = this.conn.prepareStatement("DELETE FROM bannedid WHERE steamid = ?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        return "";
    }

    public String setUserSteamID(String string, String string2) {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ?");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                preparedStatement.close();
                return "User " + string + " not found";
            }
            preparedStatement.close();
            preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET steamid = ? WHERE username = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return "User " + string + " SteamID set to " + string2;
    }

    public void setPassword(String string, String string2) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET pwdEncryptType = '2', password = ? WHERE username = ? and world = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, Core.GameSaveWorld);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void updateLastConnectionDate(String string, String string2) {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement("UPDATE whitelist SET lastConnection = ? WHERE username = ? AND password = ?");
            preparedStatement.setString(1, dateFormat.format(Calendar.getInstance().getTime()));
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public String addWarningPoint(String string, String string2, int n, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT * FROM whitelist WHERE username = ? AND world = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, Core.GameSaveWorld);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            this.addUserlog(string, Userlog.UserlogType.WarningPoint, string2, string3, n);
            return "Added a warning point on " + string + " reason: " + string2;
        }
        return "User " + string + " doesn't exist.";
    }

    public void addTicket(String string, String string2, int n) throws SQLException {
        if (n > -1) {
            PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO tickets (author, message, answeredID) VALUES (?, ?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        } else {
            PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO tickets (author, message) VALUES (?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    public ArrayList<DBTicket> getTickets(String string) throws SQLException {
        ArrayList<DBTicket> arrayList = new ArrayList<DBTicket>();
        PreparedStatement preparedStatement = null;
        if (string != null) {
            preparedStatement = this.conn.prepareStatement("SELECT * FROM tickets WHERE author = ? and answeredID is null");
            preparedStatement.setString(1, string);
        } else {
            preparedStatement = this.conn.prepareStatement("SELECT * FROM tickets where answeredID is null");
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            DBTicket dBTicket = new DBTicket(resultSet.getString("author"), resultSet.getString("message"), resultSet.getInt("id"));
            arrayList.add(dBTicket);
            DBTicket dBTicket2 = this.getAnswer(dBTicket.getTicketID());
            if (dBTicket2 == null) continue;
            dBTicket.setAnswer(dBTicket2);
        }
        return arrayList;
    }

    private DBTicket getAnswer(int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.conn.prepareStatement("SELECT * FROM tickets WHERE answeredID = ?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return new DBTicket(resultSet.getString("author"), resultSet.getString("message"), resultSet.getInt("id"));
        }
        return null;
    }

    public void removeTicket(int n) throws SQLException {
        PreparedStatement preparedStatement;
        DBTicket dBTicket = this.getAnswer(n);
        if (dBTicket != null) {
            preparedStatement = this.conn.prepareStatement("DELETE FROM tickets WHERE id = ?");
            preparedStatement.setInt(1, dBTicket.getTicketID());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        preparedStatement = this.conn.prepareStatement("DELETE FROM tickets WHERE id = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public class LogonResult {
        public boolean bAuthorized = false;
        public int x;
        public int y;
        public int z;
        public boolean newUser = false;
        public boolean admin = false;
        public boolean banned = false;
        public boolean priority = false;
        public String bannedReason = null;
        public String dcReason = null;
        public String accessLevel = "";
        public int transactionID = 0;
    }
}

