/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.network.ServerSettings;

public class ServerSettingsManager {
    public static final ServerSettingsManager instance = new ServerSettingsManager();
    protected ArrayList<ServerSettings> settings = new ArrayList();
    protected ArrayList<String> suffixes = new ArrayList();

    public String getSettingsFolder() {
        return ZomboidFileSystem.instance.getCacheDir() + File.separator + "Server";
    }

    public String getNameInSettingsFolder(String string) {
        return this.getSettingsFolder() + File.separator + string;
    }

    public void readAllSettings() {
        this.settings.clear();
        File file = new File(this.getSettingsFolder());
        if (!file.exists()) {
            file.mkdirs();
            return;
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) throws IOException {
                String string = path.getFileName().toString();
                return !Files.isDirectory(path, new LinkOption[0]) && string.endsWith(".ini") && !string.endsWith("_zombies.ini") && ServerSettingsManager.this.isValidName(string.replace(".ini", ""));
            }
        };
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file.toPath(), (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path : directoryStream) {
                ServerSettings serverSettings = new ServerSettings(path.getFileName().toString().replace(".ini", ""));
                this.settings.add(serverSettings);
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public int getSettingsCount() {
        return this.settings.size();
    }

    public ServerSettings getSettingsByIndex(int n) {
        if (n >= 0 && n < this.settings.size()) {
            return this.settings.get(n);
        }
        return null;
    }

    public boolean isValidName(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (string.contains("/") || string.contains("\\") || string.contains(":") || string.contains(";") || string.contains("\"") || string.contains(".")) {
            return false;
        }
        return !string.contains("_zombies");
    }

    private boolean anyFilesExist(String string) {
        this.getSuffixes();
        for (int i = 0; i < this.suffixes.size(); ++i) {
            File file = new File(this.getSettingsFolder() + File.separator + string + this.suffixes.get(i));
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean isValidNewName(String string) {
        if (!this.isValidName(string)) {
            return false;
        }
        return !this.anyFilesExist(string);
    }

    public ArrayList<String> getSuffixes() {
        if (this.suffixes.isEmpty()) {
            this.suffixes.add(".ini");
            this.suffixes.add("_SandboxVars.lua");
            this.suffixes.add("_spawnpoints.lua");
            this.suffixes.add("_spawnregions.lua");
            this.suffixes.add("_zombies.ini");
        }
        return this.suffixes;
    }
}

