/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import zombie.GameTime;
import zombie.MapCollisionData;
import zombie.ReanimatedPlayers;
import zombie.VirtualZombieManager;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.stash.StashSystem;
import zombie.core.utils.OnceEvery;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.globalObjects.SGlobalObjects;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.network.GameServer;
import zombie.network.IsoObjectID;
import zombie.network.MPStatistic;
import zombie.network.PacketTypes;
import zombie.network.RCONServer;
import zombie.network.ServerChunkLoader;
import zombie.network.ServerGUI;
import zombie.network.ServerLOS;
import zombie.network.ServerOptions;
import zombie.network.ServerPlayersVehicles;
import zombie.network.ServerWorldDatabase;
import zombie.popman.NetworkZombiePacker;
import zombie.popman.ZombiePopulationManager;
import zombie.radio.ZomboidRadio;
import zombie.savefile.ServerPlayerDB;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclesDB2;
import zombie.world.moddata.GlobalModData;

public class ServerMap {
    public boolean bUpdateLOSThisFrame = false;
    public static OnceEvery LOSTick = new OnceEvery(1.0f);
    public static OnceEvery TimeTick = new OnceEvery(600.0f);
    public static final int CellSize = 50;
    public static final int ChunksPerCellWidth = 5;
    public long LastSaved = 0L;
    private static boolean MapLoading;
    public final IsoObjectID<IsoZombie> ZombieMap = new IsoObjectID<IsoZombie>(IsoZombie.class);
    public boolean bQueuedSaveAll = false;
    public boolean bQueuedQuit = false;
    public static ServerMap instance;
    public ServerCell[] cellMap;
    public ArrayList<ServerCell> LoadedCells = new ArrayList();
    public ArrayList<ServerCell> ReleventNow = new ArrayList();
    int width;
    int height;
    IsoMetaGrid grid;
    ArrayList<ServerCell> ToLoad = new ArrayList();
    static final DistToCellComparator distToCellComparator;
    private final ArrayList<ServerCell> tempCells = new ArrayList();
    long lastTick = 0L;
    Vector2 start;

    public short getUniqueZombieId() {
        return this.ZombieMap.allocateID();
    }

    public Vector3 getStartLocation(ServerWorldDatabase.LogonResult logonResult) {
        int n = 9412;
        int n2 = 10745;
        boolean bl = false;
        return new Vector3(n2, n, (float)bl);
    }

    public void SaveAll() {
        long l = System.nanoTime();
        for (int i = 0; i < this.LoadedCells.size(); ++i) {
            this.LoadedCells.get(i).Save();
        }
        this.grid.save();
        DebugLog.log("SaveAll took " + (double)(System.nanoTime() - l) / 1000000.0 + " ms");
    }

    public void QueueSaveAll() {
        this.bQueuedSaveAll = true;
    }

    public void QueueQuit() {
        DebugLog.Multiplayer.printStackTrace();
        this.bQueuedSaveAll = true;
        this.bQueuedQuit = true;
    }

    public int toServerCellX(int n) {
        n *= 300;
        return n /= 50;
    }

    public int toServerCellY(int n) {
        n *= 300;
        return n /= 50;
    }

    public int toWorldCellX(int n) {
        n *= 50;
        return n /= 300;
    }

    public int toWorldCellY(int n) {
        n *= 50;
        return n /= 300;
    }

    public int getMaxX() {
        int n = this.toServerCellX(this.grid.maxX + 1);
        if ((this.grid.maxX + 1) * 300 % 50 == 0) {
            --n;
        }
        return n;
    }

    public int getMaxY() {
        int n = this.toServerCellY(this.grid.maxY + 1);
        if ((this.grid.maxY + 1) * 300 % 50 == 0) {
            --n;
        }
        return n;
    }

    public int getMinX() {
        int n = this.toServerCellX(this.grid.minX);
        return n;
    }

    public int getMinY() {
        int n = this.toServerCellY(this.grid.minY);
        return n;
    }

    public void init(IsoMetaGrid isoMetaGrid) {
        this.grid = isoMetaGrid;
        this.width = this.getMaxX() - this.getMinX() + 1;
        this.height = this.getMaxY() - this.getMinY() + 1;
        assert (this.width * 50 >= isoMetaGrid.getWidth() * 300);
        assert (this.height * 50 >= isoMetaGrid.getHeight() * 300);
        assert (this.getMaxX() * 50 < (isoMetaGrid.getMaxX() + 1) * 300);
        assert (this.getMaxY() * 50 < (isoMetaGrid.getMaxY() + 1) * 300);
        int n = this.width * this.height;
        this.cellMap = new ServerCell[n];
        StashSystem.init();
    }

    public ServerCell getCell(int n, int n2) {
        if (!this.isValidCell(n, n2)) {
            return null;
        }
        return this.cellMap[n2 * this.width + n];
    }

    public boolean isValidCell(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    public void loadOrKeepRelevent(int n, int n2) {
        if (!this.isValidCell(n, n2)) {
            return;
        }
        ServerCell serverCell = this.getCell(n, n2);
        if (serverCell == null) {
            serverCell = new ServerCell();
            serverCell.WX = n + this.getMinX();
            serverCell.WY = n2 + this.getMinY();
            if (MapLoading) {
                DebugLog.log(DebugType.MapLoading, "Loading cell: " + serverCell.WX + ", " + serverCell.WY + " (" + this.toWorldCellX(serverCell.WX) + ", " + this.toWorldCellX(serverCell.WY) + ")");
            }
            this.cellMap[n2 * this.width + n] = serverCell;
            this.ToLoad.add(serverCell);
            MPStatistic.getInstance().ServerMapToLoad.Added();
            this.LoadedCells.add(serverCell);
            MPStatistic.getInstance().ServerMapLoadedCells.Added();
            this.ReleventNow.add(serverCell);
        } else if (!this.ReleventNow.contains(serverCell)) {
            this.ReleventNow.add(serverCell);
        }
    }

    public void characterIn(IsoPlayer isoPlayer) {
        while (this.grid == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        int n = isoPlayer.OnlineChunkGridWidth / 2 * 10;
        int n2 = (int)(Math.floor((isoPlayer.getX() - (float)n) / 50.0f) - (double)this.getMinX());
        int n3 = (int)(Math.floor((isoPlayer.getX() + (float)n) / 50.0f) - (double)this.getMinX());
        int n4 = (int)(Math.floor((isoPlayer.getY() - (float)n) / 50.0f) - (double)this.getMinY());
        int n5 = (int)(Math.floor((isoPlayer.getY() + (float)n) / 50.0f) - (double)this.getMinY());
        for (int i = n4; i <= n5; ++i) {
            for (int j = n2; j <= n3; ++j) {
                this.loadOrKeepRelevent(j, i);
            }
        }
    }

    public void characterIn(int n, int n2, int n3) {
        while (this.grid == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        int n4 = n * 10;
        int n5 = n2 * 10;
        n4 = (int)((float)n4 / 50.0f);
        n5 = (int)((float)n5 / 50.0f);
        int n6 = n4 -= this.getMinX();
        int n7 = n5 -= this.getMinY();
        int n8 = n * 10 % 50;
        int n9 = n2 * 10 % 50;
        int n10 = n3 / 2 * 10;
        int n11 = n6;
        int n12 = n7;
        int n13 = n6;
        int n14 = n7;
        if (n8 < n10) {
            --n11;
        }
        if (n8 > 50 - n10) {
            ++n13;
        }
        if (n9 < n10) {
            --n12;
        }
        if (n9 > 50 - n10) {
            ++n14;
        }
        for (int i = n12; i <= n14; ++i) {
            for (int j = n11; j <= n13; ++j) {
                this.loadOrKeepRelevent(j, i);
            }
        }
    }

    public void loadMapChunk(int n, int n2) {
        while (this.grid == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        int n3 = n;
        int n4 = n2;
        n3 = (int)((float)n3 / 50.0f);
        n4 = (int)((float)n4 / 50.0f);
        this.loadOrKeepRelevent(n3 -= this.getMinX(), n4 -= this.getMinY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preupdate() {
        long l;
        int n;
        int n2;
        ServerCell serverCell;
        int n3;
        long l2 = System.nanoTime();
        long l3 = l2 - this.lastTick;
        double d = (double)l3 * 1.0E-6;
        this.lastTick = l2;
        MapLoading = DebugType.Do(DebugType.MapLoading);
        for (n3 = 0; n3 < this.ToLoad.size(); ++n3) {
            serverCell = this.ToLoad.get(n3);
            if (!serverCell.bLoadingWasCancelled) continue;
            if (MapLoading) {
                DebugLog.log(DebugType.MapLoading, "MainThread: forgetting cancelled " + serverCell.WX + "," + serverCell.WY);
            }
            n2 = serverCell.WX - this.getMinX();
            n = serverCell.WY - this.getMinY();
            assert (this.cellMap[n2 + n * this.width] == serverCell);
            this.cellMap[n2 + n * this.width] = null;
            this.LoadedCells.remove(serverCell);
            this.ReleventNow.remove(serverCell);
            ServerCell.loaded2.remove(serverCell);
            this.ToLoad.remove(n3--);
            MPStatistic.getInstance().ServerMapToLoad.Canceled();
        }
        for (n3 = 0; n3 < this.LoadedCells.size(); ++n3) {
            serverCell = this.LoadedCells.get(n3);
            if (!serverCell.bCancelLoading) continue;
            if (MapLoading) {
                DebugLog.log(DebugType.MapLoading, "MainThread: forgetting cancelled " + serverCell.WX + "," + serverCell.WY);
            }
            n2 = serverCell.WX - this.getMinX();
            n = serverCell.WY - this.getMinY();
            assert (this.cellMap[n2 + n * this.width] == serverCell);
            this.cellMap[n2 + n * this.width] = null;
            this.LoadedCells.remove(n3--);
            this.ReleventNow.remove(serverCell);
            ServerCell.loaded2.remove(serverCell);
            this.ToLoad.remove(serverCell);
            MPStatistic.getInstance().ServerMapLoadedCells.Canceled();
        }
        for (n3 = 0; n3 < ServerCell.loaded2.size(); ++n3) {
            serverCell = ServerCell.loaded2.get(n3);
            if (!serverCell.bCancelLoading) continue;
            if (MapLoading) {
                DebugLog.log(DebugType.MapLoading, "MainThread: forgetting cancelled " + serverCell.WX + "," + serverCell.WY);
            }
            n2 = serverCell.WX - this.getMinX();
            n = serverCell.WY - this.getMinY();
            assert (this.cellMap[n2 + n * this.width] == serverCell);
            this.cellMap[n2 + n * this.width] = null;
            this.LoadedCells.remove(serverCell);
            this.ReleventNow.remove(serverCell);
            ServerCell.loaded2.remove(serverCell);
            this.ToLoad.remove(serverCell);
            MPStatistic.getInstance().ServerMapLoaded2.Canceled();
        }
        if (!this.ToLoad.isEmpty()) {
            this.tempCells.clear();
            for (n3 = 0; n3 < this.ToLoad.size(); ++n3) {
                serverCell = this.ToLoad.get(n3);
                if (serverCell.bCancelLoading || serverCell.startedLoading) continue;
                this.tempCells.add(serverCell);
            }
            if (!this.tempCells.isEmpty()) {
                distToCellComparator.init();
                Collections.sort(this.tempCells, distToCellComparator);
                for (n3 = 0; n3 < this.tempCells.size(); ++n3) {
                    serverCell = this.tempCells.get(n3);
                    ServerCell.chunkLoader.addJob(serverCell);
                    serverCell.startedLoading = true;
                }
            }
            ServerCell.chunkLoader.getLoaded(ServerCell.loaded);
            for (n3 = 0; n3 < ServerCell.loaded.size(); ++n3) {
                serverCell = ServerCell.loaded.get(n3);
                if (serverCell.doingRecalc) continue;
                ServerCell.chunkLoader.addRecalcJob(serverCell);
                serverCell.doingRecalc = true;
            }
            ServerCell.loaded.clear();
            ServerCell.chunkLoader.getRecalc(ServerCell.loaded2);
            if (!ServerCell.loaded2.isEmpty()) {
                try {
                    ServerLOS.instance.suspend();
                    for (n3 = 0; n3 < ServerCell.loaded2.size(); ++n3) {
                        serverCell = ServerCell.loaded2.get(n3);
                        long l4 = System.nanoTime();
                        if (!serverCell.Load2()) continue;
                        l4 = System.nanoTime();
                        --n3;
                        this.ToLoad.remove(serverCell);
                    }
                }
                finally {
                    ServerLOS.instance.resume();
                }
            }
        }
        if ((n3 = ServerOptions.instance.SaveWorldEveryMinutes.getValue()) > 0 && (l = System.currentTimeMillis()) > this.LastSaved + (long)(n3 * 60 * 1000)) {
            this.bQueuedSaveAll = true;
            this.LastSaved = l;
        }
        if (this.bQueuedSaveAll) {
            this.bQueuedSaveAll = false;
            long l5 = System.nanoTime();
            this.SaveAll();
            ServerCell.chunkLoader.saveLater(GameTime.instance);
            ReanimatedPlayers.instance.saveReanimatedPlayers();
            MapCollisionData.instance.save();
            SGlobalObjects.save();
            try {
                ZomboidRadio.getInstance().Save();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                GlobalModData.instance.save();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            GameServer.UnPauseAllClients();
            System.out.println("Saving finish");
            DebugLog.log("Saving took " + (double)(System.nanoTime() - l5) / 1000000.0 + " ms");
        }
        if (this.bQueuedQuit) {
            ByteBufferWriter byteBufferWriter = GameServer.udpEngine.startPacket();
            PacketTypes.PacketType.ServerQuit.doPacket(byteBufferWriter);
            GameServer.udpEngine.endPacketBroadcast(PacketTypes.PacketType.ServerQuit);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            MapCollisionData.instance.stop();
            ZombiePopulationManager.instance.stop();
            RCONServer.shutdown();
            ServerCell.chunkLoader.quit();
            ServerWorldDatabase.instance.close();
            ServerPlayersVehicles.instance.stop();
            ServerPlayerDB.getInstance().close();
            VehiclesDB2.instance.Reset();
            GameServer.udpEngine.Shutdown();
            ServerGUI.shutdown();
            SteamUtils.shutdown();
            System.exit(0);
        }
        this.ReleventNow.clear();
        this.bUpdateLOSThisFrame = LOSTick.Check();
        if (TimeTick.Check()) {
            ServerCell.chunkLoader.saveLater(GameTime.instance);
        }
    }

    private IsoGridSquare getRandomSquareFromCell(int n, int n2) {
        this.loadOrKeepRelevent(n, n2);
        int n3 = n;
        int n4 = n2;
        ServerCell serverCell = this.getCell(n, n2);
        if (serverCell == null) {
            throw new RuntimeException("Cannot find a random square.");
        }
        n = (n + this.getMinX()) * 50;
        n2 = (n2 + this.getMinY()) * 50;
        IsoGridSquare isoGridSquare = null;
        int n5 = 100;
        do {
            isoGridSquare = this.getGridSquare(Rand.Next(n, n + 50), Rand.Next(n2, n2 + 50), 0);
            --n5;
            if (isoGridSquare != null) continue;
            this.loadOrKeepRelevent(n3, n4);
        } while (isoGridSquare == null && n5 > 0);
        return isoGridSquare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postupdate() {
        int n = this.LoadedCells.size();
        boolean bl = false;
        try {
            for (int i = 0; i < this.LoadedCells.size(); ++i) {
                boolean bl2;
                ServerCell serverCell = this.LoadedCells.get(i);
                boolean bl3 = bl2 = this.ReleventNow.contains(serverCell) || !this.outsidePlayerInfluence(serverCell);
                if (!serverCell.bLoaded) {
                    if (bl2 || serverCell.bCancelLoading) continue;
                    if (MapLoading) {
                        DebugLog.log(DebugType.MapLoading, "MainThread: cancelling " + serverCell.WX + "," + serverCell.WY + " cell.startedLoading=" + serverCell.startedLoading);
                    }
                    if (!serverCell.startedLoading) {
                        serverCell.bLoadingWasCancelled = true;
                    }
                    serverCell.bCancelLoading = true;
                    continue;
                }
                if (!bl2) {
                    int n2 = serverCell.WX - this.getMinX();
                    int n3 = serverCell.WY - this.getMinY();
                    if (!bl) {
                        ServerLOS.instance.suspend();
                        bl = true;
                    }
                    this.cellMap[n3 * this.width + n2].Unload();
                    this.cellMap[n3 * this.width + n2] = null;
                    this.LoadedCells.remove(serverCell);
                    --i;
                    continue;
                }
                serverCell.update();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bl) {
                ServerLOS.instance.resume();
            }
        }
        NetworkZombiePacker.getInstance().postupdate();
        ServerCell.chunkLoader.updateSaved();
    }

    public void physicsCheck(int n, int n2) {
        int n3 = n / 50;
        int n4 = n2 / 50;
        ServerCell serverCell = this.getCell(n3 -= this.getMinX(), n4 -= this.getMinY());
        if (serverCell != null && serverCell.bLoaded) {
            serverCell.bPhysicsCheck = true;
        }
    }

    private boolean outsidePlayerInfluence(ServerCell serverCell) {
        int n = serverCell.WX * 50;
        int n2 = serverCell.WY * 50;
        int n3 = (serverCell.WX + 1) * 50;
        int n4 = (serverCell.WY + 1) * 50;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (udpConnection.RelevantTo(n, n2)) {
                return false;
            }
            if (udpConnection.RelevantTo(n3, n2)) {
                return false;
            }
            if (udpConnection.RelevantTo(n3, n4)) {
                return false;
            }
            if (!udpConnection.RelevantTo(n, n4)) continue;
            return false;
        }
        return true;
    }

    public void saveZoneInsidePlayerInfluence(short s) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < udpConnection.players.length; ++j) {
                IsoGridSquare isoGridSquare;
                if (udpConnection.players[j] == null || udpConnection.players[j].OnlineID != s || (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(udpConnection.players[j].x, udpConnection.players[j].y, udpConnection.players[j].z)) == null) continue;
                ServerCell.chunkLoader.addSaveLoadedJob(isoGridSquare.chunk);
                return;
            }
        }
        ServerCell.chunkLoader.updateSaved();
    }

    private boolean InsideThePlayerInfluence(ServerCell serverCell, short s) {
        int n = serverCell.WX * 50;
        int n2 = serverCell.WY * 50;
        int n3 = (serverCell.WX + 1) * 50;
        int n4 = (serverCell.WY + 1) * 50;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < udpConnection.players.length; ++j) {
                if (udpConnection.players[j] == null || udpConnection.players[j].OnlineID != s) continue;
                if (udpConnection.RelevantToPlayerIndex(j, n, n2)) {
                    return true;
                }
                if (udpConnection.RelevantToPlayerIndex(j, n3, n2)) {
                    return true;
                }
                if (udpConnection.RelevantToPlayerIndex(j, n3, n4)) {
                    return true;
                }
                return udpConnection.RelevantToPlayerIndex(j, n, n4);
            }
        }
        return false;
    }

    public IsoGridSquare getGridSquare(int n, int n2, int n3) {
        if (!IsoWorld.instance.isValidSquare(n, n2, n3)) {
            return null;
        }
        int n4 = n / 50;
        int n5 = n2 / 50;
        n4 -= this.getMinX();
        n5 -= this.getMinY();
        int n6 = n / 10;
        int n7 = n2 / 10;
        int n8 = n6 % 5;
        int n9 = n7 % 5;
        int n10 = n % 10;
        int n11 = n2 % 10;
        ServerCell serverCell = this.getCell(n4, n5);
        if (serverCell == null || !serverCell.bLoaded) {
            return null;
        }
        IsoChunk isoChunk = serverCell.chunks[n8][n9];
        if (isoChunk == null) {
            return null;
        }
        return isoChunk.getGridSquare(n10, n11, n3);
    }

    public void setGridSquare(int n, int n2, int n3, IsoGridSquare isoGridSquare) {
        int n4 = n / 50;
        int n5 = n2 / 50;
        n4 -= this.getMinX();
        n5 -= this.getMinY();
        int n6 = n / 10;
        int n7 = n2 / 10;
        int n8 = n6 % 5;
        int n9 = n7 % 5;
        int n10 = n % 10;
        int n11 = n2 % 10;
        ServerCell serverCell = this.getCell(n4, n5);
        if (serverCell == null) {
            return;
        }
        IsoChunk isoChunk = serverCell.chunks[n8][n9];
        if (isoChunk == null) {
            return;
        }
        isoChunk.setSquare(n10, n11, n3, isoGridSquare);
    }

    public boolean isInLoaded(float f, float f2) {
        int n = (int)f;
        int n2 = (int)f2;
        n /= 50;
        n2 /= 50;
        if (this.ToLoad.contains(this.getCell(n -= this.getMinX(), n2 -= this.getMinY()))) {
            return false;
        }
        return this.getCell(n, n2) != null;
    }

    public IsoChunk getChunk(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int n3 = n / 5;
        int n4 = n2 / 5;
        int n5 = n % 5;
        int n6 = n2 % 5;
        ServerCell serverCell = this.getCell(n3 -= this.getMinX(), n4 -= this.getMinY());
        if (serverCell == null || !serverCell.bLoaded) {
            return null;
        }
        return serverCell.chunks[n5][n6];
    }

    public void setSoftResetChunk(IsoChunk isoChunk) {
        int n = isoChunk.wx / 5;
        int n2 = isoChunk.wy / 5;
        if (!this.isValidCell(n -= this.getMinX(), n2 -= this.getMinY())) {
            return;
        }
        ServerCell serverCell = this.getCell(n, n2);
        if (serverCell == null) {
            serverCell = new ServerCell();
            serverCell.bLoaded = true;
            this.cellMap[n2 * this.width + n] = serverCell;
        }
        int n3 = isoChunk.wx % 5;
        int n4 = isoChunk.wy % 5;
        serverCell.chunks[n3][n4] = isoChunk;
    }

    public void clearSoftResetChunk(IsoChunk isoChunk) {
        int n = isoChunk.wx / 5;
        int n2 = isoChunk.wy / 5;
        ServerCell serverCell = this.getCell(n -= this.getMinX(), n2 -= this.getMinY());
        if (serverCell == null) {
            return;
        }
        int n3 = isoChunk.wx % 5;
        int n4 = isoChunk.wy % 5;
        serverCell.chunks[n3][n4] = null;
    }

    static {
        instance = new ServerMap();
        distToCellComparator = new DistToCellComparator();
    }

    public static class ServerCell {
        public int WX;
        public int WY;
        public boolean bLoaded = false;
        public boolean bPhysicsCheck = false;
        public final IsoChunk[][] chunks = new IsoChunk[5][5];
        private final HashSet<RoomDef> UnexploredRooms = new HashSet();
        private static final ServerChunkLoader chunkLoader = new ServerChunkLoader();
        private static final ArrayList<ServerCell> loaded = new ArrayList();
        private boolean startedLoading = false;
        public boolean bCancelLoading = false;
        public boolean bLoadingWasCancelled = false;
        private static final ArrayList<ServerCell> loaded2 = new ArrayList();
        private boolean doingRecalc = false;

        public boolean Load2() {
            chunkLoader.getRecalc(loaded2);
            for (int i = 0; i < loaded2.size(); ++i) {
                if (loaded2.get(i) != this) continue;
                long l = System.nanoTime();
                this.RecalcAll2();
                loaded2.remove(i);
                if (MapLoading) {
                    DebugLog.log(DebugType.MapLoading, "loaded2=" + loaded2);
                }
                float f = (float)(System.nanoTime() - l) / 1000000.0f;
                if (MapLoading) {
                    DebugLog.log(DebugType.MapLoading, "finish loading cell " + this.WX + "," + this.WY + " ms=" + f);
                }
                this.loadVehicles();
                return true;
            }
            return false;
        }

        private void loadVehicles() {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    IsoChunk isoChunk = this.chunks[i][j];
                    if (isoChunk == null || isoChunk.isNewChunk()) continue;
                    VehiclesDB2.instance.loadChunkMain(isoChunk);
                }
            }
        }

        public void RecalcAll2() {
            int n;
            IsoGridSquare isoGridSquare;
            int n2;
            int n3 = this.WX * 5 * 10;
            int n4 = this.WY * 5 * 10;
            int n5 = n3 + 50;
            int n6 = n4 + 50;
            for (RoomDef roomDef : this.UnexploredRooms) {
                --roomDef.IndoorZombies;
            }
            this.UnexploredRooms.clear();
            this.bLoaded = true;
            for (n2 = 1; n2 < 8; ++n2) {
                int n7;
                for (n7 = -1; n7 < 51; ++n7) {
                    isoGridSquare = instance.getGridSquare(n3 + n7, n4 - 1, n2);
                    if (isoGridSquare != null && !isoGridSquare.getObjects().isEmpty()) {
                        IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                    } else if (n7 >= 0 && n7 < 50 && (isoGridSquare = instance.getGridSquare(n3 + n7, n4, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                        IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                    }
                    isoGridSquare = instance.getGridSquare(n3 + n7, n4 + 50, n2);
                    if (isoGridSquare != null && !isoGridSquare.getObjects().isEmpty()) {
                        IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                        continue;
                    }
                    if (n7 < 0 || n7 >= 50) continue;
                    instance.getGridSquare(n3 + n7, n4 + 50 - 1, n2);
                    if (isoGridSquare == null || isoGridSquare.getObjects().isEmpty()) continue;
                    IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                }
                for (n7 = 0; n7 < 50; ++n7) {
                    isoGridSquare = instance.getGridSquare(n3 - 1, n4 + n7, n2);
                    if (isoGridSquare != null && !isoGridSquare.getObjects().isEmpty()) {
                        IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                    } else {
                        isoGridSquare = instance.getGridSquare(n3, n4 + n7, n2);
                        if (isoGridSquare != null && !isoGridSquare.getObjects().isEmpty()) {
                            IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                        }
                    }
                    isoGridSquare = instance.getGridSquare(n3 + 50, n4 + n7, n2);
                    if (isoGridSquare != null && !isoGridSquare.getObjects().isEmpty()) {
                        IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                        continue;
                    }
                    isoGridSquare = instance.getGridSquare(n3 + 50 - 1, n4 + n7, n2);
                    if (isoGridSquare == null || isoGridSquare.getObjects().isEmpty()) continue;
                    IsoWorld.instance.CurrentCell.EnsureSurroundNotNull(isoGridSquare.x, isoGridSquare.y, n2);
                }
            }
            for (n2 = 0; n2 < 8; ++n2) {
                int n8;
                for (n8 = 0; n8 < 50; ++n8) {
                    isoGridSquare = instance.getGridSquare(n3 + n8, n4 + 0, n2);
                    if (isoGridSquare != null) {
                        isoGridSquare.RecalcAllWithNeighbours(true);
                    }
                    if ((isoGridSquare = instance.getGridSquare(n3 + n8, n6 - 1, n2)) == null) continue;
                    isoGridSquare.RecalcAllWithNeighbours(true);
                }
                for (n8 = 0; n8 < 50; ++n8) {
                    isoGridSquare = instance.getGridSquare(n3 + 0, n4 + n8, n2);
                    if (isoGridSquare != null) {
                        isoGridSquare.RecalcAllWithNeighbours(true);
                    }
                    if ((isoGridSquare = instance.getGridSquare(n5 - 1, n4 + n8, n2)) == null) continue;
                    isoGridSquare.RecalcAllWithNeighbours(true);
                }
            }
            n2 = 100;
            for (n = 0; n < 5; ++n) {
                for (int i = 0; i < 5; ++i) {
                    IsoChunk isoChunk = this.chunks[n][i];
                    if (isoChunk == null) continue;
                    isoChunk.bLoaded = true;
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k <= isoChunk.maxLevel; ++k) {
                            IsoGridSquare isoGridSquare2 = isoChunk.squares[k][j];
                            if (isoGridSquare2 == null) continue;
                            if (isoGridSquare2.getRoom() != null && !isoGridSquare2.getRoom().def.bExplored) {
                                this.UnexploredRooms.add(isoGridSquare2.getRoom().def);
                            }
                            isoGridSquare2.propertiesDirty = true;
                        }
                    }
                }
            }
            for (n = 0; n < 5; ++n) {
                for (int i = 0; i < 5; ++i) {
                    if (this.chunks[n][i] == null) continue;
                    this.chunks[n][i].doLoadGridsquare();
                }
            }
            for (RoomDef roomDef : this.UnexploredRooms) {
                ++roomDef.IndoorZombies;
                if (roomDef.IndoorZombies != 1) continue;
                try {
                    VirtualZombieManager.instance.tryAddIndoorZombies(roomDef, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.bLoaded = true;
        }

        public void Unload() {
            if (!this.bLoaded) {
                return;
            }
            if (MapLoading) {
                DebugLog.log(DebugType.MapLoading, "Unloading cell: " + this.WX + ", " + this.WY + " (" + instance.toWorldCellX(this.WX) + ", " + instance.toWorldCellX(this.WY) + ")");
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    IsoChunk isoChunk = this.chunks[i][j];
                    if (isoChunk == null) continue;
                    isoChunk.removeFromWorld();
                    isoChunk.m_loadVehiclesObject = null;
                    for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                        BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                        VehiclesDB2.instance.updateVehicle(baseVehicle);
                    }
                    chunkLoader.addSaveUnloadedJob(isoChunk);
                    this.chunks[i][j] = null;
                }
            }
            for (RoomDef roomDef : this.UnexploredRooms) {
                if (roomDef.IndoorZombies == 1) {
                    // empty if block
                }
                --roomDef.IndoorZombies;
            }
        }

        public void Save() {
            if (!this.bLoaded) {
                return;
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    IsoChunk isoChunk = this.chunks[i][j];
                    if (isoChunk == null) continue;
                    try {
                        chunkLoader.addSaveLoadedJob(isoChunk);
                        for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                            BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                            VehiclesDB2.instance.updateVehicle(baseVehicle);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LoggerManager.getLogger("map").write(exception);
                    }
                }
            }
            chunkLoader.updateSaved();
        }

        public void update() {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    IsoChunk isoChunk = this.chunks[i][j];
                    if (isoChunk == null) continue;
                    isoChunk.update();
                }
            }
            this.bPhysicsCheck = false;
        }

        public IsoChunk getChunk(int n, int n2) {
            IsoChunk isoChunk;
            if (n >= 0 && n < 5 && n2 >= 0 && n2 < 5 && (isoChunk = this.chunks[n][n2]) != null) {
                return isoChunk;
            }
            return null;
        }

        public int getWX() {
            return this.WX;
        }

        public int getWY() {
            return this.WY;
        }
    }

    private static class DistToCellComparator
    implements Comparator<ServerCell> {
        private Vector2[] pos = new Vector2[1024];
        private int posCount;

        public DistToCellComparator() {
            for (int i = 0; i < this.pos.length; ++i) {
                this.pos[i] = new Vector2();
            }
        }

        public void init() {
            this.posCount = 0;
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                if (!udpConnection.isFullyConnected()) continue;
                for (int j = 0; j < 4; ++j) {
                    if (udpConnection.players[j] == null) continue;
                    this.pos[this.posCount].set(udpConnection.players[j].x, udpConnection.players[j].y);
                    ++this.posCount;
                }
            }
        }

        @Override
        public int compare(ServerCell serverCell, ServerCell serverCell2) {
            float f = Float.MAX_VALUE;
            float f2 = Float.MAX_VALUE;
            for (int i = 0; i < this.posCount; ++i) {
                float f3 = this.pos[i].x;
                float f4 = this.pos[i].y;
                f = Math.min(f, this.distToCell(f3, f4, serverCell));
                f2 = Math.min(f2, this.distToCell(f3, f4, serverCell2));
            }
            if (f < f2) {
                return -1;
            }
            if (f > f2) {
                return 1;
            }
            return 0;
        }

        private float distToCell(float f, float f2, ServerCell serverCell) {
            int n = serverCell.WX * 50;
            int n2 = serverCell.WY * 50;
            int n3 = n + 50;
            int n4 = n2 + 50;
            float f3 = f;
            float f4 = f2;
            if (f < (float)n) {
                f3 = n;
            } else if (f > (float)n3) {
                f3 = n3;
            }
            if (f2 < (float)n2) {
                f4 = n2;
            } else if (f2 > (float)n4) {
                f4 = n4;
            }
            return IsoUtils.DistanceToSquared(f, f2, f3, f4);
        }
    }
}

