/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.util.ArrayList;
import zombie.characters.IsoPlayer;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoGridSquare;
import zombie.iso.LosUtil;
import zombie.network.MPStatistic;
import zombie.network.ServerMap;

public class ServerLOS {
    public static ServerLOS instance;
    private LOSThread thread;
    private ArrayList<PlayerData> playersMain = new ArrayList();
    private ArrayList<PlayerData> playersLOS = new ArrayList();
    private boolean bMapLoading = false;
    private boolean bSuspended = false;
    boolean bWasSuspended;

    private void noise(String string) {
    }

    public static void init() {
        instance = new ServerLOS();
        instance.start();
    }

    public void start() {
        this.thread = new LOSThread();
        this.thread.setName("LOS");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(IsoPlayer isoPlayer) {
        ArrayList<PlayerData> arrayList = this.playersMain;
        synchronized (arrayList) {
            if (this.findData(isoPlayer) != null) {
                return;
            }
            PlayerData playerData = new PlayerData(isoPlayer);
            this.playersMain.add(playerData);
            Object object = this.thread.notifier;
            synchronized (object) {
                this.thread.notifier.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(IsoPlayer isoPlayer) {
        ArrayList<PlayerData> arrayList = this.playersMain;
        synchronized (arrayList) {
            PlayerData playerData = this.findData(isoPlayer);
            this.playersMain.remove(playerData);
            Object object = this.thread.notifier;
            synchronized (object) {
                this.thread.notifier.notify();
            }
        }
    }

    public boolean isCouldSee(IsoPlayer isoPlayer, IsoGridSquare isoGridSquare) {
        PlayerData playerData = this.findData(isoPlayer);
        if (playerData != null) {
            int n = isoGridSquare.x - playerData.px + 50;
            int n2 = isoGridSquare.y - playerData.py + 50;
            if (n >= 0 && n < 100 && n2 >= 0 && n2 < 100) {
                return playerData.visible[n][n2][isoGridSquare.z];
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doServerZombieLOS(IsoPlayer isoPlayer) {
        if (!ServerMap.instance.bUpdateLOSThisFrame) {
            return;
        }
        PlayerData playerData = this.findData(isoPlayer);
        if (playerData == null) {
            return;
        }
        if (playerData.status == UpdateStatus.NeverDone) {
            playerData.status = UpdateStatus.ReadyInMain;
        }
        if (playerData.status == UpdateStatus.ReadyInMain) {
            playerData.status = UpdateStatus.WaitingInLOS;
            this.noise("WaitingInLOS playerID=" + isoPlayer.OnlineID);
            Object object = this.thread.notifier;
            synchronized (object) {
                this.thread.notifier.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLOS(IsoPlayer isoPlayer) {
        PlayerData playerData = this.findData(isoPlayer);
        if (playerData == null) {
            return;
        }
        if (playerData.status == UpdateStatus.ReadyInLOS || playerData.status == UpdateStatus.ReadyInMain) {
            if (playerData.status == UpdateStatus.ReadyInLOS) {
                this.noise("BusyInMain playerID=" + isoPlayer.OnlineID);
            }
            playerData.status = UpdateStatus.BusyInMain;
            isoPlayer.updateLOS();
            playerData.status = UpdateStatus.ReadyInMain;
            Object object = this.thread.notifier;
            synchronized (object) {
                this.thread.notifier.notify();
            }
        }
    }

    private PlayerData findData(IsoPlayer isoPlayer) {
        for (int i = 0; i < this.playersMain.size(); ++i) {
            if (this.playersMain.get((int)i).player != isoPlayer) continue;
            return this.playersMain.get(i);
        }
        return null;
    }

    public void suspend() {
        this.bMapLoading = true;
        this.bWasSuspended = this.bSuspended;
        while (!this.bSuspended) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.bWasSuspended) {
            this.noise("suspend **********");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.bMapLoading = false;
        Object object = this.thread.notifier;
        synchronized (object) {
            this.thread.notifier.notify();
        }
        if (!this.bWasSuspended) {
            this.noise("resume **********");
        }
    }

    private class LOSThread
    extends Thread {
        public Object notifier = new Object();

        private LOSThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.runInner();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInner() {
            MPStatistic.getInstance().ServerLOS.Start();
            ArrayList<PlayerData> arrayList = ServerLOS.this.playersMain;
            synchronized (arrayList) {
                ServerLOS.this.playersLOS.clear();
                ServerLOS.this.playersLOS.addAll(ServerLOS.this.playersMain);
            }
            for (int i = 0; i < ServerLOS.this.playersLOS.size(); ++i) {
                PlayerData playerData = ServerLOS.this.playersLOS.get(i);
                if (playerData.status == UpdateStatus.WaitingInLOS) {
                    playerData.status = UpdateStatus.BusyInLOS;
                    ServerLOS.this.noise("BusyInLOS playerID=" + playerData.player.OnlineID);
                    this.calcLOS(playerData);
                    playerData.status = UpdateStatus.ReadyInLOS;
                }
                if (ServerLOS.this.bMapLoading) break;
            }
            MPStatistic.getInstance().ServerLOS.End();
            while (this.shouldWait()) {
                ServerLOS.this.bSuspended = true;
                Object object = this.notifier;
                synchronized (object) {
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ServerLOS.this.bSuspended = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calcLOS(PlayerData playerData) {
            int n;
            int n2;
            int n3;
            boolean bl = false;
            if (playerData.px == (int)playerData.player.getX() && playerData.py == (int)playerData.player.getY() && playerData.pz == (int)playerData.player.getZ()) {
                bl = true;
            }
            playerData.px = (int)playerData.player.getX();
            playerData.py = (int)playerData.player.getY();
            playerData.pz = (int)playerData.player.getZ();
            playerData.player.initLightInfo2();
            if (bl) {
                return;
            }
            int n4 = 0;
            for (n3 = 0; n3 < LosUtil.XSIZE; ++n3) {
                for (n2 = 0; n2 < LosUtil.YSIZE; ++n2) {
                    for (n = 0; n < LosUtil.ZSIZE; ++n) {
                        LosUtil.cachedresults[n3][n2][n][n4] = 0;
                    }
                }
            }
            try {
                IsoPlayer.players[n4] = playerData.player;
                n3 = playerData.px;
                n2 = playerData.py;
                for (n = -50; n < 50; ++n) {
                    for (int i = -50; i < 50; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n + n3, i + n2, j);
                            if (isoGridSquare == null) continue;
                            isoGridSquare.CalcVisibility(n4);
                            playerData.visible[n + 50][i + 50][j] = isoGridSquare.isCouldSee(n4);
                            isoGridSquare.checkRoomSeen(n4);
                        }
                    }
                }
            }
            finally {
                IsoPlayer.players[n4] = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldWait() {
            if (ServerLOS.this.bMapLoading) {
                return true;
            }
            for (int i = 0; i < ServerLOS.this.playersLOS.size(); ++i) {
                PlayerData playerData = ServerLOS.this.playersLOS.get(i);
                if (playerData.status != UpdateStatus.WaitingInLOS) continue;
                return false;
            }
            ArrayList<PlayerData> arrayList = ServerLOS.this.playersMain;
            synchronized (arrayList) {
                if (ServerLOS.this.playersLOS.size() != ServerLOS.this.playersMain.size()) {
                    return false;
                }
            }
            return true;
        }
    }

    private class PlayerData {
        public IsoPlayer player;
        public UpdateStatus status = UpdateStatus.NeverDone;
        public int px;
        public int py;
        public int pz;
        public boolean[][][] visible = new boolean[100][100][8];

        public PlayerData(IsoPlayer isoPlayer) {
            this.player = isoPlayer;
        }
    }

    static enum UpdateStatus {
        NeverDone,
        WaitingInLOS,
        BusyInLOS,
        ReadyInLOS,
        BusyInMain,
        ReadyInMain;

    }

    public static final class ServerLighting
    implements IsoGridSquare.ILighting {
        private static final byte LOS_SEEN = 1;
        private static final byte LOS_COULD_SEE = 2;
        private static final byte LOS_CAN_SEE = 4;
        private static ColorInfo lightInfo = new ColorInfo();
        private byte los;

        @Override
        public int lightverts(int n) {
            return 0;
        }

        @Override
        public float lampostTotalR() {
            return 0.0f;
        }

        @Override
        public float lampostTotalG() {
            return 0.0f;
        }

        @Override
        public float lampostTotalB() {
            return 0.0f;
        }

        @Override
        public boolean bSeen() {
            return (this.los & 1) != 0;
        }

        @Override
        public boolean bCanSee() {
            return (this.los & 4) != 0;
        }

        @Override
        public boolean bCouldSee() {
            return (this.los & 2) != 0;
        }

        @Override
        public float darkMulti() {
            return 0.0f;
        }

        @Override
        public float targetDarkMulti() {
            return 0.0f;
        }

        @Override
        public ColorInfo lightInfo() {
            ServerLighting.lightInfo.r = 1.0f;
            ServerLighting.lightInfo.g = 1.0f;
            ServerLighting.lightInfo.b = 1.0f;
            return lightInfo;
        }

        @Override
        public void lightverts(int n, int n2) {
        }

        @Override
        public void lampostTotalR(float f) {
        }

        @Override
        public void lampostTotalG(float f) {
        }

        @Override
        public void lampostTotalB(float f) {
        }

        @Override
        public void bSeen(boolean bl) {
            this.los = bl ? (byte)(this.los | 1) : (byte)(this.los & 0xFFFFFFFE);
        }

        @Override
        public void bCanSee(boolean bl) {
            this.los = bl ? (byte)(this.los | 4) : (byte)(this.los & 0xFFFFFFFB);
        }

        @Override
        public void bCouldSee(boolean bl) {
            this.los = bl ? (byte)(this.los | 2) : (byte)(this.los & 0xFFFFFFFD);
        }

        @Override
        public void darkMulti(float f) {
        }

        @Override
        public void targetDarkMulti(float f) {
        }

        @Override
        public int resultLightCount() {
            return 0;
        }

        @Override
        public IsoGridSquare.ResultLight getResultLight(int n) {
            return null;
        }

        @Override
        public void reset() {
            this.los = 0;
        }
    }
}

