/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjglx.opengl.Display;
import org.lwjglx.opengl.DisplayMode;
import org.lwjglx.opengl.PixelFormat;
import zombie.GameWindow;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.WorldSoundManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.VBO.GLVertexBufferObject;
import zombie.core.opengl.RenderThread;
import zombie.core.physics.WorldSimulation;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TexturePackPage;
import zombie.debug.LineDrawer;
import zombie.gameStates.MainScreenState;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.PlayerCamera;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWindow;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.ui.TextManager;
import zombie.vehicles.BaseVehicle;

public class ServerGUI {
    private static boolean created;
    private static int minX;
    private static int minY;
    private static int maxX;
    private static int maxY;
    private static int maxZ;
    private static final ArrayList<IsoGridSquare> GridStack;
    private static final ArrayList<IsoGridSquare> MinusFloorCharacters;
    private static final ArrayList<IsoGridSquare> SolidFloor;
    private static final ArrayList<IsoGridSquare> VegetationCorpses;
    private static final ColorInfo defColorInfo;

    public static boolean isCreated() {
        return created;
    }

    public static void init() {
        created = true;
        try {
            Display.setFullscreen(false);
            Display.setResizable(false);
            Display.setVSyncEnabled(false);
            Display.setTitle("Project Zomboid Server");
            System.setProperty("org.lwjgl.opengl.Window.undecorated", "false");
            Core.width = 1366;
            Core.height = 768;
            Display.setDisplayMode(new DisplayMode(Core.width, Core.height));
            Display.create(new PixelFormat(32, 0, 24, 8, 0));
            Display.setIcon(MainScreenState.loadIcons());
            GLVertexBufferObject.init();
            Display.makeCurrent();
            SpriteRenderer.instance.create();
            TextManager.instance.Init();
            while (TextManager.instance.font.isEmpty()) {
                GameWindow.fileSystem.updateAsyncTransactions();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TexturePackPage.bIgnoreWorldItemTextures = true;
            int n = 2;
            GameWindow.LoadTexturePack("UI", n);
            GameWindow.LoadTexturePack("UI2", n);
            GameWindow.LoadTexturePack("IconsMoveables", n);
            GameWindow.LoadTexturePack("RadioIcons", n);
            GameWindow.LoadTexturePack("ApComUI", n);
            GameWindow.LoadTexturePack("WeatherFx", n);
            TexturePackPage.bIgnoreWorldItemTextures = false;
            n = 0;
            GameWindow.LoadTexturePack("Tiles2x", n);
            GameWindow.LoadTexturePack("JumboTrees2x", n);
            GameWindow.LoadTexturePack("Overlays2x", n);
            GameWindow.LoadTexturePack("Tiles2x.floor", 0);
            GameWindow.DoLoadingText("");
            GameWindow.setTexturePackLookup();
            IsoObjectPicker.Instance.Init();
            Display.makeCurrent();
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Display.releaseContext();
            RenderThread.initServerGUI();
            RenderThread.startRendering();
            Core.getInstance().initFBOs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            created = false;
            return;
        }
    }

    public static void init2() {
        if (!created) {
            return;
        }
        BaseVehicle.LoadAllVehicleTextures();
    }

    public static void shutdown() {
        if (!created) {
            return;
        }
        RenderThread.shutdown();
    }

    public static void update() {
        int n;
        if (!created) {
            return;
        }
        Mouse.update();
        GameKeyboard.update();
        Display.processMessages();
        if (RenderThread.isCloseRequested()) {
            // empty if block
        }
        if ((n = Mouse.getWheelState()) != 0) {
            int n2 = n - 0 < 0 ? 1 : -1;
            Core.getInstance().doZoomScroll(0, n2);
        }
        n = 0;
        IsoPlayer isoPlayer = ServerGUI.getPlayerToFollow();
        if (isoPlayer == null) {
            Core.getInstance().StartFrame();
            Core.getInstance().EndFrame();
            Core.getInstance().StartFrameUI();
            SpriteRenderer.instance.renderi(null, 0, 0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), 0.0f, 0.0f, 0.0f, 1.0f, null);
            Core.getInstance().EndFrameUI();
            return;
        }
        IsoPlayer.setInstance(isoPlayer);
        IsoPlayer.players[n] = isoPlayer;
        IsoCamera.CamCharacter = isoPlayer;
        Core.getInstance().StartFrame(n, true);
        ServerGUI.renderWorld();
        Core.getInstance().EndFrame(n);
        Core.getInstance().RenderOffScreenBuffer();
        Core.getInstance().StartFrameUI();
        ServerGUI.renderUI();
        Core.getInstance().EndFrameUI();
    }

    private static IsoPlayer getPlayerToFollow() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.isFullyConnected()) continue;
            for (int j = 0; j < 4; ++j) {
                IsoPlayer isoPlayer = udpConnection.players[j];
                if (isoPlayer == null || isoPlayer.OnlineID == -1) continue;
                return isoPlayer;
            }
        }
        return null;
    }

    private static void updateCamera(IsoPlayer isoPlayer) {
        IsoPlayer isoPlayer2 = isoPlayer;
        int n = 0;
        PlayerCamera playerCamera = IsoCamera.cameras[n];
        float f = IsoUtils.XToScreen(isoPlayer2.x + playerCamera.DeferedX, isoPlayer2.y + playerCamera.DeferedY, isoPlayer2.z, 0);
        float f2 = IsoUtils.YToScreen(isoPlayer2.x + playerCamera.DeferedX, isoPlayer2.y + playerCamera.DeferedY, isoPlayer2.z, 0);
        f -= (float)(IsoCamera.getOffscreenWidth(n) / 2);
        f2 -= (float)(IsoCamera.getOffscreenHeight(n) / 2);
        f2 -= isoPlayer2.getOffsetY() * 1.5f;
        playerCamera.OffX = f += (float)IsoCamera.PLAYER_OFFSET_X;
        playerCamera.OffY = f2 += (float)IsoCamera.PLAYER_OFFSET_Y;
        IsoCamera.FrameState frameState = IsoCamera.frameState;
        frameState.Paused = false;
        frameState.playerIndex = n;
        frameState.CamCharacter = isoPlayer;
        frameState.CamCharacterX = IsoCamera.CamCharacter.getX();
        frameState.CamCharacterY = IsoCamera.CamCharacter.getY();
        frameState.CamCharacterZ = IsoCamera.CamCharacter.getZ();
        frameState.CamCharacterSquare = IsoCamera.CamCharacter.getCurrentSquare();
        frameState.CamCharacterRoom = frameState.CamCharacterSquare == null ? null : frameState.CamCharacterSquare.getRoom();
        frameState.OffX = IsoCamera.getOffX();
        frameState.OffY = IsoCamera.getOffY();
        frameState.OffscreenWidth = IsoCamera.getOffscreenWidth(n);
        frameState.OffscreenHeight = IsoCamera.getOffscreenHeight(n);
    }

    private static void renderWorld() {
        IsoObject isoObject;
        int n;
        IsoPlayer isoPlayer = ServerGUI.getPlayerToFollow();
        if (isoPlayer == null) {
            return;
        }
        int n2 = 0;
        IsoPlayer.setInstance(isoPlayer);
        IsoPlayer.players[0] = isoPlayer;
        IsoCamera.CamCharacter = isoPlayer;
        ServerGUI.updateCamera(isoPlayer);
        SpriteRenderer.instance.doCoreIntParam(0, IsoCamera.CamCharacter.x);
        SpriteRenderer.instance.doCoreIntParam(1, IsoCamera.CamCharacter.y);
        SpriteRenderer.instance.doCoreIntParam(2, IsoCamera.CamCharacter.z);
        IsoWorld.instance.sceneCullZombies();
        IsoSprite.globalOffsetX = -1.0f;
        int n3 = 0;
        int n4 = 0;
        int n5 = n3 + IsoCamera.getOffscreenWidth(n2);
        int n6 = n4 + IsoCamera.getOffscreenHeight(n2);
        float f = IsoUtils.XToIso(n3, n4, 0.0f);
        float f2 = IsoUtils.YToIso(n5, n4, 0.0f);
        float f3 = IsoUtils.XToIso(n5, n6, 6.0f);
        float f4 = IsoUtils.YToIso(n3, n6, 6.0f);
        minY = (int)f2;
        maxY = (int)f4;
        minX = (int)f;
        maxX = (int)f3;
        minX -= 2;
        minY -= 2;
        maxZ = (int)isoPlayer.getZ();
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        isoCell.DrawStencilMask();
        IsoObjectPicker.Instance.StartRender();
        ServerGUI.RenderTiles();
        for (n = 0; n < isoCell.getObjectList().size(); ++n) {
            isoObject = isoCell.getObjectList().get(n);
            ((IsoMovingObject)isoObject).renderlast();
        }
        for (n = 0; n < isoCell.getStaticUpdaterObjectList().size(); ++n) {
            isoObject = isoCell.getStaticUpdaterObjectList().get(n);
            isoObject.renderlast();
        }
        if (WorldSimulation.instance.created) {
            TextureDraw.GenericDrawer genericDrawer = WorldSimulation.getDrawer(n2);
            SpriteRenderer.instance.drawGeneric(genericDrawer);
        }
        WorldSoundManager.instance.render();
        LineDrawer.clear();
    }

    private static void RenderTiles() {
        IsoCell.PerPlayerRender perPlayerRender;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        if (IsoCell.perPlayerRender[0] == null) {
            IsoCell.perPlayerRender[0] = new IsoCell.PerPlayerRender();
        }
        if ((perPlayerRender = IsoCell.perPlayerRender[0]) == null) {
            IsoCell.perPlayerRender[0] = new IsoCell.PerPlayerRender();
        }
        perPlayerRender.setSize(maxX - minX + 1, maxY - minY + 1);
        short[][][] sArray = perPlayerRender.StencilValues;
        for (int i = 0; i <= maxZ; ++i) {
            Object object;
            int n;
            int n2;
            GridStack.clear();
            for (n2 = minY; n2 < maxY; ++n2) {
                int n3 = minX;
                IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n3, n2, i);
                n = IsoDirections.E.index();
                while (n3 < maxX) {
                    if (i == 0) {
                        sArray[n3 - ServerGUI.minX][n2 - ServerGUI.minY][0] = 0;
                        sArray[n3 - ServerGUI.minX][n2 - ServerGUI.minY][1] = 0;
                    }
                    if (isoGridSquare != null && isoGridSquare.getY() != n2) {
                        isoGridSquare = null;
                    }
                    if (isoGridSquare == null && (isoGridSquare = ServerMap.instance.getGridSquare(n3, n2, i)) == null) {
                        ++n3;
                        continue;
                    }
                    object = isoGridSquare.getChunk();
                    if (object != null && isoGridSquare.IsOnScreen()) {
                        GridStack.add(isoGridSquare);
                    }
                    isoGridSquare = isoGridSquare.nav[n];
                    ++n3;
                }
            }
            SolidFloor.clear();
            VegetationCorpses.clear();
            MinusFloorCharacters.clear();
            for (n2 = 0; n2 < GridStack.size(); ++n2) {
                IsoGridSquare isoGridSquare = GridStack.get(n2);
                isoGridSquare.setLightInfoServerGUIOnly(defColorInfo);
                int n4 = ServerGUI.renderFloor(isoGridSquare);
                if (!isoGridSquare.getStaticMovingObjects().isEmpty()) {
                    n4 |= 2;
                }
                for (n = 0; n < isoGridSquare.getMovingObjects().size(); ++n) {
                    object = isoGridSquare.getMovingObjects().get(n);
                    boolean bl = ((IsoMovingObject)object).isOnFloor();
                    if (bl && object instanceof IsoZombie) {
                        IsoZombie isoZombie = (IsoZombie)object;
                        boolean bl2 = bl = isoZombie.bCrawling || isoZombie.legsSprite.CurrentAnim != null && isoZombie.legsSprite.CurrentAnim.name.equals("ZombieDeath") && isoZombie.def.isFinished();
                    }
                    if (bl) {
                        n4 |= 2;
                        continue;
                    }
                    n4 |= 4;
                }
                if ((n4 & 1) != 0) {
                    SolidFloor.add(isoGridSquare);
                }
                if ((n4 & 2) != 0) {
                    VegetationCorpses.add(isoGridSquare);
                }
                if ((n4 & 4) == 0) continue;
                MinusFloorCharacters.add(isoGridSquare);
            }
            LuaEventManager.triggerEvent("OnPostFloorLayerDraw", i);
            for (n2 = 0; n2 < VegetationCorpses.size(); ++n2) {
                IsoGridSquare isoGridSquare = VegetationCorpses.get(n2);
                ServerGUI.renderMinusFloor(isoGridSquare, false, true);
                ServerGUI.renderCharacters(isoGridSquare, true);
            }
            for (n2 = 0; n2 < MinusFloorCharacters.size(); ++n2) {
                IsoGridSquare isoGridSquare = MinusFloorCharacters.get(n2);
                boolean bl = ServerGUI.renderMinusFloor(isoGridSquare, false, false);
                ServerGUI.renderCharacters(isoGridSquare, false);
                if (!bl) continue;
                ServerGUI.renderMinusFloor(isoGridSquare, true, false);
            }
        }
        MinusFloorCharacters.clear();
        SolidFloor.clear();
        VegetationCorpses.clear();
    }

    private static int renderFloor(IsoGridSquare isoGridSquare) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            boolean bl = true;
            if (isoObject.sprite != null && !isoObject.sprite.Properties.Is(IsoFlagType.solidfloor)) {
                bl = false;
                n |= 4;
            }
            if (bl) {
                IndieGL.glAlphaFunc(516, 0.0f);
                isoObject.setAlphaAndTarget(n2, 1.0f);
                isoObject.render(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, defColorInfo, true, false, null);
                isoObject.renderObjectPicker(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, defColorInfo);
                if ((isoObject.highlightFlags & 2) != 0) {
                    isoObject.highlightFlags = (byte)(isoObject.highlightFlags & 0xFFFFFFFE);
                }
                n |= 1;
            }
            if (bl || isoObject.sprite == null || !isoObject.sprite.Properties.Is(IsoFlagType.canBeRemoved) && !isoObject.sprite.Properties.Is(IsoFlagType.attachedFloor)) continue;
            n |= 2;
        }
        return n;
    }

    private static boolean isSpriteOnSouthOrEastWall(IsoObject isoObject) {
        if (isoObject instanceof IsoBarricade) {
            return isoObject.getDir() == IsoDirections.S || isoObject.getDir() == IsoDirections.E;
        }
        if (isoObject instanceof IsoCurtain) {
            IsoCurtain isoCurtain = (IsoCurtain)isoObject;
            return isoCurtain.getType() == IsoObjectType.curtainS || isoCurtain.getType() == IsoObjectType.curtainE;
        }
        PropertyContainer propertyContainer = isoObject.getProperties();
        return propertyContainer != null && (propertyContainer.Is(IsoFlagType.attachedE) || propertyContainer.Is(IsoFlagType.attachedS));
    }

    private static int DoWallLightingN(IsoGridSquare isoGridSquare, IsoObject isoObject, int n) {
        isoObject.render(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, defColorInfo, true, false, null);
        return n;
    }

    private static int DoWallLightingW(IsoGridSquare isoGridSquare, IsoObject isoObject, int n) {
        isoObject.render(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, defColorInfo, true, false, null);
        return n;
    }

    private static int DoWallLightingNW(IsoGridSquare isoGridSquare, IsoObject isoObject, int n) {
        isoObject.render(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, defColorInfo, true, false, null);
        return n;
    }

    private static boolean renderMinusFloor(IsoGridSquare isoGridSquare, boolean bl, boolean bl2) {
        int n = bl ? isoGridSquare.getObjects().size() - 1 : 0;
        int n2 = bl ? 0 : isoGridSquare.getObjects().size() - 1;
        int n3 = IsoCamera.frameState.playerIndex;
        IsoGridSquare isoGridSquare2 = IsoCamera.frameState.CamCharacterSquare;
        IsoRoom isoRoom = IsoCamera.frameState.CamCharacterRoom;
        int n4 = (int)(IsoUtils.XToScreenInt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, 0) - IsoCamera.frameState.OffX);
        int n5 = (int)(IsoUtils.YToScreenInt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, 0) - IsoCamera.frameState.OffY);
        boolean bl3 = true;
        IsoCell isoCell = isoGridSquare.getCell();
        if (n4 + 32 * Core.TileScale <= isoCell.StencilX1 || n4 - 32 * Core.TileScale >= isoCell.StencilX2 || n5 + 32 * Core.TileScale <= isoCell.StencilY1 || n5 - 96 * Core.TileScale >= isoCell.StencilY2) {
            bl3 = false;
        }
        int n6 = 0;
        boolean bl4 = false;
        int n7 = n;
        while (bl ? n7 >= n2 : n7 <= n2) {
            IsoObject isoObject = isoGridSquare.getObjects().get(n7);
            boolean bl5 = true;
            IsoGridSquare.CircleStencil = false;
            if (isoObject.sprite != null && isoObject.sprite.getProperties().Is(IsoFlagType.solidfloor)) {
                bl5 = false;
            }
            if ((!bl2 || isoObject.sprite == null || isoObject.sprite.Properties.Is(IsoFlagType.canBeRemoved) || isoObject.sprite.Properties.Is(IsoFlagType.attachedFloor)) && (bl2 || isoObject.sprite == null || !isoObject.sprite.Properties.Is(IsoFlagType.canBeRemoved) && !isoObject.sprite.Properties.Is(IsoFlagType.attachedFloor))) {
                if (isoObject.sprite != null && (isoObject.sprite.getType() == IsoObjectType.WestRoofB || isoObject.sprite.getType() == IsoObjectType.WestRoofM || isoObject.sprite.getType() == IsoObjectType.WestRoofT) && isoGridSquare.z == maxZ && isoGridSquare.z == (int)IsoCamera.CamCharacter.getZ()) {
                    bl5 = false;
                }
                if (IsoCamera.CamCharacter.isClimbing() && isoObject.sprite != null && !isoObject.sprite.getProperties().Is(IsoFlagType.solidfloor)) {
                    bl5 = true;
                }
                if (ServerGUI.isSpriteOnSouthOrEastWall(isoObject)) {
                    if (!bl) {
                        bl5 = false;
                    }
                    bl4 = true;
                } else if (bl) {
                    bl5 = false;
                }
                if (bl5) {
                    IndieGL.glAlphaFunc(516, 0.0f);
                    if (isoObject.sprite != null && !isoGridSquare.getProperties().Is(IsoFlagType.blueprint) && (isoObject.sprite.getType() == IsoObjectType.doorFrW || isoObject.sprite.getType() == IsoObjectType.doorFrN || isoObject.sprite.getType() == IsoObjectType.doorW || isoObject.sprite.getType() == IsoObjectType.doorN || isoObject.sprite.getProperties().Is(IsoFlagType.cutW) || isoObject.sprite.getProperties().Is(IsoFlagType.cutN)) && PerformanceSettings.LightingFrameSkip < 3) {
                        if (isoObject.getTargetAlpha(n3) < 1.0f) {
                            boolean bl6 = false;
                            if (bl6) {
                                IsoGridSquare isoGridSquare3;
                                if (isoObject.sprite.getProperties().Is(IsoFlagType.cutW) && isoGridSquare.getProperties().Is(IsoFlagType.WallSE)) {
                                    IsoGridSquare isoGridSquare4 = isoGridSquare.nav[IsoDirections.NW.index()];
                                    if (isoGridSquare4 == null || isoGridSquare4.getRoom() == null) {
                                        bl6 = false;
                                    }
                                } else if (isoObject.sprite.getType() == IsoObjectType.doorFrW || isoObject.sprite.getType() == IsoObjectType.doorW || isoObject.sprite.getProperties().Is(IsoFlagType.cutW)) {
                                    IsoGridSquare isoGridSquare5 = isoGridSquare.nav[IsoDirections.W.index()];
                                    if (isoGridSquare5 == null || isoGridSquare5.getRoom() == null) {
                                        bl6 = false;
                                    }
                                } else if (!(isoObject.sprite.getType() != IsoObjectType.doorFrN && isoObject.sprite.getType() != IsoObjectType.doorN && !isoObject.sprite.getProperties().Is(IsoFlagType.cutN) || (isoGridSquare3 = isoGridSquare.nav[IsoDirections.N.index()]) != null && isoGridSquare3.getRoom() != null)) {
                                    bl6 = false;
                                }
                            }
                            if (!bl6) {
                                IsoGridSquare.CircleStencil = bl3;
                            }
                            isoObject.setAlphaAndTarget(n3, 1.0f);
                        }
                        if (isoObject.sprite.getProperties().Is(IsoFlagType.cutW) && isoObject.sprite.getProperties().Is(IsoFlagType.cutN)) {
                            n6 = ServerGUI.DoWallLightingNW(isoGridSquare, isoObject, n6);
                        } else if (isoObject.sprite.getType() == IsoObjectType.doorFrW || isoObject.sprite.getType() == IsoObjectType.doorW || isoObject.sprite.getProperties().Is(IsoFlagType.cutW)) {
                            n6 = ServerGUI.DoWallLightingW(isoGridSquare, isoObject, n6);
                        } else if (isoObject.sprite.getType() == IsoObjectType.doorFrN || isoObject.sprite.getType() == IsoObjectType.doorN || isoObject.sprite.getProperties().Is(IsoFlagType.cutN)) {
                            n6 = ServerGUI.DoWallLightingN(isoGridSquare, isoObject, n6);
                        }
                    } else {
                        IsoWindow isoWindow;
                        IsoGridSquare isoGridSquare6;
                        if (isoGridSquare2 != null) {
                            // empty if block
                        }
                        isoObject.setTargetAlpha(n3, 1.0f);
                        if (IsoCamera.CamCharacter != null && isoObject.getProperties() != null && (isoObject.getProperties().Is(IsoFlagType.solid) || isoObject.getProperties().Is(IsoFlagType.solidtrans))) {
                            int n8 = isoGridSquare.getX() - (int)IsoCamera.CamCharacter.getX();
                            int n9 = isoGridSquare.getY() - (int)IsoCamera.CamCharacter.getY();
                            if (n8 > 0 && n8 < 3 && n9 >= 0 && n9 < 3 || n9 > 0 && n9 < 3 && n8 >= 0 && n8 < 3) {
                                isoObject.setTargetAlpha(n3, 0.99f);
                            }
                        }
                        if (isoObject instanceof IsoWindow && isoObject.getTargetAlpha(n3) < 1.0E-4f && (isoGridSquare6 = (isoWindow = (IsoWindow)isoObject).getOppositeSquare()) != null && isoGridSquare6 != isoGridSquare && isoGridSquare6.lighting[n3].bSeen()) {
                            isoObject.setTargetAlpha(n3, isoGridSquare6.lighting[n3].darkMulti() * 2.0f);
                        }
                        if (isoObject instanceof IsoTree) {
                            ((IsoTree)isoObject).bRenderFlag = bl3 && isoGridSquare.x >= (int)IsoCamera.frameState.CamCharacterX && isoGridSquare.y >= (int)IsoCamera.frameState.CamCharacterY && isoGridSquare2 != null && isoGridSquare2.Is(IsoFlagType.exterior);
                        }
                        isoObject.render(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, defColorInfo, true, false, null);
                    }
                    if (isoObject.sprite != null) {
                        isoObject.renderObjectPicker(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, defColorInfo);
                    }
                    if ((isoObject.highlightFlags & 2) != 0) {
                        isoObject.highlightFlags = (byte)(isoObject.highlightFlags & 0xFFFFFFFE);
                    }
                }
            }
            n7 += bl ? -1 : 1;
        }
        return bl4;
    }

    private static void renderCharacters(IsoGridSquare isoGridSquare, boolean bl) {
        IsoMovingObject isoMovingObject;
        int n;
        int n2 = isoGridSquare.getStaticMovingObjects().size();
        for (n = 0; n < n2; ++n) {
            isoMovingObject = isoGridSquare.getStaticMovingObjects().get(n);
            if (isoMovingObject.sprite == null || bl && !(isoMovingObject instanceof IsoDeadBody) || !bl && isoMovingObject instanceof IsoDeadBody) continue;
            isoMovingObject.render(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ(), defColorInfo, true, false, null);
            isoMovingObject.renderObjectPicker(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ(), defColorInfo);
        }
        n2 = isoGridSquare.getMovingObjects().size();
        for (n = 0; n < n2; ++n) {
            IsoGameCharacter isoGameCharacter;
            isoMovingObject = isoGridSquare.getMovingObjects().get(n);
            if (isoMovingObject == null || isoMovingObject.sprite == null) continue;
            boolean bl2 = isoMovingObject.isOnFloor();
            if (bl2 && isoMovingObject instanceof IsoZombie) {
                isoGameCharacter = (IsoZombie)isoMovingObject;
                boolean bl3 = bl2 = ((IsoZombie)isoGameCharacter).bCrawling || ((IsoZombie)isoGameCharacter).legsSprite.CurrentAnim != null && ((IsoZombie)isoGameCharacter).legsSprite.CurrentAnim.name.equals("ZombieDeath") && ((IsoZombie)isoGameCharacter).def.isFinished();
            }
            if (bl && !bl2 || !bl && bl2) continue;
            isoMovingObject.setAlphaAndTarget(0, 1.0f);
            if (isoMovingObject instanceof IsoGameCharacter) {
                isoGameCharacter = (IsoGameCharacter)isoMovingObject;
                isoGameCharacter.renderServerGUI();
            } else {
                isoMovingObject.render(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ(), defColorInfo, true, false, null);
            }
            isoMovingObject.renderObjectPicker(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ(), defColorInfo);
        }
    }

    private static void renderUI() {
    }

    static {
        GridStack = new ArrayList();
        MinusFloorCharacters = new ArrayList(1000);
        SolidFloor = new ArrayList(5000);
        VegetationCorpses = new ArrayList(5000);
        defColorInfo = new ColorInfo();
    }
}

