/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.core.Translator;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.gameStates.GameLoadingState;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.packets.RequestDataPacket;

public class RequestDataManager {
    public static final int smallFileSize = 1024;
    public static final int maxLargeFileSize = 0x3200000;
    public static final int packSize = 204800;
    private final ArrayList<RequestData> requests = new ArrayList();
    private static RequestDataManager instance;

    private RequestDataManager() {
    }

    public static RequestDataManager getInstance() {
        if (instance == null) {
            instance = new RequestDataManager();
        }
        return instance;
    }

    public void ACKWasReceived(RequestDataPacket.RequestID requestID, UdpConnection udpConnection, int n) {
        RequestData requestData = null;
        for (int i = 0; i <= this.requests.size(); ++i) {
            if (this.requests.get((int)i).connectionGUID != udpConnection.getConnectedGUID()) continue;
            requestData = this.requests.get(i);
            break;
        }
        if (requestData == null || requestData.id != requestID) {
            return;
        }
        this.sendData(requestData);
    }

    public void putDataForTransmit(RequestDataPacket.RequestID requestID, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        RequestData requestData = new RequestData(requestID, byteBuffer, udpConnection.getConnectedGUID());
        this.requests.add(requestData);
        this.sendData(requestData);
    }

    public void disconnect(UdpConnection udpConnection) {
        long l = System.currentTimeMillis();
        this.requests.removeIf(requestData -> l - requestData.creationTime > 60000L || requestData.connectionGUID == udpConnection.getConnectedGUID());
    }

    public void clear() {
        this.requests.clear();
    }

    private void sendData(RequestData requestData) {
        int n;
        requestData.creationTime = System.currentTimeMillis();
        int n2 = requestData.bb.limit();
        requestData.realTransmittedFromLastACK = 0;
        UdpConnection udpConnection = GameServer.udpEngine.getActiveConnection(requestData.connectionGUID);
        RequestDataPacket requestDataPacket = new RequestDataPacket();
        requestDataPacket.setPartData(requestData.id, requestData.bb);
        while (requestData.realTransmittedFromLastACK < 204800 && (n = Math.min(1024, n2 - requestData.realTransmitted)) != 0) {
            requestDataPacket.setPartDataParameters(requestData.realTransmitted, n);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.RequestData.doPacket(byteBufferWriter);
            requestDataPacket.write(byteBufferWriter);
            PacketTypes.PacketType.RequestData.send(udpConnection);
            requestData.realTransmittedFromLastACK += n;
            requestData.realTransmitted += n;
        }
        if (requestData.realTransmitted == n2) {
            this.requests.remove(requestData);
        }
    }

    public ByteBuffer receiveClientData(RequestDataPacket.RequestID requestID, ByteBuffer byteBuffer, int n, int n2) {
        RequestData requestData = null;
        for (int i = 0; i < this.requests.size(); ++i) {
            if (this.requests.get((int)i).id != requestID) continue;
            requestData = this.requests.get(i);
            break;
        }
        if (requestData == null) {
            requestData = new RequestData(requestID, n, 0L);
            this.requests.add(requestData);
        }
        requestData.bb.position(n2);
        requestData.bb.put(byteBuffer.array(), 0, byteBuffer.limit());
        requestData.realTransmitted += byteBuffer.limit();
        requestData.realTransmittedFromLastACK += byteBuffer.limit();
        if (requestData.realTransmittedFromLastACK >= 204800) {
            requestData.realTransmittedFromLastACK = 0;
            RequestDataPacket requestDataPacket = new RequestDataPacket();
            requestDataPacket.setACK(requestData.id);
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.RequestData.doPacket(byteBufferWriter);
            requestDataPacket.write(byteBufferWriter);
            PacketTypes.PacketType.RequestData.send(GameClient.connection);
        }
        GameLoadingState.GameLoadingString = Translator.getText("IGUI_MP_DownloadedLargeFile", requestData.realTransmitted * 100 / n, requestData.id.getDescriptor());
        if (requestData.realTransmitted == n) {
            this.requests.remove(requestData);
            requestData.bb.position(0);
            return requestData.bb;
        }
        return null;
    }

    static class RequestData {
        private final RequestDataPacket.RequestID id;
        private final ByteBuffer bb;
        private final long connectionGUID;
        private long creationTime = System.currentTimeMillis();
        private int realTransmitted;
        private int realTransmittedFromLastACK;

        public RequestData(RequestDataPacket.RequestID requestID, ByteBuffer byteBuffer, long l) {
            this.id = requestID;
            this.bb = ByteBuffer.allocate(byteBuffer.position());
            this.bb.put(byteBuffer.array(), 0, this.bb.limit());
            this.connectionGUID = l;
            this.realTransmitted = 0;
            this.realTransmittedFromLastACK = 0;
        }

        public RequestData(RequestDataPacket.RequestID requestID, int n, long l) {
            this.id = requestID;
            this.bb = ByteBuffer.allocate(n);
            this.bb.clear();
            this.connectionGUID = l;
            this.realTransmitted = 0;
            this.realTransmittedFromLastACK = 0;
        }
    }
}

