/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.debug.DebugLog;
import zombie.network.GameServer;

public class RCONServer {
    public static final int SERVERDATA_RESPONSE_VALUE = 0;
    public static final int SERVERDATA_AUTH_RESPONSE = 2;
    public static final int SERVERDATA_EXECCOMMAND = 2;
    public static final int SERVERDATA_AUTH = 3;
    private static RCONServer instance;
    private ServerSocket welcomeSocket;
    private ServerThread thread;
    private String password;
    private ConcurrentLinkedQueue<ExecCommand> toMain = new ConcurrentLinkedQueue();

    private RCONServer(int n, String string, boolean bl) {
        this.password = string;
        try {
            this.welcomeSocket = new ServerSocket();
            if (bl) {
                this.welcomeSocket.bind(new InetSocketAddress("127.0.0.1", n));
            } else if (GameServer.IPCommandline != null) {
                this.welcomeSocket.bind(new InetSocketAddress(GameServer.IPCommandline, n));
            } else {
                this.welcomeSocket.bind(new InetSocketAddress(n));
            }
            DebugLog.log("RCON: listening on port " + n);
        }
        catch (IOException iOException) {
            DebugLog.log("RCON: error creating socket on port " + n);
            iOException.printStackTrace();
            try {
                this.welcomeSocket.close();
                this.welcomeSocket = null;
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            return;
        }
        this.thread = new ServerThread();
        this.thread.start();
    }

    private void updateMain() {
        ExecCommand execCommand = this.toMain.poll();
        while (execCommand != null) {
            execCommand.update();
            execCommand = this.toMain.poll();
        }
    }

    public void quit() {
        if (this.welcomeSocket != null) {
            try {
                this.welcomeSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.welcomeSocket = null;
            this.thread.quit();
            this.thread = null;
        }
    }

    public static void init(int n, String string, boolean bl) {
        instance = new RCONServer(n, string, bl);
    }

    public static void update() {
        if (instance != null) {
            instance.updateMain();
        }
    }

    public static void shutdown() {
        if (instance != null) {
            instance.quit();
        }
    }

    private class ServerThread
    extends Thread {
        private ArrayList<ClientThread> connections = new ArrayList();
        public boolean bQuit;

        public ServerThread() {
            this.setName("RCONServer");
        }

        @Override
        public void run() {
            while (!this.bQuit) {
                this.runInner();
            }
        }

        private void runInner() {
            block4: {
                try {
                    Socket socket = RCONServer.this.welcomeSocket.accept();
                    for (int i = 0; i < this.connections.size(); ++i) {
                        ClientThread clientThread = this.connections.get(i);
                        if (clientThread.isAlive()) continue;
                        this.connections.remove(i--);
                    }
                    if (this.connections.size() >= 5) {
                        socket.close();
                        return;
                    }
                    DebugLog.log("RCON: new connection " + socket.toString());
                    ClientThread clientThread = new ClientThread(socket, RCONServer.this.password);
                    this.connections.add(clientThread);
                    clientThread.start();
                }
                catch (IOException iOException) {
                    if (this.bQuit) break block4;
                    iOException.printStackTrace();
                }
            }
        }

        public void quit() {
            this.bQuit = true;
            while (this.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            for (int i = 0; i < this.connections.size(); ++i) {
                ClientThread clientThread = this.connections.get(i);
                clientThread.quit();
            }
        }
    }

    private static class ExecCommand {
        public int ID;
        public String command;
        public String response;
        public ClientThread thread;

        public ExecCommand(int n, String string, ClientThread clientThread) {
            this.ID = n;
            this.command = string;
            this.thread = clientThread;
        }

        public void update() {
            this.response = GameServer.rcon(this.command);
            if (this.thread.isAlive()) {
                this.thread.toThread.add(this);
            }
        }
    }

    private static class ClientThread
    extends Thread {
        public Socket socket;
        public boolean bAuth;
        public boolean bQuit;
        private String password;
        private InputStream in;
        private OutputStream out;
        private ConcurrentLinkedQueue<ExecCommand> toThread = new ConcurrentLinkedQueue();
        private int pendingCommands;

        public ClientThread(Socket socket, String string) {
            this.socket = socket;
            this.password = string;
            try {
                this.in = socket.getInputStream();
                this.out = socket.getOutputStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setName("RCONClient" + socket.getLocalPort());
        }

        @Override
        public void run() {
            if (this.in == null) {
                return;
            }
            if (this.out == null) {
                return;
            }
            while (!this.bQuit) {
                try {
                    this.runInner();
                }
                catch (SocketException socketException) {
                    this.bQuit = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            DebugLog.log("RCON: connection closed " + this.socket.toString());
        }

        private void runInner() throws IOException {
            int n;
            byte[] byArray = new byte[4];
            int n2 = this.in.read(byArray, 0, 4);
            if (n2 < 0) {
                this.bQuit = true;
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n3 = n = byteBuffer.getInt();
            byte[] byArray2 = new byte[n];
            do {
                if ((n2 = this.in.read(byArray2, n - n3, n3)) >= 0) continue;
                this.bQuit = true;
                return;
            } while ((n3 -= n2) > 0);
            byteBuffer = ByteBuffer.wrap(byArray2);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            String string = new String(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit() - byteBuffer.position() - 2);
            this.handlePacket(n4, n5, string);
        }

        private void handlePacket(int n, int n2, String string) throws IOException {
            if (!"players".equals(string)) {
                DebugLog.log("RCON: ID=" + n + " Type=" + n2 + " Body='" + string + "' " + this.socket.toString());
            }
            switch (n2) {
                case 3: {
                    this.bAuth = string.equals(this.password);
                    if (!this.bAuth) {
                        DebugLog.log("RCON: password doesn't match");
                        this.bQuit = true;
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate(14);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.putInt(byteBuffer.capacity() - 4);
                    byteBuffer.putInt(n);
                    byteBuffer.putInt(0);
                    byteBuffer.putShort((short)0);
                    this.out.write(byteBuffer.array());
                    byteBuffer.clear();
                    byteBuffer.putInt(byteBuffer.capacity() - 4);
                    byteBuffer.putInt(this.bAuth ? n : -1);
                    byteBuffer.putInt(2);
                    byteBuffer.putShort((short)0);
                    this.out.write(byteBuffer.array());
                    break;
                }
                case 2: {
                    if (!this.checkAuth()) break;
                    ExecCommand execCommand = new ExecCommand(n, string, this);
                    ++this.pendingCommands;
                    RCONServer.instance.toMain.add(execCommand);
                    while (this.pendingCommands > 0) {
                        execCommand = this.toThread.poll();
                        if (execCommand != null) {
                            --this.pendingCommands;
                            this.handleResponse(execCommand);
                            continue;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!this.bQuit) continue;
                            return;
                        }
                    }
                    break;
                }
                case 0: {
                    if (!this.checkAuth()) break;
                    ByteBuffer byteBuffer = ByteBuffer.allocate(14);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.putInt(byteBuffer.capacity() - 4);
                    byteBuffer.putInt(n);
                    byteBuffer.putInt(0);
                    byteBuffer.putShort((short)0);
                    this.out.write(byteBuffer.array());
                    this.out.write(byteBuffer.array());
                    break;
                }
                default: {
                    DebugLog.log("RCON: unknown packet Type=" + n2);
                }
            }
        }

        public void handleResponse(ExecCommand execCommand) {
            String string = execCommand.response;
            if (string == null) {
                string = "";
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(12 + string.length() + 2);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(byteBuffer.capacity() - 4);
            byteBuffer.putInt(execCommand.ID);
            byteBuffer.putInt(0);
            byteBuffer.put(string.getBytes());
            byteBuffer.putShort((short)0);
            try {
                this.out.write(byteBuffer.array());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private boolean checkAuth() throws IOException {
            if (this.bAuth) {
                return true;
            }
            this.bQuit = true;
            ByteBuffer byteBuffer = ByteBuffer.allocate(14);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(byteBuffer.capacity() - 4);
            byteBuffer.putInt(-1);
            byteBuffer.putInt(2);
            byteBuffer.putShort((short)0);
            this.out.write(byteBuffer.array());
            return false;
        }

        public void quit() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.bQuit = true;
            this.interrupt();
            while (this.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

