/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.lwjglx.BufferUtils;
import zombie.ChunkMapFilenames;
import zombie.core.Rand;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoChunk;
import zombie.network.ChunkChecksum;
import zombie.network.ClientChunkRequest;
import zombie.network.MPStatistic;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;

public final class PlayerDownloadServer {
    private WorkerThread workerThread;
    private final UdpConnection connection;
    private boolean NetworkFileDebug;
    private final CRC32 crc32 = new CRC32();
    private final ByteBuffer bb = ByteBuffer.allocate(1000000);
    private final ByteBuffer sb = BufferUtils.createByteBuffer(1000000);
    private final ByteBufferWriter bbw = new ByteBufferWriter(this.bb);
    private final ArrayList<ClientChunkRequest> ccrWaiting = new ArrayList();

    public PlayerDownloadServer(UdpConnection udpConnection) {
        this.connection = udpConnection;
        this.workerThread = new WorkerThread();
        this.workerThread.setDaemon(true);
        this.workerThread.setName("PlayerDownloadServer" + Rand.Next(Integer.MAX_VALUE));
        this.workerThread.start();
    }

    public void destroy() {
        this.workerThread.putCommand(EThreadCommand.Quit, null);
        while (this.workerThread.isAlive()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.workerThread = null;
    }

    public void startConnectionTest() {
    }

    public void receiveRequestArray(ByteBuffer byteBuffer) throws Exception {
        ClientChunkRequest clientChunkRequest = this.workerThread.freeRequests.poll();
        if (clientChunkRequest == null) {
            clientChunkRequest = new ClientChunkRequest();
        }
        clientChunkRequest.largeArea = false;
        this.ccrWaiting.add(clientChunkRequest);
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            if (clientChunkRequest.chunks.size() >= 20) {
                clientChunkRequest = this.workerThread.freeRequests.poll();
                if (clientChunkRequest == null) {
                    clientChunkRequest = new ClientChunkRequest();
                }
                clientChunkRequest.largeArea = false;
                this.ccrWaiting.add(clientChunkRequest);
            }
            ClientChunkRequest.Chunk chunk = clientChunkRequest.getChunk();
            chunk.requestNumber = byteBuffer.getInt();
            chunk.wx = byteBuffer.getInt();
            chunk.wy = byteBuffer.getInt();
            chunk.crc = byteBuffer.getLong();
            clientChunkRequest.chunks.add(chunk);
        }
    }

    public void receiveRequestLargeArea(ByteBuffer byteBuffer) {
        ClientChunkRequest clientChunkRequest = new ClientChunkRequest();
        clientChunkRequest.unpackLargeArea(byteBuffer, this.connection);
        for (int i = 0; i < clientChunkRequest.chunks.size(); ++i) {
            ClientChunkRequest.Chunk chunk = clientChunkRequest.chunks.get(i);
            IsoChunk isoChunk = ServerMap.instance.getChunk(chunk.wx, chunk.wy);
            if (isoChunk == null) continue;
            clientChunkRequest.getByteBuffer(chunk);
            try {
                isoChunk.SaveLoadedChunk(chunk, this.crc32);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LoggerManager.getLogger("map").write(exception);
                clientChunkRequest.releaseBuffer(chunk);
            }
        }
        this.workerThread.putCommand(EThreadCommand.RequestLargeArea, clientChunkRequest);
    }

    public void receiveCancelRequest(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            this.workerThread.cancelQ.add(n2);
        }
    }

    public final int getWaitingRequests() {
        return this.ccrWaiting.size();
    }

    public void update() {
        this.NetworkFileDebug = DebugType.Do(DebugType.NetworkFileDebug);
        if (!this.workerThread.bReady) {
            return;
        }
        this.removeOlderDuplicateRequests();
        if (this.ccrWaiting.isEmpty()) {
            if (this.workerThread.cancelQ.isEmpty() && !this.workerThread.cancelled.isEmpty()) {
                this.workerThread.cancelled.clear();
            }
            return;
        }
        ClientChunkRequest clientChunkRequest = this.ccrWaiting.remove(0);
        for (int i = 0; i < clientChunkRequest.chunks.size(); ++i) {
            ClientChunkRequest.Chunk chunk = clientChunkRequest.chunks.get(i);
            if (this.workerThread.isRequestCancelled(chunk)) {
                clientChunkRequest.chunks.remove(i--);
                clientChunkRequest.releaseChunk(chunk);
                continue;
            }
            IsoChunk isoChunk = ServerMap.instance.getChunk(chunk.wx, chunk.wy);
            if (isoChunk == null) continue;
            try {
                clientChunkRequest.getByteBuffer(chunk);
                isoChunk.SaveLoadedChunk(chunk, this.crc32);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LoggerManager.getLogger("map").write(exception);
                this.workerThread.sendNotRequired(chunk, false);
                clientChunkRequest.chunks.remove(i--);
                clientChunkRequest.releaseChunk(chunk);
            }
        }
        if (clientChunkRequest.chunks.isEmpty()) {
            this.workerThread.freeRequests.add(clientChunkRequest);
            return;
        }
        this.workerThread.bReady = false;
        this.workerThread.putCommand(EThreadCommand.RequestZipArray, clientChunkRequest);
    }

    private void removeOlderDuplicateRequests() {
        for (int i = this.ccrWaiting.size() - 1; i >= 0; --i) {
            ClientChunkRequest clientChunkRequest = this.ccrWaiting.get(i);
            for (int j = 0; j < clientChunkRequest.chunks.size(); ++j) {
                ClientChunkRequest.Chunk chunk = clientChunkRequest.chunks.get(j);
                if (this.workerThread.isRequestCancelled(chunk)) {
                    clientChunkRequest.chunks.remove(j--);
                    clientChunkRequest.releaseChunk(chunk);
                    continue;
                }
                for (int k = i - 1; k >= 0; --k) {
                    ClientChunkRequest clientChunkRequest2 = this.ccrWaiting.get(k);
                    if (!this.cancelDuplicateChunk(clientChunkRequest2, chunk.wx, chunk.wy)) continue;
                }
            }
            if (!clientChunkRequest.chunks.isEmpty()) continue;
            this.ccrWaiting.remove(i);
            this.workerThread.freeRequests.add(clientChunkRequest);
        }
    }

    private boolean cancelDuplicateChunk(ClientChunkRequest clientChunkRequest, int n, int n2) {
        for (int i = 0; i < clientChunkRequest.chunks.size(); ++i) {
            ClientChunkRequest.Chunk chunk = clientChunkRequest.chunks.get(i);
            if (this.workerThread.isRequestCancelled(chunk)) {
                clientChunkRequest.chunks.remove(i--);
                clientChunkRequest.releaseChunk(chunk);
                continue;
            }
            if (chunk.wx != n || chunk.wy != n2) continue;
            this.workerThread.sendNotRequired(chunk, false);
            clientChunkRequest.chunks.remove(i);
            clientChunkRequest.releaseChunk(chunk);
            return true;
        }
        return false;
    }

    private void sendPacket(PacketTypes.PacketType packetType) {
        this.bb.flip();
        this.sb.put(this.bb);
        this.sb.flip();
        this.connection.getPeer().SendRaw(this.sb, packetType.PacketPriority, packetType.PacketReliability, (byte)0, this.connection.getConnectedGUID(), false);
        this.sb.clear();
    }

    private ByteBufferWriter startPacket() {
        this.bb.clear();
        return this.bbw;
    }

    private final class WorkerThread
    extends Thread {
        boolean bQuit;
        volatile boolean bReady = true;
        final LinkedBlockingQueue<WorkerThreadCommand> commandQ = new LinkedBlockingQueue();
        final ConcurrentLinkedQueue<ClientChunkRequest> freeRequests = new ConcurrentLinkedQueue();
        final ConcurrentLinkedQueue<Integer> cancelQ = new ConcurrentLinkedQueue();
        final ArrayList<Integer> cancelled = new ArrayList();
        final CRC32 crcMaker = new CRC32();
        static final int chunkSize = 1000;
        private byte[] inMemoryZip = new byte[20480];
        private final Deflater compressor = new Deflater();

        private WorkerThread() {
        }

        @Override
        public void run() {
            while (!this.bQuit) {
                try {
                    this.runInner();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private void runInner() throws InterruptedException, IOException {
            MPStatistic.getInstance().PlayerDownloadServer.End();
            WorkerThreadCommand workerThreadCommand = this.commandQ.take();
            MPStatistic.getInstance().PlayerDownloadServer.Start();
            switch (workerThreadCommand.e) {
                case RequestLargeArea: {
                    try {
                        this.sendLargeArea(workerThreadCommand.ccr);
                        break;
                    }
                    finally {
                        this.bReady = true;
                    }
                }
                case RequestZipArray: {
                    try {
                        this.sendArray(workerThreadCommand.ccr);
                        break;
                    }
                    finally {
                        this.bReady = true;
                    }
                }
                case Quit: {
                    this.bQuit = true;
                }
            }
        }

        void putCommand(EThreadCommand eThreadCommand, ClientChunkRequest clientChunkRequest) {
            WorkerThreadCommand workerThreadCommand = new WorkerThreadCommand();
            workerThreadCommand.e = eThreadCommand;
            workerThreadCommand.ccr = clientChunkRequest;
            while (true) {
                try {
                    this.commandQ.put(workerThreadCommand);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private int compressChunk(ClientChunkRequest.Chunk chunk) {
            this.compressor.reset();
            this.compressor.setInput(chunk.bb.array(), 0, chunk.bb.limit());
            this.compressor.finish();
            if ((double)this.inMemoryZip.length < (double)chunk.bb.limit() * 1.5) {
                this.inMemoryZip = new byte[(int)((double)chunk.bb.limit() * 1.5)];
            }
            return this.compressor.deflate(this.inMemoryZip, 0, this.inMemoryZip.length, 3);
        }

        private void sendChunk(ClientChunkRequest.Chunk chunk) {
            try {
                long l = this.compressChunk(chunk);
                long l2 = l / 1000L;
                if (l % 1000L != 0L) {
                    ++l2;
                }
                long l3 = 0L;
                int n = 0;
                while ((long)n < l2) {
                    long l4 = l - l3 > 1000L ? 1000L : l - l3;
                    ByteBufferWriter byteBufferWriter = PlayerDownloadServer.this.startPacket();
                    PacketTypes.PacketType.SentChunk.doPacket(byteBufferWriter);
                    byteBufferWriter.putInt(chunk.requestNumber);
                    byteBufferWriter.putInt((int)l2);
                    byteBufferWriter.putInt(n);
                    byteBufferWriter.putInt((int)l);
                    byteBufferWriter.putInt((int)l3);
                    byteBufferWriter.putInt((int)l4);
                    byteBufferWriter.bb.put(this.inMemoryZip, (int)l3, (int)l4);
                    PlayerDownloadServer.this.sendPacket(PacketTypes.PacketType.SentChunk);
                    l3 += l4;
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.sendNotRequired(chunk, false);
            }
        }

        private void sendNotRequired(ClientChunkRequest.Chunk chunk, boolean bl) {
            ByteBufferWriter byteBufferWriter = PlayerDownloadServer.this.startPacket();
            PacketTypes.PacketType.NotRequiredInZip.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(1);
            byteBufferWriter.putInt(chunk.requestNumber);
            byteBufferWriter.putByte(bl ? (byte)1 : 0);
            PlayerDownloadServer.this.sendPacket(PacketTypes.PacketType.NotRequiredInZip);
        }

        private void sendLargeArea(ClientChunkRequest clientChunkRequest) throws IOException {
            for (int i = 0; i < clientChunkRequest.chunks.size(); ++i) {
                ClientChunkRequest.Chunk chunk = clientChunkRequest.chunks.get(i);
                int n = chunk.wx;
                int n2 = chunk.wy;
                if (chunk.bb != null) {
                    chunk.bb.limit(chunk.bb.position());
                    chunk.bb.position(0);
                    this.sendChunk(chunk);
                    clientChunkRequest.releaseBuffer(chunk);
                    continue;
                }
                File file = ChunkMapFilenames.instance.getFilename(n, n2);
                if (!file.exists()) continue;
                clientChunkRequest.getByteBuffer(chunk);
                chunk.bb = IsoChunk.SafeRead("map_", n, n2, chunk.bb);
                this.sendChunk(chunk);
                clientChunkRequest.releaseBuffer(chunk);
            }
            ClientChunkRequest.freeBuffers.clear();
            clientChunkRequest.chunks.clear();
        }

        private void sendArray(ClientChunkRequest clientChunkRequest) throws IOException {
            int n;
            for (n = 0; n < clientChunkRequest.chunks.size(); ++n) {
                ClientChunkRequest.Chunk chunk = clientChunkRequest.chunks.get(n);
                if (this.isRequestCancelled(chunk)) continue;
                int n2 = chunk.wx;
                int n3 = chunk.wy;
                long l = chunk.crc;
                if (chunk.bb != null) {
                    boolean bl = true;
                    if (chunk.crc != 0L) {
                        this.crcMaker.reset();
                        this.crcMaker.update(chunk.bb.array(), 0, chunk.bb.position());
                        boolean bl2 = bl = chunk.crc != this.crcMaker.getValue();
                        if (bl && PlayerDownloadServer.this.NetworkFileDebug) {
                            DebugLog.log(DebugType.NetworkFileDebug, n2 + "," + n3 + ": crc server=" + this.crcMaker.getValue() + " client=" + chunk.crc);
                        }
                    }
                    if (bl) {
                        if (PlayerDownloadServer.this.NetworkFileDebug) {
                            DebugLog.log(DebugType.NetworkFileDebug, n2 + "," + n3 + ": send=true loaded=true");
                        }
                        chunk.bb.limit(chunk.bb.position());
                        chunk.bb.position(0);
                        this.sendChunk(chunk);
                    } else {
                        if (PlayerDownloadServer.this.NetworkFileDebug) {
                            DebugLog.log(DebugType.NetworkFileDebug, n2 + "," + n3 + ": send=false loaded=true");
                        }
                        this.sendNotRequired(chunk, true);
                    }
                    clientChunkRequest.releaseBuffer(chunk);
                    continue;
                }
                File file = ChunkMapFilenames.instance.getFilename(n2, n3);
                if (file.exists()) {
                    long l2 = ChunkChecksum.getChecksum(n2, n3);
                    if (l2 != 0L && l2 == chunk.crc) {
                        if (PlayerDownloadServer.this.NetworkFileDebug) {
                            DebugLog.log(DebugType.NetworkFileDebug, n2 + "," + n3 + ": send=false loaded=false file=true");
                        }
                        this.sendNotRequired(chunk, true);
                        continue;
                    }
                    clientChunkRequest.getByteBuffer(chunk);
                    chunk.bb = IsoChunk.SafeRead("map_", n2, n3, chunk.bb);
                    boolean bl = true;
                    if (chunk.crc != 0L) {
                        this.crcMaker.reset();
                        this.crcMaker.update(chunk.bb.array(), 0, chunk.bb.limit());
                        boolean bl3 = bl = chunk.crc != this.crcMaker.getValue();
                    }
                    if (bl) {
                        if (PlayerDownloadServer.this.NetworkFileDebug) {
                            DebugLog.log(DebugType.NetworkFileDebug, n2 + "," + n3 + ": send=true loaded=false file=true");
                        }
                        this.sendChunk(chunk);
                    } else {
                        if (PlayerDownloadServer.this.NetworkFileDebug) {
                            DebugLog.log(DebugType.NetworkFileDebug, n2 + "," + n3 + ": send=false loaded=false file=true");
                        }
                        this.sendNotRequired(chunk, true);
                    }
                    clientChunkRequest.releaseBuffer(chunk);
                    continue;
                }
                if (PlayerDownloadServer.this.NetworkFileDebug) {
                    DebugLog.log(DebugType.NetworkFileDebug, n2 + "," + n3 + ": send=false loaded=false file=false");
                }
                this.sendNotRequired(chunk, l == 0L);
            }
            for (n = 0; n < clientChunkRequest.chunks.size(); ++n) {
                clientChunkRequest.releaseChunk(clientChunkRequest.chunks.get(n));
            }
            clientChunkRequest.chunks.clear();
            this.freeRequests.add(clientChunkRequest);
        }

        private boolean isRequestCancelled(ClientChunkRequest.Chunk chunk) {
            Integer n = this.cancelQ.poll();
            while (n != null) {
                this.cancelled.add(n);
                n = this.cancelQ.poll();
            }
            for (int i = 0; i < this.cancelled.size(); ++i) {
                Integer n2 = this.cancelled.get(i);
                if (n2 != chunk.requestNumber) continue;
                if (PlayerDownloadServer.this.NetworkFileDebug) {
                    DebugLog.log(DebugType.NetworkFileDebug, "cancelled request #" + n2);
                }
                this.cancelled.remove(i);
                return true;
            }
            return false;
        }
    }

    private static enum EThreadCommand {
        RequestLargeArea,
        RequestZipArray,
        Quit;

    }

    private static final class WorkerThreadCommand {
        EThreadCommand e;
        ClientChunkRequest ccr;

        private WorkerThreadCommand() {
        }
    }
}

