/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import org.joml.Vector3f;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.vehicles.BaseVehicle;

public final class PassengerMap {
    private static final int CHUNKS = 7;
    private static final int MAX_PASSENGERS = 16;
    private static final PassengerLocal[] perPlayerPngr = new PassengerLocal[4];
    private static final DriverLocal[] perPlayerDriver = new DriverLocal[4];

    public static void updatePassenger(IsoPlayer isoPlayer) {
        if (isoPlayer == null || isoPlayer.getVehicle() == null || isoPlayer.getVehicle().isDriver(isoPlayer)) {
            return;
        }
        IsoGameCharacter isoGameCharacter = isoPlayer.getVehicle().getDriver();
        if (!(isoGameCharacter instanceof IsoPlayer) || ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            return;
        }
        PassengerLocal passengerLocal = perPlayerPngr[isoPlayer.PlayerIndex];
        passengerLocal.chunkMap = IsoWorld.instance.CurrentCell.ChunkMap[isoPlayer.PlayerIndex];
        passengerLocal.updateLoaded();
    }

    public static void serverReceivePacket(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        byte by = byteBuffer.get();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        long l = byteBuffer.getLong();
        IsoPlayer isoPlayer = udpConnection.players[by];
        if (isoPlayer == null || isoPlayer.getVehicle() == null) {
            return;
        }
        IsoGameCharacter isoGameCharacter = isoPlayer.getVehicle().getDriver();
        if (!(isoGameCharacter instanceof IsoPlayer) || isoGameCharacter == isoPlayer) {
            return;
        }
        UdpConnection udpConnection2 = GameServer.getConnectionFromPlayer((IsoPlayer)isoGameCharacter);
        if (udpConnection2 == null) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
        PacketTypes.PacketType.PassengerMap.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(isoPlayer.getVehicle().VehicleID);
        byteBufferWriter.putByte((byte)isoPlayer.getVehicle().getSeat(isoPlayer));
        byteBufferWriter.putInt(n);
        byteBufferWriter.putInt(n2);
        byteBufferWriter.putLong(l);
        PacketTypes.PacketType.PassengerMap.send(udpConnection2);
    }

    public static void clientReceivePacket(ByteBuffer byteBuffer) {
        short s = byteBuffer.getShort();
        byte by = byteBuffer.get();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        long l = byteBuffer.getLong();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.getVehicle() == null) continue;
            BaseVehicle baseVehicle = isoPlayer.getVehicle();
            if (baseVehicle.VehicleID != s || !baseVehicle.isDriver(isoPlayer)) continue;
            DriverLocal driverLocal = perPlayerDriver[i];
            PassengerRemote passengerRemote = driverLocal.passengers[by];
            if (passengerRemote == null) {
                passengerRemote = driverLocal.passengers[by] = new PassengerRemote();
            }
            passengerRemote.setLoaded(n, n2, l);
        }
    }

    public static boolean isChunkLoaded(BaseVehicle baseVehicle, int n, int n2) {
        if (!GameClient.bClient) {
            return false;
        }
        if (baseVehicle == null || n < 0 || n2 < 0) {
            return false;
        }
        IsoGameCharacter isoGameCharacter = baseVehicle.getDriver();
        if (!(isoGameCharacter instanceof IsoPlayer) || !((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            return false;
        }
        int n3 = ((IsoPlayer)isoGameCharacter).PlayerIndex;
        DriverLocal driverLocal = perPlayerDriver[n3];
        for (int i = 1; i < baseVehicle.getMaxPassengers(); ++i) {
            PassengerRemote passengerRemote = driverLocal.passengers[i];
            if (passengerRemote == null || passengerRemote.wx == -1) continue;
            IsoGameCharacter isoGameCharacter2 = baseVehicle.getCharacter(i);
            if (!(isoGameCharacter2 instanceof IsoPlayer) || ((IsoPlayer)isoGameCharacter2).isLocalPlayer()) {
                passengerRemote.wx = -1;
                continue;
            }
            int n4 = passengerRemote.wx - 3;
            int n5 = passengerRemote.wy - 3;
            if (n < n4 || n2 < n5 || n >= n4 + 7 || n2 >= n5 + 7 || (passengerRemote.loaded & 1L << n - n4 + (n2 - n5) * 7) != 0L) continue;
            return false;
        }
        return true;
    }

    public static void render(int n) {
        if (!GameClient.bClient) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer == null || isoPlayer.getVehicle() == null) {
            return;
        }
        BaseVehicle baseVehicle = isoPlayer.getVehicle();
        int n2 = Core.TileScale;
        int n3 = 10;
        float f = 0.1f;
        float f2 = 0.1f;
        float f3 = 0.1f;
        float f4 = 0.75f;
        float f5 = 0.0f;
        DriverLocal driverLocal = perPlayerDriver[n];
        for (int i = 1; i < baseVehicle.getMaxPassengers(); ++i) {
            PassengerRemote passengerRemote = driverLocal.passengers[i];
            if (passengerRemote == null || passengerRemote.wx == -1) continue;
            IsoGameCharacter isoGameCharacter = baseVehicle.getCharacter(i);
            if (!(isoGameCharacter instanceof IsoPlayer) || ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                passengerRemote.wx = -1;
                continue;
            }
            for (int j = 0; j < 7; ++j) {
                for (int k = 0; k < 7; ++k) {
                    boolean bl;
                    boolean bl2 = bl = (passengerRemote.loaded & 1L << k + j * 7) != 0L;
                    if (bl) continue;
                    float f6 = (passengerRemote.wx - 3 + k) * n3;
                    float f7 = (passengerRemote.wy - 3 + j) * n3;
                    float f8 = IsoUtils.XToScreenExact(f6, f7 + (float)n3, f5, 0);
                    float f9 = IsoUtils.YToScreenExact(f6, f7 + (float)n3, f5, 0);
                    SpriteRenderer.instance.renderPoly((int)f8, (int)f9, (int)(f8 + (float)(n3 * 64 / 2 * n2)), (int)(f9 - (float)(n3 * 32 / 2 * n2)), (int)(f8 + (float)(n3 * 64 * n2)), (int)f9, (int)(f8 + (float)(n3 * 64 / 2 * n2)), (int)(f9 + (float)(n3 * 32 / 2 * n2)), f, f2, f3, f4);
                }
            }
        }
    }

    public static void Reset() {
        for (int i = 0; i < 4; ++i) {
            PassengerLocal passengerLocal = perPlayerPngr[i];
            passengerLocal.wx = -1;
            DriverLocal driverLocal = perPlayerDriver[i];
            for (int j = 0; j < 16; ++j) {
                PassengerRemote passengerRemote = driverLocal.passengers[j];
                if (passengerRemote == null) continue;
                passengerRemote.wx = -1;
            }
        }
    }

    static {
        for (int i = 0; i < 4; ++i) {
            PassengerMap.perPlayerPngr[i] = new PassengerLocal(i);
            PassengerMap.perPlayerDriver[i] = new DriverLocal();
        }
    }

    private static final class PassengerLocal {
        final int playerIndex;
        IsoChunkMap chunkMap;
        int wx = -1;
        int wy = -1;
        long loaded = 0L;

        PassengerLocal(int n) {
            this.playerIndex = n;
        }

        boolean setLoaded() {
            int n;
            boolean bl;
            int n2 = this.chunkMap.WorldX;
            int n3 = this.chunkMap.WorldY;
            Vector3f vector3f = IsoPlayer.players[this.playerIndex].getVehicle().jniLinearVelocity;
            float f = Math.abs(vector3f.x);
            float f2 = Math.abs(vector3f.z);
            boolean bl2 = vector3f.x < 0.0f && f > f2;
            boolean bl3 = vector3f.x > 0.0f && f > f2;
            boolean bl4 = vector3f.z < 0.0f && f2 > f;
            boolean bl5 = bl = vector3f.z > 0.0f && f2 > f;
            if (bl3) {
                ++n2;
            } else if (bl2) {
                --n2;
            } else if (bl4) {
                --n3;
            } else if (bl) {
                ++n3;
            }
            long l = 0L;
            for (n = 0; n < 7; ++n) {
                for (int i = 0; i < 7; ++i) {
                    IsoChunk isoChunk = this.chunkMap.getChunk(IsoChunkMap.ChunkGridWidth / 2 - 3 + i, IsoChunkMap.ChunkGridWidth / 2 - 3 + n);
                    if (isoChunk == null || !isoChunk.bLoaded) continue;
                    l |= 1L << i + n * 7;
                }
            }
            int n4 = n = n2 != this.wx || n3 != this.wy || l != this.loaded ? 1 : 0;
            if (n != 0) {
                this.wx = n2;
                this.wy = n3;
                this.loaded = l;
            }
            return n != 0;
        }

        void updateLoaded() {
            if (this.setLoaded()) {
                this.clientSendPacket(GameClient.connection);
            }
        }

        void clientSendPacket(UdpConnection udpConnection) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.PassengerMap.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)this.playerIndex);
            byteBufferWriter.putInt(this.wx);
            byteBufferWriter.putInt(this.wy);
            byteBufferWriter.putLong(this.loaded);
            PacketTypes.PacketType.PassengerMap.send(udpConnection);
        }
    }

    private static final class DriverLocal {
        final PassengerRemote[] passengers = new PassengerRemote[16];

        private DriverLocal() {
        }
    }

    private static final class PassengerRemote {
        int wx = -1;
        int wy = -1;
        long loaded = 0L;

        private PassengerRemote() {
        }

        void setLoaded(int n, int n2, long l) {
            this.wx = n;
            this.wy = n2;
            this.loaded = l;
        }
    }
}

