/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import zombie.GameWindow;
import zombie.SystemDisabler;
import zombie.characters.Faction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.SafetySystemManager;
import zombie.commands.PlayerType;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.utils.UpdateLimit;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoUtils;
import zombie.iso.areas.NonPvpZone;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.ServerWorldDatabase;
import zombie.network.Userlog;
import zombie.network.packets.hit.Character;
import zombie.network.packets.hit.Hit;
import zombie.network.packets.hit.IMovable;
import zombie.network.packets.hit.IPositional;
import zombie.network.packets.hit.Player;
import zombie.network.packets.hit.Zombie;
import zombie.scripting.objects.Recipe;
import zombie.util.StringUtils;
import zombie.util.Type;

public class PacketValidator {
    private static final int SUSPICIOUS_ACTIVITIES_MAX = 4;
    private final UpdateLimit ulSuspiciousActivity = new UpdateLimit(150000L);
    public final HashMap<String, RecipeDetails> details = new HashMap();
    public final HashMap<String, RecipeDetails> detailsFromClient = new HashMap();
    private boolean failed = false;
    private static final long USER_LOG_INTERVAL_MS = 1000L;
    private static final int MAX_TYPE_3 = 10;
    private static final int MAX_TYPE_4 = 101;
    private final UdpConnection connection;
    private final UpdateLimit ulTimeMultiplier = new UpdateLimit(this.getTimeMultiplierTimeout());
    private final UpdateLimit ulRecipeChecksumInterval = new UpdateLimit(this.getChecksumInterval());
    private final UpdateLimit ulRecipeChecksumTimeout = new UpdateLimit(this.getChecksumTimeout());
    private int salt;
    private int suspiciousActivityCounter;
    private String suspiciousActivityDescription;

    public PacketValidator(UdpConnection udpConnection) {
        this.connection = udpConnection;
        this.suspiciousActivityCounter = 0;
    }

    public void reset() {
        this.salt = Rand.Next(Integer.MAX_VALUE);
    }

    private boolean isReady() {
        IsoPlayer isoPlayer = GameServer.getPlayerByRealUserName(this.connection.username);
        return this.connection.isFullyConnected() && this.connection.isConnectionGraceIntervalTimeout() && !GameServer.bFastForward && isoPlayer != null && isoPlayer.isAlive();
    }

    public int getSalt() {
        return this.salt;
    }

    private long getChecksumDelay() {
        return (long)(1000.0 * ServerOptions.getInstance().AntiCheatProtectionType22ThresholdMultiplier.getValue());
    }

    private long getChecksumInterval() {
        return (long)(4000.0 * ServerOptions.getInstance().AntiCheatProtectionType22ThresholdMultiplier.getValue());
    }

    private long getChecksumTimeout() {
        return (long)(10000.0 * ServerOptions.getInstance().AntiCheatProtectionType22ThresholdMultiplier.getValue());
    }

    public void failChecksum() {
        if (ServerOptions.instance.AntiCheatProtectionType21.getValue() && PacketValidator.checkUser(this.connection)) {
            DebugLog.Multiplayer.warn("Checksum fail for \"%s\" (Type21)", this.connection.username);
            this.failed = true;
        }
        this.ulRecipeChecksumTimeout.Reset(this.getChecksumDelay());
    }

    public boolean isFailed() {
        return this.failed;
    }

    private void timeoutChecksum() {
        if (this.failed) {
            PacketValidator.doKickUser(this.connection, this.getClass().getSimpleName(), "Type21", this.getDescription());
        } else {
            if (ServerOptions.instance.AntiCheatProtectionType22.getValue() && PacketValidator.checkUser(this.connection)) {
                PacketValidator.doKickUser(this.connection, this.getClass().getSimpleName(), "Type22", null);
            }
            this.ulRecipeChecksumTimeout.Reset(this.getChecksumTimeout());
        }
    }

    public void successChecksum() {
        this.ulRecipeChecksumTimeout.Reset(this.getChecksumTimeout());
    }

    public void sendChecksum(boolean bl, boolean bl2, boolean bl3) {
        this.salt = Rand.Next(Integer.MAX_VALUE);
        GameServer.sendValidatePacket(this.connection, bl, bl2, bl3);
        this.ulRecipeChecksumInterval.Reset(this.getChecksumInterval());
    }

    private long getTimeMultiplierTimeout() {
        return (long)(10000.0 * ServerOptions.getInstance().AntiCheatProtectionType24ThresholdMultiplier.getValue());
    }

    public void failTimeMultiplier(float f) {
        if (ServerOptions.instance.AntiCheatProtectionType23.getValue() && PacketValidator.checkUser(this.connection)) {
            PacketValidator.doKickUser(this.connection, this.getClass().getSimpleName(), "Type23", String.valueOf(f));
        }
        this.ulTimeMultiplier.Reset(this.getTimeMultiplierTimeout());
    }

    public void timeoutTimeMultiplier() {
        if (ServerOptions.instance.AntiCheatProtectionType24.getValue() && PacketValidator.checkUser(this.connection)) {
            PacketValidator.doKickUser(this.connection, this.getClass().getSimpleName(), "Type24", null);
        }
        this.ulTimeMultiplier.Reset(this.getTimeMultiplierTimeout());
    }

    public void successTimeMultiplier() {
        this.ulTimeMultiplier.Reset(this.getTimeMultiplierTimeout());
    }

    public void update() {
        if (GameServer.bServer) {
            if (this.ulSuspiciousActivity.Check()) {
                this.updateSuspiciousActivityCounter();
            }
            if (this.isReady()) {
                if (!this.failed && this.ulRecipeChecksumInterval.Check()) {
                    this.sendChecksum(false, false, false);
                }
                if (this.ulRecipeChecksumTimeout.Check()) {
                    this.timeoutChecksum();
                }
                if (this.ulTimeMultiplier.Check()) {
                    this.timeoutTimeMultiplier();
                }
            } else {
                this.ulRecipeChecksumInterval.Reset(this.getChecksumInterval());
                this.ulRecipeChecksumTimeout.Reset(this.getChecksumTimeout());
                this.ulTimeMultiplier.Reset(this.getTimeMultiplierTimeout());
                this.failed = false;
            }
        }
    }

    public static boolean checkPVP(UdpConnection udpConnection, Character character, Character character2, String string) {
        boolean bl;
        boolean bl2 = bl = PacketValidator.checkPVP(character.getCharacter(), character2.getCharacter()) || SafetySystemManager.checkUpdateDelay(character.getCharacter(), character2.getCharacter());
        if (!bl && ServerOptions.instance.AntiCheatProtectionType1.getValue() && PacketValidator.checkUser(udpConnection)) {
            PacketValidator.doKickUser(udpConnection, string, "Type1", null);
        }
        return bl;
    }

    public static boolean checkSpeed(UdpConnection udpConnection, IMovable iMovable, String string) {
        boolean bl;
        float f = iMovable.getSpeed();
        double d = iMovable.isVehicle() ? ServerOptions.instance.SpeedLimit.getValue() : 10.0;
        boolean bl2 = bl = (double)f <= d * ServerOptions.instance.AntiCheatProtectionType2ThresholdMultiplier.getValue();
        if (!bl && ServerOptions.instance.AntiCheatProtectionType2.getValue() && PacketValidator.checkUser(udpConnection)) {
            PacketValidator.doKickUser(udpConnection, string, "Type2", String.valueOf(f));
        }
        return bl;
    }

    public static boolean checkLongDistance(UdpConnection udpConnection, IPositional iPositional, IPositional iPositional2, String string) {
        boolean bl;
        float f = IsoUtils.DistanceTo(iPositional2.getX(), iPositional2.getY(), iPositional.getX(), iPositional.getY());
        boolean bl2 = bl = (double)f <= (double)(udpConnection.ReleventRange * 10) * ServerOptions.instance.AntiCheatProtectionType3ThresholdMultiplier.getValue();
        if (!bl && ServerOptions.instance.AntiCheatProtectionType3.getValue() && PacketValidator.checkUser(udpConnection)) {
            if (udpConnection.validator.checkSuspiciousActivity("Type3")) {
                PacketValidator.doKickUser(udpConnection, string, "Type3", String.valueOf(f));
            } else {
                PacketValidator.doLogUser(udpConnection, Userlog.UserlogType.SuspiciousActivity, string, "Type3");
            }
        }
        return bl;
    }

    public static boolean checkDamage(UdpConnection udpConnection, Hit hit, String string) {
        boolean bl;
        float f = hit.getDamage();
        boolean bl2 = bl = (double)f <= 101.0 * ServerOptions.instance.AntiCheatProtectionType4ThresholdMultiplier.getValue();
        if (!bl && ServerOptions.instance.AntiCheatProtectionType4.getValue() && PacketValidator.checkUser(udpConnection)) {
            PacketValidator.doKickUser(udpConnection, string, "Type4", String.valueOf(f));
        }
        return bl;
    }

    public static boolean checkOwner(UdpConnection udpConnection2, Zombie zombie, String string) {
        boolean bl;
        IsoZombie isoZombie = (IsoZombie)zombie.getCharacter();
        UdpConnection udpConnection3 = isoZombie.authOwner;
        boolean bl2 = bl = udpConnection3 == udpConnection2 && System.currentTimeMillis() - isoZombie.lastChangeOwner > 2000L;
        if (!bl && ServerOptions.instance.AntiCheatProtectionType5.getValue() && PacketValidator.checkUser(udpConnection2)) {
            if (udpConnection2.validator.checkSuspiciousActivity("Type5")) {
                PacketValidator.doKickUser(udpConnection2, string, "Type5", Optional.ofNullable(udpConnection3).map(udpConnection -> udpConnection.username).orElse(""));
            } else {
                PacketValidator.doLogUser(udpConnection2, Userlog.UserlogType.SuspiciousActivity, string, "Type5");
            }
        }
        return bl;
    }

    public static boolean checkTarget(UdpConnection udpConnection, Player player, String string) {
        IsoPlayer isoPlayer = player.getPlayer();
        boolean bl = Arrays.stream(udpConnection.players).anyMatch(isoPlayer2 -> isoPlayer2.getOnlineID() == isoPlayer.getOnlineID());
        if (!bl && ServerOptions.instance.AntiCheatProtectionType6.getValue() && PacketValidator.checkUser(udpConnection)) {
            PacketValidator.doKickUser(udpConnection, string, "Type6", isoPlayer.getUsername());
        }
        return bl;
    }

    public static boolean checkSafehouseAuth(UdpConnection udpConnection, String string, String string2) {
        boolean bl;
        boolean bl2 = bl = StringUtils.isNullOrEmpty(string) || string.equals(udpConnection.username) || udpConnection.accessLevel >= 16;
        if (!bl && ServerOptions.instance.AntiCheatProtectionType7.getValue() && PacketValidator.checkUser(udpConnection)) {
            PacketValidator.doKickUser(udpConnection, string2, "Type7", string);
        }
        return bl;
    }

    public static boolean checkShortDistance(UdpConnection udpConnection, IPositional iPositional, IPositional iPositional2, String string) {
        boolean bl;
        float f = IsoUtils.DistanceTo(iPositional2.getX(), iPositional2.getY(), iPositional.getX(), iPositional.getY());
        boolean bl2 = bl = (double)f <= 10.0 * ServerOptions.instance.AntiCheatProtectionType3ThresholdMultiplier.getValue();
        if (!bl && ServerOptions.instance.AntiCheatProtectionType3.getValue() && PacketValidator.checkUser(udpConnection)) {
            PacketValidator.doKickUser(udpConnection, string, "Type3", String.valueOf(f));
        }
        return bl;
    }

    private static boolean isUntouchable(UdpConnection udpConnection) {
        return !udpConnection.isFullyConnected() || PlayerType.isPrivileged(udpConnection.accessLevel) || Arrays.stream(udpConnection.players).filter(Objects::nonNull).anyMatch(IsoGameCharacter::isGodMod);
    }

    public static boolean checkUser(UdpConnection udpConnection) {
        return PacketValidator.doAntiCheatProtection() && !PacketValidator.isUntouchable(udpConnection);
    }

    public boolean checkSuspiciousActivity(String string) {
        if (this.suspiciousActivityCounter <= 4) {
            ++this.suspiciousActivityCounter;
            this.suspiciousActivityDescription = String.format("player=\"%s\" type=\"%s\"", this.connection.username, string);
            DebugLog.Multiplayer.noise("SuspiciousActivity increase: counter=%d %s", this.suspiciousActivityCounter, this.suspiciousActivityDescription);
        }
        return this.suspiciousActivityCounter > 4;
    }

    public void updateSuspiciousActivityCounter() {
        if (this.suspiciousActivityCounter > 0) {
            --this.suspiciousActivityCounter;
            DebugLog.Multiplayer.warn("SuspiciousActivity decrease: counter=%d %s", this.suspiciousActivityCounter, this.suspiciousActivityDescription);
        } else {
            this.suspiciousActivityCounter = 0;
        }
    }

    public static void doLogUser(UdpConnection udpConnection, Userlog.UserlogType userlogType, String string, String string2) {
        long l = System.currentTimeMillis();
        DebugLog.Multiplayer.warn("Log: player=\"%s\" type=\"%s\" issuer=\"%s\"", udpConnection.username, string, string2);
        if (l > udpConnection.lastUnauthorizedPacket) {
            udpConnection.lastUnauthorizedPacket = l + 1000L;
            ServerWorldDatabase.instance.addUserlog(udpConnection.username, userlogType, string, "AntiCheat" + string2, 1);
        }
    }

    public static void doKickUser(UdpConnection udpConnection, String string, String string2, String string3) {
        ServerWorldDatabase.instance.addUserlog(udpConnection.username, Userlog.UserlogType.Kicked, string, "AntiCheat" + string2, 1);
        DebugLog.Multiplayer.warn("Kick: player=\"%s\" type=\"%s\" issuer=\"%s\" description=\"%s\"", udpConnection.username, string, string2, string3);
        GameServer.kick(udpConnection, "UI_Policy_Kick", string2);
        udpConnection.forceDisconnect(string);
        GameServer.addDisconnect(udpConnection);
    }

    public static void doBanUser(UdpConnection udpConnection, String string, String string2) throws Exception {
        ServerWorldDatabase.instance.addUserlog(udpConnection.username, Userlog.UserlogType.Banned, string, "AntiCheat" + string2, 1);
        DebugLog.Multiplayer.warn("Ban: player=\"%s\" type=\"%s\" issuer=\"%s\"", udpConnection.username, string, string2);
        ServerWorldDatabase.instance.banUser(udpConnection.username, true);
        if (SteamUtils.isSteamModeEnabled()) {
            String string3 = SteamUtils.convertSteamIDToString(udpConnection.steamID);
            ServerWorldDatabase.instance.banSteamID(string3, string, true);
        } else {
            ServerWorldDatabase.instance.banIp(udpConnection.ip, udpConnection.username, string, true);
        }
        GameServer.kick(udpConnection, "UI_Policy_Ban", string2);
        udpConnection.forceDisconnect(string);
        GameServer.addDisconnect(udpConnection);
    }

    private static boolean checkPVP(IsoGameCharacter isoGameCharacter, IsoMovingObject isoMovingObject) {
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        IsoPlayer isoPlayer2 = Type.tryCastTo(isoMovingObject, IsoPlayer.class);
        if (isoPlayer2 != null) {
            if (isoPlayer2.isGodMod() || !ServerOptions.instance.PVP.getValue() || ServerOptions.instance.SafetySystem.getValue() && isoGameCharacter.getSafety().isEnabled() && ((IsoGameCharacter)isoMovingObject).getSafety().isEnabled()) {
                return false;
            }
            if (NonPvpZone.getNonPvpZone((int)isoMovingObject.getX(), (int)isoMovingObject.getY()) != null) {
                return false;
            }
            if (isoPlayer != null && NonPvpZone.getNonPvpZone((int)isoGameCharacter.getX(), (int)isoGameCharacter.getY()) != null) {
                return false;
            }
            if (isoPlayer != null && !isoPlayer.factionPvp && !isoPlayer2.factionPvp) {
                Faction faction = Faction.getPlayerFaction(isoPlayer);
                Faction faction2 = Faction.getPlayerFaction(isoPlayer2);
                if (faction2 != null && faction == faction2) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean doAntiCheatProtection() {
        return !GameServer.bCoop && (!Core.bDebug || SystemDisabler.doKickInDebug);
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("Recipes CRC details");
        if (GameServer.bServer) {
            Set<String> set = this.details.entrySet().stream().filter(entry -> this.detailsFromClient.get(entry.getKey()) != null && this.detailsFromClient.get(entry.getKey()).crc == ((RecipeDetails)entry.getValue()).crc).map(Map.Entry::getKey).collect(Collectors.toSet());
            set.forEach(string -> {
                this.detailsFromClient.remove(string);
                this.details.remove(string);
            });
            stringBuilder.append("\nServer start size=").append(this.details.size());
            this.details.values().forEach(recipeDetails -> stringBuilder.append(recipeDetails.getDescription()));
            stringBuilder.append("\nServer end\nClient start size=").append(this.detailsFromClient.size());
            this.detailsFromClient.values().forEach(recipeDetails -> stringBuilder.append(recipeDetails.getDescription()));
            stringBuilder.append("\nClient end");
        }
        return stringBuilder.toString();
    }

    public static class RecipeDetails {
        private final String name;
        private final long crc;
        private final int timeToMake;
        private final ArrayList<Skill> skills = new ArrayList();
        private final ArrayList<String> items = new ArrayList();
        private final String type;
        private final String module;
        private final int count;

        public long getCRC() {
            return this.crc;
        }

        public RecipeDetails(String string, long l, int n, ArrayList<Recipe.RequiredSkill> arrayList, ArrayList<Recipe.Source> arrayList2, String string2, String string3, int n2) {
            this.name = string;
            this.crc = l;
            this.timeToMake = n;
            this.type = string2;
            this.module = string3;
            this.count = n2;
            if (arrayList != null) {
                for (Recipe.RequiredSkill object : arrayList) {
                    this.skills.add(new Skill(object.getPerk().getName(), object.getLevel()));
                }
            }
            for (Recipe.Source source : arrayList2) {
                this.items.addAll(source.getItems());
            }
        }

        public RecipeDetails(ByteBuffer byteBuffer) {
            int n;
            this.name = GameWindow.ReadString(byteBuffer);
            this.crc = byteBuffer.getLong();
            this.timeToMake = byteBuffer.getInt();
            this.type = GameWindow.ReadString(byteBuffer);
            this.module = GameWindow.ReadString(byteBuffer);
            this.count = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            for (n = 0; n < n2; ++n) {
                this.items.add(GameWindow.ReadString(byteBuffer));
            }
            n = byteBuffer.getInt();
            for (int i = 0; i < n; ++i) {
                this.skills.add(new Skill(GameWindow.ReadString(byteBuffer), byteBuffer.getInt()));
            }
        }

        public void write(ByteBufferWriter byteBufferWriter) {
            byteBufferWriter.putUTF(this.name);
            byteBufferWriter.putLong(this.crc);
            byteBufferWriter.putInt(this.timeToMake);
            byteBufferWriter.putUTF(this.type);
            byteBufferWriter.putUTF(this.module);
            byteBufferWriter.putInt(this.count);
            byteBufferWriter.putInt(this.items.size());
            for (String object : this.items) {
                byteBufferWriter.putUTF(object);
            }
            byteBufferWriter.putInt(this.skills.size());
            for (Skill skill : this.skills) {
                byteBufferWriter.putUTF(skill.name);
                byteBufferWriter.putInt(skill.value);
            }
        }

        public String getDescription() {
            return "\n\tRecipe: name=\"" + this.name + "\" crc=" + this.crc + " time=" + this.timeToMake + " type=\"" + this.type + "\" module=\"" + this.module + "\" count=" + this.count + " items=[" + String.join((CharSequence)",", this.items) + "] skills=[" + this.skills.stream().map(skill -> "\"" + skill.name + "\": " + skill.value).collect(Collectors.joining(",")) + "]";
        }

        public static class Skill {
            private final String name;
            private final int value;

            public Skill(String string, int n) {
                this.name = string;
                this.value = n;
            }
        }
    }

    public static enum CheckState {
        None,
        Sent,
        Success;

    }
}

