/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.NotificationEmitter;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.MovingObjectUpdateScheduler;
import zombie.VirtualZombieManager;
import zombie.characters.IsoPlayer;
import zombie.commands.PlayerType;
import zombie.core.Core;
import zombie.core.raknet.RakVoice;
import zombie.core.raknet.UdpConnection;
import zombie.core.raknet.VoiceManagerData;
import zombie.core.utils.UpdateLimit;
import zombie.core.znet.ZNetStatistics;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.debug.LogSeverity;
import zombie.iso.IsoWorld;
import zombie.iso.WorldStreamer;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.NetworkAIParams;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.popman.NetworkZombieManager;
import zombie.popman.NetworkZombieSimulator;
import zombie.util.StringUtils;

public class MPStatistics {
    private static final float MEM_USAGE_THRESHOLD = 0.95f;
    private static final long REQUEST_TIMEOUT = 10000L;
    private static final long STATISTICS_INTERVAL = 2000L;
    private static final long PING_INTERVAL = 1000L;
    private static final long PING_PERIOD = 10000L;
    private static final long PING_LIMIT_PERIOD = 60000L;
    private static final long PING_INTERVAL_COUNT = 60L;
    private static final long PING_LIMIT_COUNT = 20L;
    private static final long PING_LOG_COUNT = 120L;
    private static final long MAX_PING_TO_SUM = 1000L;
    private static final KahluaTable statsTable = LuaManager.platform.newTable();
    private static final KahluaTable statusTable = LuaManager.platform.newTable();
    private static final UpdateLimit ulRequestTimeout = new UpdateLimit(10000L);
    private static final UpdateLimit ulStatistics = new UpdateLimit(2000L);
    private static final UpdateLimit ulPing = new UpdateLimit(1000L);
    private static boolean serverStatisticsEnabled = false;
    private static int serverPlayers = 0;
    private static int clientPlayers = 0;
    private static int clientLastPing = -1;
    private static int clientAvgPing = -1;
    private static int clientMinPing = -1;
    private static String clientVOIPSource = "";
    private static String clientVOIPFreq = "";
    private static long clientVOIPRX = 0L;
    private static long clientVOIPTX = 0L;
    private static long serverVOIPRX = 0L;
    private static long serverVOIPTX = 0L;
    private static int serverWaitingRequests = 0;
    private static int clientSentRequests = 0;
    private static int requested1 = 0;
    private static int requested2 = 0;
    private static int pending1 = 0;
    private static int pending2 = 0;
    private static long serverCPUCores = 0L;
    private static long serverCPULoad = 0L;
    private static long serverMemMax = 0L;
    private static long serverMemFree = 0L;
    private static long serverMemTotal = 0L;
    private static long serverMemUsed = 0L;
    private static long serverRX = 0L;
    private static long serverTX = 0L;
    private static long serverResent = 0L;
    private static double serverLoss = 0.0;
    private static float serverFPS = 0.0f;
    private static long serverNetworkingUpdates = 0L;
    private static long serverNetworkingFPS = 0L;
    private static String serverRevision = "";
    private static long clientCPUCores = 0L;
    private static long clientCPULoad = 0L;
    private static long clientMemMax = 0L;
    private static long clientMemFree = 0L;
    private static long clientMemTotal = 0L;
    private static long clientMemUsed = 0L;
    private static long clientRX = 0L;
    private static long clientTX = 0L;
    private static long clientResent = 0L;
    private static double clientLoss = 0.0;
    private static float clientFPS = 0.0f;
    private static int serverStoredChunks = 0;
    private static int serverRelevantChunks = 0;
    private static int serverZombiesTotal = 0;
    private static int serverZombiesLoaded = 0;
    private static int serverZombiesSimulated = 0;
    private static int serverZombiesCulled = 0;
    private static int serverZombiesAuthorized = 0;
    private static int serverZombiesUnauthorized = 0;
    private static int serverZombiesReusable = 0;
    private static int serverZombiesUpdated = 0;
    private static int clientStoredChunks = 0;
    private static int clientRelevantChunks = 0;
    private static int clientZombiesTotal = 0;
    private static int clientZombiesLoaded = 0;
    private static int clientZombiesSimulated = 0;
    private static int clientZombiesCulled = 0;
    private static int clientZombiesAuthorized = 0;
    private static int clientZombiesUnauthorized = 0;
    private static int clientZombiesReusable = 0;
    private static int clientZombiesUpdated = 0;
    private static long zombieUpdates = 0L;
    private static long serverMinPing = 0L;
    private static long serverMaxPing = 0L;
    private static long serverAvgPing = 0L;
    private static long serverLastPing = 0L;
    private static long serverLossPing = 0L;
    private static long serverHandledPingPeriodStart = 0L;
    private static int serverHandledPingPacketIndex = 0;
    private static final ArrayList<Long> serverHandledPingHistory = new ArrayList();
    private static final HashSet<Long> serverHandledLossPingHistory = new HashSet();
    static long pingIntervalCount = 60L;
    static long pingLimitCount = 20L;
    static long maxPingToSum = 1000L;

    private static boolean isClientStatisticsEnabled() {
        boolean bl = false;
        for (IsoPlayer isoPlayer : IsoPlayer.players) {
            if (isoPlayer == null || !isoPlayer.isShowMPInfos()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static void getClientZombieStatistics() {
        int n = (int)Math.max(MovingObjectUpdateScheduler.instance.getFrameCounter() - zombieUpdates, 1L);
        clientZombiesTotal = GameClient.IDToZombieMap.values().length;
        clientZombiesLoaded = IsoWorld.instance.getCell().getZombieList().size();
        clientZombiesSimulated = clientZombiesUpdated / n;
        clientZombiesAuthorized = NetworkZombieSimulator.getInstance().getAuthorizedZombieCount();
        clientZombiesUnauthorized = NetworkZombieSimulator.getInstance().getUnauthorizedZombieCount();
        clientZombiesReusable = VirtualZombieManager.instance.reusableZombiesSize();
        clientZombiesCulled = 0;
        clientZombiesUpdated = 0;
        zombieUpdates = MovingObjectUpdateScheduler.instance.getFrameCounter();
        serverZombiesCulled = 0;
    }

    private static void getServerZombieStatistics() {
        int n = (int)Math.max(MovingObjectUpdateScheduler.instance.getFrameCounter() - zombieUpdates, 1L);
        serverZombiesTotal = ServerMap.instance.ZombieMap.size();
        serverZombiesLoaded = IsoWorld.instance.getCell().getZombieList().size();
        serverZombiesSimulated = serverZombiesUpdated / n;
        serverZombiesAuthorized = 0;
        serverZombiesUnauthorized = NetworkZombieManager.getInstance().getUnauthorizedZombieCount();
        serverZombiesReusable = VirtualZombieManager.instance.reusableZombiesSize();
        serverZombiesCulled = 0;
        serverZombiesUpdated = 0;
        zombieUpdates = MovingObjectUpdateScheduler.instance.getFrameCounter();
    }

    private static void getClientChunkStatistics() {
        try {
            WorldStreamer.instance.getStatistics();
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "Error getting chunk statistics", LogSeverity.Error);
        }
    }

    public static void countChunkRequests(int n, int n2, int n3, int n4, int n5) {
        clientSentRequests = n;
        requested1 = n2;
        requested2 = n3;
        pending1 = n4;
        pending2 = n5;
    }

    private static void resetStatistic() {
        if (GameClient.bClient) {
            GameClient.connection.netStatistics = null;
        } else if (GameServer.bServer) {
            for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
                udpConnection.netStatistics = null;
            }
        }
        serverPlayers = 0;
        clientPlayers = 0;
        clientVOIPSource = "";
        clientVOIPFreq = "";
        clientVOIPRX = 0L;
        clientVOIPTX = 0L;
        serverVOIPRX = 0L;
        serverVOIPTX = 0L;
        serverCPUCores = 0L;
        serverCPULoad = 0L;
        serverRX = 0L;
        serverTX = 0L;
        serverResent = 0L;
        serverLoss = 0.0;
        serverFPS = 0.0f;
        serverNetworkingFPS = 0L;
        serverMemMax = 0L;
        serverMemFree = 0L;
        serverMemTotal = 0L;
        serverMemUsed = 0L;
        clientCPUCores = 0L;
        clientCPULoad = 0L;
        clientRX = 0L;
        clientTX = 0L;
        clientResent = 0L;
        clientLoss = 0.0;
        clientFPS = 0.0f;
        clientMemMax = 0L;
        clientMemFree = 0L;
        clientMemTotal = 0L;
        clientMemUsed = 0L;
        serverZombiesTotal = 0;
        serverZombiesLoaded = 0;
        serverZombiesSimulated = 0;
        serverZombiesCulled = 0;
        serverZombiesAuthorized = 0;
        serverZombiesUnauthorized = 0;
        serverZombiesReusable = 0;
        serverZombiesUpdated = 0;
        clientZombiesTotal = 0;
        clientZombiesLoaded = 0;
        clientZombiesSimulated = 0;
        clientZombiesCulled = 0;
        clientZombiesAuthorized = 0;
        clientZombiesUnauthorized = 0;
        clientZombiesReusable = 0;
        clientZombiesUpdated = 0;
        serverWaitingRequests = 0;
        clientSentRequests = 0;
        requested1 = 0;
        requested2 = 0;
        pending1 = 0;
        pending2 = 0;
    }

    private static void getClientStatistics() {
        try {
            clientVOIPRX = 0L;
            clientVOIPTX = 0L;
            clientRX = 0L;
            clientTX = 0L;
            clientResent = 0L;
            clientLoss = 0.0;
            ZNetStatistics zNetStatistics = GameClient.connection.getStatistics();
            if (zNetStatistics != null) {
                clientRX = zNetStatistics.lastActualBytesReceived / 1000L;
                clientTX = zNetStatistics.lastActualBytesSent / 1000L;
                clientResent = zNetStatistics.lastUserMessageBytesResent / 1000L;
                clientLoss = zNetStatistics.packetlossLastSecond / 1000.0;
            }
            long[] lArray = new long[]{-1L, -1L};
            if (RakVoice.GetChannelStatistics(GameClient.connection.getConnectedGUID(), lArray)) {
                clientVOIPRX = lArray[0] / 2000L;
                clientVOIPTX = lArray[1] / 2000L;
            }
            clientFPS = 60.0f / GameTime.instance.FPSMultiplier;
            clientCPUCores = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
            clientCPULoad = (long)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad() * 100.0);
            clientMemMax = Runtime.getRuntime().maxMemory() / 1000L / 1000L;
            clientMemFree = Runtime.getRuntime().freeMemory() / 1000L / 1000L;
            clientMemTotal = Runtime.getRuntime().totalMemory() / 1000L / 1000L;
            clientMemUsed = clientMemTotal - clientMemFree;
            clientPlayers = 0;
            for (IsoPlayer isoPlayer : IsoPlayer.players) {
                if (isoPlayer == null) continue;
                ++clientPlayers;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getServerStatistics() {
        try {
            serverVOIPRX = 0L;
            serverVOIPTX = 0L;
            serverRX = 0L;
            serverTX = 0L;
            serverResent = 0L;
            serverLoss = 0.0;
            long[] lArray = new long[]{-1L, -1L};
            for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
                ZNetStatistics zNetStatistics = udpConnection.getStatistics();
                if (zNetStatistics != null) {
                    serverRX += udpConnection.netStatistics.lastActualBytesReceived;
                    serverTX += udpConnection.netStatistics.lastActualBytesSent;
                    serverResent += udpConnection.netStatistics.lastUserMessageBytesResent;
                    serverLoss += udpConnection.netStatistics.packetlossLastSecond;
                }
                if (!RakVoice.GetChannelStatistics(udpConnection.getConnectedGUID(), lArray)) continue;
                serverVOIPRX += lArray[0];
                serverVOIPTX += lArray[1];
            }
            serverRX /= 1000L;
            serverTX /= 1000L;
            serverResent /= 1000L;
            serverLoss /= 1000.0;
            serverVOIPRX /= 2000L;
            serverVOIPTX /= 2000L;
            serverFPS = 60.0f / GameTime.instance.FPSMultiplier;
            serverCPUCores = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
            serverCPULoad = (long)(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad() * 100.0);
            serverNetworkingFPS = 1000L * serverNetworkingUpdates / 2000L;
            serverNetworkingUpdates = 0L;
            serverMemMax = Runtime.getRuntime().maxMemory() / 1000L / 1000L;
            serverMemFree = Runtime.getRuntime().freeMemory() / 1000L / 1000L;
            serverMemTotal = Runtime.getRuntime().totalMemory() / 1000L / 1000L;
            serverMemUsed = serverMemTotal - serverMemFree;
            serverPlayers = GameServer.IDToPlayerMap.size();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void resetPingCounters() {
        clientLastPing = -1;
        clientAvgPing = -1;
        clientMinPing = -1;
    }

    private static void getPing(UdpConnection udpConnection) {
        try {
            if (udpConnection != null) {
                clientLastPing = udpConnection.getLastPing();
                clientAvgPing = udpConnection.getAveragePing();
                clientMinPing = udpConnection.getLowestPing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static long checkLatest(UdpConnection udpConnection, long l3) {
        long l4;
        if ((long)udpConnection.pingHistory.size() >= pingIntervalCount && (l4 = udpConnection.pingHistory.stream().limit(pingIntervalCount).filter(l2 -> l2 > l3).count()) >= pingLimitCount) {
            return (long)Math.ceil((float)udpConnection.pingHistory.stream().limit(pingIntervalCount).mapToLong(l -> Math.min(maxPingToSum, l)).sum() / (float)pingIntervalCount);
        }
        return 0L;
    }

    private static void limitPing() {
        int n = ServerOptions.instance.PingLimit.getValue();
        for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
            serverAvgPing = udpConnection.getAveragePing();
            serverLastPing = udpConnection.getLastPing();
            udpConnection.pingHistory.addFirst(serverLastPing);
            long l = MPStatistics.checkLatest(udpConnection, n);
            if (MPStatistics.doKick(udpConnection, l)) {
                GameServer.kick(udpConnection, "UI_Policy_Kick", "UI_OnConnectFailed_Ping");
                udpConnection.forceDisconnect("kick-ping-limit");
                GameServer.addDisconnect(udpConnection);
                DebugLog.Multiplayer.warn("Kick: player=\"%s\" type=\"%s\"", udpConnection.username, "UI_OnConnectFailed_Ping");
                DebugLog.Multiplayer.debugln("Ping: limit=%d/%d average-%d=%d", n, pingLimitCount, pingIntervalCount, l);
                DebugLog.Multiplayer.debugln("Ping: last-%d: %s", 120L, udpConnection.pingHistory.stream().map(Object::toString).collect(Collectors.joining(", ")));
            }
            if ((long)udpConnection.pingHistory.size() <= 120L) continue;
            udpConnection.pingHistory.removeLast();
        }
    }

    public static boolean doKickWhileLoading(UdpConnection udpConnection, long l) {
        int n = ServerOptions.instance.PingLimit.getValue();
        return (double)n > ServerOptions.instance.PingLimit.getMin() && l > (long)n && !udpConnection.preferredInQueue && !PlayerType.isPrivileged(udpConnection.accessLevel);
    }

    public static boolean doKick(UdpConnection udpConnection, long l) {
        return MPStatistics.doKickWhileLoading(udpConnection, l) && udpConnection.isFullyConnected() && udpConnection.isConnectionGraceIntervalTimeout();
    }

    private static void resetServerHandledPingCounters() {
        serverMinPing = 0L;
        serverMaxPing = 0L;
        serverAvgPing = 0L;
        serverLastPing = 0L;
        serverLossPing = 0L;
        serverHandledPingPeriodStart = 0L;
        serverHandledPingPacketIndex = 0;
        serverHandledPingHistory.clear();
        serverHandledLossPingHistory.clear();
    }

    private static void getServerHandledPing() {
        long l3 = System.currentTimeMillis();
        if ((long)serverHandledPingPacketIndex == 10L) {
            serverMinPing = serverHandledPingHistory.stream().mapToLong(l -> l).min().orElse(0L);
            serverMaxPing = serverHandledPingHistory.stream().mapToLong(l -> l).max().orElse(0L);
            serverAvgPing = (long)serverHandledPingHistory.stream().mapToLong(l -> l).average().orElse(0.0);
            serverHandledPingHistory.clear();
            serverHandledPingPacketIndex = 0;
            int n = serverHandledLossPingHistory.size();
            serverHandledLossPingHistory.removeIf(l2 -> l3 > l2 + 10000L);
            serverLossPing += (long)(n - serverHandledLossPingHistory.size());
            serverHandledPingPeriodStart = l3;
        }
        GameClient.sendServerPing(l3);
        if (serverHandledLossPingHistory.size() > 1000) {
            serverHandledLossPingHistory.clear();
        }
        serverHandledLossPingHistory.add(l3);
        ++serverHandledPingPacketIndex;
    }

    public static void setVOIPSource(VoiceManagerData.VoiceDataSource voiceDataSource, int n) {
        clientVOIPSource = VoiceManagerData.VoiceDataSource.Unknown.equals((Object)voiceDataSource) ? "" : voiceDataSource.name();
        clientVOIPFreq = n == 0 ? "" : String.valueOf((float)n / 1000.0f);
    }

    public static void countServerNetworkingFPS() {
        ++serverNetworkingUpdates;
    }

    public static void increaseStoredChunk() {
        if (GameClient.bClient) {
            ++clientStoredChunks;
        } else if (GameServer.bServer) {
            ++serverStoredChunks;
        }
        MPStatistics.decreaseRelevantChunk();
    }

    public static void decreaseStoredChunk() {
        if (GameClient.bClient) {
            --clientStoredChunks;
        } else if (GameServer.bServer) {
            --serverStoredChunks;
        }
        MPStatistics.increaseRelevantChunk();
    }

    public static void increaseRelevantChunk() {
        if (GameClient.bClient) {
            ++clientRelevantChunks;
        } else if (GameServer.bServer) {
            ++serverRelevantChunks;
        }
    }

    public static void decreaseRelevantChunk() {
        if (GameClient.bClient) {
            --clientRelevantChunks;
        } else if (GameServer.bServer) {
            --serverRelevantChunks;
        }
    }

    public static void Init() {
        if (GameServer.bServer || GameClient.bClient) {
            try {
                for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (!MemoryType.HEAP.equals((Object)memoryPoolMXBean.getType()) || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
                    long l = memoryPoolMXBean.getCollectionUsageThreshold();
                    String string = System.getProperty("zomboid.thresholdm");
                    if (!StringUtils.isNullOrEmpty(string)) {
                        l = Long.parseLong(string) * 1000000L;
                    }
                    if (l == 0L) {
                        l = (long)((float)Runtime.getRuntime().maxMemory() * 0.95f);
                        memoryPoolMXBean.setUsageThreshold(l);
                    }
                    if (l > 0L) {
                        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener((notification, object) -> DebugLog.Multiplayer.warn("[%s] %s (%d) free=%s", MPStatistics.class.getSimpleName(), "java.management.memory.threshold.exceeded", memoryPoolMXBean.getUsageThresholdCount(), NumberFormat.getNumberInstance().format(Runtime.getRuntime().freeMemory())), notification -> "java.management.memory.threshold.exceeded".equals(notification.getType()), null);
                    }
                    DebugLog.log(DebugType.Multiplayer, String.format("[%s] mem usage notification threshold=%s", MPStatistics.class.getSimpleName(), NumberFormat.getNumberInstance().format(l)));
                    break;
                }
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, String.format("[%s] init error", MPStatistics.class.getSimpleName()), LogSeverity.Error);
            }
            MPStatistics.Reset();
        }
    }

    public static void Reset() {
        MPStatistics.resetPingCounters();
        MPStatistics.resetServerHandledPingCounters();
        MPStatistics.resetStatistic();
    }

    public static void Update() {
        if (GameClient.bClient) {
            if (ulPing.Check()) {
                if (MPStatistics.isClientStatisticsEnabled() || NetworkAIParams.isShowPingInfo()) {
                    MPStatistics.getPing(GameClient.connection);
                    if (MPStatistics.isClientStatisticsEnabled()) {
                        MPStatistics.getServerHandledPing();
                    } else {
                        MPStatistics.resetServerHandledPingCounters();
                    }
                } else {
                    MPStatistics.resetPingCounters();
                    MPStatistics.resetServerHandledPingCounters();
                }
            }
            if (MPStatistics.isClientStatisticsEnabled()) {
                if (ulStatistics.Check()) {
                    MPStatistics.getClientStatistics();
                    MPStatistics.getClientZombieStatistics();
                    MPStatistics.getClientChunkStatistics();
                }
            } else {
                MPStatistics.resetStatistic();
            }
        } else if (GameServer.bServer) {
            if (ulPing.Check()) {
                MPStatistics.limitPing();
            }
            if (ulRequestTimeout.Check()) {
                serverStatisticsEnabled = false;
            }
            if (serverStatisticsEnabled) {
                if (ulStatistics.Check()) {
                    MPStatistics.getServerStatistics();
                    MPStatistics.getServerZombieStatistics();
                }
            } else {
                MPStatistics.resetStatistic();
            }
        }
    }

    public static void requested() {
        serverStatisticsEnabled = true;
        ulRequestTimeout.Reset(10000L);
    }

    public static void clientZombieCulled() {
        ++clientZombiesCulled;
    }

    public static void serverZombieCulled() {
        ++serverZombiesCulled;
    }

    public static void clientZombieUpdated() {
        ++clientZombiesUpdated;
    }

    public static void serverZombieUpdated() {
        ++serverZombiesUpdated;
    }

    public static void write(UdpConnection udpConnection, ByteBuffer byteBuffer) {
        byteBuffer.putLong(serverMemMax);
        byteBuffer.putLong(serverMemFree);
        byteBuffer.putLong(serverMemTotal);
        byteBuffer.putLong(serverMemUsed);
        byteBuffer.putLong(serverCPUCores);
        byteBuffer.putLong(serverCPULoad);
        byteBuffer.putLong(serverVOIPRX);
        byteBuffer.putLong(serverVOIPTX);
        byteBuffer.putLong(serverRX);
        byteBuffer.putLong(serverTX);
        byteBuffer.putLong(serverResent);
        byteBuffer.putDouble(serverLoss);
        byteBuffer.putFloat(serverFPS);
        byteBuffer.putLong(serverNetworkingFPS);
        byteBuffer.putInt(serverStoredChunks);
        byteBuffer.putInt(serverRelevantChunks);
        byteBuffer.putInt(serverZombiesTotal);
        byteBuffer.putInt(serverZombiesLoaded);
        byteBuffer.putInt(serverZombiesSimulated);
        byteBuffer.putInt(serverZombiesCulled);
        byteBuffer.putInt(NetworkZombieManager.getInstance().getAuthorizedZombieCount(udpConnection));
        byteBuffer.putInt(serverZombiesUnauthorized);
        byteBuffer.putInt(serverZombiesReusable);
        byteBuffer.putInt(udpConnection.playerDownloadServer.getWaitingRequests());
        byteBuffer.putInt(serverPlayers);
        GameWindow.WriteString(byteBuffer, "");
    }

    public static void parse(ByteBuffer byteBuffer) {
        long l = System.currentTimeMillis();
        long l2 = byteBuffer.getLong();
        serverMemMax = byteBuffer.getLong();
        serverMemFree = byteBuffer.getLong();
        serverMemTotal = byteBuffer.getLong();
        serverMemUsed = byteBuffer.getLong();
        serverCPUCores = byteBuffer.getLong();
        serverCPULoad = byteBuffer.getLong();
        serverVOIPRX = byteBuffer.getLong();
        serverVOIPTX = byteBuffer.getLong();
        serverRX = byteBuffer.getLong();
        serverTX = byteBuffer.getLong();
        serverResent = byteBuffer.getLong();
        serverLoss = byteBuffer.getDouble();
        serverFPS = byteBuffer.getFloat();
        serverNetworkingFPS = byteBuffer.getLong();
        serverStoredChunks = byteBuffer.getInt();
        serverRelevantChunks = byteBuffer.getInt();
        serverZombiesTotal = byteBuffer.getInt();
        serverZombiesLoaded = byteBuffer.getInt();
        serverZombiesSimulated = byteBuffer.getInt();
        serverZombiesCulled += byteBuffer.getInt();
        serverZombiesAuthorized = byteBuffer.getInt();
        serverZombiesUnauthorized = byteBuffer.getInt();
        serverZombiesReusable = byteBuffer.getInt();
        serverWaitingRequests = byteBuffer.getInt();
        serverPlayers = byteBuffer.getInt();
        serverRevision = GameWindow.ReadString(byteBuffer);
        serverHandledLossPingHistory.remove(l2);
        if (l2 >= serverHandledPingPeriodStart) {
            serverLastPing = l - l2;
            serverHandledPingHistory.add(serverLastPing);
        }
    }

    public static KahluaTable getLuaStatus() {
        statusTable.wipe();
        if (GameClient.bClient) {
            statusTable.rawset("serverTime", (Object)NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toSeconds(GameTime.getServerTime())));
            statusTable.rawset("svnRevision", (Object)"");
            statusTable.rawset("buildDate", (Object)"");
            statusTable.rawset("buildTime", (Object)"");
            statusTable.rawset("version", (Object)Core.getInstance().getVersion());
            statusTable.rawset("lastPing", (Object)String.valueOf(clientLastPing));
            statusTable.rawset("avgPing", (Object)String.valueOf(clientAvgPing));
            statusTable.rawset("minPing", (Object)String.valueOf(clientMinPing));
        }
        return statusTable;
    }

    public static KahluaTable getLuaStatistics() {
        statsTable.wipe();
        if (GameClient.bClient) {
            statsTable.rawset("clientTime", (Object)String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
            statsTable.rawset("serverTime", (Object)NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toSeconds(GameTime.getServerTime())));
            statsTable.rawset("clientRevision", (Object)String.valueOf(""));
            statsTable.rawset("serverRevision", (Object)String.valueOf(serverRevision));
            statsTable.rawset("clientPlayers", (Object)String.valueOf(clientPlayers));
            statsTable.rawset("serverPlayers", (Object)String.valueOf(serverPlayers));
            statsTable.rawset("clientVOIPSource", (Object)String.valueOf(clientVOIPSource));
            statsTable.rawset("clientVOIPFreq", (Object)String.valueOf(clientVOIPFreq));
            statsTable.rawset("clientVOIPRX", (Object)String.valueOf(clientVOIPRX));
            statsTable.rawset("clientVOIPTX", (Object)String.valueOf(clientVOIPTX));
            statsTable.rawset("clientRX", (Object)String.valueOf(clientRX));
            statsTable.rawset("clientTX", (Object)String.valueOf(clientTX));
            statsTable.rawset("clientResent", (Object)String.valueOf(clientResent));
            statsTable.rawset("clientLoss", (Object)String.valueOf((int)clientLoss));
            statsTable.rawset("serverVOIPRX", (Object)String.valueOf(serverVOIPRX));
            statsTable.rawset("serverVOIPTX", (Object)String.valueOf(serverVOIPTX));
            statsTable.rawset("serverRX", (Object)String.valueOf(serverRX));
            statsTable.rawset("serverTX", (Object)String.valueOf(serverTX));
            statsTable.rawset("serverResent", (Object)String.valueOf(serverResent));
            statsTable.rawset("serverLoss", (Object)String.valueOf((int)serverLoss));
            statsTable.rawset("clientLastPing", (Object)String.valueOf(clientLastPing));
            statsTable.rawset("clientAvgPing", (Object)String.valueOf(clientAvgPing));
            statsTable.rawset("clientMinPing", (Object)String.valueOf(clientMinPing));
            statsTable.rawset("serverPingLast", (Object)String.valueOf(serverLastPing));
            statsTable.rawset("serverPingMin", (Object)String.valueOf(serverMinPing));
            statsTable.rawset("serverPingAvg", (Object)String.valueOf(serverAvgPing));
            statsTable.rawset("serverPingMax", (Object)String.valueOf(serverMaxPing));
            statsTable.rawset("serverPingLoss", (Object)String.valueOf(serverLossPing));
            statsTable.rawset("clientCPUCores", (Object)String.valueOf(clientCPUCores));
            statsTable.rawset("clientCPULoad", (Object)String.valueOf(clientCPULoad));
            statsTable.rawset("clientMemMax", (Object)String.valueOf(clientMemMax));
            statsTable.rawset("clientMemFree", (Object)String.valueOf(clientMemFree));
            statsTable.rawset("clientMemTotal", (Object)String.valueOf(clientMemTotal));
            statsTable.rawset("clientMemUsed", (Object)String.valueOf(clientMemUsed));
            statsTable.rawset("serverCPUCores", (Object)String.valueOf(serverCPUCores));
            statsTable.rawset("serverCPULoad", (Object)String.valueOf(serverCPULoad));
            statsTable.rawset("serverMemMax", (Object)String.valueOf(serverMemMax));
            statsTable.rawset("serverMemFree", (Object)String.valueOf(serverMemFree));
            statsTable.rawset("serverMemTotal", (Object)String.valueOf(serverMemTotal));
            statsTable.rawset("serverMemUsed", (Object)String.valueOf(serverMemUsed));
            statsTable.rawset("serverNetworkingFPS", (Object)String.valueOf((int)serverNetworkingFPS));
            statsTable.rawset("serverFPS", (Object)String.valueOf((int)serverFPS));
            statsTable.rawset("clientFPS", (Object)String.valueOf((int)clientFPS));
            statsTable.rawset("serverStoredChunks", (Object)String.valueOf(serverStoredChunks));
            statsTable.rawset("serverRelevantChunks", (Object)String.valueOf(serverRelevantChunks));
            statsTable.rawset("serverZombiesTotal", (Object)String.valueOf(serverZombiesTotal));
            statsTable.rawset("serverZombiesLoaded", (Object)String.valueOf(serverZombiesLoaded));
            statsTable.rawset("serverZombiesSimulated", (Object)String.valueOf(serverZombiesSimulated));
            statsTable.rawset("serverZombiesCulled", (Object)String.valueOf(serverZombiesCulled));
            statsTable.rawset("serverZombiesAuthorized", (Object)String.valueOf(serverZombiesAuthorized));
            statsTable.rawset("serverZombiesUnauthorized", (Object)String.valueOf(serverZombiesUnauthorized));
            statsTable.rawset("serverZombiesReusable", (Object)String.valueOf(serverZombiesReusable));
            statsTable.rawset("clientStoredChunks", (Object)String.valueOf(clientStoredChunks));
            statsTable.rawset("clientRelevantChunks", (Object)String.valueOf(clientRelevantChunks));
            statsTable.rawset("clientZombiesTotal", (Object)String.valueOf(clientZombiesTotal));
            statsTable.rawset("clientZombiesLoaded", (Object)String.valueOf(clientZombiesLoaded));
            statsTable.rawset("clientZombiesSimulated", (Object)String.valueOf(clientZombiesSimulated));
            statsTable.rawset("clientZombiesCulled", (Object)String.valueOf(clientZombiesCulled));
            statsTable.rawset("clientZombiesAuthorized", (Object)String.valueOf(clientZombiesAuthorized));
            statsTable.rawset("clientZombiesUnauthorized", (Object)String.valueOf(clientZombiesUnauthorized));
            statsTable.rawset("clientZombiesReusable", (Object)String.valueOf(clientZombiesReusable));
            statsTable.rawset("serverWaitingRequests", (Object)String.valueOf(serverWaitingRequests));
            statsTable.rawset("clientSentRequests", (Object)String.valueOf(clientSentRequests));
            statsTable.rawset("requested1", (Object)String.valueOf(requested1));
            statsTable.rawset("requested2", (Object)String.valueOf(requested2));
            statsTable.rawset("pending1", (Object)String.valueOf(pending1));
            statsTable.rawset("pending2", (Object)String.valueOf(pending2));
        }
        return statsTable;
    }
}

