/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.util.Arrays;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.iso.IsoUtils;
import zombie.network.GameClient;

public class MPStatisticClient {
    public static MPStatisticClient instance = new MPStatisticClient();
    private boolean needUpdate = true;
    private int zombiesLocalOwnership = 0;
    private float zombiesDesyncAVG = 0.0f;
    private float zombiesDesyncMax = 0.0f;
    private int zombiesTeleports = 0;
    private float remotePlayersDesyncAVG = 0.0f;
    private float remotePlayersDesyncMax = 0.0f;
    private int remotePlayersTeleports = 0;
    private float FPS = 0.0f;
    long lastRender = System.currentTimeMillis();
    short FPSAcc = 0;
    private float[] fpsArray = new float[1000];
    private short fpsArrayCount = 0;

    public static MPStatisticClient getInstance() {
        return instance;
    }

    public void incrementZombiesTeleports() {
        ++this.zombiesTeleports;
    }

    public void incrementRemotePlayersTeleports() {
        ++this.remotePlayersTeleports;
    }

    public float getFPS() {
        return this.FPS;
    }

    public void update() {
        if (this.needUpdate) {
            float f;
            this.needUpdate = false;
            for (int i = 0; i < GameClient.IDToZombieMap.values().length; ++i) {
                IsoZombie isoGameCharacter = (IsoZombie)GameClient.IDToZombieMap.values()[i];
                if (!isoGameCharacter.isRemoteZombie()) {
                    ++this.zombiesLocalOwnership;
                    continue;
                }
                f = IsoUtils.DistanceTo(isoGameCharacter.x, isoGameCharacter.y, isoGameCharacter.z, isoGameCharacter.realx, isoGameCharacter.realy, isoGameCharacter.realz);
                this.zombiesDesyncAVG += (f - this.zombiesDesyncAVG) * 0.05f;
                if (!(f > this.zombiesDesyncMax)) continue;
                this.zombiesDesyncMax = f;
            }
            for (IsoPlayer isoPlayer : GameClient.IDToPlayerMap.values()) {
                if (isoPlayer.isLocalPlayer()) continue;
                f = IsoUtils.DistanceTo(isoPlayer.x, isoPlayer.y, isoPlayer.z, isoPlayer.realx, isoPlayer.realy, isoPlayer.realz);
                this.remotePlayersDesyncAVG += (f - this.remotePlayersDesyncAVG) * 0.05f;
                if (!(f > this.remotePlayersDesyncMax)) continue;
                this.remotePlayersDesyncMax = f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(GameClient.IDToZombieMap.size());
        byteBufferWriter.putInt(this.zombiesLocalOwnership);
        byteBufferWriter.putFloat(this.zombiesDesyncAVG);
        byteBufferWriter.putFloat(this.zombiesDesyncMax);
        byteBufferWriter.putInt(this.zombiesTeleports);
        byteBufferWriter.putInt(GameClient.IDToPlayerMap.size());
        byteBufferWriter.putFloat(this.remotePlayersDesyncAVG);
        byteBufferWriter.putFloat(this.remotePlayersDesyncMax);
        byteBufferWriter.putInt(this.remotePlayersTeleports);
        float[] fArray = null;
        int n = 0;
        float[] fArray2 = this.fpsArray;
        synchronized (this.fpsArray) {
            int n2;
            float f;
            fArray = (float[])this.fpsArray.clone();
            Arrays.fill(this.fpsArray, 0, (int)this.fpsArrayCount, 0.0f);
            n = this.fpsArrayCount;
            this.fpsArrayCount = 0;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            float f2 = fArray[0];
            float f3 = fArray[0];
            float f4 = fArray[0];
            short[] sArray = new short[32];
            Arrays.fill(sArray, (short)0);
            for (int i = 1; i < n; ++i) {
                f = fArray[i];
                if (f2 > f) {
                    f2 = f;
                }
                if (f4 < f) {
                    f4 = f;
                }
                f3 += f;
            }
            if ((f3 /= (float)n) < f2 + 16.0f) {
                f2 = f3 - 16.0f;
            }
            if (f4 < f3 + 16.0f) {
                f4 = f3 + 16.0f;
            }
            float f5 = (f3 - f2) / (float)(sArray.length / 2);
            f = (f4 - f3) / (float)(sArray.length / 2);
            for (n2 = 0; n2 < n; ++n2) {
                int n3;
                float f6 = fArray[n2];
                if (f6 < f3) {
                    int n4 = n3 = (int)Math.ceil((f6 - f2) / f5);
                    sArray[n4] = (short)(sArray[n4] + 1);
                }
                if (!(f6 >= f3)) continue;
                int n5 = n3 = (int)Math.ceil((f6 - f3) / f) + sArray.length / 2 - 1;
                sArray[n5] = (short)(sArray[n5] + 1);
            }
            byteBufferWriter.putFloat(this.FPS);
            byteBufferWriter.putFloat(f2);
            byteBufferWriter.putFloat(f3);
            byteBufferWriter.putFloat(f4);
            for (n2 = 0; n2 < sArray.length; ++n2) {
                byteBufferWriter.putShort(sArray[n2]);
            }
            this.zombiesDesyncMax = 0.0f;
            this.zombiesTeleports = 0;
            this.remotePlayersDesyncMax = 0.0f;
            this.remotePlayersTeleports = 0;
            this.zombiesLocalOwnership = 0;
            this.needUpdate = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fpsProcess() {
        this.FPSAcc = (short)(this.FPSAcc + 1);
        long l = System.currentTimeMillis();
        if (l - this.lastRender < 1000L) return;
        this.FPS = this.FPSAcc;
        this.FPSAcc = 0;
        this.lastRender = l;
        if (this.fpsArrayCount >= this.fpsArray.length) return;
        float[] fArray = this.fpsArray;
        synchronized (this.fpsArray) {
            this.fpsArray[this.fpsArrayCount] = this.FPS;
            this.fpsArrayCount = (short)(this.fpsArrayCount + 1);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }
}

