/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import zombie.core.logger.ExceptionLogger;
import zombie.core.znet.ISteamWorkshopCallback;
import zombie.core.znet.SteamUGCDetails;
import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshop;
import zombie.core.znet.SteamWorkshopItem;
import zombie.debug.DebugLog;
import zombie.network.GameServer;

public class GameServerWorkshopItems {
    private static void noise(String string) {
        DebugLog.log("Workshop: " + string);
    }

    public static boolean Install(ArrayList<Long> arrayList) {
        int n;
        Object object;
        if (!GameServer.bServer) {
            return false;
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        ArrayList<WorkshopItem> arrayList2 = new ArrayList<WorkshopItem>();
        for (long l : arrayList) {
            object = new WorkshopItem(l);
            arrayList2.add((WorkshopItem)object);
        }
        if (!GameServerWorkshopItems.QueryItemDetails(arrayList2)) {
            return false;
        }
        while (true) {
            SteamUtils.runLoop();
            n = 0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                WorkshopItem workshopItem = arrayList2.get(i);
                workshopItem.update();
                if (workshopItem.state == WorkshopInstallState.Fail) {
                    return false;
                }
                if (workshopItem.state == WorkshopInstallState.Ready) continue;
                n = 1;
                break;
            }
            if (n == 0) break;
            try {
                Thread.sleep(33L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        GameServer.WorkshopInstallFolders = new String[arrayList.size()];
        GameServer.WorkshopTimeStamps = new long[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            long l = arrayList.get(n);
            object = SteamWorkshop.instance.GetItemInstallFolder(l);
            if (object == null) {
                GameServerWorkshopItems.noise("GetItemInstallFolder() failed ID=" + l);
                return false;
            }
            GameServerWorkshopItems.noise(l + " installed to " + (String)object);
            GameServer.WorkshopInstallFolders[n] = object;
            GameServer.WorkshopTimeStamps[n] = SteamWorkshop.instance.GetItemInstallTimeStamp(l);
        }
        return true;
    }

    private static boolean QueryItemDetails(ArrayList<WorkshopItem> arrayList) {
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            WorkshopItem workshopItem = arrayList.get(i);
            lArray[i] = workshopItem.ID;
        }
        ItemQuery itemQuery = new ItemQuery();
        itemQuery.handle = SteamWorkshop.instance.CreateQueryUGCDetailsRequest(lArray, itemQuery);
        if (itemQuery.handle == 0L) {
            return false;
        }
        while (true) {
            SteamUtils.runLoop();
            if (itemQuery.isCompleted()) break;
            if (itemQuery.isNotCompleted()) {
                return false;
            }
            try {
                Thread.sleep(33L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        block4: for (SteamUGCDetails steamUGCDetails : itemQuery.details) {
            for (WorkshopItem workshopItem : arrayList) {
                if (workshopItem.ID != steamUGCDetails.getID()) continue;
                workshopItem.details = steamUGCDetails;
                continue block4;
            }
        }
        return true;
    }

    private static class WorkshopItem
    implements ISteamWorkshopCallback {
        long ID;
        WorkshopInstallState state = WorkshopInstallState.CheckItemState;
        long downloadStartTime;
        long downloadQueryTime;
        String error;
        SteamUGCDetails details;

        WorkshopItem(long l) {
            this.ID = l;
        }

        void update() {
            switch (this.state) {
                case CheckItemState: {
                    this.CheckItemState();
                    break;
                }
                case DownloadPending: {
                    this.DownloadPending();
                    break;
                }
            }
        }

        void setState(WorkshopInstallState workshopInstallState) {
            GameServerWorkshopItems.noise("item state " + this.state + " -> " + workshopInstallState + " ID=" + this.ID);
            this.state = workshopInstallState;
        }

        void CheckItemState() {
            long l = SteamWorkshop.instance.GetItemState(this.ID);
            GameServerWorkshopItems.noise("GetItemState()=" + SteamWorkshopItem.ItemState.toString(l) + " ID=" + this.ID);
            if (SteamWorkshopItem.ItemState.Installed.and(l) && this.details != null && this.details.getTimeCreated() != 0L && this.details.getTimeUpdated() != SteamWorkshop.instance.GetItemInstallTimeStamp(this.ID)) {
                GameServerWorkshopItems.noise("Installed status but timeUpdated doesn't match!!!");
                this.RemoveFolderForReinstall();
                l |= (long)SteamWorkshopItem.ItemState.NeedsUpdate.getValue();
            }
            if (l == (long)SteamWorkshopItem.ItemState.None.getValue() || SteamWorkshopItem.ItemState.NeedsUpdate.and(l)) {
                if (SteamWorkshop.instance.DownloadItem(this.ID, true, this)) {
                    this.setState(WorkshopInstallState.DownloadPending);
                    this.downloadStartTime = System.currentTimeMillis();
                    return;
                }
                this.error = "DownloadItemFalse";
                this.setState(WorkshopInstallState.Fail);
                return;
            }
            if (SteamWorkshopItem.ItemState.Installed.and(l)) {
                this.setState(WorkshopInstallState.Ready);
                return;
            }
            this.error = "UnknownItemState";
            this.setState(WorkshopInstallState.Fail);
        }

        void RemoveFolderForReinstall() {
            String string = SteamWorkshop.instance.GetItemInstallFolder(this.ID);
            if (string == null) {
                GameServerWorkshopItems.noise("not removing install folder because GetItemInstallFolder() failed ID=" + this.ID);
                return;
            }
            Path path = Paths.get(string, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                GameServerWorkshopItems.noise("not removing install folder because it does not exist : \"" + string + "\"");
                return;
            }
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }

        void DownloadPending() {
            long l = System.currentTimeMillis();
            if (this.downloadQueryTime + 100L > l) {
                return;
            }
            this.downloadQueryTime = l;
            long l2 = SteamWorkshop.instance.GetItemState(this.ID);
            GameServerWorkshopItems.noise("DownloadPending GetItemState()=" + SteamWorkshopItem.ItemState.toString(l2) + " ID=" + this.ID);
            if (SteamWorkshopItem.ItemState.NeedsUpdate.and(l2)) {
                long[] lArray = new long[2];
                if (SteamWorkshop.instance.GetItemDownloadInfo(this.ID, lArray)) {
                    GameServerWorkshopItems.noise("download " + lArray[0] + "/" + lArray[1] + " ID=" + this.ID);
                }
                return;
            }
        }

        @Override
        public void onItemCreated(long l, boolean bl) {
        }

        @Override
        public void onItemNotCreated(int n) {
        }

        @Override
        public void onItemUpdated(boolean bl) {
        }

        @Override
        public void onItemNotUpdated(int n) {
        }

        @Override
        public void onItemSubscribed(long l) {
            GameServerWorkshopItems.noise("onItemSubscribed itemID=" + l);
        }

        @Override
        public void onItemNotSubscribed(long l, int n) {
            GameServerWorkshopItems.noise("onItemNotSubscribed itemID=" + l + " result=" + n);
        }

        @Override
        public void onItemDownloaded(long l) {
            GameServerWorkshopItems.noise("onItemDownloaded itemID=" + l + " time=" + (System.currentTimeMillis() - this.downloadStartTime) + " ms");
            if (l != this.ID) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            this.setState(WorkshopInstallState.CheckItemState);
        }

        @Override
        public void onItemNotDownloaded(long l, int n) {
            GameServerWorkshopItems.noise("onItemNotDownloaded itemID=" + l + " result=" + n);
            if (l != this.ID) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            this.error = "ItemNotDownloaded";
            this.setState(WorkshopInstallState.Fail);
        }

        @Override
        public void onItemQueryCompleted(long l, int n) {
            GameServerWorkshopItems.noise("onItemQueryCompleted handle=" + l + " numResult=" + n);
        }

        @Override
        public void onItemQueryNotCompleted(long l, int n) {
            GameServerWorkshopItems.noise("onItemQueryNotCompleted handle=" + l + " result=" + n);
        }
    }

    private static enum WorkshopInstallState {
        CheckItemState,
        DownloadPending,
        Ready,
        Fail;

    }

    private static final class ItemQuery
    implements ISteamWorkshopCallback {
        long handle;
        ArrayList<SteamUGCDetails> details;
        boolean bCompleted;
        boolean bNotCompleted;

        private ItemQuery() {
        }

        public boolean isCompleted() {
            return this.bCompleted;
        }

        public boolean isNotCompleted() {
            return this.bNotCompleted;
        }

        @Override
        public void onItemCreated(long l, boolean bl) {
        }

        @Override
        public void onItemNotCreated(int n) {
        }

        @Override
        public void onItemUpdated(boolean bl) {
        }

        @Override
        public void onItemNotUpdated(int n) {
        }

        @Override
        public void onItemSubscribed(long l) {
        }

        @Override
        public void onItemNotSubscribed(long l, int n) {
        }

        @Override
        public void onItemDownloaded(long l) {
        }

        @Override
        public void onItemNotDownloaded(long l, int n) {
        }

        @Override
        public void onItemQueryCompleted(long l, int n) {
            GameServerWorkshopItems.noise("onItemQueryCompleted handle=" + l + " numResult=" + n);
            if (l != this.handle) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            ArrayList<SteamUGCDetails> arrayList = new ArrayList<SteamUGCDetails>();
            for (int i = 0; i < n; ++i) {
                SteamUGCDetails steamUGCDetails = SteamWorkshop.instance.GetQueryUGCResult(l, i);
                if (steamUGCDetails == null) continue;
                arrayList.add(steamUGCDetails);
            }
            this.details = arrayList;
            SteamWorkshop.instance.ReleaseQueryUGCRequest(l);
            this.bCompleted = true;
        }

        @Override
        public void onItemQueryNotCompleted(long l, int n) {
            GameServerWorkshopItems.noise("onItemQueryNotCompleted handle=" + l + " result=" + n);
            if (l != this.handle) {
                return;
            }
            SteamWorkshop.instance.RemoveCallback(this);
            SteamWorkshop.instance.ReleaseQueryUGCRequest(l);
            this.bNotCompleted = true;
        }
    }
}

