/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.AmbientSoundManager;
import zombie.AmbientStreamManager;
import zombie.DebugFileWatcher;
import zombie.GameProfiler;
import zombie.GameSounds;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.MapCollisionData;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.VirtualZombieManager;
import zombie.WorldSoundManager;
import zombie.ZomboidFileSystem;
import zombie.ZomboidGlobals;
import zombie.asset.AssetManagers;
import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.Faction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.Safety;
import zombie.characters.SafetySystemManager;
import zombie.characters.SurvivorDesc;
import zombie.characters.SurvivorFactory;
import zombie.characters.skills.CustomPerks;
import zombie.characters.skills.PerkFactory;
import zombie.commands.CommandBase;
import zombie.commands.PlayerType;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Languages;
import zombie.core.PerformanceSettings;
import zombie.core.ProxyPrintStream;
import zombie.core.Rand;
import zombie.core.ThreadGroups;
import zombie.core.Translator;
import zombie.core.backup.ZipBackup;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.LoggerManager;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferReader;
import zombie.core.network.ByteBufferWriter;
import zombie.core.profiling.PerformanceProfileFrameProbe;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.raknet.RakNetPeerInterface;
import zombie.core.raknet.RakVoice;
import zombie.core.raknet.UdpConnection;
import zombie.core.raknet.UdpEngine;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AnimNodeAssetManager;
import zombie.core.skinnedmodel.model.AiSceneAsset;
import zombie.core.skinnedmodel.model.AiSceneAssetManager;
import zombie.core.skinnedmodel.model.AnimationAsset;
import zombie.core.skinnedmodel.model.AnimationAssetManager;
import zombie.core.skinnedmodel.model.MeshAssetManager;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelAssetManager;
import zombie.core.skinnedmodel.model.ModelMesh;
import zombie.core.skinnedmodel.model.jassimp.JAssImpImporter;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingDecals;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemAssetManager;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.stash.StashSystem;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureAssetManager;
import zombie.core.textures.TextureID;
import zombie.core.textures.TextureIDAssetManager;
import zombie.core.utils.UpdateLimit;
import zombie.core.znet.PortMapper;
import zombie.core.znet.SteamGameServer;
import zombie.core.znet.SteamUtils;
import zombie.core.znet.SteamWorkshop;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.debug.LogSeverity;
import zombie.erosion.ErosionMain;
import zombie.gameStates.IngameState;
import zombie.globalObjects.SGlobalObjectNetwork;
import zombie.globalObjects.SGlobalObjects;
import zombie.inventory.CompressIdenticalItems;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.inventory.RecipeManager;
import zombie.inventory.types.AlarmClock;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Radio;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.ObjectsSyncRequests;
import zombie.iso.RoomDef;
import zombie.iso.SpawnPoints;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.iso.areas.NonPvpZone;
import zombie.iso.areas.SafeHouse;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.objects.BSFurnace;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoCompost;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoFire;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoMannequin;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTrap;
import zombie.iso.objects.IsoWaveSignal;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.objects.RainManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.iso.weather.ClimateManager;
import zombie.network.BodyDamageSync;
import zombie.network.ClientServerMap;
import zombie.network.ConnectionManager;
import zombie.network.CoopSlave;
import zombie.network.DBResult;
import zombie.network.DBSchema;
import zombie.network.DBTicket;
import zombie.network.DiscordBot;
import zombie.network.GameClient;
import zombie.network.GameServerWorkshopItems;
import zombie.network.IZomboidPacket;
import zombie.network.LoginQueue;
import zombie.network.MPStatistic;
import zombie.network.MPStatistics;
import zombie.network.NetChecksum;
import zombie.network.NetworkAIParams;
import zombie.network.PacketTypes;
import zombie.network.PacketValidator;
import zombie.network.PassengerMap;
import zombie.network.PlayerDownloadServer;
import zombie.network.RCONServer;
import zombie.network.RequestDataManager;
import zombie.network.ServerGUI;
import zombie.network.ServerLOS;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.network.ServerPlayersVehicles;
import zombie.network.ServerWorldDatabase;
import zombie.network.TableNetworkUtils;
import zombie.network.Userlog;
import zombie.network.WorldItemTypes;
import zombie.network.ZomboidNetData;
import zombie.network.ZomboidNetDataPool;
import zombie.network.chat.ChatServer;
import zombie.network.packets.ActionPacket;
import zombie.network.packets.AddXp;
import zombie.network.packets.CleanBurn;
import zombie.network.packets.DeadPlayerPacket;
import zombie.network.packets.DeadZombiePacket;
import zombie.network.packets.Disinfect;
import zombie.network.packets.EventPacket;
import zombie.network.packets.PlaySoundPacket;
import zombie.network.packets.PlayWorldSoundPacket;
import zombie.network.packets.PlayerDataRequestPacket;
import zombie.network.packets.PlayerPacket;
import zombie.network.packets.RemoveBullet;
import zombie.network.packets.RemoveCorpseFromMap;
import zombie.network.packets.RemoveGlass;
import zombie.network.packets.RequestDataPacket;
import zombie.network.packets.SafetyPacket;
import zombie.network.packets.StartFire;
import zombie.network.packets.Stitch;
import zombie.network.packets.StopSoundPacket;
import zombie.network.packets.SyncClothingPacket;
import zombie.network.packets.SyncInjuriesPacket;
import zombie.network.packets.SyncNonPvpZonePacket;
import zombie.network.packets.SyncSafehousePacket;
import zombie.network.packets.ValidatePacket;
import zombie.network.packets.WaveSignal;
import zombie.network.packets.hit.HitCharacterPacket;
import zombie.popman.MPDebugInfo;
import zombie.popman.NetworkZombieManager;
import zombie.popman.NetworkZombiePacker;
import zombie.popman.ZombiePopulationManager;
import zombie.radio.ZomboidRadio;
import zombie.radio.devices.DeviceData;
import zombie.sandbox.CustomSandboxOptions;
import zombie.savefile.ServerPlayerDB;
import zombie.scripting.ScriptManager;
import zombie.util.PZSQLUtils;
import zombie.util.PublicServerUtil;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.Clipper;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehicleManager;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehiclesDB2;
import zombie.world.moddata.GlobalModData;
import zombie.worldMap.WorldMapRemotePlayer;
import zombie.worldMap.WorldMapRemotePlayers;

public class GameServer {
    public static final int MAX_PLAYERS = 512;
    public static final int TimeLimitForProcessPackets = 70;
    public static final int PacketsUpdateRate = 200;
    public static final int FPS = 10;
    private static final HashMap<String, CCFilter> ccFilters = new HashMap();
    public static int test = 432432;
    public static int DEFAULT_PORT = 16261;
    public static int UDPPort = 16262;
    public static String IPCommandline = null;
    public static int PortCommandline = -1;
    public static int UDPPortCommandline = -1;
    public static Boolean SteamVACCommandline;
    public static boolean GUICommandline;
    public static boolean bServer;
    public static boolean bCoop;
    public static boolean bDebug;
    public static boolean bSoftReset;
    public static UdpEngine udpEngine;
    public static final HashMap<Short, Long> IDToAddressMap;
    public static final HashMap<Short, IsoPlayer> IDToPlayerMap;
    public static final ArrayList<IsoPlayer> Players;
    public static float timeSinceKeepAlive;
    public static int MaxTicksSinceKeepAliveBeforeStall;
    public static final HashSet<UdpConnection> DebugPlayer;
    public static int ResetID;
    public static final ArrayList<String> ServerMods;
    public static final ArrayList<Long> WorkshopItems;
    public static String[] WorkshopInstallFolders;
    public static long[] WorkshopTimeStamps;
    public static String ServerName;
    public static final DiscordBot discordBot;
    public static String checksum;
    public static String GameMap;
    public static boolean bFastForward;
    public static final HashMap<String, Integer> transactionIDMap;
    public static final ObjectsSyncRequests worldObjectsServerSyncReq;
    public static String ip;
    static int count;
    private static final UdpConnection[] SlotToConnection;
    private static final HashMap<IsoPlayer, Long> PlayerToAddressMap;
    private static final ArrayList<Integer> alreadyRemoved;
    private static boolean bDone;
    private static boolean launched;
    private static final ArrayList<String> consoleCommands;
    private static final HashMap<Long, IZomboidPacket> MainLoopPlayerUpdate;
    private static final ConcurrentLinkedQueue<IZomboidPacket> MainLoopPlayerUpdateQ;
    private static final ConcurrentLinkedQueue<IZomboidPacket> MainLoopNetDataHighPriorityQ;
    private static final ConcurrentLinkedQueue<IZomboidPacket> MainLoopNetDataQ;
    private static final ArrayList<IZomboidPacket> MainLoopNetData2;
    private static final HashMap<Short, Vector2> playerToCoordsMap;
    private static final HashMap<Short, Integer> playerMovedToFastMap;
    private static ByteBuffer large_file_bb;
    private static long previousSave;
    private String poisonousBerry = null;
    private String poisonousMushroom = null;
    private String difficulty = "Hardcore";
    private static int droppedPackets;
    private static int countOfDroppedPackets;
    private static int countOfDroppedConnections;
    public static UdpConnection removeZombiesConnection;
    private static UpdateLimit calcCountPlayersInRelevantPositionLimiter;
    private static UpdateLimit sendWorldMapPlayerPositionLimiter;
    public static LoginQueue loginQueue;
    private static int mainCycleExceptionLogCount;
    public static Thread MainThread;
    public static final ArrayList<IsoPlayer> tempPlayers;

    public static void PauseAllClients() {
        String string = "[SERVERMSG] Server saving...Please wait";
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.StartPause.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            PacketTypes.PacketType.StartPause.send(udpConnection);
        }
    }

    public static void UnPauseAllClients() {
        String string = "[SERVERMSG] Server saved game...enjoy :)";
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.StopPause.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            PacketTypes.PacketType.StopPause.send(udpConnection);
        }
    }

    private static String parseIPFromCommandline(String[] stringArray, int n, String string) {
        if (n == stringArray.length - 1) {
            DebugLog.log("expected argument after \"" + string + "\"");
            System.exit(0);
        } else if (stringArray[n + 1].trim().isEmpty()) {
            DebugLog.log("empty argument given to \"\" + option + \"\"");
            System.exit(0);
        } else {
            String[] stringArray2 = stringArray[n + 1].trim().split("\\.");
            if (stringArray2.length == 4) {
                for (int i = 0; i < 4; ++i) {
                    try {
                        int n2 = Integer.parseInt(stringArray2[i]);
                        if (n2 >= 0 && n2 <= 255) continue;
                        DebugLog.log("expected IP address after \"" + string + "\", got \"" + stringArray[n + 1] + "\"");
                        System.exit(0);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        DebugLog.log("expected IP address after \"" + string + "\", got \"" + stringArray[n + 1] + "\"");
                        System.exit(0);
                    }
                }
            } else {
                DebugLog.log("expected IP address after \"" + string + "\", got \"" + stringArray[n + 1] + "\"");
                System.exit(0);
            }
        }
        return stringArray[n + 1];
    }

    private static int parsePortFromCommandline(String[] stringArray, int n, String string) {
        if (n == stringArray.length - 1) {
            DebugLog.log("expected argument after \"" + string + "\"");
            System.exit(0);
        } else if (stringArray[n + 1].trim().isEmpty()) {
            DebugLog.log("empty argument given to \"" + string + "\"");
            System.exit(0);
        } else {
            try {
                return Integer.parseInt(stringArray[n + 1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                DebugLog.log("expected an integer after \"" + string + "\"");
                System.exit(0);
            }
        }
        return -1;
    }

    private static boolean parseBooleanFromCommandline(String[] stringArray, int n, String string) {
        if (n == stringArray.length - 1) {
            DebugLog.log("expected argument after \"" + string + "\"");
            System.exit(0);
        } else if (stringArray[n + 1].trim().isEmpty()) {
            DebugLog.log("empty argument given to \"" + string + "\"");
            System.exit(0);
        } else {
            String string2 = stringArray[n + 1].trim();
            if ("true".equalsIgnoreCase(string2)) {
                return true;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return false;
            }
            DebugLog.log("expected true or false after \"" + string + "\"");
            System.exit(0);
        }
        return false;
    }

    public static void setupCoop() throws FileNotFoundException {
        CoopSlave.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n;
        Object object;
        String[] stringArray2;
        Object object2;
        MainThread = Thread.currentThread();
        bServer = true;
        bSoftReset = System.getProperty("softreset") != null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].startsWith("-cachedir=")) {
                ZomboidFileSystem.instance.setCacheDir(stringArray[i].replace("-cachedir=", "").trim());
                continue;
            }
            if (!stringArray[i].equals("-coop")) continue;
            bCoop = true;
        }
        if (bCoop) {
            try {
                CoopSlave.initStreams();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        } else {
            try {
                String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "server-console.txt";
                object2 = new FileOutputStream(string);
                stringArray2 = new PrintStream((OutputStream)object2, true);
                System.setOut(new ProxyPrintStream(System.out, (PrintStream)stringArray2));
                System.setErr(new ProxyPrintStream(System.err, (PrintStream)stringArray2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        DebugLog.init();
        LoggerManager.init();
        DebugLog.log("cachedir set to \"" + ZomboidFileSystem.instance.getCacheDir() + "\"");
        if (bCoop) {
            try {
                GameServer.setupCoop();
                CoopSlave.status("UI_ServerStatus_Initialising");
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                SteamUtils.shutdown();
                System.exit(37);
                return;
            }
        }
        PZSQLUtils.init();
        Clipper.init();
        Rand.init();
        if (System.getProperty("debug") != null) {
            bDebug = true;
            Core.bDebug = true;
        }
        DebugLog.General.println("version=%s demo=%s", Core.getInstance().getVersion(), false);
        DebugLog.General.println("revision=%s date=%s time=%s", "", "", "");
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            if (stringArray[i] == null) continue;
            if (stringArray[i].startsWith("-disablelog=")) {
                object2 = stringArray[i].replace("-disablelog=", "").split(",");
                int n3 = ((String[])object2).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = object2[n2];
                    if ("All".equals(object)) {
                        DebugType[] debugTypeArray = DebugType.values();
                        int n4 = debugTypeArray.length;
                        for (int j = 0; j < n4; ++j) {
                            DebugType debugType = debugTypeArray[j];
                            DebugLog.setLogEnabled(debugType, false);
                        }
                        continue;
                    }
                    try {
                        DebugLog.setLogEnabled(DebugType.valueOf((String)object), false);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (stringArray[i].startsWith("-debuglog=")) {
                object2 = stringArray[i].replace("-debuglog=", "").split(",");
                int n5 = ((String[])object2).length;
                for (n2 = 0; n2 < n5; ++n2) {
                    object = object2[n2];
                    try {
                        DebugLog.setLogEnabled(DebugType.valueOf((String)object), true);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (stringArray[i].equals("-adminusername")) {
                if (i == stringArray.length - 1) {
                    DebugLog.log("expected argument after \"-adminusername\"");
                    System.exit(0);
                    continue;
                }
                if (!ServerWorldDatabase.isValidUserName(stringArray[i + 1].trim())) {
                    DebugLog.log("invalid username given to \"-adminusername\"");
                    System.exit(0);
                    continue;
                }
                ServerWorldDatabase.instance.CommandLineAdminUsername = stringArray[i + 1].trim();
                ++i;
                continue;
            }
            if (stringArray[i].equals("-adminpassword")) {
                if (i == stringArray.length - 1) {
                    DebugLog.log("expected argument after \"-adminpassword\"");
                    System.exit(0);
                    continue;
                }
                if (stringArray[i + 1].trim().isEmpty()) {
                    DebugLog.log("empty argument given to \"-adminpassword\"");
                    System.exit(0);
                    continue;
                }
                ServerWorldDatabase.instance.CommandLineAdminPassword = stringArray[i + 1].trim();
                ++i;
                continue;
            }
            if (stringArray[i].startsWith("-cachedir=")) continue;
            if (stringArray[i].equals("-ip")) {
                IPCommandline = GameServer.parseIPFromCommandline(stringArray, i, "-ip");
                ++i;
                continue;
            }
            if (stringArray[i].equals("-gui")) {
                GUICommandline = true;
                continue;
            }
            if (stringArray[i].equals("-nosteam")) {
                System.setProperty("zomboid.steam", "0");
                continue;
            }
            if (stringArray[i].equals("-statistic")) {
                int n6 = GameServer.parsePortFromCommandline(stringArray, i, "-statistic");
                if (n6 < 0) continue;
                MPStatistic.getInstance().setPeriod(n6);
                MPStatistic.getInstance().writeEnabled(true);
                continue;
            }
            if (stringArray[i].equals("-port")) {
                PortCommandline = GameServer.parsePortFromCommandline(stringArray, i, "-port");
                ++i;
                continue;
            }
            if (stringArray[i].equals("-udpport")) {
                UDPPortCommandline = GameServer.parsePortFromCommandline(stringArray, i, "-udpport");
                ++i;
                continue;
            }
            if (stringArray[i].equals("-steamvac")) {
                SteamVACCommandline = GameServer.parseBooleanFromCommandline(stringArray, i, "-steamvac");
                ++i;
                continue;
            }
            if (stringArray[i].equals("-servername")) {
                if (i == stringArray.length - 1) {
                    DebugLog.log("expected argument after \"-servername\"");
                    System.exit(0);
                    continue;
                }
                if (stringArray[i + 1].trim().isEmpty()) {
                    DebugLog.log("empty argument given to \"-servername\"");
                    System.exit(0);
                    continue;
                }
                ServerName = stringArray[i + 1].trim();
                ++i;
                continue;
            }
            if (stringArray[i].equals("-coop")) {
                ServerWorldDatabase.instance.doAdmin = false;
                continue;
            }
            DebugLog.log("unknown option \"" + stringArray[i] + "\"");
        }
        DebugLog.log("server name is \"" + ServerName + "\"");
        String string = GameServer.isWorldVersionUnsupported();
        if (string != null) {
            DebugLog.log(string);
            CoopSlave.status(string);
            return;
        }
        SteamUtils.init();
        RakNetPeerInterface.init();
        ZombiePopulationManager.init();
        try {
            ZomboidFileSystem.instance.init();
            Languages.instance.init();
            Translator.loadFiles();
        }
        catch (Exception exception) {
            DebugLog.General.printException(exception, "Exception Thrown", LogSeverity.Error);
            DebugLog.General.println("Server Terminated.");
        }
        ServerOptions.instance.init();
        GameServer.initClientCommandFilter();
        if (PortCommandline != -1) {
            ServerOptions.instance.DefaultPort.setValue(PortCommandline);
        }
        if (UDPPortCommandline != -1) {
            ServerOptions.instance.UDPPort.setValue(UDPPortCommandline);
        }
        if (SteamVACCommandline != null) {
            ServerOptions.instance.SteamVAC.setValue(SteamVACCommandline);
        }
        DEFAULT_PORT = ServerOptions.instance.DefaultPort.getValue();
        UDPPort = ServerOptions.instance.UDPPort.getValue();
        if (CoopSlave.instance != null) {
            ServerOptions.instance.ServerPlayerID.setValue("");
        }
        if (SteamUtils.isSteamModeEnabled() && ((object2 = ServerOptions.instance.PublicName.getValue()) == null || ((String)object2).isEmpty())) {
            ServerOptions.instance.PublicName.setValue("My PZ Server");
        }
        if ((object2 = ServerOptions.instance.Map.getValue()) != null && !((String)object2).trim().isEmpty()) {
            GameMap = ((String)object2).trim();
            if (GameMap.contains(";")) {
                stringArray2 = GameMap.split(";");
                object2 = stringArray2[0];
            }
            Core.GameMap = ((String)object2).trim();
        }
        if ((stringArray2 = ServerOptions.instance.Mods.getValue()) != null) {
            String[] stringArray3 = stringArray2.split(";");
            for (String string2 : stringArray3) {
                if (string2.trim().isEmpty()) continue;
                ServerMods.add(string2.trim());
            }
        }
        if (SteamUtils.isSteamModeEnabled()) {
            int n7;
            int n8 = n7 = ServerOptions.instance.SteamVAC.getValue() ? 3 : 2;
            if (!SteamGameServer.Init(IPCommandline, DEFAULT_PORT, UDPPort, n7, Core.getInstance().getSteamServerVersion())) {
                SteamUtils.shutdown();
                return;
            }
            SteamGameServer.SetProduct("zomboid");
            SteamGameServer.SetGameDescription("Project Zomboid");
            SteamGameServer.SetModDir("zomboid");
            SteamGameServer.SetDedicatedServer(true);
            SteamGameServer.SetMaxPlayerCount(ServerOptions.getInstance().getMaxPlayers());
            SteamGameServer.SetServerName(ServerOptions.instance.PublicName.getValue());
            SteamGameServer.SetMapName(ServerOptions.instance.Map.getValue());
            if (ServerOptions.instance.Public.getValue()) {
                SteamGameServer.SetGameTags(CoopSlave.instance != null ? "hosted" : "");
            } else {
                SteamGameServer.SetGameTags("hidden" + (CoopSlave.instance != null ? ";hosted" : ""));
            }
            SteamGameServer.SetKeyValue("description", ServerOptions.instance.PublicDescription.getValue());
            SteamGameServer.SetKeyValue("version", Core.getInstance().getVersion());
            SteamGameServer.SetKeyValue("open", ServerOptions.instance.Open.getValue() ? "1" : "0");
            SteamGameServer.SetKeyValue("public", ServerOptions.instance.Public.getValue() ? "1" : "0");
            object = ServerOptions.instance.Mods.getValue();
            int n9 = 0;
            String[] stringArray4 = ((String)object).split(";");
            Object object3 = stringArray4;
            int n10 = ((String[])object3).length;
            for (n = 0; n < n10; ++n) {
                String string3 = object3[n];
                if (StringUtils.isNullOrWhitespace(string3)) continue;
                ++n9;
            }
            if (((String)object).length() > 128) {
                String[] stringArray5;
                object3 = new StringBuilder();
                String[] stringArray6 = stringArray5 = ((String)object).split(";");
                int n11 = stringArray6.length;
                for (int i = 0; i < n11; ++i) {
                    String string4 = stringArray6[i];
                    if (((StringBuilder)object3).length() + 1 + string4.length() > 128) break;
                    if (((StringBuilder)object3).length() > 0) {
                        ((StringBuilder)object3).append(';');
                    }
                    ((StringBuilder)object3).append(string4);
                }
                object = ((StringBuilder)object3).toString();
            }
            SteamGameServer.SetKeyValue("mods", (String)object);
            SteamGameServer.SetKeyValue("modCount", String.valueOf(n9));
            SteamGameServer.SetKeyValue("pvp", ServerOptions.instance.PVP.getValue() ? "1" : "0");
            if (bDebug) {
                // empty if block
            }
            if ((object3 = ServerOptions.instance.WorkshopItems.getValue()) != null) {
                String[] stringArray7;
                for (String string4 : stringArray7 = ((String)object3).split(";")) {
                    if ((string4 = string4.trim()).isEmpty() || !SteamUtils.isValidSteamID(string4)) continue;
                    WorkshopItems.add(SteamUtils.convertStringToSteamID(string4));
                }
            }
            SteamWorkshop.init();
            SteamGameServer.LogOnAnonymous();
            SteamGameServer.EnableHeartBeats(true);
            DebugLog.log("Waiting for response from Steam servers");
            while (true) {
                SteamUtils.runLoop();
                int n12 = SteamGameServer.GetSteamServersConnectState();
                if (n12 == SteamGameServer.STEAM_SERVERS_CONNECTED) break;
                if (n12 == SteamGameServer.STEAM_SERVERS_CONNECTFAILURE) {
                    DebugLog.log("Failed to connect to Steam servers");
                    SteamUtils.shutdown();
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!GameServerWorkshopItems.Install(WorkshopItems)) {
                return;
            }
        }
        ZipBackup.onStartup();
        ZipBackup.onVersion();
        int n13 = 0;
        try {
            ServerWorldDatabase.instance.create();
        }
        catch (ClassNotFoundException | SQLException exception) {
            exception.printStackTrace();
        }
        if (ServerOptions.instance.UPnP.getValue()) {
            DebugLog.log("Router detection/configuration starting.");
            DebugLog.log("If the server hangs here, set UPnP=false.");
            PortMapper.startup();
            if (PortMapper.discover()) {
                DebugLog.log("UPnP-enabled internet gateway found: " + PortMapper.getGatewayInfo());
                object = PortMapper.getExternalAddress();
                DebugLog.log("External IP address: " + (String)object);
                DebugLog.log("trying to setup port forwarding rules...");
                int n14 = 86400;
                boolean bl = true;
                if (PortMapper.addMapping(DEFAULT_PORT, DEFAULT_PORT, "PZ Server default port", "UDP", n14, bl)) {
                    DebugLog.log(DebugType.Network, "Default port has been mapped successfully");
                } else {
                    DebugLog.log(DebugType.Network, "Failed to map default port");
                }
                if (SteamUtils.isSteamModeEnabled()) {
                    int n15 = ServerOptions.instance.UDPPort.getValue();
                    if (PortMapper.addMapping(n15, n15, "PZ Server UDPPort", "UDP", n14, bl)) {
                        DebugLog.log(DebugType.Network, "AdditionUDPPort has been mapped successfully");
                    } else {
                        DebugLog.log(DebugType.Network, "Failed to map AdditionUDPPort");
                    }
                }
            } else {
                DebugLog.log(DebugType.Network, "No UPnP-enabled Internet gateway found, you must configure port forwarding on your gateway manually in order to make your server accessible from the Internet.");
            }
        }
        Core.GameMode = "Multiplayer";
        bDone = false;
        DebugLog.log(DebugType.Network, "Initialising Server Systems...");
        CoopSlave.status("UI_ServerStatus_Initialising");
        try {
            GameServer.doMinimumInit();
        }
        catch (Exception exception) {
            DebugLog.General.printException(exception, "Exception Thrown", LogSeverity.Error);
            DebugLog.General.println("Server Terminated.");
        }
        LosUtil.init(100, 100);
        ChatServer.getInstance().init();
        DebugLog.log(DebugType.Network, "Loading world...");
        CoopSlave.status("UI_ServerStatus_LoadingWorld");
        try {
            ClimateManager.setInstance(new ClimateManager());
            IsoWorld.instance.init();
        }
        catch (Exception exception) {
            DebugLog.General.printException(exception, "Exception Thrown", LogSeverity.Error);
            DebugLog.General.println("Server Terminated.");
            CoopSlave.status("UI_ServerStatus_Terminated");
            return;
        }
        object = ZomboidFileSystem.instance.getFileInCurrentSave("z_outfits.bin");
        if (!((File)object).exists()) {
            ServerOptions.instance.changeOption("ResetID", new Integer(Rand.Next(100000000)).toString());
        }
        try {
            SpawnPoints.instance.initServer2();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LuaEventManager.triggerEvent("OnGameTimeLoaded");
        SGlobalObjects.initSystems();
        SoundManager.instance = new SoundManager();
        AmbientStreamManager.instance = new AmbientSoundManager();
        AmbientStreamManager.instance.init();
        ServerMap.instance.LastSaved = System.currentTimeMillis();
        VehicleManager.instance = new VehicleManager();
        ServerPlayersVehicles.instance.init();
        DebugOptions.instance.init();
        GameProfiler.init();
        try {
            GameServer.startServer();
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            SteamUtils.shutdown();
            return;
        }
        if (SteamUtils.isSteamModeEnabled()) {
            DebugLog.log("##########\nServer Steam ID " + SteamGameServer.GetSteamID() + "\n##########");
        }
        UpdateLimit updateLimit = new UpdateLimit(100L);
        PerformanceSettings.setLockFPS(10);
        IngameState ingameState = new IngameState();
        float f = 0.0f;
        float[] fArray = new float[20];
        for (n = 0; n < 20; ++n) {
            fArray[n] = PerformanceSettings.getLockFPS();
        }
        float f2 = PerformanceSettings.getLockFPS();
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        if (!SteamUtils.isSteamModeEnabled()) {
            PublicServerUtil.init();
            PublicServerUtil.insertOrUpdate();
        }
        ServerLOS.init();
        NetworkAIParams.Init();
        int n16 = ServerOptions.instance.RCONPort.getValue();
        String string5 = ServerOptions.instance.RCONPassword.getValue();
        if (n16 != 0 && string5 != null && !string5.isEmpty()) {
            String string6 = System.getProperty("rconlo");
            RCONServer.init(n16, string5, string6 != null);
        }
        LuaManager.GlobalObject.refreshAnimSets(true);
        while (!bDone) {
            try {
                Object object4;
                IZomboidPacket iZomboidPacket;
                long l3 = System.nanoTime();
                MPStatistics.countServerNetworkingFPS();
                MainLoopNetData2.clear();
                IZomboidPacket iZomboidPacket2 = MainLoopNetDataHighPriorityQ.poll();
                while (iZomboidPacket2 != null) {
                    MainLoopNetData2.add(iZomboidPacket2);
                    iZomboidPacket2 = MainLoopNetDataHighPriorityQ.poll();
                }
                MPStatistic.getInstance().setPacketsLength(MainLoopNetData2.size());
                for (int i = 0; i < MainLoopNetData2.size(); ++i) {
                    UdpConnection udpConnection;
                    iZomboidPacket = MainLoopNetData2.get(i);
                    if (iZomboidPacket.isConnect()) {
                        udpConnection = ((DelayedConnection)iZomboidPacket).connection;
                        LoggerManager.getLogger("user").write("added connection index=" + udpConnection.index + " " + ((DelayedConnection)iZomboidPacket).hostString);
                        GameServer.udpEngine.connections.add(udpConnection);
                        continue;
                    }
                    if (iZomboidPacket.isDisconnect()) {
                        udpConnection = ((DelayedConnection)iZomboidPacket).connection;
                        LoginQueue.disconnect(udpConnection);
                        LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + udpConnection.username + "\" removed connection index=" + udpConnection.index);
                        GameServer.udpEngine.connections.remove(udpConnection);
                        GameServer.disconnect(udpConnection, "receive-disconnect");
                        continue;
                    }
                    GameServer.mainLoopDealWithNetData((ZomboidNetData)iZomboidPacket);
                }
                MainLoopPlayerUpdate.clear();
                IZomboidPacket iZomboidPacket3 = MainLoopPlayerUpdateQ.poll();
                while (iZomboidPacket3 != null) {
                    iZomboidPacket = (ZomboidNetData)iZomboidPacket3;
                    long l4 = ((ZomboidNetData)iZomboidPacket).connection * 4L + (long)((ZomboidNetData)iZomboidPacket).buffer.getShort(0);
                    object4 = (ZomboidNetData)MainLoopPlayerUpdate.put(l4, iZomboidPacket);
                    if (object4 != null) {
                        ZomboidNetDataPool.instance.discard((ZomboidNetData)object4);
                    }
                    iZomboidPacket3 = MainLoopPlayerUpdateQ.poll();
                }
                MainLoopNetData2.clear();
                MainLoopNetData2.addAll(MainLoopPlayerUpdate.values());
                MainLoopPlayerUpdate.clear();
                MPStatistic.getInstance().setPacketsLength(MainLoopNetData2.size());
                for (int i = 0; i < MainLoopNetData2.size(); ++i) {
                    iZomboidPacket = MainLoopNetData2.get(i);
                    s_performance.mainLoopDealWithNetData.invokeAndMeasure((ZomboidNetData)iZomboidPacket, GameServer::mainLoopDealWithNetData);
                }
                MainLoopNetData2.clear();
                IZomboidPacket iZomboidPacket4 = MainLoopNetDataQ.poll();
                while (iZomboidPacket4 != null) {
                    MainLoopNetData2.add(iZomboidPacket4);
                    iZomboidPacket4 = MainLoopNetDataQ.poll();
                }
                for (int i = 0; i < MainLoopNetData2.size(); ++i) {
                    if (i % 10 == 0 && (System.nanoTime() - l3) / 1000000L > 70L) {
                        if (droppedPackets == 0) {
                            DebugLog.log("Server is too busy. Server will drop updates of vehicle's physics. Server is closed for new connections.");
                        }
                        droppedPackets += 2;
                        countOfDroppedPackets += MainLoopNetData2.size() - i;
                        break;
                    }
                    iZomboidPacket = MainLoopNetData2.get(i);
                    s_performance.mainLoopDealWithNetData.invokeAndMeasure((ZomboidNetData)iZomboidPacket, GameServer::mainLoopDealWithNetData);
                }
                MainLoopNetData2.clear();
                if (droppedPackets == 1) {
                    DebugLog.log("Server is working normal. Server will not drop updates of vehicle's physics. The server is open for new connections. Server dropped " + countOfDroppedPackets + " packets and " + countOfDroppedConnections + " connections.");
                    countOfDroppedPackets = 0;
                    countOfDroppedConnections = 0;
                }
                droppedPackets = Math.max(0, Math.min(1000, droppedPackets - 1));
                if (!updateLimit.Check()) {
                    long l5 = PZMath.clamp((5000000L - System.nanoTime() + l3) / 1000000L, 0L, 100L);
                    if (l5 <= 0L) continue;
                    try {
                        MPStatistic.getInstance().Main.StartSleep();
                        Thread.sleep(l5);
                        MPStatistic.getInstance().Main.EndSleep();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                MPStatistic.getInstance().Main.Start();
                ++IsoCamera.frameState.frameCount;
                s_performance.frameStep.start();
                try {
                    Object object5;
                    int n17;
                    int n18;
                    int n19;
                    timeSinceKeepAlive += GameTime.getInstance().getMultiplier();
                    MPStatistic.getInstance().ServerMapPreupdate.Start();
                    ServerMap.instance.preupdate();
                    MPStatistic.getInstance().ServerMapPreupdate.End();
                    ArrayList<String> arrayList = consoleCommands;
                    synchronized (arrayList) {
                        for (n19 = 0; n19 < consoleCommands.size(); ++n19) {
                            String string7 = consoleCommands.get(n19);
                            try {
                                if (CoopSlave.instance != null && CoopSlave.instance.handleCommand(string7)) continue;
                                System.out.println(GameServer.handleServerCommand(string7, null));
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        consoleCommands.clear();
                    }
                    if (removeZombiesConnection != null) {
                        NetworkZombieManager.removeZombies(removeZombiesConnection);
                        removeZombiesConnection = null;
                    }
                    s_performance.RCONServerUpdate.invokeAndMeasure(RCONServer::update);
                    try {
                        MapCollisionData.instance.updateGameState();
                        MPStatistic.getInstance().IngameStateUpdate.Start();
                        ingameState.update();
                        MPStatistic.getInstance().IngameStateUpdate.End();
                        VehicleManager.instance.serverUpdate();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    int n20 = 0;
                    n19 = 0;
                    for (n18 = 0; n18 < Players.size(); ++n18) {
                        IsoPlayer isoPlayer = Players.get(n18);
                        if (isoPlayer.isAlive()) {
                            if (!IsoWorld.instance.CurrentCell.getObjectList().contains(isoPlayer)) {
                                IsoWorld.instance.CurrentCell.getObjectList().add(isoPlayer);
                            }
                            ++n19;
                            if (isoPlayer.isAsleep()) {
                                ++n20;
                            }
                        }
                        ServerMap.instance.characterIn(isoPlayer);
                    }
                    GameServer.setFastForward(ServerOptions.instance.SleepAllowed.getValue() && n19 > 0 && n20 == n19);
                    n18 = calcCountPlayersInRelevantPositionLimiter.Check() ? 1 : 0;
                    for (n17 = 0; n17 < GameServer.udpEngine.connections.size(); ++n17) {
                        object4 = GameServer.udpEngine.connections.get(n17);
                        if (n18 != 0) {
                            ((UdpConnection)object4).calcCountPlayersInRelevantPosition();
                        }
                        for (int i = 0; i < 4; ++i) {
                            object5 = ((UdpConnection)object4).connectArea[i];
                            if (object5 != null) {
                                ServerMap.instance.characterIn((int)((Vector3)object5).x, (int)((Vector3)object5).y, (int)((Vector3)object5).z);
                            }
                            ClientServerMap.characterIn((UdpConnection)object4, i);
                        }
                        if (((UdpConnection)object4).playerDownloadServer == null) continue;
                        ((UdpConnection)object4).playerDownloadServer.update();
                    }
                    for (n17 = 0; n17 < IsoWorld.instance.CurrentCell.getObjectList().size(); ++n17) {
                        object4 = IsoWorld.instance.CurrentCell.getObjectList().get(n17);
                        if (!(object4 instanceof IsoPlayer) || Players.contains(object4)) continue;
                        DebugLog.log("Disconnected player in CurrentCell.getObjectList() removed");
                        IsoWorld.instance.CurrentCell.getObjectList().remove(n17--);
                    }
                    if (++n13 > 150) {
                        for (n17 = 0; n17 < GameServer.udpEngine.connections.size(); ++n17) {
                            object4 = GameServer.udpEngine.connections.get(n17);
                            try {
                                if (((UdpConnection)object4).username != null || ((UdpConnection)object4).awaitingCoopApprove || LoginQueue.isInTheQueue((UdpConnection)object4) || !((UdpConnection)object4).isConnectionAttemptTimeout()) continue;
                                GameServer.disconnect((UdpConnection)object4, "connection-attempt-timeout");
                                udpEngine.forceDisconnect(((UdpConnection)object4).getConnectedGUID(), "connection-attempt-timeout");
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        n13 = 0;
                    }
                    worldObjectsServerSyncReq.serverSendRequests(udpEngine);
                    MPStatistic.getInstance().ServerMapPostupdate.Start();
                    ServerMap.instance.postupdate();
                    MPStatistic.getInstance().ServerMapPostupdate.End();
                    try {
                        ServerGUI.update();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    l2 = l;
                    l = System.currentTimeMillis();
                    long l6 = l - l2;
                    f = 1000.0f / (float)l6;
                    if (!Float.isNaN(f)) {
                        f2 = (float)((double)f2 + Math.min((double)(f - f2) * 0.05, 1.0));
                    }
                    GameTime.instance.FPSMultiplier = 60.0f / f2;
                    GameServer.launchCommandHandler();
                    MPStatistic.getInstance().process(l6);
                    if (!SteamUtils.isSteamModeEnabled()) {
                        PublicServerUtil.update();
                        PublicServerUtil.updatePlayerCountIfChanged();
                    }
                    for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                        object5 = GameServer.udpEngine.connections.get(i);
                        if (((UdpConnection)object5).checksumState == UdpConnection.ChecksumState.Different && ((UdpConnection)object5).checksumTime + 8000L < System.currentTimeMillis()) {
                            DebugLog.log("timed out connection because checksum was different");
                            ((UdpConnection)object5).checksumState = UdpConnection.ChecksumState.Init;
                            ((UdpConnection)object5).forceDisconnect("checksum-timeout");
                            continue;
                        }
                        ((UdpConnection)object5).validator.update();
                        if (((UdpConnection)object5).chunkObjectState.isEmpty()) continue;
                        for (int j = 0; j < ((UdpConnection)object5).chunkObjectState.size(); j += 2) {
                            short s;
                            short s2 = ((UdpConnection)object5).chunkObjectState.get(j);
                            if (((UdpConnection)object5).RelevantTo(s2 * 10 + 5, (s = ((UdpConnection)object5).chunkObjectState.get(j + 1)) * 10 + 5, ((UdpConnection)object5).ChunkGridWidth * 4 * 10)) continue;
                            ((UdpConnection)object5).chunkObjectState.remove(j, 2);
                            j -= 2;
                        }
                    }
                    if (sendWorldMapPlayerPositionLimiter.Check()) {
                        try {
                            GameServer.sendWorldMapPlayerPosition();
                        }
                        catch (Exception exception) {
                            boolean bl = true;
                        }
                    }
                    if (CoopSlave.instance != null) {
                        CoopSlave.instance.update();
                        if (CoopSlave.instance.masterLost()) {
                            DebugLog.log("Coop master is not responding, terminating");
                            ServerMap.instance.QueueQuit();
                        }
                    }
                    LoginQueue.update();
                    ZipBackup.onPeriod();
                    SteamUtils.runLoop();
                    GameWindow.fileSystem.updateAsyncTransactions();
                }
                catch (Exception exception) {
                    if (mainCycleExceptionLogCount-- <= 0) continue;
                    DebugLog.Multiplayer.printException(exception, "Server processing error", LogSeverity.Error);
                }
                finally {
                    s_performance.frameStep.end();
                }
            }
            catch (Exception exception) {
                if (mainCycleExceptionLogCount-- <= 0) continue;
                DebugLog.Multiplayer.printException(exception, "Server error", LogSeverity.Error);
            }
        }
        CoopSlave.status("UI_ServerStatus_Terminated");
        DebugLog.log(DebugType.Network, "Server exited");
        ServerGUI.shutdown();
        ServerPlayerDB.getInstance().close();
        VehiclesDB2.instance.Reset();
        SteamUtils.shutdown();
        System.exit(0);
    }

    private static void launchCommandHandler() {
        if (launched) {
            return;
        }
        launched = true;
        new Thread(ThreadGroups.Workers, () -> {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.isEmpty()) continue;
                    System.out.println("command entered via server console (System.in): \"" + string + "\"");
                    ArrayList<String> arrayList = consoleCommands;
                    synchronized (arrayList) {
                        consoleCommands.add(string);
                    }
                }
                consoleCommands.add("process-status@eof");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }, "command handler").start();
    }

    public static String rcon(String string) {
        try {
            return GameServer.handleServerCommand(string, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static String handleServerCommand(String string, UdpConnection udpConnection) {
        Class clazz;
        if (string == null) {
            return null;
        }
        String string2 = "admin";
        String string3 = "admin";
        if (udpConnection != null) {
            string2 = udpConnection.username;
            string3 = PlayerType.toString(udpConnection.accessLevel);
        }
        if (udpConnection != null && udpConnection.isCoopHost) {
            string3 = "admin";
        }
        if ((clazz = CommandBase.findCommandCls(string)) != null) {
            Constructor<?> constructor = clazz.getConstructors()[0];
            try {
                CommandBase commandBase = (CommandBase)constructor.newInstance(string2, string3, string, udpConnection);
                return commandBase.Execute();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return "A InvocationTargetException error occured";
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return "A IllegalAccessException error occured";
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                return "A InstantiationException error occured";
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return "A SQL error occured";
            }
        }
        return "Unknown command " + string;
    }

    public static void sendTeleport(IsoPlayer isoPlayer, float f, float f2, float f3) {
        UdpConnection udpConnection = GameServer.getConnectionFromPlayer(isoPlayer);
        if (udpConnection == null) {
            DebugLog.log("No connection found for user " + isoPlayer.getUsername());
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Teleport.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putFloat(f);
        byteBufferWriter.putFloat(f2);
        byteBufferWriter.putFloat(f3);
        PacketTypes.PacketType.Teleport.send(udpConnection);
        if (udpConnection.players[0] != null && udpConnection.players[0].getNetworkCharacterAI() != null) {
            udpConnection.players[0].getNetworkCharacterAI().resetSpeedLimiter();
        }
    }

    static void receiveTeleport(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        IsoPlayer isoPlayer = GameServer.getPlayerByRealUserName(string);
        if (isoPlayer == null) {
            return;
        }
        UdpConnection udpConnection2 = GameServer.getConnectionFromPlayer(isoPlayer);
        if (udpConnection2 == null) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
        PacketTypes.PacketType.Teleport.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)isoPlayer.PlayerIndex);
        byteBufferWriter.putFloat(f);
        byteBufferWriter.putFloat(f2);
        byteBufferWriter.putFloat(f3);
        PacketTypes.PacketType.Teleport.send(udpConnection2);
        if (isoPlayer.getNetworkCharacterAI() != null) {
            isoPlayer.getNetworkCharacterAI().resetSpeedLimiter();
        }
        if (isoPlayer.isAsleep()) {
            isoPlayer.setAsleep(false);
            isoPlayer.setAsleepTime(0.0f);
            GameServer.sendWakeUpPlayer(isoPlayer, null);
        }
    }

    public static void sendPlayerExtraInfo(IsoPlayer isoPlayer, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.ExtraInfo.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoPlayer.OnlineID);
            byteBufferWriter.putUTF(isoPlayer.accessLevel);
            byteBufferWriter.putByte(isoPlayer.isGodMod() ? (byte)1 : 0);
            byteBufferWriter.putByte(isoPlayer.isGhostMode() ? (byte)1 : 0);
            byteBufferWriter.putByte(isoPlayer.isInvisible() ? (byte)1 : 0);
            byteBufferWriter.putByte(isoPlayer.isNoClip() ? (byte)1 : 0);
            byteBufferWriter.putByte(isoPlayer.isShowAdminTag() ? (byte)1 : 0);
            PacketTypes.PacketType.ExtraInfo.send(udpConnection2);
        }
    }

    static void receiveExtraInfo(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        boolean bl = byteBuffer.get() == 1;
        boolean bl2 = byteBuffer.get() == 1;
        boolean bl3 = byteBuffer.get() == 1;
        boolean bl4 = byteBuffer.get() == 1;
        boolean bl5 = byteBuffer.get() == 1;
        boolean bl6 = byteBuffer.get() == 1;
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, s2);
        if (isoPlayer != null) {
            isoPlayer.setGodMod(bl);
            isoPlayer.setGhostMode(bl2);
            isoPlayer.setInvisible(bl3);
            isoPlayer.setNoClip(bl4);
            isoPlayer.setShowAdminTag(bl5);
            isoPlayer.setCanHearAll(bl6);
            GameServer.sendPlayerExtraInfo(isoPlayer, udpConnection);
        }
    }

    static void receiveAddXp(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        AddXp addXp = new AddXp();
        addXp.parse(byteBuffer, udpConnection);
        if (!addXp.isConsistent() || !addXp.validate(udpConnection)) {
            return;
        }
        if (!GameServer.canModifyPlayerStats(udpConnection, addXp.target.getCharacter())) {
            PacketTypes.PacketType.AddXP.onUnauthorized(udpConnection);
            return;
        }
        addXp.process();
        if (GameServer.canModifyPlayerStats(udpConnection, null)) {
            addXp.target.getCharacter().getXp().recalcSumm();
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || udpConnection2.getConnectedGUID() != PlayerToAddressMap.get(addXp.target.getCharacter()).longValue()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.AddXP.doPacket(byteBufferWriter);
            addXp.write(byteBufferWriter);
            PacketTypes.PacketType.AddXP.send(udpConnection2);
        }
    }

    private static boolean canSeePlayerStats(UdpConnection udpConnection) {
        return udpConnection.accessLevel != 1;
    }

    private static boolean canModifyPlayerStats(UdpConnection udpConnection, IsoPlayer isoPlayer) {
        return (udpConnection.accessLevel & 0x38) != 0 || udpConnection.havePlayer(isoPlayer);
    }

    static void receiveSyncXP(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoPlayer isoPlayer = IDToPlayerMap.get(byteBuffer.getShort());
        if (isoPlayer == null) {
            return;
        }
        if (!GameServer.canModifyPlayerStats(udpConnection, isoPlayer)) {
            PacketTypes.PacketType.SyncXP.onUnauthorized(udpConnection);
            return;
        }
        if (isoPlayer != null && !isoPlayer.isDead()) {
            try {
                isoPlayer.getXp().load(byteBuffer, 195);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncXP.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(isoPlayer.getOnlineID());
                try {
                    isoPlayer.getXp().save(byteBufferWriter.bb);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                PacketTypes.PacketType.SyncXP.send(udpConnection2);
            }
        }
    }

    static void receiveChangePlayerStats(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer == null) {
            return;
        }
        String string = GameWindow.ReadString(byteBuffer);
        isoPlayer.setPlayerStats(byteBuffer, string);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            if (udpConnection2.getConnectedGUID() == PlayerToAddressMap.get(isoPlayer).longValue()) {
                udpConnection2.allChatMuted = isoPlayer.isAllChatMuted();
                udpConnection2.accessLevel = PlayerType.fromString(isoPlayer.accessLevel);
            }
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.ChangePlayerStats.doPacket(byteBufferWriter);
            isoPlayer.createPlayerStats(byteBufferWriter, string);
            PacketTypes.PacketType.ChangePlayerStats.send(udpConnection2);
        }
    }

    public static void doMinimumInit() throws IOException {
        Rand.init();
        DebugFileWatcher.instance.init();
        ArrayList<String> arrayList = new ArrayList<String>(ServerMods);
        ZomboidFileSystem.instance.loadMods(arrayList);
        LuaManager.init();
        PerkFactory.init();
        CustomPerks.instance.init();
        CustomPerks.instance.initLua();
        AssetManagers assetManagers = GameWindow.assetManagers;
        AiSceneAssetManager.instance.create(AiSceneAsset.ASSET_TYPE, assetManagers);
        AnimationAssetManager.instance.create(AnimationAsset.ASSET_TYPE, assetManagers);
        AnimNodeAssetManager.instance.create(AnimationAsset.ASSET_TYPE, assetManagers);
        ClothingItemAssetManager.instance.create(ClothingItem.ASSET_TYPE, assetManagers);
        MeshAssetManager.instance.create(ModelMesh.ASSET_TYPE, assetManagers);
        ModelAssetManager.instance.create(Model.ASSET_TYPE, assetManagers);
        TextureIDAssetManager.instance.create(TextureID.ASSET_TYPE, assetManagers);
        TextureAssetManager.instance.create(Texture.ASSET_TYPE, assetManagers);
        if (GUICommandline && !bSoftReset) {
            ServerGUI.init();
        }
        CustomSandboxOptions.instance.init();
        CustomSandboxOptions.instance.initInstance(SandboxOptions.instance);
        ScriptManager.instance.Load();
        ClothingDecals.init();
        BeardStyles.init();
        HairStyles.init();
        OutfitManager.init();
        if (!bSoftReset) {
            JAssImpImporter.Init();
            ModelManager.NoOpenGL = !ServerGUI.isCreated();
            ModelManager.instance.create();
            System.out.println("LOADING ASSETS: START");
            while (GameWindow.fileSystem.hasWork()) {
                GameWindow.fileSystem.updateAsyncTransactions();
            }
            System.out.println("LOADING ASSETS: FINISH");
        }
        try {
            LuaManager.initChecksum();
            LuaManager.LoadDirBase("shared");
            LuaManager.LoadDirBase("client", true);
            LuaManager.LoadDirBase("server");
            LuaManager.finishChecksum();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        RecipeManager.LoadedAfterLua();
        File file = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "Server" + File.separator + ServerName + "_SandboxVars.lua");
        if (file.exists()) {
            if (!SandboxOptions.instance.loadServerLuaFile(ServerName)) {
                System.out.println("Exiting due to errors loading " + file.getCanonicalPath());
                System.exit(1);
            }
            SandboxOptions.instance.handleOldServerZombiesFile();
            SandboxOptions.instance.saveServerLuaFile(ServerName);
            SandboxOptions.instance.toLua();
        } else {
            SandboxOptions.instance.handleOldServerZombiesFile();
            SandboxOptions.instance.saveServerLuaFile(ServerName);
            SandboxOptions.instance.toLua();
        }
        LuaEventManager.triggerEvent("OnGameBoot");
        ZomboidGlobals.Load();
        SpawnPoints.instance.initServer1();
        ServerGUI.init2();
    }

    public static void startServer() throws ConnectException {
        Object object;
        String string = ServerOptions.instance.Password.getValue();
        if (CoopSlave.instance != null && SteamUtils.isSteamModeEnabled()) {
            string = "";
        }
        udpEngine = new UdpEngine(DEFAULT_PORT, UDPPort, ServerOptions.getInstance().getMaxPlayers(), string, true);
        DebugLog.log(DebugType.Network, "*** SERVER STARTED ****");
        DebugLog.log(DebugType.Network, "*** Steam is " + (SteamUtils.isSteamModeEnabled() ? "enabled" : "not enabled"));
        if (SteamUtils.isSteamModeEnabled()) {
            DebugLog.log(DebugType.Network, "Server is listening on port " + DEFAULT_PORT + " (for Steam connection) and port " + UDPPort + " (for UDPRakNet connection)");
            DebugLog.log(DebugType.Network, "Clients should use " + DEFAULT_PORT + " port for connections");
        } else {
            DebugLog.log(DebugType.Network, "server is listening on port " + DEFAULT_PORT);
        }
        ResetID = ServerOptions.instance.ResetID.getValue();
        if (CoopSlave.instance != null) {
            if (SteamUtils.isSteamModeEnabled()) {
                object = udpEngine.getPeer();
                CoopSlave.instance.sendMessage("server-address", null, ((RakNetPeerInterface)object).GetServerIP() + ":" + DEFAULT_PORT);
                long l = SteamGameServer.GetSteamID();
                CoopSlave.instance.sendMessage("steam-id", null, SteamUtils.convertSteamIDToString(l));
            } else {
                object = "127.0.0.1";
                CoopSlave.instance.sendMessage("server-address", null, (String)object + ":" + DEFAULT_PORT);
            }
        }
        LuaEventManager.triggerEvent("OnServerStarted");
        if (SteamUtils.isSteamModeEnabled()) {
            CoopSlave.status("UI_ServerStatus_Started");
        } else {
            CoopSlave.status("UI_ServerStatus_Started");
        }
        object = ServerOptions.instance.DiscordChannel.getValue();
        String string2 = ServerOptions.instance.DiscordToken.getValue();
        boolean bl = ServerOptions.instance.DiscordEnable.getValue();
        String string3 = ServerOptions.instance.DiscordChannelID.getValue();
        discordBot.connect(bl, string2, (String)object, string3);
    }

    private static void mainLoopDealWithNetData(ZomboidNetData zomboidNetData) {
        if (!SystemDisabler.getDoMainLoopDealWithNetData()) {
            return;
        }
        ByteBuffer byteBuffer = zomboidNetData.buffer;
        UdpConnection udpConnection = udpEngine.getActiveConnection(zomboidNetData.connection);
        if (zomboidNetData.type == null) {
            ZomboidNetDataPool.instance.discard(zomboidNetData);
            return;
        }
        ++zomboidNetData.type.serverPacketCount;
        MPStatistic.getInstance().addIncomePacket(zomboidNetData.type, byteBuffer.limit());
        try {
            if (udpConnection == null) {
                DebugLog.log(DebugType.Network, "Received packet type=" + zomboidNetData.type.name() + " connection is null.");
                return;
            }
            if (udpConnection.username == null) {
                switch (zomboidNetData.type) {
                    case Login: 
                    case Ping: 
                    case ScoreboardUpdate: {
                        break;
                    }
                    default: {
                        DebugLog.log("Received packet type=" + zomboidNetData.type.name() + " before Login, disconnecting " + udpConnection.getInetSocketAddress().getHostString());
                        udpConnection.forceDisconnect("unacceptable-packet");
                        ZomboidNetDataPool.instance.discard(zomboidNetData);
                        return;
                    }
                }
            }
            zomboidNetData.type.onServerPacket(byteBuffer, udpConnection);
        }
        catch (Exception exception) {
            if (udpConnection == null) {
                DebugLog.log(DebugType.Network, "Error with packet of type: " + zomboidNetData.type + " connection is null.");
            } else {
                DebugLog.General.error("Error with packet of type: " + zomboidNetData.type + " for " + udpConnection.username);
            }
            exception.printStackTrace();
        }
        ZomboidNetDataPool.instance.discard(zomboidNetData);
    }

    static void receiveInvMngRemoveItem(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || udpConnection2.getConnectedGUID() != PlayerToAddressMap.get(isoPlayer).longValue()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.InvMngRemoveItem.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n);
            PacketTypes.PacketType.InvMngRemoveItem.send(udpConnection2);
            break;
        }
    }

    static void receiveInvMngGetItem(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws IOException {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || udpConnection2.getConnectedGUID() != PlayerToAddressMap.get(isoPlayer).longValue()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.InvMngGetItem.doPacket(byteBufferWriter);
            byteBuffer.rewind();
            byteBufferWriter.bb.put(byteBuffer);
            PacketTypes.PacketType.InvMngGetItem.send(udpConnection2);
            break;
        }
    }

    static void receiveInvMngReqItem(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = 0;
        String string = null;
        if (byteBuffer.get() == 1) {
            string = GameWindow.ReadString(byteBuffer);
        } else {
            n = byteBuffer.getInt();
        }
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s3);
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || udpConnection2.getConnectedGUID() != PlayerToAddressMap.get(isoPlayer).longValue()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.InvMngReqItem.doPacket(byteBufferWriter);
            if (string != null) {
                byteBufferWriter.putByte((byte)1);
                byteBufferWriter.putUTF(string);
            } else {
                byteBufferWriter.putByte((byte)0);
                byteBufferWriter.putInt(n);
            }
            byteBufferWriter.putShort(s2);
            PacketTypes.PacketType.InvMngReqItem.send(udpConnection2);
            break;
        }
    }

    static void receiveRequestZipList(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws Exception {
        if (!udpConnection.wasInLoadingQueue) {
            GameServer.kick(udpConnection, "UI_Policy_Kick", "The server received an invalid request");
        }
        if (udpConnection.playerDownloadServer != null) {
            udpConnection.playerDownloadServer.receiveRequestArray(byteBuffer);
        }
    }

    static void receiveRequestLargeAreaZip(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if (!udpConnection.wasInLoadingQueue) {
            GameServer.kick(udpConnection, "UI_Policy_Kick", "The server received an invalid request");
        }
        if (udpConnection.playerDownloadServer != null) {
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            udpConnection.connectArea[0] = new Vector3(n, n2, n3);
            udpConnection.ChunkGridWidth = n3;
            ZombiePopulationManager.instance.updateLoadedAreas();
        }
    }

    static void receiveNotRequiredInZip(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if (udpConnection.playerDownloadServer != null) {
            udpConnection.playerDownloadServer.receiveCancelRequest(byteBuffer);
        }
    }

    static void receiveLogin(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        Object object;
        ConnectionManager.log("receive-packet", "login", udpConnection);
        String string = GameWindow.ReadString(byteBuffer).trim();
        String string2 = GameWindow.ReadString(byteBuffer).trim();
        String string3 = GameWindow.ReadString(byteBuffer).trim();
        if (!string3.equals(Core.getInstance().getVersion())) {
            object = udpConnection.startPacket();
            PacketTypes.PacketType.AccessDenied.doPacket((ByteBufferWriter)object);
            LoggerManager.getLogger("user").write("access denied: user \"" + string + "\" client version (" + string3 + ") does not match server version (" + Core.getInstance().getVersion() + ")");
            ((ByteBufferWriter)object).putUTF("ClientVersionMismatch##" + string3 + "##" + Core.getInstance().getVersion());
            PacketTypes.PacketType.AccessDenied.send(udpConnection);
            ConnectionManager.log("access-denied", "version-mismatch", udpConnection);
            udpConnection.forceDisconnect("access-denied-client-version");
        }
        udpConnection.wasInLoadingQueue = false;
        udpConnection.ip = udpConnection.getInetSocketAddress().getHostString();
        udpConnection.validator.reset();
        udpConnection.idStr = udpConnection.ip;
        if (SteamUtils.isSteamModeEnabled()) {
            udpConnection.steamID = udpEngine.getClientSteamID(udpConnection.getConnectedGUID());
            if (udpConnection.steamID == -1L) {
                object = udpConnection.startPacket();
                PacketTypes.PacketType.AccessDenied.doPacket((ByteBufferWriter)object);
                LoggerManager.getLogger("user").write("access denied: The client \"" + string + "\" did not complete the connection and authorization procedure in zombienet");
                ((ByteBufferWriter)object).putUTF("ClientIsNofFullyConnectedInZombienet");
                PacketTypes.PacketType.AccessDenied.send(udpConnection);
                ConnectionManager.log("access-denied", "znet-error", udpConnection);
                udpConnection.forceDisconnect("access-denied-zombienet-connect");
            }
            udpConnection.ownerID = udpEngine.getClientOwnerSteamID(udpConnection.getConnectedGUID());
            udpConnection.idStr = SteamUtils.convertSteamIDToString(udpConnection.steamID);
            if (udpConnection.steamID != udpConnection.ownerID) {
                udpConnection.idStr = udpConnection.idStr + "(owner=" + SteamUtils.convertSteamIDToString(udpConnection.ownerID) + ")";
            }
        }
        udpConnection.password = string2;
        LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + string + "\" attempting to join");
        if (CoopSlave.instance != null && SteamUtils.isSteamModeEnabled()) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2 == udpConnection || udpConnection2.steamID != udpConnection.steamID) continue;
                LoggerManager.getLogger("user").write("access denied: user \"" + string + "\" already connected");
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
                byteBufferWriter.putUTF("AlreadyConnected");
                PacketTypes.PacketType.AccessDenied.send(udpConnection);
                ConnectionManager.log("access-denied", "already-connected-steamid", udpConnection);
                udpConnection.forceDisconnect("access-denied-already-connected-cs");
                return;
            }
            udpConnection.username = string;
            udpConnection.usernames[0] = string;
            udpConnection.isCoopHost = GameServer.udpEngine.connections.size() == 1;
            DebugLog.Multiplayer.debugln(udpConnection.idStr + " isCoopHost=" + udpConnection.isCoopHost);
            udpConnection.accessLevel = 1;
            if (!ServerOptions.instance.DoLuaChecksum.getValue()) {
                udpConnection.checksumState = UdpConnection.ChecksumState.Done;
            }
            if (GameServer.getPlayerCount() >= ServerOptions.getInstance().getMaxPlayers()) {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
                byteBufferWriter.putUTF("ServerFull");
                PacketTypes.PacketType.AccessDenied.send(udpConnection);
                ConnectionManager.log("access-denied", "server-full", udpConnection);
                udpConnection.forceDisconnect("access-denied-server-full-cs");
                return;
            }
            if (GameServer.isServerDropPackets() && ServerOptions.instance.DenyLoginOnOverloadedServer.getValue()) {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
                LoggerManager.getLogger("user").write("access denied: user \"" + string + "\" Server is too busy");
                byteBufferWriter.putUTF("Server is too busy.");
                PacketTypes.PacketType.AccessDenied.send(udpConnection);
                ConnectionManager.log("access-denied", "server-busy", udpConnection);
                udpConnection.forceDisconnect("access-denied-server-busy-cs");
                ++countOfDroppedConnections;
            }
            LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + string + "\" allowed to join");
            ServerWorldDatabase.LogonResult logonResult = new ServerWorldDatabase.LogonResult(ServerWorldDatabase.instance);
            logonResult.accessLevel = PlayerType.toString(udpConnection.accessLevel);
            GameServer.receiveClientConnect(udpConnection, logonResult);
            return;
        }
        object = ServerWorldDatabase.instance.authClient(string, string2, udpConnection.ip, udpConnection.steamID);
        if (((ServerWorldDatabase.LogonResult)object).bAuthorized) {
            Object object2;
            int n;
            for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
                object2 = GameServer.udpEngine.connections.get(n);
                for (int i = 0; i < 4; ++i) {
                    if (!string.equals(((UdpConnection)object2).usernames[i])) continue;
                    LoggerManager.getLogger("user").write("access denied: user \"" + string + "\" already connected");
                    ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                    PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
                    byteBufferWriter.putUTF("AlreadyConnected");
                    PacketTypes.PacketType.AccessDenied.send(udpConnection);
                    ConnectionManager.log("access-denied", "already-connected-username", udpConnection);
                    udpConnection.forceDisconnect("access-denied-already-connected-username");
                    return;
                }
            }
            udpConnection.username = string;
            udpConnection.usernames[0] = string;
            transactionIDMap.put(string, ((ServerWorldDatabase.LogonResult)object).transactionID);
            if (CoopSlave.instance != null) {
                udpConnection.isCoopHost = GameServer.udpEngine.connections.size() == 1;
                DebugLog.log(udpConnection.idStr + " isCoopHost=" + udpConnection.isCoopHost);
            }
            udpConnection.accessLevel = PlayerType.fromString(((ServerWorldDatabase.LogonResult)object).accessLevel);
            udpConnection.preferredInQueue = ((ServerWorldDatabase.LogonResult)object).priority;
            if (!ServerOptions.instance.DoLuaChecksum.getValue() || ((ServerWorldDatabase.LogonResult)object).accessLevel.equals("admin")) {
                udpConnection.checksumState = UdpConnection.ChecksumState.Done;
            }
            if (!((ServerWorldDatabase.LogonResult)object).accessLevel.equals("") && GameServer.getPlayerCount() >= ServerOptions.getInstance().getMaxPlayers()) {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
                byteBufferWriter.putUTF("ServerFull");
                PacketTypes.PacketType.AccessDenied.send(udpConnection);
                ConnectionManager.log("access-denied", "server-full-no-admin", udpConnection);
                udpConnection.forceDisconnect("access-denied-server-full");
                return;
            }
            if (!ServerWorldDatabase.instance.containsUser(string) && ServerWorldDatabase.instance.containsCaseinsensitiveUser(string)) {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
                byteBufferWriter.putUTF("InvalidUsername");
                PacketTypes.PacketType.AccessDenied.send(udpConnection);
                ConnectionManager.log("access-denied", "invalid-username", udpConnection);
                udpConnection.forceDisconnect("access-denied-invalid-username");
                return;
            }
            n = udpConnection.getAveragePing();
            DebugLog.Multiplayer.debugln("User %s ping %d ms", udpConnection.username, n);
            if (MPStatistics.doKickWhileLoading(udpConnection, n)) {
                object2 = udpConnection.startPacket();
                PacketTypes.PacketType.AccessDenied.doPacket((ByteBufferWriter)object2);
                LoggerManager.getLogger("user").write("access denied: user \"" + string + "\" ping is too high");
                ((ByteBufferWriter)object2).putUTF("Ping");
                PacketTypes.PacketType.AccessDenied.send(udpConnection);
                ConnectionManager.log("access-denied", "ping-limit", udpConnection);
                udpConnection.forceDisconnect("access-denied-ping-limit");
                return;
            }
            if (((ServerWorldDatabase.LogonResult)object).newUser) {
                try {
                    ServerWorldDatabase.instance.addUser(string, string2);
                    LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + string + "\" was added");
                }
                catch (SQLException sQLException) {
                    DebugLog.Multiplayer.printException(sQLException, "ServerWorldDatabase.addUser error", LogSeverity.Error);
                }
            }
            LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + string + "\" allowed to join");
            try {
                if (ServerOptions.instance.AutoCreateUserInWhiteList.getValue() && !ServerWorldDatabase.instance.containsUser(string)) {
                    ServerWorldDatabase.instance.addUser(string, string2);
                } else {
                    ServerWorldDatabase.instance.setPassword(string, string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ServerWorldDatabase.instance.updateLastConnectionDate(string, string2);
            if (SteamUtils.isSteamModeEnabled()) {
                String string4 = SteamUtils.convertSteamIDToString(udpConnection.steamID);
                ServerWorldDatabase.instance.setUserSteamID(string, string4);
            }
            GameServer.receiveClientConnect(udpConnection, (ServerWorldDatabase.LogonResult)object);
        } else {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
            if (((ServerWorldDatabase.LogonResult)object).banned) {
                LoggerManager.getLogger("user").write("access denied: user \"" + string + "\" is banned");
                if (((ServerWorldDatabase.LogonResult)object).bannedReason != null && !((ServerWorldDatabase.LogonResult)object).bannedReason.isEmpty()) {
                    byteBufferWriter.putUTF("BannedReason##" + ((ServerWorldDatabase.LogonResult)object).bannedReason);
                } else {
                    byteBufferWriter.putUTF("Banned");
                }
            } else if (!((ServerWorldDatabase.LogonResult)object).bAuthorized) {
                LoggerManager.getLogger("user").write("access denied: user \"" + string + "\" reason \"" + ((ServerWorldDatabase.LogonResult)object).dcReason + "\"");
                byteBufferWriter.putUTF(((ServerWorldDatabase.LogonResult)object).dcReason != null ? ((ServerWorldDatabase.LogonResult)object).dcReason : "AccessDenied");
            }
            PacketTypes.PacketType.AccessDenied.send(udpConnection);
            ConnectionManager.log("access-denied", "unauthorized", udpConnection);
            udpConnection.forceDisconnect("access-denied-unauthorized");
        }
    }

    static void receiveSendInventory(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        Long l = IDToAddressMap.get(s2);
        if (l != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SendInventory.doPacket(byteBufferWriter);
                byteBufferWriter.bb.put(byteBuffer);
                PacketTypes.PacketType.SendInventory.send(udpConnection2);
                break;
            }
        }
    }

    static void receivePlayerStartPMChat(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ChatServer.getInstance().processPlayerStartWhisperChatPacket(byteBuffer);
    }

    static void receiveRequestInventory(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        Long l = IDToAddressMap.get(s3);
        if (l != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.RequestInventory.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                PacketTypes.PacketType.RequestInventory.send(udpConnection2);
                break;
            }
        }
    }

    static void receiveStatistic(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            udpConnection.statistic.parse(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void receiveStatisticRequest(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if (udpConnection.accessLevel != 32 && !Core.bDebug) {
            DebugLog.General.error("User " + udpConnection.username + " has no rights to access statistics.");
            return;
        }
        try {
            udpConnection.statistic.enable = byteBuffer.get();
            GameServer.sendStatistic(udpConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void receiveZombieSimulation(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        NetworkZombiePacker.getInstance().receivePacket(byteBuffer, udpConnection);
    }

    public static void sendShortStatistic() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (udpConnection.statistic.enable != 3) continue;
            GameServer.sendShortStatistic(udpConnection);
        }
    }

    public static void sendShortStatistic(UdpConnection udpConnection) {
        try {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.StatisticRequest.doPacket(byteBufferWriter);
            MPStatistic.getInstance().write(byteBufferWriter);
            PacketTypes.PacketType.StatisticRequest.send(udpConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            udpConnection.cancelPacket();
        }
    }

    public static void sendStatistic() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (udpConnection.statistic.enable != 1) continue;
            GameServer.sendStatistic(udpConnection);
        }
    }

    public static void sendStatistic(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.StatisticRequest.doPacket(byteBufferWriter);
        try {
            MPStatistic.getInstance().getStatisticTable(byteBufferWriter.bb);
            PacketTypes.PacketType.StatisticRequest.send(udpConnection);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            udpConnection.cancelPacket();
        }
    }

    public static void getStatisticFromClients() {
        try {
            for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.Statistic.doPacket(byteBufferWriter);
                byteBufferWriter.putLong(System.currentTimeMillis());
                PacketTypes.PacketType.Statistic.send(udpConnection);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void updateZombieControl(IsoZombie isoZombie, short s, int n) {
        try {
            if (isoZombie.authOwner == null) {
                return;
            }
            ByteBufferWriter byteBufferWriter = isoZombie.authOwner.startPacket();
            PacketTypes.PacketType.ZombieControl.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoZombie.OnlineID);
            byteBufferWriter.putShort(s);
            byteBufferWriter.putInt(n);
            PacketTypes.PacketType.ZombieControl.send(isoZombie.authOwner);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void receivePlayerUpdate(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if (udpConnection.checksumState != UdpConnection.ChecksumState.Done) {
            GameServer.kick(udpConnection, "UI_Policy_Kick", null);
            udpConnection.forceDisconnect("kick-checksum");
            return;
        }
        PlayerPacket playerPacket = PlayerPacket.l_receive.playerPacket;
        playerPacket.parse(byteBuffer, udpConnection);
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, playerPacket.id);
        try {
            if (isoPlayer == null) {
                DebugLog.General.error("receivePlayerUpdate: Server received position for unknown player (id:" + playerPacket.id + "). Server will ignore this data.");
            } else {
                if (udpConnection.accessLevel == 1 && isoPlayer.networkAI.doCheckAccessLevel() && (playerPacket.booleanVariables & (SystemDisabler.getAllowDebugConnections() || SystemDisabler.getOverrideServerConnectDebugCheck() ? 49152 : 61440)) != 0 && ServerOptions.instance.AntiCheatProtectionType12.getValue() && PacketValidator.checkUser(udpConnection)) {
                    PacketValidator.doKickUser(udpConnection, playerPacket.getClass().getSimpleName(), "Type12", null);
                }
                if (!isoPlayer.networkAI.checkPosition(udpConnection, isoPlayer, PZMath.fastfloor(playerPacket.realx), PZMath.fastfloor(playerPacket.realy))) {
                    return;
                }
                if (!isoPlayer.networkAI.isSetVehicleHit()) {
                    isoPlayer.networkAI.parse(playerPacket);
                }
                isoPlayer.bleedingLevel = playerPacket.bleedingLevel;
                if (isoPlayer.networkAI.distance.getLength() > (float)IsoChunkMap.ChunkWidthInTiles) {
                    MPStatistic.getInstance().teleport();
                }
                udpConnection.ReleventPos[isoPlayer.PlayerIndex].x = playerPacket.realx;
                udpConnection.ReleventPos[isoPlayer.PlayerIndex].y = playerPacket.realy;
                udpConnection.ReleventPos[isoPlayer.PlayerIndex].z = playerPacket.realz;
                playerPacket.id = isoPlayer.getOnlineID();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (ServerOptions.instance.KickFastPlayers.getValue()) {
            Vector2 vector22 = playerToCoordsMap.get(playerPacket.id);
            if (vector22 == null) {
                vector22 = new Vector2();
                vector22.x = playerPacket.x;
                vector22.y = playerPacket.y;
                playerToCoordsMap.put(playerPacket.id, vector22);
            } else {
                if (!isoPlayer.accessLevel.equals("") && !isoPlayer.isGhostMode() && (Math.abs(playerPacket.x - vector22.x) > 4.0f || Math.abs(playerPacket.y - vector22.y) > 4.0f)) {
                    if (playerMovedToFastMap.get(playerPacket.id) == null) {
                        playerMovedToFastMap.put(playerPacket.id, 1);
                    } else {
                        playerMovedToFastMap.put(playerPacket.id, playerMovedToFastMap.get(playerPacket.id) + 1);
                    }
                    LoggerManager.getLogger("admin").write(isoPlayer.getDisplayName() + " go too fast (" + playerMovedToFastMap.get(playerPacket.id) + " times)");
                    if (playerMovedToFastMap.get(playerPacket.id) == 10) {
                        LoggerManager.getLogger("admin").write(isoPlayer.getDisplayName() + " kicked for going too fast");
                        GameServer.kick(udpConnection, "UI_Policy_Kick", null);
                        udpConnection.forceDisconnect("kick-fast-player");
                        return;
                    }
                }
                vector22.x = playerPacket.x;
                vector22.y = playerPacket.y;
            }
        }
        if (isoPlayer != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection.getConnectedGUID() == udpConnection2.getConnectedGUID() || !udpConnection2.isFullyConnected() || (!isoPlayer.checkCanSeeClient(udpConnection2) || !udpConnection2.RelevantTo(playerPacket.x, playerPacket.y)) && (s != PacketTypes.PacketType.PlayerUpdateReliable.getId() || udpConnection2.accessLevel <= udpConnection.accessLevel && udpConnection.accessLevel != 32)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.packetTypes.get(s).doPacket(byteBufferWriter);
                byteBuffer.position(0);
                byteBuffer.position(2);
                byteBufferWriter.bb.putShort(isoPlayer.getOnlineID());
                byteBufferWriter.bb.put(byteBuffer);
                PacketTypes.packetTypes.get(s).send(udpConnection2);
            }
        }
    }

    static void receivePacketCounts(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.PacketCounts.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(PacketTypes.packetTypes.size());
        for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
            byteBufferWriter.putShort(packetType.getId());
            byteBufferWriter.putLong(packetType.serverPacketCount);
        }
        PacketTypes.PacketType.PacketCounts.send(udpConnection);
    }

    static void receiveSandboxOptions(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            SandboxOptions.instance.load(byteBuffer);
            SandboxOptions.instance.applySettings();
            SandboxOptions.instance.toLua();
            SandboxOptions.instance.saveServerLuaFile(ServerName);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SandboxOptions.doPacket(byteBufferWriter);
                byteBuffer.rewind();
                byteBufferWriter.bb.put(byteBuffer);
                PacketTypes.PacketType.SandboxOptions.send(udpConnection2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void receiveChunkObjectState(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2;
        short s3 = byteBuffer.getShort();
        IsoChunk isoChunk = ServerMap.instance.getChunk(s3, s2 = byteBuffer.getShort());
        if (isoChunk == null) {
            udpConnection.chunkObjectState.add(s3);
            udpConnection.chunkObjectState.add(s2);
        } else {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.ChunkObjectState.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(s3);
            byteBufferWriter.putShort(s2);
            try {
                if (isoChunk.saveObjectState(byteBufferWriter.bb)) {
                    PacketTypes.PacketType.ChunkObjectState.send(udpConnection);
                } else {
                    udpConnection.cancelPacket();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                udpConnection.cancelPacket();
                return;
            }
        }
    }

    static void receiveReadAnnotedMap(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        StashSystem.prepareBuildingStash(string);
    }

    static void receiveTradingUIRemoveItem(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        int n = byteBuffer.getInt();
        Long l = IDToAddressMap.get(s3);
        if (l != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.TradingUIRemoveItem.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putInt(n);
                PacketTypes.PacketType.TradingUIRemoveItem.send(udpConnection2);
                break;
            }
        }
    }

    static void receiveTradingUIUpdateState(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        int n = byteBuffer.getInt();
        Long l = IDToAddressMap.get(s3);
        if (l != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.TradingUIUpdateState.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putInt(n);
                PacketTypes.PacketType.TradingUIUpdateState.send(udpConnection2);
                break;
            }
        }
    }

    static void receiveTradingUIAddItem(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        InventoryItem inventoryItem = null;
        try {
            inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (inventoryItem == null) {
            return;
        }
        Long l = IDToAddressMap.get(s3);
        if (l != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.TradingUIAddItem.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                try {
                    inventoryItem.saveWithSize(byteBufferWriter.bb, false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                PacketTypes.PacketType.TradingUIAddItem.send(udpConnection2);
                break;
            }
        }
    }

    static void receiveRequestTrading(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        byte by = byteBuffer.get();
        Long l = IDToAddressMap.get(s2);
        if (by == 0) {
            l = IDToAddressMap.get(s3);
        }
        if (l != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.RequestTrading.doPacket(byteBufferWriter);
                if (by == 0) {
                    byteBufferWriter.putShort(s2);
                } else {
                    byteBufferWriter.putShort(s3);
                }
                byteBufferWriter.putByte(by);
                PacketTypes.PacketType.RequestTrading.send(udpConnection2);
                break;
            }
        }
    }

    static void receiveSyncFaction(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        boolean bl;
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        boolean bl2 = byteBuffer.getInt();
        Faction faction = Faction.getFaction(string);
        boolean bl3 = false;
        if (faction == null) {
            faction = new Faction(string, string2);
            bl3 = true;
            Faction.getFactions().add(faction);
        }
        faction.getPlayers().clear();
        if (byteBuffer.get() == 1) {
            faction.setTag(GameWindow.ReadString(byteBuffer));
            faction.setTagColor(new ColorInfo(byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), 1.0f));
        }
        for (bl = false; bl < bl2; bl += 1) {
            String string3 = GameWindow.ReadString(byteBuffer);
            faction.getPlayers().add(string3);
        }
        if (!faction.getOwner().equals(string2)) {
            faction.setOwner(string2);
        }
        boolean bl4 = bl = byteBuffer.get() == 1;
        if (ChatServer.isInited()) {
            if (bl3) {
                ChatServer.getInstance().createFactionChat(string);
            }
            if (bl) {
                ChatServer.getInstance().removeFactionChat(string);
            } else {
                ChatServer.getInstance().syncFactionChatMembers(string, string2, faction.getPlayers());
            }
        }
        if (bl) {
            Faction.getFactions().remove(faction);
            DebugLog.log("faction: removed " + string + " owner=" + faction.getOwner());
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SyncFaction.doPacket(byteBufferWriter);
            faction.writeToBuffer(byteBufferWriter, bl);
            PacketTypes.PacketType.SyncFaction.send(udpConnection2);
        }
    }

    static void receiveSyncNonPvpZone(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            SyncNonPvpZonePacket syncNonPvpZonePacket = new SyncNonPvpZonePacket();
            syncNonPvpZonePacket.parse(byteBuffer, udpConnection);
            if (syncNonPvpZonePacket.isConsistent()) {
                GameServer.sendNonPvpZone(syncNonPvpZonePacket.zone, syncNonPvpZonePacket.doRemove, udpConnection);
                syncNonPvpZonePacket.process();
                DebugLog.Multiplayer.debugln("ReceiveSyncNonPvpZone: %s", syncNonPvpZonePacket.getDescription());
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveSyncNonPvpZone: failed", LogSeverity.Error);
        }
    }

    public static void sendNonPvpZone(NonPvpZone nonPvpZone, boolean bl, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SyncNonPvpZone.doPacket(byteBufferWriter);
            nonPvpZone.save(byteBufferWriter.bb);
            byteBufferWriter.putBoolean(bl);
            PacketTypes.PacketType.SyncNonPvpZone.send(udpConnection2);
        }
    }

    static void receiveChangeTextColor(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, s2);
        if (isoPlayer == null) {
            return;
        }
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        isoPlayer.setSpeakColourInfo(new ColorInfo(f, f2, f3, 1.0f));
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.ChangeTextColor.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoPlayer.getOnlineID());
            byteBufferWriter.putFloat(f);
            byteBufferWriter.putFloat(f2);
            byteBufferWriter.putFloat(f3);
            PacketTypes.PacketType.ChangeTextColor.send(udpConnection2);
        }
    }

    @Deprecated
    static void receiveTransactionID(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        short s = byteBuffer.getShort();
        int n = byteBuffer.getInt();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s);
        if (isoPlayer != null) {
            transactionIDMap.put(isoPlayer.username, n);
            isoPlayer.setTransactionID(n);
            ServerWorldDatabase.instance.saveTransactionID(isoPlayer.username, n);
        }
    }

    static void receiveSyncCompost(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        int n3 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3, n2 = byteBuffer.getInt(), n = byteBuffer.getInt());
        if (isoGridSquare != null) {
            IsoCompost isoCompost = isoGridSquare.getCompost();
            if (isoCompost == null) {
                isoCompost = new IsoCompost(isoGridSquare.getCell(), isoGridSquare);
                isoGridSquare.AddSpecialObject(isoCompost);
            }
            float f = byteBuffer.getFloat();
            isoCompost.setCompost(f);
            GameServer.sendCompost(isoCompost, udpConnection);
        }
    }

    public static void sendCompost(IsoCompost isoCompost, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (!udpConnection2.RelevantTo(isoCompost.square.x, isoCompost.square.y) || (udpConnection == null || udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) && udpConnection != null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SyncCompost.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(isoCompost.square.x);
            byteBufferWriter.putInt(isoCompost.square.y);
            byteBufferWriter.putInt(isoCompost.square.z);
            byteBufferWriter.putFloat(isoCompost.getCompost());
            PacketTypes.PacketType.SyncCompost.send(udpConnection2);
        }
    }

    static void receiveCataplasm(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer != null) {
            int n = byteBuffer.getInt();
            float f = byteBuffer.getFloat();
            float f2 = byteBuffer.getFloat();
            float f3 = byteBuffer.getFloat();
            if (f > 0.0f) {
                isoPlayer.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n)).setPlantainFactor(f);
            }
            if (f2 > 0.0f) {
                isoPlayer.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n)).setComfreyFactor(f2);
            }
            if (f3 > 0.0f) {
                isoPlayer.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n)).setGarlicFactor(f3);
            }
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.Cataplasm.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putFloat(f);
                byteBufferWriter.putFloat(f2);
                byteBufferWriter.putFloat(f3);
                PacketTypes.PacketType.Cataplasm.send(udpConnection2);
            }
        }
    }

    static void receiveSledgehammerDestroy(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if (ServerOptions.instance.AllowDestructionBySledgehammer.getValue()) {
            GameServer.receiveRemoveItemFromSquare(byteBuffer, udpConnection, s);
        }
    }

    public static void AddExplosiveTrap(HandWeapon handWeapon, IsoGridSquare isoGridSquare, boolean bl) {
        IsoTrap isoTrap = new IsoTrap(handWeapon, isoGridSquare.getCell(), isoGridSquare);
        int n = 0;
        if (handWeapon.getExplosionRange() > 0) {
            n = handWeapon.getExplosionRange();
        }
        if (handWeapon.getFireRange() > 0) {
            n = handWeapon.getFireRange();
        }
        if (handWeapon.getSmokeRange() > 0) {
            n = handWeapon.getSmokeRange();
        }
        isoGridSquare.AddTileObject(isoTrap);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.AddExplosiveTrap.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(isoGridSquare.x);
            byteBufferWriter.putInt(isoGridSquare.y);
            byteBufferWriter.putInt(isoGridSquare.z);
            try {
                handWeapon.saveWithSize(byteBufferWriter.bb, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byteBufferWriter.putInt(n);
            byteBufferWriter.putBoolean(bl);
            byteBufferWriter.putBoolean(false);
            PacketTypes.PacketType.AddExplosiveTrap.send(udpConnection);
        }
    }

    static void receiveAddExplosiveTrap(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        int n3 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3, n2 = byteBuffer.getInt(), n = byteBuffer.getInt());
        if (isoGridSquare != null) {
            InventoryItem inventoryItem = null;
            try {
                inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (inventoryItem == null) {
                return;
            }
            HandWeapon handWeapon = (HandWeapon)inventoryItem;
            DebugLog.log("trap: user \"" + udpConnection.username + "\" added " + inventoryItem.getFullType() + " at " + n3 + "," + n2 + "," + n);
            LoggerManager.getLogger("map").write(udpConnection.idStr + " \"" + udpConnection.username + "\" added " + inventoryItem.getFullType() + " at " + n3 + "," + n2 + "," + n);
            if (handWeapon.isInstantExplosion()) {
                IsoTrap isoTrap = new IsoTrap(handWeapon, isoGridSquare.getCell(), isoGridSquare);
                isoGridSquare.AddTileObject(isoTrap);
                isoTrap.triggerExplosion(false);
            }
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.AddExplosiveTrap.doPacket(byteBufferWriter);
                byteBufferWriter.putInt(n3);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putInt(n);
                try {
                    handWeapon.saveWithSize(byteBufferWriter.bb, false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                PacketTypes.PacketType.AddExplosiveTrap.send(udpConnection2);
            }
        }
    }

    public static void sendHelicopter(float f, float f2, boolean bl) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.Helicopter.doPacket(byteBufferWriter);
            byteBufferWriter.putFloat(f);
            byteBufferWriter.putFloat(f2);
            byteBufferWriter.putBoolean(bl);
            PacketTypes.PacketType.Helicopter.send(udpConnection);
        }
    }

    static void receiveRegisterZone(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        int n6 = byteBuffer.getInt();
        boolean bl = byteBuffer.get() == 1;
        ArrayList<IsoMetaGrid.Zone> arrayList = IsoWorld.instance.getMetaGrid().getZonesAt(n, n2, n3);
        boolean bl2 = false;
        for (IsoMetaGrid.Zone object : arrayList) {
            if (!string2.equals(object.getType())) continue;
            bl2 = true;
            object.setName(string);
            object.setLastActionTimestamp(n6);
        }
        if (!bl2) {
            IsoWorld.instance.getMetaGrid().registerZone(string, string2, n, n2, n3, n4, n5);
        }
        if (bl) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.RegisterZone.doPacket(byteBufferWriter);
                byteBufferWriter.putUTF(string);
                byteBufferWriter.putUTF(string2);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putInt(n3);
                byteBufferWriter.putInt(n4);
                byteBufferWriter.putInt(n5);
                byteBufferWriter.putInt(n6);
                PacketTypes.PacketType.RegisterZone.send(udpConnection2);
            }
        }
    }

    public static void sendZone(IsoMetaGrid.Zone zone, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.RegisterZone.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(zone.name);
            byteBufferWriter.putUTF(zone.type);
            byteBufferWriter.putInt(zone.x);
            byteBufferWriter.putInt(zone.y);
            byteBufferWriter.putInt(zone.z);
            byteBufferWriter.putInt(zone.w);
            byteBufferWriter.putInt(zone.h);
            byteBufferWriter.putInt(zone.lastActionTimestamp);
            PacketTypes.PacketType.RegisterZone.send(udpConnection2);
        }
    }

    static void receiveConstructedZone(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        int n3 = byteBuffer.getInt();
        IsoMetaGrid.Zone zone = IsoWorld.instance.MetaGrid.getZoneAt(n3, n2 = byteBuffer.getInt(), n = byteBuffer.getInt());
        if (zone != null) {
            zone.setHaveConstruction(true);
        }
    }

    public static void addXp(IsoPlayer isoPlayer, PerkFactory.Perk perk, int n) {
        if (PlayerToAddressMap.containsKey(isoPlayer)) {
            long l = PlayerToAddressMap.get(isoPlayer);
            UdpConnection udpConnection = udpEngine.getActiveConnection(l);
            if (udpConnection == null) {
                return;
            }
            AddXp addXp = new AddXp();
            addXp.set(isoPlayer, perk, n);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.AddXP.doPacket(byteBufferWriter);
            addXp.write(byteBufferWriter);
            PacketTypes.PacketType.AddXP.send(udpConnection);
        }
    }

    static void receiveWriteLog(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
    }

    static void receiveChecksum(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        NetChecksum.comparer.serverPacket(byteBuffer, udpConnection);
    }

    private static void answerPing(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        String string = GameWindow.ReadString(byteBuffer);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() != udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.Ping.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putInt(GameServer.udpEngine.connections.size());
            byteBufferWriter.putInt(512);
            PacketTypes.PacketType.Ping.send(udpConnection2);
        }
    }

    static void receiveUpdateItemSprite(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        String string = GameWindow.ReadStringUTF(byteBuffer);
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n2, n3, n4);
        if (isoGridSquare != null && n5 < isoGridSquare.getObjects().size()) {
            try {
                IsoObject isoObject = isoGridSquare.getObjects().get(n5);
                if (isoObject != null) {
                    isoObject.sprite = IsoSpriteManager.instance.getSprite(n);
                    if (isoObject.sprite == null && !string.isEmpty()) {
                        isoObject.setSprite(string);
                    }
                    isoObject.RemoveAttachedAnims();
                    int n6 = byteBuffer.get() & 0xFF;
                    for (int i = 0; i < n6; ++i) {
                        int n7 = byteBuffer.getInt();
                        IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(n7);
                        if (isoSprite == null) continue;
                        isoObject.AttachExistingAnim(isoSprite, 0, 0, false, 0, false, 0.0f);
                    }
                    isoObject.transmitUpdatedSpriteToClients(udpConnection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void receiveWorldMessage(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if (udpConnection.allChatMuted) {
            return;
        }
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        if (string2.length() > 256) {
            string2 = string2.substring(0, 256);
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.WorldMessage.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putUTF(string2);
            PacketTypes.PacketType.WorldMessage.send(udpConnection2);
        }
        discordBot.sendMessage(string, string2);
        LoggerManager.getLogger("chat").write(udpConnection.index + " \"" + udpConnection.username + "\" A \"" + string2 + "\"");
    }

    static void receiveGetModData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        LuaEventManager.triggerEvent("SendCustomModData");
    }

    static void receiveStopFire(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        byte by = byteBuffer.get();
        if (by == 1) {
            short s2 = byteBuffer.getShort();
            IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
            if (isoPlayer != null) {
                isoPlayer.sendObjectChange("StopBurning");
            }
            return;
        }
        if (by == 2) {
            short s3 = byteBuffer.getShort();
            IsoZombie isoZombie = ServerMap.instance.ZombieMap.get(s3);
            if (isoZombie != null) {
                isoZombie.StopBurning();
            }
            return;
        }
        int n3 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n3, n2 = byteBuffer.getInt(), n = byteBuffer.getInt());
        if (isoGridSquare == null) {
            return;
        }
        isoGridSquare.stopFire();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (!udpConnection2.RelevantTo(n3, n2) || udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.StopFire.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n);
            PacketTypes.PacketType.StopFire.send(udpConnection2);
        }
    }

    @Deprecated
    static void receiveStartFire(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        StartFire startFire = new StartFire();
        startFire.parse(byteBuffer, udpConnection);
        if (!startFire.isConsistent() || !startFire.validate(udpConnection)) {
            return;
        }
        startFire.process();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.StartFire.doPacket(byteBufferWriter);
            startFire.write(byteBufferWriter);
            PacketTypes.PacketType.StartFire.send(udpConnection2);
        }
    }

    public static void startFireOnClient(IsoGridSquare isoGridSquare, int n, boolean bl, int n2, boolean bl2) {
        StartFire startFire = new StartFire();
        startFire.set(isoGridSquare, bl, n, n2, bl2);
        startFire.process();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(isoGridSquare.getX(), isoGridSquare.getY())) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.StartFire.doPacket(byteBufferWriter);
            startFire.write(byteBufferWriter);
            PacketTypes.PacketType.StartFire.send(udpConnection);
        }
    }

    public static void sendOptionsToClients() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.ReloadOptions.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(ServerOptions.instance.getPublicOptions().size());
            String string2 = null;
            for (String string2 : ServerOptions.instance.getPublicOptions()) {
                byteBufferWriter.putUTF(string2);
                byteBufferWriter.putUTF(ServerOptions.instance.getOption(string2));
            }
            PacketTypes.PacketType.ReloadOptions.send(udpConnection);
        }
    }

    public static void sendBecomeCorpse(IsoDeadBody isoDeadBody) {
        IsoGridSquare isoGridSquare = isoDeadBody.getSquare();
        if (isoGridSquare != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                if (!udpConnection.RelevantTo(isoGridSquare.x, isoGridSquare.y)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.BecomeCorpse.doPacket(byteBufferWriter);
                try {
                    byteBufferWriter.putShort(isoDeadBody.getObjectID());
                    byteBufferWriter.putShort(isoDeadBody.getOnlineID());
                    byteBufferWriter.putFloat(isoDeadBody.getReanimateTime());
                    if (isoDeadBody.isPlayer()) {
                        byteBufferWriter.putByte((byte)2);
                    } else if (isoDeadBody.isZombie()) {
                        byteBufferWriter.putByte((byte)1);
                    } else {
                        byteBufferWriter.putByte((byte)0);
                    }
                    byteBufferWriter.putInt(isoGridSquare.x);
                    byteBufferWriter.putInt(isoGridSquare.y);
                    byteBufferWriter.putInt(isoGridSquare.z);
                    PacketTypes.PacketType.BecomeCorpse.send(udpConnection);
                    continue;
                }
                catch (Exception exception) {
                    udpConnection.cancelPacket();
                    DebugLog.Multiplayer.printException(exception, "SendBecomeCorpse failed", LogSeverity.Error);
                }
            }
        }
    }

    public static void sendCorpse(IsoDeadBody isoDeadBody) {
        IsoGridSquare isoGridSquare = isoDeadBody.getSquare();
        if (isoGridSquare != null) {
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                if (!udpConnection.RelevantTo(isoGridSquare.x, isoGridSquare.y)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AddCorpseToMap.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(isoDeadBody.getObjectID());
                byteBufferWriter.putShort(isoDeadBody.getOnlineID());
                byteBufferWriter.putInt(isoGridSquare.x);
                byteBufferWriter.putInt(isoGridSquare.y);
                byteBufferWriter.putInt(isoGridSquare.z);
                isoDeadBody.writeToRemoteBuffer(byteBufferWriter);
                PacketTypes.PacketType.AddCorpseToMap.send(udpConnection);
            }
        }
    }

    static void receiveAddCorpseToMap(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        IsoObject isoObject = WorldItemTypes.createFromBuffer(byteBuffer);
        if (isoObject == null || !(isoObject instanceof IsoDeadBody)) {
            return;
        }
        isoObject.loadFromRemoteBuffer(byteBuffer, false);
        ((IsoDeadBody)isoObject).setObjectID(s2);
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n, n2, n3);
        if (isoGridSquare != null) {
            isoGridSquare.addCorpse((IsoDeadBody)isoObject, true);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !udpConnection2.RelevantTo(n, n2)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.AddCorpseToMap.doPacket(byteBufferWriter);
                byteBuffer.rewind();
                byteBufferWriter.bb.put(byteBuffer);
                PacketTypes.PacketType.AddCorpseToMap.send(udpConnection2);
            }
        }
        LoggerManager.getLogger("item").write(udpConnection.idStr + " \"" + udpConnection.username + "\" corpse +1 " + n + "," + n2 + "," + n3);
    }

    static void receiveSmashWindow(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoObject isoObject = IsoWorld.instance.getItemFromXYZIndexBuffer(byteBuffer);
        if (isoObject != null && isoObject instanceof IsoWindow) {
            byte by = byteBuffer.get();
            if (by == 1) {
                ((IsoWindow)isoObject).smashWindow(true);
                GameServer.smashWindow((IsoWindow)isoObject, 1);
            } else if (by == 2) {
                ((IsoWindow)isoObject).setGlassRemoved(true);
                GameServer.smashWindow((IsoWindow)isoObject, 2);
            }
        }
    }

    public static void sendPlayerConnect(IsoPlayer isoPlayer, UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.PlayerConnect.doPacket(byteBufferWriter);
        if (udpConnection.getConnectedGUID() != PlayerToAddressMap.get(isoPlayer).longValue()) {
            byteBufferWriter.putShort(isoPlayer.OnlineID);
        } else {
            byteBufferWriter.putShort((short)-1);
            byteBufferWriter.putByte((byte)isoPlayer.PlayerIndex);
            byteBufferWriter.putShort(isoPlayer.OnlineID);
            try {
                GameTime.getInstance().saveToPacket(byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byteBufferWriter.putFloat(isoPlayer.x);
        byteBufferWriter.putFloat(isoPlayer.y);
        byteBufferWriter.putFloat(isoPlayer.z);
        byteBufferWriter.putUTF(isoPlayer.username);
        if (udpConnection.getConnectedGUID() != PlayerToAddressMap.get(isoPlayer).longValue()) {
            try {
                isoPlayer.getDescriptor().save(byteBufferWriter.bb);
                isoPlayer.getHumanVisual().save(byteBufferWriter.bb);
                ItemVisuals itemVisuals = new ItemVisuals();
                isoPlayer.getItemVisuals(itemVisuals);
                itemVisuals.save(byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (SteamUtils.isSteamModeEnabled()) {
            byteBufferWriter.putLong(isoPlayer.getSteamID());
        }
        byteBufferWriter.putByte(isoPlayer.isGodMod() ? (byte)1 : 0);
        byteBufferWriter.putByte(isoPlayer.isGhostMode() ? (byte)1 : 0);
        isoPlayer.getSafety().save(byteBufferWriter.bb);
        byteBufferWriter.putByte(PlayerType.fromString(isoPlayer.accessLevel));
        byteBufferWriter.putByte(isoPlayer.isInvisible() ? (byte)1 : 0);
        if (udpConnection.getConnectedGUID() != PlayerToAddressMap.get(isoPlayer).longValue()) {
            try {
                isoPlayer.getXp().save(byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byteBufferWriter.putUTF(isoPlayer.getTagPrefix());
        byteBufferWriter.putFloat(isoPlayer.getTagColor().r);
        byteBufferWriter.putFloat(isoPlayer.getTagColor().g);
        byteBufferWriter.putFloat(isoPlayer.getTagColor().b);
        byteBufferWriter.putDouble(isoPlayer.getHoursSurvived());
        byteBufferWriter.putInt(isoPlayer.getZombieKills());
        byteBufferWriter.putUTF(isoPlayer.getDisplayName());
        byteBufferWriter.putFloat(isoPlayer.getSpeakColour().r);
        byteBufferWriter.putFloat(isoPlayer.getSpeakColour().g);
        byteBufferWriter.putFloat(isoPlayer.getSpeakColour().b);
        byteBufferWriter.putBoolean(isoPlayer.showTag);
        byteBufferWriter.putBoolean(isoPlayer.factionPvp);
        byteBufferWriter.putInt(isoPlayer.getAttachedItems().size());
        for (int i = 0; i < isoPlayer.getAttachedItems().size(); ++i) {
            byteBufferWriter.putUTF(isoPlayer.getAttachedItems().get(i).getLocation());
            byteBufferWriter.putUTF(isoPlayer.getAttachedItems().get(i).getItem().getFullType());
        }
        byteBufferWriter.putInt(isoPlayer.remoteSneakLvl);
        byteBufferWriter.putInt(isoPlayer.remoteStrLvl);
        byteBufferWriter.putInt(isoPlayer.remoteFitLvl);
        PacketTypes.PacketType.PlayerConnect.send(udpConnection);
        if (udpConnection.getConnectedGUID() != PlayerToAddressMap.get(isoPlayer).longValue()) {
            GameServer.updateHandEquips(udpConnection, isoPlayer);
        }
    }

    @Deprecated
    static void receiveRequestPlayerData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoPlayer isoPlayer = IDToPlayerMap.get(byteBuffer.getShort());
        if (isoPlayer != null) {
            GameServer.sendPlayerConnect(isoPlayer, udpConnection);
        }
    }

    static void receiveChatMessageFromPlayer(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ChatServer.getInstance().processMessageFromPlayerPacket(byteBuffer);
    }

    public static void loadModData(IsoGridSquare isoGridSquare) {
        if (isoGridSquare.getModData().rawget("id") != null && isoGridSquare.getModData().rawget("id") != null && (isoGridSquare.getModData().rawget("remove") == null || ((String)isoGridSquare.getModData().rawget("remove")).equals("false"))) {
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":x", (Object)new Double(isoGridSquare.getX()));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":y", (Object)new Double(isoGridSquare.getY()));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":z", (Object)new Double(isoGridSquare.getZ()));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":typeOfSeed", isoGridSquare.getModData().rawget("typeOfSeed"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":nbOfGrow", (Object)((Double)isoGridSquare.getModData().rawget("nbOfGrow")));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":id", isoGridSquare.getModData().rawget("id"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":waterLvl", isoGridSquare.getModData().rawget("waterLvl"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":lastWaterHour", isoGridSquare.getModData().rawget("lastWaterHour"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":waterNeeded", isoGridSquare.getModData().rawget("waterNeeded"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":waterNeededMax", isoGridSquare.getModData().rawget("waterNeededMax"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":mildewLvl", isoGridSquare.getModData().rawget("mildewLvl"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":aphidLvl", isoGridSquare.getModData().rawget("aphidLvl"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":fliesLvl", isoGridSquare.getModData().rawget("fliesLvl"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":fertilizer", isoGridSquare.getModData().rawget("fertilizer"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":nextGrowing", isoGridSquare.getModData().rawget("nextGrowing"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":hasVegetable", isoGridSquare.getModData().rawget("hasVegetable"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":hasSeed", isoGridSquare.getModData().rawget("hasSeed"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":health", isoGridSquare.getModData().rawget("health"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":badCare", isoGridSquare.getModData().rawget("badCare"));
            GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":state", isoGridSquare.getModData().rawget("state"));
            if (isoGridSquare.getModData().rawget("hoursElapsed") != null) {
                GameTime.getInstance().getModData().rawset("hoursElapsed", isoGridSquare.getModData().rawget("hoursElapsed"));
            }
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(isoGridSquare.getX(), isoGridSquare.getY())) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.ReceiveModData.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(isoGridSquare.getX());
            byteBufferWriter.putInt(isoGridSquare.getY());
            byteBufferWriter.putInt(isoGridSquare.getZ());
            try {
                isoGridSquare.getModData().save(byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            PacketTypes.PacketType.ReceiveModData.send(udpConnection);
        }
    }

    static void receiveSendModData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        int n3 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n3, n2 = byteBuffer.getInt(), n = byteBuffer.getInt());
        if (isoGridSquare == null) {
            return;
        }
        try {
            isoGridSquare.getModData().load(byteBuffer, 195);
            if (isoGridSquare.getModData().rawget("id") != null && (isoGridSquare.getModData().rawget("remove") == null || ((String)isoGridSquare.getModData().rawget("remove")).equals("false"))) {
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":x", (Object)new Double(isoGridSquare.getX()));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":y", (Object)new Double(isoGridSquare.getY()));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":z", (Object)new Double(isoGridSquare.getZ()));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":typeOfSeed", isoGridSquare.getModData().rawget("typeOfSeed"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":nbOfGrow", (Object)((Double)isoGridSquare.getModData().rawget("nbOfGrow")));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":id", isoGridSquare.getModData().rawget("id"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":waterLvl", isoGridSquare.getModData().rawget("waterLvl"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":lastWaterHour", isoGridSquare.getModData().rawget("lastWaterHour"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":waterNeeded", isoGridSquare.getModData().rawget("waterNeeded"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":waterNeededMax", isoGridSquare.getModData().rawget("waterNeededMax"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":mildewLvl", isoGridSquare.getModData().rawget("mildewLvl"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":aphidLvl", isoGridSquare.getModData().rawget("aphidLvl"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":fliesLvl", isoGridSquare.getModData().rawget("fliesLvl"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":fertilizer", isoGridSquare.getModData().rawget("fertilizer"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":nextGrowing", isoGridSquare.getModData().rawget("nextGrowing"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":hasVegetable", isoGridSquare.getModData().rawget("hasVegetable"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":hasSeed", isoGridSquare.getModData().rawget("hasSeed"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":health", isoGridSquare.getModData().rawget("health"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":badCare", isoGridSquare.getModData().rawget("badCare"));
                GameTime.getInstance().getModData().rawset("planting:" + ((Double)isoGridSquare.getModData().rawget("id")).intValue() + ":state", isoGridSquare.getModData().rawget("state"));
                if (isoGridSquare.getModData().rawget("hoursElapsed") != null) {
                    GameTime.getInstance().getModData().rawset("hoursElapsed", isoGridSquare.getModData().rawget("hoursElapsed"));
                }
            }
            LuaEventManager.triggerEvent("onLoadModDataFromServer", isoGridSquare);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (!udpConnection2.RelevantTo(isoGridSquare.getX(), isoGridSquare.getY()) || udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.ReceiveModData.doPacket(byteBufferWriter);
                byteBufferWriter.putInt(n3);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putInt(n);
                try {
                    isoGridSquare.getModData().save(byteBufferWriter.bb);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                PacketTypes.PacketType.ReceiveModData.send(udpConnection2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static void receiveWeaponHit(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoObject isoObject = GameServer.getIsoObjectRefFromByteBuffer(byteBuffer);
        short s2 = byteBuffer.getShort();
        String string = GameWindow.ReadStringUTF(byteBuffer);
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, s2);
        if (isoObject != null && isoPlayer != null) {
            InventoryItem inventoryItem = null;
            if (!string.isEmpty() && !((inventoryItem = InventoryItemFactory.CreateItem(string)) instanceof HandWeapon)) {
                return;
            }
            if (inventoryItem == null && !(isoObject instanceof IsoWindow)) {
                return;
            }
            int n = (int)isoObject.getX();
            int n2 = (int)isoObject.getY();
            int n3 = (int)isoObject.getZ();
            if (isoObject instanceof IsoDoor) {
                ((IsoDoor)isoObject).WeaponHit(isoPlayer, (HandWeapon)inventoryItem);
            } else if (isoObject instanceof IsoThumpable) {
                ((IsoThumpable)isoObject).WeaponHit(isoPlayer, (HandWeapon)inventoryItem);
            } else if (isoObject instanceof IsoWindow) {
                ((IsoWindow)isoObject).WeaponHit(isoPlayer, (HandWeapon)inventoryItem);
            } else if (isoObject instanceof IsoBarricade) {
                ((IsoBarricade)isoObject).WeaponHit(isoPlayer, (HandWeapon)inventoryItem);
            }
            if (isoObject.getObjectIndex() == -1) {
                LoggerManager.getLogger("map").write(udpConnection.idStr + " \"" + udpConnection.username + "\" destroyed " + (isoObject.getName() != null ? isoObject.getName() : isoObject.getObjectName()) + " with " + (string.isEmpty() ? "BareHands" : string) + " at " + n + "," + n2 + "," + n3);
            }
        }
    }

    private static void putIsoObjectRefToByteBuffer(IsoObject isoObject, ByteBuffer byteBuffer) {
        byteBuffer.putInt(isoObject.square.x);
        byteBuffer.putInt(isoObject.square.y);
        byteBuffer.putInt(isoObject.square.z);
        byteBuffer.put((byte)isoObject.square.getObjects().indexOf(isoObject));
    }

    private static IsoObject getIsoObjectRefFromByteBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getObjects().size()) {
            return isoGridSquare.getObjects().get(by);
        }
        return null;
    }

    static void receiveDrink(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        float f = byteBuffer.getFloat();
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (isoPlayer != null) {
            isoPlayer.getStats().thirst -= f;
            if (isoPlayer.getStats().thirst < 0.0f) {
                isoPlayer.getStats().thirst = 0.0f;
            }
        }
    }

    private static void process(ZomboidNetData zomboidNetData) {
        ByteBuffer byteBuffer = zomboidNetData.buffer;
        UdpConnection udpConnection = udpEngine.getActiveConnection(zomboidNetData.connection);
        try {
            switch (zomboidNetData.type) {
                default: 
            }
            GameServer.doZomboidDataInMainLoop(zomboidNetData);
            return;
        }
        catch (Exception exception) {
            DebugLog.log(DebugType.Network, "Error with packet of type: " + zomboidNetData.type);
            exception.printStackTrace();
            return;
        }
    }

    static void receiveEatFood(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoPlayer isoPlayer;
        byte by = byteBuffer.get();
        float f = byteBuffer.getFloat();
        InventoryItem inventoryItem = null;
        try {
            inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (inventoryItem instanceof Food && (isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by)) != null) {
            isoPlayer.Eat(inventoryItem, f);
        }
    }

    static void receivePingFromClient(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        long l = byteBuffer.getLong();
        if (l == -1L) {
            DebugLog.Multiplayer.warn("Player \"%s\" toggled lua debugger", udpConnection.username);
        } else {
            if (udpConnection.accessLevel != 32) {
                return;
            }
            PacketTypes.PacketType.PingFromClient.doPacket(byteBufferWriter);
            try {
                byteBufferWriter.putLong(l);
                MPStatistics.write(udpConnection, byteBufferWriter.bb);
                PacketTypes.PacketType.PingFromClient.send(udpConnection);
                MPStatistics.requested();
            }
            catch (Exception exception) {
                udpConnection.cancelPacket();
            }
        }
    }

    static void receiveBandage(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer != null) {
            int n = byteBuffer.getInt();
            boolean bl = byteBuffer.get() == 1;
            float f = byteBuffer.getFloat();
            boolean bl2 = byteBuffer.get() == 1;
            String string = GameWindow.ReadStringUTF(byteBuffer);
            isoPlayer.getBodyDamage().SetBandaged(n, bl, f, bl2, string);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.Bandage.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putBoolean(bl);
                byteBufferWriter.putFloat(f);
                byteBufferWriter.putBoolean(bl2);
                GameWindow.WriteStringUTF(byteBufferWriter.bb, string);
                PacketTypes.PacketType.Bandage.send(udpConnection2);
            }
        }
    }

    static void receiveStitch(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        Stitch stitch = new Stitch();
        stitch.parse(byteBuffer, udpConnection);
        if (!stitch.isConsistent() || !stitch.validate(udpConnection)) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.Stitch.doPacket(byteBufferWriter);
            stitch.write(byteBufferWriter);
            PacketTypes.PacketType.Stitch.send(udpConnection2);
        }
    }

    @Deprecated
    static void receiveWoundInfection(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer != null) {
            int n = byteBuffer.getInt();
            boolean bl = byteBuffer.get() == 1;
            isoPlayer.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n)).setInfectedWound(bl);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.WoundInfection.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putBoolean(bl);
                PacketTypes.PacketType.WoundInfection.send(udpConnection2);
            }
        }
    }

    static void receiveDisinfect(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        Disinfect disinfect = new Disinfect();
        disinfect.parse(byteBuffer, udpConnection);
        if (!disinfect.isConsistent() || !disinfect.validate(udpConnection)) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.Disinfect.doPacket(byteBufferWriter);
            disinfect.write(byteBufferWriter);
            PacketTypes.PacketType.Disinfect.send(udpConnection2);
        }
    }

    static void receiveSplint(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer != null) {
            int n = byteBuffer.getInt();
            boolean bl = byteBuffer.get() == 1;
            String string = bl ? GameWindow.ReadStringUTF(byteBuffer) : null;
            float f = bl ? byteBuffer.getFloat() : 0.0f;
            BodyPart bodyPart = isoPlayer.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n));
            bodyPart.setSplint(bl, f);
            bodyPart.setSplintItem(string);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.Splint.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putBoolean(bl);
                if (bl) {
                    byteBufferWriter.putUTF(string);
                    byteBufferWriter.putFloat(f);
                }
                PacketTypes.PacketType.Splint.send(udpConnection2);
            }
        }
    }

    static void receiveAdditionalPain(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer != null) {
            int n = byteBuffer.getInt();
            float f = byteBuffer.getFloat();
            BodyPart bodyPart = isoPlayer.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n));
            bodyPart.setAdditionalPain(bodyPart.getAdditionalPain() + f);
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.AdditionalPain.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putFloat(f);
                PacketTypes.PacketType.AdditionalPain.send(udpConnection2);
            }
        }
    }

    static void receiveRemoveGlass(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        RemoveGlass removeGlass = new RemoveGlass();
        removeGlass.parse(byteBuffer, udpConnection);
        if (!removeGlass.isConsistent() || !removeGlass.validate(udpConnection)) {
            return;
        }
        removeGlass.process();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.RemoveGlass.doPacket(byteBufferWriter);
            removeGlass.write(byteBufferWriter);
            PacketTypes.PacketType.RemoveGlass.send(udpConnection2);
        }
    }

    static void receiveRemoveBullet(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        RemoveBullet removeBullet = new RemoveBullet();
        removeBullet.parse(byteBuffer, udpConnection);
        if (!removeBullet.isConsistent() || !removeBullet.validate(udpConnection)) {
            return;
        }
        removeBullet.process();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.RemoveBullet.doPacket(byteBufferWriter);
            removeBullet.write(byteBufferWriter);
            PacketTypes.PacketType.RemoveBullet.send(udpConnection2);
        }
    }

    static void receiveCleanBurn(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        CleanBurn cleanBurn = new CleanBurn();
        cleanBurn.parse(byteBuffer, udpConnection);
        if (!cleanBurn.isConsistent() || !cleanBurn.validate(udpConnection)) {
            return;
        }
        cleanBurn.process();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.CleanBurn.doPacket(byteBufferWriter);
            cleanBurn.write(byteBufferWriter);
            PacketTypes.PacketType.CleanBurn.send(udpConnection2);
        }
    }

    static void receiveBodyDamageUpdate(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        BodyDamageSync.instance.serverPacket(byteBuffer);
    }

    static void receiveReceiveCommand(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        Object object = null;
        object = GameServer.handleClientCommand(string.substring(1), udpConnection);
        if (object == null) {
            object = GameServer.handleServerCommand(string.substring(1), udpConnection);
        }
        if (object == null) {
            object = "Unknown command " + string;
        }
        if (string.substring(1).startsWith("roll") || string.substring(1).startsWith("card")) {
            ChatServer.getInstance().sendMessageToServerChat(udpConnection, (String)object);
        } else {
            ChatServer.getInstance().sendMessageToServerChat(udpConnection, (String)object);
        }
    }

    private static String handleClientCommand(String string, UdpConnection udpConnection) {
        String string2;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = Pattern.compile("([^\"]\\S*|\".*?\")\\s*").matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(1).replace("\"", ""));
        }
        int n = arrayList.size();
        String[] stringArray = arrayList.toArray(new String[n]);
        String string3 = string2 = n > 0 ? stringArray[0].toLowerCase() : "";
        if (string2.equals("card")) {
            GameServer.PlayWorldSoundServer("ChatDrawCard", false, GameServer.getAnyPlayerFromConnection(udpConnection).getCurrentSquare(), 0.0f, 3.0f, 1.0f, false);
            return udpConnection.username + " drew " + ServerOptions.getRandomCard();
        }
        if (string2.equals("roll")) {
            if (n != 2) {
                return ServerOptions.clientOptionsList.get("roll");
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(stringArray[1]);
                GameServer.PlayWorldSoundServer("ChatRollDice", false, GameServer.getAnyPlayerFromConnection(udpConnection).getCurrentSquare(), 0.0f, 3.0f, 1.0f, false);
                return udpConnection.username + " rolls a " + n2 + "-sided dice and obtains " + Rand.Next(n2);
            }
            catch (Exception exception) {
                return ServerOptions.clientOptionsList.get("roll");
            }
        }
        if (string2.equals("changepwd")) {
            if (n == 3) {
                String string4 = stringArray[1];
                String string5 = stringArray[2];
                try {
                    return ServerWorldDatabase.instance.changePwd(udpConnection.username, string4.trim(), string5.trim());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    return "A SQL error occured";
                }
            }
            return ServerOptions.clientOptionsList.get("changepwd");
        }
        if (string2.equals("dragons")) {
            return "Sorry, you don't have the required materials.";
        }
        if (string2.equals("dance")) {
            return "Stop kidding me...";
        }
        if (string2.equals("safehouse")) {
            if (n != 2 || udpConnection == null) {
                return ServerOptions.clientOptionsList.get("safehouse");
            }
            if (!ServerOptions.instance.PlayerSafehouse.getValue() && !ServerOptions.instance.AdminSafehouse.getValue()) {
                return "Safehouses are disabled on this server.";
            }
            if ("release".equals(stringArray[1])) {
                SafeHouse safeHouse = SafeHouse.hasSafehouse(udpConnection.username);
                if (safeHouse == null) {
                    return "You don't own a safehouse.";
                }
                if (!(ServerOptions.instance.PlayerSafehouse.getValue() || "admin".equals(udpConnection.accessLevel) || "moderator".equals(udpConnection.accessLevel))) {
                    return "Only admin or moderator may release safehouses";
                }
                safeHouse.removeSafeHouse(null);
                return "Safehouse released";
            }
            return ServerOptions.clientOptionsList.get("safehouse");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doZomboidDataInMainLoop(ZomboidNetData zomboidNetData) {
        ConcurrentLinkedQueue<IZomboidPacket> concurrentLinkedQueue = MainLoopNetDataHighPriorityQ;
        synchronized (concurrentLinkedQueue) {
            MainLoopNetDataHighPriorityQ.add(zomboidNetData);
        }
    }

    static void receiveEquip(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        InventoryItem inventoryItem = null;
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (by3 == 1) {
            try {
                inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (inventoryItem == null) {
                LoggerManager.getLogger("user").write(udpConnection.idStr + " equipped unknown item type");
                return;
            }
        }
        if (isoPlayer != null) {
            if (inventoryItem != null) {
                inventoryItem.setContainer(isoPlayer.getInventory());
            }
            if (by2 == 0) {
                isoPlayer.setPrimaryHandItem(inventoryItem);
            } else {
                if (by3 == 2) {
                    inventoryItem = isoPlayer.getPrimaryHandItem();
                }
                isoPlayer.setSecondaryHandItem(inventoryItem);
            }
            try {
                if (by3 == 1 && inventoryItem != null && byteBuffer.get() == 1) {
                    inventoryItem.getVisual().load(byteBuffer, 195);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer2;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer2 = GameServer.getAnyPlayerFromConnection(udpConnection2)) == null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.Equip.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoPlayer.OnlineID);
            byteBufferWriter.putByte(by2);
            byteBufferWriter.putByte(by3);
            if (by3 == 1) {
                try {
                    inventoryItem.saveWithSize(byteBufferWriter.bb, false);
                    if (inventoryItem.getVisual() != null) {
                        byteBufferWriter.bb.put((byte)1);
                        inventoryItem.getVisual().save(byteBufferWriter.bb);
                    } else {
                        byteBufferWriter.bb.put((byte)0);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            PacketTypes.PacketType.Equip.send(udpConnection2);
        }
    }

    static void receivePlayerConnect(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        GameServer.receivePlayerConnect(byteBuffer, udpConnection, udpConnection.username);
        GameServer.sendInitialWorldState(udpConnection);
    }

    static void receiveScoreboardUpdate(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ScoreboardUpdate.doPacket(byteBufferWriter);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(n);
            if (!udpConnection2.isFullyConnected()) continue;
            for (int i = 0; i < 4; ++i) {
                if (udpConnection2.usernames[i] == null) continue;
                arrayList.add(udpConnection2.usernames[i]);
                IsoPlayer isoPlayer = GameServer.getPlayerByRealUserName(udpConnection2.usernames[i]);
                if (isoPlayer != null) {
                    arrayList2.add(isoPlayer.getDisplayName());
                } else {
                    String string = ServerWorldDatabase.instance.getDisplayName(udpConnection2.usernames[i]);
                    arrayList2.add(string == null ? udpConnection2.usernames[i] : string);
                }
                if (!SteamUtils.isSteamModeEnabled()) continue;
                arrayList3.add(udpConnection2.steamID);
            }
        }
        byteBufferWriter.putInt(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            byteBufferWriter.putUTF((String)arrayList.get(n));
            byteBufferWriter.putUTF((String)arrayList2.get(n));
            if (!SteamUtils.isSteamModeEnabled()) continue;
            byteBufferWriter.putLong((Long)arrayList3.get(n));
        }
        PacketTypes.PacketType.ScoreboardUpdate.send(udpConnection);
    }

    static void receiveStopSound(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        StopSoundPacket stopSoundPacket = new StopSoundPacket();
        stopSoundPacket.parse(byteBuffer, udpConnection);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !udpConnection2.isFullyConnected()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.StopSound.doPacket(byteBufferWriter);
            stopSoundPacket.write(byteBufferWriter);
            PacketTypes.PacketType.StopSound.send(udpConnection2);
        }
    }

    static void receivePlaySound(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        Object object;
        int n;
        PlaySoundPacket playSoundPacket = new PlaySoundPacket();
        playSoundPacket.parse(byteBuffer, udpConnection);
        IsoMovingObject isoMovingObject = playSoundPacket.getMovingObject();
        if (!playSoundPacket.isConsistent()) {
            return;
        }
        int n2 = 70;
        GameSound gameSound = GameSounds.getSound(playSoundPacket.getName());
        if (gameSound != null) {
            for (n = 0; n < gameSound.clips.size(); ++n) {
                object = gameSound.clips.get(n);
                if (!((GameSoundClip)object).hasMaxDistance()) continue;
                n2 = Math.max(n2, (int)((GameSoundClip)object).distanceMax);
            }
        }
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            IsoPlayer isoPlayer;
            object = GameServer.udpEngine.connections.get(n);
            if (((UdpConnection)object).getConnectedGUID() == udpConnection.getConnectedGUID() || !((UdpConnection)object).isFullyConnected() || (isoPlayer = GameServer.getAnyPlayerFromConnection((UdpConnection)object)) == null || isoMovingObject != null && !((UdpConnection)object).RelevantTo(isoMovingObject.getX(), isoMovingObject.getY(), n2)) continue;
            ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
            PacketTypes.PacketType.PlaySound.doPacket(byteBufferWriter);
            playSoundPacket.write(byteBufferWriter);
            PacketTypes.PacketType.PlaySound.send((UdpConnection)object);
        }
    }

    static void receivePlayWorldSound(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        Object object;
        int n;
        PlayWorldSoundPacket playWorldSoundPacket = new PlayWorldSoundPacket();
        playWorldSoundPacket.parse(byteBuffer, udpConnection);
        if (!playWorldSoundPacket.isConsistent()) {
            return;
        }
        int n2 = 70;
        GameSound gameSound = GameSounds.getSound(playWorldSoundPacket.getName());
        if (gameSound != null) {
            for (n = 0; n < gameSound.clips.size(); ++n) {
                object = gameSound.clips.get(n);
                if (!((GameSoundClip)object).hasMaxDistance()) continue;
                n2 = Math.max(n2, (int)((GameSoundClip)object).distanceMax);
            }
        }
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            IsoPlayer isoPlayer;
            object = GameServer.udpEngine.connections.get(n);
            if (((UdpConnection)object).getConnectedGUID() == udpConnection.getConnectedGUID() || !((UdpConnection)object).isFullyConnected() || (isoPlayer = GameServer.getAnyPlayerFromConnection((UdpConnection)object)) == null || !((UdpConnection)object).RelevantTo(playWorldSoundPacket.getX(), playWorldSoundPacket.getY(), n2)) continue;
            ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
            PacketTypes.PacketType.PlayWorldSound.doPacket(byteBufferWriter);
            playWorldSoundPacket.write(byteBufferWriter);
            PacketTypes.PacketType.PlayWorldSound.send((UdpConnection)object);
        }
    }

    private static void PlayWorldSound(String string, IsoGridSquare isoGridSquare, float f) {
        if (!bServer || isoGridSquare == null) {
            return;
        }
        int n = isoGridSquare.getX();
        int n2 = isoGridSquare.getY();
        int n3 = isoGridSquare.getZ();
        PlayWorldSoundPacket playWorldSoundPacket = new PlayWorldSoundPacket();
        playWorldSoundPacket.set(string, n, n2, (byte)n3);
        DebugLog.log(DebugType.Sound, "sending " + playWorldSoundPacket.getDescription() + " radius=" + f);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            IsoPlayer isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection);
            if (isoPlayer == null || !udpConnection.RelevantTo(n, n2, f * 2.0f)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.PlayWorldSound.doPacket(byteBufferWriter);
            playWorldSoundPacket.write(byteBufferWriter);
            PacketTypes.PacketType.PlayWorldSound.send(udpConnection);
        }
    }

    public static void PlayWorldSoundServer(String string, boolean bl, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl2) {
        GameServer.PlayWorldSound(string, isoGridSquare, f2);
    }

    public static void PlayWorldSoundServer(IsoGameCharacter isoGameCharacter, String string, boolean bl, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl2) {
        if (isoGameCharacter != null && isoGameCharacter.isInvisible() && !DebugOptions.instance.Character.Debug.PlaySoundWhenInvisible.getValue()) {
            return;
        }
        GameServer.PlayWorldSound(string, isoGridSquare, f2);
    }

    public static void PlayWorldSoundWavServer(String string, boolean bl, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl2) {
        GameServer.PlayWorldSound(string, isoGridSquare, f2);
    }

    public static void PlaySoundAtEveryPlayer(String string, int n, int n2, int n3) {
        GameServer.PlaySoundAtEveryPlayer(string, n, n2, n3, false);
    }

    public static void PlaySoundAtEveryPlayer(String string) {
        GameServer.PlaySoundAtEveryPlayer(string, -1, -1, -1, true);
    }

    public static void PlaySoundAtEveryPlayer(String string, int n, int n2, int n3, boolean bl) {
        if (!bServer) {
            return;
        }
        if (bl) {
            DebugLog.log(DebugType.Sound, "sound: sending " + string + " at every player (using player location)");
        } else {
            DebugLog.log(DebugType.Sound, "sound: sending " + string + " at every player location x=" + n + " y=" + n2);
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            IsoPlayer isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection);
            if (isoPlayer == null || isoPlayer.isDeaf()) continue;
            if (bl) {
                n = (int)isoPlayer.getX();
                n2 = (int)isoPlayer.getY();
                n3 = (int)isoPlayer.getZ();
            }
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.PlaySoundEveryPlayer.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            PacketTypes.PacketType.PlaySoundEveryPlayer.send(udpConnection);
        }
    }

    public static void sendZombieSound(IsoZombie.ZombieSound zombieSound, IsoZombie isoZombie) {
        float f = zombieSound.radius();
        DebugLog.log(DebugType.Sound, "sound: sending zombie sound " + zombieSound);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.isFullyConnected() || !udpConnection.RelevantTo(isoZombie.getX(), isoZombie.getY(), f)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.ZombieSound.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoZombie.OnlineID);
            byteBufferWriter.putByte((byte)zombieSound.ordinal());
            PacketTypes.PacketType.ZombieSound.send(udpConnection);
        }
    }

    static void receiveZombieHelmetFalling(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        short s2 = byteBuffer.getShort();
        String string = GameWindow.ReadString(byteBuffer);
        IsoZombie isoZombie = ServerMap.instance.ZombieMap.get(s2);
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (isoPlayer == null || isoZombie == null) {
            return;
        }
        isoZombie.serverRemoveItemFromZombie(string);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer2;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer2 = GameServer.getAnyPlayerFromConnection(udpConnection)) == null) continue;
            try {
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.ZombieHelmetFalling.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putUTF(string);
                PacketTypes.PacketType.ZombieHelmetFalling.send(udpConnection2);
                continue;
            }
            catch (Throwable throwable) {
                udpConnection.cancelPacket();
                ExceptionLogger.logException(throwable);
            }
        }
    }

    static void receivePlayerAttachedItem(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        Object object;
        byte by = byteBuffer.get();
        String string = GameWindow.ReadString(byteBuffer);
        boolean bl = byteBuffer.get() == 1;
        InventoryItem inventoryItem = null;
        if (bl && (inventoryItem = InventoryItemFactory.CreateItem((String)(object = GameWindow.ReadString(byteBuffer)))) == null) {
            return;
        }
        object = GameServer.getPlayerFromConnection(udpConnection, by);
        if (object == null) {
            return;
        }
        ((IsoGameCharacter)object).setAttachedItem(string, inventoryItem);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection)) == null) continue;
            try {
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.PlayerAttachedItem.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(((IsoPlayer)object).OnlineID);
                GameWindow.WriteString(byteBufferWriter.bb, string);
                byteBufferWriter.putByte(bl ? (byte)1 : 0);
                if (bl) {
                    GameWindow.WriteString(byteBufferWriter.bb, inventoryItem.getFullType());
                }
                PacketTypes.PacketType.PlayerAttachedItem.send(udpConnection2);
                continue;
            }
            catch (Throwable throwable) {
                udpConnection.cancelPacket();
                ExceptionLogger.logException(throwable);
            }
        }
    }

    static void receiveSyncClothing(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        SyncClothingPacket syncClothingPacket = new SyncClothingPacket();
        syncClothingPacket.parse(byteBuffer, udpConnection);
        if (!syncClothingPacket.isConsistent()) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection)) == null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SyncClothing.doPacket(byteBufferWriter);
            syncClothingPacket.write(byteBufferWriter);
            PacketTypes.PacketType.SyncClothing.send(udpConnection2);
        }
    }

    static void receiveHumanVisual(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer == null) {
            return;
        }
        if (!udpConnection.havePlayer(isoPlayer)) {
            DebugLog.Network.warn("User " + udpConnection.username + " sent HumanVisual packet for non owned player #" + isoPlayer.OnlineID);
            return;
        }
        try {
            isoPlayer.getHumanVisual().load(byteBuffer, 195);
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer2;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer2 = GameServer.getAnyPlayerFromConnection(udpConnection2)) == null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.HumanVisual.doPacket(byteBufferWriter);
            try {
                byteBufferWriter.putShort(isoPlayer.OnlineID);
                isoPlayer.getHumanVisual().save(byteBufferWriter.bb);
                PacketTypes.PacketType.HumanVisual.send(udpConnection2);
                continue;
            }
            catch (Throwable throwable) {
                udpConnection2.cancelPacket();
                ExceptionLogger.logException(throwable);
            }
        }
    }

    public static void initClientCommandFilter() {
        String[] stringArray;
        String string = ServerOptions.getInstance().ClientCommandFilter.getValue();
        ccFilters.clear();
        for (String string2 : stringArray = string.split(";")) {
            String[] stringArray2;
            if (string2.isEmpty() || !string2.contains(".") || !string2.startsWith("+") && !string2.startsWith("-") || (stringArray2 = string2.split("\\.")).length != 2) continue;
            String string3 = stringArray2[0].substring(1);
            String string4 = stringArray2[1];
            CCFilter cCFilter = new CCFilter();
            cCFilter.command = string4;
            cCFilter.allow = stringArray2[0].startsWith("+");
            cCFilter.next = ccFilters.get(string3);
            ccFilters.put(string3, cCFilter);
        }
    }

    static void receiveClientCommand(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        boolean bl = byteBuffer.get() == 1;
        KahluaTable kahluaTable = null;
        if (bl) {
            kahluaTable = LuaManager.platform.newTable();
            try {
                TableNetworkUtils.load(kahluaTable, byteBuffer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (by == -1) {
            isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection);
        }
        if (isoPlayer == null) {
            DebugLog.log("receiveClientCommand: player is null");
            return;
        }
        CCFilter cCFilter = ccFilters.get(string);
        if (cCFilter == null || cCFilter.passes(string2)) {
            LoggerManager.getLogger("cmd").write(udpConnection.idStr + " \"" + isoPlayer.username + "\" " + string + "." + string2 + " @ " + (int)isoPlayer.getX() + "," + (int)isoPlayer.getY() + "," + (int)isoPlayer.getZ());
        }
        if ("vehicle".equals(string) && "remove".equals(string2) && !Core.bDebug && !PlayerType.isPrivileged(udpConnection.accessLevel) && !isoPlayer.networkAI.isDismantleAllowed()) {
            return;
        }
        LuaEventManager.triggerEvent("OnClientCommand", string, string2, isoPlayer, kahluaTable);
    }

    static void receiveGlobalObjects(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (by == -1) {
            isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection);
        }
        if (isoPlayer == null) {
            DebugLog.log("receiveGlobalObjects: player is null");
            return;
        }
        SGlobalObjectNetwork.receive(byteBuffer, isoPlayer);
    }

    public static IsoPlayer getAnyPlayerFromConnection(UdpConnection udpConnection) {
        for (int i = 0; i < 4; ++i) {
            if (udpConnection.players[i] == null) continue;
            return udpConnection.players[i];
        }
        return null;
    }

    public static IsoPlayer getPlayerFromConnection(UdpConnection udpConnection, int n) {
        if (n >= 0 && n < 4) {
            return udpConnection.players[n];
        }
        return null;
    }

    public static IsoPlayer getPlayerByRealUserName(String string) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < 4; ++j) {
                IsoPlayer isoPlayer = udpConnection.players[j];
                if (isoPlayer == null || !isoPlayer.username.equals(string)) continue;
                return isoPlayer;
            }
        }
        return null;
    }

    public static IsoPlayer getPlayerByUserName(String string) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < 4; ++j) {
                IsoPlayer isoPlayer = udpConnection.players[j];
                if (isoPlayer == null || !isoPlayer.getDisplayName().equals(string) && !isoPlayer.getUsername().equals(string)) continue;
                return isoPlayer;
            }
        }
        return null;
    }

    public static IsoPlayer getPlayerByUserNameForCommand(String string) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < 4; ++j) {
                IsoPlayer isoPlayer = udpConnection.players[j];
                if (isoPlayer == null || !isoPlayer.getDisplayName().toLowerCase().equals(string.toLowerCase()) && !isoPlayer.getDisplayName().toLowerCase().startsWith(string.toLowerCase())) continue;
                return isoPlayer;
            }
        }
        return null;
    }

    public static UdpConnection getConnectionByPlayerOnlineID(short s) {
        return udpEngine.getActiveConnection(IDToAddressMap.get(s));
    }

    public static UdpConnection getConnectionFromPlayer(IsoPlayer isoPlayer) {
        Long l = PlayerToAddressMap.get(isoPlayer);
        if (l == null) {
            return null;
        }
        return udpEngine.getActiveConnection(l);
    }

    static void receiveRemoveBlood(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        boolean bl = byteBuffer.get() == 1;
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return;
        }
        isoGridSquare.removeBlood(false, bl);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2 == udpConnection || !udpConnection2.RelevantTo(n, n2)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.RemoveBlood.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putBoolean(bl);
            PacketTypes.PacketType.RemoveBlood.send(udpConnection2);
        }
    }

    public static void sendAddItemToContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        IsoObject isoObject = itemContainer.getParent();
        if (itemContainer.getContainingItem() != null && itemContainer.getContainingItem().getWorldItem() != null) {
            isoObject = itemContainer.getContainingItem().getWorldItem();
        }
        if (isoObject == null) {
            DebugLog.General.error("container has no parent object");
            return;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (isoGridSquare == null) {
            DebugLog.General.error("container parent object has no square");
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(isoGridSquare.x, isoGridSquare.y)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.AddInventoryItemToContainer.doPacket(byteBufferWriter);
            if (isoObject instanceof IsoDeadBody) {
                byteBufferWriter.putShort((short)0);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putByte((byte)isoObject.getStaticMovingObjectIndex());
            } else if (isoObject instanceof IsoWorldInventoryObject) {
                byteBufferWriter.putShort((short)1);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putInt(((IsoWorldInventoryObject)isoObject).getItem().id);
            } else if (isoObject instanceof BaseVehicle) {
                byteBufferWriter.putShort((short)3);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putShort(((BaseVehicle)isoObject).VehicleID);
                byteBufferWriter.putByte((byte)itemContainer.vehiclePart.getIndex());
            } else {
                byteBufferWriter.putShort((short)2);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putByte((byte)isoObject.square.getObjects().indexOf(isoObject));
                byteBufferWriter.putByte((byte)isoObject.getContainerIndex(itemContainer));
            }
            try {
                CompressIdenticalItems.save(byteBufferWriter.bb, inventoryItem);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            PacketTypes.PacketType.AddInventoryItemToContainer.send(udpConnection);
        }
    }

    public static void sendRemoveItemFromContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        IsoObject isoObject = itemContainer.getParent();
        if (itemContainer.getContainingItem() != null && itemContainer.getContainingItem().getWorldItem() != null) {
            isoObject = itemContainer.getContainingItem().getWorldItem();
        }
        if (isoObject == null) {
            DebugLog.log("sendRemoveItemFromContainer: o is null");
            return;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (isoGridSquare == null) {
            DebugLog.log("sendRemoveItemFromContainer: square is null");
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(isoGridSquare.x, isoGridSquare.y)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.RemoveInventoryItemFromContainer.doPacket(byteBufferWriter);
            if (isoObject instanceof IsoDeadBody) {
                byteBufferWriter.putShort((short)0);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putByte((byte)isoObject.getStaticMovingObjectIndex());
                byteBufferWriter.putInt(1);
                byteBufferWriter.putInt(inventoryItem.id);
            } else if (isoObject instanceof IsoWorldInventoryObject) {
                byteBufferWriter.putShort((short)1);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putInt(((IsoWorldInventoryObject)isoObject).getItem().id);
                byteBufferWriter.putInt(1);
                byteBufferWriter.putInt(inventoryItem.id);
            } else if (isoObject instanceof BaseVehicle) {
                byteBufferWriter.putShort((short)3);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putShort(((BaseVehicle)isoObject).VehicleID);
                byteBufferWriter.putByte((byte)itemContainer.vehiclePart.getIndex());
                byteBufferWriter.putInt(1);
                byteBufferWriter.putInt(inventoryItem.id);
            } else {
                byteBufferWriter.putShort((short)2);
                byteBufferWriter.putInt(isoObject.square.getX());
                byteBufferWriter.putInt(isoObject.square.getY());
                byteBufferWriter.putInt(isoObject.square.getZ());
                byteBufferWriter.putByte((byte)isoObject.square.getObjects().indexOf(isoObject));
                byteBufferWriter.putByte((byte)isoObject.getContainerIndex(itemContainer));
                byteBufferWriter.putInt(1);
                byteBufferWriter.putInt(inventoryItem.id);
            }
            PacketTypes.PacketType.RemoveInventoryItemFromContainer.send(udpConnection);
        }
    }

    static void receiveRemoveInventoryItemFromContainer(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        HashSet<String> hashSet;
        IsoGridSquare isoGridSquare;
        int n3;
        int n4;
        int n5;
        block18: {
            int n6;
            boolean bl;
            short s2;
            ByteBufferReader byteBufferReader;
            block20: {
                ItemContainer itemContainer;
                block19: {
                    int n7;
                    block17: {
                        IsoObject isoObject;
                        alreadyRemoved.clear();
                        byteBufferReader = new ByteBufferReader(byteBuffer);
                        s2 = byteBufferReader.getShort();
                        n5 = byteBufferReader.getInt();
                        n4 = byteBufferReader.getInt();
                        n3 = byteBufferReader.getInt();
                        isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n5, n4, n3);
                        if (isoGridSquare == null) {
                            isoGridSquare = ServerMap.instance.getGridSquare(n5, n4, n3);
                        }
                        hashSet = new HashSet<String>();
                        bl = false;
                        n2 = 0;
                        if (s2 != 0) break block17;
                        n = byteBufferReader.getByte();
                        n2 = byteBuffer.getInt();
                        if (isoGridSquare != null && n >= 0 && n < isoGridSquare.getStaticMovingObjects().size() && (isoObject = (IsoObject)isoGridSquare.getStaticMovingObjects().get(n)) != null && isoObject.getContainer() != null) {
                            for (int i = 0; i < n2; ++i) {
                                int n8 = byteBufferReader.getInt();
                                InventoryItem inventoryItem = isoObject.getContainer().getItemWithID(n8);
                                if (inventoryItem == null) {
                                    alreadyRemoved.add(n8);
                                    continue;
                                }
                                isoObject.getContainer().Remove(inventoryItem);
                                bl = true;
                                hashSet.add(inventoryItem.getFullType());
                            }
                            isoObject.getContainer().setExplored(true);
                            isoObject.getContainer().setHasBeenLooted(true);
                        }
                        break block18;
                    }
                    if (s2 != 1) break block19;
                    if (isoGridSquare == null) break block18;
                    n = byteBufferReader.getInt();
                    n2 = byteBuffer.getInt();
                    ItemContainer itemContainer2 = null;
                    for (n7 = 0; n7 < isoGridSquare.getWorldObjects().size(); ++n7) {
                        IsoWorldInventoryObject isoWorldInventoryObject = isoGridSquare.getWorldObjects().get(n7);
                        if (isoWorldInventoryObject == null || !(isoWorldInventoryObject.getItem() instanceof InventoryContainer) || isoWorldInventoryObject.getItem().id != n) continue;
                        itemContainer2 = ((InventoryContainer)isoWorldInventoryObject.getItem()).getInventory();
                        break;
                    }
                    if (itemContainer2 == null) break block18;
                    for (n7 = 0; n7 < n2; ++n7) {
                        int n9 = byteBufferReader.getInt();
                        InventoryItem inventoryItem = itemContainer2.getItemWithID(n9);
                        if (inventoryItem == null) {
                            alreadyRemoved.add(n9);
                            continue;
                        }
                        itemContainer2.Remove(inventoryItem);
                        hashSet.add(inventoryItem.getFullType());
                    }
                    itemContainer2.setExplored(true);
                    itemContainer2.setHasBeenLooted(true);
                    break block18;
                }
                if (s2 != 2) break block20;
                n = byteBufferReader.getByte();
                byte by = byteBufferReader.getByte();
                n2 = byteBuffer.getInt();
                if (isoGridSquare == null || n < 0 || n >= isoGridSquare.getObjects().size()) break block18;
                IsoObject isoObject = isoGridSquare.getObjects().get(n);
                ItemContainer itemContainer3 = itemContainer = isoObject != null ? isoObject.getContainerByIndex(by) : null;
                if (itemContainer == null) break block18;
                for (int i = 0; i < n2; ++i) {
                    n6 = byteBufferReader.getInt();
                    InventoryItem inventoryItem = itemContainer.getItemWithID(n6);
                    if (inventoryItem == null) {
                        alreadyRemoved.add(n6);
                        continue;
                    }
                    itemContainer.Remove(inventoryItem);
                    itemContainer.setExplored(true);
                    itemContainer.setHasBeenLooted(true);
                    bl = true;
                    hashSet.add(inventoryItem.getFullType());
                }
                LuaManager.updateOverlaySprite(isoObject);
                break block18;
            }
            if (s2 == 3) {
                n = byteBufferReader.getShort();
                byte by = byteBufferReader.getByte();
                n2 = byteBuffer.getInt();
                BaseVehicle baseVehicle = VehicleManager.instance.getVehicleByID((short)n);
                if (baseVehicle != null) {
                    ItemContainer itemContainer;
                    VehiclePart vehiclePart = baseVehicle == null ? null : baseVehicle.getPartByIndex(by);
                    ItemContainer itemContainer4 = itemContainer = vehiclePart == null ? null : vehiclePart.getItemContainer();
                    if (itemContainer != null) {
                        for (n6 = 0; n6 < n2; ++n6) {
                            int n10 = byteBufferReader.getInt();
                            InventoryItem inventoryItem = itemContainer.getItemWithID(n10);
                            if (inventoryItem == null) {
                                alreadyRemoved.add(n10);
                                continue;
                            }
                            itemContainer.Remove(inventoryItem);
                            itemContainer.setExplored(true);
                            itemContainer.setHasBeenLooted(true);
                            bl = true;
                            hashSet.add(inventoryItem.getFullType());
                        }
                    }
                }
            }
        }
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(n);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || isoGridSquare == null || !udpConnection2.RelevantTo(isoGridSquare.x, isoGridSquare.y)) continue;
            byteBuffer.rewind();
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.RemoveInventoryItemFromContainer.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put(byteBuffer);
            PacketTypes.PacketType.RemoveInventoryItemFromContainer.send(udpConnection2);
        }
        if (!alreadyRemoved.isEmpty()) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.RemoveContestedItemsFromInventory.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(alreadyRemoved.size());
            for (int i = 0; i < alreadyRemoved.size(); ++i) {
                byteBufferWriter.putInt(alreadyRemoved.get(i));
            }
            PacketTypes.PacketType.RemoveContestedItemsFromInventory.send(udpConnection);
        }
        alreadyRemoved.clear();
        LoggerManager.getLogger("item").write(udpConnection.idStr + " \"" + udpConnection.username + "\" container -" + n2 + " " + n5 + "," + n4 + "," + n3 + " " + hashSet.toString());
    }

    private static void readItemStats(ByteBuffer byteBuffer, InventoryItem inventoryItem) {
        int n = byteBuffer.getInt();
        float f = byteBuffer.getFloat();
        boolean bl = byteBuffer.get() == 1;
        inventoryItem.setUses(n);
        if (inventoryItem instanceof DrainableComboItem) {
            ((DrainableComboItem)inventoryItem).setDelta(f);
            ((DrainableComboItem)inventoryItem).updateWeight();
        }
        if (bl && inventoryItem instanceof Food) {
            Food food = (Food)inventoryItem;
            food.setHungChange(byteBuffer.getFloat());
            food.setCalories(byteBuffer.getFloat());
            food.setCarbohydrates(byteBuffer.getFloat());
            food.setLipids(byteBuffer.getFloat());
            food.setProteins(byteBuffer.getFloat());
            food.setThirstChange(byteBuffer.getFloat());
            food.setFluReduction(byteBuffer.getInt());
            food.setPainReduction(byteBuffer.getFloat());
            food.setEndChange(byteBuffer.getFloat());
            food.setReduceFoodSickness(byteBuffer.getInt());
            food.setStressChange(byteBuffer.getFloat());
            food.setFatigueChange(byteBuffer.getFloat());
        }
    }

    static void receiveItemStats(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        short s2 = byteBuffer.getShort();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n2, n3, n4);
        block0 : switch (s2) {
            case 0: {
                Object object3;
                IsoMovingObject isoMovingObject;
                Object object2;
                n = byteBuffer.get();
                int n5 = byteBuffer.getInt();
                if (isoGridSquare == null || n < 0 || n >= isoGridSquare.getStaticMovingObjects().size() || (object2 = (isoMovingObject = isoGridSquare.getStaticMovingObjects().get(n)).getContainer()) == null || (object3 = ((ItemContainer)object2).getItemWithID(n5)) == null) break;
                GameServer.readItemStats(byteBuffer, (InventoryItem)object3);
                break;
            }
            case 2: {
                Object object;
                Object object3;
                Object object2;
                n = byteBuffer.get();
                int n5 = byteBuffer.get();
                int n6 = byteBuffer.getInt();
                if (isoGridSquare == null || n < 0 || n >= isoGridSquare.getObjects().size() || (object3 = ((IsoObject)(object2 = isoGridSquare.getObjects().get(n))).getContainerByIndex(n5)) == null || (object = ((ItemContainer)object3).getItemWithID(n6)) == null) break;
                GameServer.readItemStats(byteBuffer, (InventoryItem)object);
                break;
            }
            case 1: {
                Object object3;
                Object object2;
                int n5;
                n = byteBuffer.getInt();
                if (isoGridSquare == null) break;
                for (n5 = 0; n5 < isoGridSquare.getWorldObjects().size(); ++n5) {
                    IsoWorldInventoryObject isoWorldInventoryObject = isoGridSquare.getWorldObjects().get(n5);
                    if (isoWorldInventoryObject.getItem() != null && isoWorldInventoryObject.getItem().id == n) {
                        GameServer.readItemStats(byteBuffer, isoWorldInventoryObject.getItem());
                        break block0;
                    }
                    if (!(isoWorldInventoryObject.getItem() instanceof InventoryContainer) || (object3 = ((ItemContainer)(object2 = ((InventoryContainer)isoWorldInventoryObject.getItem()).getInventory())).getItemWithID(n)) == null) continue;
                    GameServer.readItemStats(byteBuffer, (InventoryItem)object3);
                    break block0;
                }
                break;
            }
            case 3: {
                InventoryItem inventoryItem;
                Object object;
                Object object3;
                n = byteBuffer.getShort();
                int n5 = byteBuffer.get();
                int n7 = byteBuffer.getInt();
                Object object2 = VehicleManager.instance.getVehicleByID((short)n);
                if (object2 == null || (object3 = ((BaseVehicle)object2).getPartByIndex(n5)) == null || (object = ((VehiclePart)object3).getItemContainer()) == null || (inventoryItem = ((ItemContainer)object).getItemWithID(n7)) == null) break;
                GameServer.readItemStats(byteBuffer, inventoryItem);
                break;
            }
        }
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(n);
            if (udpConnection2 == udpConnection || !udpConnection2.RelevantTo(n2, n3)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.ItemStats.doPacket(byteBufferWriter);
            byteBuffer.rewind();
            byteBufferWriter.bb.put(byteBuffer);
            PacketTypes.PacketType.ItemStats.send(udpConnection2);
        }
    }

    static void receiveRequestItemsForContainer(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ByteBufferReader byteBufferReader = new ByteBufferReader(byteBuffer);
        short s2 = byteBuffer.getShort();
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        int n = byteBufferReader.getInt();
        int n2 = byteBufferReader.getInt();
        int n3 = byteBufferReader.getInt();
        short s3 = byteBufferReader.getShort();
        byte by = -1;
        byte by2 = -1;
        int n4 = 0;
        short s4 = 0;
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        IsoObject isoObject = null;
        ItemContainer itemContainer = null;
        if (s3 == 2) {
            by = byteBufferReader.getByte();
            by2 = byteBufferReader.getByte();
            if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getObjects().size() && (isoObject = isoGridSquare.getObjects().get(by)) != null && ((itemContainer = isoObject.getContainerByIndex(by2)) == null || itemContainer.isExplored())) {
                return;
            }
        } else if (s3 == 3) {
            s4 = byteBufferReader.getShort();
            by2 = byteBufferReader.getByte();
            isoObject = VehicleManager.instance.getVehicleByID(s4);
            if (isoObject != null) {
                VehiclePart vehiclePart = ((BaseVehicle)isoObject).getPartByIndex(by2);
                ItemContainer itemContainer2 = itemContainer = vehiclePart == null ? null : vehiclePart.getItemContainer();
                if (itemContainer == null || itemContainer.isExplored()) {
                    return;
                }
            }
        } else if (s3 == 1) {
            n4 = byteBufferReader.getInt();
            for (int i = 0; i < isoGridSquare.getWorldObjects().size(); ++i) {
                IsoWorldInventoryObject isoWorldInventoryObject = isoGridSquare.getWorldObjects().get(i);
                if (isoWorldInventoryObject == null || !(isoWorldInventoryObject.getItem() instanceof InventoryContainer) || isoWorldInventoryObject.getItem().id != n4) continue;
                itemContainer = ((InventoryContainer)isoWorldInventoryObject.getItem()).getInventory();
                break;
            }
        } else if (s3 == 0) {
            by = byteBufferReader.getByte();
            if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getStaticMovingObjects().size() && (isoObject = (IsoObject)isoGridSquare.getStaticMovingObjects().get(by)) != null && isoObject.getContainer() != null) {
                if (isoObject.getContainer().isExplored()) {
                    return;
                }
                itemContainer = isoObject.getContainer();
            }
        }
        if (itemContainer == null || itemContainer.isExplored()) {
            return;
        }
        itemContainer.setExplored(true);
        int n5 = itemContainer.Items.size();
        ItemPickerJava.fillContainer(itemContainer, IDToPlayerMap.get(s2));
        if (n5 == itemContainer.Items.size()) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (!udpConnection2.RelevantTo(isoGridSquare.x, isoGridSquare.y)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.AddInventoryItemToContainer.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(s3);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            if (s3 == 0) {
                byteBufferWriter.putByte(by);
            } else if (s3 == 1) {
                byteBufferWriter.putInt(n4);
            } else if (s3 == 3) {
                byteBufferWriter.putShort(s4);
                byteBufferWriter.putByte(by2);
            } else {
                byteBufferWriter.putByte(by);
                byteBufferWriter.putByte(by2);
            }
            try {
                CompressIdenticalItems.save(byteBufferWriter.bb, itemContainer.getItems(), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            PacketTypes.PacketType.AddInventoryItemToContainer.send(udpConnection2);
        }
    }

    public static void sendItemsInContainer(IsoObject isoObject, ItemContainer itemContainer) {
        Object object;
        if (udpEngine == null) {
            return;
        }
        if (itemContainer == null) {
            DebugLog.log("sendItemsInContainer: container is null");
            return;
        }
        if (isoObject instanceof IsoWorldInventoryObject) {
            IsoWorldInventoryObject isoWorldInventoryObject = (IsoWorldInventoryObject)isoObject;
            if (!(isoWorldInventoryObject.getItem() instanceof InventoryContainer)) {
                DebugLog.log("sendItemsInContainer: IsoWorldInventoryObject item isn't a container");
                return;
            }
            object = (InventoryContainer)isoWorldInventoryObject.getItem();
            if (((InventoryContainer)object).getInventory() != itemContainer) {
                DebugLog.log("sendItemsInContainer: wrong container for IsoWorldInventoryObject");
                return;
            }
        } else if (isoObject instanceof BaseVehicle) {
            if (itemContainer.vehiclePart == null || itemContainer.vehiclePart.getItemContainer() != itemContainer || itemContainer.vehiclePart.getVehicle() != isoObject) {
                DebugLog.log("sendItemsInContainer: wrong container for BaseVehicle");
                return;
            }
        } else if (isoObject instanceof IsoDeadBody) {
            if (itemContainer != isoObject.getContainer()) {
                DebugLog.log("sendItemsInContainer: wrong container for IsoDeadBody");
                return;
            }
        } else if (isoObject.getContainerIndex(itemContainer) == -1) {
            DebugLog.log("sendItemsInContainer: wrong container for IsoObject");
            return;
        }
        if (isoObject == null || itemContainer == null || itemContainer.getItems().isEmpty()) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            object = GameServer.udpEngine.connections.get(i);
            if (!((UdpConnection)object).RelevantTo(isoObject.square.x, isoObject.square.y)) continue;
            ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
            PacketTypes.PacketType.AddInventoryItemToContainer.doPacket(byteBufferWriter);
            if (isoObject instanceof IsoDeadBody) {
                byteBufferWriter.putShort((short)0);
            } else if (isoObject instanceof IsoWorldInventoryObject) {
                byteBufferWriter.putShort((short)1);
            } else if (isoObject instanceof BaseVehicle) {
                byteBufferWriter.putShort((short)3);
            } else {
                byteBufferWriter.putShort((short)2);
            }
            byteBufferWriter.putInt(isoObject.getSquare().getX());
            byteBufferWriter.putInt(isoObject.getSquare().getY());
            byteBufferWriter.putInt(isoObject.getSquare().getZ());
            if (isoObject instanceof IsoDeadBody) {
                byteBufferWriter.putByte((byte)isoObject.getStaticMovingObjectIndex());
            } else if (isoObject instanceof IsoWorldInventoryObject) {
                byteBufferWriter.putInt(((IsoWorldInventoryObject)isoObject).getItem().id);
            } else if (isoObject instanceof BaseVehicle) {
                byteBufferWriter.putShort(((BaseVehicle)isoObject).VehicleID);
                byteBufferWriter.putByte((byte)itemContainer.vehiclePart.getIndex());
            } else {
                byteBufferWriter.putByte((byte)isoObject.getObjectIndex());
                byteBufferWriter.putByte((byte)isoObject.getContainerIndex(itemContainer));
            }
            try {
                CompressIdenticalItems.save(byteBufferWriter.bb, itemContainer.getItems(), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            PacketTypes.PacketType.AddInventoryItemToContainer.send((UdpConnection)object);
        }
    }

    private static void logDupeItem(UdpConnection udpConnection, String string) {
        IsoPlayer isoPlayer = null;
        for (int i = 0; i < Players.size(); ++i) {
            if (!udpConnection.username.equals(GameServer.Players.get((int)i).username)) continue;
            isoPlayer = Players.get(i);
            break;
        }
        String string2 = "";
        if (isoPlayer != null) {
            string2 = LoggerManager.getPlayerCoords(isoPlayer);
            LoggerManager.getLogger("user").write("Error: Dupe item ID for " + isoPlayer.getDisplayName() + " " + string2);
        }
        ServerWorldDatabase.instance.addUserlog(udpConnection.username, Userlog.UserlogType.DupeItem, string, GameServer.class.getSimpleName(), 1);
    }

    static void receiveAddInventoryItemToContainer(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        Object object;
        ByteBufferReader byteBufferReader = new ByteBufferReader(byteBuffer);
        short s2 = byteBufferReader.getShort();
        int n = byteBufferReader.getInt();
        int n2 = byteBufferReader.getInt();
        int n3 = byteBufferReader.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        HashSet<String> hashSet = new HashSet<String>();
        int n4 = 0;
        if (isoGridSquare != null) {
            Object object2;
            ItemContainer itemContainer = null;
            object = null;
            if (s2 == 0) {
                byte by = byteBufferReader.getByte();
                if (by < 0 || by >= isoGridSquare.getStaticMovingObjects().size()) {
                    DebugLog.log("ERROR sendItemsToContainer invalid corpse index");
                    return;
                }
                IsoObject isoObject = isoGridSquare.getStaticMovingObjects().get(by);
                if (isoObject != null && isoObject.getContainer() != null) {
                    itemContainer = isoObject.getContainer();
                }
            } else if (s2 == 1) {
                int arrayList = byteBufferReader.getInt();
                for (int i = 0; i < isoGridSquare.getWorldObjects().size(); ++i) {
                    object2 = isoGridSquare.getWorldObjects().get(i);
                    if (object2 == null || !(((IsoWorldInventoryObject)object2).getItem() instanceof InventoryContainer) || ((IsoWorldInventoryObject)object2).getItem().id != arrayList) continue;
                    itemContainer = ((InventoryContainer)((IsoWorldInventoryObject)object2).getItem()).getInventory();
                    break;
                }
                if (itemContainer == null) {
                    DebugLog.log("ERROR sendItemsToContainer can't find world item with id=" + arrayList);
                    return;
                }
            } else if (s2 == 2) {
                byte byteBufferWriter;
                byte exception = byteBufferReader.getByte();
                byte by = byteBufferReader.getByte();
                if (exception < 0 || exception >= isoGridSquare.getObjects().size()) {
                    DebugLog.log("ERROR sendItemsToContainer invalid object index");
                    for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
                        if (isoGridSquare.getObjects().get(i).getContainer() == null) continue;
                        byteBufferWriter = (byte)i;
                        by = 0;
                        break;
                    }
                    if (byteBufferWriter == -1) {
                        return;
                    }
                }
                itemContainer = (object = isoGridSquare.getObjects().get(byteBufferWriter)) != null ? ((IsoObject)object).getContainerByIndex(by) : null;
            } else if (s2 == 3) {
                short s3 = byteBufferReader.getShort();
                byte by = byteBufferReader.getByte();
                BaseVehicle baseVehicle = VehicleManager.instance.getVehicleByID(s3);
                if (baseVehicle == null) {
                    DebugLog.log("ERROR sendItemsToContainer invalid vehicle id");
                    return;
                }
                VehiclePart vehiclePart = baseVehicle.getPartByIndex(by);
                ItemContainer itemContainer2 = itemContainer = vehiclePart == null ? null : vehiclePart.getItemContainer();
            }
            if (itemContainer != null) {
                try {
                    ArrayList<InventoryItem> arrayList = CompressIdenticalItems.load(byteBufferReader.bb, 195, null, null);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        object2 = arrayList.get(i);
                        if (object2 == null) continue;
                        if (itemContainer.containsID(((InventoryItem)object2).id)) {
                            System.out.println("Error: Dupe item ID for " + udpConnection.username);
                            GameServer.logDupeItem(udpConnection, ((InventoryItem)object2).getDisplayName());
                            continue;
                        }
                        itemContainer.addItem((InventoryItem)object2);
                        itemContainer.setExplored(true);
                        hashSet.add(((InventoryItem)object2).getFullType());
                        if (!(object instanceof IsoMannequin)) continue;
                        ((IsoMannequin)object).wearItem((InventoryItem)object2, null);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object != null) {
                    LuaManager.updateOverlaySprite((IsoObject)object);
                    if ("campfire".equals(itemContainer.getType())) {
                        ((IsoObject)object).sendObjectChange("container.customTemperature");
                    }
                }
            }
        } else {
            DebugLog.log("ERROR sendItemsToContainer square is null");
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            object = GameServer.udpEngine.connections.get(i);
            if (((UdpConnection)object).getConnectedGUID() == udpConnection.getConnectedGUID() || !((UdpConnection)object).RelevantTo(isoGridSquare.x, isoGridSquare.y)) continue;
            byteBuffer.rewind();
            ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
            PacketTypes.PacketType.AddInventoryItemToContainer.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put(byteBuffer);
            PacketTypes.PacketType.AddInventoryItemToContainer.send((UdpConnection)object);
        }
        LoggerManager.getLogger("item").write(udpConnection.idStr + " \"" + udpConnection.username + "\" container +" + n4 + " " + n + "," + n2 + "," + n3 + " " + hashSet.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(UdpConnection udpConnection) {
        ConcurrentLinkedQueue<IZomboidPacket> concurrentLinkedQueue = MainLoopNetDataHighPriorityQ;
        synchronized (concurrentLinkedQueue) {
            MainLoopNetDataHighPriorityQ.add(new DelayedConnection(udpConnection, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDisconnect(UdpConnection udpConnection) {
        ConcurrentLinkedQueue<IZomboidPacket> concurrentLinkedQueue = MainLoopNetDataHighPriorityQ;
        synchronized (concurrentLinkedQueue) {
            MainLoopNetDataHighPriorityQ.add(new DelayedConnection(udpConnection, false));
        }
    }

    public static void disconnectPlayer(IsoPlayer isoPlayer, UdpConnection udpConnection) {
        if (isoPlayer == null) {
            return;
        }
        SafetySystemManager.storeSafety(isoPlayer);
        ChatServer.getInstance().disconnectPlayer(isoPlayer.getOnlineID());
        if (isoPlayer.getVehicle() != null) {
            int n;
            VehiclesDB2.instance.updateVehicleAndTrailer(isoPlayer.getVehicle());
            if (isoPlayer.getVehicle().isDriver(isoPlayer) && isoPlayer.getVehicle().isNetPlayerId(isoPlayer.getOnlineID())) {
                isoPlayer.getVehicle().setNetPlayerAuthorization(BaseVehicle.Authorization.Server, -1);
                isoPlayer.getVehicle().getController().clientForce = 0.0f;
                isoPlayer.getVehicle().jniLinearVelocity.set(0.0f, 0.0f, 0.0f);
            }
            if ((n = isoPlayer.getVehicle().getSeat(isoPlayer)) != -1) {
                isoPlayer.getVehicle().clearPassenger(n);
            }
        }
        if (!isoPlayer.isDead()) {
            ServerWorldDatabase.instance.saveTransactionID(isoPlayer.username, isoPlayer.getTransactionID());
        }
        NetworkZombieManager.getInstance().clearTargetAuth(udpConnection, isoPlayer);
        isoPlayer.removeFromWorld();
        isoPlayer.removeFromSquare();
        PlayerToAddressMap.remove(isoPlayer);
        IDToAddressMap.remove(isoPlayer.OnlineID);
        IDToPlayerMap.remove(isoPlayer.OnlineID);
        Players.remove(isoPlayer);
        SafeHouse.updateSafehousePlayersConnected();
        SafeHouse safeHouse = SafeHouse.hasSafehouse(isoPlayer);
        if (safeHouse != null && safeHouse.isOwner(isoPlayer)) {
            for (IsoPlayer object : IDToPlayerMap.values()) {
                safeHouse.checkTrespass(object);
            }
        }
        udpConnection.usernames[isoPlayer.PlayerIndex] = null;
        udpConnection.players[isoPlayer.PlayerIndex] = null;
        udpConnection.playerIDs[isoPlayer.PlayerIndex] = -1;
        udpConnection.ReleventPos[isoPlayer.PlayerIndex] = null;
        udpConnection.connectArea[isoPlayer.PlayerIndex] = null;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.PlayerTimeout.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoPlayer.OnlineID);
            PacketTypes.PacketType.PlayerTimeout.send(udpConnection2);
        }
        ServerLOS.instance.removePlayer(isoPlayer);
        ZombiePopulationManager.instance.updateLoadedAreas();
        DebugLog.log(DebugType.Network, "Disconnected player \"" + isoPlayer.getDisplayName() + "\" " + udpConnection.idStr);
        LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + isoPlayer.getUsername() + "\" disconnected player " + LoggerManager.getPlayerCoords(isoPlayer));
    }

    public static void heartBeat() {
        ++count;
    }

    public static short getFreeSlot() {
        for (short s = 0; s < udpEngine.getMaxConnections(); s = (short)(s + 1)) {
            if (SlotToConnection[s] != null) continue;
            return s;
        }
        return -1;
    }

    public static void receiveClientConnect(UdpConnection udpConnection, ServerWorldDatabase.LogonResult logonResult) {
        ConnectionManager.log("receive-packet", "client-connect", udpConnection);
        short s = GameServer.getFreeSlot();
        short s2 = (short)(s * 4);
        if (udpConnection.playerDownloadServer != null) {
            try {
                IDToAddressMap.put(s2, udpConnection.getConnectedGUID());
                udpConnection.playerDownloadServer.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        playerToCoordsMap.put(s2, new Vector2());
        playerMovedToFastMap.put(s2, 0);
        GameServer.SlotToConnection[s] = udpConnection;
        udpConnection.playerIDs[0] = s2;
        IDToAddressMap.put(s2, udpConnection.getConnectedGUID());
        udpConnection.playerDownloadServer = new PlayerDownloadServer(udpConnection);
        DebugLog.log(DebugType.Network, "Connected new client " + udpConnection.username + " ID # " + s2);
        udpConnection.playerDownloadServer.startConnectionTest();
        KahluaTable kahluaTable = SpawnPoints.instance.getSpawnRegions();
        for (int i = 1; i < kahluaTable.size() + 1; ++i) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.SpawnRegion.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(i);
            try {
                ((KahluaTable)kahluaTable.rawget(i)).save(byteBufferWriter.bb);
                PacketTypes.PacketType.SpawnRegion.send(udpConnection);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        RequestDataPacket requestDataPacket = new RequestDataPacket();
        requestDataPacket.sendConnectingDetails(udpConnection, logonResult);
    }

    static void receiveReplaceOnCooked(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ByteBufferReader byteBufferReader = new ByteBufferReader(byteBuffer);
        int n = byteBufferReader.getInt();
        int n2 = byteBufferReader.getInt();
        int n3 = byteBufferReader.getInt();
        byte by = byteBufferReader.getByte();
        byte by2 = byteBufferReader.getByte();
        int n4 = byteBufferReader.getInt();
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return;
        }
        if (by < 0 || by >= isoGridSquare.getObjects().size()) {
            return;
        }
        IsoObject isoObject = isoGridSquare.getObjects().get(by);
        if (isoObject == null) {
            return;
        }
        ItemContainer itemContainer = isoObject.getContainerByIndex(by2);
        if (itemContainer == null) {
            return;
        }
        InventoryItem inventoryItem = itemContainer.getItemWithID(n4);
        if (inventoryItem == null) {
            return;
        }
        Food food = Type.tryCastTo(inventoryItem, Food.class);
        if (food == null) {
            return;
        }
        if (food.getReplaceOnCooked() == null || food.isRotten()) {
            return;
        }
        for (int i = 0; i < food.getReplaceOnCooked().size(); ++i) {
            InventoryItem inventoryItem2 = itemContainer.AddItem(food.getReplaceOnCooked().get(i));
            if (inventoryItem2 == null) continue;
            inventoryItem2.copyConditionModData(food);
            if (!(inventoryItem2 instanceof Food) || food instanceof Food) {
                // empty if block
            }
            if (inventoryItem2 instanceof Food && ((Food)inventoryItem2).isBadInMicrowave() && itemContainer.isMicrowave()) {
                inventoryItem2.setUnhappyChange(5.0f);
                inventoryItem2.setBoredomChange(5.0f);
                ((Food)inventoryItem2).setCookedInMicrowave(true);
            }
            GameServer.sendAddItemToContainer(itemContainer, inventoryItem2);
        }
        GameServer.sendRemoveItemFromContainer(itemContainer, food);
        itemContainer.Remove(food);
        IsoWorld.instance.CurrentCell.addToProcessItemsRemove(food);
    }

    static void receivePlayerDataRequest(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        PlayerDataRequestPacket playerDataRequestPacket = new PlayerDataRequestPacket();
        playerDataRequestPacket.parse(byteBuffer, udpConnection);
        if (playerDataRequestPacket.isConsistent()) {
            playerDataRequestPacket.process(udpConnection);
        }
    }

    static void receiveRequestData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        RequestDataPacket requestDataPacket = new RequestDataPacket();
        requestDataPacket.parse(byteBuffer, udpConnection);
        requestDataPacket.processServer(PacketTypes.PacketType.RequestData, udpConnection);
    }

    public static void sendMetaGrid(int n, int n2, int n3, UdpConnection udpConnection) {
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.MetaGrid;
        if (n < isoMetaGrid.getMinX() || n > isoMetaGrid.getMaxX() || n2 < isoMetaGrid.getMinY() || n2 > isoMetaGrid.getMaxY()) {
            return;
        }
        IsoMetaCell isoMetaCell = isoMetaGrid.getCellData(n, n2);
        if (isoMetaCell.info == null || n3 < 0 || n3 >= isoMetaCell.info.RoomList.size()) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.MetaGrid.doPacket(byteBufferWriter);
        byteBufferWriter.putShort((short)n);
        byteBufferWriter.putShort((short)n2);
        byteBufferWriter.putShort((short)n3);
        byteBufferWriter.putBoolean(isoMetaCell.info.getRoom((int)n3).def.bLightsActive);
        PacketTypes.PacketType.MetaGrid.send(udpConnection);
    }

    public static void sendMetaGrid(int n, int n2, int n3) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            GameServer.sendMetaGrid(n, n2, n3, udpConnection);
        }
    }

    private static void preventIndoorZombies(int n, int n2, int n3) {
        RoomDef roomDef = IsoWorld.instance.MetaGrid.getRoomAt(n, n2, n3);
        if (roomDef == null) {
            return;
        }
        boolean bl = GameServer.isSpawnBuilding(roomDef.getBuilding());
        roomDef.getBuilding().setAllExplored(true);
        roomDef.getBuilding().setAlarmed(false);
        ArrayList<IsoZombie> arrayList = IsoWorld.instance.CurrentCell.getZombieList();
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoZombie isoZombie = arrayList.get(i);
            if (!bl && !isoZombie.bIndoorZombie || isoZombie.getSquare() == null || isoZombie.getSquare().getRoom() == null || isoZombie.getSquare().getRoom().def.building != roomDef.getBuilding()) continue;
            VirtualZombieManager.instance.removeZombieFromWorld(isoZombie);
            if (i < arrayList.size() && arrayList.get(i) == isoZombie) continue;
            --i;
        }
    }

    private static void receivePlayerConnect(ByteBuffer byteBuffer, UdpConnection udpConnection, String string) {
        Object object;
        int n;
        ConnectionManager.log("receive-packet", "player-connect", udpConnection);
        DebugLog.General.println("User:'" + string + "' ip:" + udpConnection.ip + " is trying to connect");
        byte by = byteBuffer.get();
        if (by < 0 || by >= 4 || udpConnection.players[by] != null) {
            return;
        }
        byte by2 = (byte)Math.min(20, byteBuffer.get());
        udpConnection.ReleventRange = (byte)(by2 / 2 + 2);
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        udpConnection.ReleventPos[by].x = f;
        udpConnection.ReleventPos[by].y = f2;
        udpConnection.ReleventPos[by].z = f3;
        udpConnection.connectArea[by] = null;
        udpConnection.ChunkGridWidth = by2;
        udpConnection.loadedCells[by] = new ClientServerMap(by, (int)f, (int)f2, by2);
        SurvivorDesc survivorDesc = SurvivorFactory.CreateSurvivor();
        try {
            survivorDesc.load(byteBuffer, 195, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        IsoPlayer isoPlayer = new IsoPlayer(null, survivorDesc, (int)f, (int)f2, (int)f3);
        isoPlayer.realx = f;
        isoPlayer.realy = f2;
        isoPlayer.realz = (byte)f3;
        isoPlayer.PlayerIndex = by;
        isoPlayer.OnlineChunkGridWidth = by2;
        Players.add(isoPlayer);
        isoPlayer.bRemote = true;
        try {
            isoPlayer.getHumanVisual().load(byteBuffer, 195);
            isoPlayer.getItemVisuals().load(byteBuffer, 195);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        short s = udpConnection.playerIDs[by];
        IDToPlayerMap.put(s, isoPlayer);
        udpConnection.players[by] = isoPlayer;
        PlayerToAddressMap.put(isoPlayer, udpConnection.getConnectedGUID());
        isoPlayer.setOnlineID(s);
        try {
            isoPlayer.getXp().load(byteBuffer, 195);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        isoPlayer.setAllChatMuted(byteBuffer.get() == 1);
        udpConnection.allChatMuted = isoPlayer.isAllChatMuted();
        isoPlayer.setTagPrefix(GameWindow.ReadString(byteBuffer));
        isoPlayer.setTagColor(new ColorInfo(byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), 1.0f));
        isoPlayer.setTransactionID(byteBuffer.getInt());
        isoPlayer.setHoursSurvived(byteBuffer.getDouble());
        isoPlayer.setZombieKills(byteBuffer.getInt());
        isoPlayer.setDisplayName(GameWindow.ReadString(byteBuffer));
        isoPlayer.setSpeakColour(new Color(byteBuffer.getFloat(), byteBuffer.getFloat(), byteBuffer.getFloat(), 1.0f));
        isoPlayer.showTag = byteBuffer.get() == 1;
        boolean bl = isoPlayer.factionPvp = byteBuffer.get() == 1;
        if (SteamUtils.isSteamModeEnabled()) {
            isoPlayer.setSteamID(udpConnection.steamID);
            String string2 = GameWindow.ReadStringUTF(byteBuffer);
            SteamGameServer.BUpdateUserData(udpConnection.steamID, udpConnection.username, 0);
        }
        byte by3 = byteBuffer.get();
        InventoryItem inventoryItem = null;
        if (by3 == 1) {
            try {
                inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            if (inventoryItem == null) {
                LoggerManager.getLogger("user").write(udpConnection.idStr + " equipped unknown item");
                return;
            }
            isoPlayer.setPrimaryHandItem(inventoryItem);
        }
        inventoryItem = null;
        byte by4 = byteBuffer.get();
        if (by4 == 2) {
            isoPlayer.setSecondaryHandItem(isoPlayer.getPrimaryHandItem());
        }
        if (by4 == 1) {
            try {
                inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            if (inventoryItem == null) {
                LoggerManager.getLogger("user").write(udpConnection.idStr + " equipped unknown item");
                return;
            }
            isoPlayer.setSecondaryHandItem(inventoryItem);
        }
        int n2 = byteBuffer.getInt();
        for (n = 0; n < n2; ++n) {
            String string3 = GameWindow.ReadString(byteBuffer);
            object = InventoryItemFactory.CreateItem(GameWindow.ReadString(byteBuffer));
            if (object == null) continue;
            isoPlayer.setAttachedItem(string3, (InventoryItem)object);
        }
        isoPlayer.remoteSneakLvl = n = byteBuffer.getInt();
        isoPlayer.username = string;
        isoPlayer.accessLevel = PlayerType.toString(udpConnection.accessLevel);
        if (!isoPlayer.accessLevel.equals("") && CoopSlave.instance == null) {
            isoPlayer.setGhostMode(true);
            isoPlayer.setInvisible(true);
            isoPlayer.setGodMod(true);
        }
        ChatServer.getInstance().initPlayer(isoPlayer.OnlineID);
        udpConnection.setFullyConnected();
        GameServer.sendWeather(udpConnection);
        SafetySystemManager.restoreSafety(isoPlayer);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            object = GameServer.udpEngine.connections.get(i);
            GameServer.sendPlayerConnect(isoPlayer, object);
        }
        SyncInjuriesPacket syncInjuriesPacket = new SyncInjuriesPacket();
        for (IsoPlayer object2 : IDToPlayerMap.values()) {
            if (object2.getOnlineID() == isoPlayer.getOnlineID() || !object2.isAlive()) continue;
            GameServer.sendPlayerConnect(object2, udpConnection);
            syncInjuriesPacket.set(object2);
            GameServer.sendPlayerInjuries(udpConnection, syncInjuriesPacket);
        }
        udpConnection.loadedCells[by].setLoaded();
        udpConnection.loadedCells[by].sendPacket(udpConnection);
        GameServer.preventIndoorZombies((int)f, (int)f2, (int)f3);
        ServerLOS.instance.addPlayer(isoPlayer);
        LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + isoPlayer.username + "\" fully connected " + LoggerManager.getPlayerCoords(isoPlayer));
        try {
            for (NonPvpZone nonPvpZone : NonPvpZone.getAllZones()) {
                GameServer.sendNonPvpZone(nonPvpZone, false, udpConnection);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "Send non PVP zones", LogSeverity.Error);
        }
    }

    static void receivePlayerSave(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if ((Calendar.getInstance().getTimeInMillis() - previousSave) / 60000L < 0L) {
            return;
        }
        byte by = byteBuffer.get();
        if (by < 0 || by >= 4) {
            return;
        }
        short s2 = byteBuffer.getShort();
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        ServerMap.instance.saveZoneInsidePlayerInfluence(s2);
    }

    static void receiveSendPlayerProfile(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ServerPlayerDB.getInstance().serverUpdateNetworkCharacter(byteBuffer, udpConnection);
    }

    static void receiveLoadPlayerProfile(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ServerPlayerDB.getInstance().serverLoadNetworkCharacter(byteBuffer, udpConnection);
    }

    private static void coopAccessGranted(int n, UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.AddCoopPlayer.doPacket(byteBufferWriter);
        byteBufferWriter.putBoolean(true);
        byteBufferWriter.putByte((byte)n);
        PacketTypes.PacketType.AddCoopPlayer.send(udpConnection);
    }

    private static void coopAccessDenied(String string, int n, UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.AddCoopPlayer.doPacket(byteBufferWriter);
        byteBufferWriter.putBoolean(false);
        byteBufferWriter.putByte((byte)n);
        byteBufferWriter.putUTF(string);
        PacketTypes.PacketType.AddCoopPlayer.send(udpConnection);
    }

    static void receiveAddCoopPlayer(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        int n = byteBuffer.get();
        if (!ServerOptions.instance.AllowCoop.getValue() && n != 0) {
            GameServer.coopAccessDenied("Coop players not allowed", n, udpConnection);
            return;
        }
        if (n < 0 || n >= 4) {
            GameServer.coopAccessDenied("Invalid coop player index", n, udpConnection);
            return;
        }
        if (udpConnection.players[n] != null && !udpConnection.players[n].isDead()) {
            GameServer.coopAccessDenied("Coop player " + (n + 1) + "/4 already exists", n, udpConnection);
            return;
        }
        if (by == 1) {
            short s2;
            short s3;
            String string = GameWindow.ReadStringUTF(byteBuffer);
            if (string.isEmpty()) {
                GameServer.coopAccessDenied("No username given", n, udpConnection);
                return;
            }
            for (s3 = 0; s3 < GameServer.udpEngine.connections.size(); ++s3) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(s3);
                for (int i = 0; i < 4; ++i) {
                    if (udpConnection2 == udpConnection && n == i || !string.equals(udpConnection2.usernames[i])) continue;
                    GameServer.coopAccessDenied("User \"" + string + "\" already connected", n, udpConnection);
                    return;
                }
            }
            DebugLog.log("coop player=" + (n + 1) + "/4 username=\"" + string + "\" is joining");
            if (udpConnection.players[n] != null) {
                DebugLog.log("coop player=" + (n + 1) + "/4 username=\"" + string + "\" is replacing dead player");
                s3 = udpConnection.players[n].OnlineID;
                GameServer.disconnectPlayer(udpConnection.players[n], udpConnection);
                float f = byteBuffer.getFloat();
                float f2 = byteBuffer.getFloat();
                udpConnection.usernames[n] = string;
                udpConnection.ReleventPos[n] = new Vector3(f, f2, 0.0f);
                udpConnection.connectArea[n] = new Vector3(f / 10.0f, f2 / 10.0f, udpConnection.ChunkGridWidth);
                udpConnection.playerIDs[n] = s3;
                IDToAddressMap.put(s3, udpConnection.getConnectedGUID());
                GameServer.coopAccessGranted(n, udpConnection);
                ZombiePopulationManager.instance.updateLoadedAreas();
                if (ChatServer.isInited()) {
                    ChatServer.getInstance().initPlayer(s3);
                }
                return;
            }
            if (GameServer.getPlayerCount() >= ServerOptions.getInstance().getMaxPlayers()) {
                GameServer.coopAccessDenied("Server is full", n, udpConnection);
                return;
            }
            s3 = -1;
            for (s2 = 0; s2 < udpEngine.getMaxConnections(); s2 = (short)((short)(s2 + 1))) {
                if (SlotToConnection[s2] != udpConnection) continue;
                s3 = s2;
                break;
            }
            s2 = (short)(s3 * 4 + n);
            DebugLog.log("coop player=" + (n + 1) + "/4 username=\"" + string + "\" assigned id=" + s2);
            float f = byteBuffer.getFloat();
            float f3 = byteBuffer.getFloat();
            udpConnection.usernames[n] = string;
            udpConnection.ReleventPos[n] = new Vector3(f, f3, 0.0f);
            udpConnection.playerIDs[n] = s2;
            udpConnection.connectArea[n] = new Vector3(f / 10.0f, f3 / 10.0f, udpConnection.ChunkGridWidth);
            IDToAddressMap.put(s2, udpConnection.getConnectedGUID());
            GameServer.coopAccessGranted(n, udpConnection);
            ZombiePopulationManager.instance.updateLoadedAreas();
            return;
        }
        if (by == 2) {
            String string = udpConnection.usernames[n];
            if (string == null) {
                GameServer.coopAccessDenied("Coop player login wasn't received", n, udpConnection);
                return;
            }
            DebugLog.log("coop player=" + (n + 1) + "/4 username=\"" + string + "\" player info received");
            GameServer.receivePlayerConnect(byteBuffer, udpConnection, string);
            return;
        }
    }

    private static void sendInitialWorldState(UdpConnection udpConnection) {
        if (RainManager.isRaining().booleanValue()) {
            GameServer.sendStartRain(udpConnection);
        }
        VehicleManager.instance.serverSendInitialWorldState(udpConnection);
        try {
            if (!ClimateManager.getInstance().isUpdated()) {
                ClimateManager.getInstance().update();
            }
            ClimateManager.getInstance().sendInitialState(udpConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void receiveObjectModData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        boolean bl = byteBuffer.get() == 1;
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && n4 >= 0 && n4 < isoGridSquare.getObjects().size()) {
            int n5;
            IsoObject isoObject = isoGridSquare.getObjects().get(n4);
            if (bl) {
                n5 = isoObject.getWaterAmount();
                try {
                    isoObject.getModData().load(byteBuffer, 195);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (n5 != isoObject.getWaterAmount()) {
                    LuaEventManager.triggerEvent("OnWaterAmountChange", isoObject, n5);
                }
            } else if (isoObject.hasModData()) {
                isoObject.getModData().wipe();
            }
            for (n5 = 0; n5 < GameServer.udpEngine.connections.size(); ++n5) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(n5);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !udpConnection2.RelevantTo(n, n2)) continue;
                GameServer.sendObjectModData(isoObject, udpConnection2);
            }
        } else if (isoGridSquare != null) {
            DebugLog.log("receiveObjectModData: index=" + n4 + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
        } else if (bDebug) {
            DebugLog.log("receiveObjectModData: sq is null x,y,z=" + n + "," + n2 + "," + n3);
        }
    }

    private static void sendObjectModData(IsoObject isoObject, UdpConnection udpConnection) {
        if (isoObject.getSquare() == null) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ObjectModData.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(isoObject.getSquare().getX());
        byteBufferWriter.putInt(isoObject.getSquare().getY());
        byteBufferWriter.putInt(isoObject.getSquare().getZ());
        byteBufferWriter.putInt(isoObject.getSquare().getObjects().indexOf(isoObject));
        if (isoObject.getModData().isEmpty()) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                isoObject.getModData().save(byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        PacketTypes.PacketType.ObjectModData.send(udpConnection);
    }

    public static void sendObjectModData(IsoObject isoObject) {
        if (bSoftReset || bFastForward) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(isoObject.getX(), isoObject.getY())) continue;
            GameServer.sendObjectModData(isoObject, udpConnection);
        }
    }

    public static void sendSlowFactor(IsoGameCharacter isoGameCharacter) {
        if (!(isoGameCharacter instanceof IsoPlayer)) {
            return;
        }
        if (!PlayerToAddressMap.containsKey(isoGameCharacter)) {
            return;
        }
        long l = PlayerToAddressMap.get((IsoPlayer)isoGameCharacter);
        UdpConnection udpConnection = udpEngine.getActiveConnection(l);
        if (udpConnection == null) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SlowFactor.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)((IsoPlayer)isoGameCharacter).PlayerIndex);
        byteBufferWriter.putFloat(isoGameCharacter.getSlowTimer());
        byteBufferWriter.putFloat(isoGameCharacter.getSlowFactor());
        PacketTypes.PacketType.SlowFactor.send(udpConnection);
    }

    private static void sendObjectChange(IsoObject isoObject, String string, KahluaTable kahluaTable, UdpConnection udpConnection) {
        if (isoObject.getSquare() == null) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ObjectChange.doPacket(byteBufferWriter);
        if (isoObject instanceof IsoPlayer) {
            byteBufferWriter.putByte((byte)1);
            byteBufferWriter.putShort(((IsoPlayer)isoObject).OnlineID);
        } else if (isoObject instanceof BaseVehicle) {
            byteBufferWriter.putByte((byte)2);
            byteBufferWriter.putShort(((BaseVehicle)isoObject).getId());
        } else if (isoObject instanceof IsoWorldInventoryObject) {
            byteBufferWriter.putByte((byte)3);
            byteBufferWriter.putInt(isoObject.getSquare().getX());
            byteBufferWriter.putInt(isoObject.getSquare().getY());
            byteBufferWriter.putInt(isoObject.getSquare().getZ());
            byteBufferWriter.putInt(((IsoWorldInventoryObject)isoObject).getItem().getID());
        } else if (isoObject instanceof IsoDeadBody) {
            byteBufferWriter.putByte((byte)4);
            byteBufferWriter.putInt(isoObject.getSquare().getX());
            byteBufferWriter.putInt(isoObject.getSquare().getY());
            byteBufferWriter.putInt(isoObject.getSquare().getZ());
            byteBufferWriter.putInt(isoObject.getStaticMovingObjectIndex());
        } else {
            byteBufferWriter.putByte((byte)0);
            byteBufferWriter.putInt(isoObject.getSquare().getX());
            byteBufferWriter.putInt(isoObject.getSquare().getY());
            byteBufferWriter.putInt(isoObject.getSquare().getZ());
            byteBufferWriter.putInt(isoObject.getSquare().getObjects().indexOf(isoObject));
        }
        byteBufferWriter.putUTF(string);
        isoObject.saveChange(string, kahluaTable, byteBufferWriter.bb);
        PacketTypes.PacketType.ObjectChange.send(udpConnection);
    }

    public static void sendObjectChange(IsoObject isoObject, String string, KahluaTable kahluaTable) {
        if (bSoftReset) {
            return;
        }
        if (isoObject == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(isoObject.getX(), isoObject.getY())) continue;
            GameServer.sendObjectChange(isoObject, string, kahluaTable, udpConnection);
        }
    }

    public static void sendObjectChange(IsoObject isoObject, String string, Object ... objectArray) {
        if (bSoftReset) {
            return;
        }
        if (objectArray.length == 0) {
            GameServer.sendObjectChange(isoObject, string, null);
            return;
        }
        if (objectArray.length % 2 != 0) {
            return;
        }
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i + 1];
            if (object instanceof Float) {
                kahluaTable.rawset(objectArray[i], (Object)((Float)object).doubleValue());
                continue;
            }
            if (object instanceof Integer) {
                kahluaTable.rawset(objectArray[i], (Object)((Integer)object).doubleValue());
                continue;
            }
            if (object instanceof Short) {
                kahluaTable.rawset(objectArray[i], (Object)((Short)object).doubleValue());
                continue;
            }
            kahluaTable.rawset(objectArray[i], object);
        }
        GameServer.sendObjectChange(isoObject, string, kahluaTable);
    }

    private static void updateHandEquips(UdpConnection udpConnection, IsoPlayer isoPlayer) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Equip.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(isoPlayer.OnlineID);
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putByte((byte)(isoPlayer.getPrimaryHandItem() != null ? 1 : 0));
        if (isoPlayer.getPrimaryHandItem() != null) {
            try {
                isoPlayer.getPrimaryHandItem().saveWithSize(byteBufferWriter.bb, false);
                if (isoPlayer.getPrimaryHandItem().getVisual() != null) {
                    byteBufferWriter.bb.put((byte)1);
                    isoPlayer.getPrimaryHandItem().getVisual().save(byteBufferWriter.bb);
                } else {
                    byteBufferWriter.bb.put((byte)0);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        PacketTypes.PacketType.Equip.send(udpConnection);
        byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Equip.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(isoPlayer.OnlineID);
        byteBufferWriter.putByte((byte)1);
        if (isoPlayer.getSecondaryHandItem() == isoPlayer.getPrimaryHandItem() && isoPlayer.getSecondaryHandItem() != null) {
            byteBufferWriter.putByte((byte)2);
        } else {
            byteBufferWriter.putByte((byte)(isoPlayer.getSecondaryHandItem() != null ? 1 : 0));
        }
        if (isoPlayer.getSecondaryHandItem() != null) {
            try {
                isoPlayer.getSecondaryHandItem().saveWithSize(byteBufferWriter.bb, false);
                if (isoPlayer.getSecondaryHandItem().getVisual() != null) {
                    byteBufferWriter.bb.put((byte)1);
                    isoPlayer.getSecondaryHandItem().getVisual().save(byteBufferWriter.bb);
                } else {
                    byteBufferWriter.bb.put((byte)0);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        PacketTypes.PacketType.Equip.send(udpConnection);
    }

    public static void receiveSyncCustomLightSettings(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getObjects().size()) {
            if (isoGridSquare.getObjects().get(by) instanceof IsoLightSwitch) {
                ((IsoLightSwitch)isoGridSquare.getObjects().get(by)).receiveSyncCustomizedSettings(byteBuffer, udpConnection);
            } else {
                DebugLog.log("Sync Lightswitch custom settings: found object not a instance of IsoLightSwitch, x,y,z=" + n + "," + n2 + "," + n3);
            }
        } else if (isoGridSquare != null) {
            DebugLog.log("Sync Lightswitch custom settings: index=" + by + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
        } else {
            DebugLog.log("Sync Lightswitch custom settings: sq is null x,y,z=" + n + "," + n2 + "," + n3);
        }
    }

    private static void sendAlarmClock_Player(short s, int n, boolean bl, int n2, int n3, boolean bl2, UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncAlarmClock.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(AlarmClock.PacketPlayer);
        byteBufferWriter.putShort(s);
        byteBufferWriter.putInt(n);
        byteBufferWriter.putByte(bl ? (byte)1 : 0);
        if (!bl) {
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putByte(bl2 ? (byte)1 : 0);
        }
        PacketTypes.PacketType.SyncAlarmClock.send(udpConnection);
    }

    private static void sendAlarmClock_World(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, boolean bl2, UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncAlarmClock.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(AlarmClock.PacketWorld);
        byteBufferWriter.putInt(n);
        byteBufferWriter.putInt(n2);
        byteBufferWriter.putInt(n3);
        byteBufferWriter.putInt(n4);
        byteBufferWriter.putByte(bl ? (byte)1 : 0);
        if (!bl) {
            byteBufferWriter.putInt(n5);
            byteBufferWriter.putInt(n6);
            byteBufferWriter.putByte(bl2 ? (byte)1 : 0);
        }
        PacketTypes.PacketType.SyncAlarmClock.send(udpConnection);
    }

    static void receiveSyncAlarmClock(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        if (s2 == AlarmClock.PacketPlayer) {
            IsoPlayer isoPlayer;
            short s3 = byteBuffer.getShort();
            int n = byteBuffer.getInt();
            boolean bl = byteBuffer.get() == 1;
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            if (!bl) {
                n2 = byteBuffer.getInt();
                n3 = byteBuffer.getInt();
                boolean bl3 = bl2 = byteBuffer.get() == 1;
            }
            if ((isoPlayer = GameServer.getPlayerFromConnection(udpConnection, s3)) != null) {
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                    if (udpConnection2 == udpConnection) continue;
                    GameServer.sendAlarmClock_Player(isoPlayer.getOnlineID(), n, bl, n2, n3, bl2, udpConnection2);
                }
            }
            return;
        }
        if (s2 == AlarmClock.PacketWorld) {
            Object object;
            int n;
            IsoGridSquare isoGridSquare;
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            int n6 = byteBuffer.getInt();
            int n7 = byteBuffer.getInt();
            boolean bl = byteBuffer.get() == 1;
            int n8 = 0;
            int n9 = 0;
            boolean bl4 = false;
            if (!bl) {
                n8 = byteBuffer.getInt();
                n9 = byteBuffer.getInt();
                boolean bl5 = bl4 = byteBuffer.get() == 1;
            }
            if ((isoGridSquare = ServerMap.instance.getGridSquare(n4, n5, n6)) == null) {
                DebugLog.log("SyncAlarmClock: sq is null x,y,z=" + n4 + "," + n5 + "," + n6);
                return;
            }
            AlarmClock alarmClock = null;
            for (n = 0; n < isoGridSquare.getWorldObjects().size(); ++n) {
                object = isoGridSquare.getWorldObjects().get(n);
                if (object == null || !(((IsoWorldInventoryObject)object).getItem() instanceof AlarmClock) || ((IsoWorldInventoryObject)object).getItem().id != n7) continue;
                alarmClock = (AlarmClock)((IsoWorldInventoryObject)object).getItem();
                break;
            }
            if (alarmClock == null) {
                DebugLog.log("SyncAlarmClock: AlarmClock is null x,y,z=" + n4 + "," + n5 + "," + n6);
            } else {
                if (bl) {
                    alarmClock.stopRinging();
                } else {
                    alarmClock.setHour(n8);
                    alarmClock.setMinute(n9);
                    alarmClock.setAlarmSet(bl4);
                }
                for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
                    object = GameServer.udpEngine.connections.get(n);
                    if (object == udpConnection) continue;
                    GameServer.sendAlarmClock_World(n4, n5, n6, n7, bl, n8, n9, bl4, (UdpConnection)object);
                }
            }
            return;
        }
    }

    static void receiveSyncIsoObject(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        if (!DebugOptions.instance.Network.Server.SyncIsoObject.getValue()) {
            return;
        }
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        if (by2 != 1) {
            return;
        }
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getObjects().size()) {
            isoGridSquare.getObjects().get(by).syncIsoObject(true, by3, udpConnection, byteBuffer);
        } else if (isoGridSquare != null) {
            DebugLog.log("SyncIsoObject: index=" + by + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
        } else {
            DebugLog.log("SyncIsoObject: sq is null x,y,z=" + n + "," + n2 + "," + n3);
        }
    }

    static void receiveSyncIsoObjectReq(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getShort();
        if (n > 50 || n <= 0) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncIsoObjectReq.doPacket(byteBufferWriter);
        byteBufferWriter.putShort((short)n);
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            byte by = byteBuffer.get();
            IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n2, n3, n4);
            if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getObjects().size()) {
                isoGridSquare.getObjects().get(by).syncIsoObjectSend(byteBufferWriter);
                continue;
            }
            if (isoGridSquare != null) {
                byteBufferWriter.putInt(isoGridSquare.getX());
                byteBufferWriter.putInt(isoGridSquare.getY());
                byteBufferWriter.putInt(isoGridSquare.getZ());
                byteBufferWriter.putByte(by);
                byteBufferWriter.putByte((byte)0);
                byteBufferWriter.putByte((byte)0);
                continue;
            }
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putInt(n4);
            byteBufferWriter.putByte(by);
            byteBufferWriter.putByte((byte)2);
            byteBufferWriter.putByte((byte)0);
        }
        PacketTypes.PacketType.SyncIsoObjectReq.send(udpConnection);
    }

    static void receiveSyncObjects(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        if (s2 == 1) {
            GameServer.SyncObjectChunkHashes(byteBuffer, udpConnection);
        } else if (s2 == 3) {
            GameServer.SyncObjectsGridSquareRequest(byteBuffer, udpConnection);
        } else if (s2 == 5) {
            GameServer.SyncObjectsRequest(byteBuffer, udpConnection);
        }
    }

    public static void SyncObjectChunkHashes(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        int n;
        int n2 = byteBuffer.getShort();
        if (n2 > 10 || n2 <= 0) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putShort((short)2);
        int n3 = byteBufferWriter.bb.position();
        byteBufferWriter.putShort((short)0);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            int n5;
            int n6 = byteBuffer.getInt();
            int n7 = byteBuffer.getInt();
            long l = byteBuffer.getLong();
            IsoChunk isoChunk = ServerMap.instance.getChunk(n6, n7);
            if (isoChunk == null) continue;
            ++n4;
            byteBufferWriter.putShort((short)isoChunk.wx);
            byteBufferWriter.putShort((short)isoChunk.wy);
            byteBufferWriter.putLong(isoChunk.getHashCodeObjects());
            int n8 = byteBufferWriter.bb.position();
            byteBufferWriter.putShort((short)0);
            int n9 = 0;
            for (n5 = n6 * 10; n5 < n6 * 10 + 10; ++n5) {
                for (int i = n7 * 10; i < n7 * 10 + 10; ++i) {
                    IsoGridSquare isoGridSquare;
                    for (int j = 0; j <= 7 && (isoGridSquare = ServerMap.instance.getGridSquare(n5, i, j)) != null; ++j) {
                        byteBufferWriter.putByte((byte)(isoGridSquare.getX() - isoChunk.wx * 10));
                        byteBufferWriter.putByte((byte)(isoGridSquare.getY() - isoChunk.wy * 10));
                        byteBufferWriter.putByte((byte)isoGridSquare.getZ());
                        byteBufferWriter.putInt((int)isoGridSquare.getHashCodeObjects());
                        ++n9;
                    }
                }
            }
            n5 = byteBufferWriter.bb.position();
            byteBufferWriter.bb.position(n8);
            byteBufferWriter.putShort((short)n9);
            byteBufferWriter.bb.position(n5);
        }
        n = byteBufferWriter.bb.position();
        byteBufferWriter.bb.position(n3);
        byteBufferWriter.putShort((short)n4);
        byteBufferWriter.bb.position(n);
        PacketTypes.PacketType.SyncObjects.send(udpConnection);
    }

    public static void SyncObjectChunkHashes(IsoChunk isoChunk, UdpConnection udpConnection) {
        int n;
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putShort((short)2);
        byteBufferWriter.putShort((short)1);
        byteBufferWriter.putShort((short)isoChunk.wx);
        byteBufferWriter.putShort((short)isoChunk.wy);
        byteBufferWriter.putLong(isoChunk.getHashCodeObjects());
        int n2 = byteBufferWriter.bb.position();
        byteBufferWriter.putShort((short)0);
        int n3 = 0;
        for (n = isoChunk.wx * 10; n < isoChunk.wx * 10 + 10; ++n) {
            for (int i = isoChunk.wy * 10; i < isoChunk.wy * 10 + 10; ++i) {
                IsoGridSquare isoGridSquare;
                for (int j = 0; j <= 7 && (isoGridSquare = ServerMap.instance.getGridSquare(n, i, j)) != null; ++j) {
                    byteBufferWriter.putByte((byte)(isoGridSquare.getX() - isoChunk.wx * 10));
                    byteBufferWriter.putByte((byte)(isoGridSquare.getY() - isoChunk.wy * 10));
                    byteBufferWriter.putByte((byte)isoGridSquare.getZ());
                    byteBufferWriter.putInt((int)isoGridSquare.getHashCodeObjects());
                    ++n3;
                }
            }
        }
        n = byteBufferWriter.bb.position();
        byteBufferWriter.bb.position(n2);
        byteBufferWriter.putShort((short)n3);
        byteBufferWriter.bb.position(n);
        PacketTypes.PacketType.SyncObjects.send(udpConnection);
    }

    public static void SyncObjectsGridSquareRequest(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        int n;
        int n2 = byteBuffer.getShort();
        if (n2 > 100 || n2 <= 0) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putShort((short)4);
        int n3 = byteBufferWriter.bb.position();
        byteBufferWriter.putShort((short)0);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            int n5;
            byte by;
            int n6;
            int n7 = byteBuffer.getInt();
            IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n7, n6 = byteBuffer.getInt(), by = byteBuffer.get());
            if (isoGridSquare == null) continue;
            ++n4;
            byteBufferWriter.putInt(n7);
            byteBufferWriter.putInt(n6);
            byteBufferWriter.putByte(by);
            byteBufferWriter.putByte((byte)isoGridSquare.getObjects().size());
            byteBufferWriter.putInt(0);
            int n8 = byteBufferWriter.bb.position();
            for (n5 = 0; n5 < isoGridSquare.getObjects().size(); ++n5) {
                byteBufferWriter.putLong(isoGridSquare.getObjects().get(n5).customHashCode());
            }
            n5 = byteBufferWriter.bb.position();
            byteBufferWriter.bb.position(n8 - 4);
            byteBufferWriter.putInt(n5);
            byteBufferWriter.bb.position(n5);
        }
        n = byteBufferWriter.bb.position();
        byteBufferWriter.bb.position(n3);
        byteBufferWriter.putShort((short)n4);
        byteBufferWriter.bb.position(n);
        PacketTypes.PacketType.SyncObjects.send(udpConnection);
    }

    public static void SyncObjectsRequest(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        int n = byteBuffer.getShort();
        if (n > 100 || n <= 0) {
            return;
        }
        block2: for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            byte by = byteBuffer.get();
            long l = byteBuffer.getLong();
            IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare(n2, n3, by);
            if (isoGridSquare == null) continue;
            for (int j = 0; j < isoGridSquare.getObjects().size(); ++j) {
                if (isoGridSquare.getObjects().get(j).customHashCode() != l) continue;
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
                byteBufferWriter.putShort((short)6);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putInt(n3);
                byteBufferWriter.putByte(by);
                byteBufferWriter.putLong(l);
                byteBufferWriter.putByte((byte)isoGridSquare.getObjects().size());
                for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                    byteBufferWriter.putLong(isoGridSquare.getObjects().get(k).customHashCode());
                }
                try {
                    isoGridSquare.getObjects().get(j).writeToRemoteBuffer(byteBufferWriter);
                }
                catch (Throwable throwable) {
                    DebugLog.log("ERROR: GameServer.SyncObjectsRequest " + throwable.getMessage());
                    udpConnection.cancelPacket();
                    continue block2;
                }
                PacketTypes.PacketType.SyncObjects.send(udpConnection);
                continue block2;
            }
        }
    }

    static void receiveSyncDoorKey(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoObject isoObject;
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        int n4 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getObjects().size()) {
            isoObject = isoGridSquare.getObjects().get(by);
            if (!(isoObject instanceof IsoDoor)) {
                DebugLog.log("SyncDoorKey: expected IsoDoor index=" + by + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
                return;
            }
        } else {
            if (isoGridSquare != null) {
                DebugLog.log("SyncDoorKey: index=" + by + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
                return;
            }
            DebugLog.log("SyncDoorKey: sq is null x,y,z=" + n + "," + n2 + "," + n3);
            return;
        }
        Object object = (IsoDoor)isoObject;
        ((IsoDoor)object).keyId = n4;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            object = GameServer.udpEngine.connections.get(i);
            if (((UdpConnection)object).getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
            PacketTypes.PacketType.SyncDoorKey.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putByte(by);
            byteBufferWriter.putInt(n4);
            PacketTypes.PacketType.SyncDoorKey.send((UdpConnection)object);
        }
    }

    static void receiveSyncThumpable(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoObject isoObject;
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        int n4 = byteBuffer.getInt();
        byte by2 = byteBuffer.get();
        int n5 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && by >= 0 && by < isoGridSquare.getObjects().size()) {
            isoObject = isoGridSquare.getObjects().get(by);
            if (!(isoObject instanceof IsoThumpable)) {
                DebugLog.log("SyncThumpable: expected IsoThumpable index=" + by + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
                return;
            }
        } else {
            if (isoGridSquare != null) {
                DebugLog.log("SyncThumpable: index=" + by + " is invalid x,y,z=" + n + "," + n2 + "," + n3);
                return;
            }
            DebugLog.log("SyncThumpable: sq is null x,y,z=" + n + "," + n2 + "," + n3);
            return;
        }
        Object object = (IsoThumpable)isoObject;
        ((IsoThumpable)object).lockedByCode = n4;
        ((IsoThumpable)object).lockedByPadlock = by2 == 1;
        ((IsoThumpable)object).keyId = n5;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            object = GameServer.udpEngine.connections.get(i);
            if (((UdpConnection)object).getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
            PacketTypes.PacketType.SyncThumpable.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putByte(by);
            byteBufferWriter.putInt(n4);
            byteBufferWriter.putByte(by2);
            byteBufferWriter.putInt(n5);
            PacketTypes.PacketType.SyncThumpable.send((UdpConnection)object);
        }
    }

    static void receiveRemoveItemFromSquare(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && n4 >= 0 && n4 < isoGridSquare.getObjects().size()) {
            Object object;
            IsoObject isoObject = isoGridSquare.getObjects().get(n4);
            if (!(isoObject instanceof IsoWorldInventoryObject)) {
                IsoRegions.setPreviousFlags(isoGridSquare);
            }
            DebugLog.log(DebugType.Objects, "object: removing " + isoObject + " index=" + n4 + " " + n + "," + n2 + "," + n3);
            if (isoObject instanceof IsoWorldInventoryObject) {
                LoggerManager.getLogger("item").write(udpConnection.idStr + " \"" + udpConnection.username + "\" floor -1 " + n + "," + n2 + "," + n3 + " [" + ((IsoWorldInventoryObject)isoObject).getItem().getFullType() + "]");
            } else {
                Object object2;
                Object object3 = object2 = isoObject.getName() != null ? isoObject.getName() : isoObject.getObjectName();
                if (isoObject.getSprite() != null && isoObject.getSprite().getName() != null) {
                    object2 = (String)object2 + " (" + isoObject.getSprite().getName() + ")";
                }
                LoggerManager.getLogger("map").write(udpConnection.idStr + " \"" + udpConnection.username + "\" removed " + (String)object2 + " at " + n + "," + n2 + "," + n3);
            }
            if (isoObject.isTableSurface()) {
                for (int i = n4 + 1; i < isoGridSquare.getObjects().size(); ++i) {
                    object = isoGridSquare.getObjects().get(i);
                    if (!((IsoObject)object).isTableTopObject() && !((IsoObject)object).isTableSurface()) continue;
                    ((IsoObject)object).setRenderYOffset(((IsoObject)object).getRenderYOffset() - isoObject.getSurfaceOffset());
                }
            }
            if (!(isoObject instanceof IsoWorldInventoryObject)) {
                LuaEventManager.triggerEvent("OnObjectAboutToBeRemoved", isoObject);
            }
            if (!isoGridSquare.getObjects().contains(isoObject)) {
                throw new IllegalArgumentException("OnObjectAboutToBeRemoved not allowed to remove the object");
            }
            isoObject.removeFromWorld();
            isoObject.removeFromSquare();
            isoGridSquare.RecalcAllWithNeighbours(true);
            if (!(isoObject instanceof IsoWorldInventoryObject)) {
                IsoWorld.instance.CurrentCell.checkHaveRoof(n, n2);
                MapCollisionData.instance.squareChanged(isoGridSquare);
                PolygonalMap2.instance.squareChanged(isoGridSquare);
                ServerMap.instance.physicsCheck(n, n2);
                IsoRegions.squareChanged(isoGridSquare, true);
                IsoGenerator.updateGenerator(isoGridSquare);
            }
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                object = GameServer.udpEngine.connections.get(i);
                if (((UdpConnection)object).getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = ((UdpConnection)object).startPacket();
                PacketTypes.PacketType.RemoveItemFromSquare.doPacket(byteBufferWriter);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putInt(n3);
                byteBufferWriter.putInt(n4);
                PacketTypes.PacketType.RemoveItemFromSquare.send((UdpConnection)object);
            }
        }
    }

    public static int RemoveItemFromMap(IsoObject isoObject) {
        int n = isoObject.getSquare().getX();
        int n2 = isoObject.getSquare().getY();
        int n3 = isoObject.getSquare().getZ();
        int n4 = isoObject.getSquare().getObjects().indexOf(isoObject);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && !(isoObject instanceof IsoWorldInventoryObject)) {
            IsoRegions.setPreviousFlags(isoGridSquare);
        }
        LuaEventManager.triggerEvent("OnObjectAboutToBeRemoved", isoObject);
        if (!isoObject.getSquare().getObjects().contains(isoObject)) {
            throw new IllegalArgumentException("OnObjectAboutToBeRemoved not allowed to remove the object");
        }
        isoObject.removeFromWorld();
        isoObject.removeFromSquare();
        if (isoGridSquare != null) {
            isoGridSquare.RecalcAllWithNeighbours(true);
        }
        if (!(isoObject instanceof IsoWorldInventoryObject)) {
            IsoWorld.instance.CurrentCell.checkHaveRoof(n, n2);
            MapCollisionData.instance.squareChanged(isoGridSquare);
            PolygonalMap2.instance.squareChanged(isoGridSquare);
            ServerMap.instance.physicsCheck(n, n2);
            IsoRegions.squareChanged(isoGridSquare, true);
            IsoGenerator.updateGenerator(isoGridSquare);
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(n, n2)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.RemoveItemFromSquare.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putInt(n4);
            PacketTypes.PacketType.RemoveItemFromSquare.send(udpConnection);
        }
        return n4;
    }

    public static void sendBloodSplatter(HandWeapon handWeapon, float f, float f2, float f3, Vector2 vector22, boolean bl, boolean bl2) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.BloodSplatter.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(handWeapon != null ? handWeapon.getType() : "");
            byteBufferWriter.putFloat(f);
            byteBufferWriter.putFloat(f2);
            byteBufferWriter.putFloat(f3);
            byteBufferWriter.putFloat(vector22.getX());
            byteBufferWriter.putFloat(vector22.getY());
            byteBufferWriter.putByte(bl ? (byte)1 : 0);
            byteBufferWriter.putByte(bl2 ? (byte)1 : 0);
            byte by = 0;
            if (handWeapon != null) {
                by = (byte)Math.max(handWeapon.getSplatNumber(), 1);
            }
            byteBufferWriter.putByte(by);
            PacketTypes.PacketType.BloodSplatter.send(udpConnection);
        }
    }

    static void receiveAddItemToMap(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoObject isoObject = WorldItemTypes.createFromBuffer(byteBuffer);
        if (isoObject instanceof IsoFire && ServerOptions.instance.NoFire.getValue()) {
            DebugLog.log("user \"" + udpConnection.username + "\" tried to start a fire");
            return;
        }
        isoObject.loadFromRemoteBuffer(byteBuffer);
        if (isoObject.square != null) {
            DebugLog.log(DebugType.Objects, "object: added " + isoObject + " index=" + isoObject.getObjectIndex() + " " + isoObject.getX() + "," + isoObject.getY() + "," + isoObject.getZ());
            if (isoObject instanceof IsoWorldInventoryObject) {
                LoggerManager.getLogger("item").write(udpConnection.idStr + " \"" + udpConnection.username + "\" floor +1 " + (int)isoObject.getX() + "," + (int)isoObject.getY() + "," + (int)isoObject.getZ() + " [" + ((IsoWorldInventoryObject)isoObject).getItem().getFullType() + "]");
            } else {
                Object object;
                Object object2 = object = isoObject.getName() != null ? isoObject.getName() : isoObject.getObjectName();
                if (isoObject.getSprite() != null && isoObject.getSprite().getName() != null) {
                    object = (String)object + " (" + isoObject.getSprite().getName() + ")";
                }
                LoggerManager.getLogger("map").write(udpConnection.idStr + " \"" + udpConnection.username + "\" added " + (String)object + " at " + isoObject.getX() + "," + isoObject.getY() + "," + isoObject.getZ());
            }
            isoObject.addToWorld();
            isoObject.square.RecalcProperties();
            if (!(isoObject instanceof IsoWorldInventoryObject)) {
                isoObject.square.restackSheetRope();
                IsoWorld.instance.CurrentCell.checkHaveRoof(isoObject.square.getX(), isoObject.square.getY());
                MapCollisionData.instance.squareChanged(isoObject.square);
                PolygonalMap2.instance.squareChanged(isoObject.square);
                ServerMap.instance.physicsCheck(isoObject.square.x, isoObject.square.y);
                IsoRegions.squareChanged(isoObject.square);
                IsoGenerator.updateGenerator(isoObject.square);
            }
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !udpConnection2.RelevantTo(isoObject.square.x, isoObject.square.y)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.AddItemToMap.doPacket(byteBufferWriter);
                isoObject.writeToRemoteBuffer(byteBufferWriter);
                PacketTypes.PacketType.AddItemToMap.send(udpConnection2);
            }
            if (!(isoObject instanceof IsoWorldInventoryObject)) {
                LuaEventManager.triggerEvent("OnObjectAdded", isoObject);
            } else {
                ((IsoWorldInventoryObject)isoObject).dropTime = GameTime.getInstance().getWorldAgeHours();
            }
        } else if (bDebug) {
            DebugLog.log("AddItemToMap: sq is null");
        }
    }

    public static void disconnect(UdpConnection udpConnection, String string) {
        Map.Entry<Short, Long> entry;
        int n;
        if (udpConnection.playerDownloadServer != null) {
            try {
                udpConnection.playerDownloadServer.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            udpConnection.playerDownloadServer = null;
        }
        RequestDataManager.getInstance().disconnect(udpConnection);
        for (n = 0; n < 4; ++n) {
            entry = udpConnection.players[n];
            if (entry != null) {
                ChatServer.getInstance().disconnectPlayer(udpConnection.playerIDs[n]);
                GameServer.disconnectPlayer((IsoPlayer)((Object)entry), udpConnection);
            }
            udpConnection.usernames[n] = null;
            udpConnection.players[n] = null;
            udpConnection.playerIDs[n] = -1;
            udpConnection.ReleventPos[n] = null;
            udpConnection.connectArea[n] = null;
        }
        for (n = 0; n < udpEngine.getMaxConnections(); ++n) {
            if (SlotToConnection[n] != udpConnection) continue;
            GameServer.SlotToConnection[n] = null;
        }
        Iterator<Map.Entry<Short, Long>> iterator = IDToAddressMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (((Long)entry.getValue()).longValue() != udpConnection.getConnectedGUID()) continue;
            iterator.remove();
        }
        if (!SteamUtils.isSteamModeEnabled()) {
            PublicServerUtil.updatePlayers();
        }
        if (CoopSlave.instance != null && udpConnection.isCoopHost) {
            DebugLog.log("Host user disconnected, stopping the server");
            ServerMap.instance.QueueQuit();
        }
        if (bServer) {
            ConnectionManager.log("disconnect", string, udpConnection);
        }
    }

    public static void addIncoming(short s, ByteBuffer byteBuffer, UdpConnection udpConnection) {
        ZomboidNetData zomboidNetData = null;
        zomboidNetData = byteBuffer.limit() > 2048 ? ZomboidNetDataPool.instance.getLong(byteBuffer.limit()) : ZomboidNetDataPool.instance.get();
        zomboidNetData.read(s, byteBuffer, udpConnection);
        if (zomboidNetData.type == null) {
            try {
                if (ServerOptions.instance.AntiCheatProtectionType13.getValue() && PacketValidator.checkUser(udpConnection)) {
                    PacketValidator.doKickUser(udpConnection, String.valueOf(s), "Type13", null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        zomboidNetData.time = System.currentTimeMillis();
        if (zomboidNetData.type == PacketTypes.PacketType.PlayerUpdate || zomboidNetData.type == PacketTypes.PacketType.PlayerUpdateReliable) {
            MainLoopPlayerUpdateQ.add(zomboidNetData);
        } else if (zomboidNetData.type == PacketTypes.PacketType.VehiclesUnreliable || zomboidNetData.type == PacketTypes.PacketType.Vehicles) {
            byte by = zomboidNetData.buffer.get(0);
            if (by == 9) {
                MainLoopNetDataQ.add(zomboidNetData);
            } else {
                MainLoopNetDataHighPriorityQ.add(zomboidNetData);
            }
        } else {
            MainLoopNetDataHighPriorityQ.add(zomboidNetData);
        }
    }

    public static void smashWindow(IsoWindow isoWindow, int n) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.RelevantTo(isoWindow.getX(), isoWindow.getY())) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.SmashWindow.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(isoWindow.square.getX());
            byteBufferWriter.putInt(isoWindow.square.getY());
            byteBufferWriter.putInt(isoWindow.square.getZ());
            byteBufferWriter.putByte((byte)isoWindow.square.getObjects().indexOf(isoWindow));
            byteBufferWriter.putByte((byte)n);
            PacketTypes.PacketType.SmashWindow.send(udpConnection);
        }
    }

    static void receiveHitCharacter(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            HitCharacterPacket hitCharacterPacket = HitCharacterPacket.process(byteBuffer);
            if (hitCharacterPacket != null) {
                hitCharacterPacket.parse(byteBuffer, udpConnection);
                if (hitCharacterPacket.isConsistent() && hitCharacterPacket.validate(udpConnection)) {
                    DebugLog.Damage.trace(hitCharacterPacket.getDescription());
                    GameServer.sendHitCharacter(hitCharacterPacket, udpConnection);
                    hitCharacterPacket.tryProcess();
                }
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveHitCharacter: failed", LogSeverity.Error);
        }
    }

    private static void sendHitCharacter(HitCharacterPacket hitCharacterPacket, UdpConnection udpConnection) {
        DebugLog.Damage.trace(hitCharacterPacket.getDescription());
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !hitCharacterPacket.isRelevant(udpConnection2)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.HitCharacter.doPacket(byteBufferWriter);
            hitCharacterPacket.write(byteBufferWriter);
            PacketTypes.PacketType.HitCharacter.send(udpConnection2);
        }
    }

    static void receiveZombieDeath(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            DeadZombiePacket deadZombiePacket = new DeadZombiePacket();
            deadZombiePacket.parse(byteBuffer, udpConnection);
            if (Core.bDebug) {
                DebugLog.Multiplayer.debugln("ReceiveZombieDeath: %s", deadZombiePacket.getDescription());
            }
            if (deadZombiePacket.isConsistent()) {
                if (deadZombiePacket.getZombie().isReanimatedPlayer()) {
                    GameServer.sendZombieDeath(deadZombiePacket.getZombie());
                } else {
                    GameServer.sendZombieDeath(deadZombiePacket);
                }
                deadZombiePacket.process();
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveZombieDeath: failed", LogSeverity.Error);
        }
    }

    public static void sendZombieDeath(IsoZombie isoZombie) {
        try {
            DeadZombiePacket deadZombiePacket = new DeadZombiePacket();
            deadZombiePacket.set(isoZombie);
            GameServer.sendZombieDeath(deadZombiePacket);
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "SendZombieDeath: failed", LogSeverity.Error);
        }
    }

    private static void sendZombieDeath(DeadZombiePacket deadZombiePacket) {
        try {
            if (Core.bDebug) {
                DebugLog.Multiplayer.debugln("SendZombieDeath: %s", deadZombiePacket.getDescription());
            }
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                if (!udpConnection.RelevantTo(deadZombiePacket.getZombie().getX(), deadZombiePacket.getZombie().getY())) continue;
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.ZombieDeath.doPacket(byteBufferWriter);
                try {
                    deadZombiePacket.write(byteBufferWriter);
                    PacketTypes.PacketType.ZombieDeath.send(udpConnection);
                    continue;
                }
                catch (Exception exception) {
                    udpConnection.cancelPacket();
                    DebugLog.Multiplayer.printException(exception, "SendZombieDeath: failed", LogSeverity.Error);
                }
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "SendZombieDeath: failed", LogSeverity.Error);
        }
    }

    static void receivePlayerDeath(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            DeadPlayerPacket deadPlayerPacket = new DeadPlayerPacket();
            deadPlayerPacket.parse(byteBuffer, udpConnection);
            if (Core.bDebug) {
                DebugLog.Multiplayer.debugln("ReceivePlayerDeath: %s", deadPlayerPacket.getDescription());
            }
            String string = deadPlayerPacket.getPlayer().username;
            ChatServer.getInstance().disconnectPlayer(deadPlayerPacket.getPlayer().getOnlineID());
            ServerWorldDatabase.instance.saveTransactionID(string, 0);
            deadPlayerPacket.getPlayer().setTransactionID(0);
            transactionIDMap.put(string, 0);
            SafetySystemManager.clearSafety(deadPlayerPacket.getPlayer());
            if (deadPlayerPacket.getPlayer().accessLevel.equals("") && !ServerOptions.instance.Open.getValue() && ServerOptions.instance.DropOffWhiteListAfterDeath.getValue()) {
                try {
                    ServerWorldDatabase.instance.removeUser(string);
                }
                catch (SQLException sQLException) {
                    DebugLog.Multiplayer.printException(sQLException, "ReceivePlayerDeath: db failed", LogSeverity.Warning);
                }
            }
            if (deadPlayerPacket.isConsistent()) {
                deadPlayerPacket.id = deadPlayerPacket.getPlayer().getOnlineID();
                GameServer.sendPlayerDeath(deadPlayerPacket, udpConnection);
                deadPlayerPacket.process();
            }
            deadPlayerPacket.getPlayer().setStateMachineLocked(true);
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceivePlayerDeath: failed", LogSeverity.Error);
        }
    }

    public static void sendPlayerDeath(DeadPlayerPacket deadPlayerPacket, UdpConnection udpConnection) {
        if (Core.bDebug) {
            DebugLog.Multiplayer.debugln("SendPlayerDeath: %s", deadPlayerPacket.getDescription());
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection.getConnectedGUID() == udpConnection2.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.PlayerDeath.doPacket(byteBufferWriter);
            deadPlayerPacket.write(byteBufferWriter);
            PacketTypes.PacketType.PlayerDeath.send(udpConnection2);
        }
    }

    static void receivePlayerDamage(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            short s2 = byteBuffer.getShort();
            float f = byteBuffer.getFloat();
            IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, s2);
            if (isoPlayer != null) {
                isoPlayer.getBodyDamage().load(byteBuffer, IsoWorld.getWorldVersion());
                isoPlayer.getStats().setPain(f);
                if (Core.bDebug) {
                    DebugLog.Multiplayer.debugln("ReceivePlayerDamage: \"%s\" %f", isoPlayer.getUsername(), Float.valueOf(isoPlayer.getBodyDamage().getOverallBodyHealth()));
                }
                GameServer.sendPlayerDamage(isoPlayer, udpConnection);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceivePlayerDamage: failed", LogSeverity.Error);
        }
    }

    public static void sendPlayerDamage(IsoPlayer isoPlayer, UdpConnection udpConnection) {
        if (Core.bDebug) {
            DebugLog.Multiplayer.debugln("SendPlayerDamage: \"%s\" %f", isoPlayer.getUsername(), Float.valueOf(isoPlayer.getBodyDamage().getOverallBodyHealth()));
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection.getConnectedGUID() == udpConnection2.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.PlayerDamage.doPacket(byteBufferWriter);
            try {
                byteBufferWriter.putShort(isoPlayer.getOnlineID());
                byteBufferWriter.putFloat(isoPlayer.getStats().getPain());
                isoPlayer.getBodyDamage().save(byteBufferWriter.bb);
                PacketTypes.PacketType.PlayerDamage.send(udpConnection2);
                continue;
            }
            catch (Exception exception) {
                udpConnection2.cancelPacket();
                DebugLog.Multiplayer.printException(exception, "SendPlayerDamage: failed", LogSeverity.Error);
            }
        }
    }

    static void receiveSyncInjuries(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            SyncInjuriesPacket syncInjuriesPacket = new SyncInjuriesPacket();
            syncInjuriesPacket.parse(byteBuffer, udpConnection);
            DebugLog.Damage.trace(syncInjuriesPacket.getDescription());
            if (syncInjuriesPacket.process()) {
                syncInjuriesPacket.id = syncInjuriesPacket.player.getOnlineID();
                GameServer.sendPlayerInjuries(udpConnection, syncInjuriesPacket);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceivePlayerInjuries: failed", LogSeverity.Error);
        }
    }

    private static void sendPlayerInjuries(UdpConnection udpConnection, SyncInjuriesPacket syncInjuriesPacket) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncInjuries.doPacket(byteBufferWriter);
        syncInjuriesPacket.write(byteBufferWriter);
        PacketTypes.PacketType.SyncInjuries.send(udpConnection);
    }

    static void receiveKeepAlive(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        MPDebugInfo.instance.serverPacket(byteBuffer, udpConnection);
    }

    static void receiveRemoveCorpseFromMap(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        RemoveCorpseFromMap removeCorpseFromMap = new RemoveCorpseFromMap();
        removeCorpseFromMap.parse(byteBuffer, udpConnection);
        if (!removeCorpseFromMap.isConsistent()) {
            return;
        }
        removeCorpseFromMap.process();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !removeCorpseFromMap.isRelevant(udpConnection2)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.RemoveCorpseFromMap.doPacket(byteBufferWriter);
            removeCorpseFromMap.write(byteBufferWriter);
            PacketTypes.PacketType.RemoveCorpseFromMap.send(udpConnection2);
        }
    }

    public static void sendRemoveCorpseFromMap(IsoDeadBody isoDeadBody) {
        RemoveCorpseFromMap removeCorpseFromMap = new RemoveCorpseFromMap();
        removeCorpseFromMap.set(isoDeadBody);
        DebugLog.Death.trace(removeCorpseFromMap.getDescription());
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.RemoveCorpseFromMap.doPacket(byteBufferWriter);
            removeCorpseFromMap.write(byteBufferWriter);
            PacketTypes.PacketType.RemoveCorpseFromMap.send(udpConnection);
        }
    }

    static void receiveEventPacket(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            EventPacket eventPacket = new EventPacket();
            eventPacket.parse(byteBuffer, udpConnection);
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !eventPacket.isRelevant(udpConnection2)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.EventPacket.doPacket(byteBufferWriter);
                eventPacket.write(byteBufferWriter);
                PacketTypes.PacketType.EventPacket.send(udpConnection2);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveEvent: failed", LogSeverity.Error);
        }
    }

    static void receiveActionPacket(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            ActionPacket actionPacket = new ActionPacket();
            actionPacket.parse(byteBuffer, udpConnection);
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || !actionPacket.isRelevant(udpConnection2)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.ActionPacket.doPacket(byteBufferWriter);
                actionPacket.write(byteBufferWriter);
                PacketTypes.PacketType.ActionPacket.send(udpConnection2);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveAction: failed", LogSeverity.Error);
        }
    }

    static void receiveKillZombie(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            short s2 = byteBuffer.getShort();
            boolean bl = byteBuffer.get() != 0;
            DebugLog.Death.trace("id=%d, isFallOnFront=%b", s2, bl);
            IsoZombie isoZombie = ServerMap.instance.ZombieMap.get(s2);
            if (isoZombie != null) {
                isoZombie.setFallOnFront(bl);
                isoZombie.becomeCorpse();
            } else {
                DebugLog.Multiplayer.error("ReceiveKillZombie: zombie not found");
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveKillZombie: failed", LogSeverity.Error);
        }
    }

    public static void receiveEatBody(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            short s2;
            IsoZombie isoZombie;
            if (Core.bDebug) {
                DebugLog.log(DebugType.Multiplayer, "ReceiveEatBody");
            }
            if ((isoZombie = ServerMap.instance.ZombieMap.get(s2 = byteBuffer.getShort())) == null) {
                DebugLog.Multiplayer.error("ReceiveEatBody: zombie " + s2 + " not found");
                return;
            }
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                if (!udpConnection2.RelevantTo(isoZombie.x, isoZombie.y)) continue;
                if (Core.bDebug) {
                    DebugLog.log(DebugType.Multiplayer, "SendEatBody");
                }
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.EatBody.doPacket(byteBufferWriter);
                byteBuffer.position(0);
                byteBufferWriter.bb.put(byteBuffer);
                PacketTypes.PacketType.EatBody.send(udpConnection2);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveEatBody: failed", LogSeverity.Error);
        }
    }

    public static void receiveSyncRadioData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            boolean bl = byteBuffer.get() == 1;
            int n = byteBuffer.getInt();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = byteBuffer.getInt();
            }
            RakVoice.SetChannelsRouting(udpConnection.getConnectedGUID(), bl, nArray, (short)n);
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                if (udpConnection2 == udpConnection || udpConnection.players[0] == null) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncRadioData.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(udpConnection.players[0].OnlineID);
                byteBuffer.position(0);
                byteBufferWriter.bb.put(byteBuffer);
                PacketTypes.PacketType.SyncRadioData.send(udpConnection2);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "SyncRadioData: failed", LogSeverity.Error);
        }
    }

    public static void receiveThump(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            short s2;
            IsoZombie isoZombie;
            if (Core.bDebug) {
                DebugLog.log(DebugType.Multiplayer, "ReceiveThump");
            }
            if ((isoZombie = ServerMap.instance.ZombieMap.get(s2 = byteBuffer.getShort())) == null) {
                DebugLog.Multiplayer.error("ReceiveThump: zombie " + s2 + " not found");
                return;
            }
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                if (!udpConnection2.RelevantTo(isoZombie.x, isoZombie.y)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.Thump.doPacket(byteBufferWriter);
                byteBuffer.position(0);
                byteBufferWriter.bb.put(byteBuffer);
                PacketTypes.PacketType.Thump.send(udpConnection2);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveEatBody: failed", LogSeverity.Error);
        }
    }

    public static void sendWorldSound(UdpConnection udpConnection, WorldSoundManager.WorldSound worldSound) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.WorldSound.doPacket(byteBufferWriter);
        try {
            byteBufferWriter.putInt(worldSound.x);
            byteBufferWriter.putInt(worldSound.y);
            byteBufferWriter.putInt(worldSound.z);
            byteBufferWriter.putInt(worldSound.radius);
            byteBufferWriter.putInt(worldSound.volume);
            byteBufferWriter.putByte(worldSound.stresshumans ? (byte)1 : 0);
            byteBufferWriter.putFloat(worldSound.zombieIgnoreDist);
            byteBufferWriter.putFloat(worldSound.stressMod);
            byteBufferWriter.putByte(worldSound.sourceIsZombie ? (byte)1 : 0);
            PacketTypes.PacketType.WorldSound.send(udpConnection);
        }
        catch (Exception exception) {
            DebugLog.Sound.printException(exception, "SendWorldSound: failed", LogSeverity.Error);
            udpConnection.cancelPacket();
        }
    }

    public static void sendWorldSound(WorldSoundManager.WorldSound worldSound, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection.getConnectedGUID() == udpConnection2.getConnectedGUID() || !udpConnection2.isFullyConnected() || (isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection2)) == null || !udpConnection2.RelevantTo(worldSound.x, worldSound.y, worldSound.radius)) continue;
            GameServer.sendWorldSound(udpConnection2, worldSound);
        }
    }

    static void receiveWorldSound(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        boolean bl = byteBuffer.get() == 1;
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        boolean bl2 = byteBuffer.get() == 1;
        DebugLog.Sound.noise("x=%d y=%d z=%d, radius=%d", n, n2, n3, n4);
        WorldSoundManager.WorldSound worldSound = WorldSoundManager.instance.addSound(null, n, n2, n3, n4, n5, bl, f, f2, bl2, false, true);
        if (worldSound != null) {
            GameServer.sendWorldSound(worldSound, udpConnection);
        }
    }

    public static void kick(UdpConnection udpConnection, String string, String string2) {
        DebugLog.General.warn("The player " + udpConnection.username + " was kicked. The reason was " + string + ", " + string2);
        ConnectionManager.log("kick", string2, udpConnection);
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        try {
            PacketTypes.PacketType.Kicked.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putUTF(string2);
            PacketTypes.PacketType.Kicked.send(udpConnection);
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "Kick: failed", LogSeverity.Error);
            udpConnection.cancelPacket();
        }
    }

    private static void sendStartRain(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.StartRain.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(RainManager.randRainMin);
        byteBufferWriter.putInt(RainManager.randRainMax);
        byteBufferWriter.putFloat(RainManager.RainDesiredIntensity);
        PacketTypes.PacketType.StartRain.send(udpConnection);
    }

    public static void startRain() {
        if (udpEngine == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            GameServer.sendStartRain(udpConnection);
        }
    }

    private static void sendStopRain(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.StopRain.doPacket(byteBufferWriter);
        PacketTypes.PacketType.StopRain.send(udpConnection);
    }

    public static void stopRain() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            GameServer.sendStopRain(udpConnection);
        }
    }

    private static void sendWeather(UdpConnection udpConnection) {
        GameTime gameTime = GameTime.getInstance();
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.Weather.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)gameTime.getDawn());
        byteBufferWriter.putByte((byte)gameTime.getDusk());
        byteBufferWriter.putByte(gameTime.isThunderDay() ? (byte)1 : 0);
        byteBufferWriter.putFloat(gameTime.Moon);
        byteBufferWriter.putFloat(gameTime.getAmbientMin());
        byteBufferWriter.putFloat(gameTime.getAmbientMax());
        byteBufferWriter.putFloat(gameTime.getViewDistMin());
        byteBufferWriter.putFloat(gameTime.getViewDistMax());
        byteBufferWriter.putFloat(IsoWorld.instance.getGlobalTemperature());
        byteBufferWriter.putUTF(IsoWorld.instance.getWeather());
        ErosionMain.getInstance().sendState(byteBufferWriter.bb);
        PacketTypes.PacketType.Weather.send(udpConnection);
    }

    public static void sendWeather() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            GameServer.sendWeather(udpConnection);
        }
    }

    private static boolean isInSameFaction(IsoPlayer isoPlayer, IsoPlayer isoPlayer2) {
        Faction faction = Faction.getPlayerFaction(isoPlayer);
        Faction faction2 = Faction.getPlayerFaction(isoPlayer2);
        return faction != null && faction == faction2;
    }

    private static boolean isInSameSafehouse(IsoPlayer isoPlayer, IsoPlayer isoPlayer2) {
        ArrayList<SafeHouse> arrayList = SafeHouse.getSafehouseList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SafeHouse safeHouse = arrayList.get(i);
            if (!safeHouse.playerAllowed(isoPlayer.getUsername()) || !safeHouse.playerAllowed(isoPlayer2.getUsername())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnyPlayerInSameFaction(UdpConnection udpConnection, IsoPlayer isoPlayer) {
        for (int i = 0; i < 4; ++i) {
            IsoPlayer isoPlayer2 = udpConnection.players[i];
            if (isoPlayer2 == null || !GameServer.isInSameFaction(isoPlayer2, isoPlayer)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnyPlayerInSameSafehouse(UdpConnection udpConnection, IsoPlayer isoPlayer) {
        for (int i = 0; i < 4; ++i) {
            IsoPlayer isoPlayer2 = udpConnection.players[i];
            if (isoPlayer2 == null || !GameServer.isInSameSafehouse(isoPlayer2, isoPlayer)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldSendWorldMapPlayerPosition(UdpConnection udpConnection, IsoPlayer isoPlayer) {
        if (isoPlayer == null || isoPlayer.isDead()) {
            return false;
        }
        UdpConnection udpConnection2 = GameServer.getConnectionFromPlayer(isoPlayer);
        if (udpConnection2 == null || udpConnection2 == udpConnection || !udpConnection2.isFullyConnected()) {
            return false;
        }
        if (udpConnection.accessLevel > 1) {
            return true;
        }
        int n = ServerOptions.getInstance().MapRemotePlayerVisibility.getValue();
        if (n == 2) {
            return GameServer.isAnyPlayerInSameFaction(udpConnection, isoPlayer) || GameServer.isAnyPlayerInSameSafehouse(udpConnection, isoPlayer);
        }
        return true;
    }

    private static void sendWorldMapPlayerPosition(UdpConnection udpConnection) {
        tempPlayers.clear();
        for (int i = 0; i < Players.size(); ++i) {
            IsoPlayer isoPlayer = Players.get(i);
            if (!GameServer.shouldSendWorldMapPlayerPosition(udpConnection, isoPlayer)) continue;
            tempPlayers.add(isoPlayer);
        }
        if (tempPlayers.isEmpty()) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.WorldMapPlayerPosition.doPacket(byteBufferWriter);
        byteBufferWriter.putBoolean(false);
        byteBufferWriter.putShort((short)tempPlayers.size());
        for (int i = 0; i < tempPlayers.size(); ++i) {
            IsoPlayer isoPlayer = tempPlayers.get(i);
            WorldMapRemotePlayer worldMapRemotePlayer = WorldMapRemotePlayers.instance.getOrCreatePlayer(isoPlayer);
            worldMapRemotePlayer.setPlayer(isoPlayer);
            byteBufferWriter.putShort(worldMapRemotePlayer.getOnlineID());
            byteBufferWriter.putShort(worldMapRemotePlayer.getChangeCount());
            byteBufferWriter.putFloat(worldMapRemotePlayer.getX());
            byteBufferWriter.putFloat(worldMapRemotePlayer.getY());
        }
        PacketTypes.PacketType.WorldMapPlayerPosition.send(udpConnection);
    }

    public static void sendWorldMapPlayerPosition() {
        int n = ServerOptions.getInstance().MapRemotePlayerVisibility.getValue();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (n == 1 && udpConnection.accessLevel == 1) continue;
            GameServer.sendWorldMapPlayerPosition(udpConnection);
        }
    }

    public static void receiveWorldMapPlayerPosition(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoPlayer isoPlayer;
        int n;
        int n2 = byteBuffer.getShort();
        tempPlayers.clear();
        for (int i = 0; i < n2; ++i) {
            n = byteBuffer.getShort();
            isoPlayer = IDToPlayerMap.get((short)n);
            if (isoPlayer == null || !GameServer.shouldSendWorldMapPlayerPosition(udpConnection, isoPlayer)) continue;
            tempPlayers.add(isoPlayer);
        }
        if (tempPlayers.isEmpty()) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.WorldMapPlayerPosition.doPacket(byteBufferWriter);
        byteBufferWriter.putBoolean(true);
        byteBufferWriter.putShort((short)tempPlayers.size());
        for (n = 0; n < tempPlayers.size(); ++n) {
            isoPlayer = tempPlayers.get(n);
            WorldMapRemotePlayer worldMapRemotePlayer = WorldMapRemotePlayers.instance.getOrCreatePlayer(isoPlayer);
            worldMapRemotePlayer.setPlayer(isoPlayer);
            byteBufferWriter.putShort(worldMapRemotePlayer.getOnlineID());
            byteBufferWriter.putShort(worldMapRemotePlayer.getChangeCount());
            byteBufferWriter.putUTF(worldMapRemotePlayer.getUsername());
            byteBufferWriter.putUTF(worldMapRemotePlayer.getForename());
            byteBufferWriter.putUTF(worldMapRemotePlayer.getSurname());
            byteBufferWriter.putUTF(worldMapRemotePlayer.getAccessLevel());
            byteBufferWriter.putFloat(worldMapRemotePlayer.getX());
            byteBufferWriter.putFloat(worldMapRemotePlayer.getY());
            byteBufferWriter.putBoolean(worldMapRemotePlayer.isInvisible());
        }
        PacketTypes.PacketType.WorldMapPlayerPosition.send(udpConnection);
    }

    private static void syncClock(UdpConnection udpConnection) {
        GameTime gameTime = GameTime.getInstance();
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncClock.doPacket(byteBufferWriter);
        byteBufferWriter.putBoolean(bFastForward);
        byteBufferWriter.putFloat(gameTime.getTimeOfDay());
        byteBufferWriter.putInt(gameTime.getNightsSurvived());
        PacketTypes.PacketType.SyncClock.send(udpConnection);
    }

    public static void syncClock() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            GameServer.syncClock(udpConnection);
        }
    }

    public static void sendServerCommand(String string, String string2, KahluaTable kahluaTable, UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ClientCommand.doPacket(byteBufferWriter);
        byteBufferWriter.putUTF(string);
        byteBufferWriter.putUTF(string2);
        if (kahluaTable == null || kahluaTable.isEmpty()) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
                while (kahluaTableIterator.advance()) {
                    if (TableNetworkUtils.canSave(kahluaTableIterator.getKey(), kahluaTableIterator.getValue())) continue;
                    DebugLog.log("ERROR: sendServerCommand: can't save key,value=" + kahluaTableIterator.getKey() + "," + kahluaTableIterator.getValue());
                }
                TableNetworkUtils.save(kahluaTable, byteBufferWriter.bb);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        PacketTypes.PacketType.ClientCommand.send(udpConnection);
    }

    public static void sendServerCommand(String string, String string2, KahluaTable kahluaTable) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            GameServer.sendServerCommand(string, string2, kahluaTable, udpConnection);
        }
    }

    public static void sendServerCommandV(String string, String string2, Object ... objectArray) {
        if (objectArray.length == 0) {
            GameServer.sendServerCommand(string, string2, null);
            return;
        }
        if (objectArray.length % 2 != 0) {
            DebugLog.log("ERROR: sendServerCommand called with invalid number of arguments (" + string + " " + string2 + ")");
            return;
        }
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i + 1];
            if (object instanceof Float) {
                kahluaTable.rawset(objectArray[i], (Object)((Float)object).doubleValue());
                continue;
            }
            if (object instanceof Integer) {
                kahluaTable.rawset(objectArray[i], (Object)((Integer)object).doubleValue());
                continue;
            }
            if (object instanceof Short) {
                kahluaTable.rawset(objectArray[i], (Object)((Short)object).doubleValue());
                continue;
            }
            kahluaTable.rawset(objectArray[i], object);
        }
        GameServer.sendServerCommand(string, string2, kahluaTable);
    }

    public static void sendServerCommand(IsoPlayer isoPlayer, String string, String string2, KahluaTable kahluaTable) {
        if (!PlayerToAddressMap.containsKey(isoPlayer)) {
            return;
        }
        long l = PlayerToAddressMap.get(isoPlayer);
        UdpConnection udpConnection = udpEngine.getActiveConnection(l);
        if (udpConnection == null) {
            return;
        }
        GameServer.sendServerCommand(string, string2, kahluaTable, udpConnection);
    }

    public static ArrayList<IsoPlayer> getPlayers(ArrayList<IsoPlayer> arrayList) {
        arrayList.clear();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < 4; ++j) {
                IsoPlayer isoPlayer = udpConnection.players[j];
                if (isoPlayer == null || isoPlayer.OnlineID == -1) continue;
                arrayList.add(isoPlayer);
            }
        }
        return arrayList;
    }

    public static ArrayList<IsoPlayer> getPlayers() {
        ArrayList<IsoPlayer> arrayList = new ArrayList<IsoPlayer>();
        return GameServer.getPlayers(arrayList);
    }

    public static int getPlayerCount() {
        int n = 0;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            for (int j = 0; j < 4; ++j) {
                if (udpConnection.playerIDs[j] == -1) continue;
                ++n;
            }
        }
        return n;
    }

    public static void sendAmbient(String string, int n, int n2, int n3, float f) {
        DebugLog.log(DebugType.Sound, "ambient: sending " + string + " at " + n + "," + n2 + " radius=" + n3);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            IsoPlayer isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection);
            if (isoPlayer == null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.AddAmbient.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putFloat(f);
            PacketTypes.PacketType.AddAmbient.send(udpConnection);
        }
    }

    static void receiveChangeSafety(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            SafetyPacket safetyPacket = new SafetyPacket();
            safetyPacket.parse(byteBuffer, udpConnection);
            safetyPacket.log(udpConnection, "ReceiveChangeSafety");
            safetyPacket.process();
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveZombieDeath: failed", LogSeverity.Error);
        }
    }

    public static void sendChangeSafety(Safety safety) {
        try {
            SafetyPacket safetyPacket = new SafetyPacket(safety);
            safetyPacket.log(null, "SendChangeSafety");
            for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.ChangeSafety.doPacket(byteBufferWriter);
                safetyPacket.write(byteBufferWriter);
                PacketTypes.PacketType.ChangeSafety.send(udpConnection);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "SendChangeSafety: failed", LogSeverity.Error);
        }
    }

    static void receivePing(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        udpConnection.ping = true;
        GameServer.answerPing(byteBuffer, udpConnection);
    }

    public static void updateOverlayForClients(IsoObject isoObject, String string, float f, float f2, float f3, float f4, UdpConnection udpConnection) {
        if (udpEngine == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2 == null || isoObject.square == null || !udpConnection2.RelevantTo(isoObject.square.x, isoObject.square.y) || udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.UpdateOverlaySprite.doPacket(byteBufferWriter);
            GameWindow.WriteStringUTF(byteBufferWriter.bb, string);
            byteBufferWriter.putInt(isoObject.getSquare().getX());
            byteBufferWriter.putInt(isoObject.getSquare().getY());
            byteBufferWriter.putInt(isoObject.getSquare().getZ());
            byteBufferWriter.putFloat(f);
            byteBufferWriter.putFloat(f2);
            byteBufferWriter.putFloat(f3);
            byteBufferWriter.putFloat(f4);
            byteBufferWriter.putInt(isoObject.getSquare().getObjects().indexOf(isoObject));
            PacketTypes.PacketType.UpdateOverlaySprite.send(udpConnection2);
        }
    }

    static void receiveUpdateOverlaySprite(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadStringUTF(byteBuffer);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        float f4 = byteBuffer.getFloat();
        int n4 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && n4 < isoGridSquare.getObjects().size()) {
            try {
                IsoObject isoObject = isoGridSquare.getObjects().get(n4);
                if (isoObject != null && isoObject.setOverlaySprite(string, f, f2, f3, f4, false)) {
                    GameServer.updateOverlayForClients(isoObject, string, f, f2, f3, f4, udpConnection);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void sendReanimatedZombieID(IsoPlayer isoPlayer, IsoZombie isoZombie) {
        if (PlayerToAddressMap.containsKey(isoPlayer)) {
            GameServer.sendObjectChange((IsoObject)isoPlayer, "reanimatedID", "ID", isoZombie.OnlineID);
        }
    }

    static void receiveSyncSafehouse(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        SyncSafehousePacket syncSafehousePacket = new SyncSafehousePacket();
        syncSafehousePacket.parse(byteBuffer, udpConnection);
        if (!syncSafehousePacket.validate(udpConnection)) {
            return;
        }
        syncSafehousePacket.process();
        GameServer.sendSafehouse(syncSafehousePacket, udpConnection);
        if (ChatServer.isInited()) {
            if (syncSafehousePacket.shouldCreateChat) {
                ChatServer.getInstance().createSafehouseChat(syncSafehousePacket.safehouse.getId());
            }
            if (syncSafehousePacket.remove) {
                ChatServer.getInstance().removeSafehouseChat(syncSafehousePacket.safehouse.getId());
            } else {
                ChatServer.getInstance().syncSafehouseChatMembers(syncSafehousePacket.safehouse.getId(), syncSafehousePacket.ownerUsername, syncSafehousePacket.safehouse.getPlayers());
            }
        }
    }

    public static void receiveKickOutOfSafehouse(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            IsoPlayer isoPlayer = IDToPlayerMap.get(byteBuffer.getShort());
            if (isoPlayer == null) {
                return;
            }
            IsoPlayer isoPlayer2 = udpConnection.players[0];
            if (isoPlayer2 == null) {
                return;
            }
            SafeHouse safeHouse = SafeHouse.hasSafehouse(isoPlayer2);
            if (safeHouse == null) {
                return;
            }
            if (!safeHouse.isOwner(isoPlayer2)) {
                return;
            }
            if (!safeHouse.playerAllowed(isoPlayer)) {
                return;
            }
            UdpConnection udpConnection2 = GameServer.getConnectionFromPlayer(isoPlayer);
            if (udpConnection2 == null) {
                return;
            }
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.KickOutOfSafehouse.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)isoPlayer.PlayerIndex);
            byteBufferWriter.putFloat(safeHouse.getX() - 1);
            byteBufferWriter.putFloat(safeHouse.getY() - 1);
            byteBufferWriter.putFloat(0.0f);
            PacketTypes.PacketType.KickOutOfSafehouse.send(udpConnection2);
            if (isoPlayer.getNetworkCharacterAI() != null) {
                isoPlayer.getNetworkCharacterAI().resetSpeedLimiter();
            }
            if (isoPlayer.isAsleep()) {
                isoPlayer.setAsleep(false);
                isoPlayer.setAsleepTime(0.0f);
                GameServer.sendWakeUpPlayer(isoPlayer, null);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveKickOutOfSafehouse: failed", LogSeverity.Error);
        }
    }

    public static void sendSafehouse(SyncSafehousePacket syncSafehousePacket, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SyncSafehouse.doPacket(byteBufferWriter);
            syncSafehousePacket.write(byteBufferWriter);
            PacketTypes.PacketType.SyncSafehouse.send(udpConnection2);
        }
    }

    public static void receiveRadioServerData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.RadioServerData.doPacket(byteBufferWriter);
        ZomboidRadio.getInstance().WriteRadioServerDataPacket(byteBufferWriter);
        PacketTypes.PacketType.RadioServerData.send(udpConnection);
    }

    public static void receiveRadioDeviceDataState(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        if (by == 1) {
            DeviceData deviceData;
            IsoObject isoObject;
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            if (isoGridSquare != null && n4 >= 0 && n4 < isoGridSquare.getObjects().size() && (isoObject = isoGridSquare.getObjects().get(n4)) instanceof IsoWaveSignal && (deviceData = ((IsoWaveSignal)isoObject).getDeviceData()) != null) {
                try {
                    deviceData.receiveDeviceDataStatePacket(byteBuffer, null);
                }
                catch (Exception exception) {
                    System.out.print(exception.getMessage());
                }
            }
        } else if (by == 0) {
            byte by2 = byteBuffer.get();
            IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by2);
            byte by3 = byteBuffer.get();
            if (isoPlayer != null) {
                Radio radio = null;
                if (by3 == 1 && isoPlayer.getPrimaryHandItem() instanceof Radio) {
                    radio = (Radio)isoPlayer.getPrimaryHandItem();
                }
                if (by3 == 2 && isoPlayer.getSecondaryHandItem() instanceof Radio) {
                    radio = (Radio)isoPlayer.getSecondaryHandItem();
                }
                if (radio != null && radio.getDeviceData() != null) {
                    try {
                        radio.getDeviceData().receiveDeviceDataStatePacket(byteBuffer, udpConnection);
                    }
                    catch (Exception exception) {
                        System.out.print(exception.getMessage());
                    }
                }
            }
        } else if (by == 2) {
            DeviceData deviceData;
            VehiclePart vehiclePart;
            short s2 = byteBuffer.getShort();
            short s3 = byteBuffer.getShort();
            BaseVehicle baseVehicle = VehicleManager.instance.getVehicleByID(s2);
            if (baseVehicle != null && (vehiclePart = baseVehicle.getPartByIndex(s3)) != null && (deviceData = vehiclePart.getDeviceData()) != null) {
                try {
                    deviceData.receiveDeviceDataStatePacket(byteBuffer, null);
                }
                catch (Exception exception) {
                    System.out.print(exception.getMessage());
                }
            }
        }
    }

    public static void sendIsoWaveSignal(long l, int n, int n2, int n3, String string, String string2, String string3, float f, float f2, float f3, int n4, boolean bl) {
        WaveSignal waveSignal = new WaveSignal();
        waveSignal.set(n, n2, n3, string, string2, string3, f, f2, f3, n4, bl);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (l == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.WaveSignal.doPacket(byteBufferWriter);
            waveSignal.write(byteBufferWriter);
            PacketTypes.PacketType.WaveSignal.send(udpConnection);
        }
    }

    public static void receiveWaveSignal(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        WaveSignal waveSignal = new WaveSignal();
        waveSignal.parse(byteBuffer, udpConnection);
        waveSignal.process(udpConnection);
    }

    public static void receivePlayerListensChannel(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n = byteBuffer.getInt();
        boolean bl = byteBuffer.get() == 1;
        boolean bl2 = byteBuffer.get() == 1;
        ZomboidRadio.getInstance().PlayerListensChannel(n, bl, bl2);
    }

    public static void sendAlarm(int n, int n2) {
        DebugLog.log(DebugType.Multiplayer, "SendAlarm at [ " + n + " , " + n2 + " ]");
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            IsoPlayer isoPlayer = GameServer.getAnyPlayerFromConnection(udpConnection);
            if (isoPlayer == null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.AddAlarm.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            PacketTypes.PacketType.AddAlarm.send(udpConnection);
        }
    }

    public static boolean isSpawnBuilding(BuildingDef buildingDef) {
        return SpawnPoints.instance.isSpawnBuilding(buildingDef);
    }

    private static void setFastForward(boolean bl) {
        if (bl == bFastForward) {
            return;
        }
        bFastForward = bl;
        GameServer.syncClock();
    }

    static void receiveSendCustomColor(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoObject isoObject;
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        float f3 = byteBuffer.getFloat();
        float f4 = byteBuffer.getFloat();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGridSquare != null && n4 < isoGridSquare.getObjects().size() && (isoObject = isoGridSquare.getObjects().get(n4)) != null) {
            isoObject.setCustomColor(f, f2, f3, f4);
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (!udpConnection2.RelevantTo(n, n2) || (udpConnection == null || udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) && udpConnection != null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SendCustomColor.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putInt(n4);
            byteBufferWriter.putFloat(f);
            byteBufferWriter.putFloat(f2);
            byteBufferWriter.putFloat(f3);
            byteBufferWriter.putFloat(f4);
            PacketTypes.PacketType.SendCustomColor.send(udpConnection2);
        }
    }

    static void receiveSyncFurnace(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        int n3 = byteBuffer.getInt();
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3, n2 = byteBuffer.getInt(), n = byteBuffer.getInt());
        if (isoGridSquare == null) {
            DebugLog.log("receiveFurnaceChange: square is null x,y,z=" + n3 + "," + n2 + "," + n);
            return;
        }
        BSFurnace bSFurnace = null;
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            if (!(isoGridSquare.getObjects().get(i) instanceof BSFurnace)) continue;
            bSFurnace = (BSFurnace)isoGridSquare.getObjects().get(i);
            break;
        }
        if (bSFurnace == null) {
            DebugLog.log("receiveFurnaceChange: furnace is null x,y,z=" + n3 + "," + n2 + "," + n);
            return;
        }
        bSFurnace.fireStarted = byteBuffer.get() == 1;
        bSFurnace.fuelAmount = byteBuffer.getFloat();
        bSFurnace.fuelDecrease = byteBuffer.getFloat();
        bSFurnace.heat = byteBuffer.getFloat();
        bSFurnace.sSprite = GameWindow.ReadString(byteBuffer);
        bSFurnace.sLitSprite = GameWindow.ReadString(byteBuffer);
        GameServer.sendFuranceChange(bSFurnace, udpConnection);
    }

    static void receiveVehicles(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        VehicleManager.instance.serverPacket(byteBuffer, udpConnection, s);
    }

    static void receiveTimeSync(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        GameTime.receiveTimeSync(byteBuffer, udpConnection);
    }

    public static void sendFuranceChange(BSFurnace bSFurnace, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (!udpConnection2.RelevantTo(bSFurnace.square.x, bSFurnace.square.y) || (udpConnection == null || udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) && udpConnection != null) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SyncFurnace.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(bSFurnace.square.x);
            byteBufferWriter.putInt(bSFurnace.square.y);
            byteBufferWriter.putInt(bSFurnace.square.z);
            byteBufferWriter.putByte(bSFurnace.isFireStarted() ? (byte)1 : 0);
            byteBufferWriter.putFloat(bSFurnace.getFuelAmount());
            byteBufferWriter.putFloat(bSFurnace.getFuelDecrease());
            byteBufferWriter.putFloat(bSFurnace.getHeat());
            GameWindow.WriteString(byteBufferWriter.bb, bSFurnace.sSprite);
            GameWindow.WriteString(byteBufferWriter.bb, bSFurnace.sLitSprite);
            PacketTypes.PacketType.SyncFurnace.send(udpConnection2);
        }
    }

    static void receiveUserlog(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        ArrayList<Userlog> arrayList = ServerWorldDatabase.instance.getUserlog(string);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() != udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.Userlog.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(arrayList.size());
            byteBufferWriter.putUTF(string);
            for (int j = 0; j < arrayList.size(); ++j) {
                Userlog userlog = arrayList.get(j);
                byteBufferWriter.putInt(Userlog.UserlogType.FromString(userlog.getType()).index());
                byteBufferWriter.putUTF(userlog.getText());
                byteBufferWriter.putUTF(userlog.getIssuedBy());
                byteBufferWriter.putInt(userlog.getAmount());
                byteBufferWriter.putUTF(userlog.getLastUpdate());
            }
            PacketTypes.PacketType.Userlog.send(udpConnection2);
        }
    }

    static void receiveAddUserlog(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        String string3 = GameWindow.ReadString(byteBuffer);
        ServerWorldDatabase.instance.addUserlog(string, Userlog.UserlogType.FromString(string2), string3, udpConnection.username, 1);
        LoggerManager.getLogger("admin").write(udpConnection.username + " added log on user " + string + ", log: " + string3);
    }

    static void receiveRemoveUserlog(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        String string3 = GameWindow.ReadString(byteBuffer);
        ServerWorldDatabase.instance.removeUserLog(string, string2, string3);
        LoggerManager.getLogger("admin").write(udpConnection.username + " removed log on user " + string + ", type:" + string2 + ", log: " + string3);
    }

    static void receiveAddWarningPoint(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        int n = byteBuffer.getInt();
        ServerWorldDatabase.instance.addWarningPoint(string, string2, n, udpConnection.username);
        LoggerManager.getLogger("admin").write(udpConnection.username + " added " + n + " warning point(s) on " + string + ", reason:" + string2);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (!udpConnection2.username.equals(string)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.WorldMessage.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(udpConnection.username);
            byteBufferWriter.putUTF(" gave you " + n + " warning point(s), reason: " + string2 + " ");
            PacketTypes.PacketType.WorldMessage.send(udpConnection2);
        }
    }

    public static void sendAdminMessage(String string, int n, int n2, int n3) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!GameServer.canSeePlayerStats(udpConnection)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.MessageForAdmin.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            PacketTypes.PacketType.MessageForAdmin.send(udpConnection);
        }
    }

    static void receiveWakeUpPlayer(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, byteBuffer.getShort());
        if (isoPlayer != null) {
            isoPlayer.setAsleep(false);
            isoPlayer.setAsleepTime(0.0f);
            GameServer.sendWakeUpPlayer(isoPlayer, udpConnection);
        }
    }

    public static void sendWakeUpPlayer(IsoPlayer isoPlayer, UdpConnection udpConnection) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.WakeUpPlayer.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(isoPlayer.getOnlineID());
            PacketTypes.PacketType.WakeUpPlayer.send(udpConnection2);
        }
    }

    static void receiveGetDBSchema(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        DBSchema dBSchema = ServerWorldDatabase.instance.getDBSchema();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection == null || udpConnection2.getConnectedGUID() != udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.GetDBSchema.doPacket(byteBufferWriter);
            HashMap<String, HashMap<String, String>> hashMap = dBSchema.getSchema();
            byteBufferWriter.putInt(hashMap.size());
            for (String string : hashMap.keySet()) {
                HashMap<String, String> hashMap2 = hashMap.get(string);
                byteBufferWriter.putUTF(string);
                byteBufferWriter.putInt(hashMap2.size());
                for (String string2 : hashMap2.keySet()) {
                    byteBufferWriter.putUTF(string2);
                    byteBufferWriter.putUTF(hashMap2.get(string2));
                }
            }
            PacketTypes.PacketType.GetDBSchema.send(udpConnection2);
        }
    }

    static void receiveGetTableResult(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        int n = byteBuffer.getInt();
        String string = GameWindow.ReadString(byteBuffer);
        ArrayList<DBResult> arrayList = ServerWorldDatabase.instance.getTableResult(string);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection == null || udpConnection2.getConnectedGUID() != udpConnection.getConnectedGUID()) continue;
            GameServer.doTableResult(udpConnection2, string, arrayList, 0, n);
        }
    }

    private static void doTableResult(UdpConnection udpConnection, String string, ArrayList<DBResult> arrayList, int n, int n2) {
        int n3 = 0;
        boolean bl = true;
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.GetTableResult.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(n);
        byteBufferWriter.putUTF(string);
        if (arrayList.size() < n2) {
            byteBufferWriter.putInt(arrayList.size());
        } else if (arrayList.size() - n < n2) {
            byteBufferWriter.putInt(arrayList.size() - n);
        } else {
            byteBufferWriter.putInt(n2);
        }
        for (int i = n; i < arrayList.size(); ++i) {
            DBResult dBResult = null;
            try {
                dBResult = arrayList.get(i);
                byteBufferWriter.putInt(dBResult.getColumns().size());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (String string2 : dBResult.getColumns()) {
                byteBufferWriter.putUTF(string2);
                byteBufferWriter.putUTF(dBResult.getValues().get(string2));
            }
            if (++n3 < n2) continue;
            bl = false;
            PacketTypes.PacketType.GetTableResult.send(udpConnection);
            GameServer.doTableResult(udpConnection, string, arrayList, n + n3, n2);
            break;
        }
        if (bl) {
            PacketTypes.PacketType.GetTableResult.send(udpConnection);
        }
    }

    static void receiveExecuteQuery(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        if (udpConnection.accessLevel != 32) {
            return;
        }
        try {
            String string = GameWindow.ReadString(byteBuffer);
            KahluaTable kahluaTable = LuaManager.platform.newTable();
            kahluaTable.load(byteBuffer, 195);
            ServerWorldDatabase.instance.executeQuery(string, kahluaTable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static void receiveSendFactionInvite(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        String string3 = GameWindow.ReadString(byteBuffer);
        IsoPlayer isoPlayer = GameServer.getPlayerByUserName(string3);
        if (isoPlayer == null) {
            return;
        }
        Long l = IDToAddressMap.get(isoPlayer.getOnlineID());
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SendFactionInvite.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putUTF(string2);
            PacketTypes.PacketType.SendFactionInvite.send(udpConnection2);
            break;
        }
    }

    static void receiveAcceptedFactionInvite(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        IsoPlayer isoPlayer = GameServer.getPlayerByUserName(string2);
        Long l = IDToAddressMap.get(isoPlayer.getOnlineID());
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            Faction faction;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() != l.longValue() || (faction = Faction.getPlayerFaction(udpConnection2.username)) == null || !faction.getName().equals(string)) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.AcceptedFactionInvite.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putUTF(string2);
            PacketTypes.PacketType.AcceptedFactionInvite.send(udpConnection2);
        }
    }

    static void receiveViewTickets(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        String string = GameWindow.ReadString(byteBuffer);
        if ("".equals(string)) {
            string = null;
        }
        GameServer.sendTickets(string, udpConnection);
    }

    private static void sendTickets(String string, UdpConnection udpConnection) throws SQLException {
        ArrayList<DBTicket> arrayList = ServerWorldDatabase.instance.getTickets(string);
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() != udpConnection.getConnectedGUID()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.ViewTickets.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(arrayList.size());
            for (int j = 0; j < arrayList.size(); ++j) {
                DBTicket dBTicket = arrayList.get(j);
                byteBufferWriter.putUTF(dBTicket.getAuthor());
                byteBufferWriter.putUTF(dBTicket.getMessage());
                byteBufferWriter.putInt(dBTicket.getTicketID());
                if (dBTicket.getAnswer() != null) {
                    byteBufferWriter.putByte((byte)1);
                    byteBufferWriter.putUTF(dBTicket.getAnswer().getAuthor());
                    byteBufferWriter.putUTF(dBTicket.getAnswer().getMessage());
                    byteBufferWriter.putInt(dBTicket.getAnswer().getTicketID());
                    continue;
                }
                byteBufferWriter.putByte((byte)0);
            }
            PacketTypes.PacketType.ViewTickets.send(udpConnection2);
            break;
        }
    }

    static void receiveAddTicket(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        int n = byteBuffer.getInt();
        if (n == -1) {
            GameServer.sendAdminMessage("user " + string + " added a ticket <LINE> <LINE> " + string2, -1, -1, -1);
        }
        ServerWorldDatabase.instance.addTicket(string, string2, n);
        GameServer.sendTickets(string, udpConnection);
    }

    static void receiveRemoveTicket(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) throws SQLException {
        int n = byteBuffer.getInt();
        ServerWorldDatabase.instance.removeTicket(n);
        GameServer.sendTickets(null, udpConnection);
    }

    public static boolean sendItemListNet(UdpConnection udpConnection, IsoPlayer isoPlayer, ArrayList<InventoryItem> arrayList, IsoPlayer isoPlayer2, String string, String string2) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection != null && udpConnection2 == udpConnection) continue;
            if (isoPlayer2 != null) {
                boolean bl = false;
                for (int j = 0; j < udpConnection2.players.length; ++j) {
                    IsoPlayer isoPlayer3 = udpConnection2.players[j];
                    if (isoPlayer3 == null || isoPlayer3 != isoPlayer2) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SendItemListNet.doPacket(byteBufferWriter);
            byteBufferWriter.putByte(isoPlayer2 != null ? (byte)1 : 0);
            if (isoPlayer2 != null) {
                byteBufferWriter.putShort(isoPlayer2.getOnlineID());
            }
            byteBufferWriter.putByte(isoPlayer != null ? (byte)1 : 0);
            if (isoPlayer != null) {
                byteBufferWriter.putShort(isoPlayer.getOnlineID());
            }
            GameWindow.WriteString(byteBufferWriter.bb, string);
            byteBufferWriter.putByte(string2 != null ? (byte)1 : 0);
            if (string2 != null) {
                GameWindow.WriteString(byteBufferWriter.bb, string2);
            }
            try {
                CompressIdenticalItems.save(byteBufferWriter.bb, arrayList, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                udpConnection2.cancelPacket();
                return false;
            }
            PacketTypes.PacketType.SendItemListNet.send(udpConnection2);
        }
        return true;
    }

    static void receiveSendItemListNet(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoPlayer isoPlayer = null;
        if (byteBuffer.get() == 1) {
            isoPlayer = IDToPlayerMap.get(byteBuffer.getShort());
        }
        IsoPlayer isoPlayer2 = null;
        if (byteBuffer.get() == 1) {
            isoPlayer2 = IDToPlayerMap.get(byteBuffer.getShort());
        }
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = null;
        if (byteBuffer.get() == 1) {
            string2 = GameWindow.ReadString(byteBuffer);
        }
        ArrayList<InventoryItem> arrayList = new ArrayList<InventoryItem>();
        try {
            CompressIdenticalItems.load(byteBuffer, 195, arrayList, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (isoPlayer == null) {
            LuaEventManager.triggerEvent("OnReceiveItemListNet", isoPlayer2, arrayList, isoPlayer, string, string2);
        } else {
            GameServer.sendItemListNet(udpConnection, isoPlayer2, arrayList, isoPlayer, string, string2);
        }
    }

    public static void sendPlayerDamagedByCarCrash(IsoPlayer isoPlayer, float f) {
        UdpConnection udpConnection = GameServer.getConnectionFromPlayer(isoPlayer);
        if (udpConnection == null) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.PlayerDamageFromCarCrash.doPacket(byteBufferWriter);
        byteBufferWriter.putFloat(f);
        PacketTypes.PacketType.PlayerDamageFromCarCrash.send(udpConnection);
    }

    static void receiveClimateManagerPacket(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ClimateManager climateManager = ClimateManager.getInstance();
        if (climateManager != null) {
            try {
                climateManager.receiveClimatePacket(byteBuffer, udpConnection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static void receivePassengerMap(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        PassengerMap.serverReceivePacket(byteBuffer, udpConnection);
    }

    static void receiveIsoRegionClientRequestFullUpdate(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        IsoRegions.receiveClientRequestFullDataChunks(byteBuffer, udpConnection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String isWorldVersionUnsupported() {
        File file = new File(ZomboidFileSystem.instance.getSaveDir() + File.separator + "Multiplayer" + File.separator + ServerName + File.separator + "map_t.bin");
        if (!file.exists()) {
            DebugLog.log("map_t.bin does not exist, cannot determine the server's WorldVersion.  This is ok the first time a server is started.");
            return null;
        }
        DebugLog.log("checking server WorldVersion in map_t.bin");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             DataInputStream dataInputStream = new DataInputStream(fileInputStream);){
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            byte by3 = dataInputStream.readByte();
            byte by4 = dataInputStream.readByte();
            if (by == 71 && by2 == 77 && by3 == 84 && by4 == 77) {
                int n = dataInputStream.readInt();
                if (n > 195) {
                    String string = "The server savefile appears to be from a newer version of the game and cannot be loaded.";
                    return string;
                }
                if (n > 143) return null;
                String string = "The server savefile appears to be from a pre-animations version of the game and cannot be loaded.\nDue to the extent of changes required to implement animations, saves from earlier versions are not compatible.";
                return string;
            }
            String string = "The server savefile appears to be from an old version of the game and cannot be loaded.";
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getPoisonousBerry() {
        return this.poisonousBerry;
    }

    public void setPoisonousBerry(String string) {
        this.poisonousBerry = string;
    }

    public String getPoisonousMushroom() {
        return this.poisonousMushroom;
    }

    public void setPoisonousMushroom(String string) {
        this.poisonousMushroom = string;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(String string) {
        this.difficulty = string;
    }

    public static void transmitBrokenGlass(IsoGridSquare isoGridSquare) {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            try {
                if (!udpConnection.RelevantTo(isoGridSquare.getX(), isoGridSquare.getY())) continue;
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.AddBrokenGlass.doPacket(byteBufferWriter);
                byteBufferWriter.putInt((short)isoGridSquare.getX());
                byteBufferWriter.putInt((short)isoGridSquare.getY());
                byteBufferWriter.putInt((short)isoGridSquare.getZ());
                PacketTypes.PacketType.AddBrokenGlass.send(udpConnection);
                continue;
            }
            catch (Throwable throwable) {
                udpConnection.cancelPacket();
                ExceptionLogger.logException(throwable);
            }
        }
    }

    public static boolean isServerDropPackets() {
        return droppedPackets > 0;
    }

    static void receiveSyncPerks(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (isoPlayer == null) {
            return;
        }
        isoPlayer.remoteSneakLvl = n;
        isoPlayer.remoteStrLvl = n2;
        isoPlayer.remoteFitLvl = n3;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer2;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer2 = GameServer.getAnyPlayerFromConnection(udpConnection)) == null) continue;
            try {
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncPerks.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(isoPlayer.OnlineID);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putInt(n3);
                PacketTypes.PacketType.SyncPerks.send(udpConnection2);
                continue;
            }
            catch (Throwable throwable) {
                udpConnection.cancelPacket();
                ExceptionLogger.logException(throwable);
            }
        }
    }

    static void receiveSyncWeight(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        double d = byteBuffer.getDouble();
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer2;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer2 = GameServer.getAnyPlayerFromConnection(udpConnection)) == null) continue;
            try {
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncWeight.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(isoPlayer.OnlineID);
                byteBufferWriter.putDouble(d);
                PacketTypes.PacketType.SyncWeight.send(udpConnection2);
                continue;
            }
            catch (Throwable throwable) {
                udpConnection.cancelPacket();
                ExceptionLogger.logException(throwable);
            }
        }
    }

    static void receiveSyncEquippedRadioFreq(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        byte by = byteBuffer.get();
        int n = byteBuffer.getInt();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(byteBuffer.getInt());
        }
        IsoPlayer isoPlayer = GameServer.getPlayerFromConnection(udpConnection, by);
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            IsoPlayer isoPlayer2;
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID() || (isoPlayer2 = GameServer.getAnyPlayerFromConnection(udpConnection)) == null) continue;
            try {
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncEquippedRadioFreq.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(isoPlayer.OnlineID);
                byteBufferWriter.putInt(n);
                for (int j = 0; j < arrayList.size(); ++j) {
                    byteBufferWriter.putInt((Integer)arrayList.get(j));
                }
                PacketTypes.PacketType.SyncEquippedRadioFreq.send(udpConnection2);
                continue;
            }
            catch (Throwable throwable) {
                udpConnection.cancelPacket();
                ExceptionLogger.logException(throwable);
            }
        }
    }

    static void receiveGlobalModData(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        GlobalModData.instance.receive(byteBuffer);
    }

    static void receiveGlobalModDataRequest(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        GlobalModData.instance.receiveRequest(byteBuffer, udpConnection);
    }

    static void receiveSendSafehouseInvite(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        String string3 = GameWindow.ReadString(byteBuffer);
        IsoPlayer isoPlayer = GameServer.getPlayerByUserName(string3);
        Long l = IDToAddressMap.get(isoPlayer.getOnlineID());
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            if (udpConnection2.getConnectedGUID() != l.longValue()) continue;
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.SendSafehouseInvite.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putUTF(string2);
            byteBufferWriter.putInt(n);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putInt(n4);
            PacketTypes.PacketType.SendSafehouseInvite.send(udpConnection2);
            break;
        }
    }

    static void receiveAcceptedSafehouseInvite(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        int n;
        int n2;
        int n3;
        String string = GameWindow.ReadString(byteBuffer);
        String string2 = GameWindow.ReadString(byteBuffer);
        String string3 = GameWindow.ReadString(byteBuffer);
        int n4 = byteBuffer.getInt();
        SafeHouse safeHouse = SafeHouse.getSafeHouse(n4, n3 = byteBuffer.getInt(), n2 = byteBuffer.getInt(), n = byteBuffer.getInt());
        if (safeHouse != null) {
            safeHouse.addPlayer(string3);
        } else {
            DebugLog.log("WARN: player '" + string3 + "' accepted the invitation, but the safehouse not found for x=" + n4 + " y=" + n3 + " w=" + n2 + " h=" + n);
        }
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
            ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
            PacketTypes.PacketType.AcceptedSafehouseInvite.doPacket(byteBufferWriter);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putUTF(string2);
            byteBufferWriter.putUTF(string3);
            byteBufferWriter.putInt(n4);
            byteBufferWriter.putInt(n3);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putInt(n);
            PacketTypes.PacketType.AcceptedSafehouseInvite.send(udpConnection2);
        }
    }

    public static void sendRadioPostSilence() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (udpConnection.statistic.enable != 3) continue;
            GameServer.sendShortStatistic(udpConnection);
        }
    }

    public static void sendRadioPostSilence(UdpConnection udpConnection) {
        try {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.RadioPostSilenceEvent.doPacket(byteBufferWriter);
            byteBufferWriter.putByte(ZomboidRadio.POST_RADIO_SILENCE ? (byte)1 : 0);
            PacketTypes.PacketType.RadioPostSilenceEvent.send(udpConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            udpConnection.cancelPacket();
        }
    }

    static void receiveSneezeCough(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        byte by = byteBuffer.get();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer != null) {
            float f = isoPlayer.x;
            float f2 = isoPlayer.y;
            int n = GameServer.udpEngine.connections.size();
            for (int i = 0; i < n; ++i) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                if (udpConnection.getConnectedGUID() == udpConnection2.getConnectedGUID() || !udpConnection2.RelevantTo(f, f2)) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SneezeCough.doPacket(byteBufferWriter);
                byteBufferWriter.putShort(s2);
                byteBufferWriter.putByte(by);
                PacketTypes.PacketType.SneezeCough.send(udpConnection2);
            }
        }
    }

    static void receiveBurnCorpse(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        IsoPlayer isoPlayer = IDToPlayerMap.get(s2);
        if (isoPlayer == null) {
            DebugLog.Network.warn("Player not found by id " + s2);
            return;
        }
        IsoDeadBody isoDeadBody = IsoDeadBody.getDeadBody(s3);
        if (isoDeadBody == null) {
            DebugLog.Network.warn("Corpse not found by id " + s3);
            return;
        }
        float f = IsoUtils.DistanceTo(isoPlayer.x, isoPlayer.y, isoDeadBody.x, isoDeadBody.y);
        if (f <= 1.8f) {
            IsoFireManager.StartFire(isoDeadBody.getCell(), isoDeadBody.getSquare(), true, 100);
        } else {
            DebugLog.Network.warn("Distance between player and corpse too big: " + f);
        }
    }

    public static void sendValidatePacket(UdpConnection udpConnection, boolean bl, boolean bl2, boolean bl3) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        try {
            ValidatePacket validatePacket = new ValidatePacket();
            validatePacket.setSalt(udpConnection.validator.getSalt(), bl, bl2, bl3);
            PacketTypes.PacketType.Validate.doPacket(byteBufferWriter);
            validatePacket.write(byteBufferWriter);
            PacketTypes.PacketType.Validate.send(udpConnection);
            validatePacket.log(GameClient.connection, "send-packet");
        }
        catch (Exception exception) {
            udpConnection.cancelPacket();
            DebugLog.Multiplayer.printException(exception, "SendValidatePacket: failed", LogSeverity.Error);
        }
    }

    static void receiveValidatePacket(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        ValidatePacket validatePacket = new ValidatePacket();
        validatePacket.parse(byteBuffer, udpConnection);
        validatePacket.log(GameClient.connection, "receive-packet");
        if (validatePacket.isConsistent()) {
            validatePacket.process(udpConnection);
        }
    }

    static {
        bServer = false;
        bCoop = false;
        bDebug = false;
        bSoftReset = false;
        IDToAddressMap = new HashMap();
        IDToPlayerMap = new HashMap();
        Players = new ArrayList();
        timeSinceKeepAlive = 0.0f;
        MaxTicksSinceKeepAliveBeforeStall = 60;
        DebugPlayer = new HashSet();
        ResetID = 0;
        ServerMods = new ArrayList();
        WorkshopItems = new ArrayList();
        ServerName = "servertest";
        discordBot = new DiscordBot(ServerName, (string, string2) -> ChatServer.getInstance().sendMessageFromDiscordToGeneralChat(string, string2));
        checksum = "";
        GameMap = "Muldraugh, KY";
        transactionIDMap = new HashMap();
        worldObjectsServerSyncReq = new ObjectsSyncRequests(false);
        ip = "127.0.0.1";
        count = 0;
        SlotToConnection = new UdpConnection[512];
        PlayerToAddressMap = new HashMap();
        alreadyRemoved = new ArrayList();
        launched = false;
        consoleCommands = new ArrayList();
        MainLoopPlayerUpdate = new HashMap();
        MainLoopPlayerUpdateQ = new ConcurrentLinkedQueue();
        MainLoopNetDataHighPriorityQ = new ConcurrentLinkedQueue();
        MainLoopNetDataQ = new ConcurrentLinkedQueue();
        MainLoopNetData2 = new ArrayList();
        playerToCoordsMap = new HashMap();
        playerMovedToFastMap = new HashMap();
        large_file_bb = ByteBuffer.allocate(0x200000);
        previousSave = Calendar.getInstance().getTimeInMillis();
        droppedPackets = 0;
        countOfDroppedPackets = 0;
        countOfDroppedConnections = 0;
        removeZombiesConnection = null;
        calcCountPlayersInRelevantPositionLimiter = new UpdateLimit(2000L);
        sendWorldMapPlayerPositionLimiter = new UpdateLimit(1000L);
        loginQueue = new LoginQueue();
        mainCycleExceptionLogCount = 25;
        tempPlayers = new ArrayList();
    }

    private static class DelayedConnection
    implements IZomboidPacket {
        public UdpConnection connection;
        public boolean connect;
        public String hostString;

        public DelayedConnection(UdpConnection udpConnection, boolean bl) {
            this.connection = udpConnection;
            this.connect = bl;
            if (bl) {
                try {
                    this.hostString = udpConnection.getInetSocketAddress().getHostString();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        public boolean isConnect() {
            return this.connect;
        }

        @Override
        public boolean isDisconnect() {
            return !this.connect;
        }
    }

    private static class s_performance {
        static final PerformanceProfileFrameProbe frameStep = new PerformanceProfileFrameProbe("GameServer.frameStep");
        static final PerformanceProfileProbe mainLoopDealWithNetData = new PerformanceProfileProbe("GameServer.mainLoopDealWithNetData");
        static final PerformanceProfileProbe RCONServerUpdate = new PerformanceProfileProbe("RCONServer.update");

        private s_performance() {
        }
    }

    private static final class CCFilter {
        String command;
        boolean allow;
        CCFilter next;

        private CCFilter() {
        }

        boolean matches(String string) {
            return this.command.equals(string) || "*".equals(this.command);
        }

        boolean passes(String string) {
            if (this.matches(string)) {
                return this.allow;
            }
            if (this.next == null) {
                return true;
            }
            return this.next.passes(string);
        }
    }
}

