/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import fmod.fmod.FMODManager;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.CRC32;
import org.json.JSONObject;
import zombie.characters.NetworkCharacter;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.ThreadGroups;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.RakNetPeerInterface;
import zombie.core.raknet.RakVoice;
import zombie.core.raknet.VoiceManager;
import zombie.core.secure.PZcrypt;
import zombie.core.utils.UpdateLimit;
import zombie.core.znet.ZNet;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoDirections;
import zombie.iso.IsoUtils;
import zombie.iso.Vector2;
import zombie.network.NetworkVariables;
import zombie.network.PacketTypes;
import zombie.network.packets.PlayerPacket;
import zombie.network.packets.SyncInjuriesPacket;
import zombie.network.packets.ZombiePacket;

public class FakeClientManager {
    private static final int SERVER_PORT = 16261;
    private static final int CLIENT_PORT = 17500;
    private static final String CLIENT_ADDRESS = "0.0.0.0";
    private static final String versionNumber = Core.getInstance().getVersion();
    private static final DateFormat logDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final ThreadLocal<StringUTF> stringUTF = ThreadLocal.withInitial(StringUTF::new);
    private static int logLevel = 0;
    private static long startTime = System.currentTimeMillis();
    private static final HashSet<Player> players = new HashSet();

    public static String ReadStringUTF(ByteBuffer byteBuffer) {
        return stringUTF.get().load(byteBuffer);
    }

    public static void WriteStringUTF(ByteBuffer byteBuffer, String string) {
        stringUTF.get().save(byteBuffer, string);
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<Integer, Movement> load(String string) {
        HashMap<Integer, Movement> hashMap = new HashMap<Integer, Movement>();
        try {
            JSONObject jSONObject;
            String string2 = new String(Files.readAllBytes(Paths.get(string, new String[0])));
            JSONObject jSONObject2 = new JSONObject(string2);
            Movement.version = jSONObject2.getString("version");
            JSONObject jSONObject3 = jSONObject2.getJSONObject("config");
            JSONObject jSONObject4 = jSONObject3.getJSONObject("client");
            JSONObject jSONObject5 = jSONObject4.getJSONObject("connection");
            if (jSONObject5.has("serverHost")) {
                Client.connectionServerHost = jSONObject5.getString("serverHost");
            }
            Client.connectionInterval = jSONObject5.getLong("interval");
            Client.connectionTimeout = jSONObject5.getLong("timeout");
            Client.connectionDelay = jSONObject5.getLong("delay");
            Object object = jSONObject4.getJSONObject("statistics");
            Client.statisticsPeriod = object.getInt("period");
            Client.statisticsClientID = Math.max(object.getInt("id"), -1);
            if (jSONObject4.has("checksum")) {
                jSONObject = jSONObject4.getJSONObject("checksum");
                Client.luaChecksum = jSONObject.getString("lua");
                Client.scriptChecksum = jSONObject.getString("script");
            }
            if (jSONObject3.has("zombies")) {
                jSONObject5 = jSONObject3.getJSONObject("zombies");
                object = ZombieSimulator.Behaviour.Normal;
                if (jSONObject5.has("behaviour")) {
                    object = ZombieSimulator.Behaviour.valueOf(jSONObject5.getString("behaviour"));
                }
                ZombieSimulator.behaviour = object;
                if (jSONObject5.has("maxZombiesPerUpdate")) {
                    ZombieSimulator.maxZombiesPerUpdate = jSONObject5.getInt("maxZombiesPerUpdate");
                }
                if (jSONObject5.has("deleteZombieDistance")) {
                    int n = jSONObject5.getInt("deleteZombieDistance");
                    ZombieSimulator.deleteZombieDistanceSquared = n * n;
                }
                if (jSONObject5.has("forgotZombieDistance")) {
                    int n = jSONObject5.getInt("forgotZombieDistance");
                    ZombieSimulator.forgotZombieDistanceSquared = n * n;
                }
                if (jSONObject5.has("canSeeZombieDistance")) {
                    int n = jSONObject5.getInt("canSeeZombieDistance");
                    ZombieSimulator.canSeeZombieDistanceSquared = n * n;
                }
                if (jSONObject5.has("seeZombieDistance")) {
                    int n = jSONObject5.getInt("seeZombieDistance");
                    ZombieSimulator.seeZombieDistanceSquared = n * n;
                }
                if (jSONObject5.has("canChangeTarget")) {
                    ZombieSimulator.canChangeTarget = jSONObject5.getBoolean("canChangeTarget");
                }
            }
            jSONObject5 = jSONObject3.getJSONObject("player");
            Player.fps = jSONObject5.getInt("fps");
            Player.predictInterval = jSONObject5.getInt("predict");
            if (jSONObject5.has("damage")) {
                Player.damage = (float)jSONObject5.getDouble("damage");
            }
            if (jSONObject5.has("voip")) {
                Player.isVOIPEnabled = jSONObject5.getBoolean("voip");
            }
            object = jSONObject3.getJSONObject("movement");
            Movement.defaultRadius = object.getInt("radius");
            jSONObject = object.getJSONObject("motion");
            Movement.aimSpeed = jSONObject.getInt("aim");
            Movement.sneakSpeed = jSONObject.getInt("sneak");
            Movement.sneakRunSpeed = jSONObject.getInt("sneakrun");
            Movement.walkSpeed = jSONObject.getInt("walk");
            Movement.runSpeed = jSONObject.getInt("run");
            Movement.sprintSpeed = jSONObject.getInt("sprint");
            Object object2 = jSONObject.getJSONObject("pedestrian");
            Movement.pedestrianSpeedMin = object2.getInt("min");
            Movement.pedestrianSpeedMax = object2.getInt("max");
            JSONObject jSONObject6 = jSONObject.getJSONObject("vehicle");
            Movement.vehicleSpeedMin = jSONObject6.getInt("min");
            Movement.vehicleSpeedMax = jSONObject6.getInt("max");
            jSONObject4 = jSONObject2.getJSONArray("movements");
            for (int i = 0; i < jSONObject4.length(); ++i) {
                int n;
                Object object3;
                Object object4;
                Object object5;
                object = jSONObject4.getJSONObject(i);
                int n2 = object.getInt("id");
                object2 = null;
                if (object.has("description")) {
                    object2 = object.getString("description");
                }
                int n3 = (int)Math.round(Math.random() * 6000.0 + 6000.0);
                int n4 = (int)Math.round(Math.random() * 6000.0 + 6000.0);
                if (object.has("spawn")) {
                    object5 = object.getJSONObject("spawn");
                    n3 = object5.getInt("x");
                    n4 = object5.getInt("y");
                }
                Movement.Motion motion = object5 = Math.random() > (double)0.8f ? Movement.Motion.Vehicle : Movement.Motion.Pedestrian;
                if (object.has("motion")) {
                    object5 = Movement.Motion.valueOf(object.getString("motion"));
                }
                int n5 = 0;
                if (object.has("speed")) {
                    n5 = object.getInt("speed");
                } else {
                    switch (1.$SwitchMap$zombie$network$FakeClientManager$Movement$Motion[((Enum)object5).ordinal()]) {
                        case 1: {
                            n5 = Movement.aimSpeed;
                            break;
                        }
                        case 2: {
                            n5 = Movement.sneakSpeed;
                            break;
                        }
                        case 3: {
                            n5 = Movement.sneakRunSpeed;
                            break;
                        }
                        case 6: {
                            n5 = Movement.walkSpeed;
                            break;
                        }
                        case 4: {
                            n5 = Movement.runSpeed;
                            break;
                        }
                        case 5: {
                            n5 = Movement.sprintSpeed;
                            break;
                        }
                        case 7: {
                            n5 = (int)Math.round(Math.random() * (double)(Movement.pedestrianSpeedMax - Movement.pedestrianSpeedMin) + (double)Movement.pedestrianSpeedMin);
                            break;
                        }
                        case 8: {
                            n5 = (int)Math.round(Math.random() * (double)(Movement.vehicleSpeedMax - Movement.vehicleSpeedMin) + (double)Movement.vehicleSpeedMin);
                        }
                    }
                }
                Movement.Type type = Movement.Type.Line;
                if (object.has("type")) {
                    type = Movement.Type.valueOf(object.getString("type"));
                }
                int n6 = Movement.defaultRadius;
                if (object.has("radius")) {
                    n6 = object.getInt("radius");
                }
                IsoDirections isoDirections = IsoDirections.fromIndex((int)Math.round(Math.random() * 7.0));
                if (object.has("direction")) {
                    isoDirections = IsoDirections.valueOf(object.getString("direction"));
                }
                boolean bl = false;
                if (object.has("ghost")) {
                    bl = object.getBoolean("ghost");
                }
                long l = (long)n2 * Client.connectionInterval;
                if (object.has("connect")) {
                    l = object.getLong("connect");
                }
                long l2 = 0L;
                if (object.has("disconnect")) {
                    l2 = object.getLong("disconnect");
                }
                long l3 = 0L;
                if (object.has("reconnect")) {
                    l3 = object.getLong("reconnect");
                }
                long l4 = 0L;
                if (object.has("teleport")) {
                    l4 = object.getLong("teleport");
                }
                int n7 = (int)Math.round(Math.random() * 6000.0 + 6000.0);
                int n8 = (int)Math.round(Math.random() * 6000.0 + 6000.0);
                if (object.has("destination")) {
                    object4 = object.getJSONObject("destination");
                    n7 = object4.getInt("x");
                    n8 = object4.getInt("y");
                }
                object4 = null;
                if (object.has("createHorde")) {
                    object3 = object.getJSONObject("createHorde");
                    int n9 = object3.getInt("count");
                    n = object3.getInt("radius");
                    long l5 = object3.getLong("interval");
                    if (l5 != 0L) {
                        object4 = new HordeCreator(n, n9, l5);
                    }
                }
                object3 = null;
                if (object.has("makeSound")) {
                    JSONObject jSONObject7 = object.getJSONObject("makeSound");
                    n = jSONObject7.getInt("interval");
                    int n10 = jSONObject7.getInt("radius");
                    String string3 = jSONObject7.getString("message");
                    if (n != 0) {
                        object3 = new SoundMaker(n, n10, string3);
                    }
                }
                Movement movement = new Movement(n2, (String)object2, n3, n4, (Movement.Motion)((Object)object5), n5, type, n6, n7, n8, isoDirections, bl, l, l2, l3, l4, (HordeCreator)object4, (SoundMaker)object3);
                if (hashMap.containsKey(n2)) {
                    FakeClientManager.error(n2, String.format("Client %d already exists", movement.id));
                    continue;
                }
                hashMap.put(n2, movement);
            }
        }
        catch (Exception exception) {
            FakeClientManager.error(-1, "Scenarios file load failed");
            exception.printStackTrace();
        }
        finally {
            return hashMap;
        }
    }

    private static void error(int n, String string) {
        System.out.print(String.format("%5s : %s , [%2d] > %s\n", "ERROR", logDateFormat.format(Calendar.getInstance().getTime()), n, string));
    }

    private static void info(int n, String string) {
        if (logLevel >= 0) {
            System.out.print(String.format("%5s : %s , [%2d] > %s\n", "INFO", logDateFormat.format(Calendar.getInstance().getTime()), n, string));
        }
    }

    private static void log(int n, String string) {
        if (logLevel >= 1) {
            System.out.print(String.format("%5s : %s , [%2d] > %s\n", "LOG", logDateFormat.format(Calendar.getInstance().getTime()), n, string));
        }
    }

    private static void trace(int n, String string) {
        if (logLevel >= 2) {
            System.out.print(String.format("%5s : %s , [%2d] > %s\n", "TRACE", logDateFormat.format(Calendar.getInstance().getTime()), n, string));
        }
    }

    public static boolean isVOIPEnabled() {
        return Player.isVOIPEnabled && FakeClientManager.getOnlineID() != -1L && FakeClientManager.getConnectedGUID() != -1L;
    }

    public static long getConnectedGUID() {
        if (players.isEmpty()) {
            return -1L;
        }
        return FakeClientManager.players.iterator().next().client.connectionGUID;
    }

    public static long getOnlineID() {
        if (players.isEmpty()) {
            return -1L;
        }
        return FakeClientManager.players.iterator().next().OnlineID;
    }

    public static void main(String[] stringArray) {
        Network network;
        int n;
        Object object;
        String string = null;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-scenarios=")) {
                string = stringArray[i].replace("-scenarios=", "").trim();
                continue;
            }
            if (!stringArray[i].startsWith("-id=")) continue;
            n2 = Integer.parseInt(stringArray[i].replace("-id=", "").trim());
        }
        if (string == null || string.isBlank()) {
            FakeClientManager.error(-1, "Invalid scenarios file name");
            System.exit(0);
        }
        Rand.init();
        System.loadLibrary("RakNet64");
        System.loadLibrary("ZNetNoSteam64");
        try {
            object = System.getProperty("zomboid.znetlog");
            if (object != null) {
                logLevel = Integer.parseInt((String)object);
                ZNet.init();
                ZNet.SetLogLevel(logLevel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            FakeClientManager.error(-1, "Invalid log arguments");
        }
        DebugLog.setLogEnabled(DebugType.General, false);
        object = FakeClientManager.load(string);
        if (Player.isVOIPEnabled) {
            FMODManager.instance.init();
            VoiceManager.instance.InitVMClient();
            VoiceManager.instance.setMode(1);
        }
        if (n2 != -1) {
            n = 17500 + n2;
            network = new Network(((HashMap)object).size(), n);
        } else {
            n = 17500;
            network = new Network(((HashMap)object).size(), n);
        }
        if (network.isStarted()) {
            int n3 = 0;
            if (n2 != -1) {
                Movement movement = (Movement)((HashMap)object).get(n2);
                if (movement != null) {
                    players.add(new Player(movement, network, n3, n));
                } else {
                    FakeClientManager.error(n2, "Client movement not found");
                }
            } else {
                for (Movement movement : ((HashMap)object).values()) {
                    players.add(new Player(movement, network, n3++, n));
                }
            }
            while (!players.isEmpty()) {
                FakeClientManager.sleep(1000L);
            }
        }
    }

    private static class StringUTF {
        private char[] chars;
        private ByteBuffer byteBuffer;
        private CharBuffer charBuffer;
        private CharsetEncoder ce;
        private CharsetDecoder cd;

        private StringUTF() {
        }

        private int encode(String string) {
            int n;
            if (this.chars == null || this.chars.length < string.length()) {
                n = (string.length() + 128 - 1) / 128 * 128;
                this.chars = new char[n];
                this.charBuffer = CharBuffer.wrap(this.chars);
            }
            string.getChars(0, string.length(), this.chars, 0);
            this.charBuffer.limit(string.length());
            this.charBuffer.position(0);
            if (this.ce == null) {
                this.ce = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.ce.reset();
            n = (int)((double)string.length() * (double)this.ce.maxBytesPerChar());
            n = (n + 128 - 1) / 128 * 128;
            if (this.byteBuffer == null || this.byteBuffer.capacity() < n) {
                this.byteBuffer = ByteBuffer.allocate(n);
            }
            this.byteBuffer.clear();
            CoderResult coderResult = this.ce.encode(this.charBuffer, this.byteBuffer, true);
            return this.byteBuffer.position();
        }

        private String decode(int n) {
            if (this.cd == null) {
                this.cd = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.cd.reset();
            int n2 = (int)((double)n * (double)this.cd.maxCharsPerByte());
            if (this.chars == null || this.chars.length < n2) {
                int n3 = (n2 + 128 - 1) / 128 * 128;
                this.chars = new char[n3];
                this.charBuffer = CharBuffer.wrap(this.chars);
            }
            this.charBuffer.clear();
            CoderResult coderResult = this.cd.decode(this.byteBuffer, this.charBuffer, true);
            return new String(this.chars, 0, this.charBuffer.position());
        }

        void save(ByteBuffer byteBuffer, String string) {
            if (string == null || string.isEmpty()) {
                byteBuffer.putShort((short)0);
                return;
            }
            int n = this.encode(string);
            byteBuffer.putShort((short)n);
            this.byteBuffer.flip();
            byteBuffer.put(this.byteBuffer);
        }

        String load(ByteBuffer byteBuffer) {
            short s = byteBuffer.getShort();
            if (s <= 0) {
                return "";
            }
            int n = (s + 128 - 1) / 128 * 128;
            if (this.byteBuffer == null || this.byteBuffer.capacity() < n) {
                this.byteBuffer = ByteBuffer.allocate(n);
            }
            this.byteBuffer.clear();
            if (byteBuffer.remaining() < s) {
                DebugLog.General.error("GameWindow.StringUTF.load> numBytes:" + s + " is higher than the remaining bytes in the buffer:" + byteBuffer.remaining());
            }
            int n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + s);
            this.byteBuffer.put(byteBuffer);
            byteBuffer.limit(n2);
            this.byteBuffer.flip();
            return this.decode(s);
        }
    }

    private static class Movement {
        static String version;
        static int defaultRadius;
        static int aimSpeed;
        static int sneakSpeed;
        static int walkSpeed;
        static int sneakRunSpeed;
        static int runSpeed;
        static int sprintSpeed;
        static int pedestrianSpeedMin;
        static int pedestrianSpeedMax;
        static int vehicleSpeedMin;
        static int vehicleSpeedMax;
        static final float zombieLungeDistanceSquared = 100.0f;
        static final float zombieWalkSpeed = 3.0f;
        static final float zombieLungeSpeed = 6.0f;
        final int id;
        final String description;
        final Vector2 spawn;
        Motion motion;
        float speed;
        final Type type;
        final int radius;
        final IsoDirections direction;
        final Vector2 destination;
        final boolean ghost;
        final long connectDelay;
        final long disconnectDelay;
        final long reconnectDelay;
        final long teleportDelay;
        final HordeCreator hordeCreator;
        SoundMaker soundMaker;
        long timestamp;

        public Movement(int n, String string, int n2, int n3, Motion motion, int n4, Type type, int n5, int n6, int n7, IsoDirections isoDirections, boolean bl, long l, long l2, long l3, long l4, HordeCreator hordeCreator, SoundMaker soundMaker) {
            this.id = n;
            this.description = string;
            this.spawn = new Vector2(n2, n3);
            this.motion = motion;
            this.speed = n4;
            this.type = type;
            this.radius = n5;
            this.direction = isoDirections;
            this.destination = new Vector2(n6, n7);
            this.ghost = bl;
            this.connectDelay = l;
            this.disconnectDelay = l2;
            this.reconnectDelay = l3;
            this.teleportDelay = l4;
            this.hordeCreator = hordeCreator;
            this.soundMaker = soundMaker;
        }

        public void connect(int n) {
            long l = System.currentTimeMillis();
            if (this.disconnectDelay != 0L) {
                FakeClientManager.info(this.id, String.format("Player %3d connect in %.3fs, disconnect in %.3fs", n, Float.valueOf((float)(l - this.timestamp) / 1000.0f), Float.valueOf((float)this.disconnectDelay / 1000.0f)));
            } else {
                FakeClientManager.info(this.id, String.format("Player %3d connect in %.3fs", n, Float.valueOf((float)(l - this.timestamp) / 1000.0f)));
            }
            this.timestamp = l;
        }

        public void disconnect(int n) {
            long l = System.currentTimeMillis();
            if (this.reconnectDelay != 0L) {
                FakeClientManager.info(this.id, String.format("Player %3d disconnect in %.3fs, reconnect in %.3fs", n, Float.valueOf((float)(l - this.timestamp) / 1000.0f), Float.valueOf((float)this.reconnectDelay / 1000.0f)));
            } else {
                FakeClientManager.info(this.id, String.format("Player %3d disconnect in %.3fs", n, Float.valueOf((float)(l - this.timestamp) / 1000.0f)));
            }
            this.timestamp = l;
        }

        public boolean doTeleport() {
            return this.teleportDelay != 0L;
        }

        public boolean doDisconnect() {
            return this.disconnectDelay != 0L;
        }

        public boolean checkDisconnect() {
            return System.currentTimeMillis() - this.timestamp > this.disconnectDelay;
        }

        public boolean doReconnect() {
            return this.reconnectDelay != 0L;
        }

        public boolean checkReconnect() {
            return System.currentTimeMillis() - this.timestamp > this.reconnectDelay;
        }

        static {
            defaultRadius = 150;
            aimSpeed = 4;
            sneakSpeed = 6;
            walkSpeed = 7;
            sneakRunSpeed = 10;
            runSpeed = 13;
            sprintSpeed = 19;
            pedestrianSpeedMin = 5;
            pedestrianSpeedMax = 20;
            vehicleSpeedMin = 40;
            vehicleSpeedMax = 80;
        }

        private static enum Motion {
            Aim,
            Sneak,
            Walk,
            SneakRun,
            Run,
            Sprint,
            Pedestrian,
            Vehicle;

        }

        private static enum Type {
            Stay,
            Line,
            Circle,
            AIAttackZombies,
            AIRunAwayFromZombies,
            AIRunToAnotherPlayers,
            AINormal;

        }
    }

    private static class Client {
        private static String connectionServerHost = "127.0.0.1";
        private static long connectionInterval = 1500L;
        private static long connectionTimeout = 10000L;
        private static long connectionDelay = 15000L;
        private static int statisticsClientID = -1;
        private static int statisticsPeriod = 1;
        private static long serverTimeShift = 0L;
        private static boolean serverTimeShiftIsSet = false;
        private final HashMap<Integer, Request> requests = new HashMap();
        private final Player player;
        private final Network network;
        private final int connectionIndex;
        private final int port;
        private long connectionGUID = -1L;
        private int requestId = 0;
        private long stateTime;
        private State state;
        private String host;
        public static String luaChecksum = "";
        public static String scriptChecksum = "";

        private Client(Player player, Network network, int n, int n2) {
            this.connectionIndex = n;
            this.network = network;
            this.player = player;
            this.port = n2;
            try {
                this.host = InetAddress.getByName(connectionServerHost).getHostAddress();
                this.state = State.CONNECT;
                Thread thread = new Thread(ThreadGroups.Workers, this::updateThread, this.player.username);
                thread.setDaemon(true);
                thread.start();
            }
            catch (UnknownHostException unknownHostException) {
                this.state = State.QUIT;
                unknownHostException.printStackTrace();
            }
        }

        private void updateThread() {
            FakeClientManager.info(this.player.movement.id, String.format("Start client (%d) %s:%d => %s:%d / \"%s\"", this.connectionIndex, FakeClientManager.CLIENT_ADDRESS, this.port, this.host, 16261, this.player.movement.description));
            FakeClientManager.sleep(this.player.movement.connectDelay);
            switch (this.player.movement.type) {
                case Circle: {
                    this.player.circleMovement();
                    break;
                }
                case Line: {
                    this.player.lineMovement();
                    break;
                }
                case AIAttackZombies: {
                    this.player.aiAttackZombiesMovement();
                    break;
                }
                case AIRunAwayFromZombies: {
                    this.player.aiRunAwayFromZombiesMovement();
                    break;
                }
                case AIRunToAnotherPlayers: {
                    this.player.aiRunToAnotherPlayersMovement();
                    break;
                }
                case AINormal: {
                    this.player.aiNormalMovement();
                }
            }
            while (this.state != State.QUIT) {
                this.update();
                FakeClientManager.sleep(1L);
            }
            FakeClientManager.info(this.player.movement.id, String.format("Stop client (%d) %s:%d => %s:%d / \"%s\"", this.connectionIndex, FakeClientManager.CLIENT_ADDRESS, this.port, this.host, 16261, this.player.movement.description));
        }

        private void updateTime() {
            this.stateTime = System.currentTimeMillis();
        }

        private long getServerTime() {
            return serverTimeShiftIsSet ? System.nanoTime() + serverTimeShift : 0L;
        }

        private boolean checkConnectionTimeout() {
            return System.currentTimeMillis() - this.stateTime > connectionTimeout;
        }

        private boolean checkConnectionDelay() {
            return System.currentTimeMillis() - this.stateTime > connectionDelay;
        }

        private void changeState(State state) {
            this.updateTime();
            FakeClientManager.log(this.player.movement.id, String.format("%s >> %s", new Object[]{this.state, state}));
            if (State.RUN.equals((Object)state)) {
                this.player.movement.connect(this.player.OnlineID);
                if (this.player.teleportLimiter == null) {
                    this.player.teleportLimiter = new UpdateLimit(this.player.movement.teleportDelay);
                }
                if (this.player.movement.id == statisticsClientID) {
                    this.sendTimeSync();
                    this.sendInjuries();
                    this.sendStatisticsEnable(statisticsPeriod);
                }
            } else if (State.DISCONNECT.equals((Object)state) && !State.DISCONNECT.equals((Object)this.state)) {
                this.player.movement.disconnect(this.player.OnlineID);
            }
            this.state = state;
        }

        private void update() {
            switch (this.state) {
                case CONNECT: {
                    this.player.movement.timestamp = System.currentTimeMillis();
                    this.network.connect(this.player.movement.id, this.host);
                    this.changeState(State.WAIT);
                    break;
                }
                case LOGIN: {
                    this.sendPlayerLogin();
                    this.changeState(State.WAIT);
                    break;
                }
                case PLAYER_CONNECT: {
                    this.sendPlayerConnect();
                    this.changeState(State.WAIT);
                    break;
                }
                case CHECKSUM: {
                    this.sendChecksum();
                    this.changeState(State.WAIT);
                    break;
                }
                case PLAYER_EXTRA_INFO: {
                    this.sendPlayerExtraInfo(this.player.movement.ghost, this.player.movement.hordeCreator != null || Player.isVOIPEnabled);
                    this.sendEquip();
                    this.changeState(State.WAIT);
                    break;
                }
                case LOAD: {
                    this.requestId = 0;
                    this.requests.clear();
                    this.requestFullUpdate();
                    this.requestLargeAreaZip();
                    this.changeState(State.WAIT);
                    break;
                }
                case RUN: {
                    if (this.player.movement.doDisconnect() && this.player.movement.checkDisconnect()) {
                        this.changeState(State.DISCONNECT);
                        break;
                    }
                    this.player.run();
                    break;
                }
                case WAIT: {
                    if (!this.checkConnectionTimeout()) break;
                    this.changeState(State.DISCONNECT);
                    break;
                }
                case DISCONNECT: {
                    if (this.network.isConnected()) {
                        this.player.movement.timestamp = System.currentTimeMillis();
                        this.network.disconnect(this.connectionGUID, this.player.movement.id, this.host);
                    }
                    if ((!this.player.movement.doReconnect() || !this.player.movement.checkReconnect()) && (this.player.movement.doReconnect() || !this.checkConnectionDelay())) break;
                    this.changeState(State.CONNECT);
                    break;
                }
            }
        }

        private void receive(short s, ByteBuffer byteBuffer) {
            PacketTypes.PacketType packetType = PacketTypes.packetTypes.get(s);
            Network.logUserPacket(this.player.movement.id, s);
            switch (packetType) {
                case PlayerConnect: {
                    if (!this.receivePlayerConnect(byteBuffer)) break;
                    if (luaChecksum.isEmpty()) {
                        this.changeState(State.PLAYER_EXTRA_INFO);
                        break;
                    }
                    this.changeState(State.CHECKSUM);
                    break;
                }
                case ExtraInfo: {
                    if (!this.receivePlayerExtraInfo(byteBuffer)) break;
                    this.changeState(State.RUN);
                    break;
                }
                case SentChunk: {
                    if (this.state != State.WAIT || !this.receiveChunkPart(byteBuffer)) break;
                    this.updateTime();
                    if (!this.allChunkPartsReceived()) break;
                    this.changeState(State.PLAYER_CONNECT);
                    break;
                }
                case NotRequiredInZip: {
                    if (this.state != State.WAIT || !this.receiveNotRequired(byteBuffer)) break;
                    this.updateTime();
                    if (!this.allChunkPartsReceived()) break;
                    this.changeState(State.PLAYER_CONNECT);
                    break;
                }
                case HitCharacter: {
                    break;
                }
                case StatisticRequest: {
                    this.receiveStatistics(byteBuffer);
                    break;
                }
                case TimeSync: {
                    this.receiveTimeSync(byteBuffer);
                    break;
                }
                case SyncClock: {
                    this.receiveSyncClock(byteBuffer);
                    break;
                }
                case ZombieSimulation: 
                case ZombieSimulationReliable: {
                    this.receiveZombieSimulation(byteBuffer);
                    break;
                }
                case PlayerUpdate: 
                case PlayerUpdateReliable: {
                    this.player.playerManager.parsePlayer(byteBuffer);
                    break;
                }
                case PlayerTimeout: {
                    this.player.playerManager.parsePlayerTimeout(byteBuffer);
                    break;
                }
                case Kicked: {
                    this.receiveKicked(byteBuffer);
                    break;
                }
                case Checksum: {
                    this.receiveChecksum(byteBuffer);
                    break;
                }
                case KillZombie: {
                    this.receiveKillZombie(byteBuffer);
                    break;
                }
                case Teleport: {
                    this.receiveTeleport(byteBuffer);
                    break;
                }
            }
            byteBuffer.clear();
        }

        private void doPacket(short s, ByteBuffer byteBuffer) {
            byteBuffer.put((byte)-122);
            byteBuffer.putShort(s);
        }

        private void putUTF(ByteBuffer byteBuffer, String string) {
            if (string == null) {
                byteBuffer.putShort((short)0);
            } else {
                byte[] byArray = string.getBytes();
                byteBuffer.putShort((short)byArray.length);
                byteBuffer.put(byArray);
            }
        }

        private void putBoolean(ByteBuffer byteBuffer, boolean bl) {
            byteBuffer.put((byte)(bl ? 1 : 0));
        }

        private void sendPlayerLogin() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.Login.getId(), byteBuffer);
            this.putUTF(byteBuffer, this.player.username);
            this.putUTF(byteBuffer, this.player.username);
            this.putUTF(byteBuffer, versionNumber);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void sendPlayerConnect() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.PlayerConnect.getId(), byteBuffer);
            this.writePlayerConnectData(byteBuffer);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void writePlayerConnectData(ByteBuffer byteBuffer) {
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)13);
            byteBuffer.putFloat(this.player.x);
            byteBuffer.putFloat(this.player.y);
            byteBuffer.putFloat(this.player.z);
            byteBuffer.putInt(0);
            this.putUTF(byteBuffer, this.player.username);
            this.putUTF(byteBuffer, this.player.username);
            this.putUTF(byteBuffer, this.player.isFemale == 0 ? "Kate" : "Male");
            byteBuffer.putInt(this.player.isFemale);
            this.putUTF(byteBuffer, "fireofficer");
            byteBuffer.putInt(0);
            byteBuffer.putInt(4);
            this.putUTF(byteBuffer, "Sprinting");
            byteBuffer.putInt(1);
            this.putUTF(byteBuffer, "Fitness");
            byteBuffer.putInt(6);
            this.putUTF(byteBuffer, "Strength");
            byteBuffer.putInt(6);
            this.putUTF(byteBuffer, "Axe");
            byteBuffer.putInt(1);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)Math.round(Math.random() * 5.0));
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            int n = this.player.clothes.size();
            byteBuffer.put((byte)n);
            for (Player.Clothes clothes : this.player.clothes) {
                byteBuffer.put(clothes.flags);
                this.putUTF(byteBuffer, "Base." + clothes.name);
                this.putUTF(byteBuffer, null);
                this.putUTF(byteBuffer, clothes.name);
                byteBuffer.put((byte)-1);
                byteBuffer.put((byte)-1);
                byteBuffer.put((byte)-1);
                byteBuffer.put(clothes.text);
                byteBuffer.putFloat(0.0f);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
            }
            this.putUTF(byteBuffer, "fake_str");
            byteBuffer.putShort((short)0);
            byteBuffer.putInt(2);
            this.putUTF(byteBuffer, "Fit");
            this.putUTF(byteBuffer, "Stout");
            byteBuffer.putFloat(0.0f);
            byteBuffer.putInt(0);
            byteBuffer.putInt(0);
            byteBuffer.putInt(4);
            this.putUTF(byteBuffer, "Sprinting");
            byteBuffer.putFloat(75.0f);
            this.putUTF(byteBuffer, "Fitness");
            byteBuffer.putFloat(67500.0f);
            this.putUTF(byteBuffer, "Strength");
            byteBuffer.putFloat(67500.0f);
            this.putUTF(byteBuffer, "Axe");
            byteBuffer.putFloat(75.0f);
            byteBuffer.putInt(4);
            this.putUTF(byteBuffer, "Sprinting");
            byteBuffer.putInt(1);
            this.putUTF(byteBuffer, "Fitness");
            byteBuffer.putInt(6);
            this.putUTF(byteBuffer, "Strength");
            byteBuffer.putInt(6);
            this.putUTF(byteBuffer, "Axe");
            byteBuffer.putInt(1);
            byteBuffer.putInt(0);
            this.putBoolean(byteBuffer, true);
            this.putUTF(byteBuffer, "fake");
            byteBuffer.putFloat(this.player.tagColor.r);
            byteBuffer.putFloat(this.player.tagColor.g);
            byteBuffer.putFloat(this.player.tagColor.b);
            byteBuffer.putInt(0);
            byteBuffer.putDouble(0.0);
            byteBuffer.putInt(0);
            this.putUTF(byteBuffer, this.player.username);
            byteBuffer.putFloat(this.player.speakColor.r);
            byteBuffer.putFloat(this.player.speakColor.g);
            byteBuffer.putFloat(this.player.speakColor.b);
            this.putBoolean(byteBuffer, true);
            this.putBoolean(byteBuffer, false);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.putInt(0);
            byteBuffer.putInt(0);
        }

        private void sendPlayerExtraInfo(boolean bl, boolean bl2) {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.ExtraInfo.getId(), byteBuffer);
            byteBuffer.putShort(this.player.OnlineID);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(bl ? 1 : 0));
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(Player.isVOIPEnabled ? 1 : 0));
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void sendSyncRadioData() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.SyncRadioData.getId(), byteBuffer);
            byteBuffer.put((byte)(Player.isVOIPEnabled ? 1 : 0));
            byteBuffer.putInt(4);
            byteBuffer.putInt(0);
            byteBuffer.putInt((int)RakVoice.GetMaxDistance());
            byteBuffer.putInt((int)this.player.x);
            byteBuffer.putInt((int)this.player.y);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void sendEquip() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.Equip.getId(), byteBuffer);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)1);
            byteBuffer.putInt(16);
            byteBuffer.putShort(this.player.registry_id);
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.player.weapon_id);
            byteBuffer.put((byte)0);
            byteBuffer.putInt(0);
            byteBuffer.putInt(0);
            byteBuffer.put((byte)0);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void sendChatMessage(String string) {
            ByteBuffer byteBuffer = this.network.startPacket();
            byteBuffer.putShort(this.player.OnlineID);
            byteBuffer.putInt(2);
            this.putUTF(byteBuffer, this.player.username);
            this.putUTF(byteBuffer, string);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private int getBooleanVariables() {
            int n = 0;
            if (this.player.movement.speed > 0.0f) {
                switch (this.player.movement.motion) {
                    case Aim: {
                        n |= 0x40;
                        break;
                    }
                    case Sneak: {
                        n |= 1;
                        break;
                    }
                    case SneakRun: {
                        n |= 0x11;
                        break;
                    }
                    case Run: {
                        n |= 0x10;
                        break;
                    }
                    case Sprint: {
                        n |= 0x20;
                    }
                }
                n |= 0x4400;
            }
            return n;
        }

        private void sendPlayer(NetworkCharacter.Transform transform, int n, Vector2 vector22) {
            PlayerPacket playerPacket = new PlayerPacket();
            playerPacket.id = this.player.OnlineID;
            playerPacket.x = transform.position.x;
            playerPacket.y = transform.position.y;
            playerPacket.z = (byte)this.player.z;
            playerPacket.direction = vector22.getDirection();
            playerPacket.usePathFinder = false;
            playerPacket.moveType = NetworkVariables.PredictionTypes.None;
            playerPacket.VehicleID = (short)-1;
            playerPacket.VehicleSeat = (short)-1;
            playerPacket.booleanVariables = this.getBooleanVariables();
            playerPacket.footstepSoundRadius = 0;
            playerPacket.bleedingLevel = 0;
            playerPacket.realx = this.player.x;
            playerPacket.realy = this.player.y;
            playerPacket.realz = (byte)this.player.z;
            playerPacket.realdir = (byte)IsoDirections.fromAngleActual(this.player.direction).index();
            playerPacket.realt = n;
            playerPacket.collidePointX = -1.0f;
            playerPacket.collidePointY = -1.0f;
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.PlayerUpdateReliable.getId(), byteBuffer);
            ByteBufferWriter byteBufferWriter = new ByteBufferWriter(byteBuffer);
            playerPacket.write(byteBufferWriter);
            this.network.endPacket(this.connectionGUID);
        }

        private boolean receivePlayerConnect(ByteBuffer byteBuffer) {
            short s = byteBuffer.getShort();
            if (s == -1) {
                byte by = byteBuffer.get();
                this.player.OnlineID = s = byteBuffer.getShort();
                return true;
            }
            return false;
        }

        private boolean receivePlayerExtraInfo(ByteBuffer byteBuffer) {
            short s = byteBuffer.getShort();
            return s == this.player.OnlineID;
        }

        private boolean receiveChunkPart(ByteBuffer byteBuffer) {
            boolean bl = false;
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            int n6 = byteBuffer.getInt();
            if (this.requests.remove(n) != null) {
                bl = true;
            }
            return bl;
        }

        private boolean receiveNotRequired(ByteBuffer byteBuffer) {
            boolean bl = false;
            int n = byteBuffer.getInt();
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                int n2 = byteBuffer.getInt();
                boolean bl3 = bl2 = byteBuffer.get() == 1;
                if (this.requests.remove(n2) == null) continue;
                bl = true;
            }
            return bl;
        }

        private boolean allChunkPartsReceived() {
            return this.requests.size() == 0;
        }

        private void addChunkRequest(int n, int n2, int n3, int n4) {
            Request request = new Request(n, n2, this.requestId);
            ++this.requestId;
            this.requests.put(request.id, request);
        }

        private void requestZipList() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.RequestZipList.getId(), byteBuffer);
            byteBuffer.putInt(this.requests.size());
            for (Request request : this.requests.values()) {
                byteBuffer.putInt(request.id);
                byteBuffer.putInt(request.wx);
                byteBuffer.putInt(request.wy);
                byteBuffer.putLong(request.crc);
            }
            this.network.endPacket(this.connectionGUID);
        }

        private void requestLargeAreaZip() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.RequestLargeAreaZip.getId(), byteBuffer);
            byteBuffer.putInt(this.player.WorldX);
            byteBuffer.putInt(this.player.WorldY);
            byteBuffer.putInt(13);
            this.network.endPacketImmediate(this.connectionGUID);
            int n = this.player.WorldX - 6 + 2;
            int n2 = this.player.WorldY - 6 + 2;
            int n3 = this.player.WorldX + 6 + 2;
            int n4 = this.player.WorldY + 6 + 2;
            for (int i = n2; i <= n4; ++i) {
                for (int j = n; j <= n3; ++j) {
                    Request request = new Request(j, i, this.requestId);
                    ++this.requestId;
                    this.requests.put(request.id, request);
                }
            }
            this.requestZipList();
        }

        private void requestFullUpdate() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.IsoRegionClientRequestFullUpdate.getId(), byteBuffer);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void requestChunkObjectState() {
            for (Request request : this.requests.values()) {
                ByteBuffer byteBuffer = this.network.startPacket();
                this.doPacket(PacketTypes.PacketType.ChunkObjectState.getId(), byteBuffer);
                byteBuffer.putShort((short)request.wx);
                byteBuffer.putShort((short)request.wy);
                this.network.endPacket(this.connectionGUID);
            }
        }

        private void requestChunks() {
            if (!this.requests.isEmpty()) {
                this.requestZipList();
                this.requestChunkObjectState();
                this.requests.clear();
            }
        }

        private void sendStatisticsEnable(int n) {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.StatisticRequest.getId(), byteBuffer);
            byteBuffer.put((byte)3);
            byteBuffer.putInt(n);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void receiveStatistics(ByteBuffer byteBuffer) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            long l3 = byteBuffer.getLong();
            long l4 = byteBuffer.getLong();
            long l5 = byteBuffer.getLong();
            long l6 = byteBuffer.getLong();
            long l7 = byteBuffer.getLong();
            long l8 = byteBuffer.getLong();
            long l9 = byteBuffer.getLong();
            FakeClientManager.info(this.player.movement.id, String.format("ServerStats: con=[%2d] fps=[%2d] tps=[%2d] upt=[%4d-%4d/%4d], c1=[%d] c2=[%d] c3=[%d]", l6, l4, l5, l, l2, l3, l7, l8, l9));
        }

        private void sendTimeSync() {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.TimeSync.getId(), byteBuffer);
            long l = System.nanoTime();
            byteBuffer.putLong(l);
            byteBuffer.putLong(0L);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void receiveTimeSync(ByteBuffer byteBuffer) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            long l3 = System.nanoTime();
            long l4 = l3 - l;
            long l5 = l2 - l3 + l4 / 2L;
            long l6 = serverTimeShift;
            serverTimeShift = !serverTimeShiftIsSet ? l5 : (long)((float)serverTimeShift + (float)(l5 - serverTimeShift) * 0.05f);
            long l7 = 10000000L;
            if (Math.abs(serverTimeShift - l6) > l7) {
                this.sendTimeSync();
            } else {
                serverTimeShiftIsSet = true;
            }
        }

        private void receiveSyncClock(ByteBuffer byteBuffer) {
            FakeClientManager.trace(this.player.movement.id, String.format("Player %3d sync clock", this.player.OnlineID));
        }

        private void receiveKicked(ByteBuffer byteBuffer) {
            String string = FakeClientManager.ReadStringUTF(byteBuffer);
            FakeClientManager.info(this.player.movement.id, String.format("Client kicked. Reason: %s", string));
        }

        private void receiveChecksum(ByteBuffer byteBuffer) {
            boolean bl;
            FakeClientManager.trace(this.player.movement.id, String.format("Player %3d receive Checksum", this.player.OnlineID));
            short s = byteBuffer.getShort();
            boolean bl2 = byteBuffer.get() == 1;
            boolean bl3 = bl = byteBuffer.get() == 1;
            if (s != 1 || !bl2 || !bl) {
                FakeClientManager.info(this.player.movement.id, String.format("checksum lua: %b, script: %b", bl2, bl));
            }
            this.changeState(State.PLAYER_EXTRA_INFO);
        }

        private void receiveKillZombie(ByteBuffer byteBuffer) {
            FakeClientManager.trace(this.player.movement.id, String.format("Player %3d receive KillZombie", this.player.OnlineID));
            short s = byteBuffer.getShort();
            Zombie zombie = this.player.simulator.zombies.get(s);
            if (zombie != null) {
                this.player.simulator.zombies4Delete.add(zombie);
            }
        }

        private void receiveTeleport(ByteBuffer byteBuffer) {
            byte by = byteBuffer.get();
            float f = byteBuffer.getFloat();
            float f2 = byteBuffer.getFloat();
            float f3 = byteBuffer.getFloat();
            FakeClientManager.info(this.player.movement.id, String.format("Player %3d teleport to (%d, %d)", this.player.OnlineID, (int)f, (int)f2));
            this.player.x = f;
            this.player.y = f2;
        }

        private void receiveZombieSimulation(ByteBuffer byteBuffer) {
            short s;
            short s2;
            this.player.simulator.clear();
            boolean bl = byteBuffer.get() == 1;
            short s3 = byteBuffer.getShort();
            for (s2 = 0; s2 < s3; s2 = (short)(s2 + 1)) {
                s = byteBuffer.getShort();
                Zombie zombie = this.player.simulator.zombies.get(s);
                this.player.simulator.zombies4Delete.add(zombie);
            }
            s2 = byteBuffer.getShort();
            for (s = 0; s < s2; s = (short)(s + 1)) {
                short s4 = byteBuffer.getShort();
                this.player.simulator.add(s4);
            }
            this.player.simulator.receivePacket(byteBuffer);
            this.player.simulator.process();
        }

        private void sendInjuries() {
            SyncInjuriesPacket syncInjuriesPacket = new SyncInjuriesPacket();
            syncInjuriesPacket.id = this.player.OnlineID;
            syncInjuriesPacket.strafeSpeed = 1.0f;
            syncInjuriesPacket.walkSpeed = 1.0f;
            syncInjuriesPacket.walkInjury = 0.0f;
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.SyncInjuries.getId(), byteBuffer);
            ByteBufferWriter byteBufferWriter = new ByteBufferWriter(byteBuffer);
            syncInjuriesPacket.write(byteBufferWriter);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void sendChecksum() {
            if (luaChecksum.isEmpty()) {
                return;
            }
            FakeClientManager.trace(this.player.movement.id, String.format("Player %3d sendChecksum", this.player.OnlineID));
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.Checksum.getId(), byteBuffer);
            byteBuffer.putShort((short)1);
            this.putUTF(byteBuffer, luaChecksum);
            this.putUTF(byteBuffer, scriptChecksum);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        public void sendCommand(String string) {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.ReceiveCommand.getId(), byteBuffer);
            FakeClientManager.WriteStringUTF(byteBuffer, string);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void sendEventPacket(short s, int n, int n2, int n3, byte by, String string) {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.EventPacket.getId(), byteBuffer);
            byteBuffer.putShort(s);
            byteBuffer.putFloat(n);
            byteBuffer.putFloat(n2);
            byteBuffer.putFloat(n3);
            byteBuffer.put(by);
            FakeClientManager.WriteStringUTF(byteBuffer, string);
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            byteBuffer.putFloat(1.0f);
            byteBuffer.putFloat(1.0f);
            byteBuffer.putFloat(0.0f);
            byteBuffer.putInt(0);
            byteBuffer.putShort((short)0);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private void sendWorldSound4Player(int n, int n2, int n3, int n4, int n5) {
            ByteBuffer byteBuffer = this.network.startPacket();
            this.doPacket(PacketTypes.PacketType.WorldSound.getId(), byteBuffer);
            byteBuffer.putInt(n);
            byteBuffer.putInt(n2);
            byteBuffer.putInt(n3);
            byteBuffer.putInt(n4);
            byteBuffer.putInt(n5);
            byteBuffer.put((byte)0);
            byteBuffer.putFloat(0.0f);
            byteBuffer.putFloat(1.0f);
            byteBuffer.put((byte)0);
            this.network.endPacketImmediate(this.connectionGUID);
        }

        private static enum State {
            CONNECT,
            LOGIN,
            CHECKSUM,
            PLAYER_CONNECT,
            PLAYER_EXTRA_INFO,
            LOAD,
            RUN,
            WAIT,
            DISCONNECT,
            QUIT;

        }

        private static final class Request {
            private final int id;
            private final int wx;
            private final int wy;
            private final long crc;

            private Request(int n, int n2, int n3) {
                this.id = n3;
                this.wx = n;
                this.wy = n2;
                CRC32 cRC32 = new CRC32();
                cRC32.reset();
                cRC32.update(String.format("map_%d_%d.bin", n, n2).getBytes());
                this.crc = cRC32.getValue();
            }
        }
    }

    private static class ZombieSimulator {
        public static Behaviour behaviour = Behaviour.Stay;
        public static int deleteZombieDistanceSquared = 10000;
        public static int forgotZombieDistanceSquared = 225;
        public static int canSeeZombieDistanceSquared = 100;
        public static int seeZombieDistanceSquared = 25;
        private static boolean canChangeTarget = true;
        private static int updatePeriod = 100;
        private static int attackPeriod = 1000;
        public static int maxZombiesPerUpdate = 300;
        private final ByteBuffer bb = ByteBuffer.allocate(1000000);
        private UpdateLimit updateLimiter = new UpdateLimit(updatePeriod);
        private UpdateLimit attackLimiter = new UpdateLimit(attackPeriod);
        private Player player = null;
        private final ZombiePacket zombiePacket = new ZombiePacket();
        private HashSet<Short> authoriseZombiesCurrent = new HashSet();
        private HashSet<Short> authoriseZombiesLast = new HashSet();
        private final ArrayList<Short> unknownZombies = new ArrayList();
        private final HashMap<Integer, Zombie> zombies = new HashMap();
        private final ArrayDeque<Zombie> zombies4Add = new ArrayDeque();
        private final ArrayDeque<Zombie> zombies4Delete = new ArrayDeque();
        private final HashSet<Short> authoriseZombies = new HashSet();
        private final ArrayDeque<Zombie> SendQueue = new ArrayDeque();
        private static Vector2 tmpDir = new Vector2();

        public ZombieSimulator(Player player) {
            this.player = player;
        }

        public void becomeLocal(Zombie zombie) {
            zombie.localOwnership = true;
        }

        public void becomeRemote(Zombie zombie) {
            zombie.localOwnership = false;
        }

        public void clear() {
            HashSet<Short> hashSet = this.authoriseZombiesCurrent;
            this.authoriseZombiesCurrent = this.authoriseZombiesLast;
            this.authoriseZombiesLast = hashSet;
            this.authoriseZombiesLast.removeIf(s -> this.zombies.get(s) == null);
            this.authoriseZombiesCurrent.clear();
        }

        public void add(short s) {
            this.authoriseZombiesCurrent.add(s);
        }

        public void receivePacket(ByteBuffer byteBuffer) {
            short s = byteBuffer.getShort();
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                this.parseZombie(byteBuffer);
            }
        }

        private void parseZombie(ByteBuffer byteBuffer) {
            ZombiePacket zombiePacket = this.zombiePacket;
            zombiePacket.parse(byteBuffer, null);
            Zombie zombie = this.zombies.get(zombiePacket.id);
            if (this.authoriseZombies.contains(zombiePacket.id) && zombie != null) {
                return;
            }
            if (zombie == null) {
                zombie = new Zombie(zombiePacket.id);
                this.zombies4Add.add(zombie);
                FakeClientManager.trace(this.player.movement.id, String.format("New zombie %s", zombie.OnlineID));
            }
            zombie.lastUpdate = System.currentTimeMillis();
            zombie.zombiePacket.copy(zombiePacket);
            zombie.x = zombiePacket.realX;
            zombie.y = zombiePacket.realY;
            zombie.z = zombiePacket.realZ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Serializable serializable2;
            Sets.SetView setView = Sets.difference(this.authoriseZombiesCurrent, this.authoriseZombiesLast);
            for (Serializable serializable2 : setView) {
                Object object = this.zombies.get(serializable2);
                if (object != null) {
                    this.becomeLocal((Zombie)object);
                    continue;
                }
                if (this.unknownZombies.contains(serializable2)) continue;
                this.unknownZombies.add((Short)serializable2);
            }
            UnmodifiableIterator unmodifiableIterator = Sets.difference(this.authoriseZombiesLast, this.authoriseZombiesCurrent);
            for (Object object : unmodifiableIterator) {
                Zombie zombie = this.zombies.get((Short)object);
                if (zombie == null) continue;
                this.becomeRemote(zombie);
            }
            serializable2 = this.authoriseZombies;
            synchronized (serializable2) {
                this.authoriseZombies.clear();
                this.authoriseZombies.addAll(this.authoriseZombiesCurrent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() {
            int n;
            Zombie zombie;
            if (this.authoriseZombies.size() == 0 && this.unknownZombies.size() == 0) {
                return;
            }
            if (this.SendQueue.isEmpty()) {
                HashSet<Short> hashSet = this.authoriseZombies;
                synchronized (hashSet) {
                    for (Short s : this.authoriseZombies) {
                        zombie = this.zombies.get(s);
                        if (zombie == null || zombie.OnlineID == -1) continue;
                        this.SendQueue.add(zombie);
                    }
                }
            }
            this.bb.clear();
            this.bb.putShort((short)0);
            int n2 = this.unknownZombies.size();
            this.bb.putShort((short)n2);
            for (n = 0; n < this.unknownZombies.size(); ++n) {
                if (this.unknownZombies.get(n) == null) {
                    return;
                }
                this.bb.putShort(this.unknownZombies.get(n));
            }
            this.unknownZombies.clear();
            n = this.bb.position();
            this.bb.putShort((short)maxZombiesPerUpdate);
            int n3 = 0;
            while (!this.SendQueue.isEmpty()) {
                zombie = this.SendQueue.poll();
                if (zombie.OnlineID == -1) continue;
                zombie.zombiePacket.write(this.bb);
                if (++n3 < maxZombiesPerUpdate) continue;
                break;
            }
            if (n3 < maxZombiesPerUpdate) {
                int n4 = this.bb.position();
                this.bb.position(n);
                this.bb.putShort((short)n3);
                this.bb.position(n4);
            }
            if (n3 > 0 || n2 > 0) {
                ByteBuffer byteBuffer = this.player.client.network.startPacket();
                this.player.client.doPacket(PacketTypes.PacketType.ZombieSimulation.getId(), byteBuffer);
                byteBuffer.put(this.bb.array(), 0, this.bb.position());
                this.player.client.network.endPacketSuperHighUnreliable(this.player.client.connectionGUID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void simulate(Integer n, Zombie zombie) {
            float f;
            float f2 = IsoUtils.DistanceToSquared(this.player.x, this.player.y, zombie.x, zombie.y);
            if (f2 > (float)deleteZombieDistanceSquared || !zombie.localOwnership && zombie.lastUpdate + 5000L < System.currentTimeMillis()) {
                this.zombies4Delete.add(zombie);
                return;
            }
            tmpDir.set(-zombie.x + this.player.x, -zombie.y + this.player.y);
            if (zombie.isMoving) {
                f = 0.2f;
                zombie.x = PZMath.lerp(zombie.x, zombie.zombiePacket.x, f);
                zombie.y = PZMath.lerp(zombie.y, zombie.zombiePacket.y, f);
                zombie.z = 0.0f;
                zombie.dir = IsoDirections.fromAngle(tmpDir);
            }
            if (canChangeTarget) {
                HashMap<Integer, PlayerManager.RemotePlayer> hashMap = this.player.playerManager.players;
                synchronized (hashMap) {
                    for (PlayerManager.RemotePlayer remotePlayer : this.player.playerManager.players.values()) {
                        float f3 = IsoUtils.DistanceToSquared(remotePlayer.x, remotePlayer.y, zombie.x, zombie.y);
                        if (!(f3 < (float)seeZombieDistanceSquared)) continue;
                        zombie.zombiePacket.target = remotePlayer.OnlineID;
                        break;
                    }
                }
            } else {
                zombie.zombiePacket.target = this.player.OnlineID;
            }
            if (behaviour == Behaviour.Stay) {
                zombie.isMoving = false;
            } else if (behaviour == Behaviour.Normal) {
                if (f2 > (float)forgotZombieDistanceSquared) {
                    zombie.isMoving = false;
                }
                if (f2 < (float)canSeeZombieDistanceSquared && (Rand.Next(100) < 1 || zombie.dir == IsoDirections.fromAngle(tmpDir))) {
                    zombie.isMoving = true;
                }
                if (f2 < (float)seeZombieDistanceSquared) {
                    zombie.isMoving = true;
                }
            } else {
                zombie.isMoving = true;
            }
            f = 0.0f;
            if (zombie.isMoving) {
                Vector2 vector22 = zombie.dir.ToVector();
                f = 3.0f;
                if (f2 < 100.0f) {
                    f = 6.0f;
                }
                long l = System.currentTimeMillis() - zombie.lastUpdate;
                zombie.zombiePacket.x = zombie.x + vector22.x * (float)l * 0.001f * f;
                zombie.zombiePacket.y = zombie.y + vector22.y * (float)l * 0.001f * f;
                zombie.zombiePacket.z = (byte)zombie.z;
                zombie.zombiePacket.moveType = NetworkVariables.PredictionTypes.Moving;
            } else {
                zombie.zombiePacket.x = zombie.x;
                zombie.zombiePacket.y = zombie.y;
                zombie.zombiePacket.z = (byte)zombie.z;
                zombie.zombiePacket.moveType = NetworkVariables.PredictionTypes.Static;
            }
            zombie.zombiePacket.booleanVariables = 0;
            if (f2 < 100.0f) {
                zombie.zombiePacket.booleanVariables = (short)(zombie.zombiePacket.booleanVariables | 2);
            }
            zombie.zombiePacket.timeSinceSeenFlesh = zombie.isMoving ? 0 : 100000;
            zombie.zombiePacket.smParamTargetAngle = 0;
            zombie.zombiePacket.speedMod = (short)1000;
            zombie.zombiePacket.walkType = NetworkVariables.WalkType.values()[zombie.walkType];
            zombie.zombiePacket.realX = zombie.x;
            zombie.zombiePacket.realY = zombie.y;
            zombie.zombiePacket.realZ = (byte)zombie.z;
            zombie.zombiePacket.realHealth = (short)(zombie.health * 1000.0f);
            zombie.zombiePacket.realState = NetworkVariables.ZombieState.fromString("fakezombie-" + behaviour.toString().toLowerCase());
            if (zombie.isMoving) {
                zombie.zombiePacket.pfbType = 1;
                zombie.zombiePacket.pfbTarget = this.player.OnlineID;
            } else {
                zombie.zombiePacket.pfbType = 0;
            }
            if (f2 < 2.0f && this.attackLimiter.Check()) {
                zombie.health -= Player.damage;
                this.sendHitCharacter(zombie, Player.damage);
                if (zombie.health <= 0.0f) {
                    this.player.client.sendChatMessage("DIE!!");
                    this.zombies4Delete.add(zombie);
                }
            }
            zombie.lastUpdate = System.currentTimeMillis();
        }

        private void writeHitInfoToZombie(ByteBuffer byteBuffer, short s, float f, float f2, float f3) {
            byteBuffer.put((byte)2);
            byteBuffer.putShort(s);
            byteBuffer.put((byte)0);
            byteBuffer.putFloat(f);
            byteBuffer.putFloat(f2);
            byteBuffer.putFloat(0.0f);
            byteBuffer.putFloat(f3);
            byteBuffer.putFloat(1.0f);
            byteBuffer.putInt(100);
        }

        private void sendHitCharacter(Zombie zombie, float f) {
            int n;
            boolean bl = false;
            ByteBuffer byteBuffer = this.player.client.network.startPacket();
            this.player.client.doPacket(PacketTypes.PacketType.HitCharacter.getId(), byteBuffer);
            byteBuffer.put((byte)3);
            byteBuffer.putShort(this.player.OnlineID);
            byteBuffer.putShort((short)0);
            byteBuffer.putFloat(this.player.x);
            byteBuffer.putFloat(this.player.y);
            byteBuffer.putFloat(this.player.z);
            byteBuffer.putFloat(this.player.direction.x);
            byteBuffer.putFloat(this.player.direction.y);
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            byteBuffer.putShort((short)((this.player.weapon_isBareHeads ? 2 : 0) + (bl ? 8 : 0)));
            byteBuffer.putFloat(1.0f);
            byteBuffer.putFloat(1.0f);
            byteBuffer.putFloat(1.0f);
            FakeClientManager.WriteStringUTF(byteBuffer, "default");
            byte by = 0;
            by = (byte)(by | (byte)(this.player.weapon_isBareHeads ? 9 : 0));
            byteBuffer.put(by);
            byteBuffer.put((byte)0);
            byteBuffer.putShort((short)0);
            byteBuffer.putFloat(1.0f);
            byteBuffer.putInt(0);
            int n2 = 1;
            byteBuffer.put((byte)n2);
            for (n = 0; n < n2; ++n) {
                this.writeHitInfoToZombie(byteBuffer, zombie.OnlineID, zombie.x, zombie.y, f);
            }
            n2 = 0;
            byteBuffer.put((byte)n2);
            n2 = 1;
            byteBuffer.put((byte)n2);
            for (n = 0; n < n2; ++n) {
                this.writeHitInfoToZombie(byteBuffer, zombie.OnlineID, zombie.x, zombie.y, f);
            }
            if (!this.player.weapon_isBareHeads) {
                byteBuffer.put((byte)0);
            } else {
                byteBuffer.put((byte)1);
                byteBuffer.putShort(this.player.registry_id);
                byteBuffer.put((byte)1);
                byteBuffer.putInt(this.player.weapon_id);
                byteBuffer.put((byte)0);
                byteBuffer.putInt(0);
                byteBuffer.putInt(0);
            }
            byteBuffer.putShort(zombie.OnlineID);
            byteBuffer.putShort((short)(f >= zombie.health ? 3 : 0));
            byteBuffer.putFloat(zombie.x);
            byteBuffer.putFloat(zombie.y);
            byteBuffer.putFloat(zombie.z);
            byteBuffer.putFloat(zombie.dir.ToVector().x);
            byteBuffer.putFloat(zombie.dir.ToVector().y);
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            byteBuffer.putShort((short)0);
            FakeClientManager.WriteStringUTF(byteBuffer, "");
            FakeClientManager.WriteStringUTF(byteBuffer, "FRONT");
            byteBuffer.put((byte)0);
            byteBuffer.putFloat(f);
            byteBuffer.putFloat(1.0f);
            byteBuffer.putFloat(this.player.direction.x);
            byteBuffer.putFloat(this.player.direction.y);
            byteBuffer.putFloat(1.0f);
            byteBuffer.put((byte)0);
            if (tmpDir.getLength() > 0.0f) {
                zombie.dropPositionX = zombie.x + ZombieSimulator.tmpDir.x / tmpDir.getLength();
                zombie.dropPositionY = zombie.y + ZombieSimulator.tmpDir.y / tmpDir.getLength();
            } else {
                zombie.dropPositionX = zombie.x;
                zombie.dropPositionY = zombie.y;
            }
            byteBuffer.putFloat(zombie.dropPositionX);
            byteBuffer.putFloat(zombie.dropPositionY);
            byteBuffer.put((byte)zombie.z);
            byteBuffer.putFloat(zombie.dir.toAngle());
            this.player.client.network.endPacketImmediate(this.player.client.connectionGUID);
        }

        private void sendSendDeadZombie(Zombie zombie) {
            ByteBuffer byteBuffer = this.player.client.network.startPacket();
            this.player.client.doPacket(PacketTypes.PacketType.ZombieDeath.getId(), byteBuffer);
            byteBuffer.putShort(zombie.OnlineID);
            byteBuffer.putFloat(zombie.x);
            byteBuffer.putFloat(zombie.y);
            byteBuffer.putFloat(zombie.z);
            byteBuffer.putFloat(zombie.dir.toAngle());
            byteBuffer.put((byte)zombie.dir.index());
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            this.player.client.network.endPacketImmediate(this.player.client.connectionGUID);
        }

        public void simulateAll() {
            Zombie zombie;
            while (!this.zombies4Add.isEmpty()) {
                zombie = this.zombies4Add.poll();
                this.zombies.put(Integer.valueOf(zombie.OnlineID), zombie);
            }
            this.zombies.forEach(this::simulate);
            while (!this.zombies4Delete.isEmpty()) {
                zombie = this.zombies4Delete.poll();
                this.zombies.remove(zombie.OnlineID);
            }
        }

        public void update() {
            if (this.updateLimiter.Check()) {
                this.simulateAll();
                this.send();
            }
        }

        private static enum Behaviour {
            Stay,
            Normal,
            Attack;

        }
    }

    private static class Player {
        private static final int cellSize = 50;
        private static final int spawnMinX = 3550;
        private static final int spawnMaxX = 14450;
        private static final int spawnMinY = 5050;
        private static final int spawnMaxY = 12950;
        private static final int ChunkGridWidth = 13;
        private static final int ChunksPerWidth = 10;
        private static int fps = 60;
        private static int predictInterval = 1000;
        private static float damage = 1.0f;
        private static boolean isVOIPEnabled = false;
        private final NetworkCharacter networkCharacter;
        private final UpdateLimit updateLimiter;
        private final UpdateLimit predictLimiter;
        private final UpdateLimit timeSyncLimiter;
        private final Client client;
        private final Movement movement;
        private final ArrayList<Clothes> clothes;
        private final String username;
        private final int isFemale;
        private final Color tagColor;
        private final Color speakColor;
        private UpdateLimit teleportLimiter;
        private short OnlineID;
        private float x;
        private float y;
        private final float z;
        private Vector2 direction;
        private int WorldX;
        private int WorldY;
        private float angle;
        private ZombieSimulator simulator;
        private PlayerManager playerManager;
        private boolean weapon_isBareHeads = false;
        private int weapon_id = 837602032;
        private short registry_id = (short)1202;
        static float distance = 0.0f;
        private int lastPlayerForHello = -1;

        private Player(Movement movement, Network network, int n, int n2) {
            this.username = String.format("Client%d", movement.id);
            this.tagColor = Colors.SkyBlue;
            this.speakColor = Colors.GetRandomColor();
            this.isFemale = (int)Math.round(Math.random());
            this.OnlineID = (short)-1;
            this.clothes = new ArrayList();
            this.clothes.add(new Clothes(11, 0, "Shirt_FormalWhite"));
            this.clothes.add(new Clothes(13, 3, "Tie_Full"));
            this.clothes.add(new Clothes(11, 0, "Socks_Ankle"));
            this.clothes.add(new Clothes(13, 0, "Trousers_Suit"));
            this.clothes.add(new Clothes(13, 0, "Suit_Jacket"));
            this.clothes.add(new Clothes(11, 0, "Shoes_Black"));
            this.clothes.add(new Clothes(11, 0, "Glasses_Sun"));
            this.WorldX = (int)this.x / 10;
            this.WorldY = (int)this.y / 10;
            this.movement = movement;
            this.z = 0.0f;
            this.angle = 0.0f;
            this.x = movement.spawn.x;
            this.y = movement.spawn.y;
            this.direction = movement.direction.ToVector();
            this.networkCharacter = new NetworkCharacter();
            this.simulator = new ZombieSimulator(this);
            this.playerManager = new PlayerManager(this);
            this.client = new Client(this, network, n, n2);
            network.createdClients.put(n, this.client);
            this.updateLimiter = new UpdateLimit(1000 / fps);
            this.predictLimiter = new UpdateLimit((long)((float)predictInterval * 0.6f));
            this.timeSyncLimiter = new UpdateLimit(10000L);
        }

        private float getDistance(float f) {
            return f / 3.6f / (float)fps;
        }

        private void teleportMovement() {
            float f = this.movement.destination.x;
            float f2 = this.movement.destination.y;
            FakeClientManager.info(this.movement.id, String.format("Player %3d teleport (%9.3f,%9.3f) => (%9.3f,%9.3f) / %9.3f, next in %.3fs", this.OnlineID, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(f), Float.valueOf(f2), Math.sqrt(Math.pow(f - this.x, 2.0) + Math.pow(f2 - this.y, 2.0)), Float.valueOf((float)this.movement.teleportDelay / 1000.0f)));
            this.x = f;
            this.y = f2;
            this.angle = 0.0f;
            this.teleportLimiter.Reset(this.movement.teleportDelay);
        }

        private void lineMovement() {
            distance = this.getDistance(this.movement.speed);
            this.direction.set(this.movement.destination.x - this.x, this.movement.destination.y - this.y);
            this.direction.normalize();
            float f = this.x + distance * this.direction.x;
            float f2 = this.y + distance * this.direction.y;
            if (this.x < this.movement.destination.x && f > this.movement.destination.x || this.x > this.movement.destination.x && f < this.movement.destination.x || this.y < this.movement.destination.y && f2 > this.movement.destination.y || this.y > this.movement.destination.y && f2 < this.movement.destination.y) {
                f = this.movement.destination.x;
                f2 = this.movement.destination.y;
            }
            this.x = f;
            this.y = f2;
        }

        private void circleMovement() {
            this.angle = (this.angle + (float)(2.0 * Math.asin(this.getDistance(this.movement.speed) / 2.0f / (float)this.movement.radius))) % 360.0f;
            float f = this.movement.spawn.x + (float)((double)this.movement.radius * Math.sin(this.angle));
            float f2 = this.movement.spawn.y + (float)((double)this.movement.radius * Math.cos(this.angle));
            this.x = f;
            this.y = f2;
        }

        private Zombie getNearestZombie() {
            Zombie zombie = null;
            float f = Float.POSITIVE_INFINITY;
            for (Zombie zombie2 : this.simulator.zombies.values()) {
                float f2 = IsoUtils.DistanceToSquared(this.x, this.y, zombie2.x, zombie2.y);
                if (!(f2 < f)) continue;
                zombie = zombie2;
                f = f2;
            }
            return zombie;
        }

        private Zombie getNearestZombie(PlayerManager.RemotePlayer remotePlayer) {
            Zombie zombie = null;
            float f = Float.POSITIVE_INFINITY;
            for (Zombie zombie2 : this.simulator.zombies.values()) {
                float f2 = IsoUtils.DistanceToSquared(remotePlayer.x, remotePlayer.y, zombie2.x, zombie2.y);
                if (!(f2 < f)) continue;
                zombie = zombie2;
                f = f2;
            }
            return zombie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PlayerManager.RemotePlayer getNearestPlayer() {
            PlayerManager.RemotePlayer remotePlayer = null;
            float f = Float.POSITIVE_INFINITY;
            HashMap<Integer, PlayerManager.RemotePlayer> hashMap = this.playerManager.players;
            synchronized (hashMap) {
                for (PlayerManager.RemotePlayer remotePlayer2 : this.playerManager.players.values()) {
                    float f2 = IsoUtils.DistanceToSquared(this.x, this.y, remotePlayer2.x, remotePlayer2.y);
                    if (!(f2 < f)) continue;
                    remotePlayer = remotePlayer2;
                    f = f2;
                }
            }
            return remotePlayer;
        }

        private void aiAttackZombiesMovement() {
            Zombie zombie = this.getNearestZombie();
            float f = this.getDistance(this.movement.speed);
            if (zombie != null) {
                this.direction.set(zombie.x - this.x, zombie.y - this.y);
                this.direction.normalize();
            }
            float f2 = this.x + f * this.direction.x;
            float f3 = this.y + f * this.direction.y;
            this.x = f2;
            this.y = f3;
        }

        private void aiRunAwayFromZombiesMovement() {
            Zombie zombie = this.getNearestZombie();
            float f = this.getDistance(this.movement.speed);
            if (zombie != null) {
                this.direction.set(this.x - zombie.x, this.y - zombie.y);
                this.direction.normalize();
            }
            float f2 = this.x + f * this.direction.x;
            float f3 = this.y + f * this.direction.y;
            this.x = f2;
            this.y = f3;
        }

        private void aiRunToAnotherPlayersMovement() {
            PlayerManager.RemotePlayer remotePlayer = this.getNearestPlayer();
            float f = this.getDistance(this.movement.speed);
            float f2 = this.x + f * this.direction.x;
            float f3 = this.y + f * this.direction.y;
            if (remotePlayer != null) {
                this.direction.set(remotePlayer.x - this.x, remotePlayer.y - this.y);
                float f4 = this.direction.normalize();
                if (f4 > 2.0f) {
                    this.x = f2;
                    this.y = f3;
                } else if (this.lastPlayerForHello != remotePlayer.OnlineID) {
                    this.lastPlayerForHello = remotePlayer.OnlineID;
                }
            }
        }

        private void aiNormalMovement() {
            float f = this.getDistance(this.movement.speed);
            PlayerManager.RemotePlayer remotePlayer = this.getNearestPlayer();
            if (remotePlayer == null) {
                this.aiRunAwayFromZombiesMovement();
                return;
            }
            float f2 = IsoUtils.DistanceToSquared(this.x, this.y, remotePlayer.x, remotePlayer.y);
            if (f2 > 36.0f) {
                this.movement.speed = 13.0f;
                this.movement.motion = Movement.Motion.Run;
            } else {
                this.movement.speed = 4.0f;
                this.movement.motion = Movement.Motion.Walk;
            }
            Zombie zombie = this.getNearestZombie();
            float f3 = Float.POSITIVE_INFINITY;
            if (zombie != null) {
                f3 = IsoUtils.DistanceToSquared(this.x, this.y, zombie.x, zombie.y);
            }
            Zombie zombie2 = this.getNearestZombie(remotePlayer);
            float f4 = Float.POSITIVE_INFINITY;
            if (zombie2 != null) {
                f4 = IsoUtils.DistanceToSquared(remotePlayer.x, remotePlayer.y, zombie2.x, zombie2.y);
            }
            if (f4 < 25.0f) {
                zombie = zombie2;
                f3 = f4;
            }
            if (f2 > 25.0f || zombie == null) {
                this.direction.set(remotePlayer.x - this.x, remotePlayer.y - this.y);
                float f5 = this.direction.normalize();
                if (f5 > 4.0f) {
                    float f6 = this.x + f * this.direction.x;
                    float f7 = this.y + f * this.direction.y;
                    this.x = f6;
                    this.y = f7;
                } else if (this.lastPlayerForHello != remotePlayer.OnlineID) {
                    this.lastPlayerForHello = remotePlayer.OnlineID;
                }
            } else if (f3 < 25.0f) {
                this.direction.set(zombie.x - this.x, zombie.y - this.y);
                this.direction.normalize();
                this.x += f * this.direction.x;
                this.y += f * this.direction.y;
            }
        }

        private void checkRequestChunks() {
            int n = (int)this.x / 10;
            int n2 = (int)this.y / 10;
            if (Math.abs(n - this.WorldX) >= 13 || Math.abs(n2 - this.WorldY) >= 13) {
                int n3 = this.WorldX - 6;
                int n4 = this.WorldY - 6;
                int n5 = this.WorldX + 6;
                int n6 = this.WorldY + 6;
                for (int i = n3; i <= n5; ++i) {
                    for (int j = n4; j <= n6; ++j) {
                        this.client.addChunkRequest(i, j, i - n3, j - n4);
                    }
                }
            } else if (n != this.WorldX) {
                if (n < this.WorldX) {
                    for (int i = -6; i <= 6; ++i) {
                        this.client.addChunkRequest(this.WorldX - 6, this.WorldY + i, 0, i + 6);
                    }
                } else {
                    for (int i = -6; i <= 6; ++i) {
                        this.client.addChunkRequest(this.WorldX + 6, this.WorldY + i, 12, i + 6);
                    }
                }
            } else if (n2 != this.WorldY) {
                if (n2 < this.WorldY) {
                    for (int i = -6; i <= 6; ++i) {
                        this.client.addChunkRequest(this.WorldX + i, this.WorldY - 6, i + 6, 0);
                    }
                } else {
                    for (int i = -6; i <= 6; ++i) {
                        this.client.addChunkRequest(this.WorldX + i, this.WorldY + 6, i + 6, 12);
                    }
                }
            }
            this.client.requestChunks();
            this.WorldX = n;
            this.WorldY = n2;
        }

        private void hit() {
            FakeClientManager.info(this.movement.id, String.format("Player %3d hit", this.OnlineID));
        }

        private void run() {
            this.simulator.update();
            if (this.updateLimiter.Check()) {
                if (isVOIPEnabled) {
                    FMODManager.instance.tick();
                    VoiceManager.instance.update();
                }
                if (this.movement.doTeleport() && this.teleportLimiter.Check()) {
                    this.teleportMovement();
                }
                switch (this.movement.type) {
                    case Circle: {
                        this.circleMovement();
                        break;
                    }
                    case Line: {
                        this.lineMovement();
                        break;
                    }
                    case AIAttackZombies: {
                        this.aiAttackZombiesMovement();
                        break;
                    }
                    case AIRunAwayFromZombies: {
                        this.aiRunAwayFromZombiesMovement();
                        break;
                    }
                    case AIRunToAnotherPlayers: {
                        this.aiRunToAnotherPlayersMovement();
                        break;
                    }
                    case AINormal: {
                        this.aiNormalMovement();
                    }
                }
                this.checkRequestChunks();
                if (this.predictLimiter.Check()) {
                    int n = (int)(this.client.getServerTime() / 1000000L);
                    this.networkCharacter.checkResetPlayer(n);
                    NetworkCharacter.Transform transform = this.networkCharacter.predict(predictInterval, n, this.x, this.y, this.direction.x, this.direction.y);
                    this.client.sendPlayer(transform, n, this.direction);
                }
                if (this.timeSyncLimiter.Check()) {
                    this.client.sendTimeSync();
                    this.client.sendSyncRadioData();
                }
                if (this.movement.hordeCreator != null && this.movement.hordeCreator.hordeCreatorLimiter.Check()) {
                    this.client.sendCommand(this.movement.hordeCreator.getCommand((int)this.x, (int)this.y, (int)this.z));
                }
                if (this.movement.soundMaker != null && this.movement.soundMaker.soundMakerLimiter.Check()) {
                    this.client.sendWorldSound4Player((int)this.x, (int)this.y, (int)this.z, this.movement.soundMaker.radius, this.movement.soundMaker.radius);
                    this.client.sendChatMessage(this.movement.soundMaker.message);
                    this.client.sendEventPacket(this.OnlineID, (int)this.x, (int)this.y, (int)this.z, (byte)4, "shout");
                }
            }
        }

        private static class Clothes {
            private final byte flags;
            private final byte text;
            private final String name;

            Clothes(byte by, byte by2, String string) {
                this.flags = by;
                this.text = by2;
                this.name = string;
            }
        }
    }

    private static class HordeCreator {
        private final int radius;
        private final int count;
        private final long interval;
        private final UpdateLimit hordeCreatorLimiter;

        public HordeCreator(int n, int n2, long l) {
            this.radius = n;
            this.count = n2;
            this.interval = l;
            this.hordeCreatorLimiter = new UpdateLimit(l);
        }

        public String getCommand(int n, int n2, int n3) {
            return String.format("/createhorde2 -x %d -y %d -z %d -count %d -radius %d -crawler false -isFallOnFront false -isFakeDead false -knockedDown false -health 1 -outfit", n, n2, n3, this.count, this.radius);
        }
    }

    private static class SoundMaker {
        private final int radius;
        private final int interval;
        private final String message;
        private final UpdateLimit soundMakerLimiter;

        public SoundMaker(int n, int n2, String string) {
            this.radius = n2;
            this.message = string;
            this.interval = n;
            this.soundMakerLimiter = new UpdateLimit(n);
        }
    }

    private static class Network {
        private final HashMap<Integer, Client> createdClients = new HashMap();
        private final HashMap<Long, Client> connectedClients = new HashMap();
        private final ByteBuffer rb = ByteBuffer.allocate(1000000);
        private final ByteBuffer wb = ByteBuffer.allocate(1000000);
        private final RakNetPeerInterface peer = new RakNetPeerInterface();
        private final int started;
        private int connected = -1;
        private static final HashMap<Integer, String> systemPacketTypeNames = new HashMap();

        boolean isConnected() {
            return this.connected == 0;
        }

        boolean isStarted() {
            return this.started == 0;
        }

        private Network(int n, int n2) {
            this.peer.Init(false);
            this.peer.SetMaximumIncomingConnections(0);
            this.peer.SetClientPort(n2);
            this.peer.SetOccasionalPing(true);
            this.started = this.peer.Startup(n);
            if (this.started == 0) {
                Thread thread = new Thread(ThreadGroups.Network, this::receiveThread, "PeerInterfaceReceive");
                thread.setDaemon(true);
                thread.start();
                FakeClientManager.log(-1, "Network start ok");
            } else {
                FakeClientManager.error(-1, String.format("Network start failed: %d", this.started));
            }
        }

        private void connect(int n, String string) {
            this.connected = this.peer.Connect(string, 16261, PZcrypt.hash("", true), false);
            if (this.connected == 0) {
                FakeClientManager.log(n, String.format("Client connected to %s:%d", string, 16261));
            } else {
                FakeClientManager.error(n, String.format("Client connection to %s:%d failed: %d", string, 16261, this.connected));
            }
        }

        private void disconnect(long l, int n, String string) {
            if (l != 0L) {
                this.peer.disconnect(l, "");
                this.connected = -1;
            }
            if (this.connected == -1) {
                FakeClientManager.log(n, String.format("Client disconnected from %s:%d", string, 16261));
            } else {
                FakeClientManager.log(n, String.format("Client disconnection from %s:%d failed: %d", string, 16261, l));
            }
        }

        private ByteBuffer startPacket() {
            this.wb.clear();
            return this.wb;
        }

        private void cancelPacket() {
            this.wb.clear();
        }

        private void endPacket(long l) {
            this.wb.flip();
            this.peer.Send(this.wb, 1, 3, (byte)0, l, false);
        }

        private void endPacketImmediate(long l) {
            this.wb.flip();
            this.peer.Send(this.wb, 0, 3, (byte)0, l, false);
        }

        private void endPacketSuperHighUnreliable(long l) {
            this.wb.flip();
            this.peer.Send(this.wb, 0, 1, (byte)0, l, false);
        }

        private void receiveThread() {
            while (true) {
                if (this.peer.Receive(this.rb)) {
                    this.decode(this.rb);
                    continue;
                }
                FakeClientManager.sleep(1L);
            }
        }

        private static void logUserPacket(int n, short s) {
            PacketTypes.PacketType packetType = PacketTypes.packetTypes.get(s);
            String string = packetType == null ? "unknown user packet" : packetType.name();
            FakeClientManager.trace(n, String.format("## %s (%d)", string, s));
        }

        private static void logSystemPacket(int n, int n2) {
            String string = systemPacketTypeNames.getOrDefault(n2, "unknown system packet");
            FakeClientManager.trace(n, String.format("## %s (%d)", string, n2));
        }

        private void decode(ByteBuffer byteBuffer) {
            int n = byteBuffer.get() & 0xFF;
            int n2 = -1;
            long l = -1L;
            Network.logSystemPacket(n2, n);
            switch (n) {
                case 17: 
                case 18: 
                case 23: 
                case 24: 
                case 32: {
                    FakeClientManager.error(-1, "Connection failed: " + n);
                    break;
                }
                case 22: {
                    n2 = byteBuffer.get() & 0xFF;
                    Client client = this.createdClients.get(n2);
                    if (client == null) break;
                    client.changeState(Client.State.DISCONNECT);
                    break;
                }
                case 21: {
                    n2 = byteBuffer.get() & 0xFF;
                    l = this.peer.getGuidOfPacket();
                    Client client = this.connectedClients.get(l);
                    if (client != null) {
                        this.connectedClients.remove(l);
                        client.changeState(Client.State.DISCONNECT);
                    }
                    FakeClientManager.log(-1, String.format("Connected clients: %d (connection index %d)", this.connectedClients.size(), n2));
                    break;
                }
                case 19: {
                    n2 = byteBuffer.get() & 0xFF;
                }
                case 44: 
                case 45: {
                    l = this.peer.getGuidOfPacket();
                    break;
                }
                case 16: {
                    n2 = byteBuffer.get() & 0xFF;
                    l = this.peer.getGuidOfPacket();
                    Client client = this.createdClients.get(n2);
                    if (client != null) {
                        client.connectionGUID = l;
                        this.connectedClients.put(l, client);
                        VoiceManager.instance.VoiceConnectReq(l);
                        client.changeState(Client.State.LOGIN);
                    }
                    FakeClientManager.log(-1, String.format("Connected clients: %d (connection index %d)", this.connectedClients.size(), n2));
                    break;
                }
                case 0: 
                case 1: 
                case 20: 
                case 25: 
                case 31: 
                case 33: {
                    break;
                }
                case 134: {
                    short s = byteBuffer.getShort();
                    l = this.peer.getGuidOfPacket();
                    Client client = this.connectedClients.get(l);
                    if (client == null) break;
                    client.receive(s, byteBuffer);
                    n2 = client.connectionIndex;
                    break;
                }
            }
        }

        static {
            systemPacketTypeNames.put(22, "connection lost");
            systemPacketTypeNames.put(21, "disconnected");
            systemPacketTypeNames.put(23, "connection banned");
            systemPacketTypeNames.put(17, "connection failed");
            systemPacketTypeNames.put(20, "no free connections");
            systemPacketTypeNames.put(16, "connection accepted");
            systemPacketTypeNames.put(18, "already connected");
            systemPacketTypeNames.put(44, "voice request");
            systemPacketTypeNames.put(45, "voice reply");
            systemPacketTypeNames.put(25, "wrong protocol version");
            systemPacketTypeNames.put(0, "connected ping");
            systemPacketTypeNames.put(1, "unconnected ping");
            systemPacketTypeNames.put(33, "new remote connection");
            systemPacketTypeNames.put(31, "remote disconnection");
            systemPacketTypeNames.put(32, "remote connection lost");
            systemPacketTypeNames.put(24, "invalid password");
            systemPacketTypeNames.put(19, "new connection");
            systemPacketTypeNames.put(134, "user packet");
        }
    }

    private static class PlayerManager {
        private Player player = null;
        private final PlayerPacket playerPacket = new PlayerPacket();
        public final HashMap<Integer, RemotePlayer> players = new HashMap();

        public PlayerManager(Player player) {
            this.player = player;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePlayer(ByteBuffer byteBuffer) {
            PlayerPacket playerPacket = this.playerPacket;
            playerPacket.parse(byteBuffer, null);
            HashMap<Integer, RemotePlayer> hashMap = this.players;
            synchronized (hashMap) {
                RemotePlayer remotePlayer = this.players.get(playerPacket.id);
                if (remotePlayer == null) {
                    remotePlayer = new RemotePlayer(playerPacket.id);
                    this.players.put(Integer.valueOf(playerPacket.id), remotePlayer);
                    FakeClientManager.trace(this.player.movement.id, String.format("New player %s", remotePlayer.OnlineID));
                }
                remotePlayer.playerPacket.copy(playerPacket);
                remotePlayer.x = playerPacket.realx;
                remotePlayer.y = playerPacket.realy;
                remotePlayer.z = playerPacket.realz;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePlayerTimeout(ByteBuffer byteBuffer) {
            short s = byteBuffer.getShort();
            HashMap<Integer, RemotePlayer> hashMap = this.players;
            synchronized (hashMap) {
                this.players.remove(s);
            }
            FakeClientManager.trace(this.player.movement.id, String.format("Remove player %s", s));
        }

        private class RemotePlayer {
            public float x;
            public float y;
            public float z;
            public short OnlineID;
            public PlayerPacket playerPacket = new PlayerPacket();

            public RemotePlayer(short s) {
                this.playerPacket.id = s;
                this.OnlineID = s;
            }
        }
    }

    private static class Zombie {
        public long lastUpdate;
        public float x;
        public float y;
        public float z;
        public short OnlineID;
        public boolean localOwnership = false;
        public ZombiePacket zombiePacket = null;
        public IsoDirections dir = IsoDirections.N;
        public float health = 1.0f;
        public byte walkType = (byte)Rand.Next(NetworkVariables.WalkType.values().length);
        public float dropPositionX;
        public float dropPositionY;
        public boolean isMoving = false;

        public Zombie(short s) {
            this.zombiePacket = new ZombiePacket();
            this.zombiePacket.id = s;
            this.OnlineID = s;
            this.localOwnership = false;
        }
    }
}

