/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.Platform;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.ThreadGroups;
import zombie.core.logger.ZipLogs;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.network.ICoopServerMessageListener;

public class CoopMaster {
    private Process serverProcess;
    private Thread serverThread;
    private PrintStream serverCommandStream;
    private final List<String> incomingMessages = new LinkedList<String>();
    private Pattern serverMessageParser;
    private TerminationReason serverTerminationReason;
    private Thread timeoutWatchThread;
    private boolean serverResponded;
    public static final CoopMaster instance = new CoopMaster();
    private String adminUsername = null;
    private String adminPassword = null;
    private String serverName = null;
    private Long serverSteamID = null;
    private String serverIP = null;
    private Integer serverPort = null;
    private int autoCookie = 0;
    private static final int autoCookieOffset = 1000000;
    private static final int maxAutoCookie = 1000000;
    private final List<Pair<ICoopServerMessageListener, ListenerOptions>> listeners = new LinkedList<Pair<ICoopServerMessageListener, ListenerOptions>>();

    private CoopMaster() {
        this.serverMessageParser = Pattern.compile("^([\\-\\w]+)(\\[(\\d+)\\])?@(.*)$");
        this.adminPassword = UUID.randomUUID().toString();
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void launchServer(String string, String string2, int n) throws IOException {
        this.launchServer(string, string2, n, false);
    }

    public void softreset(String string, String string2, int n) throws IOException {
        this.launchServer(string, string2, n, true);
    }

    private void launchServer(String string, String string2, int n, boolean bl) throws IOException {
        String string3 = Paths.get(System.getProperty("java.home"), "bin", "java").toAbsolutePath().toString();
        if (SteamUtils.isSteamModeEnabled()) {
            string2 = "admin";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add("-Xms" + n + "m");
        arrayList.add("-Xmx" + n + "m");
        arrayList.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        arrayList.add("-Djava.class.path=" + System.getProperty("java.class.path"));
        arrayList.add("-Duser.dir=" + System.getProperty("user.dir"));
        arrayList.add("-Duser.home=" + System.getProperty("user.home"));
        arrayList.add("-Dzomboid.znetlog=2");
        arrayList.add("-Dzomboid.steam=" + (SteamUtils.isSteamModeEnabled() ? "1" : "0"));
        arrayList.add("-Djava.awt.headless=true");
        arrayList.add("-XX:-OmitStackTraceInFastThrow");
        String string4 = this.getGarbageCollector();
        if (string4 != null) {
            arrayList.add(string4);
        }
        if (bl) {
            arrayList.add("-Dsoftreset");
        }
        if (Core.bDebug) {
            arrayList.add("-Ddebug");
        }
        arrayList.add("zombie.network.GameServer");
        arrayList.add("-coop");
        arrayList.add("-servername");
        this.serverName = string;
        arrayList.add(this.serverName);
        arrayList.add("-adminusername");
        this.adminUsername = string2;
        arrayList.add(this.adminUsername);
        arrayList.add("-adminpassword");
        arrayList.add(this.adminPassword);
        arrayList.add("-cachedir=" + ZomboidFileSystem.instance.getCacheDir());
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        ZipLogs.addZipFile(false);
        this.serverTerminationReason = TerminationReason.NormalTermination;
        this.serverResponded = false;
        this.serverProcess = processBuilder.start();
        this.serverCommandStream = new PrintStream(this.serverProcess.getOutputStream());
        this.serverThread = new Thread(ThreadGroups.Workers, this::readServer);
        this.serverThread.setUncaughtExceptionHandler(GameWindow::uncaughtException);
        this.serverThread.start();
        this.timeoutWatchThread = new Thread(ThreadGroups.Workers, this::watchServer);
        this.timeoutWatchThread.setUncaughtExceptionHandler(GameWindow::uncaughtException);
        this.timeoutWatchThread.start();
    }

    private String getGarbageCollector() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            boolean bl = false;
            boolean bl2 = false;
            for (String string : list) {
                if ("-XX:+UseZGC".equals(string)) {
                    bl = true;
                }
                if ("-XX:-UseZGC".equals(string)) {
                    bl = false;
                }
                if ("-XX:+UseG1GC".equals(string)) {
                    bl2 = true;
                }
                if (!"-XX:-UseG1GC".equals(string)) continue;
                bl2 = false;
            }
            if (bl) {
                return "-XX:+UseZGC";
            }
            if (bl2) {
                return "-XX:+UseG1GC";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private void readServer() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.serverProcess.getInputStream()));
        while (true) {
            try {
                int n = this.serverProcess.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                String string = null;
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (string == null) continue;
                this.storeMessage(string);
                this.serverResponded = true;
                continue;
            }
            break;
        }
        this.storeMessage("process-status@terminated");
        ZipLogs.addZipFile(true);
    }

    public void abortServer() {
        this.serverProcess.destroy();
    }

    private void watchServer() {
        int n = 20;
        try {
            Thread.sleep(1000 * n);
            if (!this.serverResponded) {
                this.serverTerminationReason = TerminationReason.Timeout;
                this.abortServer();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.serverThread != null && this.serverThread.isAlive();
    }

    public TerminationReason terminationReason() {
        return this.serverTerminationReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMessage(String string) {
        List<String> list = this.incomingMessages;
        synchronized (list) {
            this.incomingMessages.add(string);
        }
    }

    public synchronized void sendMessage(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (string2 == null) {
            stringBuilder.append("@");
        } else {
            stringBuilder.append("[");
            stringBuilder.append(string2);
            stringBuilder.append("]@");
        }
        stringBuilder.append(string3);
        String string4 = stringBuilder.toString();
        if (this.serverCommandStream != null) {
            this.serverCommandStream.println(string4);
            this.serverCommandStream.flush();
        }
    }

    public void sendMessage(String string, String string2) {
        this.sendMessage(string, null, string2);
    }

    public synchronized void invokeServer(String string, String string2, ICoopServerMessageListener iCoopServerMessageListener) {
        this.autoCookie = (this.autoCookie + 1) % 1000000;
        String string3 = Integer.toString(1000000 + this.autoCookie);
        this.addListener(iCoopServerMessageListener, new ListenerOptions(string, string3, true));
        this.sendMessage(string, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        String string = null;
        List<String> list = this.incomingMessages;
        synchronized (list) {
            if (this.incomingMessages.size() != 0) {
                string = this.incomingMessages.get(0);
                this.incomingMessages.remove(0);
                if (!"ping@ping".equals(string)) {
                    System.out.println("SERVER: " + string);
                }
            }
        }
        return string;
    }

    public void update() {
        String string;
        while ((string = this.getMessage()) != null) {
            Matcher matcher = this.serverMessageParser.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(3);
                String string4 = matcher.group(4);
                LuaEventManager.triggerEvent("OnCoopServerMessage", string2, string3, string4);
                this.handleMessage(string2, string3, string4);
                continue;
            }
            DebugLog.log(DebugType.Network, "[CoopMaster] Unknown message incoming from the slave server: " + string);
        }
    }

    private void handleMessage(String string, String string2, String string3) {
        if (Objects.equals(string, "ping")) {
            this.sendMessage("ping", string2, "pong");
        } else if (Objects.equals(string, "steam-id")) {
            this.serverSteamID = Objects.equals(string3, "null") ? null : Long.valueOf(SteamUtils.convertStringToSteamID(string3));
        } else if (Objects.equals(string, "server-address")) {
            DebugLog.log("Got server-address: " + string3);
            String string4 = "^(\\d+\\.\\d+\\.\\d+\\.\\d+):(\\d+)$";
            Pattern pattern = Pattern.compile(string4);
            Matcher matcher = pattern.matcher(string3);
            if (matcher.find()) {
                String string5 = matcher.group(1);
                String string6 = matcher.group(2);
                this.serverIP = string5;
                this.serverPort = Integer.valueOf(string6);
                DebugLog.log("Successfully parsed: address = " + this.serverIP + ", port = " + this.serverPort);
            } else {
                DebugLog.log("Failed to parse server address");
            }
        }
        this.invokeListeners(string, string2, string3);
    }

    public void register(Platform platform, KahluaTable kahluaTable) {
        KahluaTable kahluaTable2 = platform.newTable();
        kahluaTable2.rawset("launch", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                boolean bl = false;
                if (n == 4) {
                    Object object = luaCallFrame.get(1);
                    Object object2 = luaCallFrame.get(2);
                    Object object3 = luaCallFrame.get(3);
                    if (!(object instanceof String && object2 instanceof String && object3 instanceof Double)) {
                        return 0;
                    }
                    try {
                        CoopMaster.this.launchServer((String)object, (String)object2, ((Double)object3).intValue());
                        bl = true;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    DebugLog.log(DebugType.Network, "[CoopMaster] wrong number of arguments: " + n);
                }
                luaCallFrame.push(bl);
                return 1;
            }
        });
        kahluaTable2.rawset("softreset", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                boolean bl = false;
                if (n == 4) {
                    Object object = luaCallFrame.get(1);
                    Object object2 = luaCallFrame.get(2);
                    Object object3 = luaCallFrame.get(3);
                    if (!(object instanceof String && object2 instanceof String && object3 instanceof Double)) {
                        return 0;
                    }
                    try {
                        CoopMaster.this.softreset((String)object, (String)object2, ((Double)object3).intValue());
                        bl = true;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    DebugLog.log(DebugType.Network, "[CoopMaster] wrong number of arguments: " + n);
                }
                luaCallFrame.push(bl);
                return 1;
            }
        });
        kahluaTable2.rawset("isRunning", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                luaCallFrame.push(CoopMaster.this.isRunning());
                return 1;
            }
        });
        kahluaTable2.rawset("sendMessage", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                if (n == 4) {
                    Object object = luaCallFrame.get(1);
                    Object object2 = luaCallFrame.get(2);
                    Object object3 = luaCallFrame.get(3);
                    if (object instanceof String && object2 instanceof String && object3 instanceof String) {
                        CoopMaster.this.sendMessage((String)object, (String)object2, (String)object3);
                    }
                } else if (n == 3) {
                    Object object = luaCallFrame.get(1);
                    Object object4 = luaCallFrame.get(2);
                    if (object instanceof String && object4 instanceof String) {
                        CoopMaster.this.sendMessage((String)object, (String)object4);
                    }
                }
                return 0;
            }
        });
        kahluaTable2.rawset("getAdminPassword", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                luaCallFrame.push(CoopMaster.this.adminPassword);
                return 1;
            }
        });
        kahluaTable2.rawset("getTerminationReason", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                luaCallFrame.push(CoopMaster.this.serverTerminationReason.toString());
                return 1;
            }
        });
        kahluaTable2.rawset("getSteamID", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                if (CoopMaster.this.serverSteamID != null) {
                    luaCallFrame.push(SteamUtils.convertSteamIDToString(CoopMaster.this.serverSteamID));
                    return 1;
                }
                return 0;
            }
        });
        kahluaTable2.rawset("getAddress", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                luaCallFrame.push(CoopMaster.this.serverIP);
                return 1;
            }
        });
        kahluaTable2.rawset("getPort", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                luaCallFrame.push(CoopMaster.this.serverPort);
                return 1;
            }
        });
        kahluaTable2.rawset("abort", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                CoopMaster.this.abortServer();
                return 0;
            }
        });
        kahluaTable2.rawset("getServerSaveFolder", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                Object object = luaCallFrame.get(1);
                luaCallFrame.push(CoopMaster.this.getServerSaveFolder((String)object));
                return 1;
            }
        });
        kahluaTable2.rawset("getPlayerSaveFolder", (Object)new JavaFunction(){

            @Override
            public int call(LuaCallFrame luaCallFrame, int n) {
                Object object = luaCallFrame.get(1);
                luaCallFrame.push(CoopMaster.this.getPlayerSaveFolder((String)object));
                return 1;
            }
        });
        kahluaTable.rawset("CoopServer", (Object)kahluaTable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ICoopServerMessageListener iCoopServerMessageListener, ListenerOptions listenerOptions) {
        List<Pair<ICoopServerMessageListener, ListenerOptions>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(new Pair<ICoopServerMessageListener, ListenerOptions>(iCoopServerMessageListener, listenerOptions));
        }
    }

    public void addListener(ICoopServerMessageListener iCoopServerMessageListener) {
        this.addListener(iCoopServerMessageListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ICoopServerMessageListener iCoopServerMessageListener) {
        List<Pair<ICoopServerMessageListener, ListenerOptions>> list = this.listeners;
        synchronized (list) {
            int n;
            for (n = 0; n < this.listeners.size() && this.listeners.get((int)n).first != iCoopServerMessageListener; ++n) {
            }
            if (n < this.listeners.size()) {
                this.listeners.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeListeners(String string, String string2, String string3) {
        List<Pair<ICoopServerMessageListener, ListenerOptions>> list = this.listeners;
        synchronized (list) {
            Iterator<Pair<ICoopServerMessageListener, ListenerOptions>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Pair<ICoopServerMessageListener, ListenerOptions> pair = iterator.next();
                ICoopServerMessageListener iCoopServerMessageListener = (ICoopServerMessageListener)pair.first;
                ListenerOptions listenerOptions = (ListenerOptions)pair.second;
                if (iCoopServerMessageListener == null) continue;
                if (listenerOptions == null) {
                    iCoopServerMessageListener.OnCoopServerMessage(string, string2, string3);
                    continue;
                }
                if (listenerOptions.tag != null && !listenerOptions.tag.equals(string) || listenerOptions.cookie != null && !listenerOptions.cookie.equals(string2)) continue;
                if (listenerOptions.autoRemove) {
                    iterator.remove();
                }
                iCoopServerMessageListener.OnCoopServerMessage(string, string2, string3);
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerSaveFolder(String string) {
        return LuaManager.GlobalObject.sanitizeWorldName(string);
    }

    public String getPlayerSaveFolder(String string) {
        return LuaManager.GlobalObject.sanitizeWorldName(string + "_player");
    }

    public static enum TerminationReason {
        NormalTermination,
        Timeout;

    }

    public class ListenerOptions {
        public String tag = null;
        public String cookie = null;
        public boolean autoRemove = false;

        public ListenerOptions(String string, String string2, boolean bl) {
            this.tag = string;
            this.cookie = string2;
            this.autoRemove = bl;
        }

        public ListenerOptions(String string, String string2) {
            this(string, string2, false);
        }

        public ListenerOptions(String string) {
            this(string, null, false);
        }
    }

    private class Pair<K, V> {
        private final K first;
        private final V second;

        public Pair(K k, V v) {
            this.first = k;
            this.second = v;
        }

        public K getFirst() {
            return this.first;
        }

        public V getSecond() {
            return this.second;
        }
    }
}

