/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import java.util.Arrays;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.textures.Texture;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;

public final class ClientServerMap {
    private static final int ChunksPerServerCell = 5;
    private static final int SquaresPerServerCell = 50;
    int playerIndex;
    int centerX;
    int centerY;
    int chunkGridWidth;
    int width;
    boolean[] loaded;
    private static boolean[] isLoaded;
    private static Texture trafficCone;

    public ClientServerMap(int n, int n2, int n3, int n4) {
        this.playerIndex = n;
        this.centerX = n2;
        this.centerY = n3;
        this.chunkGridWidth = n4;
        this.width = (n4 - 1) * 10 / 50;
        if ((n4 - 1) * 10 % 50 != 0) {
            ++this.width;
        }
        ++this.width;
        this.loaded = new boolean[this.width * this.width];
    }

    public int getMinX() {
        return (this.centerX / 10 - this.chunkGridWidth / 2) / 5;
    }

    public int getMinY() {
        return (this.centerY / 10 - this.chunkGridWidth / 2) / 5;
    }

    public int getMaxX() {
        return this.getMinX() + this.width - 1;
    }

    public int getMaxY() {
        return this.getMinY() + this.width - 1;
    }

    public boolean isValidCell(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.width;
    }

    public boolean setLoaded() {
        if (!GameServer.bServer) {
            return false;
        }
        int n = ServerMap.instance.getMinX();
        int n2 = ServerMap.instance.getMinY();
        int n3 = this.getMinX();
        int n4 = this.getMinY();
        boolean bl = false;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                ServerMap.ServerCell serverCell = ServerMap.instance.getCell(n3 + j - n, n4 + i - n2);
                boolean bl2 = serverCell == null ? false : serverCell.bLoaded;
                bl |= this.loaded[j + i * this.width] != bl2;
                this.loaded[j + i * this.width] = bl2;
            }
        }
        return bl;
    }

    public boolean setPlayerPosition(int n, int n2) {
        if (!GameServer.bServer) {
            return false;
        }
        int n3 = this.getMinX();
        int n4 = this.getMinY();
        this.centerX = n;
        this.centerY = n2;
        return this.setLoaded() || n3 != this.getMinX() || n4 != this.getMinY();
    }

    public static boolean isChunkLoaded(int n, int n2) {
        if (!GameClient.bClient) {
            return false;
        }
        if (n < 0 || n2 < 0) {
            return false;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            int n3;
            int n4;
            ClientServerMap clientServerMap = GameClient.loadedCells[i];
            if (clientServerMap == null || !clientServerMap.isValidCell(n4 = n / 5 - clientServerMap.getMinX(), n3 = n2 / 5 - clientServerMap.getMinY()) || !clientServerMap.loaded[n4 + n3 * clientServerMap.width]) continue;
            return true;
        }
        return false;
    }

    public static void characterIn(UdpConnection udpConnection, int n) {
        if (!GameServer.bServer) {
            return;
        }
        ClientServerMap clientServerMap = udpConnection.loadedCells[n];
        if (clientServerMap == null) {
            return;
        }
        IsoPlayer isoPlayer = udpConnection.players[n];
        if (isoPlayer == null) {
            return;
        }
        if (clientServerMap.setPlayerPosition((int)isoPlayer.x, (int)isoPlayer.y)) {
            clientServerMap.sendPacket(udpConnection);
        }
    }

    public void sendPacket(UdpConnection udpConnection) {
        if (!GameServer.bServer) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ServerMap.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)this.playerIndex);
        byteBufferWriter.putInt(this.centerX);
        byteBufferWriter.putInt(this.centerY);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                byteBufferWriter.putBoolean(this.loaded[j + i * this.width]);
            }
        }
        PacketTypes.PacketType.ServerMap.send(udpConnection);
    }

    public static void receivePacket(ByteBuffer byteBuffer) {
        if (!GameClient.bClient) {
            return;
        }
        byte by = byteBuffer.get();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        ClientServerMap clientServerMap = GameClient.loadedCells[by];
        if (clientServerMap == null) {
            clientServerMap = GameClient.loadedCells[by] = new ClientServerMap(by, n, n2, IsoChunkMap.ChunkGridWidth);
        }
        clientServerMap.centerX = n;
        clientServerMap.centerY = n2;
        for (int i = 0; i < clientServerMap.width; ++i) {
            for (int j = 0; j < clientServerMap.width; ++j) {
                clientServerMap.loaded[j + i * clientServerMap.width] = byteBuffer.get() == 1;
            }
        }
    }

    public static void render(int n) {
        IsoChunk isoChunk;
        int n2;
        int n3;
        if (!GameClient.bClient) {
            return;
        }
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.getChunkMap(n);
        if (isoChunkMap == null || isoChunkMap.ignore) {
            return;
        }
        int n4 = Core.TileScale;
        int n5 = 10;
        float f = 0.1f;
        float f2 = 0.1f;
        float f3 = 0.1f;
        float f4 = 0.75f;
        float f5 = 0.0f;
        if (trafficCone == null) {
            trafficCone = Texture.getSharedTexture("street_decoration_01_26");
        }
        Texture texture = trafficCone;
        if (isLoaded == null || isLoaded.length < IsoChunkMap.ChunkGridWidth * IsoChunkMap.ChunkGridWidth) {
            isLoaded = new boolean[IsoChunkMap.ChunkGridWidth * IsoChunkMap.ChunkGridWidth];
        }
        for (n3 = 0; n3 < IsoChunkMap.ChunkGridWidth; ++n3) {
            for (n2 = 0; n2 < IsoChunkMap.ChunkGridWidth; ++n2) {
                isoChunk = isoChunkMap.getChunk(n2, n3);
                if (isoChunk == null) continue;
                ClientServerMap.isLoaded[n2 + n3 * IsoChunkMap.ChunkGridWidth] = ClientServerMap.isChunkLoaded(isoChunk.wx, isoChunk.wy);
            }
        }
        for (n3 = 0; n3 < IsoChunkMap.ChunkGridWidth; ++n3) {
            for (n2 = 0; n2 < IsoChunkMap.ChunkGridWidth; ++n2) {
                isoChunk = isoChunkMap.getChunk(n2, n3);
                if (isoChunk == null) continue;
                boolean bl = isLoaded[n2 + n3 * IsoChunkMap.ChunkGridWidth];
                if (bl && texture != null) {
                    IsoChunk isoChunk2;
                    float f6;
                    IsoChunk isoChunk3;
                    float f7;
                    IsoChunk isoChunk4;
                    float f8;
                    IsoChunk isoChunk5 = isoChunkMap.getChunk(n2, n3 - 1);
                    if (isoChunk5 != null && !isLoaded[n2 + (n3 - 1) * IsoChunkMap.ChunkGridWidth]) {
                        for (int i = 0; i < n5; ++i) {
                            float f9 = IsoUtils.XToScreenExact(isoChunk.wx * n5 + i, isoChunk.wy * n5, f5, 0);
                            f8 = IsoUtils.YToScreenExact(isoChunk.wx * n5 + i, isoChunk.wy * n5, f5, 0);
                            SpriteRenderer.instance.render(texture, f9 - (float)(texture.getWidth() / 2), f8, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, null);
                        }
                    }
                    if ((isoChunk4 = isoChunkMap.getChunk(n2, n3 + 1)) != null && !isLoaded[n2 + (n3 + 1) * IsoChunkMap.ChunkGridWidth]) {
                        for (int i = 0; i < n5; ++i) {
                            f8 = IsoUtils.XToScreenExact(isoChunk.wx * n5 + i, isoChunk.wy * n5 + (n5 - 1), f5, 0);
                            f7 = IsoUtils.YToScreenExact(isoChunk.wx * n5 + i, isoChunk.wy * n5 + (n5 - 1), f5, 0);
                            SpriteRenderer.instance.render(texture, f8 - (float)(texture.getWidth() / 2), f7, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, null);
                        }
                    }
                    if ((isoChunk3 = isoChunkMap.getChunk(n2 - 1, n3)) != null && !isLoaded[n2 - 1 + n3 * IsoChunkMap.ChunkGridWidth]) {
                        for (int i = 0; i < n5; ++i) {
                            f7 = IsoUtils.XToScreenExact(isoChunk.wx * n5, isoChunk.wy * n5 + i, f5, 0);
                            f6 = IsoUtils.YToScreenExact(isoChunk.wx * n5, isoChunk.wy * n5 + i, f5, 0);
                            SpriteRenderer.instance.render(texture, f7 - (float)(texture.getWidth() / 2), f6, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, null);
                        }
                    }
                    if ((isoChunk2 = isoChunkMap.getChunk(n2 + 1, n3)) != null && !isLoaded[n2 + 1 + n3 * IsoChunkMap.ChunkGridWidth]) {
                        for (int i = 0; i < n5; ++i) {
                            f6 = IsoUtils.XToScreenExact(isoChunk.wx * n5 + (n5 - 1), isoChunk.wy * n5 + i, f5, 0);
                            float f10 = IsoUtils.YToScreenExact(isoChunk.wx * n5 + (n5 - 1), isoChunk.wy * n5 + i, f5, 0);
                            SpriteRenderer.instance.render(texture, f6 - (float)(texture.getWidth() / 2), f10, texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, null);
                        }
                    }
                }
                if (bl) continue;
                float f11 = isoChunk.wx * n5;
                float f12 = isoChunk.wy * n5;
                float f13 = IsoUtils.XToScreenExact(f11, f12 + (float)n5, f5, 0);
                float f14 = IsoUtils.YToScreenExact(f11, f12 + (float)n5, f5, 0);
                SpriteRenderer.instance.renderPoly((int)f13, (int)f14, (int)(f13 + (float)(n5 * 64 / 2 * n4)), (int)(f14 - (float)(n5 * 32 / 2 * n4)), (int)(f13 + (float)(n5 * 64 * n4)), (int)f14, (int)(f13 + (float)(n5 * 64 / 2 * n4)), (int)(f14 + (float)(n5 * 32 / 2 * n4)), f, f2, f3, f4);
            }
        }
    }

    public static void Reset() {
        Arrays.fill(GameClient.loadedCells, null);
        trafficCone = null;
    }
}

