/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.core.raknet.UdpConnection;

public class ClientChunkRequest {
    public ArrayList<Chunk> chunks = new ArrayList(20);
    private static final ConcurrentLinkedQueue<Chunk> freeChunks = new ConcurrentLinkedQueue();
    public static final ConcurrentLinkedQueue<ByteBuffer> freeBuffers = new ConcurrentLinkedQueue();
    public boolean largeArea = false;
    int minX;
    int maxX;
    int minY;
    int maxY;

    public Chunk getChunk() {
        Chunk chunk = freeChunks.poll();
        if (chunk == null) {
            chunk = new Chunk();
        }
        return chunk;
    }

    public void releaseChunk(Chunk chunk) {
        this.releaseBuffer(chunk);
        freeChunks.add(chunk);
    }

    public void getByteBuffer(Chunk chunk) {
        chunk.bb = freeBuffers.poll();
        if (chunk.bb == null) {
            chunk.bb = ByteBuffer.allocate(16384);
        } else {
            chunk.bb.clear();
        }
    }

    public void releaseBuffer(Chunk chunk) {
        if (chunk.bb != null) {
            freeBuffers.add(chunk.bb);
            chunk.bb = null;
        }
    }

    public void releaseBuffers() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            this.chunks.get((int)i).bb = null;
        }
    }

    public void unpack(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        int n;
        for (n = 0; n < this.chunks.size(); ++n) {
            this.releaseBuffer(this.chunks.get(n));
        }
        freeChunks.addAll(this.chunks);
        this.chunks.clear();
        n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            Chunk chunk = this.getChunk();
            chunk.requestNumber = byteBuffer.getInt();
            chunk.wx = byteBuffer.getInt();
            chunk.wy = byteBuffer.getInt();
            chunk.crc = byteBuffer.getLong();
            this.chunks.add(chunk);
        }
        this.largeArea = false;
    }

    public void unpackLargeArea(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        int n;
        for (n = 0; n < this.chunks.size(); ++n) {
            this.releaseBuffer(this.chunks.get(n));
        }
        freeChunks.addAll(this.chunks);
        this.chunks.clear();
        this.minX = byteBuffer.getInt();
        this.minY = byteBuffer.getInt();
        this.maxX = byteBuffer.getInt();
        this.maxY = byteBuffer.getInt();
        for (n = this.minX; n < this.maxX; ++n) {
            int n2 = this.minY;
            while (n2 < this.maxY) {
                Chunk chunk = this.getChunk();
                chunk.requestNumber = byteBuffer.getInt();
                chunk.wx = n;
                chunk.wy = n2++;
                chunk.crc = 0L;
                this.releaseBuffer(chunk);
                this.chunks.add(chunk);
            }
        }
        this.largeArea = true;
    }

    public static final class Chunk {
        public int requestNumber;
        public int wx;
        public int wy;
        public long crc;
        public ByteBuffer bb;
    }
}

