/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import gnu.trove.map.hash.TIntLongHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.network.MPStatistic;

public class ChunkChecksum {
    private static final TIntLongHashMap checksumCache = new TIntLongHashMap();
    private static final StringBuilder stringBuilder = new StringBuilder(128);
    private static final CRC32 crc32 = new CRC32();
    private static final byte[] bytes = new byte[1024];

    private static void noise(String string) {
        if (Core.bDebug) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getChecksum(int n, int n2) throws IOException {
        MPStatistic.getInstance().ChunkChecksum.Start();
        long l = 0L;
        TIntLongHashMap tIntLongHashMap = checksumCache;
        synchronized (tIntLongHashMap) {
            int n3 = n + n2 * 30 * 1000;
            if (checksumCache.containsKey(n3)) {
                ChunkChecksum.noise(n + "," + n2 + " found in cache crc=" + checksumCache.get(n3));
                l = checksumCache.get(n3);
            } else {
                stringBuilder.setLength(0);
                stringBuilder.append(ZomboidFileSystem.instance.getGameModeCacheDir());
                stringBuilder.append(File.separator);
                stringBuilder.append(Core.GameSaveWorld);
                stringBuilder.append(File.separator);
                stringBuilder.append("map_");
                stringBuilder.append(n);
                stringBuilder.append("_");
                stringBuilder.append(n2);
                stringBuilder.append(".bin");
                l = ChunkChecksum.createChecksum(stringBuilder.toString());
                checksumCache.put(n3, l);
                ChunkChecksum.noise(n + "," + n2 + " read from disk crc=" + l);
            }
        }
        MPStatistic.getInstance().ChunkChecksum.End();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getChecksumIfExists(int n, int n2) throws IOException {
        long l = 0L;
        MPStatistic.getInstance().ChunkChecksum.Start();
        TIntLongHashMap tIntLongHashMap = checksumCache;
        synchronized (tIntLongHashMap) {
            int n3 = n + n2 * 30 * 1000;
            if (checksumCache.containsKey(n3)) {
                l = checksumCache.get(n3);
            }
        }
        MPStatistic.getInstance().ChunkChecksum.End();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setChecksum(int n, int n2, long l) {
        MPStatistic.getInstance().ChunkChecksum.Start();
        TIntLongHashMap tIntLongHashMap = checksumCache;
        synchronized (tIntLongHashMap) {
            int n3 = n + n2 * 30 * 1000;
            checksumCache.put(n3, l);
            ChunkChecksum.noise(n + "," + n2 + " set crc=" + l);
        }
        MPStatistic.getInstance().ChunkChecksum.End();
    }

    public static long createChecksum(String string) throws IOException {
        MPStatistic.getInstance().ChunkChecksum.Start();
        File file = new File(string);
        if (!file.exists()) {
            MPStatistic.getInstance().ChunkChecksum.End();
            return 0L;
        }
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            int n;
            crc32.reset();
            while ((n = ((InputStream)fileInputStream).read(bytes)) != -1) {
                crc32.update(bytes, 0, n);
            }
            long l = crc32.getValue();
            MPStatistic.getInstance().ChunkChecksum.End();
            long l2 = l;
            return l2;
        }
    }

    public static void Reset() {
        MPStatistic.getInstance().ChunkChecksum.Start();
        checksumCache.clear();
        MPStatistic.getInstance().ChunkChecksum.End();
    }
}

