/*
 * Decompiled with CFR 0.152.
 */
package zombie.modding;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.modding.ActiveMods;
import zombie.scripting.ScriptParser;
import zombie.util.StringUtils;

public final class ActiveModsFile {
    private static final int VERSION1 = 1;
    private static final int VERSION = 1;

    public boolean write(String string, ActiveMods activeMods) {
        if (Core.getInstance().isNoSave()) {
            return false;
        }
        File file = new File(string);
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            String string2 = this.toString(activeMods);
            bufferedWriter.write(string2);
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
        return true;
    }

    private String toString(ActiveMods activeMods) {
        ScriptParser.Block block = new ScriptParser.Block();
        block.setValue("VERSION", String.valueOf(1));
        ScriptParser.Block block2 = block.addBlock("mods", null);
        ArrayList<String> arrayList = activeMods.getMods();
        for (int i = 0; i < arrayList.size(); ++i) {
            block2.addValue("mod", arrayList.get(i));
        }
        ScriptParser.Block block3 = block.addBlock("maps", null);
        ArrayList<String> arrayList2 = activeMods.getMapOrder();
        for (int i = 0; i < arrayList2.size(); ++i) {
            block3.addValue("map", arrayList2.get(i));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        block.prettyPrintElements(0, stringBuilder, string);
        return stringBuilder.toString();
    }

    public boolean read(String string, ActiveMods activeMods) {
        activeMods.clear();
        try (FileReader fileReader = new FileReader(string);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                string2 = bufferedReader.readLine();
            }
            this.fromString(stringBuilder.toString(), activeMods);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
        return true;
    }

    private void fromString(String string, ActiveMods activeMods) {
        String string2;
        Object object;
        string = ScriptParser.stripComments(string);
        ScriptParser.Block block = ScriptParser.parse(string);
        int n = -1;
        ScriptParser.Value value = block.getValue("VERSION");
        if (value != null) {
            n = PZMath.tryParseInt(value.getValue(), -1);
        }
        if (n < 1 || n > 1) {
            return;
        }
        ScriptParser.Block block2 = block.getBlock("mods", null);
        if (block2 != null) {
            object = block2.values.iterator();
            while (object.hasNext()) {
                ScriptParser.Value value2 = (ScriptParser.Value)object.next();
                String object2 = value2.getKey().trim();
                if (!object2.equalsIgnoreCase("mod") || StringUtils.isNullOrWhitespace(string2 = value2.getValue().trim())) continue;
                activeMods.getMods().add(string2);
            }
        }
        if ((object = block.getBlock("maps", null)) != null) {
            for (ScriptParser.Value value2 : ((ScriptParser.Block)object).values) {
                String string3;
                string2 = value2.getKey().trim();
                if (!string2.equalsIgnoreCase("map") || StringUtils.isNullOrWhitespace(string3 = value2.getValue().trim())) continue;
                activeMods.getMapOrder().add(string3);
            }
        }
    }
}

