/*
 * Decompiled with CFR 0.152.
 */
package zombie.modding;

import java.util.ArrayList;
import java.util.Objects;
import zombie.GameWindow;
import zombie.MapGroups;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.debug.DebugOptions;
import zombie.gameStates.ChooseGameInfo;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.util.StringUtils;

public final class ActiveMods {
    private static final ArrayList<ActiveMods> s_activeMods = new ArrayList();
    private static final ActiveMods s_loaded = new ActiveMods("loaded");
    private final String id;
    private final ArrayList<String> mods = new ArrayList();
    private final ArrayList<String> mapOrder = new ArrayList();

    private static int count() {
        return s_activeMods.size();
    }

    public static ActiveMods getByIndex(int n) {
        return s_activeMods.get(n);
    }

    public static ActiveMods getById(String string) {
        int n = ActiveMods.indexOf(string);
        if (n == -1) {
            return ActiveMods.create(string);
        }
        return s_activeMods.get(n);
    }

    public static int indexOf(String string) {
        string = string.trim();
        ActiveMods.requireValidId(string);
        for (int i = 0; i < s_activeMods.size(); ++i) {
            ActiveMods activeMods = s_activeMods.get(i);
            if (!activeMods.id.equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private static ActiveMods create(String string) {
        ActiveMods.requireValidId(string);
        if (ActiveMods.indexOf(string) != -1) {
            throw new IllegalStateException("id \"" + string + "\" exists");
        }
        ActiveMods activeMods = new ActiveMods(string);
        s_activeMods.add(activeMods);
        return activeMods;
    }

    private static void requireValidId(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("id is null or whitespace");
        }
    }

    public static void setLoadedMods(ActiveMods activeMods) {
        if (activeMods == null) {
            return;
        }
        s_loaded.copyFrom(activeMods);
    }

    public static boolean requiresResetLua(ActiveMods activeMods) {
        Objects.requireNonNull(activeMods);
        return !ActiveMods.s_loaded.mods.equals(activeMods.mods);
    }

    public static void renderUI() {
        int n;
        int n2;
        if (!DebugOptions.instance.ModRenderLoaded.getValue()) {
            return;
        }
        if (GameWindow.DrawReloadingLua) {
            return;
        }
        UIFont uIFont = UIFont.DebugConsole;
        int n3 = TextManager.instance.getFontHeight(uIFont);
        String string = "Active Mods:";
        int n4 = TextManager.instance.MeasureStringX(uIFont, string);
        for (n2 = 0; n2 < ActiveMods.s_loaded.mods.size(); ++n2) {
            String string2 = ActiveMods.s_loaded.mods.get(n2);
            n = TextManager.instance.MeasureStringX(uIFont, string2);
            n4 = Math.max(n4, n);
        }
        n2 = 10;
        int n5 = Core.width - 20 - (n4 += n2 * 2);
        n = 20;
        int n6 = (1 + ActiveMods.s_loaded.mods.size()) * n3 + n2 * 2;
        SpriteRenderer.instance.renderi(null, n5, n, n4, n6, 0.0f, 0.5f, 0.75f, 1.0f, null);
        TextManager.instance.DrawString(uIFont, n5 + n2, n += n2, string, 1.0, 1.0, 1.0, 1.0);
        for (int i = 0; i < ActiveMods.s_loaded.mods.size(); ++i) {
            String string3 = ActiveMods.s_loaded.mods.get(i);
            TextManager.instance.DrawString(uIFont, n5 + n2, n += n3, string3, 1.0, 1.0, 1.0, 1.0);
        }
    }

    public static void Reset() {
        s_loaded.clear();
    }

    public ActiveMods(String string) {
        ActiveMods.requireValidId(string);
        this.id = string;
    }

    public void clear() {
        this.mods.clear();
        this.mapOrder.clear();
    }

    public ArrayList<String> getMods() {
        return this.mods;
    }

    public ArrayList<String> getMapOrder() {
        return this.mapOrder;
    }

    public void copyFrom(ActiveMods activeMods) {
        this.mods.clear();
        this.mapOrder.clear();
        this.mods.addAll(activeMods.mods);
        this.mapOrder.addAll(activeMods.mapOrder);
    }

    public void setModActive(String string, boolean bl) {
        if (StringUtils.isNullOrWhitespace(string = string.trim())) {
            return;
        }
        if (bl) {
            if (!this.mods.contains(string)) {
                this.mods.add(string);
            }
        } else {
            this.mods.remove(string);
        }
    }

    public boolean isModActive(String string) {
        if (StringUtils.isNullOrWhitespace(string = string.trim())) {
            return false;
        }
        return this.mods.contains(string);
    }

    public void removeMod(String string) {
        string = string.trim();
        this.mods.remove(string);
    }

    public void removeMapOrder(String string) {
        this.mapOrder.remove(string);
    }

    public void checkMissingMods() {
        if (this.mods.isEmpty()) {
            return;
        }
        for (int i = this.mods.size() - 1; i >= 0; --i) {
            String string = this.mods.get(i);
            if (ChooseGameInfo.getAvailableModDetails(string) != null) continue;
            this.mods.remove(i);
        }
    }

    public void checkMissingMaps() {
        if (this.mapOrder.isEmpty()) {
            return;
        }
        MapGroups mapGroups = new MapGroups();
        mapGroups.createGroups(this, false);
        if (mapGroups.checkMapConflicts()) {
            ArrayList<String> arrayList = mapGroups.getAllMapsInOrder();
            for (int i = this.mapOrder.size() - 1; i >= 0; --i) {
                String string = this.mapOrder.get(i);
                if (arrayList.contains(string)) continue;
                this.mapOrder.remove(i);
            }
        } else {
            this.mapOrder.clear();
        }
    }
}

