/*
 * Decompiled with CFR 0.152.
 */
package zombie.meta;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import zombie.GameTime;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.areas.SafeHouse;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class Meta {
    public static final Meta instance = new Meta();
    final ArrayList<IsoGridSquare> SquaresProcessing = new ArrayList();
    private final ArrayList<IsoGridSquare> SquaresSeen = new ArrayList(2000);
    private final TIntHashSet SquaresSeenSet = new TIntHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealWithSquareSeen(IsoGridSquare isoGridSquare) {
        if (GameClient.bClient) {
            return;
        }
        if (isoGridSquare.hourLastSeen == (int)GameTime.getInstance().getWorldAgeHours()) {
            return;
        }
        ArrayList<IsoGridSquare> arrayList = this.SquaresSeen;
        synchronized (arrayList) {
            if (!this.SquaresSeenSet.contains(isoGridSquare.getID().intValue())) {
                this.SquaresSeen.add(isoGridSquare);
                this.SquaresSeenSet.add(isoGridSquare.getID().intValue());
            }
        }
    }

    public void dealWithSquareSeenActual(IsoGridSquare isoGridSquare) {
        SafeHouse safeHouse;
        if (GameClient.bClient) {
            return;
        }
        IsoMetaGrid.Zone zone = isoGridSquare.zone;
        if (zone != null) {
            zone.setHourSeenToCurrent();
        }
        if (GameServer.bServer && (safeHouse = SafeHouse.getSafeHouse(isoGridSquare)) != null) {
            safeHouse.updateSafehouse(null);
        }
        isoGridSquare.setHourSeenToCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (GameClient.bClient) {
            return;
        }
        this.SquaresProcessing.clear();
        ArrayList<IsoGridSquare> arrayList = this.SquaresSeen;
        synchronized (arrayList) {
            this.SquaresProcessing.addAll(this.SquaresSeen);
            this.SquaresSeen.clear();
            this.SquaresSeenSet.clear();
        }
        for (int i = 0; i < this.SquaresProcessing.size(); ++i) {
            this.dealWithSquareSeenActual(this.SquaresProcessing.get(i));
        }
        this.SquaresProcessing.clear();
    }
}

