/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fx;

import java.io.Serializable;
import java.util.ArrayList;
import org.joml.Vector2i;
import org.joml.Vector3f;
import zombie.IndieGL;
import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderSettings;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureFBO;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.input.GameKeyboard;
import zombie.iso.DiamondMatrixIterator;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.regions.IWorldRegion;
import zombie.iso.areas.isoregion.regions.IsoWorldRegion;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.network.GameServer;

public class WeatherFxMask {
    private static boolean DEBUG_KEYS = false;
    private static TextureFBO fboMask;
    private static TextureFBO fboParticles;
    public static IsoSprite floorSprite;
    public static IsoSprite wallNSprite;
    public static IsoSprite wallWSprite;
    public static IsoSprite wallNWSprite;
    public static IsoSprite wallSESprite;
    private static Texture texWhite;
    private static int curPlayerIndex;
    public static final int BIT_FLOOR = 0;
    public static final int BIT_WALLN = 1;
    public static final int BIT_WALLW = 2;
    public static final int BIT_IS_CUT = 4;
    public static final int BIT_CHARS = 8;
    public static final int BIT_OBJECTS = 16;
    public static final int BIT_WALL_SE = 32;
    public static final int BIT_DOOR = 64;
    public static float offsetX;
    public static float offsetY;
    public static ColorInfo defColorInfo;
    private static int DIAMOND_ROWS;
    public int x;
    public int y;
    public int z;
    public int flags;
    public IsoGridSquare gs;
    public boolean enabled;
    private static PlayerFxMask[] playerMasks;
    private static DiamondMatrixIterator dmiter;
    private static final Vector2i diamondMatrixPos;
    private static Vector3f tmpVec;
    private static IsoGameCharacter.TorchInfo tmpTorch;
    private static ColorInfo tmpColInfo;
    private static int[] test;
    private static String[] testNames;
    private static int var1;
    private static int var2;
    private static float var3;
    private static int SCR_MASK_ADD;
    private static int DST_MASK_ADD;
    private static int SCR_MASK_SUB;
    private static int DST_MASK_SUB;
    private static int SCR_PARTICLES;
    private static int DST_PARTICLES;
    private static int SCR_MERGE;
    private static int DST_MERGE;
    private static int SCR_FINAL;
    private static int DST_FINAL;
    private static int ID_SCR_MASK_ADD;
    private static int ID_DST_MASK_ADD;
    private static int ID_SCR_MASK_SUB;
    private static int ID_DST_MASK_SUB;
    private static int ID_SCR_MERGE;
    private static int ID_DST_MERGE;
    private static int ID_SCR_FINAL;
    private static int ID_DST_FINAL;
    private static int ID_SCR_PARTICLES;
    private static int ID_DST_PARTICLES;
    private static int TARGET_BLEND;
    private static boolean DEBUG_MASK;
    public static boolean MASKING_ENABLED;
    private static boolean DEBUG_MASK_AND_PARTICLES;
    private static final boolean DEBUG_THROTTLE_KEYS = true;
    private static int keypause;

    public static TextureFBO getFboMask() {
        return fboMask;
    }

    public static TextureFBO getFboParticles() {
        return fboParticles;
    }

    public static void init() throws Exception {
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < playerMasks.length; ++i) {
            WeatherFxMask.playerMasks[i] = new PlayerFxMask();
        }
        playerMasks[0].init();
        WeatherFxMask.initGlIds();
        floorSprite = IsoSpriteManager.instance.getSprite("floors_interior_tilesandwood_01_16");
        wallNSprite = IsoSpriteManager.instance.getSprite("walls_interior_house_01_21");
        wallWSprite = IsoSpriteManager.instance.getSprite("walls_interior_house_01_20");
        wallNWSprite = IsoSpriteManager.instance.getSprite("walls_interior_house_01_22");
        wallSESprite = IsoSpriteManager.instance.getSprite("walls_interior_house_01_23");
        texWhite = Texture.getSharedTexture("media/textures/weather/fogwhite.png");
    }

    public static boolean checkFbos() {
        if (GameServer.bServer) {
            return false;
        }
        TextureFBO textureFBO = Core.getInstance().getOffscreenBuffer();
        if (Core.getInstance().getOffscreenBuffer() == null) {
            DebugLog.log("fbo=" + (textureFBO != null));
            return false;
        }
        int n = Core.getInstance().getScreenWidth();
        int n2 = Core.getInstance().getScreenHeight();
        if (fboMask == null || fboParticles == null || fboMask.getTexture().getWidth() != n || fboMask.getTexture().getHeight() != n2) {
            Texture texture;
            if (fboMask != null) {
                fboMask.destroy();
            }
            if (fboParticles != null) {
                fboParticles.destroy();
            }
            fboMask = null;
            fboParticles = null;
            try {
                texture = new Texture(n, n2, 16);
                fboMask = new TextureFBO(texture);
            }
            catch (Exception exception) {
                DebugLog.log(exception.getStackTrace());
                exception.printStackTrace();
            }
            try {
                texture = new Texture(n, n2, 16);
                fboParticles = new TextureFBO(texture);
            }
            catch (Exception exception) {
                DebugLog.log(exception.getStackTrace());
                exception.printStackTrace();
            }
            return fboMask != null && fboParticles != null;
        }
        return fboMask != null && fboParticles != null;
    }

    public static void destroy() {
        if (fboMask != null) {
            fboMask.destroy();
        }
        fboMask = null;
        if (fboParticles != null) {
            fboParticles.destroy();
        }
        fboParticles = null;
    }

    public static void initMask() {
        if (GameServer.bServer) {
            return;
        }
        curPlayerIndex = IsoCamera.frameState.playerIndex;
        playerMasks[curPlayerIndex].initMask();
    }

    private static boolean isOnScreen(int n, int n2, int n3) {
        float f = (int)IsoUtils.XToScreenInt(n, n2, n3, 0);
        float f2 = (int)IsoUtils.YToScreenInt(n, n2, n3, 0);
        f -= (float)((int)IsoCamera.frameState.OffX);
        f2 -= (float)((int)IsoCamera.frameState.OffY);
        if (f + (float)(32 * Core.TileScale) <= 0.0f) {
            return false;
        }
        if (f2 + (float)(32 * Core.TileScale) <= 0.0f) {
            return false;
        }
        if (f - (float)(32 * Core.TileScale) >= (float)IsoCamera.frameState.OffscreenWidth) {
            return false;
        }
        return !(f2 - (float)(96 * Core.TileScale) >= (float)IsoCamera.frameState.OffscreenHeight);
    }

    public boolean isLoc(int n, int n2, int n3) {
        return this.x == n && this.y == n2 && this.z == n3;
    }

    public static boolean playerHasMaskToDraw(int n) {
        if (n < playerMasks.length) {
            return WeatherFxMask.playerMasks[n].hasMaskToDraw;
        }
        return false;
    }

    public static void setDiamondIterDone(int n) {
        if (n < playerMasks.length) {
            WeatherFxMask.playerMasks[n].DIAMOND_ITER_DONE = true;
        }
    }

    public static void forceMaskUpdate(int n) {
        if (n < playerMasks.length) {
            WeatherFxMask.playerMasks[n].plrSquare = null;
        }
    }

    public static void forceMaskUpdateAll() {
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < playerMasks.length; ++i) {
            WeatherFxMask.playerMasks[i].plrSquare = null;
        }
    }

    private static boolean getIsStairs(IsoGridSquare isoGridSquare) {
        return isoGridSquare != null && (isoGridSquare.Has(IsoObjectType.stairsBN) || isoGridSquare.Has(IsoObjectType.stairsBW) || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsMW) || isoGridSquare.Has(IsoObjectType.stairsTN) || isoGridSquare.Has(IsoObjectType.stairsTW));
    }

    private static boolean getHasDoor(IsoGridSquare isoGridSquare) {
        if (isoGridSquare != null && (isoGridSquare.Is(IsoFlagType.cutN) || isoGridSquare.Is(IsoFlagType.cutW)) && (isoGridSquare.Is(IsoFlagType.DoorWallN) || isoGridSquare.Is(IsoFlagType.DoorWallW)) && !isoGridSquare.Is(IsoFlagType.doorN) && !isoGridSquare.Is(IsoFlagType.doorW)) {
            return isoGridSquare.getCanSee(curPlayerIndex);
        }
        return false;
    }

    public static void addMaskLocation(IsoGridSquare isoGridSquare, int n, int n2, int n3) {
        if (GameServer.bServer) {
            return;
        }
        PlayerFxMask playerFxMask = playerMasks[curPlayerIndex];
        if (!playerFxMask.requiresUpdate) {
            return;
        }
        if (!playerFxMask.hasMaskToDraw || playerFxMask.playerZ != n3) {
            return;
        }
        if (WeatherFxMask.isInPlayerBuilding(isoGridSquare, n, n2, n3)) {
            int n4;
            IsoGridSquare isoGridSquare2 = IsoWorld.instance.getCell().getChunkMap(curPlayerIndex).getGridSquare(n, n2 - 1, n3);
            boolean bl = !WeatherFxMask.isInPlayerBuilding(isoGridSquare2, n, n2 - 1, n3);
            isoGridSquare2 = IsoWorld.instance.getCell().getChunkMap(curPlayerIndex).getGridSquare(n - 1, n2, n3);
            boolean bl2 = !WeatherFxMask.isInPlayerBuilding(isoGridSquare2, n - 1, n2, n3);
            isoGridSquare2 = IsoWorld.instance.getCell().getChunkMap(curPlayerIndex).getGridSquare(n - 1, n2 - 1, n3);
            boolean bl3 = !WeatherFxMask.isInPlayerBuilding(isoGridSquare2, n - 1, n2 - 1, n3);
            int n5 = 0;
            if (bl) {
                n5 |= 1;
            }
            if (bl2) {
                n5 |= 2;
            }
            if (bl3) {
                n5 |= 0x20;
            }
            boolean bl4 = false;
            boolean bl5 = WeatherFxMask.getIsStairs(isoGridSquare);
            if (isoGridSquare != null && (bl || bl2 || bl3)) {
                n4 = 24;
                if (bl && !isoGridSquare.getProperties().Is(IsoFlagType.WallN) && !isoGridSquare.Is(IsoFlagType.WallNW)) {
                    playerFxMask.addMask(n - 1, n2, n3, null, 8, false);
                    playerFxMask.addMask(n, n2, n3, isoGridSquare, n4);
                    playerFxMask.addMask(n + 1, n2, n3, null, n4, false);
                    playerFxMask.addMask(n + 2, n2, n3, null, 8, false);
                    playerFxMask.addMask(n, n2 + 1, n3, null, 8, false);
                    playerFxMask.addMask(n + 1, n2 + 1, n3, null, n4, false);
                    playerFxMask.addMask(n + 2, n2 + 1, n3, null, n4, false);
                    playerFxMask.addMask(n + 2, n2 + 2, n3, null, 16, false);
                    playerFxMask.addMask(n + 3, n2 + 2, n3, null, 16, false);
                    bl4 = true;
                }
                if (bl2 && !isoGridSquare.getProperties().Is(IsoFlagType.WallW) && !isoGridSquare.getProperties().Is(IsoFlagType.WallNW)) {
                    playerFxMask.addMask(n, n2 - 1, n3, null, 8, false);
                    playerFxMask.addMask(n, n2, n3, isoGridSquare, n4);
                    playerFxMask.addMask(n, n2 + 1, n3, null, n4, false);
                    playerFxMask.addMask(n, n2 + 2, n3, null, 8, false);
                    playerFxMask.addMask(n + 1, n2, n3, null, 8, false);
                    playerFxMask.addMask(n + 1, n2 + 1, n3, null, n4, false);
                    playerFxMask.addMask(n + 1, n2 + 2, n3, null, n4, false);
                    playerFxMask.addMask(n + 2, n2 + 2, n3, null, 16, false);
                    playerFxMask.addMask(n + 2, n2 + 3, n3, null, 16, false);
                    bl4 = true;
                }
                if (bl3) {
                    int n6 = bl5 ? n4 : n5;
                    playerFxMask.addMask(n, n2, n3, isoGridSquare, n6);
                    bl4 = true;
                }
            }
            if (!bl4) {
                n4 = bl5 ? 24 : n5;
                playerFxMask.addMask(n, n2, n3, isoGridSquare, n4);
            }
        } else {
            IsoGridSquare isoGridSquare3 = IsoWorld.instance.getCell().getChunkMap(curPlayerIndex).getGridSquare(n, n2 - 1, n3);
            boolean bl = WeatherFxMask.isInPlayerBuilding(isoGridSquare3, n, n2 - 1, n3);
            isoGridSquare3 = IsoWorld.instance.getCell().getChunkMap(curPlayerIndex).getGridSquare(n - 1, n2, n3);
            boolean bl6 = WeatherFxMask.isInPlayerBuilding(isoGridSquare3, n - 1, n2, n3);
            if (bl || bl6) {
                int n7 = 4;
                if (bl) {
                    n7 |= 1;
                }
                if (bl6) {
                    n7 |= 2;
                }
                if (WeatherFxMask.getHasDoor(isoGridSquare)) {
                    n7 |= 0x40;
                }
                playerFxMask.addMask(n, n2, n3, isoGridSquare, n7);
            } else {
                isoGridSquare3 = IsoWorld.instance.getCell().getChunkMap(curPlayerIndex).getGridSquare(n - 1, n2 - 1, n3);
                if (WeatherFxMask.isInPlayerBuilding(isoGridSquare3, n - 1, n2 - 1, n3)) {
                    playerFxMask.addMask(n, n2, n3, isoGridSquare, 4);
                }
            }
        }
    }

    private static boolean isInPlayerBuilding(IsoGridSquare isoGridSquare, int n, int n2, int n3) {
        PlayerFxMask playerFxMask = playerMasks[curPlayerIndex];
        if (isoGridSquare != null && isoGridSquare.Is(IsoFlagType.solidfloor)) {
            if (isoGridSquare.getBuilding() != null && isoGridSquare.getBuilding() == playerFxMask.player.getBuilding()) {
                return true;
            }
            if (isoGridSquare.getBuilding() == null) {
                return playerFxMask.curIsoWorldRegion != null && isoGridSquare.getIsoWorldRegion() != null && isoGridSquare.getIsoWorldRegion().isFogMask() && (isoGridSquare.getIsoWorldRegion() == playerFxMask.curIsoWorldRegion || playerFxMask.curConnectedRegions.contains(isoGridSquare.getIsoWorldRegion()));
            }
        } else {
            if (WeatherFxMask.isInteriorLocation(n, n2, n3)) {
                return true;
            }
            if (isoGridSquare != null && isoGridSquare.getBuilding() == null) {
                return playerFxMask.curIsoWorldRegion != null && isoGridSquare.getIsoWorldRegion() != null && isoGridSquare.getIsoWorldRegion().isFogMask() && (isoGridSquare.getIsoWorldRegion() == playerFxMask.curIsoWorldRegion || playerFxMask.curConnectedRegions.contains(isoGridSquare.getIsoWorldRegion()));
            }
            if (isoGridSquare == null && playerFxMask.curIsoWorldRegion != null) {
                IWorldRegion iWorldRegion = IsoRegions.getIsoWorldRegion(n, n2, n3);
                return iWorldRegion != null && iWorldRegion.isFogMask() && (iWorldRegion == playerFxMask.curIsoWorldRegion || playerFxMask.curConnectedRegions.contains(iWorldRegion));
            }
        }
        return false;
    }

    private static boolean isInteriorLocation(int n, int n2, int n3) {
        PlayerFxMask playerFxMask = playerMasks[curPlayerIndex];
        for (int i = n3; i >= 0; --i) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.getCell().getChunkMap(curPlayerIndex).getGridSquare(n, n2, i);
            if (isoGridSquare == null) continue;
            if (isoGridSquare.getBuilding() != null && isoGridSquare.getBuilding() == playerFxMask.player.getBuilding()) {
                return true;
            }
            if (!isoGridSquare.Is(IsoFlagType.exterior)) continue;
            return false;
        }
        return false;
    }

    private static void scanForTiles(int n) {
        PlayerFxMask playerFxMask = playerMasks[curPlayerIndex];
        if (playerFxMask.DIAMOND_ITER_DONE) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        int n2 = (int)isoPlayer.getZ();
        int n3 = 0;
        int n4 = 0;
        int n5 = n3 + IsoCamera.getOffscreenWidth(n);
        int n6 = n4 + IsoCamera.getOffscreenHeight(n);
        float f = IsoUtils.XToIso(n3, n4, 0.0f);
        float f2 = IsoUtils.YToIso(n5, n4, 0.0f);
        float f3 = IsoUtils.XToIso(n5, n6, 6.0f);
        float f4 = IsoUtils.YToIso(n3, n6, 6.0f);
        float f5 = IsoUtils.XToIso(n5, n4, 0.0f);
        int n7 = (int)f2;
        int n8 = (int)f4;
        int n9 = (int)f;
        int n10 = (int)f3;
        DIAMOND_ROWS = (int)f5 * 4;
        n7 -= 2;
        dmiter.reset(n10 - (n9 -= 2));
        Vector2i vector2i = diamondMatrixPos;
        IsoChunkMap isoChunkMap = IsoWorld.instance.getCell().getChunkMap(n);
        while (dmiter.next(vector2i)) {
            if (vector2i == null) continue;
            IsoGridSquare isoGridSquare = isoChunkMap.getGridSquare(vector2i.x + n9, vector2i.y + n7, n2);
            if (isoGridSquare == null) {
                WeatherFxMask.addMaskLocation(null, vector2i.x + n9, vector2i.y + n7, n2);
                continue;
            }
            IsoChunk isoChunk = isoGridSquare.getChunk();
            if (isoChunk == null || !isoGridSquare.IsOnScreen()) continue;
            WeatherFxMask.addMaskLocation(isoGridSquare, vector2i.x + n9, vector2i.y + n7, n2);
        }
    }

    private static void renderMaskFloor(int n, int n2, int n3) {
        floorSprite.render(null, n, n2, n3, IsoDirections.N, offsetX, offsetY, defColorInfo, false);
    }

    private static void renderMaskWall(IsoGridSquare isoGridSquare, int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        IsoDirections isoDirections;
        IsoSprite isoSprite;
        boolean bl3;
        if (isoGridSquare == null) {
            return;
        }
        IsoGridSquare isoGridSquare2 = isoGridSquare.nav[IsoDirections.S.index()];
        IsoGridSquare isoGridSquare3 = isoGridSquare.nav[IsoDirections.E.index()];
        long l = System.currentTimeMillis();
        boolean bl4 = isoGridSquare2 != null && isoGridSquare2.getPlayerCutawayFlag(n4, l);
        boolean bl5 = isoGridSquare.getPlayerCutawayFlag(n4, l);
        boolean bl6 = bl3 = isoGridSquare3 != null && isoGridSquare3.getPlayerCutawayFlag(n4, l);
        if (bl && bl2) {
            isoSprite = wallNWSprite;
            isoDirections = IsoDirections.NW;
        } else if (bl) {
            isoSprite = wallNSprite;
            isoDirections = IsoDirections.N;
        } else if (bl2) {
            isoSprite = wallWSprite;
            isoDirections = IsoDirections.W;
        } else {
            isoSprite = wallSESprite;
            isoDirections = IsoDirections.W;
        }
        isoGridSquare.DoCutawayShaderSprite(isoSprite, isoDirections, bl4, bl5, bl3);
    }

    private static void renderMaskWallNoCuts(int n, int n2, int n3, boolean bl, boolean bl2) {
        if (bl && bl2) {
            wallNWSprite.render(null, n, n2, n3, IsoDirections.N, offsetX, offsetY, defColorInfo, false);
        } else if (bl) {
            wallNSprite.render(null, n, n2, n3, IsoDirections.N, offsetX, offsetY, defColorInfo, false);
        } else if (bl2) {
            wallWSprite.render(null, n, n2, n3, IsoDirections.N, offsetX, offsetY, defColorInfo, false);
        } else {
            wallSESprite.render(null, n, n2, n3, IsoDirections.N, offsetX, offsetY, defColorInfo, false);
        }
    }

    public static void renderFxMask(int n) {
        if (!DebugOptions.instance.Weather.Fx.getValue()) {
            return;
        }
        if (GameServer.bServer) {
            return;
        }
        if (IsoWeatherFX.instance == null) {
            return;
        }
        if (LuaManager.thread != null && LuaManager.thread.bStep) {
            return;
        }
        if (DEBUG_KEYS && Core.bDebug) {
            WeatherFxMask.updateDebugKeys();
        }
        if (!WeatherFxMask.playerMasks[n].maskEnabled) {
            return;
        }
        PlayerFxMask playerFxMask = playerMasks[curPlayerIndex];
        if (!playerFxMask.maskEnabled) {
            return;
        }
        if (MASKING_ENABLED && !WeatherFxMask.checkFbos()) {
            MASKING_ENABLED = false;
        }
        if (!MASKING_ENABLED || !playerFxMask.hasMaskToDraw) {
            if (IsoWorld.instance.getCell() != null && IsoWorld.instance.getCell().getWeatherFX() != null) {
                SpriteRenderer.instance.glIgnoreStyles(true);
                SpriteRenderer.instance.glBlendFunc(770, 771);
                IsoWorld.instance.getCell().getWeatherFX().render();
                SpriteRenderer.instance.glIgnoreStyles(false);
            }
            return;
        }
        WeatherFxMask.scanForTiles(n);
        int n2 = IsoCamera.getOffscreenLeft(n);
        int n3 = IsoCamera.getOffscreenTop(n);
        int n4 = IsoCamera.getOffscreenWidth(n);
        int n5 = IsoCamera.getOffscreenHeight(n);
        int n6 = IsoCamera.getScreenWidth(n);
        int n7 = IsoCamera.getScreenHeight(n);
        SpriteRenderer.instance.glIgnoreStyles(true);
        if (MASKING_ENABLED) {
            SpriteRenderer.instance.glBuffer(4, n);
            SpriteRenderer.instance.glDoStartFrameFx(n4, n5, n);
            if (PerformanceSettings.LightingFrameSkip < 3) {
                IsoWorld.instance.getCell().DrawStencilMask();
                SpriteRenderer.instance.glClearColor(0, 0, 0, 0);
                SpriteRenderer.instance.glClear(16640);
                SpriteRenderer.instance.glClearColor(0, 0, 0, 255);
            }
            boolean bl = true;
            boolean bl2 = false;
            WeatherFxMask[] weatherFxMaskArray = WeatherFxMask.playerMasks[n].masks;
            int n8 = WeatherFxMask.playerMasks[n].maskPointer;
            for (int i = 0; i < n8; ++i) {
                boolean bl3;
                boolean bl4;
                boolean bl5;
                WeatherFxMask weatherFxMask = weatherFxMaskArray[i];
                if (!weatherFxMask.enabled) continue;
                if ((weatherFxMask.flags & 4) == 4) {
                    boolean bl6;
                    SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
                    SpriteRenderer.instance.glBlendFunc(SCR_MASK_SUB, DST_MASK_SUB);
                    SpriteRenderer.instance.glBlendEquation(32779);
                    IndieGL.enableAlphaTest();
                    IndieGL.glAlphaFunc(516, 0.02f);
                    SpriteRenderer.GL_BLENDFUNC_ENABLED = false;
                    bl5 = (weatherFxMask.flags & 1) == 1;
                    bl4 = (weatherFxMask.flags & 2) == 2;
                    WeatherFxMask.renderMaskWall(weatherFxMask.gs, weatherFxMask.x, weatherFxMask.y, weatherFxMask.z, bl5, bl4, n);
                    SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
                    SpriteRenderer.instance.glBlendEquation(32774);
                    SpriteRenderer.GL_BLENDFUNC_ENABLED = false;
                    boolean bl7 = bl6 = (weatherFxMask.flags & 0x40) == 64;
                    if (!bl6 || weatherFxMask.gs == null) continue;
                    SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
                    SpriteRenderer.instance.glBlendFunc(SCR_MASK_ADD, DST_MASK_ADD);
                    SpriteRenderer.GL_BLENDFUNC_ENABLED = false;
                    weatherFxMask.gs.RenderOpenDoorOnly();
                    continue;
                }
                SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
                SpriteRenderer.instance.glBlendFunc(SCR_MASK_ADD, DST_MASK_ADD);
                SpriteRenderer.GL_BLENDFUNC_ENABLED = false;
                WeatherFxMask.renderMaskFloor(weatherFxMask.x, weatherFxMask.y, weatherFxMask.z);
                bl2 = (weatherFxMask.flags & 0x10) == 16;
                boolean bl8 = bl3 = (weatherFxMask.flags & 8) == 8;
                if (!bl2) {
                    bl5 = (weatherFxMask.flags & 1) == 1;
                    boolean bl9 = bl4 = (weatherFxMask.flags & 2) == 2;
                    if (bl5 || bl4) {
                        WeatherFxMask.renderMaskWall(weatherFxMask.gs, weatherFxMask.x, weatherFxMask.y, weatherFxMask.z, bl5, bl4, n);
                    } else if ((weatherFxMask.flags & 0x20) == 32) {
                        WeatherFxMask.renderMaskWall(weatherFxMask.gs, weatherFxMask.x, weatherFxMask.y, weatherFxMask.z, false, false, n);
                    }
                }
                if (bl2 && weatherFxMask.gs != null) {
                    weatherFxMask.gs.RenderMinusFloorFxMask(weatherFxMask.z + 1, false, false);
                }
                if (!bl3 || weatherFxMask.gs == null) continue;
                weatherFxMask.gs.renderCharacters(weatherFxMask.z + 1, false, false);
                SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
                SpriteRenderer.instance.glBlendFunc(SCR_MASK_ADD, DST_MASK_ADD);
                SpriteRenderer.GL_BLENDFUNC_ENABLED = false;
            }
            SpriteRenderer.instance.glBlendFunc(770, 771);
            SpriteRenderer.instance.glBuffer(5, n);
            SpriteRenderer.instance.glDoEndFrameFx(n);
        }
        if (DEBUG_MASK_AND_PARTICLES) {
            SpriteRenderer.instance.glClearColor(0, 0, 0, 255);
            SpriteRenderer.instance.glClear(16640);
            SpriteRenderer.instance.glClearColor(0, 0, 0, 255);
        } else if (DEBUG_MASK) {
            SpriteRenderer.instance.glClearColor(0, 255, 0, 255);
            SpriteRenderer.instance.glClear(16640);
            SpriteRenderer.instance.glClearColor(0, 0, 0, 255);
        }
        if (!RenderSettings.getInstance().getPlayerSettings(n).isExterior()) {
            WeatherFxMask.drawFxLayered(n, false, false, false);
        }
        if (IsoWeatherFX.instance.hasCloudsToRender()) {
            WeatherFxMask.drawFxLayered(n, true, false, false);
        }
        if (IsoWeatherFX.instance.hasFogToRender() && PerformanceSettings.FogQuality == 2) {
            WeatherFxMask.drawFxLayered(n, false, true, false);
        }
        if (Core.OptionRenderPrecipitation == 1 && IsoWeatherFX.instance.hasPrecipitationToRender()) {
            WeatherFxMask.drawFxLayered(n, false, false, true);
        }
        SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
        SpriteRenderer.instance.glIgnoreStyles(false);
    }

    private static void drawFxLayered(int n, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        int n2 = IsoCamera.getOffscreenLeft(n);
        int n3 = IsoCamera.getOffscreenTop(n);
        int n4 = IsoCamera.getOffscreenWidth(n);
        int n5 = IsoCamera.getOffscreenHeight(n);
        int n6 = IsoCamera.getScreenLeft(n);
        int n7 = IsoCamera.getScreenTop(n);
        int n8 = IsoCamera.getScreenWidth(n);
        int n9 = IsoCamera.getScreenHeight(n);
        SpriteRenderer.instance.glBuffer(6, n);
        SpriteRenderer.instance.glDoStartFrameFx(n4, n5, n);
        if (!(bl || bl2 || bl3)) {
            serializable = RenderSettings.getInstance().getMaskClearColorForPlayer(n);
            SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
            SpriteRenderer.instance.glBlendFuncSeparate(SCR_PARTICLES, DST_PARTICLES, 1, 771);
            SpriteRenderer.GL_BLENDFUNC_ENABLED = false;
            SpriteRenderer.instance.renderi(texWhite, 0, 0, n4, n5, ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, ((Color)serializable).a, null);
            SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
        } else if (IsoWorld.instance.getCell() != null && IsoWorld.instance.getCell().getWeatherFX() != null) {
            SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
            SpriteRenderer.instance.glBlendFuncSeparate(SCR_PARTICLES, DST_PARTICLES, 1, 771);
            SpriteRenderer.GL_BLENDFUNC_ENABLED = false;
            IsoWorld.instance.getCell().getWeatherFX().renderLayered(bl, bl2, bl3);
            SpriteRenderer.GL_BLENDFUNC_ENABLED = true;
        }
        if (MASKING_ENABLED) {
            SpriteRenderer.instance.glBlendFunc(SCR_MERGE, DST_MERGE);
            SpriteRenderer.instance.glBlendEquation(32779);
            ((Texture)fboMask.getTexture()).rendershader2(0.0f, 0.0f, n4, n5, n6, n7, n8, n9, 1.0f, 1.0f, 1.0f, 1.0f);
            SpriteRenderer.instance.glBlendEquation(32774);
        }
        SpriteRenderer.instance.glBlendFunc(770, 771);
        SpriteRenderer.instance.glBuffer(7, n);
        SpriteRenderer.instance.glDoEndFrameFx(n);
        if (!DEBUG_MASK && !DEBUG_MASK_AND_PARTICLES || DEBUG_MASK_AND_PARTICLES) {
            serializable = (Texture)fboParticles.getTexture();
            SpriteRenderer.instance.glBlendFunc(SCR_FINAL, DST_FINAL);
        } else {
            serializable = (Texture)fboMask.getTexture();
            SpriteRenderer.instance.glBlendFunc(770, 771);
        }
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        int n10 = n6;
        int n11 = n7;
        int n12 = n8;
        int n13 = n9;
        float f5 = (float)n10 / (float)((Texture)serializable).getWidthHW();
        float f6 = (float)n11 / (float)((Texture)serializable).getHeightHW();
        float f7 = (float)(n10 + n12) / (float)((Texture)serializable).getWidthHW();
        float f8 = (float)(n11 + n13) / (float)((Texture)serializable).getHeightHW();
        SpriteRenderer.instance.render((Texture)serializable, 0.0f, 0.0f, n4, n5, f, f2, f3, f4, f5, f8, f7, f8, f7, f6, f5, f6);
    }

    private static void initGlIds() {
        for (int i = 0; i < test.length; ++i) {
            if (test[i] == SCR_MASK_ADD) {
                ID_SCR_MASK_ADD = i;
                continue;
            }
            if (test[i] == DST_MASK_ADD) {
                ID_DST_MASK_ADD = i;
                continue;
            }
            if (test[i] == SCR_MASK_SUB) {
                ID_SCR_MASK_SUB = i;
                continue;
            }
            if (test[i] == DST_MASK_SUB) {
                ID_DST_MASK_SUB = i;
                continue;
            }
            if (test[i] == SCR_PARTICLES) {
                ID_SCR_PARTICLES = i;
                continue;
            }
            if (test[i] == DST_PARTICLES) {
                ID_DST_PARTICLES = i;
                continue;
            }
            if (test[i] == SCR_MERGE) {
                ID_SCR_MERGE = i;
                continue;
            }
            if (test[i] == DST_MERGE) {
                ID_DST_MERGE = i;
                continue;
            }
            if (test[i] == SCR_FINAL) {
                ID_SCR_FINAL = i;
                continue;
            }
            if (test[i] != DST_FINAL) continue;
            ID_DST_FINAL = i;
        }
    }

    private static void updateDebugKeys() {
        if (keypause > 0) {
            --keypause;
        }
        if (keypause == 0) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (TARGET_BLEND == 0) {
                var1 = ID_SCR_MASK_ADD;
                var2 = ID_DST_MASK_ADD;
            } else if (TARGET_BLEND == 1) {
                var1 = ID_SCR_MASK_SUB;
                var2 = ID_DST_MASK_SUB;
            } else if (TARGET_BLEND == 2) {
                var1 = ID_SCR_MERGE;
                var2 = ID_DST_MERGE;
            } else if (TARGET_BLEND == 3) {
                var1 = ID_SCR_FINAL;
                var2 = ID_DST_FINAL;
            } else if (TARGET_BLEND == 4) {
                var1 = ID_SCR_PARTICLES;
                var2 = ID_DST_PARTICLES;
            }
            if (GameKeyboard.isKeyDown(79)) {
                if (--var1 < 0) {
                    var1 = test.length - 1;
                }
                bl = true;
            } else if (GameKeyboard.isKeyDown(81)) {
                if (++var1 >= test.length) {
                    var1 = 0;
                }
                bl = true;
            } else if (GameKeyboard.isKeyDown(75)) {
                if (--var2 < 0) {
                    var2 = test.length - 1;
                }
                bl = true;
            } else if (GameKeyboard.isKeyDown(77)) {
                if (++var2 >= test.length) {
                    var2 = 0;
                }
                bl = true;
            } else if (GameKeyboard.isKeyDown(71)) {
                if (--TARGET_BLEND < 0) {
                    TARGET_BLEND = 4;
                }
                bl = true;
                bl2 = true;
            } else if (GameKeyboard.isKeyDown(73)) {
                if (++TARGET_BLEND >= 5) {
                    TARGET_BLEND = 0;
                }
                bl = true;
                bl2 = true;
            } else if (MASKING_ENABLED && GameKeyboard.isKeyDown(82)) {
                DEBUG_MASK = !DEBUG_MASK;
                bl = true;
                bl3 = true;
            } else if (MASKING_ENABLED && GameKeyboard.isKeyDown(80)) {
                DEBUG_MASK_AND_PARTICLES = !DEBUG_MASK_AND_PARTICLES;
                bl = true;
                bl4 = true;
            } else if (!GameKeyboard.isKeyDown(72) && GameKeyboard.isKeyDown(76)) {
                MASKING_ENABLED = !MASKING_ENABLED;
                bl = true;
                bl5 = true;
            }
            if (bl) {
                if (bl2) {
                    if (TARGET_BLEND == 0) {
                        DebugLog.log("TargetBlend = MASK_ADD");
                    } else if (TARGET_BLEND == 1) {
                        DebugLog.log("TargetBlend = MASK_SUB");
                    } else if (TARGET_BLEND == 2) {
                        DebugLog.log("TargetBlend = MERGE");
                    } else if (TARGET_BLEND == 3) {
                        DebugLog.log("TargetBlend = FINAL");
                    } else if (TARGET_BLEND == 4) {
                        DebugLog.log("TargetBlend = PARTICLES");
                    }
                } else if (bl3) {
                    DebugLog.log("DEBUG_MASK = " + DEBUG_MASK);
                } else if (bl4) {
                    DebugLog.log("DEBUG_MASK_AND_PARTICLES = " + DEBUG_MASK_AND_PARTICLES);
                } else if (bl5) {
                    DebugLog.log("MASKING_ENABLED = " + MASKING_ENABLED);
                } else {
                    if (TARGET_BLEND == 0) {
                        ID_SCR_MASK_ADD = var1;
                        ID_DST_MASK_ADD = var2;
                        SCR_MASK_ADD = test[ID_SCR_MASK_ADD];
                        DST_MASK_ADD = test[ID_DST_MASK_ADD];
                    } else if (TARGET_BLEND == 1) {
                        ID_SCR_MASK_SUB = var1;
                        ID_DST_MASK_SUB = var2;
                        SCR_MASK_SUB = test[ID_SCR_MASK_SUB];
                        DST_MASK_SUB = test[ID_DST_MASK_SUB];
                    } else if (TARGET_BLEND == 2) {
                        ID_SCR_MERGE = var1;
                        ID_DST_MERGE = var2;
                        SCR_MERGE = test[ID_SCR_MERGE];
                        DST_MERGE = test[ID_DST_MERGE];
                    } else if (TARGET_BLEND == 3) {
                        ID_SCR_FINAL = var1;
                        ID_DST_FINAL = var2;
                        SCR_FINAL = test[ID_SCR_FINAL];
                        DST_FINAL = test[ID_DST_FINAL];
                    } else if (TARGET_BLEND == 4) {
                        ID_SCR_PARTICLES = var1;
                        ID_DST_PARTICLES = var2;
                        SCR_PARTICLES = test[ID_SCR_PARTICLES];
                        DST_PARTICLES = test[ID_DST_PARTICLES];
                    }
                    DebugLog.log("Blendmode = " + testNames[var1] + " -> " + testNames[var2]);
                }
                keypause = 30;
            }
        }
    }

    static {
        offsetX = 32 * Core.TileScale;
        offsetY = 96 * Core.TileScale;
        defColorInfo = new ColorInfo();
        DIAMOND_ROWS = 1000;
        playerMasks = new PlayerFxMask[4];
        dmiter = new DiamondMatrixIterator(0);
        diamondMatrixPos = new Vector2i();
        tmpVec = new Vector3f();
        tmpTorch = new IsoGameCharacter.TorchInfo();
        tmpColInfo = new ColorInfo();
        test = new int[]{0, 1, 768, 769, 774, 775, 770, 771, 772, 773, 32769, 32770, 32771, 32772, 776, 35065, 35066, 34185, 35067};
        testNames = new String[]{"GL_ZERO", "GL_ONE", "GL_SRC_COLOR", "GL_ONE_MINUS_SRC_COLOR", "GL_DST_COLOR", "GL_ONE_MINUS_DST_COLOR", "GL_SRC_ALPHA", "GL_ONE_MINUS_SRC_ALPHA", "GL_DST_ALPHA", "GL_ONE_MINUS_DST_ALPHA", "GL_CONSTANT_COLOR", "GL_ONE_MINUS_CONSTANT_COLOR", "GL_CONSTANT_ALPHA", "GL_ONE_MINUS_CONSTANT_ALPHA", "GL_SRC_ALPHA_SATURATE", "GL_SRC1_COLOR (33)", "GL_ONE_MINUS_SRC1_COLOR (33)", "GL_SRC1_ALPHA (15)", "GL_ONE_MINUS_SRC1_ALPHA (33)"};
        var1 = 1;
        var2 = 1;
        var3 = 1.0f;
        SCR_MASK_ADD = 770;
        DST_MASK_ADD = 771;
        SCR_MASK_SUB = 0;
        DST_MASK_SUB = 0;
        SCR_PARTICLES = 1;
        DST_PARTICLES = 771;
        SCR_MERGE = 770;
        DST_MERGE = 771;
        SCR_FINAL = 770;
        DST_FINAL = 771;
        TARGET_BLEND = 0;
        DEBUG_MASK = false;
        MASKING_ENABLED = true;
        DEBUG_MASK_AND_PARTICLES = false;
        keypause = 0;
    }

    public static class PlayerFxMask {
        private WeatherFxMask[] masks;
        private int maskPointer = 0;
        private boolean maskEnabled = false;
        private IsoGridSquare plrSquare;
        private int DISABLED_MASKS = 0;
        private boolean requiresUpdate = false;
        private boolean hasMaskToDraw = true;
        private int playerIndex;
        private IsoPlayer player;
        private int playerZ;
        private IWorldRegion curIsoWorldRegion;
        private ArrayList<IWorldRegion> curConnectedRegions = new ArrayList();
        private final ArrayList<IWorldRegion> isoWorldRegionTemp = new ArrayList();
        private boolean DIAMOND_ITER_DONE = false;
        private boolean isFirstSquare = true;
        private IsoGridSquare firstSquare;

        private void init() {
            this.masks = new WeatherFxMask[30000];
            for (int i = 0; i < this.masks.length; ++i) {
                if (this.masks[i] != null) continue;
                this.masks[i] = new WeatherFxMask();
            }
            this.maskEnabled = true;
        }

        private void initMask() {
            if (GameServer.bServer) {
                return;
            }
            if (!this.maskEnabled) {
                this.init();
            }
            this.playerIndex = IsoCamera.frameState.playerIndex;
            this.player = IsoPlayer.players[this.playerIndex];
            this.playerZ = (int)this.player.getZ();
            this.DIAMOND_ITER_DONE = false;
            this.requiresUpdate = false;
            if (this.player != null) {
                if (this.isFirstSquare || this.plrSquare == null || this.plrSquare != this.player.getSquare()) {
                    this.plrSquare = this.player.getSquare();
                    this.maskPointer = 0;
                    this.DISABLED_MASKS = 0;
                    this.requiresUpdate = true;
                    if (this.firstSquare == null) {
                        this.firstSquare = this.plrSquare;
                    }
                    if (this.firstSquare != null && this.firstSquare != this.plrSquare) {
                        this.isFirstSquare = false;
                    }
                }
                this.curIsoWorldRegion = this.player.getMasterRegion();
                this.curConnectedRegions.clear();
                if (this.curIsoWorldRegion != null && this.player.getMasterRegion().isFogMask()) {
                    this.isoWorldRegionTemp.clear();
                    this.isoWorldRegionTemp.add(this.curIsoWorldRegion);
                    while (this.isoWorldRegionTemp.size() > 0) {
                        IWorldRegion iWorldRegion = this.isoWorldRegionTemp.remove(0);
                        this.curConnectedRegions.add(iWorldRegion);
                        if (iWorldRegion.getNeighbors().size() == 0) continue;
                        for (IsoWorldRegion isoWorldRegion : iWorldRegion.getNeighbors()) {
                            if (this.isoWorldRegionTemp.contains(isoWorldRegion) || this.curConnectedRegions.contains(isoWorldRegion) || !isoWorldRegion.isFogMask()) continue;
                            this.isoWorldRegionTemp.add(isoWorldRegion);
                        }
                    }
                } else {
                    this.curIsoWorldRegion = null;
                }
            }
            if (IsoWeatherFX.instance == null) {
                this.hasMaskToDraw = false;
                return;
            }
            this.hasMaskToDraw = true;
            if (this.hasMaskToDraw) {
                this.hasMaskToDraw = this.player.getSquare() != null && (this.player.getSquare().getBuilding() != null || !this.player.getSquare().Is(IsoFlagType.exterior)) || this.curIsoWorldRegion != null && this.curIsoWorldRegion.isFogMask();
            }
        }

        private void addMask(int n, int n2, int n3, IsoGridSquare isoGridSquare, int n4) {
            this.addMask(n, n2, n3, isoGridSquare, n4, true);
        }

        private void addMask(int n, int n2, int n3, IsoGridSquare isoGridSquare, int n4, boolean bl) {
            WeatherFxMask weatherFxMask;
            if (!this.hasMaskToDraw || !this.requiresUpdate) {
                return;
            }
            if (!this.maskEnabled) {
                this.init();
            }
            if ((weatherFxMask = this.getMask(n, n2, n3)) == null) {
                WeatherFxMask weatherFxMask2 = this.getFreeMask();
                weatherFxMask2.x = n;
                weatherFxMask2.y = n2;
                weatherFxMask2.z = n3;
                weatherFxMask2.flags = n4;
                weatherFxMask2.gs = isoGridSquare;
                weatherFxMask2.enabled = bl;
                if (!bl && this.DISABLED_MASKS < DIAMOND_ROWS) {
                    ++this.DISABLED_MASKS;
                }
            } else {
                if (weatherFxMask.flags != n4) {
                    weatherFxMask.flags |= n4;
                }
                if (!weatherFxMask.enabled && bl) {
                    WeatherFxMask weatherFxMask3 = this.getFreeMask();
                    weatherFxMask3.x = n;
                    weatherFxMask3.y = n2;
                    weatherFxMask3.z = n3;
                    weatherFxMask3.flags = weatherFxMask.flags;
                    weatherFxMask3.gs = isoGridSquare;
                    weatherFxMask3.enabled = bl;
                } else {
                    boolean bl2 = weatherFxMask.enabled = weatherFxMask.enabled ? weatherFxMask.enabled : bl;
                    if (bl && isoGridSquare != null && weatherFxMask.gs == null) {
                        weatherFxMask.gs = isoGridSquare;
                    }
                }
            }
        }

        private WeatherFxMask getFreeMask() {
            if (this.maskPointer >= this.masks.length) {
                DebugLog.log("Weather Mask buffer out of bounds. Increasing cache.");
                WeatherFxMask[] weatherFxMaskArray = this.masks;
                this.masks = new WeatherFxMask[this.masks.length + 10000];
                for (int i = 0; i < this.masks.length; ++i) {
                    this.masks[i] = weatherFxMaskArray[i] != null ? weatherFxMaskArray[i] : new WeatherFxMask();
                }
            }
            return this.masks[this.maskPointer++];
        }

        private boolean masksContains(int n, int n2, int n3) {
            return this.getMask(n, n2, n3) != null;
        }

        private WeatherFxMask getMask(int n, int n2, int n3) {
            if (this.maskPointer <= 0) {
                return null;
            }
            int n4 = this.maskPointer - 1 - (DIAMOND_ROWS + this.DISABLED_MASKS);
            if (n4 < 0) {
                n4 = 0;
            }
            for (int i = this.maskPointer - 1; i >= n4; --i) {
                if (!this.masks[i].isLoc(n, n2, n3)) continue;
                return this.masks[i];
            }
            return null;
        }
    }
}

