/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fx;

import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.iso.weather.fx.WeatherParticle;

public class RainParticle
extends WeatherParticle {
    private double angleRadians = 0.0;
    private float lastAngle = -1.0f;
    private float lastIntensity = -1.0f;
    protected float angleOffset = 0.0f;
    private float alphaMod = 0.0f;
    private float incarnateAlpha = 1.0f;
    private float life = 0.0f;
    private RenderPoints rp;
    private boolean angleUpdate = false;
    private float tmpAngle = 0.0f;

    public RainParticle(Texture texture, int n) {
        super(texture);
        if (n > 6) {
            this.bounds.setSize(Rand.Next(1, 2), n);
        } else {
            this.bounds.setSize(1, n);
        }
        this.oWidth = this.bounds.getWidth();
        this.oHeight = this.bounds.getHeight();
        this.recalcSizeOnZoom = true;
        this.zoomMultiW = 0.0f;
        this.zoomMultiH = 2.0f;
        this.setLife();
        this.rp = new RenderPoints();
        this.rp.setDimensions(this.oWidth, this.oHeight);
    }

    protected void setLife() {
        this.life = Rand.Next(20, 60);
    }

    @Override
    public void update(float f) {
        this.angleUpdate = false;
        if (this.updateZoomSize()) {
            this.rp.setDimensions(this.oWidth, this.oHeight);
            this.angleUpdate = true;
        }
        if (this.angleUpdate || this.lastAngle != IsoWeatherFX.instance.windAngle || this.lastIntensity != IsoWeatherFX.instance.windPrecipIntensity.value()) {
            this.tmpAngle = IsoWeatherFX.instance.windAngle + (this.angleOffset - this.angleOffset * 0.5f * IsoWeatherFX.instance.windPrecipIntensity.value());
            if (this.tmpAngle > 360.0f) {
                this.tmpAngle -= 360.0f;
            }
            if (this.tmpAngle < 0.0f) {
                this.tmpAngle += 360.0f;
            }
            this.angleRadians = Math.toRadians(this.tmpAngle);
            this.velocity.set((float)Math.cos(this.angleRadians) * this.speed, (float)Math.sin(this.angleRadians) * this.speed);
            this.lastAngle = IsoWeatherFX.instance.windAngle;
            this.lastIntensity = IsoWeatherFX.instance.windPrecipIntensity.value();
            this.angleUpdate = true;
        }
        this.position.x += this.velocity.x * (1.0f + IsoWeatherFX.instance.windSpeed * 0.1f) * f;
        this.position.y += this.velocity.y * (1.0f + IsoWeatherFX.instance.windSpeed * 0.1f) * f;
        this.life -= 1.0f;
        if (this.life < 0.0f) {
            this.setLife();
            this.incarnateAlpha = 0.0f;
            this.position.set(Rand.Next(0, this.parent.getWidth()), Rand.Next(0, this.parent.getHeight()));
        }
        if (this.incarnateAlpha < 1.0f) {
            this.incarnateAlpha += 0.035f;
            if (this.incarnateAlpha > 1.0f) {
                this.incarnateAlpha = 1.0f;
            }
        }
        super.update(f, false);
        this.bounds.setLocation((int)this.position.x, (int)this.position.y);
        if (this.angleUpdate) {
            this.tmpAngle += 90.0f;
            if (this.tmpAngle > 360.0f) {
                this.tmpAngle -= 360.0f;
            }
            if (this.tmpAngle < 0.0f) {
                this.tmpAngle += 360.0f;
            }
            this.angleRadians = Math.toRadians(this.tmpAngle);
            this.rp.rotate(this.angleRadians);
        }
        this.alphaMod = 1.0f - 0.2f * IsoWeatherFX.instance.windIntensity.value();
        this.renderAlpha = this.alpha * this.alphaMod * this.alphaFadeMod.value() * IsoWeatherFX.instance.indoorsAlphaMod.value() * this.incarnateAlpha;
        this.renderAlpha *= 0.55f;
        if (IsoWeatherFX.instance.playerIndoors) {
            this.renderAlpha *= 0.5f;
        }
    }

    @Override
    public void render(float f, float f2) {
        double d = f + (float)this.bounds.getX();
        double d2 = f2 + (float)this.bounds.getY();
        SpriteRenderer.instance.render(this.texture, d + this.rp.getX(0), d2 + this.rp.getY(0), d + this.rp.getX(1), d2 + this.rp.getY(1), d + this.rp.getX(2), d2 + this.rp.getY(2), d + this.rp.getX(3), d2 + this.rp.getY(3), this.color.r, this.color.g, this.color.b, this.renderAlpha, null);
    }

    private class RenderPoints {
        Point[] points = new Point[4];
        Point center = new Point();
        Point dim = new Point();

        public RenderPoints() {
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i] = new Point();
            }
        }

        public double getX(int n) {
            return this.points[n].x;
        }

        public double getY(int n) {
            return this.points[n].y;
        }

        public void setCenter(float f, float f2) {
            this.center.set(f, f2);
        }

        public void setDimensions(float f, float f2) {
            this.dim.set(f, f2);
            this.points[0].setOrig(-f / 2.0f, -f2 / 2.0f);
            this.points[1].setOrig(f / 2.0f, -f2 / 2.0f);
            this.points[2].setOrig(f / 2.0f, f2 / 2.0f);
            this.points[3].setOrig(-f / 2.0f, f2 / 2.0f);
        }

        public void rotate(double d) {
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            for (int i = 0; i < this.points.length; ++i) {
                this.points[i].x = this.points[i].origx * d2 - this.points[i].origy * d3;
                this.points[i].y = this.points[i].origx * d3 + this.points[i].origy * d2;
            }
        }
    }

    private class Point {
        private double origx;
        private double origy;
        private double x;
        private double y;

        private Point() {
        }

        public void setOrig(double d, double d2) {
            this.origx = d;
            this.origy = d2;
            this.x = d;
            this.y = d2;
        }

        public void set(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

