/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fx;

import java.util.ArrayList;
import org.lwjgl.util.vector.Matrix4f;
import zombie.GameTime;
import zombie.IndieGL;
import zombie.SandboxOptions;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.core.skinnedmodel.shader.ShaderManager;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugLog;
import zombie.iso.IsoCamera;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.fx.CloudParticle;
import zombie.iso.weather.fx.FogParticle;
import zombie.iso.weather.fx.ParticleRectangle;
import zombie.iso.weather.fx.RainParticle;
import zombie.iso.weather.fx.SnowParticle;
import zombie.iso.weather.fx.SteppedUpdateFloat;
import zombie.iso.weather.fx.WeatherFxMask;
import zombie.iso.weather.fx.WeatherParticle;
import zombie.network.GameServer;

public class IsoWeatherFX {
    private static boolean VERBOSE = false;
    protected static boolean DEBUG_BOUNDS = false;
    private static float DELTA;
    private ParticleRectangle cloudParticles;
    private ParticleRectangle fogParticles;
    private ParticleRectangle snowParticles;
    private ParticleRectangle rainParticles;
    private static int ID_CLOUD;
    private static int ID_FOG;
    private static int ID_SNOW;
    private static int ID_RAIN;
    public static float ZoomMod;
    protected boolean playerIndoors = false;
    protected SteppedUpdateFloat windPrecipIntensity = new SteppedUpdateFloat(0.0f, 0.025f, 0.0f, 1.0f);
    protected SteppedUpdateFloat windIntensity = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
    protected SteppedUpdateFloat windAngleIntensity = new SteppedUpdateFloat(0.0f, 0.005f, -1.0f, 1.0f);
    protected SteppedUpdateFloat precipitationIntensity = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
    protected SteppedUpdateFloat precipitationIntensitySnow = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
    protected SteppedUpdateFloat precipitationIntensityRain = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
    protected SteppedUpdateFloat cloudIntensity = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
    protected SteppedUpdateFloat fogIntensity = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
    protected SteppedUpdateFloat windAngleMod = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
    protected boolean precipitationIsSnow = true;
    private float fogOverlayAlpha = 0.0f;
    private float windSpeedMax = 6.0f;
    protected float windSpeed = 0.0f;
    protected float windSpeedFog = 0.0f;
    protected float windAngle = 90.0f;
    protected float windAngleClouds = 90.0f;
    private Texture texFogCircle;
    private Texture texFogWhite;
    private Color fogColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    protected SteppedUpdateFloat indoorsAlphaMod = new SteppedUpdateFloat(1.0f, 0.05f, 0.0f, 1.0f);
    private ArrayList<ParticleRectangle> particleRectangles = new ArrayList(0);
    protected static IsoWeatherFX instance;
    private float windUpdCounter = 0.0f;
    static Shader s_shader;
    static final Drawer[][] s_drawer;

    public IsoWeatherFX() {
        instance = this;
    }

    public void init() {
        if (GameServer.bServer) {
            return;
        }
        int n = 0;
        Texture[] textureArray = new Texture[6];
        for (int i = 0; i < textureArray.length; ++i) {
            textureArray[i] = Texture.getSharedTexture("media/textures/weather/clouds_" + i + ".png");
            if (textureArray[i] != null) continue;
            DebugLog.log("Missing texture: media/textures/weather/clouds_" + i + ".png");
        }
        this.cloudParticles = new ParticleRectangle(8192, 4096);
        WeatherParticle[] weatherParticleArray = new WeatherParticle[16];
        for (int i = 0; i < weatherParticleArray.length; ++i) {
            Texture texture = textureArray[Rand.Next(textureArray.length)];
            CloudParticle cloudParticle = new CloudParticle(texture, texture.getWidth() * 8, texture.getHeight() * 8);
            cloudParticle.position.set(Rand.Next(0, this.cloudParticles.getWidth()), Rand.Next(0, this.cloudParticles.getHeight()));
            cloudParticle.speed = Rand.Next(0.01f, 0.1f);
            cloudParticle.angleOffset = 180.0f - Rand.Next(0.0f, 360.0f);
            cloudParticle.alpha = Rand.Next(0.25f, 0.75f);
            weatherParticleArray[i] = cloudParticle;
        }
        this.cloudParticles.SetParticles(weatherParticleArray);
        this.cloudParticles.SetParticlesStrength(1.0f);
        this.particleRectangles.add(n, this.cloudParticles);
        ID_CLOUD = n++;
        if (this.texFogCircle == null) {
            this.texFogCircle = Texture.getSharedTexture("media/textures/weather/fogcircle_tex.png", 35);
        }
        if (this.texFogWhite == null) {
            this.texFogWhite = Texture.getSharedTexture("media/textures/weather/fogwhite_tex.png", 35);
        }
        Texture[] textureArray2 = new Texture[6];
        for (int i = 0; i < textureArray2.length; ++i) {
            textureArray2[i] = Texture.getSharedTexture("media/textures/weather/fog_" + i + ".png");
            if (textureArray2[i] != null) continue;
            DebugLog.log("Missing texture: media/textures/weather/fog_" + i + ".png");
        }
        this.fogParticles = new ParticleRectangle(2048, 1024);
        WeatherParticle[] weatherParticleArray2 = new WeatherParticle[16];
        for (int i = 0; i < weatherParticleArray2.length; ++i) {
            Texture texture = textureArray2[Rand.Next(textureArray2.length)];
            FogParticle fogParticle = new FogParticle(texture, texture.getWidth() * 2, texture.getHeight() * 2);
            fogParticle.position.set(Rand.Next(0, this.fogParticles.getWidth()), Rand.Next(0, this.fogParticles.getHeight()));
            fogParticle.speed = Rand.Next(0.01f, 0.1f);
            fogParticle.angleOffset = 180.0f - Rand.Next(0.0f, 360.0f);
            fogParticle.alpha = Rand.Next(0.05f, 0.25f);
            weatherParticleArray2[i] = fogParticle;
        }
        this.fogParticles.SetParticles(weatherParticleArray2);
        this.fogParticles.SetParticlesStrength(1.0f);
        this.particleRectangles.add(n, this.fogParticles);
        ID_FOG = n++;
        Texture[] textureArray3 = new Texture[3];
        for (int i = 0; i < textureArray3.length; ++i) {
            textureArray3[i] = Texture.getSharedTexture("media/textures/weather/snow_" + (i + 1) + ".png");
            if (textureArray3[i] != null) continue;
            DebugLog.log("Missing texture: media/textures/weather/snow_" + (i + 1) + ".png");
        }
        this.snowParticles = new ParticleRectangle(512, 512);
        WeatherParticle[] weatherParticleArray3 = new WeatherParticle[1024];
        for (int i = 0; i < weatherParticleArray3.length; ++i) {
            SnowParticle snowParticle = new SnowParticle(textureArray3[Rand.Next(textureArray3.length)]);
            snowParticle.position.set(Rand.Next(0, this.snowParticles.getWidth()), Rand.Next(0, this.snowParticles.getHeight()));
            snowParticle.speed = Rand.Next(1.0f, 2.0f);
            snowParticle.angleOffset = 15.0f - Rand.Next(0.0f, 30.0f);
            snowParticle.alpha = Rand.Next(0.25f, 0.6f);
            weatherParticleArray3[i] = snowParticle;
        }
        this.snowParticles.SetParticles(weatherParticleArray3);
        this.particleRectangles.add(n, this.snowParticles);
        ID_SNOW = n++;
        this.rainParticles = new ParticleRectangle(512, 512);
        WeatherParticle[] weatherParticleArray4 = new WeatherParticle[1024];
        for (int i = 0; i < weatherParticleArray4.length; ++i) {
            RainParticle rainParticle = new RainParticle(this.texFogWhite, Rand.Next(5, 12));
            rainParticle.position.set(Rand.Next(0, this.rainParticles.getWidth()), Rand.Next(0, this.rainParticles.getHeight()));
            rainParticle.speed = Rand.Next(7, 12);
            rainParticle.angleOffset = 3.0f - Rand.Next(0.0f, 6.0f);
            rainParticle.alpha = Rand.Next(0.5f, 0.8f);
            rainParticle.color = new Color(Rand.Next(0.75f, 0.8f), Rand.Next(0.85f, 0.9f), Rand.Next(0.95f, 1.0f), 1.0f);
            weatherParticleArray4[i] = rainParticle;
        }
        this.rainParticles.SetParticles(weatherParticleArray4);
        this.particleRectangles.add(n, this.rainParticles);
        ID_RAIN = n++;
    }

    public void update() {
        float f;
        if (GameServer.bServer) {
            return;
        }
        this.playerIndoors = IsoCamera.frameState.CamCharacterSquare != null && !IsoCamera.frameState.CamCharacterSquare.Is(IsoFlagType.exterior);
        GameTime gameTime = GameTime.getInstance();
        DELTA = gameTime.getMultiplier();
        if (!WeatherFxMask.playerHasMaskToDraw(IsoCamera.frameState.playerIndex)) {
            if (this.playerIndoors && this.indoorsAlphaMod.value() > 0.0f) {
                this.indoorsAlphaMod.setTarget(this.indoorsAlphaMod.value() - 0.05f * DELTA);
            } else if (!this.playerIndoors && this.indoorsAlphaMod.value() < 1.0f) {
                this.indoorsAlphaMod.setTarget(this.indoorsAlphaMod.value() + 0.05f * DELTA);
            }
        } else {
            this.indoorsAlphaMod.setTarget(1.0f);
        }
        this.indoorsAlphaMod.update(DELTA);
        this.cloudIntensity.update(DELTA);
        this.windIntensity.update(DELTA);
        this.windPrecipIntensity.update(DELTA);
        this.windAngleIntensity.update(DELTA);
        this.precipitationIntensity.update(DELTA);
        this.fogIntensity.update(DELTA);
        if (this.precipitationIsSnow) {
            this.precipitationIntensitySnow.setTarget(this.precipitationIntensity.getTarget());
        } else {
            this.precipitationIntensitySnow.setTarget(0.0f);
        }
        if (!this.precipitationIsSnow) {
            this.precipitationIntensityRain.setTarget(this.precipitationIntensity.getTarget());
        } else {
            this.precipitationIntensityRain.setTarget(0.0f);
        }
        if (this.precipitationIsSnow) {
            this.windAngleMod.setTarget(0.3f);
        } else {
            this.windAngleMod.setTarget(0.6f);
        }
        this.precipitationIntensitySnow.update(DELTA);
        this.precipitationIntensityRain.update(DELTA);
        this.windAngleMod.update(DELTA);
        float f2 = this.fogIntensity.value() * this.indoorsAlphaMod.value();
        this.fogOverlayAlpha = 0.8f * f2;
        this.windUpdCounter += 1.0f;
        if (f > 15.0f) {
            this.windUpdCounter = 0.0f;
            if (this.windAngleIntensity.value() > 0.0f) {
                this.windAngle = IsoWeatherFX.lerp(this.windPrecipIntensity.value(), 90.0f, 0.0f + 54.0f * this.windAngleMod.value());
                this.windAngleClouds = this.windAngleIntensity.value() < 0.5f ? IsoWeatherFX.lerp(this.windAngleIntensity.value() * 2.0f, 90.0f, 0.0f) : IsoWeatherFX.lerp((this.windAngleIntensity.value() - 0.5f) * 2.0f, 360.0f, 270.0f);
            } else if (this.windAngleIntensity.value() < 0.0f) {
                this.windAngle = IsoWeatherFX.lerp(Math.abs(this.windPrecipIntensity.value()), 90.0f, 180.0f - 54.0f * this.windAngleMod.value());
                this.windAngleClouds = IsoWeatherFX.lerp(Math.abs(this.windAngleIntensity.value()), 90.0f, 270.0f);
            } else {
                this.windAngle = 90.0f;
            }
            this.windSpeed = this.windSpeedMax * this.windPrecipIntensity.value();
            this.windSpeedFog = this.windSpeedMax * this.windIntensity.value() * (4.0f + 16.0f * Math.abs(this.windAngleIntensity.value()));
            if (this.windSpeed < 1.0f) {
                this.windSpeed = 1.0f;
            }
            if (this.windSpeedFog < 1.0f) {
                this.windSpeedFog = 1.0f;
            }
        }
        float f3 = Core.getInstance().getZoom(IsoPlayer.getInstance().getPlayerNum());
        float f4 = 1.0f - (f3 - 0.5f) * 0.5f * 0.75f;
        ZoomMod = 0.0f;
        if (Core.getInstance().isZoomEnabled() && f3 > 1.0f) {
            ZoomMod = ClimateManager.clamp(0.0f, 1.0f, (f3 - 1.0f) * 0.6666667f);
        }
        if (this.cloudIntensity.value() <= 0.0f) {
            this.cloudParticles.SetParticlesStrength(0.0f);
        } else {
            this.cloudParticles.SetParticlesStrength(1.0f);
        }
        if (this.fogIntensity.value() <= 0.0f) {
            this.fogParticles.SetParticlesStrength(0.0f);
        } else {
            this.fogParticles.SetParticlesStrength(1.0f);
        }
        this.snowParticles.SetParticlesStrength(this.precipitationIntensitySnow.value() * f4);
        this.rainParticles.SetParticlesStrength(this.precipitationIntensityRain.value() * f4);
        for (int i = 0; i < this.particleRectangles.size(); ++i) {
            if (!this.particleRectangles.get(i).requiresUpdate()) continue;
            this.particleRectangles.get(i).update(DELTA);
        }
    }

    public void setDebugBounds(boolean bl) {
        DEBUG_BOUNDS = bl;
    }

    public boolean isDebugBounds() {
        return DEBUG_BOUNDS;
    }

    public void setWindAngleIntensity(float f) {
        this.windAngleIntensity.setTarget(f);
        if (VERBOSE) {
            DebugLog.log("Wind angle intensity = " + this.windAngleIntensity.getTarget());
        }
    }

    public float getWindAngleIntensity() {
        return this.windAngleIntensity.value();
    }

    public float getRenderWindAngleRain() {
        return this.windAngle;
    }

    public void setWindPrecipIntensity(float f) {
        this.windPrecipIntensity.setTarget(f);
        if (VERBOSE) {
            DebugLog.log("Wind Precip intensity = " + this.windPrecipIntensity.getTarget());
        }
    }

    public float getWindPrecipIntensity() {
        return this.windPrecipIntensity.value();
    }

    public void setWindIntensity(float f) {
        this.windIntensity.setTarget(f);
        if (VERBOSE) {
            DebugLog.log("Wind intensity = " + this.windIntensity.getTarget());
        }
    }

    public float getWindIntensity() {
        return this.windIntensity.value();
    }

    public void setFogIntensity(float f) {
        if (SandboxOptions.instance.MaxFogIntensity.getValue() == 2) {
            f = Math.min(f, 0.75f);
        } else if (SandboxOptions.instance.MaxFogIntensity.getValue() == 3) {
            f = Math.min(f, 0.5f);
        }
        this.fogIntensity.setTarget(f);
        if (VERBOSE) {
            DebugLog.log("Fog intensity = " + this.fogIntensity.getTarget());
        }
    }

    public float getFogIntensity() {
        return this.fogIntensity.value();
    }

    public void setCloudIntensity(float f) {
        this.cloudIntensity.setTarget(f);
        if (VERBOSE) {
            DebugLog.log("Cloud intensity = " + this.cloudIntensity.getTarget());
        }
    }

    public float getCloudIntensity() {
        return this.cloudIntensity.value();
    }

    public void setPrecipitationIntensity(float f) {
        if (SandboxOptions.instance.MaxRainFxIntensity.getValue() == 2) {
            f *= 0.75f;
        } else if (SandboxOptions.instance.MaxRainFxIntensity.getValue() == 3) {
            f *= 0.5f;
        }
        if (f > 0.0f) {
            f = 0.05f + 0.95f * f;
        }
        this.precipitationIntensity.setTarget(f);
        if (VERBOSE) {
            DebugLog.log("Precipitation intensity = " + this.precipitationIntensity.getTarget());
        }
    }

    public float getPrecipitationIntensity() {
        return this.precipitationIntensity.value();
    }

    public void setPrecipitationIsSnow(boolean bl) {
        this.precipitationIsSnow = bl;
    }

    public boolean getPrecipitationIsSnow() {
        return this.precipitationIsSnow;
    }

    public boolean hasCloudsToRender() {
        return this.cloudIntensity.value() > 0.0f || this.particleRectangles.get(ID_CLOUD).requiresUpdate();
    }

    public boolean hasPrecipitationToRender() {
        return this.precipitationIntensity.value() > 0.0f || this.particleRectangles.get(ID_SNOW).requiresUpdate() || this.particleRectangles.get(ID_RAIN).requiresUpdate();
    }

    public boolean hasFogToRender() {
        return this.fogIntensity.value() > 0.0f || this.particleRectangles.get(ID_FOG).requiresUpdate();
    }

    public void render() {
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < this.particleRectangles.size(); ++i) {
            if (i == ID_FOG) {
                if (PerformanceSettings.FogQuality != 2) continue;
                this.renderFogCircle();
            }
            if ((i == ID_RAIN || i == ID_SNOW) && Core.OptionRenderPrecipitation > 2 || !this.particleRectangles.get(i).requiresUpdate()) continue;
            this.particleRectangles.get(i).render();
        }
    }

    public void renderLayered(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.renderClouds();
        } else if (bl2) {
            this.renderFog();
        } else if (bl3) {
            this.renderPrecipitation();
        }
    }

    public void renderClouds() {
        if (GameServer.bServer) {
            return;
        }
        if (this.particleRectangles.get(ID_CLOUD).requiresUpdate()) {
            this.particleRectangles.get(ID_CLOUD).render();
        }
    }

    public void renderFog() {
        if (GameServer.bServer) {
            return;
        }
        this.renderFogCircle();
        if (this.particleRectangles.get(ID_FOG).requiresUpdate()) {
            this.particleRectangles.get(ID_FOG).render();
        }
    }

    public void renderPrecipitation() {
        if (GameServer.bServer) {
            return;
        }
        if (this.particleRectangles.get(ID_SNOW).requiresUpdate()) {
            this.particleRectangles.get(ID_SNOW).render();
        }
        if (this.particleRectangles.get(ID_RAIN).requiresUpdate()) {
            this.particleRectangles.get(ID_RAIN).render();
        }
    }

    private void renderFogCircle() {
        if (this.fogOverlayAlpha <= 0.0f) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        float f = Core.getInstance().getCurrentPlayerZoom();
        int n2 = IsoCamera.getScreenWidth(n);
        int n3 = IsoCamera.getScreenHeight(n);
        int n4 = 2048 - (int)(512.0f * this.fogIntensity.value());
        int n5 = 1024 - (int)(256.0f * this.fogIntensity.value());
        n4 = (int)((float)n4 / f);
        n5 = (int)((float)n5 / f);
        int n6 = n2 / 2 - n4 / 2;
        int n7 = n3 / 2 - n5 / 2;
        n6 = (int)((float)n6 - IsoCamera.getRightClickOffX() / f);
        n7 = (int)((float)n7 - IsoCamera.getRightClickOffY() / f);
        int n8 = n6 + n4;
        int n9 = n7 + n5;
        SpriteRenderer.instance.glBind(this.texFogWhite.getID());
        IndieGL.glTexParameteri(3553, 10241, 9728);
        IndieGL.glTexParameteri(3553, 10240, 9728);
        if (s_shader == null) {
            RenderThread.invokeOnRenderContext(() -> {
                s_shader = ShaderManager.instance.getOrCreateShader("fogCircle", false);
            });
        }
        if (s_shader.getShaderProgram().isCompiled()) {
            IndieGL.StartShader(s_shader.getID(), n);
            int n10 = SpriteRenderer.instance.getMainStateIndex();
            if (s_drawer[n][n10] == null) {
                IsoWeatherFX.s_drawer[n][n10] = new Drawer();
            }
            s_drawer[n][n10].init(n2, n3);
        }
        SpriteRenderer.instance.renderi(this.texFogCircle, n6, n7, n4, n5, this.fogColor.r, this.fogColor.g, this.fogColor.b, this.fogOverlayAlpha, null);
        SpriteRenderer.instance.renderi(this.texFogWhite, 0, 0, n6, n3, this.fogColor.r, this.fogColor.g, this.fogColor.b, this.fogOverlayAlpha, null);
        SpriteRenderer.instance.renderi(this.texFogWhite, n6, 0, n4, n7, this.fogColor.r, this.fogColor.g, this.fogColor.b, this.fogOverlayAlpha, null);
        SpriteRenderer.instance.renderi(this.texFogWhite, n8, 0, n2 - n8, n3, this.fogColor.r, this.fogColor.g, this.fogColor.b, this.fogOverlayAlpha, null);
        SpriteRenderer.instance.renderi(this.texFogWhite, n6, n9, n4, n3 - n9, this.fogColor.r, this.fogColor.g, this.fogColor.b, this.fogOverlayAlpha, null);
        if (s_shader.getShaderProgram().isCompiled()) {
            IndieGL.EndShader();
        }
        if (Core.getInstance().getOffscreenBuffer() != null) {
            if (Core.getInstance().isZoomEnabled() && Core.getInstance().getZoom(n) > 0.5f) {
                IndieGL.glTexParameteri(3553, 10241, 9729);
            } else {
                IndieGL.glTexParameteri(3553, 10241, 9728);
            }
            if (Core.getInstance().getZoom(n) == 0.5f) {
                IndieGL.glTexParameteri(3553, 10240, 9728);
            } else {
                IndieGL.glTexParameteri(3553, 10240, 9729);
            }
        }
    }

    public static float clamp(float f, float f2, float f3) {
        f3 = Math.min(f2, f3);
        f3 = Math.max(f, f3);
        return f3;
    }

    public static float lerp(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    public static float clerp(float f, float f2, float f3) {
        float f4 = (float)(1.0 - Math.cos((double)f * Math.PI)) / 2.0f;
        return f2 * (1.0f - f4) + f3 * f4;
    }

    static {
        ID_CLOUD = 0;
        ID_FOG = 1;
        ID_SNOW = 2;
        ID_RAIN = 3;
        ZoomMod = 1.0f;
        s_drawer = new Drawer[4][3];
    }

    private static final class Drawer
    extends TextureDraw.GenericDrawer {
        static final org.joml.Matrix4f s_matrix4f = new org.joml.Matrix4f();
        final Matrix4f m_mvp = new Matrix4f();
        int m_width;
        int m_height;
        boolean m_bSet = false;

        private Drawer() {
        }

        void init(int n, int n2) {
            if (n == this.m_width && n2 == this.m_height && this.m_bSet) {
                return;
            }
            this.m_width = n;
            this.m_height = n2;
            this.m_bSet = false;
            s_matrix4f.setOrtho(0.0f, this.m_width, this.m_height, 0.0f, -1.0f, 1.0f);
            PZMath.convertMatrix(s_matrix4f, this.m_mvp);
            this.m_mvp.transpose();
            SpriteRenderer.instance.drawGeneric(this);
        }

        @Override
        public void render() {
            s_shader.getShaderProgram().setValue("u_mvp", this.m_mvp);
            this.m_bSet = true;
        }
    }
}

