/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import java.util.ArrayList;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderSettings;
import zombie.debug.LineDrawer;
import zombie.iso.IsoUtils;
import zombie.iso.Vector2;
import zombie.iso.weather.ClimateColorInfo;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.fx.SteppedUpdateFloat;

public class WorldFlares {
    public static final boolean ENABLED = true;
    public static boolean DEBUG_DRAW = false;
    public static int NEXT_ID = 0;
    private static ArrayList<Flare> flares = new ArrayList();

    public static void Clear() {
        flares.clear();
    }

    public static int getFlareCount() {
        return flares.size();
    }

    public static Flare getFlare(int n) {
        return flares.get(n);
    }

    public static Flare getFlareID(int n) {
        for (int i = 0; i < flares.size(); ++i) {
            if (WorldFlares.flares.get((int)i).id != n) continue;
            return flares.get(i);
        }
        return null;
    }

    public static void launchFlare(float f, int n, int n2, int n3, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (flares.size() > 100) {
            flares.remove(0);
        }
        Flare flare = new Flare();
        flare.id = NEXT_ID++;
        flare.x = n;
        flare.y = n2;
        flare.range = n3;
        flare.windSpeed = f2;
        flare.color.setExterior(f3, f4, f5, 1.0f);
        flare.color.setInterior(f6, f7, f8, 1.0f);
        flare.hasLaunched = true;
        flare.maxLifeTime = f;
        flares.add(flare);
    }

    public static void update() {
        for (int i = flares.size() - 1; i >= 0; --i) {
            flares.get(i).update();
            if (WorldFlares.flares.get((int)i).hasLaunched) continue;
            flares.remove(i);
        }
    }

    public static void applyFlaresForPlayer(RenderSettings.PlayerRenderSettings playerRenderSettings, int n, IsoPlayer isoPlayer) {
        for (int i = flares.size() - 1; i >= 0; --i) {
            if (!WorldFlares.flares.get((int)i).hasLaunched) continue;
            flares.get(i).applyFlare(playerRenderSettings, n, isoPlayer);
        }
    }

    public static void setDebugDraw(boolean bl) {
        DEBUG_DRAW = bl;
    }

    public static boolean getDebugDraw() {
        return DEBUG_DRAW;
    }

    public static void debugRender() {
        if (!DEBUG_DRAW) {
            return;
        }
        float f = 0.0f;
        for (int i = flares.size() - 1; i >= 0; --i) {
            Flare flare = flares.get(i);
            float f2 = 0.5f;
            for (double d = 0.0; d < Math.PI * 2; d += 0.15707963267948966) {
                WorldFlares.DrawIsoLine(flare.x + (float)flare.range * (float)Math.cos(d), flare.y + (float)flare.range * (float)Math.sin(d), flare.x + (float)flare.range * (float)Math.cos(d + 0.15707963267948966), flare.y + (float)flare.range * (float)Math.sin(d + 0.15707963267948966), f, 1.0f, 1.0f, 1.0f, 0.25f, 1);
                WorldFlares.DrawIsoLine(flare.x + f2 * (float)Math.cos(d), flare.y + f2 * (float)Math.sin(d), flare.x + f2 * (float)Math.cos(d + 0.15707963267948966), flare.y + f2 * (float)Math.sin(d + 0.15707963267948966), f, 1.0f, 1.0f, 1.0f, 0.25f, 1);
            }
        }
    }

    private static void DrawIsoLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n) {
        float f10 = IsoUtils.XToScreenExact(f, f2, f5, 0);
        float f11 = IsoUtils.YToScreenExact(f, f2, f5, 0);
        float f12 = IsoUtils.XToScreenExact(f3, f4, f5, 0);
        float f13 = IsoUtils.YToScreenExact(f3, f4, f5, 0);
        LineDrawer.drawLine(f10, f11, f12, f13, f6, f7, f8, f9, n);
    }

    public static class Flare {
        private int id;
        private float x;
        private float y;
        private int range;
        private float windSpeed = 0.0f;
        private ClimateColorInfo color = new ClimateColorInfo(1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        private boolean hasLaunched = false;
        private SteppedUpdateFloat intensity = new SteppedUpdateFloat(0.0f, 0.01f, 0.0f, 1.0f);
        private float maxLifeTime;
        private float lifeTime;
        private int nextRandomTargetIntens = 10;
        private float perc = 0.0f;
        private PlayerFlareLightInfo[] infos = new PlayerFlareLightInfo[4];

        public Flare() {
            for (int i = 0; i < this.infos.length; ++i) {
                this.infos[i] = new PlayerFlareLightInfo();
            }
        }

        public int getId() {
            return this.id;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public int getRange() {
            return this.range;
        }

        public float getWindSpeed() {
            return this.windSpeed;
        }

        public ClimateColorInfo getColor() {
            return this.color;
        }

        public boolean isHasLaunched() {
            return this.hasLaunched;
        }

        public float getIntensity() {
            return this.intensity.value();
        }

        public float getMaxLifeTime() {
            return this.maxLifeTime;
        }

        public float getLifeTime() {
            return this.lifeTime;
        }

        public float getPercent() {
            return this.perc;
        }

        public float getIntensityPlayer(int n) {
            return this.infos[n].intensity;
        }

        public float getLerpPlayer(int n) {
            return this.infos[n].lerp;
        }

        public float getDistModPlayer(int n) {
            return this.infos[n].distMod;
        }

        public ClimateColorInfo getColorPlayer(int n) {
            return this.infos[n].flareCol;
        }

        public ClimateColorInfo getOutColorPlayer(int n) {
            return this.infos[n].outColor;
        }

        private int GetDistance(int n, int n2, int n3, int n4) {
            return (int)Math.sqrt(Math.pow(n - n3, 2.0) + Math.pow(n2 - n4, 2.0));
        }

        private void update() {
            if (this.hasLaunched) {
                if (this.lifeTime > this.maxLifeTime) {
                    this.hasLaunched = false;
                    return;
                }
                this.perc = this.lifeTime / this.maxLifeTime;
                this.nextRandomTargetIntens = (int)((float)this.nextRandomTargetIntens - GameTime.instance.getMultiplier());
                if (this.nextRandomTargetIntens <= 0) {
                    this.intensity.setTarget(Rand.Next(0.8f, 1.0f));
                    this.nextRandomTargetIntens = Rand.Next(5, 30);
                }
                this.intensity.update(GameTime.instance.getMultiplier());
                if (this.windSpeed > 0.0f) {
                    Vector2 vector22 = new Vector2(this.windSpeed / 60.0f * ClimateManager.getInstance().getWindIntensity() * (float)Math.sin(ClimateManager.getInstance().getWindAngleRadians()), this.windSpeed / 60.0f * ClimateManager.getInstance().getWindIntensity() * (float)Math.cos(ClimateManager.getInstance().getWindAngleRadians()));
                    this.x += vector22.x * GameTime.instance.getMultiplier();
                    this.y += vector22.y * GameTime.instance.getMultiplier();
                }
                for (int i = 0; i < 4; ++i) {
                    PlayerFlareLightInfo playerFlareLightInfo = this.infos[i];
                    IsoPlayer isoPlayer = IsoPlayer.players[i];
                    if (isoPlayer == null) {
                        playerFlareLightInfo.intensity = 0.0f;
                        continue;
                    }
                    int n = this.GetDistance((int)this.x, (int)this.y, (int)isoPlayer.getX(), (int)isoPlayer.getY());
                    if (n > this.range) {
                        playerFlareLightInfo.intensity = 0.0f;
                        playerFlareLightInfo.lerp = 1.0f;
                    } else {
                        playerFlareLightInfo.distMod = 1.0f - (float)n / (float)this.range;
                        playerFlareLightInfo.lerp = this.perc < 0.75f ? 0.0f : (this.perc - 0.75f) / 0.25f;
                        playerFlareLightInfo.intensity = this.intensity.value();
                    }
                    float f = (1.0f - playerFlareLightInfo.lerp) * playerFlareLightInfo.distMod * playerFlareLightInfo.intensity;
                    ClimateManager.getInstance().dayLightStrength.finalValue += (1.0f - ClimateManager.getInstance().dayLightStrength.finalValue) * f;
                    if (isoPlayer == null) continue;
                    isoPlayer.dirtyRecalcGridStackTime = 1.0f;
                }
                this.lifeTime += GameTime.instance.getMultiplier();
            }
        }

        private void applyFlare(RenderSettings.PlayerRenderSettings playerRenderSettings, int n, IsoPlayer isoPlayer) {
            PlayerFlareLightInfo playerFlareLightInfo = this.infos[n];
            if (playerFlareLightInfo.distMod > 0.0f) {
                float f = 1.0f - playerRenderSettings.CM_DayLightStrength;
                f = playerRenderSettings.CM_NightStrength > f ? playerRenderSettings.CM_NightStrength : f;
                f = PZMath.clamp(f * 2.0f, 0.0f, 1.0f);
                float f2 = 1.0f - playerFlareLightInfo.lerp;
                ClimateColorInfo climateColorInfo = playerRenderSettings.CM_GlobalLight;
                playerFlareLightInfo.outColor.setTo(climateColorInfo);
                playerFlareLightInfo.outColor.getExterior().g *= 1.0f - f * (f2 *= playerFlareLightInfo.distMod) * playerFlareLightInfo.intensity * 0.5f;
                playerFlareLightInfo.outColor.getInterior().g *= 1.0f - f * f2 * playerFlareLightInfo.intensity * 0.5f;
                playerFlareLightInfo.outColor.getExterior().b *= 1.0f - f * f2 * playerFlareLightInfo.intensity * 0.8f;
                playerFlareLightInfo.outColor.getInterior().b *= 1.0f - f * f2 * playerFlareLightInfo.intensity * 0.8f;
                playerFlareLightInfo.flareCol.setTo(this.color);
                playerFlareLightInfo.flareCol.scale(f);
                playerFlareLightInfo.flareCol.getExterior().a = 1.0f;
                playerFlareLightInfo.flareCol.getInterior().a = 1.0f;
                playerFlareLightInfo.outColor.getExterior().r = playerFlareLightInfo.outColor.getExterior().r > playerFlareLightInfo.flareCol.getExterior().r ? playerFlareLightInfo.outColor.getExterior().r : playerFlareLightInfo.flareCol.getExterior().r;
                playerFlareLightInfo.outColor.getExterior().g = playerFlareLightInfo.outColor.getExterior().g > playerFlareLightInfo.flareCol.getExterior().g ? playerFlareLightInfo.outColor.getExterior().g : playerFlareLightInfo.flareCol.getExterior().g;
                playerFlareLightInfo.outColor.getExterior().b = playerFlareLightInfo.outColor.getExterior().b > playerFlareLightInfo.flareCol.getExterior().b ? playerFlareLightInfo.outColor.getExterior().b : playerFlareLightInfo.flareCol.getExterior().b;
                playerFlareLightInfo.outColor.getExterior().a = playerFlareLightInfo.outColor.getExterior().a > playerFlareLightInfo.flareCol.getExterior().a ? playerFlareLightInfo.outColor.getExterior().a : playerFlareLightInfo.flareCol.getExterior().a;
                playerFlareLightInfo.outColor.getInterior().r = playerFlareLightInfo.outColor.getInterior().r > playerFlareLightInfo.flareCol.getInterior().r ? playerFlareLightInfo.outColor.getInterior().r : playerFlareLightInfo.flareCol.getInterior().r;
                playerFlareLightInfo.outColor.getInterior().g = playerFlareLightInfo.outColor.getInterior().g > playerFlareLightInfo.flareCol.getInterior().g ? playerFlareLightInfo.outColor.getInterior().g : playerFlareLightInfo.flareCol.getInterior().g;
                playerFlareLightInfo.outColor.getInterior().b = playerFlareLightInfo.outColor.getInterior().b > playerFlareLightInfo.flareCol.getInterior().b ? playerFlareLightInfo.outColor.getInterior().b : playerFlareLightInfo.flareCol.getInterior().b;
                playerFlareLightInfo.outColor.getInterior().a = playerFlareLightInfo.outColor.getInterior().a > playerFlareLightInfo.flareCol.getInterior().a ? playerFlareLightInfo.outColor.getInterior().a : playerFlareLightInfo.flareCol.getInterior().a;
                float f3 = 1.0f - f2 * playerFlareLightInfo.intensity;
                playerFlareLightInfo.outColor.interp(climateColorInfo, f3, climateColorInfo);
                float f4 = ClimateManager.lerp(f3, 0.35f, playerRenderSettings.CM_Ambient);
                playerRenderSettings.CM_Ambient = playerRenderSettings.CM_Ambient > f4 ? playerRenderSettings.CM_Ambient : f4;
                float f5 = ClimateManager.lerp(f3, 0.6f * playerFlareLightInfo.intensity, playerRenderSettings.CM_DayLightStrength);
                float f6 = playerRenderSettings.CM_DayLightStrength = playerRenderSettings.CM_DayLightStrength > f5 ? playerRenderSettings.CM_DayLightStrength : f5;
                if (Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null) {
                    float f7 = ClimateManager.lerp(f3, 1.0f * f, playerRenderSettings.CM_Desaturation);
                    playerRenderSettings.CM_Desaturation = playerRenderSettings.CM_Desaturation > f7 ? playerRenderSettings.CM_Desaturation : f7;
                }
            }
        }
    }

    private static class PlayerFlareLightInfo {
        private float intensity;
        private float lerp;
        private float distMod;
        private ClimateColorInfo flareCol = new ClimateColorInfo(1.0f, 1.0f, 1.0f, 1.0f);
        private ClimateColorInfo outColor = new ClimateColorInfo(1.0f, 1.0f, 1.0f, 1.0f);

        private PlayerFlareLightInfo() {
        }
    }
}

