/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import java.text.SimpleDateFormat;
import java.time.temporal.ChronoUnit;
import java.util.GregorianCalendar;
import java.util.Random;
import zombie.GameTime;
import zombie.SandboxOptions;
import zombie.debug.DebugLog;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.SimplexNoise;

public class ClimateValues {
    private double simplexOffsetA = 0.0;
    private double simplexOffsetB = 0.0;
    private double simplexOffsetC = 0.0;
    private double simplexOffsetD = 0.0;
    private ClimateManager clim;
    private GameTime gt;
    private float time = 0.0f;
    private float dawn = 0.0f;
    private float dusk = 0.0f;
    private float noon = 0.0f;
    private float dayMeanTemperature = 0.0f;
    private double airMassNoiseFrequencyMod = 0.0;
    private float noiseAirmass = 0.0f;
    private float airMassTemperature = 0.0f;
    private float baseTemperature = 0.0f;
    private float dayLightLagged = 0.0f;
    private float nightLagged = 0.0f;
    private float temperature = 0.0f;
    private boolean temperatureIsSnow = false;
    private float humidity = 0.0f;
    private float windIntensity = 0.0f;
    private float windAngleIntensity = 0.0f;
    private float windAngleDegrees = 0.0f;
    private float nightStrength = 0.0f;
    private float dayLightStrength = 0.0f;
    private float ambient = 0.0f;
    private float desaturation = 0.0f;
    private float dayLightStrengthBase = 0.0f;
    private float lerpNight = 0.0f;
    private float cloudyT = 0.0f;
    private float cloudIntensity = 0.0f;
    private float airFrontAirmass = 0.0f;
    private boolean dayDoFog = false;
    private float dayFogStrength = 0.0f;
    private float dayFogDuration = 0.0f;
    private ClimateManager.DayInfo testCurrentDay;
    private ClimateManager.DayInfo testNextDay;
    private double cacheWorldAgeHours = 0.0;
    private int cacheYear;
    private int cacheMonth;
    private int cacheDay;
    private Random seededRandom;

    public ClimateValues(ClimateManager climateManager) {
        this.simplexOffsetA = climateManager.getSimplexOffsetA();
        this.simplexOffsetB = climateManager.getSimplexOffsetB();
        this.simplexOffsetC = climateManager.getSimplexOffsetC();
        this.simplexOffsetD = climateManager.getSimplexOffsetD();
        this.clim = climateManager;
        this.gt = GameTime.getInstance();
        this.seededRandom = new Random(1984L);
    }

    public ClimateValues getCopy() {
        ClimateValues climateValues = new ClimateValues(this.clim);
        this.CopyValues(climateValues);
        return climateValues;
    }

    public void CopyValues(ClimateValues climateValues) {
        if (climateValues != this) {
            climateValues.time = this.time;
            climateValues.dawn = this.dawn;
            climateValues.dusk = this.dusk;
            climateValues.noon = this.noon;
            climateValues.dayMeanTemperature = this.dayMeanTemperature;
            climateValues.airMassNoiseFrequencyMod = this.airMassNoiseFrequencyMod;
            climateValues.noiseAirmass = this.noiseAirmass;
            climateValues.airMassTemperature = this.airMassTemperature;
            climateValues.baseTemperature = this.baseTemperature;
            climateValues.dayLightLagged = this.dayLightLagged;
            climateValues.nightLagged = this.nightLagged;
            climateValues.temperature = this.temperature;
            climateValues.temperatureIsSnow = this.temperatureIsSnow;
            climateValues.humidity = this.humidity;
            climateValues.windIntensity = this.windIntensity;
            climateValues.windAngleIntensity = this.windAngleIntensity;
            climateValues.windAngleDegrees = this.windAngleDegrees;
            climateValues.nightStrength = this.nightStrength;
            climateValues.dayLightStrength = this.dayLightStrength;
            climateValues.ambient = this.ambient;
            climateValues.desaturation = this.desaturation;
            climateValues.dayLightStrengthBase = this.dayLightStrengthBase;
            climateValues.lerpNight = this.lerpNight;
            climateValues.cloudyT = this.cloudyT;
            climateValues.cloudIntensity = this.cloudIntensity;
            climateValues.airFrontAirmass = this.airFrontAirmass;
            climateValues.dayDoFog = this.dayDoFog;
            climateValues.dayFogStrength = this.dayFogStrength;
            climateValues.dayFogDuration = this.dayFogDuration;
            climateValues.cacheWorldAgeHours = this.cacheWorldAgeHours;
            climateValues.cacheYear = this.cacheYear;
            climateValues.cacheMonth = this.cacheMonth;
            climateValues.cacheDay = this.cacheDay;
        }
    }

    public void print() {
        DebugLog.log("==================================================");
        DebugLog.log("Current time of day = " + this.gt.getTimeOfDay());
        DebugLog.log("Current Worldagehours = " + this.gt.getWorldAgeHours());
        DebugLog.log("--------------------------------------------------");
        if (this.testCurrentDay == null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(this.cacheYear, this.cacheMonth, this.cacheDay);
            DebugLog.log("Printing climate values for: " + new SimpleDateFormat("yyyy MM dd").format(gregorianCalendar.getTime()));
        } else {
            DebugLog.log("Printing climate values for: " + new SimpleDateFormat("yyyy MM dd").format(this.testCurrentDay.calendar.getTime()));
        }
        DebugLog.log("--------------------------------------------------");
        DebugLog.log("Poll Worldagehours = " + this.cacheWorldAgeHours);
        DebugLog.log("Poll time = " + this.time);
        DebugLog.log("dawn = " + this.dawn);
        DebugLog.log("dusk = " + this.dusk);
        DebugLog.log("noon = " + this.noon);
        DebugLog.log("daymeantemperature = " + this.dayMeanTemperature);
        DebugLog.log("airMassNoiseFrequencyMod = " + this.airMassNoiseFrequencyMod);
        DebugLog.log("noiseAirmass = " + this.noiseAirmass);
        DebugLog.log("airMassTemperature = " + this.airMassTemperature);
        DebugLog.log("baseTemperature = " + this.baseTemperature);
        DebugLog.log("dayLightLagged = " + this.dayLightLagged);
        DebugLog.log("nightLagged = " + this.nightLagged);
        DebugLog.log("temperature = " + this.temperature);
        DebugLog.log("temperatureIsSnow = " + this.temperatureIsSnow);
        DebugLog.log("humidity = " + this.humidity);
        DebugLog.log("windIntensity = " + this.windIntensity);
        DebugLog.log("windAngleIntensity = " + this.windAngleIntensity);
        DebugLog.log("windAngleDegrees = " + this.windAngleDegrees);
        DebugLog.log("nightStrength = " + this.nightStrength);
        DebugLog.log("dayLightStrength = " + this.dayLightStrength);
        DebugLog.log("ambient = " + this.ambient);
        DebugLog.log("desaturation = " + this.desaturation);
        DebugLog.log("dayLightStrengthBase = " + this.dayLightStrengthBase);
        DebugLog.log("lerpNight = " + this.lerpNight);
        DebugLog.log("cloudyT = " + this.cloudyT);
        DebugLog.log("cloudIntensity = " + this.cloudIntensity);
        DebugLog.log("airFrontAirmass = " + this.airFrontAirmass);
    }

    public void pollDate(int n, int n2, int n3) {
        this.pollDate(n, n2, n3, 0, 0);
    }

    public void pollDate(int n, int n2, int n3, int n4) {
        this.pollDate(n, n2, n3, n4, 0);
    }

    public void pollDate(int n, int n2, int n3, int n4, int n5) {
        this.pollDate(new GregorianCalendar(n, n2, n3, n4, n5));
    }

    public void pollDate(GregorianCalendar gregorianCalendar) {
        if (this.testCurrentDay == null) {
            this.testCurrentDay = new ClimateManager.DayInfo();
        }
        if (this.testNextDay == null) {
            this.testNextDay = new ClimateManager.DayInfo();
        }
        double d = this.gt.getWorldAgeHours();
        this.clim.setDayInfo(this.testCurrentDay, gregorianCalendar.get(5), gregorianCalendar.get(2), gregorianCalendar.get(1), 0);
        this.clim.setDayInfo(this.testNextDay, gregorianCalendar.get(5), gregorianCalendar.get(2), gregorianCalendar.get(1), 1);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(this.gt.getYear(), this.gt.getMonth(), this.gt.getDayPlusOne(), this.gt.getHour(), this.gt.getMinutes());
        double d2 = ChronoUnit.MINUTES.between(gregorianCalendar2.toInstant(), gregorianCalendar.toInstant());
        double d3 = d + (d2 /= 60.0);
        float f = (float)gregorianCalendar.get(11) + (float)gregorianCalendar.get(12) / 60.0f;
        this.updateValues(d3, f, this.testCurrentDay, this.testNextDay);
    }

    /*
     * Unable to fully structure code
     */
    protected void updateValues(double var1_1, float var3_2, ClimateManager.DayInfo var4_3, ClimateManager.DayInfo var5_4) {
        if (var4_3.year != this.cacheYear || var4_3.month != this.cacheMonth || var4_3.day != this.cacheDay) {
            var6_5 = (int)this.clim.getSimplexOffsetC();
            var7_7 = (int)this.clim.getSimplexOffsetD();
            var8_9 = (var4_3.year - 1990) * 100000;
            var8_9 += (long)(var4_3.month * var4_3.day * 1234);
            var8_9 += (long)((var4_3.year - 1990) * var4_3.month * 10000);
            this.seededRandom.setSeed(var8_9 += (long)((var7_7 - var6_5) * var4_3.day));
            this.dayFogStrength = 0.0f;
            this.dayDoFog = false;
            this.dayFogDuration = 0.0f;
            var10_11 = this.seededRandom.nextInt(1000);
            v0 = this.dayDoFog = var10_11 < 200.0f;
            if (this.dayDoFog) {
                this.dayFogDuration = 4.0f;
                if (var10_11 < 25.0f) {
                    this.dayFogStrength = 1.0f;
                    this.dayFogDuration += 2.0f;
                } else {
                    this.dayFogStrength = this.seededRandom.nextFloat();
                }
                var11_12 = var4_3.season.getDayMeanTemperature();
                var12_13 = (float)SimplexNoise.noise(this.simplexOffsetA, (var1_1 + 12.0 - 48.0) / this.clim.getAirMassNoiseFrequencyMod(SandboxOptions.instance.getRainModifier()));
                var11_12 += var12_13 * 8.0f;
                var13_14 = this.seededRandom.nextFloat();
                if (var11_12 < 0.0f) {
                    this.dayFogDuration += 5.0f * this.dayFogStrength;
                    this.dayFogDuration += 8.0f * var13_14;
                } else if (var11_12 < 10.0f) {
                    this.dayFogDuration += 2.5f * this.dayFogStrength;
                    this.dayFogDuration += 5.0f * var13_14;
                } else if (var11_12 < 20.0f) {
                    this.dayFogDuration += 1.5f * this.dayFogStrength;
                    this.dayFogDuration += 2.5f * var13_14;
                } else {
                    this.dayFogDuration += 1.0f * this.dayFogStrength;
                    this.dayFogDuration += 1.0f * var13_14;
                }
                if (this.dayFogDuration > 24.0f - var4_3.season.getDawn()) {
                    this.dayFogDuration = 24.0f - var4_3.season.getDawn() - 1.0f;
                }
            }
        }
        this.cacheWorldAgeHours = var1_1;
        this.cacheYear = var4_3.year;
        this.cacheMonth = var4_3.month;
        this.cacheDay = var4_3.day;
        this.time = var3_2;
        this.dawn = var4_3.season.getDawn();
        this.dusk = var4_3.season.getDusk();
        this.noon = var4_3.season.getDayHighNoon();
        this.dayMeanTemperature = var4_3.season.getDayMeanTemperature();
        var6_6 = var3_2 / 24.0f;
        var7_8 = ClimateManager.lerp(var6_6, var4_3.season.getCurDayPercent(), var5_4.season.getCurDayPercent());
        this.airMassNoiseFrequencyMod = this.clim.getAirMassNoiseFrequencyMod(SandboxOptions.instance.getRainModifier());
        this.noiseAirmass = (float)SimplexNoise.noise(this.simplexOffsetA, var1_1 / this.airMassNoiseFrequencyMod);
        var8_10 = (float)SimplexNoise.noise(this.simplexOffsetC, var1_1 / this.airMassNoiseFrequencyMod);
        this.airMassTemperature = (float)SimplexNoise.noise(this.simplexOffsetA, (var1_1 - 48.0) / this.airMassNoiseFrequencyMod);
        var9_16 = Math.floor(var1_1) + 12.0;
        this.airFrontAirmass = (float)SimplexNoise.noise(this.simplexOffsetA, var9_16 / this.airMassNoiseFrequencyMod);
        var11_12 = ClimateManager.clerp(var6_6, var4_3.season.getDayTemperature(), var5_4.season.getDayTemperature());
        var12_13 = ClimateManager.clerp(var6_6, var4_3.season.getDayMeanTemperature(), var5_4.season.getDayMeanTemperature());
        var13_15 = var11_12 < var12_13;
        this.baseTemperature = var12_13 + this.airMassTemperature * 8.0f;
        var14_17 = 4.0f;
        var15_18 = this.dusk + var14_17;
        if (var15_18 >= 24.0f) {
            var15_18 -= 24.0f;
        }
        this.dayLightLagged = this.clim.getTimeLerpHours(var3_2, this.dawn + var14_17, var15_18, true);
        var16_19 = 5.0f * (1.0f - this.dayLightLagged);
        this.nightLagged = this.clim.getTimeLerpHours(var3_2, var15_18, this.dawn + var14_17, true);
        this.temperature = this.baseTemperature + 1.0f - (var16_19 += 5.0f * this.nightLagged);
        if (this.temperature < 0.0f) ** GOTO lbl-1000
        if (ClimateManager.WINTER_IS_COMING) lbl-1000:
        // 2 sources

        {
            this.temperatureIsSnow = true;
        } else {
            this.temperatureIsSnow = false;
        }
        var17_20 = this.temperature;
        var17_20 = (45.0f - var17_20) / 90.0f;
        var17_20 = ClimateManager.clamp01(1.0f - var17_20);
        var18_21 = (1.0f + var8_10) * 0.5f;
        this.humidity = var18_21 * var17_20;
        var19_22 = 1.0f - (this.airMassTemperature + 1.0f) * 0.5f;
        var20_23 = 1.0f - var7_8 * 0.4f;
        var21_24 = (float)SimplexNoise.noise(var1_1 / 40.0, this.simplexOffsetA);
        var22_25 = (var21_24 + 1.0f) * 0.5f;
        var22_25 *= var19_22 * var20_23;
        this.windIntensity = var22_25 *= 0.65f;
        this.windAngleIntensity = var23_26 = (float)SimplexNoise.noise(var1_1 / 80.0, this.simplexOffsetB);
        var24_27 = (float)SimplexNoise.noise(var1_1 / 40.0, this.simplexOffsetD);
        var24_27 = (var24_27 + 1.0f) * 0.5f;
        this.windAngleDegrees = 360.0f * var24_27;
        this.lerpNight = this.clim.getTimeLerpHours(var3_2, this.dusk, this.dawn, true);
        this.nightStrength = this.lerpNight = ClimateManager.clamp(0.0f, 1.0f, this.lerpNight * 2.0f);
        this.dayLightStrengthBase = 1.0f - this.nightStrength;
        var25_28 = 1.0f - 0.15f * var7_8 - 0.2f * this.windIntensity;
        this.dayLightStrengthBase *= var25_28;
        this.ambient = this.dayLightStrength = this.dayLightStrengthBase;
        var26_29 = (1.0f - var4_3.season.getCurDayPercent()) * 0.4f;
        var27_30 = (1.0f - var5_4.season.getCurDayPercent()) * 0.4f;
        this.desaturation = ClimateManager.lerp(var6_6, var26_29, var27_30);
        this.cloudyT = 1.0f - ClimateManager.clamp01((this.airMassTemperature + 0.8f) * 0.625f);
        this.cloudyT *= 0.8f;
        this.cloudyT = ClimateManager.clamp01(this.cloudyT + this.windIntensity);
        this.cloudIntensity = ClimateManager.clamp01(this.windIntensity * 2.0f);
        this.cloudIntensity -= this.cloudIntensity * 0.5f * this.nightStrength;
    }

    public float getTime() {
        return this.time;
    }

    public float getDawn() {
        return this.dawn;
    }

    public float getDusk() {
        return this.dusk;
    }

    public float getNoon() {
        return this.noon;
    }

    public double getAirMassNoiseFrequencyMod() {
        return this.airMassNoiseFrequencyMod;
    }

    public float getNoiseAirmass() {
        return this.noiseAirmass;
    }

    public float getAirMassTemperature() {
        return this.airMassTemperature;
    }

    public float getBaseTemperature() {
        return this.baseTemperature;
    }

    public float getDayLightLagged() {
        return this.dayLightLagged;
    }

    public float getNightLagged() {
        return this.nightLagged;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean isTemperatureIsSnow() {
        return this.temperatureIsSnow;
    }

    public float getHumidity() {
        return this.humidity;
    }

    public float getWindIntensity() {
        return this.windIntensity;
    }

    public float getWindAngleIntensity() {
        return this.windAngleIntensity;
    }

    public float getWindAngleDegrees() {
        return this.windAngleDegrees;
    }

    public float getNightStrength() {
        return this.nightStrength;
    }

    public float getDayLightStrength() {
        return this.dayLightStrength;
    }

    public float getAmbient() {
        return this.ambient;
    }

    public float getDesaturation() {
        return this.desaturation;
    }

    public float getDayLightStrengthBase() {
        return this.dayLightStrengthBase;
    }

    public float getLerpNight() {
        return this.lerpNight;
    }

    public float getCloudyT() {
        return this.cloudyT;
    }

    public float getCloudIntensity() {
        return this.cloudIntensity;
    }

    public float getAirFrontAirmass() {
        return this.airFrontAirmass;
    }

    public double getCacheWorldAgeHours() {
        return this.cacheWorldAgeHours;
    }

    public int getCacheYear() {
        return this.cacheYear;
    }

    public int getCacheMonth() {
        return this.cacheMonth;
    }

    public int getCacheDay() {
        return this.cacheDay;
    }

    public float getDayMeanTemperature() {
        return this.dayMeanTemperature;
    }

    public boolean isDayDoFog() {
        return this.dayDoFog;
    }

    public float getDayFogStrength() {
        return this.dayFogStrength;
    }

    public float getDayFogDuration() {
        return this.dayFogDuration;
    }
}

