/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import zombie.debug.DebugLog;

public class ClimateMoon {
    private static final int[] day_year = new int[]{-1, -1, 30, 58, 89, 119, 150, 180, 211, 241, 272, 303, 333};
    private static final String[] moon_phase_name = new String[]{"New", "Waxing crescent", "First quarter", "Waxing gibbous", "Full", "Waning gibbous", "Third quarter", "Waning crescent"};
    private static final float[] units = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 0.75f, 0.5f, 0.25f};
    private static int last_year;
    private static int last_month;
    private static int last_day;
    private static int current_phase;
    private static float current_float;
    private static ClimateMoon instance;

    public static ClimateMoon getInstance() {
        return instance;
    }

    public static void updatePhase(int n, int n2, int n3) {
        if (n != last_year || n2 != last_month || n3 != last_day) {
            last_year = n;
            last_month = n2;
            last_day = n3;
            current_phase = ClimateMoon.getMoonPhase(n, n2, n3);
            if (current_phase > 7) {
                current_phase = 7;
            }
            if (current_phase < 0) {
                current_phase = 0;
            }
            current_float = units[current_phase];
            DebugLog.log("Updated MoonPhase = " + ClimateMoon.getPhaseName() + ", float = " + current_float + ", int = " + current_phase);
        }
    }

    public static String getPhaseName() {
        return moon_phase_name[current_phase];
    }

    public static float getMoonFloat() {
        return current_float;
    }

    public int getCurrentMoonPhase() {
        return current_phase;
    }

    private static int getMoonPhase(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n2 < 0 || n2 > 12) {
            n2 = 0;
        }
        int n7 = n3 + day_year[n2];
        if (n2 > 2 && ClimateMoon.isLeapYearP(n)) {
            ++n7;
        }
        if ((n6 = (11 * (n5 = n % 19 + 1) + 20 + (8 * (n4 = n / 100 + 1) + 5) / 25 - 5 - (3 * n4 / 4 - 12)) % 30) <= 0) {
            n6 += 30;
        }
        if (n6 == 25 && n5 > 11 || n6 == 24) {
            ++n6;
        }
        int n8 = ((n7 + n6) * 6 + 11) % 177 / 22 & 7;
        return n8;
    }

    private static int daysInMonth(int n, int n2) {
        int n3 = 31;
        switch (n) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n3 = 30;
                break;
            }
            case 2: {
                n3 = ClimateMoon.isLeapYearP(n2) ? 29 : 28;
            }
        }
        return n3;
    }

    private static boolean isLeapYearP(int n) {
        return n % 4 == 0 && (n % 400 == 0 || n % 100 != 0);
    }

    static {
        current_phase = 0;
        current_float = 0.0f;
        instance = new ClimateMoon();
    }
}

