/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import zombie.GameTime;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.ClimateValues;
import zombie.iso.weather.WeatherPeriod;

public class ClimateForecaster {
    private static final int OffsetToday = 10;
    private ClimateValues climateValues;
    private DayForecast[] forecasts = new DayForecast[40];
    private ArrayList<DayForecast> forecastList = new ArrayList(40);

    public ArrayList<DayForecast> getForecasts() {
        return this.forecastList;
    }

    public DayForecast getForecast() {
        return this.getForecast(0);
    }

    public DayForecast getForecast(int n) {
        int n2 = 10 + n;
        if (n2 >= 0 && n2 < this.forecasts.length) {
            return this.forecasts[n2];
        }
        return null;
    }

    private void populateForecastList() {
        this.forecastList.clear();
        for (int i = 0; i < this.forecasts.length; ++i) {
            this.forecastList.add(this.forecasts[i]);
        }
    }

    protected void init(ClimateManager climateManager) {
        this.climateValues = climateManager.getClimateValuesCopy();
        for (int i = 0; i < this.forecasts.length; ++i) {
            int n = i - 10;
            DayForecast dayForecast = new DayForecast();
            dayForecast.weatherPeriod = new WeatherPeriod(climateManager, climateManager.getThunderStorm());
            dayForecast.weatherPeriod.setDummy(true);
            dayForecast.indexOffset = n;
            dayForecast.airFront = new ClimateManager.AirFront();
            this.sampleDay(climateManager, dayForecast, n);
            this.forecasts[i] = dayForecast;
        }
        this.populateForecastList();
    }

    protected void updateDayChange(ClimateManager climateManager) {
        DayForecast dayForecast = this.forecasts[0];
        for (int i = 0; i < this.forecasts.length; ++i) {
            if (i <= 0 || i >= this.forecasts.length) continue;
            this.forecasts[i].indexOffset = i - 1 - 10;
            this.forecasts[i - 1] = this.forecasts[i];
        }
        dayForecast.reset();
        this.sampleDay(climateManager, dayForecast, this.forecasts.length - 1 - 10);
        dayForecast.indexOffset = this.forecasts.length - 1 - 10;
        this.forecasts[this.forecasts.length - 1] = dayForecast;
        this.populateForecastList();
    }

    protected void sampleDay(ClimateManager climateManager, DayForecast dayForecast, int n) {
        DayForecast dayForecast2;
        GameTime gameTime = GameTime.getInstance();
        int n2 = gameTime.getYear();
        int n3 = gameTime.getMonth();
        int n4 = gameTime.getDayPlusOne();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3, n4, 0, 0);
        gregorianCalendar.add(5, n);
        boolean bl = true;
        dayForecast.weatherOverlap = dayForecast2 = this.getWeatherOverlap(n + 10, 0.0f);
        dayForecast.weatherPeriod.stopWeatherPeriod();
        dayForecast.name = "day: " + gregorianCalendar.get(1) + " - " + (gregorianCalendar.get(2) + 1) + " - " + gregorianCalendar.get(5);
        for (int i = 0; i < 24; ++i) {
            float f;
            boolean bl2;
            if (i != 0) {
                gregorianCalendar.add(11, 1);
            }
            this.climateValues.pollDate(gregorianCalendar);
            if (i == 0) {
                bl = this.climateValues.getNoiseAirmass() >= 0.0f;
                dayForecast.airFrontString = bl ? "WARM" : "COLD";
                dayForecast.dawn = this.climateValues.getDawn();
                dayForecast.dusk = this.climateValues.getDusk();
                dayForecast.dayLightHours = dayForecast.dusk - dayForecast.dawn;
            }
            if (!dayForecast.weatherStarts && (bl && this.climateValues.getNoiseAirmass() < 0.0f || !bl && this.climateValues.getNoiseAirmass() >= 0.0f)) {
                bl2 = this.climateValues.getNoiseAirmass() >= 0.0f ? -1 != 0 : true;
                dayForecast.airFront.setFrontType(bl2 ? 1 : 0);
                climateManager.CalculateWeatherFrontStrength(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), dayForecast.airFront);
                dayForecast.airFront.setFrontWind(this.climateValues.getWindAngleDegrees());
                if (dayForecast.airFront.getStrength() >= 0.1f) {
                    DayForecast dayForecast3 = this.getWeatherOverlap(n + 10, i);
                    float f2 = f = dayForecast3 != null ? dayForecast3.weatherPeriod.getTotalStrength() : -1.0f;
                    if (f < 0.1f) {
                        dayForecast.weatherStarts = true;
                        dayForecast.weatherStartTime = i;
                        dayForecast.weatherPeriod.init(dayForecast.airFront, this.climateValues.getCacheWorldAgeHours(), gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
                    }
                }
                if (!dayForecast.weatherStarts) {
                    bl = !bl;
                }
            }
            bl2 = (float)i > this.climateValues.getDawn() && (float)i <= this.climateValues.getDusk();
            float f3 = this.climateValues.getTemperature();
            f = this.climateValues.getHumidity();
            float f4 = this.climateValues.getWindAngleDegrees();
            float f5 = this.climateValues.getWindIntensity();
            float f6 = this.climateValues.getCloudIntensity();
            if (dayForecast.weatherStarts || dayForecast.weatherOverlap != null) {
                WeatherPeriod weatherPeriod;
                WeatherPeriod weatherPeriod2 = weatherPeriod = dayForecast.weatherStarts ? dayForecast.weatherPeriod : dayForecast.weatherOverlap.weatherPeriod;
                if (weatherPeriod != null) {
                    f4 = weatherPeriod.getWindAngleDegrees();
                    WeatherPeriod.WeatherStage weatherStage = weatherPeriod.getStageForWorldAge(this.climateValues.getCacheWorldAgeHours());
                    if (weatherStage != null) {
                        if (!dayForecast.weatherStages.contains(weatherStage.getStageID())) {
                            dayForecast.weatherStages.add(weatherStage.getStageID());
                        }
                        switch (weatherStage.getStageID()) {
                            case 7: {
                                dayForecast.chanceOnSnow = true;
                                f5 = 0.75f + 0.25f * weatherPeriod.getTotalStrength();
                                f3 -= WeatherPeriod.getMaxTemperatureInfluence() * f5;
                                f6 = 0.5f + 0.5f * f5;
                                dayForecast.hasBlizzard = true;
                                break;
                            }
                            case 2: {
                                f5 = 0.5f * weatherPeriod.getTotalStrength();
                                f3 -= WeatherPeriod.getMaxTemperatureInfluence() * f5;
                                f6 = 0.5f + 0.5f * f5;
                                dayForecast.hasHeavyRain = true;
                                break;
                            }
                            case 3: {
                                f5 = 0.2f + 0.5f * weatherPeriod.getTotalStrength();
                                f3 -= WeatherPeriod.getMaxTemperatureInfluence() * f5;
                                f6 = 0.5f + 0.5f * f5;
                                dayForecast.hasStorm = true;
                                break;
                            }
                            case 8: {
                                f5 = 0.4f + 0.6f * weatherPeriod.getTotalStrength();
                                f3 -= WeatherPeriod.getMaxTemperatureInfluence() * f5;
                                f6 = 0.5f + 0.5f * f5;
                                dayForecast.hasTropicalStorm = true;
                                break;
                            }
                            case 1: {
                                dayForecast.hasHeavyRain = true;
                            }
                            default: {
                                f3 -= WeatherPeriod.getMaxTemperatureInfluence() * 0.25f;
                                f6 = 0.35f + 0.5f * weatherPeriod.getTotalStrength();
                                break;
                            }
                        }
                    } else if (dayForecast.weatherOverlap != null && (float)i < dayForecast.weatherEndTime) {
                        dayForecast.weatherEndTime = i;
                    }
                }
                if (f3 < 0.0f) {
                    dayForecast.chanceOnSnow = true;
                }
            }
            dayForecast.temperature.add(f3, bl2);
            dayForecast.humidity.add(f, bl2);
            dayForecast.windDirection.add(f4, bl2);
            dayForecast.windPower.add(f5, bl2);
            dayForecast.cloudiness.add(f6, bl2);
        }
        dayForecast.temperature.calculate();
        dayForecast.humidity.calculate();
        dayForecast.windDirection.calculate();
        dayForecast.windPower.calculate();
        dayForecast.cloudiness.calculate();
        dayForecast.hasFog = this.climateValues.isDayDoFog();
        dayForecast.fogStrength = this.climateValues.getDayFogStrength();
        dayForecast.fogDuration = this.climateValues.getDayFogDuration();
    }

    private DayForecast getWeatherOverlap(int n, float f) {
        int n2 = Math.max(0, n - 10);
        if (n2 == n) {
            return null;
        }
        for (int i = n2; i < n; ++i) {
            if (!this.forecasts[i].weatherStarts) continue;
            float f2 = (float)this.forecasts[i].weatherPeriod.getDuration() / 24.0f;
            float f3 = (float)i + this.forecasts[i].weatherStartTime / 24.0f;
            float f4 = (float)n + f / 24.0f;
            if (!((f3 += f2) > f4)) continue;
            return this.forecasts[i];
        }
        return null;
    }

    public int getDaysTillFirstWeather() {
        int n = -1;
        for (int i = 10; i < this.forecasts.length - 1; ++i) {
            if (!this.forecasts[i].weatherStarts || n >= 0) continue;
            n = i;
        }
        return n;
    }

    public static class DayForecast {
        private int indexOffset = 0;
        private String name = "Day x";
        private WeatherPeriod weatherPeriod;
        private ForecastValue temperature = new ForecastValue();
        private ForecastValue humidity = new ForecastValue();
        private ForecastValue windDirection = new ForecastValue();
        private ForecastValue windPower = new ForecastValue();
        private ForecastValue cloudiness = new ForecastValue();
        private boolean weatherStarts = false;
        private float weatherStartTime = 0.0f;
        private float weatherEndTime = 24.0f;
        private boolean chanceOnSnow = false;
        private String airFrontString = "";
        private boolean hasFog = false;
        private float fogStrength = 0.0f;
        private float fogDuration = 0.0f;
        private ClimateManager.AirFront airFront;
        private DayForecast weatherOverlap;
        private boolean hasHeavyRain = false;
        private boolean hasStorm = false;
        private boolean hasTropicalStorm = false;
        private boolean hasBlizzard = false;
        private float dawn = 0.0f;
        private float dusk = 0.0f;
        private float dayLightHours = 0.0f;
        private ArrayList<Integer> weatherStages = new ArrayList();

        public int getIndexOffset() {
            return this.indexOffset;
        }

        public String getName() {
            return this.name;
        }

        public ForecastValue getTemperature() {
            return this.temperature;
        }

        public ForecastValue getHumidity() {
            return this.humidity;
        }

        public ForecastValue getWindDirection() {
            return this.windDirection;
        }

        public ForecastValue getWindPower() {
            return this.windPower;
        }

        public ForecastValue getCloudiness() {
            return this.cloudiness;
        }

        public WeatherPeriod getWeatherPeriod() {
            return this.weatherPeriod;
        }

        public boolean isWeatherStarts() {
            return this.weatherStarts;
        }

        public float getWeatherStartTime() {
            return this.weatherStartTime;
        }

        public float getWeatherEndTime() {
            return this.weatherEndTime;
        }

        public boolean isChanceOnSnow() {
            return this.chanceOnSnow;
        }

        public String getAirFrontString() {
            return this.airFrontString;
        }

        public boolean isHasFog() {
            return this.hasFog;
        }

        public ClimateManager.AirFront getAirFront() {
            return this.airFront;
        }

        public DayForecast getWeatherOverlap() {
            return this.weatherOverlap;
        }

        public String getMeanWindAngleString() {
            return ClimateManager.getWindAngleString(this.windDirection.getTotalMean());
        }

        public float getFogStrength() {
            return this.fogStrength;
        }

        public float getFogDuration() {
            return this.fogDuration;
        }

        public boolean isHasHeavyRain() {
            return this.hasHeavyRain;
        }

        public boolean isHasStorm() {
            return this.hasStorm;
        }

        public boolean isHasTropicalStorm() {
            return this.hasTropicalStorm;
        }

        public boolean isHasBlizzard() {
            return this.hasBlizzard;
        }

        public ArrayList<Integer> getWeatherStages() {
            return this.weatherStages;
        }

        public float getDawn() {
            return this.dawn;
        }

        public float getDusk() {
            return this.dusk;
        }

        public float getDayLightHours() {
            return this.dayLightHours;
        }

        private void reset() {
            this.weatherPeriod.stopWeatherPeriod();
            this.temperature.reset();
            this.humidity.reset();
            this.windDirection.reset();
            this.windPower.reset();
            this.cloudiness.reset();
            this.weatherStarts = false;
            this.weatherStartTime = 0.0f;
            this.weatherEndTime = 24.0f;
            this.chanceOnSnow = false;
            this.hasFog = false;
            this.fogStrength = 0.0f;
            this.fogDuration = 0.0f;
            this.weatherOverlap = null;
            this.hasHeavyRain = false;
            this.hasStorm = false;
            this.hasTropicalStorm = false;
            this.hasBlizzard = false;
            this.weatherStages.clear();
        }
    }

    public static class ForecastValue {
        private float dayMin;
        private float dayMax;
        private float dayMean;
        private int dayMeanTicks;
        private float nightMin;
        private float nightMax;
        private float nightMean;
        private int nightMeanTicks;
        private float totalMin;
        private float totalMax;
        private float totalMean;
        private int totalMeanTicks;

        public ForecastValue() {
            this.reset();
        }

        public float getDayMin() {
            return this.dayMin;
        }

        public float getDayMax() {
            return this.dayMax;
        }

        public float getDayMean() {
            return this.dayMean;
        }

        public float getNightMin() {
            return this.nightMin;
        }

        public float getNightMax() {
            return this.nightMax;
        }

        public float getNightMean() {
            return this.nightMean;
        }

        public float getTotalMin() {
            return this.totalMin;
        }

        public float getTotalMax() {
            return this.totalMax;
        }

        public float getTotalMean() {
            return this.totalMean;
        }

        protected void add(float f, boolean bl) {
            if (bl) {
                if (f < this.dayMin) {
                    this.dayMin = f;
                }
                if (f > this.dayMax) {
                    this.dayMax = f;
                }
                this.dayMean += f;
                ++this.dayMeanTicks;
            } else {
                if (f < this.nightMin) {
                    this.nightMin = f;
                }
                if (f > this.nightMax) {
                    this.nightMax = f;
                }
                this.nightMean += f;
                ++this.nightMeanTicks;
            }
            if (f < this.totalMin) {
                this.totalMin = f;
            }
            if (f > this.totalMax) {
                this.totalMax = f;
            }
            this.totalMean += f;
            ++this.totalMeanTicks;
        }

        protected void calculate() {
            this.totalMean = this.totalMeanTicks <= 0 ? 0.0f : (this.totalMean /= (float)this.totalMeanTicks);
            if (this.dayMeanTicks <= 0) {
                this.dayMin = this.totalMin;
                this.dayMax = this.totalMax;
                this.dayMean = this.totalMean;
            } else {
                this.dayMean /= (float)this.dayMeanTicks;
            }
            if (this.nightMeanTicks <= 0) {
                this.nightMin = this.totalMin;
                this.nightMax = this.totalMax;
                this.nightMean = this.totalMean;
            } else {
                this.nightMean /= (float)this.nightMeanTicks;
            }
        }

        protected void reset() {
            this.dayMin = 10000.0f;
            this.dayMax = -10000.0f;
            this.dayMean = 0.0f;
            this.dayMeanTicks = 0;
            this.nightMin = 10000.0f;
            this.nightMax = -10000.0f;
            this.nightMean = 0.0f;
            this.nightMeanTicks = 0;
            this.totalMin = 10000.0f;
            this.totalMax = -10000.0f;
            this.totalMean = 0.0f;
            this.totalMeanTicks = 0;
        }
    }
}

