/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite.shapers;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.TransformerException;
import zombie.DebugFileWatcher;
import zombie.PredicatedFileWatcher;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.iso.sprite.shapers.FloorShaperAttachedSprites;
import zombie.iso.sprite.shapers.FloorShaperDeDiamond;
import zombie.iso.sprite.shapers.SpritePadding;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;

public class SpritePaddingSettings {
    private static Settings m_settings = null;
    private static String m_settingsFilePath = null;
    private static PredicatedFileWatcher m_fileWatcher = null;

    public static void settingsFileChanged(Settings settings) {
        DebugLog.General.println("Settings file changed.");
        m_settings = settings;
    }

    private static void loadSettings() {
        String string = SpritePaddingSettings.getSettingsFilePath();
        File file = new File(string).getAbsoluteFile();
        if (file.isFile()) {
            try {
                m_settings = PZXmlUtil.parse(Settings.class, file.getPath());
            }
            catch (PZXmlParserException pZXmlParserException) {
                DebugLog.General.printException(pZXmlParserException, "Error parsing file: " + string, LogSeverity.Warning);
                m_settings = new Settings();
            }
        } else {
            m_settings = new Settings();
            SpritePaddingSettings.saveSettings();
        }
        if (m_fileWatcher == null) {
            m_fileWatcher = new PredicatedFileWatcher(string, Settings.class, SpritePaddingSettings::settingsFileChanged);
            DebugFileWatcher.instance.add(m_fileWatcher);
        }
    }

    private static String getSettingsFilePath() {
        if (m_settingsFilePath == null) {
            m_settingsFilePath = ZomboidFileSystem.instance.getLocalWorkDirSub("SpritePaddingSettings.xml");
        }
        return m_settingsFilePath;
    }

    private static void saveSettings() {
        try {
            PZXmlUtil.write(m_settings, new File(SpritePaddingSettings.getSettingsFilePath()).getAbsoluteFile());
        }
        catch (IOException | JAXBException | TransformerException throwable) {
            throwable.printStackTrace();
        }
    }

    public static Settings getSettings() {
        if (m_settings == null) {
            SpritePaddingSettings.loadSettings();
        }
        return m_settings;
    }

    @XmlRootElement(name="FloorShaperDeDiamondSettings")
    public static class Settings {
        public SpritePadding.IsoPaddingSettings IsoPadding = new SpritePadding.IsoPaddingSettings();
        public FloorShaperDeDiamond.Settings FloorDeDiamond = new FloorShaperDeDiamond.Settings();
        public FloorShaperAttachedSprites.Settings AttachedSprites = new FloorShaperAttachedSprites.Settings();
    }

    public static abstract class GenericZoomBasedSettingGroup {
        public abstract <ZoomBasedSetting> ZoomBasedSetting getCurrentZoomSetting();

        public static <ZoomBasedSetting> ZoomBasedSetting getCurrentZoomSetting(ZoomBasedSetting ZoomBasedSetting, ZoomBasedSetting ZoomBasedSetting2, ZoomBasedSetting ZoomBasedSetting3) {
            float f = Core.getInstance().getCurrentPlayerZoom();
            if (f < 1.0f) {
                return ZoomBasedSetting;
            }
            if (f == 1.0f) {
                return ZoomBasedSetting2;
            }
            return ZoomBasedSetting3;
        }
    }
}

