/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite.shapers;

import java.util.function.Consumer;
import zombie.core.Color;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.iso.sprite.shapers.SpritePadding;
import zombie.iso.sprite.shapers.SpritePaddingSettings;

public class FloorShaper
implements Consumer<TextureDraw> {
    protected final int[] col = new int[4];
    protected int colTint = 0;
    protected boolean isShore = false;
    protected final float[] waterDepth = new float[4];

    public void setVertColors(int n, int n2, int n3, int n4) {
        this.col[0] = n;
        this.col[1] = n2;
        this.col[2] = n3;
        this.col[3] = n4;
    }

    public void setAlpha4(float f) {
        int n = (int)(f * 255.0f) & 0xFF;
        this.col[0] = this.col[0] & 0xFFFFFF | n << 24;
        this.col[1] = this.col[1] & 0xFFFFFF | n << 24;
        this.col[2] = this.col[2] & 0xFFFFFF | n << 24;
        this.col[3] = this.col[3] & 0xFFFFFF | n << 24;
    }

    public void setShore(boolean bl) {
        this.isShore = bl;
    }

    public void setWaterDepth(float f, float f2, float f3, float f4) {
        this.waterDepth[0] = f;
        this.waterDepth[1] = f2;
        this.waterDepth[2] = f3;
        this.waterDepth[3] = f4;
    }

    public void setTintColor(int n) {
        this.colTint = n;
    }

    @Override
    public void accept(TextureDraw textureDraw) {
        if (DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Floor.Lighting.getValue()) {
            textureDraw.col0 = Color.blendBGR(textureDraw.col0, this.col[0]);
            textureDraw.col1 = Color.blendBGR(textureDraw.col1, this.col[1]);
            textureDraw.col2 = Color.blendBGR(textureDraw.col2, this.col[2]);
            textureDraw.col3 = Color.blendBGR(textureDraw.col3, this.col[3]);
        }
        if (this.isShore && DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.ShoreFade.getValue()) {
            textureDraw.col0 = Color.setAlphaChannelToABGR(textureDraw.col0, 1.0f - this.waterDepth[0]);
            textureDraw.col1 = Color.setAlphaChannelToABGR(textureDraw.col1, 1.0f - this.waterDepth[1]);
            textureDraw.col2 = Color.setAlphaChannelToABGR(textureDraw.col2, 1.0f - this.waterDepth[2]);
            textureDraw.col3 = Color.setAlphaChannelToABGR(textureDraw.col3, 1.0f - this.waterDepth[3]);
        }
        if (this.colTint != 0) {
            textureDraw.col0 = Color.tintABGR(textureDraw.col0, this.colTint);
            textureDraw.col1 = Color.tintABGR(textureDraw.col1, this.colTint);
            textureDraw.col2 = Color.tintABGR(textureDraw.col2, this.colTint);
            textureDraw.col3 = Color.tintABGR(textureDraw.col3, this.colTint);
        }
        SpritePadding.applyIsoPadding(textureDraw, this.getIsoPaddingSettings());
    }

    private SpritePadding.IsoPaddingSettings getIsoPaddingSettings() {
        return SpritePaddingSettings.getSettings().IsoPadding;
    }
}

