/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import zombie.core.Color;
import zombie.debug.DebugLog;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.sprite.IsoAnim;
import zombie.iso.sprite.IsoSprite;

public final class IsoSpriteManager {
    public static final IsoSpriteManager instance = new IsoSpriteManager();
    public final HashMap<String, IsoSprite> NamedMap = new HashMap();
    public final TIntObjectHashMap<IsoSprite> IntMap = new TIntObjectHashMap();
    private final IsoSprite emptySprite;

    public IsoSpriteManager() {
        IsoSprite isoSprite = this.emptySprite = new IsoSprite(this);
        isoSprite.name = "";
        isoSprite.ID = -1;
        isoSprite.Properties.Set(IsoFlagType.invisible);
        isoSprite.CurrentAnim = new IsoAnim();
        isoSprite.CurrentAnim.ID = isoSprite.AnimStack.size();
        isoSprite.AnimStack.add(isoSprite.CurrentAnim);
        isoSprite.AnimMap.put("default", isoSprite.CurrentAnim);
        this.NamedMap.put(isoSprite.name, isoSprite);
    }

    public void Dispose() {
        IsoSprite.DisposeAll();
        IsoAnim.DisposeAll();
        Object[] objectArray = this.IntMap.values();
        for (int i = 0; i < objectArray.length; ++i) {
            IsoSprite isoSprite = (IsoSprite)objectArray[i];
            isoSprite.Dispose();
            isoSprite.def = null;
            isoSprite.parentManager = null;
        }
        this.IntMap.clear();
        this.NamedMap.clear();
        this.NamedMap.put(this.emptySprite.name, this.emptySprite);
    }

    public IsoSprite getSprite(int n) {
        if (this.IntMap.containsKey(n)) {
            return (IsoSprite)this.IntMap.get(n);
        }
        return null;
    }

    public IsoSprite getSprite(String string) {
        if (this.NamedMap.containsKey(string)) {
            return this.NamedMap.get(string);
        }
        return this.AddSprite(string);
    }

    public IsoSprite getOrAddSpriteCache(String string) {
        if (this.NamedMap.containsKey(string)) {
            return this.NamedMap.get(string);
        }
        IsoSprite isoSprite = new IsoSprite(this);
        isoSprite.LoadFramesNoDirPageSimple(string);
        this.NamedMap.put(string, isoSprite);
        return isoSprite;
    }

    public IsoSprite getOrAddSpriteCache(String string, Color color) {
        int n = (int)(color.r * 255.0f);
        int n2 = (int)(color.g * 255.0f);
        int n3 = (int)(color.b * 255.0f);
        String string2 = string + "_" + n + "_" + n2 + "_" + n3;
        if (this.NamedMap.containsKey(string2)) {
            return this.NamedMap.get(string2);
        }
        IsoSprite isoSprite = new IsoSprite(this);
        isoSprite.LoadFramesNoDirPageSimple(string);
        this.NamedMap.put(string2, isoSprite);
        return isoSprite;
    }

    public IsoSprite AddSprite(String string) {
        IsoSprite isoSprite = new IsoSprite(this);
        isoSprite.LoadFramesNoDirPageSimple(string);
        this.NamedMap.put(string, isoSprite);
        return isoSprite;
    }

    public IsoSprite AddSprite(String string, int n) {
        IsoSprite isoSprite = new IsoSprite(this);
        isoSprite.LoadFramesNoDirPageSimple(string);
        if (this.NamedMap.containsKey(string)) {
            DebugLog.log("duplicate texture " + string + " ignore ID=" + n + ", use ID=" + this.NamedMap.get((Object)string).ID);
            n = this.NamedMap.get((Object)string).ID;
        }
        this.NamedMap.put(string, isoSprite);
        isoSprite.ID = n;
        this.IntMap.put(n, (Object)isoSprite);
        return isoSprite;
    }
}

