/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.util.ArrayDeque;
import java.util.ArrayList;
import zombie.GameTime;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.iso.IsoObject;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameServer;

public class ObjectRenderEffects {
    public static final boolean ENABLED = true;
    private static ArrayDeque<ObjectRenderEffects> pool = new ArrayDeque();
    public double x1;
    public double y1;
    public double x2;
    public double y2;
    public double x3;
    public double y3;
    public double x4;
    public double y4;
    private double tx1;
    private double ty1;
    private double tx2;
    private double ty2;
    private double tx3;
    private double ty3;
    private double tx4;
    private double ty4;
    private double lx1;
    private double ly1;
    private double lx2;
    private double ly2;
    private double lx3;
    private double ly3;
    private double lx4;
    private double ly4;
    private double maxX;
    private double maxY;
    private float curTime = 0.0f;
    private float maxTime = 0.0f;
    private float totalTime = 0.0f;
    private float totalMaxTime = 0.0f;
    private RenderEffectType type;
    private IsoObject parent;
    private boolean finish = false;
    private boolean isTree = false;
    private boolean isBig = false;
    private boolean gust = false;
    private int windType = 1;
    private static float T_MOD = 1.0f;
    private static int windCount = 0;
    private static int windCountTree = 0;
    private static final int EFFECTS_COUNT = 15;
    private static final int TYPE_COUNT = 3;
    private static final ObjectRenderEffects[][] WIND_EFFECTS = new ObjectRenderEffects[3][15];
    private static final ObjectRenderEffects[][] WIND_EFFECTS_TREES = new ObjectRenderEffects[3][15];
    private static final ArrayList<ObjectRenderEffects> DYNAMIC_EFFECTS = new ArrayList();
    private static ObjectRenderEffects RANDOM_RUSTLE;
    private static float randomRustleTime;
    private static float randomRustleTotalTime;
    private static int randomRustleTarget;
    private static int randomRustleType;

    public static ObjectRenderEffects alloc() {
        ObjectRenderEffects objectRenderEffects = !pool.isEmpty() ? pool.pop() : new ObjectRenderEffects();
        return objectRenderEffects;
    }

    public static void release(ObjectRenderEffects objectRenderEffects) {
        assert (!pool.contains(objectRenderEffects));
        pool.push(objectRenderEffects.reset());
    }

    private ObjectRenderEffects() {
    }

    private ObjectRenderEffects reset() {
        this.parent = null;
        this.finish = false;
        this.isBig = false;
        this.isTree = false;
        this.curTime = 0.0f;
        this.maxTime = 0.0f;
        this.totalTime = 0.0f;
        this.totalMaxTime = 0.0f;
        this.x1 = 0.0;
        this.y1 = 0.0;
        this.x2 = 0.0;
        this.y2 = 0.0;
        this.x3 = 0.0;
        this.y3 = 0.0;
        this.x4 = 0.0;
        this.y4 = 0.0;
        this.tx1 = 0.0;
        this.ty1 = 0.0;
        this.tx2 = 0.0;
        this.ty2 = 0.0;
        this.tx3 = 0.0;
        this.ty3 = 0.0;
        this.tx4 = 0.0;
        this.ty4 = 0.0;
        this.swapTargetToLast();
        return this;
    }

    public static ObjectRenderEffects getNew(IsoObject isoObject, RenderEffectType renderEffectType, boolean bl) {
        return ObjectRenderEffects.getNew(isoObject, renderEffectType, bl, false);
    }

    public static ObjectRenderEffects getNew(IsoObject isoObject, RenderEffectType renderEffectType, boolean bl, boolean bl2) {
        if (GameServer.bServer) {
            return null;
        }
        if (renderEffectType == RenderEffectType.Hit_Door && !Core.getInstance().getOptionDoDoorSpriteEffects()) {
            return null;
        }
        ObjectRenderEffects objectRenderEffects = null;
        try {
            boolean bl3 = false;
            if (bl && isoObject != null && isoObject.getObjectRenderEffects() != null && isoObject.getObjectRenderEffects().type == renderEffectType) {
                objectRenderEffects = isoObject.getObjectRenderEffects();
                bl3 = true;
            } else {
                objectRenderEffects = ObjectRenderEffects.alloc();
            }
            objectRenderEffects.type = renderEffectType;
            objectRenderEffects.parent = isoObject;
            objectRenderEffects.finish = false;
            objectRenderEffects.isBig = false;
            objectRenderEffects.totalTime = 0.0f;
            switch (renderEffectType) {
                case Hit_Tree_Shudder: {
                    objectRenderEffects.totalMaxTime = Rand.Next(45.0f, 60.0f) * T_MOD;
                    break;
                }
                case Vegetation_Rustle: {
                    objectRenderEffects.totalMaxTime = Rand.Next(45.0f, 60.0f) * T_MOD;
                    if (isoObject == null || !(isoObject instanceof IsoTree)) break;
                    objectRenderEffects.isTree = true;
                    objectRenderEffects.isBig = ((IsoTree)isoObject).size > 4;
                    break;
                }
                case Hit_Door: {
                    objectRenderEffects.totalMaxTime = Rand.Next(15.0f, 30.0f) * T_MOD;
                }
            }
            if (!bl3 && isoObject != null && isoObject.getWindRenderEffects() != null && Core.getInstance().getOptionDoWindSpriteEffects()) {
                objectRenderEffects.copyMainFromOther(isoObject.getWindRenderEffects());
            }
            if (!bl3 && !bl2) {
                DYNAMIC_EFFECTS.add(objectRenderEffects);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return objectRenderEffects;
    }

    public static ObjectRenderEffects getNextWindEffect(int n, boolean bl) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= 3) {
            return null;
        }
        if (bl) {
            if (++windCountTree >= 15) {
                windCountTree = 0;
            }
            return WIND_EFFECTS_TREES[n2][windCountTree];
        }
        if (++windCount >= 15) {
            windCount = 0;
        }
        return WIND_EFFECTS[n2][windCount];
    }

    public static void init() {
        if (GameServer.bServer) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            ObjectRenderEffects objectRenderEffects;
            int n;
            for (n = 0; n < 15; ++n) {
                objectRenderEffects = new ObjectRenderEffects();
                objectRenderEffects.windType = i + 1;
                ObjectRenderEffects.WIND_EFFECTS[i][n] = objectRenderEffects;
            }
            for (n = 0; n < 15; ++n) {
                objectRenderEffects = new ObjectRenderEffects();
                objectRenderEffects.isTree = true;
                objectRenderEffects.windType = i + 1;
                ObjectRenderEffects.WIND_EFFECTS_TREES[i][n] = objectRenderEffects;
            }
        }
        DYNAMIC_EFFECTS.clear();
        windCount = 0;
        windCountTree = 0;
        RANDOM_RUSTLE = null;
        randomRustleTime = 0.0f;
        randomRustleTotalTime = 0.0f;
        randomRustleTarget = 0;
    }

    public boolean update() {
        this.curTime += 1.0f * GameTime.getInstance().getMultiplier();
        this.totalTime += 1.0f * GameTime.getInstance().getMultiplier();
        if (this.curTime > this.maxTime) {
            if (this.finish) {
                return false;
            }
            this.curTime = 0.0f;
            this.swapTargetToLast();
            float f = ClimateManager.clamp01(this.totalTime / this.totalMaxTime);
            float f2 = 1.0f - f;
            switch (this.type) {
                case Hit_Tree_Shudder: {
                    double d;
                    if (this.totalTime > this.totalMaxTime) {
                        this.maxTime = 10.0f * T_MOD;
                        this.tx1 = 0.0;
                        this.tx2 = 0.0;
                        this.finish = true;
                        break;
                    }
                    this.maxTime = (3.0f + 15.0f * f) * T_MOD;
                    this.tx1 = d = this.isBig ? (double)Rand.Next(-0.01f + -0.08f * f2, 0.01f + 0.08f * f2) : (double)Rand.Next(-0.02f + -0.16f * f2, 0.02f + 0.16f * f2);
                    this.tx2 = d;
                    break;
                }
                case Vegetation_Rustle: {
                    double d;
                    if (this.totalTime > this.totalMaxTime) {
                        this.maxTime = 3.0f * T_MOD;
                        this.tx1 = 0.0;
                        this.tx2 = 0.0;
                        this.finish = true;
                        break;
                    }
                    this.maxTime = (2.0f + 6.0f * f) * T_MOD;
                    double d2 = this.isBig ? (double)Rand.Next(-0.00625f, 0.00625f) : (double)Rand.Next(-0.015f, 0.015f);
                    double d3 = d = this.isBig ? (double)Rand.Next(-0.00625f, 0.00625f) : (double)Rand.Next(-0.015f, 0.015f);
                    if (ClimateManager.getWindTickFinal() < 0.15) {
                        d2 *= 0.6;
                        d *= 0.6;
                    }
                    this.tx1 = d2;
                    this.ty1 = d;
                    this.tx2 = d2;
                    this.ty2 = d;
                    break;
                }
                case Hit_Door: {
                    if (this.totalTime > this.totalMaxTime) {
                        this.maxTime = 3.0f * T_MOD;
                        this.tx1 = 0.0;
                        this.tx2 = 0.0;
                        this.finish = true;
                        break;
                    }
                    this.maxTime = (1.0f + 2.0f * f) * T_MOD;
                    double d = Rand.Next(-0.005f, 0.005f);
                    double d4 = Rand.Next(-0.0075f, 0.0075f);
                    this.tx1 = d;
                    this.ty1 = d4;
                    this.tx2 = d;
                    this.ty2 = d4;
                    this.tx3 = d;
                    this.ty3 = d4;
                    this.tx4 = d;
                    this.ty4 = d4;
                    break;
                }
                default: {
                    this.finish = true;
                }
            }
        }
        this.lerpAll(this.curTime / this.maxTime);
        if (this.parent != null && this.parent.getWindRenderEffects() != null && Core.getInstance().getOptionDoWindSpriteEffects()) {
            this.add(this.parent.getWindRenderEffects());
        }
        return true;
    }

    private void update(float f, float f2) {
        this.curTime += 1.0f * GameTime.getInstance().getMultiplier();
        if (this.curTime >= this.maxTime) {
            this.swapTargetToLast();
            if (this.isTree) {
                double d;
                float f3 = 0.0f;
                float f4 = 0.04f;
                if (this.windType == 1) {
                    f3 = 0.6f;
                    f = f <= 0.08f ? 0.0f : (f - 0.08f) / 0.92f;
                } else if (this.windType == 2) {
                    f3 = 0.3f;
                    f4 = 0.06f;
                    f = f <= 0.15f ? 0.0f : (f - 0.15f) / 0.85f;
                } else if (this.windType == 3) {
                    f3 = 0.15f;
                    f = f <= 0.3f ? 0.0f : (f - 0.3f) / 0.7f;
                }
                float f5 = ClimateManager.clamp01(1.0f - f);
                this.curTime = 0.0f;
                this.maxTime = Rand.Next(20.0f + 100.0f * f5, 70.0f + 200.0f * f5) * T_MOD;
                if (f <= 0.01f || !Core.OptionDoWindSpriteEffects) {
                    this.tx1 = 0.0;
                    this.tx2 = 0.0;
                    this.ty1 = 0.0;
                    this.ty2 = 0.0;
                    return;
                }
                float f6 = 0.6f * f + 0.4f * (f * f);
                if (this.gust) {
                    d = Rand.Next(-0.1f + 0.6f * f, 1.0f) * f2;
                    if (Rand.Next(0.0f, 1.0f) > Rand.Next(0.0f, 0.75f * f)) {
                        this.gust = false;
                    }
                } else {
                    d = Rand.Next(-0.1f, 0.2f) * f2;
                    this.gust = true;
                }
                this.tx1 = d *= (double)(f3 * f6);
                this.tx2 = d;
                double d2 = Rand.Next(-1.0f, 1.0f);
                this.ty1 = d2 *= 0.01 + (double)(f4 * f6);
                d2 = Rand.Next(-1.0f, 1.0f);
                this.ty2 = d2 *= 0.01 + (double)(f4 * f6);
            } else {
                double d;
                float f7 = 0.0f;
                if (this.windType == 1) {
                    f7 = 0.575f;
                    f = f <= 0.02f ? 0.0f : (f - 0.02f) / 0.98f;
                } else if (this.windType == 2) {
                    f7 = 0.375f;
                    f = f <= 0.2f ? 0.0f : (f - 0.2f) / 0.8f;
                } else if (this.windType == 3) {
                    f7 = 0.175f;
                    f = f <= 0.6f ? 0.0f : (f - 0.6f) / 0.4f;
                }
                float f8 = ClimateManager.clamp01(1.0f - f);
                this.curTime = 0.0f;
                this.maxTime = Rand.Next(20.0f + 50.0f * f8, 60.0f + 100.0f * f8) * T_MOD;
                if (f <= 0.05f || !Core.OptionDoWindSpriteEffects) {
                    this.tx1 = 0.0;
                    this.tx2 = 0.0;
                    this.ty1 = 0.0;
                    this.ty2 = 0.0;
                    return;
                }
                float f9 = 0.55f * f + 0.45f * (f * f);
                if (this.gust) {
                    d = Rand.Next(-0.1f + 0.9f * f, 1.0f) * f2;
                    if (Rand.Next(0.0f, 1.0f) > Rand.Next(0.0f, 0.95f * f)) {
                        this.gust = false;
                    }
                } else {
                    d = Rand.Next(-0.1f, 0.2f) * f2;
                    this.gust = true;
                }
                this.tx1 = d *= (double)(0.025f + f7 * f9);
                this.tx2 = d;
                if (f > 0.5f) {
                    double d3 = Rand.Next(-1.0f, 1.0f);
                    this.ty1 = d3 *= (double)(0.05f * f9);
                    d3 = Rand.Next(-1.0f, 1.0f);
                    this.ty2 = d3 *= (double)(0.05f * f9);
                } else {
                    this.ty1 = 0.0;
                    this.ty2 = 0.0;
                }
            }
        } else {
            this.lerpAll(this.curTime / this.maxTime);
        }
    }

    private void updateOLD(float f, float f2) {
        this.curTime += 1.0f * GameTime.getInstance().getMultiplier();
        if (this.curTime >= this.maxTime) {
            this.curTime = 0.0f;
            float f3 = ClimateManager.clamp01(1.0f - f);
            this.maxTime = Rand.Next(20.0f + 100.0f * f3, 70.0f + 200.0f * f3) * T_MOD;
            this.swapTargetToLast();
            float f4 = f;
            f = ClimateManager.clamp01(f * 1.25f);
            double d = Rand.Next(-0.65f, 0.65f);
            d += (double)(f4 * f2 * 0.7f);
            this.tx1 = d *= (double)(0.4f * f);
            this.tx2 = d;
            double d2 = Rand.Next(-1.0f, 1.0f);
            this.ty1 = d2 *= (double)(0.05f * f);
            d2 = Rand.Next(-1.0f, 1.0f);
            this.ty2 = d2 *= (double)(0.05f * f);
        } else {
            this.lerpAll(this.curTime / this.maxTime);
        }
    }

    private void lerpAll(float f) {
        this.x1 = ClimateManager.clerp(f, (float)this.lx1, (float)this.tx1);
        this.y1 = ClimateManager.clerp(f, (float)this.ly1, (float)this.ty1);
        this.x2 = ClimateManager.clerp(f, (float)this.lx2, (float)this.tx2);
        this.y2 = ClimateManager.clerp(f, (float)this.ly2, (float)this.ty2);
        this.x3 = ClimateManager.clerp(f, (float)this.lx3, (float)this.tx3);
        this.y3 = ClimateManager.clerp(f, (float)this.ly3, (float)this.ty3);
        this.x4 = ClimateManager.clerp(f, (float)this.lx4, (float)this.tx4);
        this.y4 = ClimateManager.clerp(f, (float)this.ly4, (float)this.ty4);
    }

    private void swapTargetToLast() {
        this.lx1 = this.tx1;
        this.ly1 = this.ty1;
        this.lx2 = this.tx2;
        this.ly2 = this.ty2;
        this.lx3 = this.tx3;
        this.ly3 = this.ty3;
        this.lx4 = this.tx4;
        this.ly4 = this.ty4;
    }

    public void copyMainFromOther(ObjectRenderEffects objectRenderEffects) {
        this.x1 = objectRenderEffects.x1;
        this.y1 = objectRenderEffects.y1;
        this.x2 = objectRenderEffects.x2;
        this.y2 = objectRenderEffects.y2;
        this.x3 = objectRenderEffects.x3;
        this.y3 = objectRenderEffects.y3;
        this.x4 = objectRenderEffects.x4;
        this.y4 = objectRenderEffects.y4;
    }

    public void add(ObjectRenderEffects objectRenderEffects) {
        this.x1 += objectRenderEffects.x1;
        this.y1 += objectRenderEffects.y1;
        this.x2 += objectRenderEffects.x2;
        this.y2 += objectRenderEffects.y2;
        this.x3 += objectRenderEffects.x3;
        this.y3 += objectRenderEffects.y3;
        this.x4 += objectRenderEffects.x4;
        this.y4 += objectRenderEffects.y4;
    }

    public static void updateStatic() {
        if (GameServer.bServer) {
            return;
        }
        try {
            int n;
            float f = (float)ClimateManager.getWindTickFinal();
            float f2 = ClimateManager.getInstance().getWindAngleIntensity();
            f2 = f2 < 0.0f ? -1.0f : 1.0f;
            for (n = 0; n < 3; ++n) {
                ObjectRenderEffects objectRenderEffects;
                int n2;
                for (n2 = 0; n2 < 15; ++n2) {
                    objectRenderEffects = WIND_EFFECTS[n][n2];
                    objectRenderEffects.update(f, f2);
                }
                for (n2 = 0; n2 < 15; ++n2) {
                    objectRenderEffects = WIND_EFFECTS_TREES[n][n2];
                    objectRenderEffects.update(f, f2);
                }
            }
            if ((randomRustleTime += 1.0f * GameTime.getInstance().getMultiplier()) > randomRustleTotalTime && RANDOM_RUSTLE == null) {
                float f3 = 1.0f - f;
                RANDOM_RUSTLE = ObjectRenderEffects.getNew(null, RenderEffectType.Vegetation_Rustle, false, true);
                ObjectRenderEffects.RANDOM_RUSTLE.isBig = false;
                if (f > 0.45f && Rand.Next(0.0f, 1.0f) < Rand.Next(0.0f, 0.8f * f)) {
                    ObjectRenderEffects.RANDOM_RUSTLE.isBig = true;
                }
                randomRustleType = Rand.Next(3);
                randomRustleTarget = Rand.Next(15);
                randomRustleTime = 0.0f;
                randomRustleTotalTime = Rand.Next(400.0f + 400.0f * f3, 1200.0f + 3200.0f * f3);
            }
            if (RANDOM_RUSTLE != null) {
                if (!RANDOM_RUSTLE.update()) {
                    ObjectRenderEffects.release(RANDOM_RUSTLE);
                    RANDOM_RUSTLE = null;
                } else {
                    ObjectRenderEffects objectRenderEffects = WIND_EFFECTS_TREES[randomRustleType][randomRustleTarget];
                    objectRenderEffects.add(RANDOM_RUSTLE);
                }
            }
            for (n = DYNAMIC_EFFECTS.size() - 1; n >= 0; --n) {
                ObjectRenderEffects objectRenderEffects = DYNAMIC_EFFECTS.get(n);
                if (objectRenderEffects.update()) continue;
                if (objectRenderEffects.parent != null) {
                    objectRenderEffects.parent.removeRenderEffect(objectRenderEffects);
                }
                DYNAMIC_EFFECTS.remove(n);
                ObjectRenderEffects.release(objectRenderEffects);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        randomRustleTime = 0.0f;
        randomRustleTotalTime = 0.0f;
        randomRustleTarget = 0;
        randomRustleType = 0;
    }
}

