/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.opengl.Shader;
import zombie.core.skinnedmodel.model.WorldItemModelDrawer;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.debug.DebugOptions;
import zombie.debug.LineDrawer;
import zombie.input.Mouse;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemSoundManager;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.InventoryContainer;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.PlayerCamera;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.ui.ObjectTooltip;
import zombie.util.Type;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;

public class IsoWorldInventoryObject
extends IsoObject {
    public InventoryItem item;
    public float xoff;
    public float yoff;
    public float zoff;
    public boolean removeProcess = false;
    public double dropTime = -1.0;
    public boolean ignoreRemoveSandbox = false;

    public IsoWorldInventoryObject(InventoryItem inventoryItem, IsoGridSquare isoGridSquare, float f, float f2, float f3) {
        this.OutlineOnMouseover = true;
        if (inventoryItem.worldZRotation < 0) {
            inventoryItem.worldZRotation = Rand.Next(0, 360);
        }
        inventoryItem.setContainer(null);
        this.xoff = f;
        this.yoff = f2;
        this.zoff = f3;
        if (this.xoff == 0.0f) {
            this.xoff = (float)Rand.Next(1000) / 1000.0f;
        }
        if (this.yoff == 0.0f) {
            this.yoff = (float)Rand.Next(1000) / 1000.0f;
        }
        this.item = inventoryItem;
        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.updateSprite();
        this.square = isoGridSquare;
        this.offsetY = 0.0f;
        this.offsetX = 0.0f;
        this.dropTime = GameTime.getInstance().getWorldAgeHours();
    }

    public IsoWorldInventoryObject(IsoCell isoCell) {
        super(isoCell);
        this.offsetY = 0.0f;
        this.offsetX = 0.0f;
    }

    public void swapItem(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return;
        }
        if (this.getItem() != null) {
            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this.getItem());
            ItemSoundManager.removeItem(this.getItem());
            this.getItem().setWorldItem(null);
            inventoryItem.setID(this.getItem().getID());
            inventoryItem.worldScale = this.getItem().worldScale;
            inventoryItem.worldZRotation = this.getItem().worldZRotation;
        }
        this.item = inventoryItem;
        if (inventoryItem.getWorldItem() != null) {
            throw new IllegalArgumentException("newItem.getWorldItem() != null");
        }
        this.getItem().setWorldItem(this);
        this.setKeyId(this.getItem().getKeyId());
        this.setName(this.getItem().getName());
        if (this.getItem().shouldUpdateInWorld()) {
            IsoWorld.instance.CurrentCell.addToProcessWorldItems(this);
        }
        IsoWorld.instance.CurrentCell.addToProcessItems(inventoryItem);
        this.updateSprite();
        LuaEventManager.triggerEvent("OnContainerUpdate");
        if (GameServer.bServer) {
            this.sendObjectChange("swapItem");
        }
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("swapItem".equals(string)) {
            if (this.getItem() == null) {
                return;
            }
            try {
                this.getItem().saveWithSize(byteBuffer, false);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        } else {
            super.saveChange(string, kahluaTable, byteBuffer);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("swapItem".equals(string)) {
            try {
                InventoryItem inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
                if (inventoryItem != null) {
                    this.swapItem(inventoryItem);
                }
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        } else {
            super.loadChange(string, byteBuffer);
        }
    }

    private boolean isWaterSource() {
        Item item;
        if (this.item == null) {
            return false;
        }
        if (this.item.isBroken()) {
            // empty if block
        }
        if (!this.item.canStoreWater()) {
            return false;
        }
        if (this.item.isWaterSource() && this.item instanceof DrainableComboItem) {
            return ((DrainableComboItem)this.item).getRainFactor() > 0.0f;
        }
        if (this.item.hasReplaceType("WaterSource") && (item = ScriptManager.instance.getItem(this.item.getReplaceType("WaterSource"))) != null && item.getType() == Item.Type.Drainable) {
            return item.getCanStoreWater() && item.getRainFactor() > 0.0f;
        }
        return false;
    }

    @Override
    public int getWaterAmount() {
        if (this.isWaterSource()) {
            if (this.item instanceof DrainableComboItem) {
                return ((DrainableComboItem)this.item).getRemainingUses();
            }
            return 0;
        }
        return 0;
    }

    @Override
    public void setWaterAmount(int n) {
        if (this.isWaterSource()) {
            InventoryItem inventoryItem;
            DrainableComboItem drainableComboItem = Type.tryCastTo(this.item, DrainableComboItem.class);
            if (drainableComboItem != null) {
                InventoryItem inventoryItem2;
                drainableComboItem.setUsedDelta((float)n * drainableComboItem.getUseDelta());
                if (n == 0 && drainableComboItem.getReplaceOnDeplete() != null && (inventoryItem2 = InventoryItemFactory.CreateItem(drainableComboItem.getReplaceOnDepleteFullType())) != null) {
                    inventoryItem2.setCondition(this.getItem().getCondition());
                    inventoryItem2.setFavorite(this.getItem().isFavorite());
                    this.swapItem(inventoryItem2);
                }
            } else if (n > 0 && this.getItem().hasReplaceType("WaterSource") && (inventoryItem = InventoryItemFactory.CreateItem(this.getItem().getReplaceType("WaterSource"))) != null) {
                inventoryItem.setCondition(this.getItem().getCondition());
                inventoryItem.setFavorite(this.getItem().isFavorite());
                inventoryItem.setTaintedWater(this.getItem().isTaintedWater());
                drainableComboItem = Type.tryCastTo(inventoryItem, DrainableComboItem.class);
                if (drainableComboItem != null) {
                    drainableComboItem.setUsedDelta((float)n * drainableComboItem.getUseDelta());
                }
                this.swapItem(inventoryItem);
            }
        }
    }

    @Override
    public int getWaterMax() {
        if (this.isWaterSource()) {
            float f;
            if (this.item instanceof DrainableComboItem) {
                f = 1.0f / ((DrainableComboItem)this.item).getUseDelta();
            } else if (this.getItem().hasReplaceType("WaterSource")) {
                Item item = ScriptManager.instance.getItem(this.getItem().getReplaceType("WaterSource"));
                if (item == null) {
                    return 0;
                }
                f = 1.0f / item.getUseDelta();
            } else {
                return 0;
            }
            if (f - (float)((int)f) > 0.99f) {
                return (int)f + 1;
            }
            return (int)f;
        }
        return 0;
    }

    @Override
    public boolean isTaintedWater() {
        if (this.isWaterSource()) {
            return this.getItem().isTaintedWater();
        }
        return false;
    }

    @Override
    public void setTaintedWater(boolean bl) {
        if (this.isWaterSource()) {
            this.getItem().setTaintedWater(bl);
        }
    }

    @Override
    public void update() {
        IsoCell isoCell = IsoWorld.instance.getCell();
        if (!this.removeProcess && this.item != null && this.item.shouldUpdateInWorld()) {
            isoCell.addToProcessItems(this.item);
        }
    }

    public void updateSprite() {
        Texture texture;
        this.sprite.setTintMod(new ColorInfo(this.item.col.r, this.item.col.g, this.item.col.b, this.item.col.a));
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return;
        }
        String string = this.item.getTex().getName();
        if (this.item.isUseWorldItem()) {
            string = this.item.getWorldTexture();
        }
        try {
            texture = Texture.getSharedTexture(string);
            if (texture == null) {
                string = this.item.getTex().getName();
            }
        }
        catch (Exception exception) {
            string = "media/inventory/world/WItem_Sack.png";
        }
        texture = this.sprite.LoadFrameExplicit(string);
        if (this.item.getScriptItem() == null) {
            this.sprite.def.scaleAspect(texture.getWidthOrig(), texture.getHeightOrig(), 16 * Core.TileScale, 16 * Core.TileScale);
        } else {
            float f = this.item.getScriptItem().ScaleWorldIcon * ((float)Core.TileScale / 2.0f);
            this.sprite.def.setScale(f, f);
        }
    }

    public boolean finishupdate() {
        return this.removeProcess || this.item == null || !this.item.shouldUpdateInWorld();
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        Texture texture;
        Object object;
        this.xoff = byteBuffer.getFloat();
        this.yoff = byteBuffer.getFloat();
        this.zoff = byteBuffer.getFloat();
        float f = byteBuffer.getFloat();
        float f2 = byteBuffer.getFloat();
        this.sprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.item = InventoryItem.loadItem(byteBuffer, n);
        if (this.item == null) {
            byteBuffer.getDouble();
            if (n >= 193) {
                BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
                bitHeaderRead.release();
            }
            return;
        }
        this.item.setWorldItem(this);
        this.sprite.getTintMod().r = this.item.getR();
        this.sprite.getTintMod().g = this.item.getG();
        this.sprite.getTintMod().b = this.item.getB();
        this.dropTime = n >= 108 ? byteBuffer.getDouble() : GameTime.getInstance().getWorldAgeHours();
        if (n >= 193) {
            object = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
            this.ignoreRemoveSandbox = object.hasFlags(1);
            object.release();
        }
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return;
        }
        object = this.item.getTex().getName();
        if (this.item.isUseWorldItem()) {
            object = this.item.getWorldTexture();
        }
        try {
            texture = Texture.getSharedTexture((String)object);
            if (texture == null) {
                object = this.item.getTex().getName();
            }
        }
        catch (Exception exception) {
            object = "media/inventory/world/WItem_Sack.png";
        }
        texture = this.sprite.LoadFrameExplicit((String)object);
        if (texture == null) {
            return;
        }
        if (n < 33) {
            f -= (float)(texture.getWidthOrig() / 2);
            f2 -= (float)texture.getHeightOrig();
        }
        if (this.item.getScriptItem() == null) {
            this.sprite.def.scaleAspect(texture.getWidthOrig(), texture.getHeightOrig(), 16 * Core.TileScale, 16 * Core.TileScale);
        } else {
            float f3 = this.item.getScriptItem().ScaleWorldIcon * ((float)Core.TileScale / 2.0f);
            this.sprite.def.setScale(f3, f3);
        }
    }

    @Override
    public boolean Serialize() {
        return true;
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byteBuffer.put(this.Serialize() ? (byte)1 : 0);
        if (!this.Serialize()) {
            return;
        }
        byteBuffer.put(IsoObject.factoryGetClassID(this.getObjectName()));
        byteBuffer.putFloat(this.xoff);
        byteBuffer.putFloat(this.yoff);
        byteBuffer.putFloat(this.zoff);
        byteBuffer.putFloat(this.offsetX);
        byteBuffer.putFloat(this.offsetY);
        this.item.saveWithSize(byteBuffer, false);
        byteBuffer.putDouble(this.dropTime);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        if (this.ignoreRemoveSandbox) {
            bitHeaderWrite.addFlags(1);
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
    }

    @Override
    public void softReset() {
        this.square.removeWorldObject(this);
    }

    @Override
    public String getObjectName() {
        return "WorldInventoryItem";
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip) {
        this.item.DoTooltip(objectTooltip);
    }

    @Override
    public boolean HasTooltip() {
        return false;
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        return false;
    }

    private void debugDrawLocation(float f, float f2, float f3) {
        if (Core.bDebug && DebugOptions.instance.ModelRenderAxis.getValue()) {
            LineDrawer.DrawIsoLine((f += this.xoff) - 0.25f, f2 += this.yoff, f3 += this.zoff, f + 0.25f, f2, f3, 1.0f, 1.0f, 1.0f, 0.5f, 1);
            LineDrawer.DrawIsoLine(f, f2 - 0.25f, f3, f, f2 + 0.25f, f3, 1.0f, 1.0f, 1.0f, 0.5f, 1);
        }
    }

    private void debugHitTest() {
        int n;
        float f;
        int n2 = IsoCamera.frameState.playerIndex;
        float f2 = Core.getInstance().getZoom(n2);
        float f3 = Mouse.getXA();
        float f4 = Mouse.getYA();
        f3 -= (float)IsoCamera.getScreenLeft(n2);
        f4 -= (float)IsoCamera.getScreenTop(n2);
        f3 *= f2;
        f4 *= f2;
        float f5 = this.getScreenPosX(n2) * f2;
        float f6 = IsoUtils.DistanceTo2D(f5, f = this.getScreenPosY(n2) * f2, f3, f4);
        if (f6 < (float)(n = 48)) {
            LineDrawer.drawCircle(f5, f, n, 16, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (Core.bDebug) {
            // empty if block
        }
        if (!this.getItem().getScriptItem().isWorldRender().booleanValue()) {
            return;
        }
        if (WorldItemModelDrawer.renderMain(this.getItem(), this.getSquare(), this.getX() + this.xoff, this.getY() + this.yoff, this.getZ() + this.zoff, 0.0f)) {
            this.debugDrawLocation(f, f2, f3);
            return;
        }
        if (this.sprite.CurrentAnim == null || this.sprite.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        Texture texture = this.sprite.CurrentAnim.Frames.get(0).getTexture(this.dir);
        if (texture == null) {
            return;
        }
        float f4 = (float)texture.getWidthOrig() * this.sprite.def.getScaleX() / 2.0f;
        float f5 = (float)texture.getHeightOrig() * this.sprite.def.getScaleY() * 3.0f / 4.0f;
        int n = IsoCamera.frameState.playerIndex;
        float f6 = this.getAlpha(n);
        float f7 = this.getTargetAlpha(n);
        float f8 = PZMath.min(IsoWorldInventoryObject.getSurfaceAlpha(this.square, this.zoff), f6);
        this.setAlphaAndTarget(n, f8);
        this.sprite.render(this, f + this.xoff, f2 + this.yoff, f3 + this.zoff, this.dir, this.offsetX + f4, this.offsetY + f5, colorInfo, true);
        this.setAlpha(n, f6);
        this.setTargetAlpha(n, f7);
        this.debugDrawLocation(f, f2, f3);
    }

    @Override
    public void renderObjectPicker(float f, float f2, float f3, ColorInfo colorInfo) {
        if (this.sprite == null) {
            return;
        }
        if (this.sprite.CurrentAnim == null || this.sprite.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        Texture texture = this.sprite.CurrentAnim.Frames.get(0).getTexture(this.dir);
        if (texture == null) {
            return;
        }
        float f4 = texture.getWidthOrig() / 2;
        float f5 = texture.getHeightOrig();
        this.sprite.renderObjectPicker(this.sprite.def, this, this.dir);
    }

    public InventoryItem getItem() {
        return this.item;
    }

    @Override
    public void addToWorld() {
        ItemContainer itemContainer;
        if (this.item != null && this.item.shouldUpdateInWorld() && !IsoWorld.instance.CurrentCell.getProcessWorldItems().contains(this)) {
            IsoWorld.instance.CurrentCell.getProcessWorldItems().add(this);
        }
        if (this.item instanceof InventoryContainer && (itemContainer = ((InventoryContainer)this.item).getInventory()) != null) {
            itemContainer.addItemsToProcessItems();
        }
        super.addToWorld();
    }

    @Override
    public void removeFromWorld() {
        ItemContainer itemContainer;
        this.removeProcess = true;
        IsoWorld.instance.getCell().getProcessWorldItems().remove(this);
        if (this.item != null) {
            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this.item);
            ItemSoundManager.removeItem(this.item);
            this.item.atlasTexture = null;
        }
        if (this.item instanceof InventoryContainer && (itemContainer = ((InventoryContainer)this.item).getInventory()) != null) {
            itemContainer.removeItemsFromProcessItems();
        }
        super.removeFromWorld();
    }

    @Override
    public void removeFromSquare() {
        if (this.square != null) {
            this.square.getWorldObjects().remove(this);
            this.square.chunk.recalcHashCodeObjects();
        }
        super.removeFromSquare();
    }

    public float getScreenPosX(int n) {
        float f = IsoUtils.XToScreen(this.getX() + this.xoff, this.getY() + this.yoff, this.getZ() + this.zoff, 0);
        PlayerCamera playerCamera = IsoCamera.cameras[n];
        return (f - playerCamera.getOffX()) / Core.getInstance().getZoom(n);
    }

    public float getScreenPosY(int n) {
        Texture texture = this.sprite == null ? null : this.sprite.getTextureForCurrentFrame(this.dir);
        float f = texture == null ? 0.0f : (float)texture.getHeightOrig() * this.sprite.def.getScaleY() * 1.0f / 4.0f;
        float f2 = IsoUtils.YToScreen(this.getX() + this.xoff, this.getY() + this.yoff, this.getZ() + this.zoff, 0);
        PlayerCamera playerCamera = IsoCamera.cameras[n];
        return (f2 - playerCamera.getOffY() - f) / Core.getInstance().getZoom(n);
    }

    public void setIgnoreRemoveSandbox(boolean bl) {
        this.ignoreRemoveSandbox = bl;
    }

    public boolean isIgnoreRemoveSandbox() {
        return this.ignoreRemoveSandbox;
    }

    public float getWorldPosX() {
        return this.getX() + this.xoff;
    }

    public float getWorldPosY() {
        return this.getY() + this.yoff;
    }

    public float getWorldPosZ() {
        return this.getZ() + this.zoff;
    }

    public static float getSurfaceAlpha(IsoGridSquare isoGridSquare, float f) {
        if (isoGridSquare == null) {
            return 1.0f;
        }
        int n = IsoCamera.frameState.playerIndex;
        float f2 = 1.0f;
        if (f > 0.01f) {
            boolean bl = false;
            for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
                IsoObject isoObject = isoGridSquare.getObjects().get(i);
                if (!(isoObject.getSurfaceOffsetNoTable() > 0.0f)) continue;
                if (!bl) {
                    bl = true;
                    f2 = 0.0f;
                }
                f2 = PZMath.max(f2, isoObject.getAlpha(n));
            }
        }
        return f2;
    }
}

