/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.AmbientStreamManager;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.WorldSoundManager;
import zombie.ai.states.ThumpState;
import zombie.audio.parameters.ParameterMeleeHitSurface;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoLivingCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.Shader;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.core.textures.ColorInfo;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.areas.IsoRoom;
import zombie.iso.areas.SafeHouse;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerOptions;
import zombie.util.Type;
import zombie.vehicles.PolygonalMap2;

public class IsoWindow
extends IsoObject
implements BarricadeAble,
Thumpable {
    public int Health = 75;
    public int MaxHealth = 75;
    public WindowType type = WindowType.SinglePane;
    IsoSprite closedSprite;
    IsoSprite smashedSprite;
    public boolean north = false;
    public boolean Locked = false;
    public boolean PermaLocked = false;
    public boolean open = false;
    IsoSprite openSprite;
    private boolean destroyed = false;
    private boolean glassRemoved = false;
    private IsoSprite glassRemovedSprite;
    public int OldNumPlanks;

    public IsoCurtain HasCurtains() {
        IsoCurtain isoCurtain;
        IsoGridSquare isoGridSquare = this.getOppositeSquare();
        if (isoGridSquare != null && (isoCurtain = isoGridSquare.getCurtain(this.getNorth() ? IsoObjectType.curtainS : IsoObjectType.curtainE)) != null) {
            return isoCurtain;
        }
        return this.getSquare().getCurtain(this.getNorth() ? IsoObjectType.curtainN : IsoObjectType.curtainW);
    }

    public IsoGridSquare getIndoorSquare() {
        if (this.square.getRoom() != null) {
            return this.square;
        }
        if (this.north) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ());
            if (isoGridSquare != null && isoGridSquare.getRoom() != null) {
                return isoGridSquare;
            }
        } else {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ());
            if (isoGridSquare != null && isoGridSquare.getRoom() != null) {
                return isoGridSquare;
            }
        }
        return null;
    }

    public IsoGridSquare getAddSheetSquare(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.getCurrentSquare() == null) {
            return null;
        }
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        IsoGridSquare isoGridSquare2 = this.getSquare();
        if (this.north) {
            if (isoGridSquare.getY() < isoGridSquare2.getY()) {
                return this.getCell().getGridSquare(isoGridSquare2.x, isoGridSquare2.y - 1, isoGridSquare2.z);
            }
            return isoGridSquare2;
        }
        if (isoGridSquare.getX() < isoGridSquare2.getX()) {
            return this.getCell().getGridSquare(isoGridSquare2.x - 1, isoGridSquare2.y, isoGridSquare2.z);
        }
        return isoGridSquare2;
    }

    @Override
    public void AttackObject(IsoGameCharacter isoGameCharacter) {
        super.AttackObject(isoGameCharacter);
        IsoObject isoObject = this.square.getWall(this.north);
        if (isoObject != null) {
            isoObject.AttackObject(isoGameCharacter);
        }
    }

    public IsoGridSquare getInsideSquare() {
        if (this.square == null) {
            return null;
        }
        if (this.north) {
            return this.getCell().getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ());
        }
        return this.getCell().getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ());
    }

    @Override
    public IsoGridSquare getOppositeSquare() {
        return this.getInsideSquare();
    }

    public boolean isExterior() {
        IsoGridSquare isoGridSquare = this.getSquare();
        IsoGridSquare isoGridSquare2 = this.getOppositeSquare();
        if (isoGridSquare2 == null) {
            return false;
        }
        return isoGridSquare.isInARoom() != isoGridSquare2.isInARoom();
    }

    public IsoWindow(IsoCell isoCell) {
        super(isoCell);
    }

    @Override
    public String getObjectName() {
        return "Window";
    }

    @Override
    public void WeaponHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (GameClient.bClient) {
            if (isoPlayer != null) {
                GameClient.instance.sendWeaponHit(isoPlayer, handWeapon, this);
            }
            return;
        }
        Thumpable thumpable = this.getThumpableFor(isoGameCharacter);
        if (thumpable == null) {
            return;
        }
        if (thumpable instanceof IsoBarricade) {
            ((IsoBarricade)thumpable).WeaponHit(isoGameCharacter, handWeapon);
            return;
        }
        LuaEventManager.triggerEvent("OnWeaponHitThumpable", isoGameCharacter, handWeapon, this);
        if (handWeapon == ((IsoLivingCharacter)isoGameCharacter).bareHands) {
            if (isoPlayer != null) {
                isoPlayer.setMeleeHitSurface(ParameterMeleeHitSurface.Material.Glass);
                isoPlayer.getEmitter().playSound(handWeapon.getDoorHitSound(), this);
            }
            return;
        }
        if (handWeapon != null) {
            this.Damage((float)(handWeapon.getDoorDamage() * 5), isoGameCharacter);
        } else {
            this.Damage(100.0f, isoGameCharacter);
        }
        this.DirtySlice();
        if (handWeapon != null && handWeapon.getDoorHitSound() != null) {
            if (isoPlayer != null) {
                isoPlayer.setMeleeHitSurface(ParameterMeleeHitSurface.Material.Glass);
            }
            isoGameCharacter.getEmitter().playSound(handWeapon.getDoorHitSound(), this);
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer(isoGameCharacter, handWeapon.getDoorHitSound(), false, this.getSquare(), 1.0f, 20.0f, 2.0f, false);
            }
        }
        WorldSoundManager.instance.addSound(isoGameCharacter, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, false, 0.0f, 15.0f);
        if (!this.isDestroyed() && this.Health <= 0) {
            this.smashWindow();
            this.addBrokenGlass(isoGameCharacter);
        }
    }

    public void smashWindow(boolean bl, boolean bl2) {
        if (this.destroyed) {
            return;
        }
        if (GameClient.bClient && !bl) {
            GameClient.instance.smashWindow(this, 1);
        }
        if (!bl) {
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer("SmashWindow", false, this.square, 0.2f, 20.0f, 1.1f, true);
            } else {
                SoundManager.instance.PlayWorldSound("SmashWindow", this.square, 0.2f, 20.0f, 1.0f, true);
            }
            WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 10, 20, true, 4.0f, 15.0f);
        }
        this.destroyed = true;
        this.sprite = this.smashedSprite;
        if (this.getAttachedAnimSprite() != null) {
            this.getSquare().removeBlood(false, true);
            System.out.println(this.wallBloodSplats);
            for (int i = 0; i < this.getAttachedAnimSprite().size(); ++i) {
                IsoSprite isoSprite = this.getAttachedAnimSprite().get((int)i).parentSprite;
                if (isoSprite == null || !isoSprite.getProperties().Is("AttachedToGlass")) continue;
                this.getAttachedAnimSprite().remove(i);
                --i;
            }
        }
        this.getSquare().removeLightSwitch();
        if (bl2) {
            this.handleAlarm();
        }
        if (GameServer.bServer && !bl) {
            GameServer.smashWindow(this, 1);
        }
        this.square.InvalidateSpecialObjectPaths();
    }

    public void smashWindow(boolean bl) {
        this.smashWindow(bl, true);
    }

    public void smashWindow() {
        this.smashWindow(false, true);
    }

    public void addBrokenGlass(IsoMovingObject isoMovingObject) {
        if (isoMovingObject == null) {
            return;
        }
        if (this.getSquare() == null) {
            return;
        }
        if (this.getNorth()) {
            this.addBrokenGlass(isoMovingObject.getY() >= (float)this.getSquare().getY());
        } else {
            this.addBrokenGlass(isoMovingObject.getX() >= (float)this.getSquare().getX());
        }
    }

    public void addBrokenGlass(boolean bl) {
        IsoGridSquare isoGridSquare;
        IsoGridSquare isoGridSquare2 = isoGridSquare = bl ? this.getOppositeSquare() : this.getSquare();
        if (isoGridSquare != null) {
            isoGridSquare.addBrokenGlass();
        }
    }

    private void handleAlarm() {
        if (GameClient.bClient) {
            return;
        }
        IsoGridSquare isoGridSquare = this.getIndoorSquare();
        if (isoGridSquare == null) {
            return;
        }
        IsoRoom isoRoom = isoGridSquare.getRoom();
        RoomDef roomDef = isoRoom.def;
        if (roomDef.building.bAlarmed && !GameClient.bClient) {
            AmbientStreamManager.instance.doAlarm(roomDef);
        }
    }

    public IsoWindow(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite, boolean bl) {
        isoSprite.getProperties().UnSet(IsoFlagType.cutN);
        isoSprite.getProperties().UnSet(IsoFlagType.cutW);
        int n = 0;
        if (isoSprite.getProperties().Is("OpenTileOffset")) {
            n = Integer.parseInt(isoSprite.getProperties().Val("OpenTileOffset"));
        }
        int n2 = 0;
        this.PermaLocked = isoSprite.getProperties().Is("WindowLocked");
        if (isoSprite.getProperties().Is("SmashedTileOffset")) {
            n2 = Integer.parseInt(isoSprite.getProperties().Val("SmashedTileOffset"));
        }
        this.closedSprite = isoSprite;
        if (bl) {
            this.closedSprite.getProperties().Set(IsoFlagType.cutN);
            this.closedSprite.getProperties().Set(IsoFlagType.windowN);
        } else {
            this.closedSprite.getProperties().Set(IsoFlagType.cutW);
            this.closedSprite.getProperties().Set(IsoFlagType.windowW);
        }
        this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, n);
        this.smashedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, n2);
        if (this.closedSprite.getProperties().Is("GlassRemovedOffset")) {
            int n3 = Integer.parseInt(this.closedSprite.getProperties().Val("GlassRemovedOffset"));
            this.glassRemovedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, this.closedSprite, n3);
        } else {
            this.glassRemovedSprite = this.smashedSprite;
        }
        if (this.smashedSprite != this.closedSprite && this.smashedSprite != null) {
            this.smashedSprite.AddProperties(this.closedSprite);
            this.smashedSprite.setType(this.closedSprite.getType());
        }
        if (this.openSprite != this.closedSprite && this.openSprite != null) {
            this.openSprite.AddProperties(this.closedSprite);
            this.openSprite.setType(this.closedSprite.getType());
        }
        if (this.glassRemovedSprite != this.closedSprite && this.glassRemovedSprite != null) {
            this.glassRemovedSprite.AddProperties(this.closedSprite);
            this.glassRemovedSprite.setType(this.closedSprite.getType());
        }
        this.sprite = this.closedSprite;
        IsoObject isoObject = isoGridSquare.getWall(bl);
        if (isoObject != null) {
            isoObject.rerouteCollide = this;
        }
        this.square = isoGridSquare;
        this.north = bl;
        switch (this.type) {
            case SinglePane: {
                this.Health = 50;
                this.MaxHealth = 50;
                break;
            }
            case DoublePane: {
                this.Health = 150;
                this.MaxHealth = 150;
            }
        }
        int n4 = 69;
        if (SandboxOptions.instance.LockedHouses.getValue() == 1) {
            n4 = -1;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 2) {
            n4 = 5;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 3) {
            n4 = 10;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 4) {
            n4 = 50;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 5) {
            n4 = 60;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 6) {
            n4 = 70;
        }
        if (n4 > -1) {
            this.Locked = Rand.Next(100) < n4;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean IsOpen() {
        return this.open;
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        return false;
    }

    @Override
    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (isoGridSquare == this.square) {
            if (this.north && isoGridSquare2.getY() < isoGridSquare.getY()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
            if (!this.north && isoGridSquare2.getX() < isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
        } else {
            if (this.north && isoGridSquare2.getY() > isoGridSquare.getY()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
            if (!this.north && isoGridSquare2.getX() > isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (isoGridSquare2.getZ() != isoGridSquare.getZ()) {
            return IsoObject.VisionResult.NoEffect;
        }
        if (isoGridSquare == this.square) {
            if (this.north && isoGridSquare2.getY() < isoGridSquare.getY()) {
                return IsoObject.VisionResult.Unblocked;
            }
            if (!this.north && isoGridSquare2.getX() < isoGridSquare.getX()) {
                return IsoObject.VisionResult.Unblocked;
            }
        } else {
            if (this.north && isoGridSquare2.getY() > isoGridSquare.getY()) {
                return IsoObject.VisionResult.Unblocked;
            }
            if (!this.north && isoGridSquare2.getX() > isoGridSquare.getX()) {
                return IsoObject.VisionResult.Unblocked;
            }
        }
        return IsoObject.VisionResult.NoEffect;
    }

    @Override
    public void Thump(IsoMovingObject isoMovingObject) {
        if (isoMovingObject instanceof IsoGameCharacter) {
            Thumpable thumpable = this.getThumpableFor((IsoGameCharacter)isoMovingObject);
            if (thumpable == null) {
                return;
            }
            if (thumpable != this) {
                thumpable.Thump(isoMovingObject);
                return;
            }
        }
        if (isoMovingObject instanceof IsoZombie) {
            if (!(((IsoZombie)isoMovingObject).cognition != 1 || this.canClimbThrough((IsoZombie)isoMovingObject) || this.isInvincible() || this.Locked && (isoMovingObject.getCurrentSquare() == null || isoMovingObject.getCurrentSquare().Is(IsoFlagType.exterior)))) {
                this.ToggleWindow((IsoGameCharacter)isoMovingObject);
                if (this.canClimbThrough((IsoZombie)isoMovingObject)) {
                    return;
                }
            }
            int n = ThumpState.getFastForwardDamageMultiplier();
            this.DirtySlice();
            this.Damage((float)(((IsoZombie)isoMovingObject).strength * n), isoMovingObject);
            WorldSoundManager.instance.addSound(isoMovingObject, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
        }
        if (!this.isDestroyed() && this.Health <= 0) {
            if (this.getSquare().getBuilding() != null) {
                this.getSquare().getBuilding().forceAwake();
            }
            if (GameServer.bServer) {
                GameServer.smashWindow(this, 1);
                GameServer.PlayWorldSoundServer((IsoGameCharacter)isoMovingObject, "SmashWindow", false, isoMovingObject.getCurrentSquare(), 0.2f, 20.0f, 1.1f, true);
            }
            ((IsoGameCharacter)isoMovingObject).getEmitter().playSound("SmashWindow", this);
            WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 10, 20, true, 4.0f, 15.0f);
            isoMovingObject.setThumpTarget(null);
            this.destroyed = true;
            this.sprite = this.smashedSprite;
            this.square.InvalidateSpecialObjectPaths();
            this.addBrokenGlass(isoMovingObject);
            if (isoMovingObject instanceof IsoZombie && this.getThumpableFor((IsoZombie)isoMovingObject) != null) {
                isoMovingObject.setThumpTarget(this.getThumpableFor((IsoZombie)isoMovingObject));
            }
        }
    }

    @Override
    public Thumpable getThumpableFor(IsoGameCharacter isoGameCharacter) {
        IsoBarricade isoBarricade = this.getBarricadeForCharacter(isoGameCharacter);
        if (isoBarricade != null) {
            return isoBarricade;
        }
        if (this.isDestroyed() || this.IsOpen()) {
            isoBarricade = this.getBarricadeOppositeCharacter(isoGameCharacter);
            if (isoBarricade != null) {
                return isoBarricade;
            }
            return null;
        }
        return this;
    }

    @Override
    public float getThumpCondition() {
        return (float)PZMath.clamp(this.Health, 0, this.MaxHealth) / (float)this.MaxHealth;
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        int n2;
        super.load(byteBuffer, n, bl);
        this.open = byteBuffer.get() == 1;
        boolean bl2 = this.north = byteBuffer.get() == 1;
        if (n >= 87) {
            this.Health = byteBuffer.getInt();
        } else {
            n2 = byteBuffer.getInt();
            this.Health = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            if (n >= 49) {
                short s = byteBuffer.getShort();
            } else {
                int n4 = Math.max(n3, n2 * 1000);
            }
            this.OldNumPlanks = n2;
        }
        this.Locked = byteBuffer.get() == 1;
        this.PermaLocked = byteBuffer.get() == 1;
        boolean bl3 = this.destroyed = byteBuffer.get() == 1;
        if (n >= 64) {
            boolean bl4 = this.glassRemoved = byteBuffer.get() == 1;
            if (byteBuffer.get() == 1) {
                this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (byteBuffer.get() == 1) {
                this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (byteBuffer.get() == 1) {
                this.smashedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (byteBuffer.get() == 1) {
                this.glassRemovedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
        } else {
            if (byteBuffer.getInt() == 1) {
                this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (byteBuffer.getInt() == 1) {
                this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (byteBuffer.getInt() == 1) {
                this.smashedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
            }
            if (this.closedSprite != null) {
                if (this.destroyed && this.closedSprite.getProperties().Is("SmashedTileOffset")) {
                    n2 = Integer.parseInt(this.closedSprite.getProperties().Val("SmashedTileOffset"));
                    this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, this.closedSprite, -n2);
                }
                if (this.closedSprite.getProperties().Is("GlassRemovedOffset")) {
                    n2 = Integer.parseInt(this.closedSprite.getProperties().Val("GlassRemovedOffset"));
                    this.glassRemovedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, this.closedSprite, n2);
                }
            }
            if (this.glassRemovedSprite == null) {
                this.glassRemovedSprite = this.smashedSprite != null ? this.smashedSprite : this.closedSprite;
            }
        }
        this.MaxHealth = byteBuffer.getInt();
        if (this.closedSprite != null) {
            if (this.north) {
                this.closedSprite.getProperties().Set(IsoFlagType.cutN);
                this.closedSprite.getProperties().Set(IsoFlagType.windowN);
            } else {
                this.closedSprite.getProperties().Set(IsoFlagType.cutW);
                this.closedSprite.getProperties().Set(IsoFlagType.windowW);
            }
            if (this.smashedSprite != this.closedSprite && this.smashedSprite != null) {
                this.smashedSprite.AddProperties(this.closedSprite);
                this.smashedSprite.setType(this.closedSprite.getType());
            }
            if (this.openSprite != this.closedSprite && this.openSprite != null) {
                this.openSprite.AddProperties(this.closedSprite);
                this.openSprite.setType(this.closedSprite.getType());
            }
            if (this.glassRemovedSprite != this.closedSprite && this.glassRemovedSprite != null) {
                this.glassRemovedSprite.AddProperties(this.closedSprite);
                this.glassRemovedSprite.setType(this.closedSprite.getType());
            }
        }
        if (SystemDisabler.doObjectStateSyncEnable && GameClient.bClient) {
            GameClient.instance.objectSyncReq.putRequestLoad(this.square);
        }
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.getCell().addToWindowList(this);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.getCell().removeFromWindowList(this);
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.open ? (byte)1 : 0);
        byteBuffer.put(this.north ? (byte)1 : 0);
        byteBuffer.putInt(this.Health);
        byteBuffer.put(this.Locked ? (byte)1 : 0);
        byteBuffer.put(this.PermaLocked ? (byte)1 : 0);
        byteBuffer.put(this.destroyed ? (byte)1 : 0);
        byteBuffer.put(this.glassRemoved ? (byte)1 : 0);
        if (this.openSprite != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.openSprite.ID);
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.closedSprite != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.closedSprite.ID);
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.smashedSprite != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.smashedSprite.ID);
        } else {
            byteBuffer.put((byte)0);
        }
        if (this.glassRemovedSprite != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(this.glassRemovedSprite.ID);
        } else {
            byteBuffer.put((byte)0);
        }
        byteBuffer.putInt(this.MaxHealth);
    }

    @Override
    public void saveState(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put((byte)(this.Locked ? 1 : 0));
    }

    @Override
    public void loadState(ByteBuffer byteBuffer) throws IOException {
        boolean bl;
        boolean bl2 = bl = byteBuffer.get() == 1;
        if (bl != this.Locked) {
            this.Locked = bl;
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
    }

    public void openCloseCurtain(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == IsoPlayer.getInstance()) {
            IsoGridSquare isoGridSquare = null;
            IsoGridSquare isoGridSquare2 = null;
            IsoDirections isoDirections = IsoDirections.N;
            if (this.north) {
                var5_5 = this.square;
                isoDirections = IsoDirections.N;
                if (var5_5.getRoom() == null) {
                    var5_5 = this.getCell().getGridSquare(var5_5.getX(), var5_5.getY() - 1, var5_5.getZ());
                    isoDirections = IsoDirections.S;
                }
                isoGridSquare2 = isoGridSquare;
                isoGridSquare = var5_5;
            } else {
                var5_5 = this.square;
                isoDirections = IsoDirections.W;
                if (var5_5.getRoom() == null) {
                    var5_5 = this.getCell().getGridSquare(var5_5.getX() - 1, var5_5.getY(), var5_5.getZ());
                    isoDirections = IsoDirections.E;
                }
                isoGridSquare2 = isoGridSquare;
                isoGridSquare = var5_5;
            }
            if (isoGridSquare != null) {
                for (int i = 0; i < isoGridSquare.getSpecialObjects().size(); ++i) {
                    if (!(isoGridSquare.getSpecialObjects().get(i) instanceof IsoCurtain)) continue;
                    ((IsoCurtain)isoGridSquare.getSpecialObjects().get(i)).ToggleDoorSilent();
                    return;
                }
            }
            if (isoGridSquare2 != null) {
                for (int i = 0; i < isoGridSquare2.getSpecialObjects().size(); ++i) {
                    if (!(isoGridSquare2.getSpecialObjects().get(i) instanceof IsoCurtain)) continue;
                    ((IsoCurtain)isoGridSquare2.getSpecialObjects().get(i)).ToggleDoorSilent();
                    return;
                }
            }
        }
    }

    public void removeSheet(IsoGameCharacter isoGameCharacter) {
        IsoGridSquare isoGridSquare = null;
        IsoDirections isoDirections = IsoDirections.N;
        if (this.north) {
            var4_4 = this.square;
            isoDirections = IsoDirections.N;
            if (var4_4.getRoom() == null) {
                var4_4 = this.getCell().getGridSquare(var4_4.getX(), var4_4.getY() - 1, var4_4.getZ());
                isoDirections = IsoDirections.S;
            }
            isoGridSquare = var4_4;
        } else {
            var4_4 = this.square;
            isoDirections = IsoDirections.W;
            if (var4_4.getRoom() == null) {
                var4_4 = this.getCell().getGridSquare(var4_4.getX() - 1, var4_4.getY(), var4_4.getZ());
                isoDirections = IsoDirections.E;
            }
            isoGridSquare = var4_4;
        }
        for (int i = 0; i < isoGridSquare.getSpecialObjects().size(); ++i) {
            IsoObject isoObject = isoGridSquare.getSpecialObjects().get(i);
            if (!(isoObject instanceof IsoCurtain)) continue;
            isoGridSquare.transmitRemoveItemFromSquare(isoObject);
            if (isoGameCharacter == null) break;
            if (GameServer.bServer) {
                isoGameCharacter.sendObjectChange("addItemOfType", "type", isoObject.getName());
                break;
            }
            isoGameCharacter.getInventory().AddItem(isoObject.getName());
            break;
        }
    }

    public void addSheet(IsoGameCharacter isoGameCharacter) {
        IsoObjectType isoObjectType;
        IsoGridSquare isoGridSquare = null;
        if (this.north) {
            var4_3 = this.square;
            isoObjectType = IsoObjectType.curtainN;
            if (isoGameCharacter != null) {
                if (isoGameCharacter.getY() < this.getY()) {
                    var4_3 = this.getCell().getGridSquare(var4_3.getX(), var4_3.getY() - 1, var4_3.getZ());
                    isoObjectType = IsoObjectType.curtainS;
                }
            } else if (var4_3.getRoom() == null) {
                var4_3 = this.getCell().getGridSquare(var4_3.getX(), var4_3.getY() - 1, var4_3.getZ());
                isoObjectType = IsoObjectType.curtainS;
            }
            isoGridSquare = var4_3;
        } else {
            var4_3 = this.square;
            isoObjectType = IsoObjectType.curtainW;
            if (isoGameCharacter != null) {
                if (isoGameCharacter.getX() < this.getX()) {
                    var4_3 = this.getCell().getGridSquare(var4_3.getX() - 1, var4_3.getY(), var4_3.getZ());
                    isoObjectType = IsoObjectType.curtainE;
                }
            } else if (var4_3.getRoom() == null) {
                var4_3 = this.getCell().getGridSquare(var4_3.getX() - 1, var4_3.getY(), var4_3.getZ());
                isoObjectType = IsoObjectType.curtainE;
            }
            isoGridSquare = var4_3;
        }
        if (isoGridSquare.getCurtain(isoObjectType) != null) {
            return;
        }
        if (isoGridSquare != null) {
            int n = 16;
            if (isoObjectType == IsoObjectType.curtainE) {
                ++n;
            }
            if (isoObjectType == IsoObjectType.curtainS) {
                n += 3;
            }
            if (isoObjectType == IsoObjectType.curtainN) {
                n += 2;
            }
            IsoCurtain isoCurtain = new IsoCurtain(this.getCell(), isoGridSquare, "fixtures_windows_curtains_01_" + (n += 4), this.north);
            isoGridSquare.AddSpecialTileObject(isoCurtain);
            if (!isoCurtain.open) {
                isoCurtain.ToggleDoorSilent();
            }
            if (GameServer.bServer) {
                isoCurtain.transmitCompleteItemToClients();
                if (isoGameCharacter != null) {
                    isoGameCharacter.sendObjectChange("removeOneOf", "type", "Sheet");
                }
            } else if (isoGameCharacter != null) {
                isoGameCharacter.getInventory().RemoveOneOf("Sheet");
            }
            return;
        }
    }

    public void ToggleWindow(IsoGameCharacter isoGameCharacter) {
        this.DirtySlice();
        IsoGridSquare.setRecalcLightTime(-1);
        if (this.PermaLocked) {
            return;
        }
        if (this.destroyed) {
            return;
        }
        if (isoGameCharacter != null && this.getBarricadeForCharacter(isoGameCharacter) != null) {
            return;
        }
        this.Locked = false;
        this.open = !this.open;
        this.sprite = this.closedSprite;
        this.square.InvalidateSpecialObjectPaths();
        if (this.open) {
            if (!(isoGameCharacter instanceof IsoZombie) || SandboxOptions.getInstance().Lore.TriggerHouseAlarm.getValue()) {
                this.handleAlarm();
            }
            this.sprite = this.openSprite;
        }
        this.square.RecalcProperties();
        this.syncIsoObject(false, this.open ? (byte)1 : 0, null, null);
        PolygonalMap2.instance.squareChanged(this.square);
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte(this.open ? (byte)1 : 0);
        byteBufferWriter.putByte(this.destroyed ? (byte)1 : 0);
        byteBufferWriter.putByte(this.Locked ? (byte)1 : 0);
        byteBufferWriter.putByte(this.PermaLocked ? (byte)1 : 0);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        if (this.square == null) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " square is null");
            return;
        }
        if (this.getObjectIndex() == -1) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " not found on square " + this.square.getX() + "," + this.square.getY() + "," + this.square.getZ());
            return;
        }
        if (GameClient.bClient && !bl) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
            this.syncIsoObjectSend(byteBufferWriter);
            PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
        } else if (GameServer.bServer && !bl) {
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                this.syncIsoObjectSend(byteBufferWriter);
                PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
            }
        } else if (bl) {
            boolean bl2;
            boolean bl3 = byteBuffer.get() == 1;
            boolean bl4 = byteBuffer.get() == 1;
            boolean bl5 = bl2 = byteBuffer.get() == 1;
            if (by == 1) {
                this.open = true;
                this.sprite = this.openSprite;
            } else if (by == 0) {
                this.open = false;
                this.sprite = this.closedSprite;
            }
            if (bl3) {
                this.destroyed = true;
                this.sprite = this.smashedSprite;
            }
            this.Locked = bl4;
            this.PermaLocked = bl2;
            if (GameServer.bServer) {
                for (UdpConnection udpConnection3 : GameServer.udpEngine.connections) {
                    if (udpConnection == null || udpConnection3.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection3.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection3);
                }
            }
            this.square.RecalcProperties();
            LuaEventManager.triggerEvent("OnContainerUpdate");
        }
    }

    public static boolean isTopOfSheetRopeHere(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        return isoGridSquare.Is(IsoFlagType.climbSheetTopN) || isoGridSquare.Is(IsoFlagType.climbSheetTopS) || isoGridSquare.Is(IsoFlagType.climbSheetTopW) || isoGridSquare.Is(IsoFlagType.climbSheetTopE);
    }

    public static boolean isTopOfSheetRopeHere(IsoGridSquare isoGridSquare, boolean bl) {
        if (isoGridSquare == null) {
            return false;
        }
        if (bl) {
            if (isoGridSquare.Is(IsoFlagType.climbSheetTopN)) {
                return true;
            }
            if (isoGridSquare.nav[IsoDirections.N.index()] != null && isoGridSquare.nav[IsoDirections.N.index()].Is(IsoFlagType.climbSheetTopS)) {
                return true;
            }
        } else {
            if (isoGridSquare.Is(IsoFlagType.climbSheetTopW)) {
                return true;
            }
            if (isoGridSquare.nav[IsoDirections.W.index()] != null && isoGridSquare.nav[IsoDirections.W.index()].Is(IsoFlagType.climbSheetTopE)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean haveSheetRope() {
        return IsoWindow.isTopOfSheetRopeHere(this.square, this.north);
    }

    public static boolean isSheetRopeHere(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        return isoGridSquare.Is(IsoFlagType.climbSheetTopW) || isoGridSquare.Is(IsoFlagType.climbSheetTopN) || isoGridSquare.Is(IsoFlagType.climbSheetTopE) || isoGridSquare.Is(IsoFlagType.climbSheetTopS) || isoGridSquare.Is(IsoFlagType.climbSheetW) || isoGridSquare.Is(IsoFlagType.climbSheetN) || isoGridSquare.Is(IsoFlagType.climbSheetE) || isoGridSquare.Is(IsoFlagType.climbSheetS);
    }

    public static boolean canClimbHere(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.solid)) {
            return false;
        }
        if (isoGridSquare.Has(IsoObjectType.stairsBN) || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsTN)) {
            return false;
        }
        return !isoGridSquare.Has(IsoObjectType.stairsBW) && !isoGridSquare.Has(IsoObjectType.stairsMW) && !isoGridSquare.Has(IsoObjectType.stairsTW);
    }

    public static int countAddSheetRope(IsoGridSquare isoGridSquare, boolean bl) {
        if (IsoWindow.isTopOfSheetRopeHere(isoGridSquare, bl)) {
            return 0;
        }
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        if (isoGridSquare.TreatAsSolidFloor()) {
            if (bl) {
                var3_3 = isoCell.getOrCreateGridSquare(isoGridSquare.getX(), isoGridSquare.getY() - 1, isoGridSquare.getZ());
                if (var3_3 == null || var3_3.TreatAsSolidFloor() || IsoWindow.isSheetRopeHere(var3_3) || !IsoWindow.canClimbHere(var3_3)) {
                    return 0;
                }
                isoGridSquare = var3_3;
            } else {
                var3_3 = isoCell.getOrCreateGridSquare(isoGridSquare.getX() - 1, isoGridSquare.getY(), isoGridSquare.getZ());
                if (var3_3 == null || var3_3.TreatAsSolidFloor() || IsoWindow.isSheetRopeHere(var3_3) || !IsoWindow.canClimbHere(var3_3)) {
                    return 0;
                }
                isoGridSquare = var3_3;
            }
        }
        int n = 1;
        while (isoGridSquare != null) {
            if (!IsoWindow.canClimbHere(isoGridSquare)) {
                return 0;
            }
            if (isoGridSquare.TreatAsSolidFloor()) {
                return n;
            }
            if (isoGridSquare.getZ() == 0) {
                return n;
            }
            isoGridSquare = isoCell.getOrCreateGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() - 1);
            ++n;
        }
        return 0;
    }

    @Override
    public int countAddSheetRope() {
        return IsoWindow.countAddSheetRope(this.square, this.north);
    }

    public static boolean canAddSheetRope(IsoGridSquare isoGridSquare, boolean bl) {
        return IsoWindow.countAddSheetRope(isoGridSquare, bl) != 0;
    }

    @Override
    public boolean canAddSheetRope() {
        if (!this.canClimbThrough(null)) {
            return false;
        }
        return IsoWindow.canAddSheetRope(this.square, this.north);
    }

    @Override
    public boolean addSheetRope(IsoPlayer isoPlayer, String string) {
        if (!this.canAddSheetRope()) {
            return false;
        }
        return IsoWindow.addSheetRope(isoPlayer, this.square, this.north, string);
    }

    public static boolean addSheetRope(IsoPlayer isoPlayer, IsoGridSquare isoGridSquare, boolean bl, String string) {
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        IsoGridSquare isoGridSquare2 = null;
        IsoGridSquare isoGridSquare3 = null;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        if (isoGridSquare.TreatAsSolidFloor()) {
            if (!bl) {
                isoGridSquare2 = isoCell.getGridSquare(isoGridSquare.getX() - 1, isoGridSquare.getY(), isoGridSquare.getZ());
                if (isoGridSquare2 != null) {
                    bl4 = true;
                    n2 = 3;
                }
            } else {
                isoGridSquare3 = isoCell.getGridSquare(isoGridSquare.getX(), isoGridSquare.getY() - 1, isoGridSquare.getZ());
                if (isoGridSquare3 != null) {
                    bl3 = true;
                    n2 = 4;
                }
            }
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.solidfloor)) {
            // empty if block
        }
        while (isoGridSquare != null && (GameServer.bServer || isoPlayer.getInventory().contains(string))) {
            Object object = "crafted_01_" + n2;
            if (n > 0) {
                object = bl4 ? "crafted_01_10" : (bl3 ? "crafted_01_13" : "crafted_01_" + (n2 + 8));
            }
            IsoObject isoObject = new IsoObject(isoCell, isoGridSquare, (String)object);
            isoObject.setName(string);
            isoObject.sheetRope = true;
            isoGridSquare.getObjects().add(isoObject);
            isoObject.transmitCompleteItemToClients();
            isoGridSquare.haveSheetRope = true;
            if (bl3 && n == 0) {
                isoGridSquare = isoGridSquare3;
                isoObject = new IsoObject(isoCell, isoGridSquare, "crafted_01_5");
                isoObject.setName(string);
                isoObject.sheetRope = true;
                isoGridSquare.getObjects().add(isoObject);
                isoObject.transmitCompleteItemToClients();
            }
            if (bl4 && n == 0) {
                isoGridSquare = isoGridSquare2;
                isoObject = new IsoObject(isoCell, isoGridSquare, "crafted_01_2");
                isoObject.setName(string);
                isoObject.sheetRope = true;
                isoGridSquare.getObjects().add(isoObject);
                isoObject.transmitCompleteItemToClients();
            }
            isoGridSquare.RecalcProperties();
            isoGridSquare.getProperties().UnSet(IsoFlagType.solidtrans);
            if (GameServer.bServer) {
                if (n == 0) {
                    isoPlayer.sendObjectChange("removeOneOf", "type", "Nails");
                }
                isoPlayer.sendObjectChange("removeOneOf", "type", string);
            } else {
                if (n == 0) {
                    isoPlayer.getInventory().RemoveOneOf("Nails");
                }
                isoPlayer.getInventory().RemoveOneOf(string);
            }
            ++n;
            if (bl2) break;
            if ((isoGridSquare = isoCell.getOrCreateGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() - 1)) == null || !isoGridSquare.TreatAsSolidFloor()) continue;
            bl2 = true;
        }
        return true;
    }

    @Override
    public boolean removeSheetRope(IsoPlayer isoPlayer) {
        if (!this.haveSheetRope()) {
            return false;
        }
        return IsoWindow.removeSheetRope(isoPlayer, this.square, this.north);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean removeSheetRope(IsoPlayer isoPlayer, IsoGridSquare isoGridSquare, boolean bl) {
        int n;
        IsoFlagType isoFlagType;
        IsoFlagType isoFlagType2;
        if (isoGridSquare == null) {
            return false;
        }
        IsoGridSquare isoGridSquare2 = isoGridSquare;
        isoGridSquare2.haveSheetRope = false;
        if (bl) {
            if (isoGridSquare.Is(IsoFlagType.climbSheetTopN)) {
                isoFlagType2 = IsoFlagType.climbSheetTopN;
                isoFlagType = IsoFlagType.climbSheetN;
            } else {
                if (isoGridSquare.nav[IsoDirections.N.index()] == null || !isoGridSquare.nav[IsoDirections.N.index()].Is(IsoFlagType.climbSheetTopS)) return false;
                isoFlagType2 = IsoFlagType.climbSheetTopS;
                isoFlagType = IsoFlagType.climbSheetS;
                var5_6 = "crafted_01_4";
                for (n = 0; n < isoGridSquare2.getObjects().size(); ++n) {
                    IsoObject isoObject = isoGridSquare2.getObjects().get(n);
                    if (isoObject.sprite == null || isoObject.sprite.getName() == null || !isoObject.sprite.getName().equals(var5_6)) continue;
                    isoGridSquare2.transmitRemoveItemFromSquare(isoObject);
                    break;
                }
                isoGridSquare2 = isoGridSquare.nav[IsoDirections.N.index()];
            }
        } else if (isoGridSquare.Is(IsoFlagType.climbSheetTopW)) {
            isoFlagType2 = IsoFlagType.climbSheetTopW;
            isoFlagType = IsoFlagType.climbSheetW;
        } else {
            if (isoGridSquare.nav[IsoDirections.W.index()] == null || !isoGridSquare.nav[IsoDirections.W.index()].Is(IsoFlagType.climbSheetTopE)) return false;
            isoFlagType2 = IsoFlagType.climbSheetTopE;
            isoFlagType = IsoFlagType.climbSheetE;
            var5_6 = "crafted_01_3";
            for (n = 0; n < isoGridSquare2.getObjects().size(); ++n) {
                IsoObject isoObject = isoGridSquare2.getObjects().get(n);
                if (isoObject.sprite == null || isoObject.sprite.getName() == null || !isoObject.sprite.getName().equals(var5_6)) continue;
                isoGridSquare2.transmitRemoveItemFromSquare(isoObject);
                break;
            }
            isoGridSquare2 = isoGridSquare.nav[IsoDirections.W.index()];
        }
        while (isoGridSquare2 != null) {
            n = 0;
            for (int i = 0; i < isoGridSquare2.getObjects().size(); ++i) {
                IsoObject isoObject = isoGridSquare2.getObjects().get(i);
                if (isoObject.getProperties() == null || !isoObject.getProperties().Is(isoFlagType2) && !isoObject.getProperties().Is(isoFlagType)) continue;
                isoGridSquare2.transmitRemoveItemFromSquare(isoObject);
                if (GameServer.bServer) {
                    if (isoPlayer != null) {
                        isoPlayer.sendObjectChange("addItemOfType", "type", isoObject.getName());
                    }
                } else if (isoPlayer != null) {
                    isoPlayer.getInventory().AddItem(isoObject.getName());
                }
                n = 1;
                break;
            }
            if (n == 0 || isoGridSquare2.getZ() == 0) return true;
            isoGridSquare2 = isoGridSquare2.getCell().getGridSquare(isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ() - 1);
        }
        return true;
    }

    @Override
    public void Damage(float f) {
        this.Damage(f, false);
    }

    public void Damage(float f, boolean bl) {
        if (this.isInvincible() || "Tutorial".equals(Core.GameMode)) {
            return;
        }
        this.DirtySlice();
        this.Health = (int)((float)this.Health - f);
        if (this.Health < 0) {
            this.Health = 0;
        }
        if (!this.isDestroyed() && this.Health == 0) {
            this.smashWindow(false, !bl || SandboxOptions.getInstance().Lore.TriggerHouseAlarm.getValue());
            if (this.getSquare().getBuilding() != null) {
                this.getSquare().getBuilding().forceAwake();
            }
        }
    }

    public void Damage(float f, IsoMovingObject isoMovingObject) {
        if (this.isInvincible() || "Tutorial".equals(Core.GameMode)) {
            return;
        }
        this.Health = (int)((float)this.Health - f);
        if (this.Health < 0) {
            this.Health = 0;
        }
        if (!this.isDestroyed() && this.Health == 0) {
            boolean bl = !(isoMovingObject instanceof IsoZombie) || SandboxOptions.getInstance().Lore.TriggerHouseAlarm.getValue();
            this.smashWindow(false, bl);
            this.addBrokenGlass(isoMovingObject);
        }
    }

    public boolean isLocked() {
        return this.Locked;
    }

    public boolean isSmashed() {
        return this.destroyed;
    }

    public boolean isInvincible() {
        if (this.square == null || !this.square.Is(IsoFlagType.makeWindowInvincible)) {
            return false;
        }
        int n = this.getObjectIndex();
        if (n != -1) {
            IsoObject[] isoObjectArray = this.square.getObjects().getElements();
            int n2 = this.square.getObjects().size();
            for (int i = 0; i < n2; ++i) {
                IsoObject isoObject;
                PropertyContainer propertyContainer;
                if (i == n || (propertyContainer = (isoObject = isoObjectArray[i]).getProperties()) == null || !propertyContainer.Is(this.getNorth() ? IsoFlagType.cutN : IsoFlagType.cutW) || !propertyContainer.Is(IsoFlagType.makeWindowInvincible)) continue;
                return true;
            }
        }
        return this.sprite != null && this.sprite.getProperties().Is(IsoFlagType.makeWindowInvincible);
    }

    @Override
    public IsoBarricade getBarricadeOnSameSquare() {
        return IsoBarricade.GetBarricadeOnSquare(this.square, this.north ? IsoDirections.N : IsoDirections.W);
    }

    @Override
    public IsoBarricade getBarricadeOnOppositeSquare() {
        return IsoBarricade.GetBarricadeOnSquare(this.getOppositeSquare(), this.north ? IsoDirections.S : IsoDirections.E);
    }

    @Override
    public boolean isBarricaded() {
        IsoBarricade isoBarricade = this.getBarricadeOnSameSquare();
        if (isoBarricade == null) {
            isoBarricade = this.getBarricadeOnOppositeSquare();
        }
        return isoBarricade != null;
    }

    @Override
    public boolean isBarricadeAllowed() {
        return true;
    }

    @Override
    public IsoBarricade getBarricadeForCharacter(IsoGameCharacter isoGameCharacter) {
        return IsoBarricade.GetBarricadeForCharacter(this, isoGameCharacter);
    }

    @Override
    public IsoBarricade getBarricadeOppositeCharacter(IsoGameCharacter isoGameCharacter) {
        return IsoBarricade.GetBarricadeOppositeCharacter(this, isoGameCharacter);
    }

    @Override
    public boolean getNorth() {
        return this.north;
    }

    @Override
    public Vector2 getFacingPosition(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        if (this.north) {
            return vector22.set(this.getX() + 0.5f, this.getY());
        }
        return vector22.set(this.getX(), this.getY() + 0.5f);
    }

    public void setIsLocked(boolean bl) {
        this.Locked = bl;
    }

    public IsoSprite getOpenSprite() {
        return this.openSprite;
    }

    public void setOpenSprite(IsoSprite isoSprite) {
        this.openSprite = isoSprite;
    }

    public void setSmashed(boolean bl) {
        if (bl) {
            this.destroyed = true;
            this.sprite = this.smashedSprite;
        } else {
            this.destroyed = false;
            this.sprite = this.open ? this.openSprite : this.closedSprite;
            this.Health = this.MaxHealth;
        }
        this.glassRemoved = false;
    }

    public IsoSprite getSmashedSprite() {
        return this.smashedSprite;
    }

    public void setSmashedSprite(IsoSprite isoSprite) {
        this.smashedSprite = isoSprite;
    }

    public void setPermaLocked(Boolean bl) {
        this.PermaLocked = bl;
    }

    public boolean isPermaLocked() {
        return this.PermaLocked;
    }

    public static boolean canClimbThroughHelper(IsoGameCharacter isoGameCharacter, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2, boolean bl) {
        IsoGridSquare isoGridSquare3 = isoGridSquare;
        float f = 0.5f;
        float f2 = 0.5f;
        if (bl) {
            if (isoGameCharacter.getY() >= (float)isoGridSquare.getY()) {
                isoGridSquare3 = isoGridSquare2;
                f2 = 0.7f;
            } else {
                f2 = 0.3f;
            }
        } else if (isoGameCharacter.getX() >= (float)isoGridSquare.getX()) {
            isoGridSquare3 = isoGridSquare2;
            f = 0.7f;
        } else {
            f = 0.3f;
        }
        if (isoGridSquare3 == null) {
            return false;
        }
        if (isoGridSquare3.isSolid()) {
            return false;
        }
        if (isoGridSquare3.Is(IsoFlagType.water)) {
            return false;
        }
        if (!(isoGameCharacter.canClimbDownSheetRope(isoGridSquare3) || isoGridSquare3.HasStairsBelow() || PolygonalMap2.instance.canStandAt((float)isoGridSquare3.x + f, (float)isoGridSquare3.y + f2, isoGridSquare3.z, null, 19))) {
            return !isoGridSquare3.TreatAsSolidFloor();
        }
        return !GameClient.bClient || !(isoGameCharacter instanceof IsoPlayer) || SafeHouse.isSafeHouse(isoGridSquare3, ((IsoPlayer)isoGameCharacter).getUsername(), true) == null || ServerOptions.instance.SafehouseAllowTrepass.getValue();
    }

    public boolean canClimbThrough(IsoGameCharacter isoGameCharacter) {
        if (this.square == null || this.isInvincible()) {
            return false;
        }
        if (this.isBarricaded()) {
            return false;
        }
        if (isoGameCharacter != null && !IsoWindow.canClimbThroughHelper(isoGameCharacter, this.getSquare(), this.getOppositeSquare(), this.north)) {
            return false;
        }
        IsoGameCharacter isoGameCharacter2 = this.getFirstCharacterClosing();
        if (isoGameCharacter2 != null && isoGameCharacter2.isVariable("CloseWindowOutcome", "success")) {
            return false;
        }
        if (this.Health <= 0 || this.destroyed) {
            return true;
        }
        return this.open;
    }

    public IsoGameCharacter getFirstCharacterClimbingThrough() {
        IsoGameCharacter isoGameCharacter = this.getFirstCharacterClimbingThrough(this.getSquare());
        if (isoGameCharacter != null) {
            return isoGameCharacter;
        }
        return this.getFirstCharacterClimbingThrough(this.getOppositeSquare());
    }

    public IsoGameCharacter getFirstCharacterClimbingThrough(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return null;
        }
        for (int i = 0; i < isoGridSquare.getMovingObjects().size(); ++i) {
            IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoGridSquare.getMovingObjects().get(i), IsoGameCharacter.class);
            if (isoGameCharacter == null || !isoGameCharacter.isClimbingThroughWindow(this)) continue;
            return isoGameCharacter;
        }
        return null;
    }

    public IsoGameCharacter getFirstCharacterClosing() {
        IsoGameCharacter isoGameCharacter = this.getFirstCharacterClosing(this.getSquare());
        if (isoGameCharacter != null) {
            return isoGameCharacter;
        }
        return this.getFirstCharacterClosing(this.getOppositeSquare());
    }

    public IsoGameCharacter getFirstCharacterClosing(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return null;
        }
        for (int i = 0; i < isoGridSquare.getMovingObjects().size(); ++i) {
            IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoGridSquare.getMovingObjects().get(i), IsoGameCharacter.class);
            if (isoGameCharacter == null || !isoGameCharacter.isClosingWindow(this)) continue;
            return isoGameCharacter;
        }
        return null;
    }

    public boolean isGlassRemoved() {
        return this.glassRemoved;
    }

    public void setGlassRemoved(boolean bl) {
        if (!this.destroyed) {
            return;
        }
        if (bl) {
            this.sprite = this.glassRemovedSprite;
            this.glassRemoved = true;
        } else {
            this.sprite = this.smashedSprite;
            this.glassRemoved = false;
        }
        if (this.getObjectIndex() != -1) {
            PolygonalMap2.instance.squareChanged(this.square);
        }
    }

    public void removeBrokenGlass() {
        if (GameClient.bClient) {
            GameClient.instance.smashWindow(this, 2);
        } else {
            this.setGlassRemoved(true);
        }
    }

    public IsoBarricade addBarricadesDebug(int n, boolean bl) {
        IsoGridSquare isoGridSquare = this.square.getRoom() == null ? this.square : this.getOppositeSquare();
        boolean bl2 = isoGridSquare != this.square;
        IsoBarricade isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)this, bl2);
        if (isoBarricade != null) {
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    isoBarricade.addMetalBar(null, null);
                    continue;
                }
                isoBarricade.addPlank(null, null);
            }
        }
        return isoBarricade;
    }

    public void addRandomBarricades() {
        IsoGridSquare isoGridSquare;
        IsoGridSquare isoGridSquare2 = isoGridSquare = this.square.getRoom() == null ? this.square : this.getOppositeSquare();
        if (this.getZ() == 0.0f && isoGridSquare != null && isoGridSquare.getRoom() == null) {
            boolean bl = isoGridSquare != this.square;
            IsoBarricade isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)this, bl);
            if (isoBarricade != null) {
                int n = Rand.Next(1, 4);
                for (int i = 0; i < n; ++i) {
                    isoBarricade.addPlank(null, null);
                }
                if (GameServer.bServer) {
                    isoBarricade.transmitCompleteItemToClients();
                }
            }
        } else {
            this.addSheet(null);
            this.HasCurtains().ToggleDoor(null);
        }
    }

    public static enum WindowType {
        SinglePane,
        DoublePane;

    }
}

