/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.characters.IsoPlayer;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoPushableObject;

public class IsoWheelieBin
extends IsoPushableObject {
    float velx = 0.0f;
    float vely = 0.0f;

    @Override
    public String getObjectName() {
        return "WheelieBin";
    }

    public IsoWheelieBin(IsoCell isoCell) {
        super(isoCell);
        this.container = new ItemContainer("wheeliebin", this.square, this);
        this.Collidable = true;
        this.solid = true;
        this.shootable = false;
        this.width = 0.3f;
        this.dir = IsoDirections.E;
        this.setAlphaAndTarget(0.0f);
        this.offsetX = -26.0f;
        this.offsetY = -248.0f;
        this.OutlineOnMouseover = true;
        this.sprite.LoadFramesPageSimple("TileObjectsExt_7", "TileObjectsExt_5", "TileObjectsExt_6", "TileObjectsExt_8");
    }

    public IsoWheelieBin(IsoCell isoCell, int n, int n2, int n3) {
        super(isoCell, n, n2, n3);
        this.x = (float)n + 0.5f;
        this.y = (float)n2 + 0.5f;
        this.z = n3;
        this.nx = this.x;
        this.ny = this.y;
        this.offsetX = -26.0f;
        this.offsetY = -248.0f;
        this.weight = 6.0f;
        this.sprite.LoadFramesPageSimple("TileObjectsExt_7", "TileObjectsExt_5", "TileObjectsExt_6", "TileObjectsExt_8");
        this.square = this.getCell().getGridSquare(n, n2, n3);
        this.current = this.getCell().getGridSquare(n, n2, n3);
        this.container = new ItemContainer("wheeliebin", this.square, this);
        this.Collidable = true;
        this.solid = true;
        this.shootable = false;
        this.width = 0.3f;
        this.dir = IsoDirections.E;
        this.setAlphaAndTarget(0.0f);
        this.OutlineOnMouseover = true;
    }

    @Override
    public void update() {
        this.velx = this.getX() - this.getLx();
        this.vely = this.getY() - this.getLy();
        float f = 1.0f - this.container.getContentsWeight() / 500.0f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f < 0.7f) {
            f *= f;
        }
        if (IsoPlayer.getInstance() != null && IsoPlayer.getInstance().getDragObject() != this) {
            if (this.velx != 0.0f && this.vely == 0.0f && (this.dir == IsoDirections.E || this.dir == IsoDirections.W)) {
                this.setNx(this.getNx() + this.velx * 0.65f * f);
            }
            if (this.vely != 0.0f && this.velx == 0.0f && (this.dir == IsoDirections.N || this.dir == IsoDirections.S)) {
                this.setNy(this.getNy() + this.vely * 0.65f * f);
            }
        }
        super.update();
    }

    @Override
    public float getWeight(float f, float f2) {
        float f3 = this.container.getContentsWeight() / 500.0f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            return this.getWeight() * 8.0f;
        }
        float f4 = this.getWeight() * f3 + 1.5f;
        if (this.dir == IsoDirections.W || this.dir == IsoDirections.E && f2 == 0.0f) {
            return f4 / 2.0f;
        }
        if (this.dir == IsoDirections.N || this.dir == IsoDirections.S && f == 0.0f) {
            return f4 / 2.0f;
        }
        return f4 * 3.0f;
    }
}

