/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.characters.IsoPlayer;
import zombie.characters.Talker;
import zombie.chat.ChatElement;
import zombie.chat.ChatElementOwner;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.properties.PropertyContainer;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.Radio;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoRadio;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.radio.ZomboidRadio;
import zombie.radio.devices.DeviceData;
import zombie.radio.devices.PresetEntry;
import zombie.radio.devices.WaveSignalDevice;
import zombie.ui.UIFont;

public class IsoWaveSignal
extends IsoObject
implements WaveSignalDevice,
ChatElementOwner,
Talker {
    protected IsoLightSource lightSource = null;
    protected boolean lightWasRemoved = false;
    protected int lightSourceRadius = 4;
    protected float nextLightUpdate = 0.0f;
    protected float lightUpdateCnt = 0.0f;
    protected DeviceData deviceData = null;
    protected boolean displayRange = false;
    protected boolean hasPlayerInRange = false;
    protected GameTime gameTime;
    protected ChatElement chatElement;
    protected String talkerType = "device";
    protected static Map<String, DeviceData> deviceDataCache = new HashMap<String, DeviceData>();

    public IsoWaveSignal(IsoCell isoCell) {
        super(isoCell);
        this.init(true);
    }

    public IsoWaveSignal(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
        this.init(false);
    }

    protected void init(boolean bl) {
        this.chatElement = new ChatElement(this, 5, this.talkerType);
        this.gameTime = GameTime.getInstance();
        if (!bl) {
            PropertyContainer propertyContainer;
            if (this.sprite != null && this.sprite.getProperties() != null && (propertyContainer = this.sprite.getProperties()).Is("CustomItem") && propertyContainer.Val("CustomItem") != null) {
                this.deviceData = this.cloneDeviceDataFromItem(propertyContainer.Val("CustomItem"));
            }
            if (!GameClient.bClient && this.deviceData != null) {
                this.deviceData.generatePresets();
                this.deviceData.setDeviceVolume(Rand.Next(0.1f, 1.0f));
                this.deviceData.setRandomChannel();
                if (Rand.Next(100) <= 35 && !"Tutorial".equals(Core.GameMode)) {
                    this.deviceData.setTurnedOnRaw(true);
                    if (this instanceof IsoRadio) {
                        this.deviceData.setInitialPower();
                        if (this.deviceData.getIsBatteryPowered() && this.deviceData.getPower() <= 0.0f) {
                            this.deviceData.setTurnedOnRaw(false);
                        }
                    }
                }
            }
        }
        if (this.deviceData == null) {
            this.deviceData = new DeviceData(this);
        }
        this.deviceData.setParent(this);
    }

    public DeviceData cloneDeviceDataFromItem(String string) {
        if (string != null) {
            DeviceData deviceData;
            if (deviceDataCache.containsKey(string) && deviceDataCache.get(string) != null) {
                return deviceDataCache.get(string).getClone();
            }
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string);
            if (inventoryItem != null && inventoryItem instanceof Radio && (deviceData = ((Radio)inventoryItem).getDeviceData()) != null) {
                deviceDataCache.put(string, deviceData);
                return deviceData.getClone();
            }
        }
        return null;
    }

    public boolean hasChatToDisplay() {
        return this.chatElement.getHasChatToDisplay();
    }

    @Override
    public boolean HasPlayerInRange() {
        return this.hasPlayerInRange;
    }

    @Override
    public float getDelta() {
        if (this.deviceData != null) {
            return this.deviceData.getPower();
        }
        return 0.0f;
    }

    @Override
    public void setDelta(float f) {
        if (this.deviceData != null) {
            this.deviceData.setPower(f);
        }
    }

    @Override
    public DeviceData getDeviceData() {
        return this.deviceData;
    }

    @Override
    public void setDeviceData(DeviceData deviceData) {
        if (deviceData == null) {
            deviceData = new DeviceData(this);
        }
        this.deviceData = deviceData;
        this.deviceData.setParent(this);
    }

    @Override
    public boolean IsSpeaking() {
        return this.chatElement.IsSpeaking();
    }

    @Override
    public String getTalkerType() {
        return this.chatElement.getTalkerType();
    }

    public void setTalkerType(String string) {
        this.talkerType = string == null ? "" : string;
        this.chatElement.setTalkerType(this.talkerType);
    }

    @Override
    public String getSayLine() {
        return this.chatElement.getSayLine();
    }

    @Override
    public void Say(String string) {
        this.AddDeviceText(string, 1.0f, 1.0f, 1.0f, null, null, -1, false);
    }

    @Override
    public void AddDeviceText(String string, float f, float f2, float f3, String string2, String string3, int n) {
        this.AddDeviceText(string, f, f2, f3, string2, string3, n, true);
    }

    public void AddDeviceText(String string, int n, int n2, int n3, String string2, String string3, int n4) {
        this.AddDeviceText(string, (float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, string2, string3, n4, true);
    }

    public void AddDeviceText(String string, int n, int n2, int n3, String string2, String string3, int n4, boolean bl) {
        this.AddDeviceText(string, (float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, string2, string3, n4, bl);
    }

    public void AddDeviceText(String string, float f, float f2, float f3, String string2, String string3, int n, boolean bl) {
        if (this.deviceData != null && this.deviceData.getIsTurnedOn()) {
            if (!ZomboidRadio.isStaticSound(string)) {
                this.deviceData.doReceiveSignal(n);
            }
            if (this.deviceData.getDeviceVolume() > 0.0f) {
                this.chatElement.addChatLine(string, f, f2, f3, UIFont.Medium, this.deviceData.getDeviceVolumeRange(), "default", true, true, true, true, true, true);
                if (string3 != null) {
                    LuaEventManager.triggerEvent("OnDeviceText", string2, string3, Float.valueOf(this.getX()), Float.valueOf(this.getY()), Float.valueOf(this.getZ()), string, this);
                }
            }
        }
    }

    @Override
    public void renderlast() {
        if (this.chatElement.getHasChatToDisplay()) {
            if (this.getDeviceData() != null && !this.getDeviceData().getIsTurnedOn()) {
                this.chatElement.clear(IsoCamera.frameState.playerIndex);
                return;
            }
            float f = IsoUtils.XToScreen(this.getX(), this.getY(), this.getZ(), 0);
            float f2 = IsoUtils.YToScreen(this.getX(), this.getY(), this.getZ(), 0);
            f = f - IsoCamera.getOffX() - this.offsetX;
            f2 = f2 - IsoCamera.getOffY() - this.offsetY;
            f += (float)(32 * Core.TileScale);
            f2 += (float)(50 * Core.TileScale);
            this.chatElement.renderBatched(IsoPlayer.getPlayerIndex(), (int)(f /= Core.getInstance().getZoom(IsoPlayer.getPlayerIndex())), (int)(f2 /= Core.getInstance().getZoom(IsoPlayer.getPlayerIndex())));
        }
    }

    public void renderlastold2() {
        if (this.chatElement.getHasChatToDisplay()) {
            float f = IsoUtils.XToScreen(this.getX(), this.getY(), this.getZ(), 0);
            float f2 = IsoUtils.YToScreen(this.getX(), this.getY(), this.getZ(), 0);
            f = f - IsoCamera.getOffX() - this.offsetX;
            f2 = f2 - IsoCamera.getOffY() - this.offsetY;
            f += 28.0f;
            f2 += 180.0f;
            f /= Core.getInstance().getZoom(IsoPlayer.getPlayerIndex());
            f2 /= Core.getInstance().getZoom(IsoPlayer.getPlayerIndex());
            this.chatElement.renderBatched(IsoPlayer.getPlayerIndex(), (int)(f += (float)IsoCamera.getScreenLeft(IsoPlayer.getPlayerIndex())), (int)(f2 += (float)IsoCamera.getScreenTop(IsoPlayer.getPlayerIndex())));
        }
    }

    protected boolean playerWithinBounds(IsoPlayer isoPlayer, float f) {
        if (isoPlayer == null) {
            return false;
        }
        return (isoPlayer.getX() > this.getX() - f || isoPlayer.getX() < this.getX() + f) && (isoPlayer.getY() > this.getY() - f || isoPlayer.getY() < this.getY() + f);
    }

    @Override
    public void update() {
        if (this.deviceData == null) {
            return;
        }
        if (!GameServer.bServer && !GameClient.bClient || GameServer.bServer) {
            this.deviceData.update(true, this.hasPlayerInRange);
        } else {
            this.deviceData.updateSimple();
        }
        if (!GameServer.bServer) {
            this.hasPlayerInRange = false;
            if (this.deviceData.getIsTurnedOn()) {
                IsoPlayer isoPlayer = IsoPlayer.getInstance();
                if (this.playerWithinBounds(isoPlayer, (float)this.deviceData.getDeviceVolumeRange() * 0.6f)) {
                    this.hasPlayerInRange = true;
                }
                this.updateLightSource();
            } else {
                this.removeLightSourceFromWorld();
            }
            this.chatElement.setHistoryRange((float)this.deviceData.getDeviceVolumeRange() * 0.6f);
            this.chatElement.update();
        } else {
            this.hasPlayerInRange = false;
        }
    }

    protected void updateLightSource() {
    }

    protected void removeLightSourceFromWorld() {
        if (this.lightSource != null) {
            IsoWorld.instance.CurrentCell.removeLamppost(this.lightSource);
            this.lightSource = null;
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        if (this.deviceData == null) {
            this.deviceData = new DeviceData(this);
        }
        if (byteBuffer.get() == 1) {
            this.deviceData.load(byteBuffer, n, true);
        }
        this.deviceData.setParent(this);
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        if (this.deviceData != null) {
            byteBuffer.put((byte)1);
            this.deviceData.save(byteBuffer, true);
        } else {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public void addToWorld() {
        if (!GameServer.bServer) {
            ZomboidRadio.getInstance().RegisterDevice(this);
        }
        if (this.getCell() != null) {
            this.getCell().addToStaticUpdaterObjectList(this);
        }
        super.addToWorld();
    }

    @Override
    public void removeFromWorld() {
        if (!GameServer.bServer) {
            ZomboidRadio.getInstance().UnRegisterDevice(this);
        }
        this.removeLightSourceFromWorld();
        this.lightSource = null;
        if (this.deviceData != null) {
            this.deviceData.cleanSoundsAndEmitter();
        }
        super.removeFromWorld();
    }

    @Override
    public void removeFromSquare() {
        super.removeFromSquare();
        this.square = null;
    }

    @Override
    public void saveState(ByteBuffer byteBuffer) throws IOException {
        if (this.deviceData == null) {
            return;
        }
        ArrayList<PresetEntry> arrayList = this.deviceData.getDevicePresets().getPresets();
        byteBuffer.putInt(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            PresetEntry presetEntry = arrayList.get(i);
            GameWindow.WriteString(byteBuffer, presetEntry.getName());
            byteBuffer.putInt(presetEntry.getFrequency());
        }
        byteBuffer.put((byte)(this.deviceData.getIsTurnedOn() ? 1 : 0));
        byteBuffer.putInt(this.deviceData.getChannel());
        byteBuffer.putFloat(this.deviceData.getDeviceVolume());
    }

    @Override
    public void loadState(ByteBuffer byteBuffer) throws IOException {
        ArrayList<PresetEntry> arrayList = this.deviceData.getDevicePresets().getPresets();
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            String string = GameWindow.ReadString(byteBuffer);
            int n2 = byteBuffer.getInt();
            if (i < arrayList.size()) {
                PresetEntry presetEntry = arrayList.get(i);
                presetEntry.setName(string);
                presetEntry.setFrequency(n2);
                continue;
            }
            this.deviceData.getDevicePresets().addPreset(string, n2);
        }
        while (arrayList.size() > n) {
            this.deviceData.getDevicePresets().removePreset(n);
        }
        this.deviceData.setTurnedOnRaw(byteBuffer.get() == 1);
        this.deviceData.setChannelRaw(byteBuffer.getInt());
        this.deviceData.setDeviceVolumeRaw(byteBuffer.getFloat());
    }

    public ChatElement getChatElement() {
        return this.chatElement;
    }

    public static void Reset() {
        deviceDataCache.clear();
    }
}

