/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import fmod.fmod.FMODManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.lwjgl.opengl.ARBShaderObjects;
import zombie.GameTime;
import zombie.IndieGL;
import zombie.Lua.LuaEventManager;
import zombie.WorldSoundManager;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.parameters.ParameterMeleeHitSurface;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.opengl.ShaderProgram;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.inventory.types.HandWeapon;
import zombie.iso.CellLoader;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;

public class IsoTree
extends IsoObject {
    public static final int MAX_SIZE = 6;
    public int LogYield = 1;
    public int damage = 500;
    public int size = 4;
    public boolean bRenderFlag;
    public float fadeAlpha;
    private static final IsoGameCharacter.Location[] s_chopTreeLocation = new IsoGameCharacter.Location[4];
    private static final ArrayList<IsoGridSquare> s_chopTreeIndicators = new ArrayList();
    private static IsoTree s_chopTreeHighlighted = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IsoTree getNew() {
        ArrayDeque<IsoTree> arrayDeque = CellLoader.isoTreeCache;
        synchronized (arrayDeque) {
            if (CellLoader.isoTreeCache.isEmpty()) {
                return new IsoTree();
            }
            IsoTree isoTree = CellLoader.isoTreeCache.pop();
            isoTree.sx = 0.0f;
            return isoTree;
        }
    }

    public IsoTree() {
    }

    public IsoTree(IsoCell isoCell) {
        super(isoCell);
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put((byte)this.LogYield);
        byteBuffer.put((byte)(this.damage / 10));
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.LogYield = byteBuffer.get();
        this.damage = byteBuffer.get() * 10;
        if (this.sprite != null && this.sprite.getProperties().Val("tree") != null) {
            this.size = Integer.parseInt(this.sprite.getProperties().Val("tree"));
            if (this.size < 1) {
                this.size = 1;
            }
            if (this.size > 6) {
                this.size = 6;
            }
        }
    }

    @Override
    protected void checkMoveWithWind() {
        this.checkMoveWithWind(true);
    }

    @Override
    public void reset() {
        super.reset();
    }

    public IsoTree(IsoGridSquare isoGridSquare, String string) {
        super(isoGridSquare, string, false);
        this.initTree();
    }

    public IsoTree(IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoGridSquare.getCell(), isoGridSquare, isoSprite);
        this.initTree();
    }

    public void initTree() {
        this.setType(IsoObjectType.tree);
        if (this.sprite.getProperties().Val("tree") != null) {
            this.size = Integer.parseInt(this.sprite.getProperties().Val("tree"));
            if (this.size < 1) {
                this.size = 1;
            }
            if (this.size > 6) {
                this.size = 6;
            }
        } else {
            this.size = 4;
        }
        switch (this.size) {
            case 1: 
            case 2: {
                this.LogYield = 1;
                break;
            }
            case 3: 
            case 4: {
                this.LogYield = 2;
                break;
            }
            case 5: {
                this.LogYield = 3;
                break;
            }
            case 6: {
                this.LogYield = 4;
            }
        }
        this.damage = this.LogYield * 80;
    }

    @Override
    public String getObjectName() {
        return "Tree";
    }

    @Override
    public void Damage(float f) {
        float f2 = f * 0.05f;
        this.damage = (int)((float)this.damage - f2);
        if (this.damage <= 0) {
            int n;
            this.square.transmitRemoveItemFromSquare(this);
            this.square.RecalcAllWithNeighbours(true);
            int n2 = this.LogYield;
            for (n = 0; n < n2; ++n) {
                this.square.AddWorldInventoryItem("Base.Log", 0.0f, 0.0f, 0.0f);
                if (Rand.Next(4) == 0) {
                    this.square.AddWorldInventoryItem("Base.TreeBranch", 0.0f, 0.0f, 0.0f);
                }
                if (Rand.Next(4) != 0) continue;
                this.square.AddWorldInventoryItem("Base.Twigs", 0.0f, 0.0f, 0.0f);
            }
            this.reset();
            CellLoader.isoTreeCache.add(this);
            for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                LosUtil.cachecleared[n] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
            LuaEventManager.triggerEvent("OnContainerUpdate");
        }
    }

    @Override
    public void HitByVehicle(BaseVehicle baseVehicle, float f) {
        BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter((float)this.square.x + 0.5f, (float)this.square.y + 0.5f, this.square.z);
        long l = baseSoundEmitter.playSound("VehicleHitTree");
        baseSoundEmitter.setParameterValue(l, FMODManager.instance.getParameterDescription("VehicleSpeed"), baseVehicle.getCurrentSpeedKmHour());
        WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
        this.Damage(this.damage);
    }

    @Override
    public void WeaponHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        int n = handWeapon.getConditionLowerChance() * 2 + isoGameCharacter.getMaintenanceMod();
        if (!handWeapon.getCategories().contains("Axe")) {
            n = handWeapon.getConditionLowerChance() / 2 + isoGameCharacter.getMaintenanceMod();
        }
        if (Rand.NextBool(n)) {
            handWeapon.setCondition(handWeapon.getCondition() - 1);
        }
        if (isoGameCharacter instanceof IsoPlayer) {
            ((IsoPlayer)isoGameCharacter).setMeleeHitSurface(ParameterMeleeHitSurface.Material.Tree);
            isoGameCharacter.getEmitter().playSound(handWeapon.getZombieHitSound());
        } else {
            isoGameCharacter.getEmitter().playSound("ChopTree");
        }
        WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
        this.setRenderEffect(RenderEffectType.Hit_Tree_Shudder, true);
        float f = handWeapon.getTreeDamage();
        if (isoGameCharacter.Traits.Axeman.isSet() && handWeapon.getCategories().contains("Axe")) {
            f *= 1.5f;
        }
        this.damage = (int)((float)this.damage - f);
        if (this.damage <= 0) {
            int n2;
            this.square.transmitRemoveItemFromSquare(this);
            isoGameCharacter.getEmitter().playSound("FallingTree");
            this.square.RecalcAllWithNeighbours(true);
            int n3 = this.LogYield;
            for (n2 = 0; n2 < n3; ++n2) {
                this.square.AddWorldInventoryItem("Base.Log", 0.0f, 0.0f, 0.0f);
                if (Rand.Next(4) == 0) {
                    this.square.AddWorldInventoryItem("Base.TreeBranch", 0.0f, 0.0f, 0.0f);
                }
                if (Rand.Next(4) != 0) continue;
                this.square.AddWorldInventoryItem("Base.Twigs", 0.0f, 0.0f, 0.0f);
            }
            this.reset();
            CellLoader.isoTreeCache.add(this);
            for (n2 = 0; n2 < IsoPlayer.numPlayers; ++n2) {
                LosUtil.cachecleared[n2] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
            LuaEventManager.triggerEvent("OnContainerUpdate");
        }
        LuaEventManager.triggerEvent("OnWeaponHitTree", isoGameCharacter, handWeapon);
    }

    public void setHealth(int n) {
        this.damage = Math.max(n, 0);
    }

    public int getHealth() {
        return this.damage;
    }

    public int getMaxHealth() {
        return this.LogYield * 80;
    }

    public int getSize() {
        return this.size;
    }

    public float getSlowFactor(IsoMovingObject isoMovingObject) {
        float f = 1.0f;
        if (isoMovingObject instanceof IsoGameCharacter) {
            if ("parkranger".equals(((IsoGameCharacter)isoMovingObject).getDescriptor().getProfession())) {
                f = 1.5f;
            }
            if ("lumberjack".equals(((IsoGameCharacter)isoMovingObject).getDescriptor().getProfession())) {
                f = 1.2f;
            }
        }
        if (this.size == 1 || this.size == 2) {
            return 0.8f * f;
        }
        if (this.size == 3 || this.size == 4) {
            return 0.5f * f;
        }
        return 0.3f * f;
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.isHighlighted()) {
            if (this.square != null) {
                s_chopTreeHighlighted = this;
            }
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        if (this.bRenderFlag || this.fadeAlpha < this.getTargetAlpha(n)) {
            float f4;
            IndieGL.enableStencilTest();
            IndieGL.glStencilFunc(517, 128, 128);
            this.renderInner(f, f2, f3, colorInfo, bl, false);
            float f5 = 0.044999998f * (GameTime.getInstance().getMultiplier() / 1.6f);
            if (this.bRenderFlag && this.fadeAlpha > 0.25f) {
                this.fadeAlpha -= f5;
                if (this.fadeAlpha < 0.25f) {
                    this.fadeAlpha = 0.25f;
                }
            }
            if (!this.bRenderFlag && this.fadeAlpha < (f4 = this.getTargetAlpha(n))) {
                this.fadeAlpha += f5;
                if (this.fadeAlpha > f4) {
                    this.fadeAlpha = f4;
                }
            }
            f4 = this.getAlpha(n);
            float f6 = this.getTargetAlpha(n);
            this.setAlphaAndTarget(n, this.fadeAlpha);
            IndieGL.glStencilFunc(514, 128, 128);
            this.renderInner(f, f2, f3, colorInfo, true, false);
            this.setAlpha(n, f4);
            this.setTargetAlpha(n, f6);
            if (TreeShader.instance.StartShader()) {
                TreeShader.instance.setOutlineColor(0.1f, 0.1f, 0.1f, 1.0f - this.fadeAlpha);
                this.renderInner(f, f2, f3, colorInfo, true, true);
                IndieGL.EndShader();
            }
            IndieGL.glStencilFunc(519, 255, 255);
        } else {
            this.renderInner(f, f2, f3, colorInfo, bl, false);
        }
        this.checkChopTreeIndicator(f, f2, f3);
    }

    private void renderInner(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2) {
        Texture texture;
        if (this.sprite != null && this.sprite.name != null && this.sprite.name.contains("JUMBO")) {
            var7_7 = this.offsetX;
            var8_10 = this.offsetY;
            this.offsetX = 384 * Core.TileScale / 2 - 96 * Core.TileScale;
            this.offsetY = 256 * Core.TileScale - 32 * Core.TileScale;
            if (this.offsetX != var7_7 || this.offsetY != var8_10) {
                this.sx = 0.0f;
            }
        } else {
            var7_7 = this.offsetX;
            var8_10 = this.offsetY;
            this.offsetX = 32 * Core.TileScale;
            this.offsetY = 96 * Core.TileScale;
            if (this.offsetX != var7_7 || this.offsetY != var8_10) {
                this.sx = 0.0f;
            }
        }
        if (bl2 && this.sprite != null && (texture = this.sprite.getTextureForCurrentFrame(this.dir)) != null) {
            TreeShader.instance.setStepSize(0.25f, texture.getWidth(), texture.getHeight());
        }
        super.render(f, f2, f3, colorInfo, false, false, null);
        if (this.AttachedAnimSprite != null) {
            int n = this.AttachedAnimSprite.size();
            for (int i = 0; i < n; ++i) {
                IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(i);
                int n2 = IsoCamera.frameState.playerIndex;
                float f4 = this.getTargetAlpha(n2);
                this.setTargetAlpha(n2, 1.0f);
                isoSpriteInstance.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY, this.isHighlighted() ? this.getHighlightColor() : colorInfo);
                this.setTargetAlpha(n2, f4);
                isoSpriteInstance.update();
            }
        }
    }

    @Override
    public void setSprite(IsoSprite isoSprite) {
        super.setSprite(isoSprite);
        this.initTree();
    }

    @Override
    public boolean isMaskClicked(int n, int n2, boolean bl) {
        if (super.isMaskClicked(n, n2, bl)) {
            return true;
        }
        if (this.AttachedAnimSprite == null) {
            return false;
        }
        for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
            if (!((IsoSpriteInstance)this.AttachedAnimSprite.get((int)i)).parentSprite.isMaskClicked(this.dir, n, n2, bl)) continue;
            return true;
        }
        return false;
    }

    public static void setChopTreeCursorLocation(int n, int n2, int n3, int n4) {
        if (s_chopTreeLocation[n] == null) {
            IsoTree.s_chopTreeLocation[n] = new IsoGameCharacter.Location(-1, -1, -1);
        }
        IsoGameCharacter.Location location = s_chopTreeLocation[n];
        location.x = n2;
        location.y = n3;
        location.z = n4;
    }

    private void checkChopTreeIndicator(float f, float f2, float f3) {
        if (this.isHighlighted()) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        IsoGameCharacter.Location location = s_chopTreeLocation[n];
        if (location == null || location.x == -1 || this.square == null) {
            return;
        }
        if (this.getCell().getDrag(n) == null) {
            location.x = -1;
            return;
        }
        if (IsoUtils.DistanceToSquared((float)this.square.x + 0.5f, (float)this.square.y + 0.5f, (float)location.x + 0.5f, (float)location.y + 0.5f) < 12.25f) {
            s_chopTreeIndicators.add(this.square);
        }
    }

    public static void renderChopTreeIndicators() {
        if (!s_chopTreeIndicators.isEmpty()) {
            PZArrayUtil.forEach(s_chopTreeIndicators, IsoTree::renderChopTreeIndicator);
            s_chopTreeIndicators.clear();
        }
        if (s_chopTreeHighlighted != null) {
            IsoTree isoTree = s_chopTreeHighlighted;
            s_chopTreeHighlighted = null;
            isoTree.renderInner(isoTree.square.x, isoTree.square.y, isoTree.square.z, isoTree.getHighlightColor(), false, false);
        }
    }

    private static void renderChopTreeIndicator(IsoGridSquare isoGridSquare) {
        Texture texture = Texture.getSharedTexture("media/ui/chop_tree.png");
        if (texture == null || !texture.isReady()) {
            return;
        }
        float f = isoGridSquare.x;
        float f2 = isoGridSquare.y;
        float f3 = isoGridSquare.z;
        float f4 = IsoUtils.XToScreen(f, f2, f3, 0) + IsoSprite.globalOffsetX;
        float f5 = IsoUtils.YToScreen(f, f2, f3, 0) + IsoSprite.globalOffsetY;
        SpriteRenderer.instance.render(texture, f4 -= (float)(32 * Core.TileScale), f5 -= (float)(96 * Core.TileScale), 64 * Core.TileScale, 128 * Core.TileScale, 0.0f, 0.5f, 0.0f, 0.75f, null);
    }

    public static class TreeShader {
        public static final TreeShader instance = new TreeShader();
        private ShaderProgram shaderProgram;
        private int stepSize;
        private int outlineColor;

        public void initShader() {
            this.shaderProgram = ShaderProgram.createShaderProgram("tree", false, true);
            if (this.shaderProgram.isCompiled()) {
                this.stepSize = ARBShaderObjects.glGetUniformLocationARB((int)this.shaderProgram.getShaderID(), (CharSequence)"stepSize");
                this.outlineColor = ARBShaderObjects.glGetUniformLocationARB((int)this.shaderProgram.getShaderID(), (CharSequence)"outlineColor");
                ARBShaderObjects.glUseProgramObjectARB((int)this.shaderProgram.getShaderID());
                ARBShaderObjects.glUniform2fARB((int)this.stepSize, (float)0.001f, (float)0.001f);
                ARBShaderObjects.glUseProgramObjectARB((int)0);
            }
        }

        public void setOutlineColor(float f, float f2, float f3, float f4) {
            SpriteRenderer.instance.ShaderUpdate4f(this.shaderProgram.getShaderID(), this.outlineColor, f, f2, f3, f4);
        }

        public void setStepSize(float f, int n, int n2) {
            SpriteRenderer.instance.ShaderUpdate2f(this.shaderProgram.getShaderID(), this.stepSize, f / (float)n, f / (float)n2);
        }

        public boolean StartShader() {
            if (this.shaderProgram == null) {
                RenderThread.invokeOnRenderContext(this::initShader);
            }
            if (this.shaderProgram.isCompiled()) {
                IndieGL.StartShader(this.shaderProgram.getShaderID(), 0);
                return true;
            }
            return false;
        }
    }
}

