/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.RainManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;

public class IsoRainSplash
extends IsoObject {
    public int Age;

    @Override
    public boolean Serialize() {
        return false;
    }

    public IsoRainSplash(IsoCell isoCell, IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.HasRainSplashes)) {
            return;
        }
        this.Age = 0;
        this.square = isoGridSquare;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        int n = 1 + Rand.Next(2);
        int n2 = 16;
        int n3 = 8;
        for (int i = 0; i < n; ++i) {
            float f = Rand.Next(0.1f, 0.9f);
            float f2 = Rand.Next(0.1f, 0.9f);
            short s = (short)(IsoUtils.XToScreen(f, f2, 0.0f, 0) - (float)(n2 / 2));
            short s2 = (short)(IsoUtils.YToScreen(f, f2, 0.0f, 0) - (float)(n3 / 2));
            this.AttachAnim("RainSplash", "00", 4, RainManager.RainSplashAnimDelay, -s, -s2, true, 0, false, 0.7f, RainManager.RainSplashTintMod);
            ((IsoSpriteInstance)this.AttachedAnimSprite.get((int)i)).Frame = (short)Rand.Next(4);
            ((IsoSpriteInstance)this.AttachedAnimSprite.get(i)).setScale(Core.TileScale, Core.TileScale);
        }
        isoGridSquare.getProperties().Set(IsoFlagType.HasRainSplashes);
        RainManager.AddRainSplash(this);
    }

    @Override
    public String getObjectName() {
        return "RainSplashes";
    }

    @Override
    public boolean HasTooltip() {
        return false;
    }

    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare) {
        return this.square == isoGridSquare;
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return IsoObject.VisionResult.NoEffect;
    }

    public void ChangeTintMod(ColorInfo colorInfo) {
        if (this.AttachedAnimSprite != null) {
            for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
            }
        }
    }

    @Override
    public void update() {
        int n;
        this.sy = 0.0f;
        this.sx = 0.0f;
        ++this.Age;
        for (n = 0; n < this.AttachedAnimSprite.size(); ++n) {
            IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(n);
            IsoSprite isoSprite = isoSpriteInstance.parentSprite;
            isoSpriteInstance.update();
            isoSpriteInstance.Frame += isoSpriteInstance.AnimFrameIncrease * (GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f);
            if ((int)isoSpriteInstance.Frame < isoSprite.CurrentAnim.Frames.size() || !isoSprite.Loop || !isoSpriteInstance.Looped) continue;
            isoSpriteInstance.Frame = 0.0f;
        }
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null) {
                this.setAlphaAndTarget(n, 0.25f);
                continue;
            }
            this.setAlphaAndTarget(n, 0.6f);
        }
    }

    void Reset(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return;
        }
        if (isoGridSquare.getProperties().Is(IsoFlagType.HasRainSplashes)) {
            return;
        }
        this.Age = 0;
        this.square = isoGridSquare;
        int n = 1 + Rand.Next(2);
        if (this.AttachedAnimSprite != null) {
            for (int i = 0; i < this.AttachedAnimSprite.size(); ++i) {
            }
        }
        isoGridSquare.getProperties().Set(IsoFlagType.HasRainSplashes);
        RainManager.AddRainSplash(this);
    }
}

