/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCell;
import zombie.iso.IsoPhysicsObject;
import zombie.iso.objects.IsoTrap;
import zombie.network.GameClient;

public class IsoMolotovCocktail
extends IsoPhysicsObject {
    private HandWeapon weapon = null;
    private IsoGameCharacter character = null;
    private int timer = 0;
    private int explodeTimer = 0;

    @Override
    public String getObjectName() {
        return "MolotovCocktail";
    }

    public IsoMolotovCocktail(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoMolotovCocktail(IsoCell isoCell, float f, float f2, float f3, float f4, float f5, HandWeapon handWeapon, IsoGameCharacter isoGameCharacter) {
        super(isoCell);
        this.weapon = handWeapon;
        this.character = isoGameCharacter;
        this.explodeTimer = handWeapon.getTriggerExplosionTimer();
        this.velX = f4;
        this.velY = f5;
        float f6 = (float)Rand.Next(4000) / 10000.0f;
        float f7 = (float)Rand.Next(4000) / 10000.0f;
        this.velX += (f6 -= 0.2f);
        this.velY += (f7 -= 0.2f);
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.nx = f;
        this.ny = f2;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.terminalVelocity = -0.02f;
        Texture texture = this.sprite.LoadFrameExplicit(handWeapon.getTex().getName());
        if (texture != null) {
            this.sprite.Animate = false;
            int n = Core.TileScale;
            this.sprite.def.scaleAspect(texture.getWidthOrig(), texture.getHeightOrig(), 16 * n, 16 * n);
        }
        this.speedMod = 0.6f;
    }

    public void collideCharacter() {
        if (this.explodeTimer == 0) {
            this.Explode();
        }
    }

    @Override
    public void collideGround() {
        if (this.explodeTimer == 0) {
            this.Explode();
        }
    }

    @Override
    public void collideWall() {
        if (this.explodeTimer == 0) {
            this.Explode();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.isCollidedThisFrame() && this.explodeTimer == 0) {
            this.Explode();
        }
        if (this.explodeTimer > 0) {
            ++this.timer;
            if (this.timer >= this.explodeTimer) {
                this.Explode();
            }
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
        if (Core.bDebug) {
            // empty if block
        }
    }

    void Explode() {
        this.setDestroyed(true);
        this.getCurrentSquare().getMovingObjects().remove(this);
        this.getCell().Remove(this);
        if (GameClient.bClient) {
            if (this.character instanceof IsoPlayer && ((IsoPlayer)this.character).isLocalPlayer()) {
                this.square.syncIsoTrap(this.weapon);
            } else {
                return;
            }
        }
        if (this.weapon.isInstantExplosion()) {
            IsoTrap isoTrap = new IsoTrap(this.weapon, this.getCurrentSquare().getCell(), this.getCurrentSquare());
            this.getCurrentSquare().AddTileObject(isoTrap);
            isoTrap.triggerExplosion(false);
        }
    }
}

