/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.characters.WornItems.BodyLocations;
import zombie.characters.WornItems.WornItems;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.Shader;
import zombie.core.skinnedmodel.DeadBodyAtlas;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AnimNode;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.core.skinnedmodel.advancedanimation.AnimatedModel;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugLog;
import zombie.gameStates.GameLoadingState;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Moveable;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SliceY;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.MannequinScript;
import zombie.scripting.objects.ModelScript;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public class IsoMannequin
extends IsoObject
implements IHumanVisual {
    private static final ColorInfo inf = new ColorInfo();
    private boolean bInit = false;
    private boolean bFemale = false;
    private boolean bZombie = false;
    private boolean bSkeleton = false;
    private String mannequinScriptName = null;
    private String modelScriptName = null;
    private String textureName = null;
    private String animSet = null;
    private String animState = null;
    private String pose = null;
    private String outfit = null;
    private final HumanVisual humanVisual = new HumanVisual(this);
    private final ItemVisuals itemVisuals = new ItemVisuals();
    private final WornItems wornItems;
    private MannequinScript mannequinScript = null;
    private ModelScript modelScript = null;
    private final PerPlayer[] perPlayer = new PerPlayer[4];
    private boolean bAnimate = false;
    private AnimatedModel animatedModel = null;
    private Drawer[] drawers = null;
    private float screenX;
    private float screenY;
    private static final StaticPerPlayer[] staticPerPlayer = new StaticPerPlayer[4];

    public IsoMannequin(IsoCell isoCell) {
        super(isoCell);
        this.wornItems = new WornItems(BodyLocations.getGroup("Human"));
        for (int i = 0; i < 4; ++i) {
            this.perPlayer[i] = new PerPlayer();
        }
    }

    public IsoMannequin(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite) {
        super(isoCell, isoGridSquare, isoSprite);
        this.wornItems = new WornItems(BodyLocations.getGroup("Human"));
        for (int i = 0; i < 4; ++i) {
            this.perPlayer[i] = new PerPlayer();
        }
    }

    @Override
    public String getObjectName() {
        return "Mannequin";
    }

    @Override
    public HumanVisual getHumanVisual() {
        return this.humanVisual;
    }

    @Override
    public void getItemVisuals(ItemVisuals itemVisuals) {
        this.wornItems.getItemVisuals(itemVisuals);
    }

    @Override
    public boolean isFemale() {
        return this.bFemale;
    }

    @Override
    public boolean isZombie() {
        return this.bZombie;
    }

    @Override
    public boolean isSkeleton() {
        return this.bSkeleton;
    }

    @Override
    public boolean isItemAllowedInContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        if (inventoryItem instanceof Clothing && !StringUtils.isNullOrWhitespace(((Clothing)inventoryItem).getBodyLocation())) {
            return true;
        }
        return inventoryItem instanceof InventoryContainer && !StringUtils.isNullOrWhitespace(((InventoryContainer)inventoryItem).canBeEquipped());
    }

    public String getMannequinScriptName() {
        return this.mannequinScriptName;
    }

    public void setMannequinScriptName(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        if (ScriptManager.instance.getMannequinScript(string) == null) {
            return;
        }
        this.mannequinScriptName = string;
        this.bInit = true;
        this.mannequinScript = null;
        this.textureName = null;
        this.animSet = null;
        this.animState = null;
        this.pose = null;
        this.outfit = null;
        this.humanVisual.clear();
        this.itemVisuals.clear();
        this.wornItems.clear();
        this.initMannequinScript();
        this.initModelScript();
        if (this.outfit == null) {
            Outfit outfit = OutfitManager.instance.GetRandomNonProfessionalOutfit(this.bFemale);
            this.humanVisual.dressInNamedOutfit(outfit.m_Name, this.itemVisuals);
        } else if (!"none".equalsIgnoreCase(this.outfit)) {
            this.humanVisual.dressInNamedOutfit(this.outfit, this.itemVisuals);
        }
        this.humanVisual.setHairModel("");
        this.humanVisual.setBeardModel("");
        this.createInventory(this.itemVisuals);
        this.validateSkinTexture();
        this.validatePose();
        this.syncModel();
    }

    public String getPose() {
        return this.pose;
    }

    public void setRenderDirection(IsoDirections isoDirections) {
        int n = IsoCamera.frameState.playerIndex;
        if (isoDirections == this.perPlayer[n].renderDirection) {
            return;
        }
        this.perPlayer[n].renderDirection = isoDirections;
    }

    public void rotate(IsoDirections isoDirections) {
        if (isoDirections == null || isoDirections == IsoDirections.Max) {
            return;
        }
        this.dir = isoDirections;
        for (int i = 0; i < 4; ++i) {
            this.perPlayer[i].atlasTex = null;
        }
        if (GameServer.bServer) {
            this.sendObjectChange("rotate");
        }
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("rotate".equals(string)) {
            byteBuffer.put((byte)this.dir.index());
        } else {
            super.saveChange(string, kahluaTable, byteBuffer);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("rotate".equals(string)) {
            byte by = byteBuffer.get();
            this.rotate(IsoDirections.fromIndex(by));
        } else {
            super.loadChange(string, byteBuffer);
        }
    }

    public void getVariables(Map<String, String> map) {
        map.put("Female", this.bFemale ? "true" : "false");
        map.put("Pose", this.getPose());
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        block6: {
            super.load(byteBuffer, n, bl);
            this.dir = IsoDirections.fromIndex(byteBuffer.get());
            this.bInit = byteBuffer.get() == 1;
            this.bFemale = byteBuffer.get() == 1;
            this.bZombie = byteBuffer.get() == 1;
            boolean bl2 = this.bSkeleton = byteBuffer.get() == 1;
            if (n >= 191) {
                this.mannequinScriptName = GameWindow.ReadString(byteBuffer);
            }
            this.pose = GameWindow.ReadString(byteBuffer);
            this.humanVisual.load(byteBuffer, n);
            this.textureName = this.humanVisual.getSkinTexture();
            this.wornItems.clear();
            if (this.container == null) {
                this.container = new ItemContainer("mannequin", this.getSquare(), this);
                this.container.setExplored(true);
            }
            this.container.clear();
            if (byteBuffer.get() == 1) {
                try {
                    this.container.ID = byteBuffer.getInt();
                    ArrayList<InventoryItem> arrayList = this.container.load(byteBuffer, n);
                    int n2 = byteBuffer.get();
                    for (int i = 0; i < n2; ++i) {
                        String string = GameWindow.ReadString(byteBuffer);
                        short s = byteBuffer.getShort();
                        if (s < 0 || s >= arrayList.size() || this.wornItems.getBodyLocationGroup().getLocation(string) == null) continue;
                        this.wornItems.setItem(string, arrayList.get(s));
                    }
                }
                catch (Exception exception) {
                    if (this.container == null) break block6;
                    DebugLog.log("Failed to stream in container ID: " + this.container.ID);
                }
            }
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        ItemContainer itemContainer = this.container;
        this.container = null;
        super.save(byteBuffer, bl);
        this.container = itemContainer;
        byteBuffer.put((byte)this.dir.index());
        byteBuffer.put(this.bInit ? (byte)1 : 0);
        byteBuffer.put(this.bFemale ? (byte)1 : 0);
        byteBuffer.put(this.bZombie ? (byte)1 : 0);
        byteBuffer.put(this.bSkeleton ? (byte)1 : 0);
        GameWindow.WriteString(byteBuffer, this.mannequinScriptName);
        GameWindow.WriteString(byteBuffer, this.pose);
        this.humanVisual.save(byteBuffer);
        if (itemContainer != null) {
            byteBuffer.put((byte)1);
            byteBuffer.putInt(itemContainer.ID);
            ArrayList<InventoryItem> arrayList = itemContainer.save(byteBuffer);
            if (this.wornItems.size() > 127) {
                throw new RuntimeException("too many worn items");
            }
            byteBuffer.put((byte)this.wornItems.size());
            this.wornItems.forEach(wornItem -> {
                GameWindow.WriteString(byteBuffer, wornItem.getLocation());
                byteBuffer.putShort((short)arrayList.indexOf(wornItem.getItem()));
            });
        } else {
            byteBuffer.put((byte)0);
        }
    }

    @Override
    public void saveState(ByteBuffer byteBuffer) throws IOException {
        if (!this.bInit) {
            this.initOutfit();
        }
        this.save(byteBuffer);
    }

    @Override
    public void loadState(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.get();
        byteBuffer.get();
        this.load(byteBuffer, 195);
        this.initOutfit();
        this.validateSkinTexture();
        this.validatePose();
        this.syncModel();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.initOutfit();
        this.validateSkinTexture();
        this.validatePose();
        this.syncModel();
    }

    private void initMannequinScript() {
        if (!StringUtils.isNullOrWhitespace(this.mannequinScriptName)) {
            this.mannequinScript = ScriptManager.instance.getMannequinScript(this.mannequinScriptName);
        }
        if (this.mannequinScript == null) {
            this.modelScriptName = this.bFemale ? "FemaleBody" : "MaleBody";
            this.textureName = this.bFemale ? "F_Mannequin_White" : "M_Mannequin_White";
            this.animSet = "mannequin";
            this.animState = this.bFemale ? "female" : "male";
            this.outfit = null;
        } else {
            this.bFemale = this.mannequinScript.isFemale();
            this.modelScriptName = this.mannequinScript.getModelScriptName();
            if (this.textureName == null) {
                this.textureName = this.mannequinScript.getTexture();
            }
            this.animSet = this.mannequinScript.getAnimSet();
            this.animState = this.mannequinScript.getAnimState();
            if (this.pose == null) {
                this.pose = this.mannequinScript.getPose();
            }
            if (this.outfit == null) {
                this.outfit = this.mannequinScript.getOutfit();
            }
        }
    }

    private void initModelScript() {
        if (!StringUtils.isNullOrWhitespace(this.modelScriptName)) {
            this.modelScript = ScriptManager.instance.getModelScript(this.modelScriptName);
        }
    }

    private void validateSkinTexture() {
    }

    private void validatePose() {
        AnimationSet animationSet = AnimationSet.GetAnimationSet(this.animSet, false);
        if (animationSet == null) {
            DebugLog.General.warn("ERROR: mannequin AnimSet \"%s\" doesn't exist", this.animSet);
            this.pose = "Invalid";
            return;
        }
        AnimState animState = animationSet.GetState(this.animState);
        if (animState == null) {
            DebugLog.General.warn("ERROR: mannequin AnimSet \"%s\" state \"%s\" doesn't exist", this.animSet, this.animState);
            this.pose = "Invalid";
            return;
        }
        for (AnimNode animNode : animState.m_Nodes) {
            if (!animNode.m_Name.equalsIgnoreCase(this.pose)) continue;
            return;
        }
        if (animState.m_Nodes == null) {
            DebugLog.General.warn("ERROR: mannequin AnimSet \"%s\" state \"%s\" node \"%s\" doesn't exist", this.animSet, this.animState, this.pose);
            this.pose = "Invalid";
            return;
        }
        AnimNode animNode = PZArrayUtil.pickRandom(animState.m_Nodes);
        this.pose = animNode.m_Name;
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        int n = IsoCamera.frameState.playerIndex;
        this.calcScreenPos(f += 0.5f, f2 += 0.5f, f3);
        this.renderShadow(f, f2, f3);
        if (this.bAnimate) {
            this.animatedModel.update();
            Drawer drawer = this.drawers[SpriteRenderer.instance.getMainStateIndex()];
            drawer.init(f, f2, f3);
            SpriteRenderer.instance.drawGeneric(drawer);
            return;
        }
        IsoDirections isoDirections = this.dir;
        PerPlayer perPlayer = this.perPlayer[n];
        if (perPlayer.renderDirection != null && perPlayer.renderDirection != IsoDirections.Max) {
            this.dir = perPlayer.renderDirection;
            perPlayer.renderDirection = null;
            perPlayer.bWasRenderDirection = true;
            perPlayer.atlasTex = null;
        } else if (perPlayer.bWasRenderDirection) {
            perPlayer.bWasRenderDirection = false;
            perPlayer.atlasTex = null;
        }
        if (perPlayer.atlasTex == null) {
            perPlayer.atlasTex = DeadBodyAtlas.instance.getBodyTexture(this);
            DeadBodyAtlas.instance.render();
        }
        this.dir = isoDirections;
        if (perPlayer.atlasTex != null) {
            if (this.isHighlighted()) {
                IsoMannequin.inf.r = this.getHighlightColor().r;
                IsoMannequin.inf.g = this.getHighlightColor().g;
                IsoMannequin.inf.b = this.getHighlightColor().b;
                IsoMannequin.inf.a = this.getHighlightColor().a;
            } else {
                IsoMannequin.inf.r = colorInfo.r;
                IsoMannequin.inf.g = colorInfo.g;
                IsoMannequin.inf.b = colorInfo.b;
                IsoMannequin.inf.a = colorInfo.a;
            }
            colorInfo = inf;
            if (!this.isHighlighted() && PerformanceSettings.LightingFrameSkip < 3) {
                this.square.interpolateLight(colorInfo, f - (float)this.square.getX(), f2 - (float)this.square.getY());
            }
            perPlayer.atlasTex.render((int)this.screenX, (int)this.screenY, colorInfo.r, colorInfo.g, colorInfo.b, this.getAlpha(n));
            if (Core.bDebug) {
                // empty if block
            }
        }
    }

    @Override
    public void renderFxMask(float f, float f2, float f3, boolean bl) {
    }

    private void calcScreenPos(float f, float f2, float f3) {
        if (IsoSprite.globalOffsetX == -1.0f) {
            IsoSprite.globalOffsetX = -IsoCamera.frameState.OffX;
            IsoSprite.globalOffsetY = -IsoCamera.frameState.OffY;
        }
        this.screenX = IsoUtils.XToScreen(f, f2, f3, 0);
        this.screenY = IsoUtils.YToScreen(f, f2, f3, 0);
        this.sx = this.screenX;
        this.sy = this.screenY;
        this.screenX = this.sx + IsoSprite.globalOffsetX;
        this.screenY = this.sy + IsoSprite.globalOffsetY;
        IsoObject[] isoObjectArray = this.square.getObjects().getElements();
        for (int i = 0; i < this.square.getObjects().size(); ++i) {
            IsoObject isoObject = isoObjectArray[i];
            if (!isoObject.isTableSurface()) continue;
            this.screenY -= (isoObject.getSurfaceOffset() + 1.0f) * (float)Core.TileScale;
        }
    }

    private void renderShadow(float f, float f2, float f3) {
        Texture texture = Texture.getSharedTexture("dropshadow");
        int n = IsoCamera.frameState.playerIndex;
        float f4 = 0.8f * this.getAlpha(n);
        ColorInfo colorInfo = this.square.lighting[n].lightInfo();
        f4 *= (colorInfo.r + colorInfo.g + colorInfo.b) / 3.0f;
        float f5 = this.screenX - (float)texture.getWidth() / 2.0f * (float)Core.TileScale;
        float f6 = this.screenY - (float)texture.getHeight() / 2.0f * (float)Core.TileScale;
        SpriteRenderer.instance.render(texture, f5, f6, (float)texture.getWidth() * (float)Core.TileScale, (float)texture.getHeight() * (float)Core.TileScale, 1.0f, 1.0f, 1.0f, f4 *= 0.8f, null);
    }

    private void initOutfit() {
        if (this.bInit) {
            this.initMannequinScript();
            this.initModelScript();
            return;
        }
        this.bInit = true;
        this.getPropertiesFromSprite();
        this.getPropertiesFromZone();
        this.initMannequinScript();
        this.initModelScript();
        if (this.outfit == null) {
            Outfit outfit = OutfitManager.instance.GetRandomNonProfessionalOutfit(this.bFemale);
            this.humanVisual.dressInNamedOutfit(outfit.m_Name, this.itemVisuals);
        } else if (!"none".equalsIgnoreCase(this.outfit)) {
            this.humanVisual.dressInNamedOutfit(this.outfit, this.itemVisuals);
        }
        this.humanVisual.setHairModel("");
        this.humanVisual.setBeardModel("");
        this.createInventory(this.itemVisuals);
    }

    private void getPropertiesFromSprite() {
        switch (this.sprite.name) {
            case "location_shop_mall_01_65": {
                this.mannequinScriptName = "FemaleWhite01";
                this.dir = IsoDirections.SE;
                break;
            }
            case "location_shop_mall_01_66": {
                this.mannequinScriptName = "FemaleWhite02";
                this.dir = IsoDirections.S;
                break;
            }
            case "location_shop_mall_01_67": {
                this.mannequinScriptName = "FemaleWhite03";
                this.dir = IsoDirections.SE;
                break;
            }
            case "location_shop_mall_01_68": {
                this.mannequinScriptName = "MaleWhite01";
                this.dir = IsoDirections.SE;
                break;
            }
            case "location_shop_mall_01_69": {
                this.mannequinScriptName = "MaleWhite02";
                this.dir = IsoDirections.S;
                break;
            }
            case "location_shop_mall_01_70": {
                this.mannequinScriptName = "MaleWhite03";
                this.dir = IsoDirections.SE;
                break;
            }
            case "location_shop_mall_01_73": {
                this.mannequinScriptName = "FemaleBlack01";
                this.dir = IsoDirections.SE;
                break;
            }
            case "location_shop_mall_01_74": {
                this.mannequinScriptName = "FemaleBlack02";
                this.dir = IsoDirections.S;
                break;
            }
            case "location_shop_mall_01_75": {
                this.mannequinScriptName = "FemaleBlack03";
                this.dir = IsoDirections.SE;
                break;
            }
            case "location_shop_mall_01_76": {
                this.mannequinScriptName = "MaleBlack01";
                this.dir = IsoDirections.SE;
                break;
            }
            case "location_shop_mall_01_77": {
                this.mannequinScriptName = "MaleBlack02";
                this.dir = IsoDirections.S;
                break;
            }
            case "location_shop_mall_01_78": {
                this.mannequinScriptName = "MaleBlack03";
                this.dir = IsoDirections.SE;
            }
        }
    }

    private void getPropertiesFromZone() {
        if (this.getObjectIndex() == -1) {
            return;
        }
        IsoMetaCell isoMetaCell = IsoWorld.instance.getMetaGrid().getCellData(this.square.x / 300, this.square.y / 300);
        if (isoMetaCell == null || isoMetaCell.mannequinZones == null) {
            return;
        }
        ArrayList<MannequinZone> arrayList = isoMetaCell.mannequinZones;
        MannequinZone mannequinZone = null;
        for (int i = 0; i < arrayList.size() && !(mannequinZone = arrayList.get(i)).contains(this.square.x, this.square.y, this.square.z); ++i) {
            mannequinZone = null;
        }
        if (mannequinZone == null) {
            return;
        }
        if (mannequinZone.bFemale != -1) {
            boolean bl = this.bFemale = mannequinZone.bFemale == 1;
        }
        if (mannequinZone.dir != IsoDirections.Max) {
            this.dir = mannequinZone.dir;
        }
        if (mannequinZone.mannequinScript != null) {
            this.mannequinScriptName = mannequinZone.mannequinScript;
        }
        if (mannequinZone.skin != null) {
            this.textureName = mannequinZone.skin;
        }
        if (mannequinZone.pose != null) {
            this.pose = mannequinZone.pose;
        }
        if (mannequinZone.outfit != null) {
            this.outfit = mannequinZone.outfit;
        }
    }

    private void syncModel() {
        int n;
        this.humanVisual.setForceModelScript(this.modelScriptName);
        switch (this.modelScriptName) {
            case "FemaleBody": {
                this.humanVisual.setForceModel(ModelManager.instance.m_femaleModel);
                break;
            }
            case "MaleBody": {
                this.humanVisual.setForceModel(ModelManager.instance.m_maleModel);
                break;
            }
            default: {
                this.humanVisual.setForceModel(ModelManager.instance.getLoadedModel(this.modelScriptName));
            }
        }
        this.humanVisual.setSkinTextureName(this.textureName);
        this.wornItems.getItemVisuals(this.itemVisuals);
        for (n = 0; n < 4; ++n) {
            this.perPlayer[n].atlasTex = null;
        }
        if (this.bAnimate) {
            if (this.animatedModel == null) {
                this.animatedModel = new AnimatedModel();
                this.drawers = new Drawer[3];
                for (n = 0; n < this.drawers.length; ++n) {
                    this.drawers[n] = new Drawer();
                }
            }
            this.animatedModel.setAnimSetName(this.getAnimSetName());
            this.animatedModel.setState(this.getAnimStateName());
            this.animatedModel.setVariable("Female", this.bFemale);
            this.animatedModel.setVariable("Pose", this.getPose());
            this.animatedModel.setAngle(this.dir.ToVector());
            this.animatedModel.setModelData(this.humanVisual, this.itemVisuals);
        }
    }

    private void createInventory(ItemVisuals itemVisuals) {
        if (this.container == null) {
            this.container = new ItemContainer("mannequin", this.getSquare(), this);
            this.container.setExplored(true);
        }
        this.container.clear();
        this.wornItems.setFromItemVisuals(itemVisuals);
        this.wornItems.addItemsToItemContainer(this.container);
    }

    public void wearItem(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter) {
        if (!this.container.contains(inventoryItem)) {
            return;
        }
        ItemVisual itemVisual = inventoryItem.getVisual();
        if (itemVisual == null) {
            return;
        }
        if (inventoryItem instanceof Clothing && !StringUtils.isNullOrWhitespace(((Clothing)inventoryItem).getBodyLocation())) {
            this.wornItems.setItem(((Clothing)inventoryItem).getBodyLocation(), inventoryItem);
        } else if (inventoryItem instanceof InventoryContainer && !StringUtils.isNullOrWhitespace(((InventoryContainer)inventoryItem).canBeEquipped())) {
            this.wornItems.setItem(((InventoryContainer)inventoryItem).canBeEquipped(), inventoryItem);
        } else {
            return;
        }
        if (isoGameCharacter != null) {
            ArrayList<InventoryItem> arrayList = this.container.getItems();
            for (int i = 0; i < arrayList.size(); ++i) {
                InventoryItem inventoryItem2 = arrayList.get(i);
                if (this.wornItems.contains(inventoryItem2)) continue;
                this.container.removeItemOnServer(inventoryItem2);
                this.container.Remove(inventoryItem2);
                isoGameCharacter.getInventory().AddItem(inventoryItem2);
                --i;
            }
        }
        this.syncModel();
    }

    public void checkClothing(InventoryItem inventoryItem) {
        for (int i = 0; i < this.wornItems.size(); ++i) {
            InventoryItem inventoryItem2 = this.wornItems.getItemByIndex(i);
            if (this.container != null && this.container.getItems().indexOf(inventoryItem2) != -1) continue;
            this.wornItems.remove(inventoryItem2);
            this.syncModel();
            --i;
        }
    }

    public String getAnimSetName() {
        return this.animSet;
    }

    public String getAnimStateName() {
        return this.animState;
    }

    public void getCustomSettingsFromItem(InventoryItem inventoryItem) throws IOException {
        if (inventoryItem instanceof Moveable) {
            ByteBuffer byteBuffer = inventoryItem.getByteData();
            if (byteBuffer == null) {
                return;
            }
            byteBuffer.rewind();
            int n = byteBuffer.getInt();
            byteBuffer.get();
            byteBuffer.get();
            this.load(byteBuffer, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomSettingsToItem(InventoryItem inventoryItem) throws IOException {
        if (inventoryItem instanceof Moveable) {
            Object object = SliceY.SliceBufferLock;
            synchronized (object) {
                ByteBuffer byteBuffer = SliceY.SliceBuffer;
                byteBuffer.clear();
                byteBuffer.putInt(195);
                this.save(byteBuffer);
                byteBuffer.flip();
                inventoryItem.byteData = ByteBuffer.allocate(byteBuffer.limit());
                inventoryItem.byteData.put(byteBuffer);
            }
            if (this.container != null) {
                inventoryItem.setActualWeight(inventoryItem.getActualWeight() + this.container.getContentsWeight());
            }
        }
    }

    public static boolean isMannequinSprite(IsoSprite isoSprite) {
        return "Mannequin".equals(isoSprite.getProperties().Val("CustomName"));
    }

    private void resetMannequin() {
        this.bInit = false;
        this.bFemale = false;
        this.bZombie = false;
        this.bSkeleton = false;
        this.mannequinScriptName = null;
        this.modelScriptName = null;
        this.textureName = null;
        this.animSet = null;
        this.animState = null;
        this.pose = null;
        this.outfit = null;
        this.humanVisual.clear();
        this.itemVisuals.clear();
        this.wornItems.clear();
        this.mannequinScript = null;
        this.modelScript = null;
        this.bAnimate = false;
    }

    public static void renderMoveableItem(Moveable moveable, int n, int n2, int n3, IsoDirections isoDirections) {
        int n4 = IsoCamera.frameState.playerIndex;
        StaticPerPlayer staticPerPlayer = IsoMannequin.staticPerPlayer[n4];
        if (staticPerPlayer == null) {
            staticPerPlayer = IsoMannequin.staticPerPlayer[n4] = new StaticPerPlayer(n4);
        }
        staticPerPlayer.renderMoveableItem(moveable, n, n2, n3, isoDirections);
    }

    public static void renderMoveableObject(IsoMannequin isoMannequin, int n, int n2, int n3, IsoDirections isoDirections) {
        isoMannequin.setRenderDirection(isoDirections);
    }

    public static IsoDirections getDirectionFromItem(Moveable moveable, int n) {
        StaticPerPlayer staticPerPlayer = IsoMannequin.staticPerPlayer[n];
        if (staticPerPlayer == null) {
            staticPerPlayer = IsoMannequin.staticPerPlayer[n] = new StaticPerPlayer(n);
        }
        return staticPerPlayer.getDirectionFromItem(moveable);
    }

    private static final class PerPlayer {
        private DeadBodyAtlas.BodyTexture atlasTex = null;
        IsoDirections renderDirection = null;
        boolean bWasRenderDirection = false;

        private PerPlayer() {
        }
    }

    private final class Drawer
    extends TextureDraw.GenericDrawer {
        float x;
        float y;
        float z;
        float m_animPlayerAngle;
        boolean bRendered;

        private Drawer() {
        }

        public void init(float f, float f2, float f3) {
            this.x = f;
            this.y = f2;
            this.z = f3;
            this.bRendered = false;
            IsoMannequin.this.animatedModel.renderMain();
            this.m_animPlayerAngle = IsoMannequin.this.animatedModel.getAnimationPlayer().getRenderedAngle();
        }

        @Override
        public void render() {
            IsoMannequin.this.animatedModel.DoRenderToWorld(this.x, this.y, this.z, this.m_animPlayerAngle);
            this.bRendered = true;
        }

        @Override
        public void postRender() {
            IsoMannequin.this.animatedModel.postRender(this.bRendered);
        }
    }

    public static final class MannequinZone
    extends IsoMetaGrid.Zone {
        public int bFemale = -1;
        public IsoDirections dir = IsoDirections.Max;
        public String mannequinScript = null;
        public String pose = null;
        public String skin = null;
        public String outfit = null;

        public MannequinZone(String string, String string2, int n, int n2, int n3, int n4, int n5, KahluaTable kahluaTable) {
            super(string, string2, n, n2, n3, n4, n5);
            if (kahluaTable != null) {
                Object object = kahluaTable.rawget("Female");
                if (object instanceof Boolean) {
                    int n6 = this.bFemale = object == Boolean.TRUE ? 1 : 0;
                }
                if ((object = kahluaTable.rawget("Direction")) instanceof String) {
                    this.dir = IsoDirections.valueOf((String)object);
                }
                if ((object = kahluaTable.rawget("Outfit")) instanceof String) {
                    this.outfit = (String)object;
                }
                if ((object = kahluaTable.rawget("Script")) instanceof String) {
                    this.mannequinScript = (String)object;
                }
                if ((object = kahluaTable.rawget("Skin")) instanceof String) {
                    this.skin = (String)object;
                }
                if ((object = kahluaTable.rawget("Pose")) instanceof String) {
                    this.pose = (String)object;
                }
            }
        }
    }

    private static final class StaticPerPlayer {
        final int playerIndex;
        Moveable _moveable = null;
        Moveable _failedItem = null;
        IsoMannequin _mannequin = null;

        StaticPerPlayer(int n) {
            this.playerIndex = n;
        }

        void renderMoveableItem(Moveable moveable, int n, int n2, int n3, IsoDirections isoDirections) {
            if (!this.checkItem(moveable)) {
                return;
            }
            if (this._moveable != moveable) {
                this._moveable = moveable;
                try {
                    this._mannequin.getCustomSettingsFromItem(this._moveable);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._mannequin.initOutfit();
                this._mannequin.validateSkinTexture();
                this._mannequin.validatePose();
                this._mannequin.syncModel();
                this._mannequin.perPlayer[this.playerIndex].atlasTex = null;
            }
            this._mannequin.square = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
            if (this._mannequin.square == null) {
                return;
            }
            this._mannequin.perPlayer[this.playerIndex].renderDirection = isoDirections;
            inf.set(1.0f, 1.0f, 1.0f, 1.0f);
            this._mannequin.render(n, n2, n3, inf, false, false, null);
        }

        IsoDirections getDirectionFromItem(Moveable moveable) {
            if (!this.checkItem(moveable)) {
                return IsoDirections.S;
            }
            this._moveable = null;
            try {
                this._mannequin.getCustomSettingsFromItem(moveable);
                return this._mannequin.getDir();
            }
            catch (Exception exception) {
                return IsoDirections.S;
            }
        }

        boolean checkItem(Moveable moveable) {
            if (moveable == null) {
                return false;
            }
            String string = moveable.getWorldSprite();
            IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(string);
            if (isoSprite == null || !IsoMannequin.isMannequinSprite(isoSprite)) {
                return false;
            }
            if (moveable.getByteData() == null) {
                Thread thread = Thread.currentThread();
                if (thread != GameWindow.GameThread && thread != GameLoadingState.loader && thread == GameServer.MainThread) {
                    return false;
                }
                if (this._mannequin == null || this._mannequin.getCell() != IsoWorld.instance.CurrentCell) {
                    this._mannequin = new IsoMannequin(IsoWorld.instance.CurrentCell);
                }
                if (this._failedItem == moveable) {
                    return false;
                }
                try {
                    this._mannequin.resetMannequin();
                    this._mannequin.sprite = isoSprite;
                    this._mannequin.initOutfit();
                    this._mannequin.validateSkinTexture();
                    this._mannequin.validatePose();
                    this._mannequin.syncModel();
                    this._mannequin.setCustomSettingsToItem(moveable);
                    return true;
                }
                catch (IOException iOException) {
                    this._failedItem = moveable;
                    return false;
                }
            }
            if (this._mannequin == null || this._mannequin.getCell() != IsoWorld.instance.CurrentCell) {
                this._mannequin = new IsoMannequin(IsoWorld.instance.CurrentCell);
            }
            return true;
        }
    }
}

