/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.SandboxOptions;
import zombie.SystemDisabler;
import zombie.characters.IsoGameCharacter;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.Moveable;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoObject;
import zombie.iso.IsoRoomLight;
import zombie.iso.IsoWorld;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;

public class IsoLightSwitch
extends IsoObject {
    boolean Activated = false;
    public final ArrayList<IsoLightSource> lights = new ArrayList();
    public boolean lightRoom = false;
    public int RoomID = -1;
    public boolean bStreetLight = false;
    private boolean canBeModified = false;
    private boolean useBattery = false;
    private boolean hasBattery = false;
    private String bulbItem = "Base.LightBulb";
    private float power = 0.0f;
    private float delta = 2.5E-4f;
    private float primaryR = 1.0f;
    private float primaryG = 1.0f;
    private float primaryB = 1.0f;
    protected long lastMinuteStamp = -1L;
    protected int bulbBurnMinutes = -1;
    protected int lastMin = 0;
    protected int nextBreakUpdate = 60;

    @Override
    public String getObjectName() {
        return "LightSwitch";
    }

    public IsoLightSwitch(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoLightSwitch(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite, int n) {
        super(isoCell, isoGridSquare, isoSprite);
        this.RoomID = n;
        if (isoSprite != null && isoSprite.getProperties().Is("lightR")) {
            if (isoSprite.getProperties().Is("IsMoveAble")) {
                this.canBeModified = true;
            }
            this.primaryR = Float.parseFloat(isoSprite.getProperties().Val("lightR")) / 255.0f;
            this.primaryG = Float.parseFloat(isoSprite.getProperties().Val("lightG")) / 255.0f;
            this.primaryB = Float.parseFloat(isoSprite.getProperties().Val("lightB")) / 255.0f;
        } else {
            this.lightRoom = true;
        }
        this.bStreetLight = isoSprite != null && isoSprite.getProperties().Is("streetlight");
        IsoRoom isoRoom = this.square.getRoom();
        if (isoRoom != null && this.lightRoom) {
            if (!isoGridSquare.haveElectricity() && !IsoWorld.instance.isHydroPowerOn()) {
                isoRoom.def.bLightsActive = false;
            }
            this.Activated = isoRoom.def.bLightsActive;
            isoRoom.lightSwitches.add(this);
        } else {
            this.Activated = true;
        }
    }

    public void addLightSourceFromSprite() {
        if (this.sprite != null && this.sprite.getProperties().Is("lightR")) {
            float f = Float.parseFloat(this.sprite.getProperties().Val("lightR")) / 255.0f;
            float f2 = Float.parseFloat(this.sprite.getProperties().Val("lightG")) / 255.0f;
            float f3 = Float.parseFloat(this.sprite.getProperties().Val("lightB")) / 255.0f;
            this.Activated = false;
            this.setActive(true, true);
            int n = 10;
            if (this.sprite.getProperties().Is("LightRadius") && Integer.parseInt(this.sprite.getProperties().Val("LightRadius")) > 0) {
                n = Integer.parseInt(this.sprite.getProperties().Val("LightRadius"));
            }
            IsoLightSource isoLightSource = new IsoLightSource(this.square.getX(), this.square.getY(), this.square.getZ(), f, f2, f3, n);
            isoLightSource.bActive = this.Activated;
            isoLightSource.bHydroPowered = true;
            isoLightSource.switches.add(this);
            this.lights.add(isoLightSource);
        }
    }

    public boolean getCanBeModified() {
        return this.canBeModified;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float f) {
        this.power = f;
    }

    public void setDelta(float f) {
        this.delta = f;
    }

    public float getDelta() {
        return this.delta;
    }

    public void setUseBattery(boolean bl) {
        this.setActive(false);
        this.useBattery = bl;
        if (GameClient.bClient) {
            this.syncCustomizedSettings(null);
        }
    }

    public boolean getUseBattery() {
        return this.useBattery;
    }

    public boolean getHasBattery() {
        return this.hasBattery;
    }

    public void setHasBatteryRaw(boolean bl) {
        this.hasBattery = bl;
    }

    public void addBattery(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        if (this.canBeModified && this.useBattery && !this.hasBattery && inventoryItem != null && inventoryItem.getFullType().equals("Base.Battery")) {
            this.power = ((DrainableComboItem)inventoryItem).getUsedDelta();
            this.hasBattery = true;
            isoGameCharacter.removeFromHands(inventoryItem);
            isoGameCharacter.getInventory().Remove(inventoryItem);
            if (GameClient.bClient) {
                this.syncCustomizedSettings(null);
            }
        }
    }

    public DrainableComboItem removeBattery(IsoGameCharacter isoGameCharacter) {
        DrainableComboItem drainableComboItem;
        if (this.canBeModified && this.useBattery && this.hasBattery && (drainableComboItem = (DrainableComboItem)InventoryItemFactory.CreateItem("Base.Battery")) != null) {
            this.hasBattery = false;
            drainableComboItem.setUsedDelta(this.power >= 0.0f ? this.power : 0.0f);
            this.power = 0.0f;
            this.setActive(false, false, true);
            isoGameCharacter.getInventory().AddItem(drainableComboItem);
            if (GameClient.bClient) {
                this.syncCustomizedSettings(null);
            }
            return drainableComboItem;
        }
        return null;
    }

    public boolean hasLightBulb() {
        return this.bulbItem != null;
    }

    public String getBulbItem() {
        return this.bulbItem;
    }

    public void setBulbItemRaw(String string) {
        this.bulbItem = string;
    }

    public void addLightBulb(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        IsoLightSource isoLightSource;
        if (!this.hasLightBulb() && inventoryItem != null && inventoryItem.getType().startsWith("LightBulb") && (isoLightSource = this.getPrimaryLight()) != null) {
            this.setPrimaryR(inventoryItem.getColorRed());
            this.setPrimaryG(inventoryItem.getColorGreen());
            this.setPrimaryB(inventoryItem.getColorBlue());
            this.bulbItem = inventoryItem.getFullType();
            isoGameCharacter.removeFromHands(inventoryItem);
            isoGameCharacter.getInventory().Remove(inventoryItem);
            if (GameClient.bClient) {
                this.syncCustomizedSettings(null);
            }
        }
    }

    public InventoryItem removeLightBulb(IsoGameCharacter isoGameCharacter) {
        InventoryItem inventoryItem;
        IsoLightSource isoLightSource = this.getPrimaryLight();
        if (isoLightSource != null && this.hasLightBulb() && (inventoryItem = InventoryItemFactory.CreateItem(this.bulbItem)) != null) {
            inventoryItem.setColorRed(this.getPrimaryR());
            inventoryItem.setColorGreen(this.getPrimaryG());
            inventoryItem.setColorBlue(this.getPrimaryB());
            inventoryItem.setColor(new Color(isoLightSource.r, isoLightSource.g, isoLightSource.b));
            this.bulbItem = null;
            isoGameCharacter.getInventory().AddItem(inventoryItem);
            this.setActive(false, false, true);
            if (GameClient.bClient) {
                this.syncCustomizedSettings(null);
            }
            return inventoryItem;
        }
        return null;
    }

    private IsoLightSource getPrimaryLight() {
        if (this.lights.size() > 0) {
            return this.lights.get(0);
        }
        return null;
    }

    public float getPrimaryR() {
        return this.getPrimaryLight() != null ? this.getPrimaryLight().r : this.primaryR;
    }

    public float getPrimaryG() {
        return this.getPrimaryLight() != null ? this.getPrimaryLight().g : this.primaryG;
    }

    public float getPrimaryB() {
        return this.getPrimaryLight() != null ? this.getPrimaryLight().b : this.primaryB;
    }

    public void setPrimaryR(float f) {
        this.primaryR = f;
        if (this.getPrimaryLight() != null) {
            this.getPrimaryLight().r = f;
        }
    }

    public void setPrimaryG(float f) {
        this.primaryG = f;
        if (this.getPrimaryLight() != null) {
            this.getPrimaryLight().g = f;
        }
    }

    public void setPrimaryB(float f) {
        this.primaryB = f;
        if (this.getPrimaryLight() != null) {
            this.getPrimaryLight().b = f;
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.lightRoom = byteBuffer.get() == 1;
        this.RoomID = byteBuffer.getInt();
        boolean bl2 = this.Activated = byteBuffer.get() == 1;
        if (n >= 76) {
            boolean bl3 = this.canBeModified = byteBuffer.get() == 1;
            if (this.canBeModified) {
                this.useBattery = byteBuffer.get() == 1;
                this.hasBattery = byteBuffer.get() == 1;
                this.bulbItem = byteBuffer.get() == 1 ? GameWindow.ReadString(byteBuffer) : null;
                this.power = byteBuffer.getFloat();
                this.delta = byteBuffer.getFloat();
                this.setPrimaryR(byteBuffer.getFloat());
                this.setPrimaryG(byteBuffer.getFloat());
                this.setPrimaryB(byteBuffer.getFloat());
            }
        }
        if (n >= 79) {
            this.lastMinuteStamp = byteBuffer.getLong();
            this.bulbBurnMinutes = byteBuffer.getInt();
        }
        boolean bl4 = this.bStreetLight = this.sprite != null && this.sprite.getProperties().Is("streetlight");
        if (this.square == null) {
            return;
        }
        IsoRoom isoRoom = this.square.getRoom();
        if (isoRoom != null && this.lightRoom) {
            this.Activated = isoRoom.def.bLightsActive;
            isoRoom.lightSwitches.add(this);
        } else {
            float f = 0.9f;
            float f2 = 0.8f;
            float f3 = 0.7f;
            if (this.sprite != null && this.sprite.getProperties().Is("lightR")) {
                if (n >= 76 && this.canBeModified) {
                    f = this.primaryR;
                    f2 = this.primaryG;
                    f3 = this.primaryB;
                } else {
                    f = Float.parseFloat(this.sprite.getProperties().Val("lightR")) / 255.0f;
                    f2 = Float.parseFloat(this.sprite.getProperties().Val("lightG")) / 255.0f;
                    f3 = Float.parseFloat(this.sprite.getProperties().Val("lightB")) / 255.0f;
                    this.primaryR = f;
                    this.primaryG = f2;
                    this.primaryB = f3;
                }
            }
            int n2 = 8;
            if (this.sprite.getProperties().Is("LightRadius") && Integer.parseInt(this.sprite.getProperties().Val("LightRadius")) > 0) {
                n2 = Integer.parseInt(this.sprite.getProperties().Val("LightRadius"));
            }
            IsoLightSource isoLightSource = new IsoLightSource((int)this.getX(), (int)this.getY(), (int)this.getZ(), f, f2, f3, n2);
            isoLightSource.bWasActive = isoLightSource.bActive = this.Activated;
            isoLightSource.bHydroPowered = true;
            isoLightSource.switches.add(this);
            this.lights.add(isoLightSource);
        }
        if (SystemDisabler.doObjectStateSyncEnable && GameClient.bClient) {
            GameClient.instance.objectSyncReq.putRequestLoad(this.square);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.lightRoom ? (byte)1 : 0);
        byteBuffer.putInt(this.RoomID);
        byteBuffer.put(this.Activated ? (byte)1 : 0);
        byteBuffer.put(this.canBeModified ? (byte)1 : 0);
        if (this.canBeModified) {
            byteBuffer.put(this.useBattery ? (byte)1 : 0);
            byteBuffer.put(this.hasBattery ? (byte)1 : 0);
            byteBuffer.put(this.hasLightBulb() ? (byte)1 : 0);
            if (this.hasLightBulb()) {
                GameWindow.WriteString(byteBuffer, this.bulbItem);
            }
            byteBuffer.putFloat(this.power);
            byteBuffer.putFloat(this.delta);
            byteBuffer.putFloat(this.getPrimaryR());
            byteBuffer.putFloat(this.getPrimaryG());
            byteBuffer.putFloat(this.getPrimaryB());
        }
        byteBuffer.putLong(this.lastMinuteStamp);
        byteBuffer.putInt(this.bulbBurnMinutes);
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        return false;
    }

    public boolean canSwitchLight() {
        if (this.bulbItem != null) {
            boolean bl;
            boolean bl2 = IsoWorld.instance.isHydroPowerOn();
            boolean bl3 = bl2 ? this.square.getRoom() != null || this.bStreetLight : (bl = this.square.haveElectricity());
            if (!bl && this.getCell() != null) {
                block0: for (int i = 0; i >= (this.getZ() >= 1.0f ? -1 : 0); --i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = -1; k < 2; ++k) {
                            IsoGridSquare isoGridSquare;
                            if (j == 0 && k == 0 && i == 0 || (isoGridSquare = this.getCell().getGridSquare(this.getX() + (float)j, this.getY() + (float)k, this.getZ() + (float)i)) == null || (!bl2 || isoGridSquare.getRoom() == null) && !isoGridSquare.haveElectricity()) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue block0;
                    }
                }
            }
            if (!this.useBattery && bl || this.canBeModified && this.useBattery && this.hasBattery && this.power > 0.0f) {
                return true;
            }
        }
        return false;
    }

    public boolean setActive(boolean bl) {
        return this.setActive(bl, false, false);
    }

    public boolean setActive(boolean bl, boolean bl2) {
        return this.setActive(bl, bl2, false);
    }

    public boolean setActive(boolean bl, boolean bl2, boolean bl3) {
        if (this.bulbItem == null) {
            bl = false;
        }
        if (bl == this.Activated) {
            return this.Activated;
        }
        if (this.square.getRoom() == null && !this.canBeModified) {
            return this.Activated;
        }
        if (bl3 || this.canSwitchLight()) {
            this.Activated = bl;
            if (!bl2) {
                IsoWorld.instance.getFreeEmitter().playSound("LightSwitch", this.square);
                this.switchLight(this.Activated);
                this.syncIsoObject(false, this.Activated ? (byte)1 : 0, null);
            }
        }
        return this.Activated;
    }

    public boolean toggle() {
        return this.setActive(!this.Activated);
    }

    public void switchLight(boolean bl) {
        int n;
        if (this.lightRoom && this.square.getRoom() != null) {
            this.square.getRoom().def.bLightsActive = bl;
            for (n = 0; n < this.square.getRoom().lightSwitches.size(); ++n) {
                this.square.getRoom().lightSwitches.get((int)n).Activated = bl;
            }
            if (GameServer.bServer) {
                n = this.square.getX() / 300;
                int n2 = this.square.getY() / 300;
                int n3 = this.square.getRoom().def.ID;
                GameServer.sendMetaGrid(n, n2, n3);
            }
        }
        for (n = 0; n < this.lights.size(); ++n) {
            IsoLightSource isoLightSource = this.lights.get(n);
            isoLightSource.bActive = bl;
        }
        IsoGridSquare.RecalcLightTime = -1;
        GameTime.instance.lightSourceUpdate = 100.0f;
        IsoGenerator.updateGenerator(this.getSquare());
    }

    public void getCustomSettingsFromItem(InventoryItem inventoryItem) {
        Moveable moveable;
        if (inventoryItem instanceof Moveable && (moveable = (Moveable)inventoryItem).isLight()) {
            this.useBattery = moveable.isLightUseBattery();
            this.hasBattery = moveable.isLightHasBattery();
            this.bulbItem = moveable.getLightBulbItem();
            this.power = moveable.getLightPower();
            this.delta = moveable.getLightDelta();
            this.setPrimaryR(moveable.getLightR());
            this.setPrimaryG(moveable.getLightG());
            this.setPrimaryB(moveable.getLightB());
        }
    }

    public void setCustomSettingsToItem(InventoryItem inventoryItem) {
        if (inventoryItem instanceof Moveable) {
            Moveable moveable = (Moveable)inventoryItem;
            moveable.setLightUseBattery(this.useBattery);
            moveable.setLightHasBattery(this.hasBattery);
            moveable.setLightBulbItem(this.bulbItem);
            moveable.setLightPower(this.power);
            moveable.setLightDelta(this.delta);
            moveable.setLightR(this.primaryR);
            moveable.setLightG(this.primaryG);
            moveable.setLightB(this.primaryB);
        }
    }

    public void syncCustomizedSettings(UdpConnection udpConnection) {
        if (GameClient.bClient) {
            this.writeCustomizedSettingsPacket(GameClient.connection);
        } else if (GameServer.bServer) {
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                if (udpConnection != null && udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                this.writeCustomizedSettingsPacket(udpConnection2);
            }
        }
    }

    private void writeCustomizedSettingsPacket(UdpConnection udpConnection) {
        if (udpConnection != null) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.SyncCustomLightSettings.doPacket(byteBufferWriter);
            this.writeLightSwitchObjectHeader(byteBufferWriter, this.Activated ? (byte)1 : 0);
            byteBufferWriter.putBoolean(this.canBeModified);
            byteBufferWriter.putBoolean(this.useBattery);
            byteBufferWriter.putBoolean(this.hasBattery);
            byteBufferWriter.putByte(this.bulbItem != null ? (byte)1 : 0);
            if (this.bulbItem != null) {
                GameWindow.WriteString(byteBufferWriter.bb, this.bulbItem);
            }
            byteBufferWriter.putFloat(this.power);
            byteBufferWriter.putFloat(this.delta);
            byteBufferWriter.putFloat(this.primaryR);
            byteBufferWriter.putFloat(this.primaryG);
            byteBufferWriter.putFloat(this.primaryB);
            PacketTypes.PacketType.SyncCustomLightSettings.send(udpConnection);
        }
    }

    private void readCustomizedSettingsPacket(ByteBuffer byteBuffer) {
        this.Activated = byteBuffer.get() == 1;
        this.canBeModified = byteBuffer.get() == 1;
        this.useBattery = byteBuffer.get() == 1;
        this.hasBattery = byteBuffer.get() == 1;
        this.bulbItem = byteBuffer.get() == 1 ? GameWindow.ReadString(byteBuffer) : null;
        this.power = byteBuffer.getFloat();
        this.delta = byteBuffer.getFloat();
        this.setPrimaryR(byteBuffer.getFloat());
        this.setPrimaryG(byteBuffer.getFloat());
        this.setPrimaryB(byteBuffer.getFloat());
    }

    public void receiveSyncCustomizedSettings(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        if (GameClient.bClient) {
            this.readCustomizedSettingsPacket(byteBuffer);
        } else if (GameServer.bServer) {
            this.readCustomizedSettingsPacket(byteBuffer);
            this.syncCustomizedSettings(udpConnection);
        }
        this.switchLight(this.Activated);
    }

    private void writeLightSwitchObjectHeader(ByteBufferWriter byteBufferWriter, byte by) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byteBufferWriter.putByte((byte)this.square.getObjects().indexOf(this));
        byteBufferWriter.putByte(by);
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte(this.Activated ? (byte)1 : 0);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        this.syncIsoObject(bl, by, udpConnection);
    }

    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection) {
        if (this.square == null) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " square is null");
            return;
        }
        if (this.getObjectIndex() == -1) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " not found on square " + this.square.getX() + "," + this.square.getY() + "," + this.square.getZ());
            return;
        }
        if (GameClient.bClient && !bl) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
            this.syncIsoObjectSend(byteBufferWriter);
            PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
        } else if (bl) {
            if (by == 1) {
                this.switchLight(true);
                this.Activated = true;
            } else {
                this.switchLight(false);
                this.Activated = false;
            }
            if (GameServer.bServer) {
                for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                    ByteBufferWriter byteBufferWriter;
                    if (udpConnection != null) {
                        if (udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) continue;
                        byteBufferWriter = udpConnection2.startPacket();
                        PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                        this.syncIsoObjectSend(byteBufferWriter);
                        PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
                        continue;
                    }
                    if (!udpConnection2.RelevantTo(this.square.x, this.square.y)) continue;
                    byteBufferWriter = udpConnection2.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    byteBufferWriter.putInt(this.square.getX());
                    byteBufferWriter.putInt(this.square.getY());
                    byteBufferWriter.putInt(this.square.getZ());
                    byte by2 = (byte)this.square.getObjects().indexOf(this);
                    if (by2 != -1) {
                        byteBufferWriter.putByte(by2);
                    } else {
                        byteBufferWriter.putByte((byte)this.square.getObjects().size());
                    }
                    byteBufferWriter.putByte((byte)1);
                    byteBufferWriter.putByte(this.Activated ? (byte)1 : 0);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
                }
            }
        }
    }

    @Override
    public void update() {
        if (!GameServer.bServer && !GameClient.bClient || GameServer.bServer) {
            boolean bl = false;
            if (!this.Activated) {
                this.lastMinuteStamp = -1L;
            }
            if (!this.lightRoom && this.canBeModified && this.Activated) {
                if (this.lastMinuteStamp == -1L) {
                    this.lastMinuteStamp = GameTime.instance.getMinutesStamp();
                }
                if (GameTime.instance.getMinutesStamp() > this.lastMinuteStamp) {
                    double d;
                    boolean bl2;
                    if (this.bulbBurnMinutes == -1) {
                        int n = SandboxOptions.instance.getElecShutModifier() * 24 * 60;
                        this.bulbBurnMinutes = this.lastMinuteStamp < (long)n ? (int)this.lastMinuteStamp : n;
                    }
                    long l = GameTime.instance.getMinutesStamp() - this.lastMinuteStamp;
                    this.lastMinuteStamp = GameTime.instance.getMinutesStamp();
                    boolean bl3 = false;
                    boolean bl4 = IsoWorld.instance.isHydroPowerOn();
                    boolean bl5 = bl4 ? this.square.getRoom() != null : this.square.haveElectricity();
                    boolean bl6 = bl2 = this.useBattery && this.hasBattery && this.power > 0.0f;
                    if (bl2 || !this.useBattery && bl5) {
                        bl3 = true;
                    }
                    if ((d = SandboxOptions.instance.LightBulbLifespan.getValue()) <= 0.0) {
                        bl3 = false;
                    }
                    if (this.Activated && this.hasLightBulb() && bl3) {
                        this.bulbBurnMinutes = (int)((long)this.bulbBurnMinutes + l);
                    }
                    this.nextBreakUpdate = (int)((long)this.nextBreakUpdate - l);
                    if (this.nextBreakUpdate <= 0) {
                        if (this.Activated && this.hasLightBulb() && bl3) {
                            int n;
                            int n2;
                            int n3 = (int)(1000.0 * d);
                            if (n3 < 1) {
                                n3 = 1;
                            }
                            if ((n2 = Rand.Next(0, n3)) < (n = this.bulbBurnMinutes / 10000)) {
                                this.bulbBurnMinutes = 0;
                                this.setActive(false, true, true);
                                this.bulbItem = null;
                                IsoWorld.instance.getFreeEmitter().playSound("LightbulbBurnedOut", this.square);
                                bl = true;
                                if (Core.bDebug) {
                                    System.out.println("broke bulb at x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ());
                                }
                            }
                        }
                        this.nextBreakUpdate = 60;
                    }
                    if (this.Activated && bl2 && this.hasLightBulb()) {
                        float f = this.power - this.power % 0.01f;
                        this.power -= this.delta * (float)l;
                        if (this.power < 0.0f) {
                            this.power = 0.0f;
                        }
                        if (l == 1L || this.power < f) {
                            bl = true;
                        }
                    }
                }
                if (this.useBattery && this.Activated && (this.power <= 0.0f || !this.hasBattery)) {
                    this.power = 0.0f;
                    this.setActive(false, true, true);
                    bl = true;
                }
            }
            if (this.Activated && !this.hasLightBulb()) {
                this.setActive(false, true, true);
                bl = true;
            }
            if (bl && GameServer.bServer) {
                this.syncCustomizedSettings(null);
            }
        }
    }

    public boolean isActivated() {
        return this.Activated;
    }

    @Override
    public void addToWorld() {
        if (!this.Activated) {
            this.lastMinuteStamp = -1L;
        }
        if (!this.lightRoom && !this.lights.isEmpty()) {
            for (int i = 0; i < this.lights.size(); ++i) {
                IsoWorld.instance.CurrentCell.getLamppostPositions().add(this.lights.get(i));
            }
        }
        if (this.getCell() != null && this.canBeModified && !this.lightRoom && (!GameServer.bServer && !GameClient.bClient || GameServer.bServer)) {
            this.getCell().addToStaticUpdaterObjectList(this);
        }
        this.checkAmbientSound();
    }

    @Override
    public void removeFromWorld() {
        IsoRoom isoRoom;
        if (!this.lightRoom && !this.lights.isEmpty()) {
            for (int i = 0; i < this.lights.size(); ++i) {
                this.lights.get(i).setActive(false);
                IsoWorld.instance.CurrentCell.removeLamppost(this.lights.get(i));
            }
            this.lights.clear();
        }
        if (this.square != null && this.lightRoom && (isoRoom = this.square.getRoom()) != null) {
            isoRoom.lightSwitches.remove(this);
        }
        super.removeFromWorld();
    }

    public static void chunkLoaded(IsoChunk isoChunk) {
        Object object;
        int n;
        int n2;
        ArrayList<IsoRoom> arrayList = new ArrayList<IsoRoom>();
        for (n2 = 0; n2 < 10; ++n2) {
            for (int i = 0; i < 10; ++i) {
                for (n = 0; n < 8; ++n) {
                    IsoRoom isoRoom;
                    object = isoChunk.getGridSquare(n2, i, n);
                    if (object == null || (isoRoom = ((IsoGridSquare)object).getRoom()) == null || !isoRoom.hasLightSwitches() || arrayList.contains(isoRoom)) continue;
                    arrayList.add(isoRoom);
                }
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            IsoRoom isoRoom = (IsoRoom)arrayList.get(n2);
            isoRoom.createLights(isoRoom.def.bLightsActive);
            for (n = 0; n < isoRoom.roomLights.size(); ++n) {
                object = isoRoom.roomLights.get(n);
                if (isoChunk.roomLights.contains(object)) continue;
                isoChunk.roomLights.add((IsoRoomLight)object);
            }
        }
    }

    public ArrayList<IsoLightSource> getLights() {
        return this.lights;
    }
}

