/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import fmod.fmod.FMODSoundEmitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Stack;
import zombie.WorldSoundManager;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.DummySoundEmitter;
import zombie.audio.parameters.ParameterFireSize;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.network.ByteBufferWriter;
import zombie.core.textures.ColorInfo;
import zombie.debug.DebugLog;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoFire;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.util.list.PZArrayUtil;

public class IsoFireManager {
    public static double Red_Oscilator = 0.0;
    public static double Green_Oscilator = 0.0;
    public static double Blue_Oscilator = 0.0;
    public static double Red_Oscilator_Rate = 0.1f;
    public static double Green_Oscilator_Rate = 0.13f;
    public static double Blue_Oscilator_Rate = 0.0876f;
    public static double Red_Oscilator_Val = 0.0;
    public static double Green_Oscilator_Val = 0.0;
    public static double Blue_Oscilator_Val = 0.0;
    public static double OscilatorSpeedScalar = 15.6f;
    public static double OscilatorEffectScalar = 0.0039f;
    public static int MaxFireObjects = 75;
    public static int FireRecalcDelay;
    public static int FireRecalc;
    public static boolean LightCalcFromBurningCharacters;
    public static float FireAlpha;
    public static float SmokeAlpha;
    public static float FireAnimDelay;
    public static float SmokeAnimDelay;
    public static ColorInfo FireTintMod;
    public static ColorInfo SmokeTintMod;
    public static final ArrayList<IsoFire> FireStack;
    public static final ArrayList<IsoGameCharacter> CharactersOnFire_Stack;
    private static final FireSounds fireSounds;
    private static Stack<IsoFire> updateStack;
    private static final HashSet<IsoGameCharacter> charactersOnFire;

    public static void Add(IsoFire isoFire) {
        if (FireStack.contains(isoFire)) {
            System.out.println("IsoFireManager.Add already added fire, ignoring");
            return;
        }
        if (FireStack.size() < MaxFireObjects) {
            FireStack.add(isoFire);
        } else {
            IsoObject isoObject = null;
            int n = 0;
            for (int i = 0; i < FireStack.size(); ++i) {
                if (IsoFireManager.FireStack.get((int)i).Age <= n) continue;
                n = IsoFireManager.FireStack.get((int)i).Age;
                isoObject = FireStack.get(i);
            }
            if (isoObject != null && ((IsoFire)isoObject).square != null) {
                ((IsoFire)isoObject).square.getProperties().UnSet(IsoFlagType.burning);
                ((IsoFire)isoObject).square.getProperties().UnSet(IsoFlagType.smoke);
                isoObject.RemoveAttachedAnims();
                ((IsoFire)isoObject).removeFromWorld();
                isoObject.removeFromSquare();
            }
            FireStack.add(isoFire);
        }
    }

    public static void AddBurningCharacter(IsoGameCharacter isoGameCharacter) {
        for (int i = 0; i < CharactersOnFire_Stack.size(); ++i) {
            if (CharactersOnFire_Stack.get(i) != isoGameCharacter) continue;
            return;
        }
        CharactersOnFire_Stack.add(isoGameCharacter);
    }

    public static void Fire_LightCalc(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2, int n) {
        if (isoGridSquare2 == null || isoGridSquare == null) {
            return;
        }
        int n2 = 0;
        int n3 = 8;
        n2 += Math.abs(isoGridSquare2.getX() - isoGridSquare.getX());
        n2 += Math.abs(isoGridSquare2.getY() - isoGridSquare.getY());
        if ((n2 += Math.abs(isoGridSquare2.getZ() - isoGridSquare.getZ())) <= n3) {
            float f;
            float f2 = f = 0.199f / (float)n3 * (float)(n3 - n2);
            float f3 = f * 0.6f;
            float f4 = f * 0.4f;
            if (isoGridSquare2.getLightInfluenceR() == null) {
                isoGridSquare2.setLightInfluenceR(new ArrayList<Float>());
            }
            isoGridSquare2.getLightInfluenceR().add(Float.valueOf(f2));
            if (isoGridSquare2.getLightInfluenceG() == null) {
                isoGridSquare2.setLightInfluenceG(new ArrayList<Float>());
            }
            isoGridSquare2.getLightInfluenceG().add(Float.valueOf(f3));
            if (isoGridSquare2.getLightInfluenceB() == null) {
                isoGridSquare2.setLightInfluenceB(new ArrayList<Float>());
            }
            isoGridSquare2.getLightInfluenceB().add(Float.valueOf(f4));
            ColorInfo colorInfo = isoGridSquare2.lighting[n].lightInfo();
            colorInfo.r += f2;
            colorInfo.g += f3;
            colorInfo.b += f4;
            if (colorInfo.r > 1.0f) {
                colorInfo.r = 1.0f;
            }
            if (colorInfo.g > 1.0f) {
                colorInfo.g = 1.0f;
            }
            if (colorInfo.b > 1.0f) {
                colorInfo.b = 1.0f;
            }
        }
    }

    public static void LightTileWithFire(IsoGridSquare isoGridSquare) {
    }

    public static void explode(IsoCell isoCell, IsoGridSquare isoGridSquare, int n) {
        if (isoGridSquare == null) {
            return;
        }
        IsoGridSquare isoGridSquare2 = null;
        Object var4_4 = null;
        FireRecalc = 1;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    isoGridSquare2 = isoCell.getGridSquare(isoGridSquare.getX() + i, isoGridSquare.getY() + j, isoGridSquare.getZ() + k);
                    if (isoGridSquare2 == null || Rand.Next(100) >= n || !IsoFire.CanAddFire(isoGridSquare2, true)) continue;
                    IsoFireManager.StartFire(isoCell, isoGridSquare2, true, Rand.Next(100, 250 + n));
                    isoGridSquare2.BurnWalls(true);
                }
            }
        }
    }

    @Deprecated
    public static void MolotovSmash(IsoCell isoCell, IsoGridSquare isoGridSquare) {
    }

    public static void Remove(IsoFire isoFire) {
        if (!FireStack.contains(isoFire)) {
            System.out.println("IsoFireManager.Remove unknown fire, ignoring");
            return;
        }
        FireStack.remove(isoFire);
    }

    public static void RemoveBurningCharacter(IsoGameCharacter isoGameCharacter) {
        CharactersOnFire_Stack.remove(isoGameCharacter);
    }

    public static void StartFire(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl, int n, int n2) {
        if (isoGridSquare.getFloor() != null && isoGridSquare.getFloor().getSprite() != null) {
            n -= isoGridSquare.getFloor().getSprite().firerequirement;
        }
        if (n < 5) {
            n = 5;
        }
        if (!IsoFire.CanAddFire(isoGridSquare, bl)) {
            return;
        }
        if (GameClient.bClient) {
            DebugLog.General.warn("The StartFire function was called on Client");
            return;
        }
        if (GameServer.bServer) {
            GameServer.startFireOnClient(isoGridSquare, n, bl, n2, false);
            return;
        }
        IsoFire isoFire = new IsoFire(isoCell, isoGridSquare, bl, n, n2);
        IsoFireManager.Add(isoFire);
        isoGridSquare.getObjects().add(isoFire);
        if (Rand.Next(5) == 0) {
            WorldSoundManager.instance.addSound(isoFire, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), 20, 20);
        }
    }

    public static void StartSmoke(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl, int n, int n2) {
        if (!IsoFire.CanAddSmoke(isoGridSquare, bl)) {
            return;
        }
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.StartFire.doPacket(byteBufferWriter);
            byteBufferWriter.putInt(isoGridSquare.getX());
            byteBufferWriter.putInt(isoGridSquare.getY());
            byteBufferWriter.putInt(isoGridSquare.getZ());
            byteBufferWriter.putInt(n);
            byteBufferWriter.putBoolean(bl);
            byteBufferWriter.putInt(n2);
            byteBufferWriter.putBoolean(true);
            PacketTypes.PacketType.StartFire.send(GameClient.connection);
            return;
        }
        if (GameServer.bServer) {
            GameServer.startFireOnClient(isoGridSquare, n, bl, n2, true);
            return;
        }
        IsoFire isoFire = new IsoFire(isoCell, isoGridSquare, bl, n, n2, true);
        IsoFireManager.Add(isoFire);
        isoGridSquare.getObjects().add(isoFire);
    }

    public static void StartFire(IsoCell isoCell, IsoGridSquare isoGridSquare, boolean bl, int n) {
        IsoFireManager.StartFire(isoCell, isoGridSquare, bl, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCharacterOnFire(IsoGameCharacter isoGameCharacter) {
        HashSet<IsoGameCharacter> hashSet = charactersOnFire;
        synchronized (hashSet) {
            charactersOnFire.add(isoGameCharacter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCharacterOnFire(IsoGameCharacter isoGameCharacter) {
        HashSet<IsoGameCharacter> hashSet = charactersOnFire;
        synchronized (hashSet) {
            charactersOnFire.remove(isoGameCharacter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Update() {
        HashSet<IsoGameCharacter> hashSet = charactersOnFire;
        synchronized (hashSet) {
            charactersOnFire.forEach(IsoGameCharacter::SpreadFireMP);
        }
        Red_Oscilator_Val = Math.sin(Red_Oscilator += Blue_Oscilator_Rate * OscilatorSpeedScalar);
        Green_Oscilator_Val = Math.sin(Green_Oscilator += Blue_Oscilator_Rate * OscilatorSpeedScalar);
        Blue_Oscilator_Val = Math.sin(Blue_Oscilator += Blue_Oscilator_Rate * OscilatorSpeedScalar);
        Red_Oscilator_Val = (Red_Oscilator_Val + 1.0) / 2.0;
        Green_Oscilator_Val = (Green_Oscilator_Val + 1.0) / 2.0;
        Blue_Oscilator_Val = (Blue_Oscilator_Val + 1.0) / 2.0;
        Red_Oscilator_Val *= OscilatorEffectScalar;
        Green_Oscilator_Val *= OscilatorEffectScalar;
        Blue_Oscilator_Val *= OscilatorEffectScalar;
        updateStack.clear();
        updateStack.addAll(FireStack);
        for (int i = 0; i < updateStack.size(); ++i) {
            IsoFire isoFire = (IsoFire)updateStack.get(i);
            if (isoFire.getObjectIndex() == -1 || !FireStack.contains(isoFire)) continue;
            isoFire.update();
        }
        if (--FireRecalc < 0) {
            FireRecalc = FireRecalcDelay;
        }
        fireSounds.update();
    }

    public static void updateSound(IsoFire isoFire) {
        fireSounds.addFire(isoFire);
    }

    public static void stopSound(IsoFire isoFire) {
        fireSounds.removeFire(isoFire);
    }

    public static void RemoveAllOn(IsoGridSquare isoGridSquare) {
        for (int i = FireStack.size() - 1; i >= 0; --i) {
            IsoFire isoFire = FireStack.get(i);
            if (isoFire.square != isoGridSquare) continue;
            isoFire.extinctFire();
        }
    }

    public static void Reset() {
        FireStack.clear();
        CharactersOnFire_Stack.clear();
        fireSounds.Reset();
    }

    static {
        FireRecalc = FireRecalcDelay = 25;
        LightCalcFromBurningCharacters = false;
        FireAlpha = 1.0f;
        SmokeAlpha = 0.3f;
        FireAnimDelay = 0.2f;
        SmokeAnimDelay = 0.2f;
        FireTintMod = new ColorInfo(1.0f, 1.0f, 1.0f, 1.0f);
        SmokeTintMod = new ColorInfo(0.5f, 0.5f, 0.5f, 1.0f);
        FireStack = new ArrayList();
        CharactersOnFire_Stack = new ArrayList();
        fireSounds = new FireSounds(20);
        updateStack = new Stack();
        charactersOnFire = new HashSet();
    }

    private static final class FireSounds {
        final ArrayList<IsoFire> fires = new ArrayList();
        final Slot[] slots;
        final Comparator<IsoFire> comp = new Comparator<IsoFire>(){

            @Override
            public int compare(IsoFire isoFire, IsoFire isoFire2) {
                float f;
                float f2 = this.getClosestListener((float)isoFire.square.x + 0.5f, (float)isoFire.square.y + 0.5f, isoFire.square.z);
                if (f2 > (f = this.getClosestListener((float)isoFire2.square.x + 0.5f, (float)isoFire2.square.y + 0.5f, isoFire2.square.z))) {
                    return 1;
                }
                if (f2 < f) {
                    return -1;
                }
                return 0;
            }
        };

        FireSounds(int n) {
            this.slots = PZArrayUtil.newInstance(Slot.class, n, Slot::new);
        }

        void addFire(IsoFire isoFire) {
            if (!this.fires.contains(isoFire)) {
                this.fires.add(isoFire);
            }
        }

        void removeFire(IsoFire isoFire) {
            this.fires.remove(isoFire);
        }

        void update() {
            int n;
            IsoFire isoFire;
            int n2;
            int n3;
            if (GameServer.bServer) {
                return;
            }
            for (n3 = 0; n3 < this.slots.length; ++n3) {
                this.slots[n3].playing = false;
            }
            if (this.fires.isEmpty()) {
                this.stopNotPlaying();
                return;
            }
            Collections.sort(this.fires, this.comp);
            n3 = Math.min(this.fires.size(), this.slots.length);
            for (n2 = 0; n2 < n3; ++n2) {
                isoFire = this.fires.get(n2);
                if (!this.shouldPlay(isoFire) || (n = this.getExistingSlot(isoFire)) == -1) continue;
                this.slots[n].playSound(isoFire);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                isoFire = this.fires.get(n2);
                if (!this.shouldPlay(isoFire) || (n = this.getExistingSlot(isoFire)) != -1) continue;
                n = this.getFreeSlot();
                this.slots[n].playSound(isoFire);
            }
            this.stopNotPlaying();
            this.fires.clear();
        }

        float getClosestListener(float f, float f2, float f3) {
            float f4 = Float.MAX_VALUE;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null || isoPlayer.getCurrentSquare() == null) continue;
                float f5 = isoPlayer.getX();
                float f6 = isoPlayer.getY();
                float f7 = isoPlayer.getZ();
                float f8 = IsoUtils.DistanceToSquared(f5, f6, f7 * 3.0f, f, f2, f3 * 3.0f);
                if (isoPlayer.Traits.HardOfHearing.isSet()) {
                    f8 *= 4.5f;
                }
                if (!(f8 < f4)) continue;
                f4 = f8;
            }
            return f4;
        }

        boolean shouldPlay(IsoFire isoFire) {
            return isoFire != null && isoFire.getObjectIndex() != -1 && isoFire.LifeStage < 4;
        }

        int getExistingSlot(IsoFire isoFire) {
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i].fire != isoFire) continue;
                return i;
            }
            return -1;
        }

        int getFreeSlot() {
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i].playing) continue;
                return i;
            }
            return -1;
        }

        void stopNotPlaying() {
            for (int i = 0; i < this.slots.length; ++i) {
                Slot slot = this.slots[i];
                if (slot.playing) continue;
                slot.stopPlaying();
                slot.fire = null;
            }
        }

        void Reset() {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].stopPlaying();
                this.slots[i].fire = null;
                this.slots[i].playing = false;
            }
        }

        static final class Slot {
            IsoFire fire;
            BaseSoundEmitter emitter;
            final ParameterFireSize parameterFireSize = new ParameterFireSize();
            long instance = 0L;
            boolean playing;

            Slot() {
            }

            void playSound(IsoFire isoFire) {
                if (this.emitter == null) {
                    BaseSoundEmitter baseSoundEmitter = this.emitter = Core.SoundDisabled ? new DummySoundEmitter() : new FMODSoundEmitter();
                    if (!Core.SoundDisabled) {
                        ((FMODSoundEmitter)this.emitter).addParameter(this.parameterFireSize);
                    }
                }
                this.emitter.setPos((float)isoFire.square.x + 0.5f, (float)isoFire.square.y + 0.5f, isoFire.square.z);
                int n = switch (isoFire.LifeStage) {
                    case 1, 3 -> 1;
                    case 2 -> 2;
                    default -> 0;
                };
                this.parameterFireSize.setSize(n);
                if (isoFire.isCampfire()) {
                    if (!this.emitter.isPlaying("CampfireRunning")) {
                        this.instance = this.emitter.playSoundImpl("CampfireRunning", (IsoObject)null);
                    }
                } else if (!this.emitter.isPlaying("Fire")) {
                    this.instance = this.emitter.playSoundImpl("Fire", (IsoObject)null);
                }
                this.fire = isoFire;
                this.playing = true;
                this.emitter.tick();
            }

            void stopPlaying() {
                if (this.emitter == null || this.instance == 0L) {
                    if (this.emitter != null && !this.emitter.isEmpty()) {
                        this.emitter.tick();
                    }
                    return;
                }
                if (this.emitter.hasSustainPoints(this.instance)) {
                    this.emitter.triggerCue(this.instance);
                    this.instance = 0L;
                    return;
                }
                this.emitter.stopAll();
                this.instance = 0L;
            }
        }
    }
}

