/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.Lua.LuaEventManager;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.opengl.Shader;
import zombie.core.skinnedmodel.model.WorldItemModelDrawer;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.inventory.InventoryItem;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoPhysicsObject;

public class IsoFallingClothing
extends IsoPhysicsObject {
    private InventoryItem clothing = null;
    private int dropTimer = 0;
    public boolean addWorldItem = true;

    @Override
    public String getObjectName() {
        return "FallingClothing";
    }

    public IsoFallingClothing(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoFallingClothing(IsoCell isoCell, float f, float f2, float f3, float f4, float f5, InventoryItem inventoryItem) {
        super(isoCell);
        this.clothing = inventoryItem;
        this.dropTimer = 60;
        this.velX = f4;
        this.velY = f5;
        float f6 = (float)Rand.Next(4000) / 10000.0f;
        float f7 = (float)Rand.Next(4000) / 10000.0f;
        this.velX += (f6 -= 0.2f);
        this.velY += (f7 -= 0.2f);
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.nx = f;
        this.ny = f2;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.terminalVelocity = -0.02f;
        Texture texture = this.sprite.LoadFrameExplicit(inventoryItem.getTex().getName());
        if (texture != null) {
            this.sprite.Animate = false;
            int n = Core.TileScale;
            this.sprite.def.scaleAspect(texture.getWidthOrig(), texture.getHeightOrig(), 16 * n, 16 * n);
        }
        this.speedMod = 4.5f;
    }

    @Override
    public void collideGround() {
        this.drop();
    }

    @Override
    public void collideWall() {
        this.drop();
    }

    @Override
    public void update() {
        super.update();
        --this.dropTimer;
        if (this.dropTimer <= 0) {
            this.drop();
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        float f4 = (float)(60 - this.dropTimer) / 60.0f * 360.0f;
        if (WorldItemModelDrawer.renderMain(this.clothing, this.getCurrentSquare(), this.getX(), this.getY(), this.getZ(), f4)) {
            return;
        }
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
    }

    void drop() {
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        if (isoGridSquare != null && this.clothing != null) {
            if (this.addWorldItem) {
                float f = isoGridSquare.getApparentZ(this.getX() % 1.0f, this.getY() % 1.0f);
                isoGridSquare.AddWorldInventoryItem(this.clothing, this.getX() % 1.0f, this.getY() % 1.0f, f - (float)isoGridSquare.getZ());
            }
            this.clothing = null;
            this.setDestroyed(true);
            isoGridSquare.getMovingObjects().remove(this);
            this.getCell().Remove(this);
            LuaEventManager.triggerEvent("OnContainerUpdate", isoGridSquare);
        }
    }

    void Trigger() {
    }
}

