/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.Consumer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.SystemDisabler;
import zombie.WorldSoundManager;
import zombie.ai.states.ThumpState;
import zombie.characters.BaseCharacterSoundEmitter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.Shader;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.Key;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.iso.weather.fx.WeatherFxMask;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;

public class IsoDoor
extends IsoObject
implements BarricadeAble,
Thumpable {
    public int Health = 500;
    public boolean lockedByKey = false;
    private boolean haveKey = false;
    public boolean Locked = false;
    public int MaxHealth = 500;
    public int PushedMaxStrength = 0;
    public int PushedStrength = 0;
    public DoorType type = DoorType.WeakWooden;
    IsoSprite closedSprite;
    public boolean north = false;
    int gid = -1;
    public boolean open = false;
    IsoSprite openSprite;
    private boolean destroyed = false;
    private boolean bHasCurtain;
    private boolean bCurtainInside;
    private boolean bCurtainOpen;
    KahluaTable table;
    public static final Vector2 tempo = new Vector2();
    private IsoSprite curtainN;
    private IsoSprite curtainS;
    private IsoSprite curtainW;
    private IsoSprite curtainE;
    private IsoSprite curtainNopen;
    private IsoSprite curtainSopen;
    private IsoSprite curtainWopen;
    private IsoSprite curtainEopen;
    private static final int[] DoubleDoorNorthSpriteOffset = new int[]{5, 3, 4, 4};
    private static final int[] DoubleDoorWestSpriteOffset = new int[]{4, 4, 5, 3};
    private static final int[] DoubleDoorNorthClosedXOffset = new int[]{0, 1, 2, 3};
    private static final int[] DoubleDoorNorthOpenXOffset = new int[]{0, 0, 3, 3};
    private static final int[] DoubleDoorNorthClosedYOffset = new int[]{0, 0, 0, 0};
    private static final int[] DoubleDoorNorthOpenYOffset = new int[]{0, 1, 1, 0};
    private static final int[] DoubleDoorWestClosedXOffset = new int[]{0, 0, 0, 0};
    private static final int[] DoubleDoorWestOpenXOffset = new int[]{0, 1, 1, 0};
    private static final int[] DoubleDoorWestClosedYOffset = new int[]{0, -1, -2, -3};
    private static final int[] DoubleDoorWestOpenYOffset = new int[]{0, 0, -3, -3};

    public IsoDoor(IsoCell isoCell) {
        super(isoCell);
    }

    @Override
    public String getObjectName() {
        return "Door";
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        this.checkKeyHighlight(f, f2);
        if (!this.bHasCurtain) {
            super.render(f, f2, f3, colorInfo, bl, bl2, shader);
            return;
        }
        this.initCurtainSprites();
        IsoDirections isoDirections = this.getSpriteEdge(false);
        this.prerender(f, f2, f3, colorInfo, bl, bl2, isoDirections);
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
        this.postrender(f, f2, f3, colorInfo, bl, bl2, isoDirections);
    }

    @Override
    public void renderWallTile(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader, Consumer<TextureDraw> consumer) {
        this.checkKeyHighlight(f, f2);
        if (!this.bHasCurtain) {
            super.renderWallTile(f, f2, f3, colorInfo, bl, bl2, shader, consumer);
            return;
        }
        this.initCurtainSprites();
        IsoDirections isoDirections = this.getSpriteEdge(false);
        this.prerender(f, f2, f3, colorInfo, bl, bl2, isoDirections);
        super.renderWallTile(f, f2, f3, colorInfo, bl, bl2, shader, consumer);
        this.postrender(f, f2, f3, colorInfo, bl, bl2, isoDirections);
    }

    private void checkKeyHighlight(float f, float f2) {
        int n = IsoCamera.frameState.playerIndex;
        IsoGameCharacter isoGameCharacter = IsoCamera.frameState.CamCharacter;
        Key key = Key.highlightDoor[n];
        if (key != null && f >= isoGameCharacter.getX() - 20.0f && f2 >= isoGameCharacter.getY() - 20.0f && f < isoGameCharacter.getX() + 20.0f && f2 < isoGameCharacter.getY() + 20.0f) {
            boolean bl = this.square.isSeen(n);
            if (!bl) {
                IsoGridSquare isoGridSquare = this.getOppositeSquare();
                boolean bl2 = bl = isoGridSquare != null && isoGridSquare.isSeen(n);
            }
            if (bl) {
                this.checkKeyId();
                if (this.getKeyId() == key.getKeyId()) {
                    this.setHighlighted(true);
                }
            }
        }
    }

    private void prerender(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, IsoDirections isoDirections) {
        if (Core.TileScale == 1) {
            switch (isoDirections) {
                case N: {
                    this.prerender1xN(f, f2, f3, colorInfo, bl, bl2, null);
                    break;
                }
                case S: {
                    this.prerender1xS(f, f2, f3, colorInfo, bl, bl2, null);
                    break;
                }
                case W: {
                    this.prerender1xW(f, f2, f3, colorInfo, bl, bl2, null);
                    break;
                }
                case E: {
                    this.prerender1xE(f, f2, f3, colorInfo, bl, bl2, null);
                }
            }
            return;
        }
        switch (isoDirections) {
            case N: {
                this.prerender2xN(f, f2, f3, colorInfo, bl, bl2, null);
                break;
            }
            case S: {
                this.prerender2xS(f, f2, f3, colorInfo, bl, bl2, null);
                break;
            }
            case W: {
                this.prerender2xW(f, f2, f3, colorInfo, bl, bl2, null);
                break;
            }
            case E: {
                this.prerender2xE(f, f2, f3, colorInfo, bl, bl2, null);
            }
        }
    }

    private void postrender(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, IsoDirections isoDirections) {
        if (Core.TileScale == 1) {
            switch (isoDirections) {
                case N: {
                    this.postrender1xN(f, f2, f3, colorInfo, bl, bl2, null);
                    break;
                }
                case S: {
                    this.postrender1xS(f, f2, f3, colorInfo, bl, bl2, null);
                    break;
                }
                case W: {
                    this.postrender1xW(f, f2, f3, colorInfo, bl, bl2, null);
                    break;
                }
                case E: {
                    this.postrender1xE(f, f2, f3, colorInfo, bl, bl2, null);
                }
            }
            return;
        }
        switch (isoDirections) {
            case N: {
                this.postrender2xN(f, f2, f3, colorInfo, bl, bl2, null);
                break;
            }
            case S: {
                this.postrender2xS(f, f2, f3, colorInfo, bl, bl2, null);
                break;
            }
            case W: {
                this.postrender2xW(f, f2, f3, colorInfo, bl, bl2, null);
                break;
            }
            case E: {
                this.postrender2xE(f, f2, f3, colorInfo, bl, bl2, null);
            }
        }
    }

    private void prerender1xN(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (!this.north && this.open) {
                (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2 - 1.0f, f3, this.dir, this.offsetX + 3.0f, this.offsetY + (float)(this.bCurtainOpen ? -14 : -14), colorInfo, true);
            }
        } else if (this.north && !this.open) {
            (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2 - 1.0f, f3, this.dir, this.offsetX - 1.0f - 1.0f, this.offsetY + -15.0f, colorInfo, true);
        }
    }

    private void postrender1xN(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (this.north && !this.open) {
                (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2, f3, this.dir, this.offsetX - 10.0f - 1.0f, this.offsetY + -10.0f, colorInfo, true);
            }
        } else if (!this.north && this.open) {
            (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2, f3, this.dir, this.offsetX - 4.0f, this.offsetY + (float)(this.bCurtainOpen ? -10 : -10), colorInfo, true);
        }
    }

    private void prerender1xS(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (!this.north && this.open);
        if (!this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2, f3, this.dir, this.offsetX + (float)((this.bCurtainOpen ? -14 : -14) / 2), this.offsetY + (float)((this.bCurtainOpen ? -16 : -16) / 2), colorInfo, true);
        }
    }

    private void postrender1xS(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (!this.north && this.open);
        if (this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2 + 1.0f, f3, this.dir, this.offsetX + (float)((this.bCurtainOpen ? -28 : -28) / 2), this.offsetY + (float)((this.bCurtainOpen ? -8 : -8) / 2), colorInfo, true);
        }
    }

    private void prerender1xW(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (this.north && this.open) {
                (this.bCurtainOpen ? this.curtainEopen : this.curtainE).render(null, f - 1.0f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? -16 : -18), this.offsetY + (float)(this.bCurtainOpen ? -14 : -15), colorInfo, true);
            }
            if (!this.north && this.open) {
                (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2 - 1.0f, f3, this.dir, this.offsetX + 3.0f, this.offsetY + (float)(this.bCurtainOpen ? -14 : -14), colorInfo, true);
            }
        } else {
            if (this.north && !this.open) {
                (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2 - 1.0f, f3, this.dir, this.offsetX - 1.0f - 1.0f, this.offsetY + -15.0f, colorInfo, true);
            }
            if (!this.north && !this.open) {
                (this.bCurtainOpen ? this.curtainEopen : this.curtainE).render(null, f - 1.0f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? -12 : -14), this.offsetY + (float)(this.bCurtainOpen ? -14 : -15), colorInfo, true);
            }
        }
    }

    private void postrender1xW(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (this.north && !this.open) {
                (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2, f3, this.dir, this.offsetX - 10.0f - 1.0f, this.offsetY + -10.0f, colorInfo, true);
            }
            if (!this.north && !this.open) {
                (this.bCurtainOpen ? this.curtainWopen : this.curtainW).render(null, f, f2, f3, this.dir, this.offsetX - 2.0f - 1.0f, this.offsetY + -10.0f, colorInfo, true);
            }
        } else {
            if (this.north && this.open) {
                (this.bCurtainOpen ? this.curtainWopen : this.curtainW).render(null, f, f2, f3, this.dir, this.offsetX - 9.0f, this.offsetY + -10.0f, colorInfo, true);
            }
            if (!this.north && this.open) {
                (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2, f3, this.dir, this.offsetX - 4.0f, this.offsetY + (float)(this.bCurtainOpen ? -10 : -10), colorInfo, true);
            }
        }
    }

    private void prerender1xE(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (this.north && this.open);
        if (!this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainEopen : this.curtainE).render(null, f, f2, f3, this.dir, this.offsetX + (float)((this.bCurtainOpen ? -13 : -18) / 2), this.offsetY + (float)((this.bCurtainOpen ? -15 : -18) / 2), colorInfo, true);
        }
    }

    private void postrender1xE(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (this.north && this.open);
        if (this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainWopen : this.curtainW).render(null, f + 1.0f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? false : false), this.offsetY + (float)(this.bCurtainOpen ? false : false), colorInfo, true);
        }
    }

    private void prerender2xN(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (!this.north && this.open) {
                (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2 - 1.0f, f3, this.dir, this.offsetX + 7.0f, this.offsetY + (float)(this.bCurtainOpen ? -28 : -28), colorInfo, true);
            }
        } else if (this.north && !this.open) {
            (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2 - 1.0f, f3, this.dir, this.offsetX - 3.0f, this.offsetY + (float)(this.bCurtainOpen ? -30 : -30), colorInfo, true);
        }
    }

    private void postrender2xN(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (this.north && !this.open) {
                (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2, f3, this.dir, this.offsetX - 20.0f, this.offsetY + (float)(this.bCurtainOpen ? -20 : -20), colorInfo, true);
            }
        } else if (!this.north && this.open) {
            (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2, f3, this.dir, this.offsetX - 8.0f, this.offsetY + (float)(this.bCurtainOpen ? -20 : -20), colorInfo, true);
        }
    }

    private void prerender2xS(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (!this.north && this.open);
        if (!this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainSopen : this.curtainS).render(null, f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? -14 : -14), this.offsetY + (float)(this.bCurtainOpen ? -16 : -16), colorInfo, true);
        }
    }

    private void postrender2xS(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (!this.north && this.open);
        if (this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainNopen : this.curtainN).render(null, f, f2 + 1.0f, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? -28 : -28), this.offsetY + (float)(this.bCurtainOpen ? -8 : -8), colorInfo, true);
        }
    }

    private void prerender2xW(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (this.north && this.open) {
                (this.bCurtainOpen ? this.curtainEopen : this.curtainE).render(null, f - 1.0f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? -32 : -37), this.offsetY + (float)(this.bCurtainOpen ? -28 : -31), colorInfo, true);
            }
        } else if (!this.north && !this.open) {
            (this.bCurtainOpen ? this.curtainEopen : this.curtainE).render(null, f - 1.0f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? -22 : -26), this.offsetY + (float)(this.bCurtainOpen ? -28 : -31), colorInfo, true);
        }
    }

    private void postrender2xW(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.bCurtainInside) {
            if (!this.north && !this.open) {
                (this.bCurtainOpen ? this.curtainWopen : this.curtainW).render(null, f, f2, f3, this.dir, this.offsetX - 5.0f, this.offsetY + (float)(this.bCurtainOpen ? -20 : -20), colorInfo, true);
            }
        } else if (this.north && this.open) {
            (this.bCurtainOpen ? this.curtainWopen : this.curtainW).render(null, f, f2, f3, this.dir, this.offsetX - 19.0f, this.offsetY + (float)(this.bCurtainOpen ? -20 : -20), colorInfo, true);
        }
    }

    private void prerender2xE(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (this.north && this.open);
        if (!this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainEopen : this.curtainE).render(null, f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? -13 : -18), this.offsetY + (float)(this.bCurtainOpen ? -15 : -18), colorInfo, true);
        }
    }

    private void postrender2xE(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        assert (this.north && this.open);
        if (this.bCurtainInside) {
            (this.bCurtainOpen ? this.curtainWopen : this.curtainW).render(null, f + 1.0f, f2, f3, this.dir, this.offsetX + (float)(this.bCurtainOpen ? false : false), this.offsetY + (float)(this.bCurtainOpen ? false : false), colorInfo, true);
        }
    }

    public IsoDirections getSpriteEdge(boolean bl) {
        if (!this.open || bl) {
            return this.north ? IsoDirections.N : IsoDirections.W;
        }
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer != null && propertyContainer.Is("GarageDoor")) {
            return this.north ? IsoDirections.N : IsoDirections.W;
        }
        if (propertyContainer != null && propertyContainer.Is(IsoFlagType.attachedE)) {
            return IsoDirections.E;
        }
        if (propertyContainer != null && propertyContainer.Is(IsoFlagType.attachedS)) {
            return IsoDirections.S;
        }
        return this.north ? IsoDirections.W : IsoDirections.N;
    }

    public IsoDoor(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoSprite isoSprite, boolean bl) {
        this.open = isoSprite.getProperties().Is(IsoFlagType.open);
        this.OutlineOnMouseover = true;
        this.PushedStrength = 2500;
        this.PushedMaxStrength = 2500;
        int n = 2;
        if (isoSprite.getProperties().Is("DoubleDoor")) {
            n = 4;
        }
        if (isoSprite.getProperties().Is("GarageDoor")) {
            n = 8;
        }
        this.closedSprite = this.open ? IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, -n) : isoSprite;
        this.openSprite = this.open ? isoSprite : IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite, n);
        this.sprite = this.open ? this.openSprite : this.closedSprite;
        this.square = isoGridSquare;
        this.north = bl;
        switch (this.type) {
            case WeakWooden: {
                this.Health = 500;
                this.MaxHealth = 500;
                break;
            }
            case StrongWooden: {
                this.Health = 800;
                this.MaxHealth = 800;
            }
        }
        if (this.getSprite().getName() != null && this.getSprite().getName().contains("fences")) {
            this.Health = 100;
            this.MaxHealth = 100;
        }
        int n2 = 69;
        if (SandboxOptions.instance.LockedHouses.getValue() == 1) {
            n2 = -1;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 2) {
            n2 = 5;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 3) {
            n2 = 10;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 4) {
            n2 = 50;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 5) {
            n2 = 60;
        } else if (SandboxOptions.instance.LockedHouses.getValue() == 6) {
            n2 = 70;
        }
        if (n2 > -1) {
            boolean bl2 = this.Locked = Rand.Next(100) < n2;
            if (this.Locked && Rand.Next(3) == 0) {
                this.lockedByKey = true;
            }
        }
        if (this.getProperties().Is("forceLocked")) {
            this.Locked = true;
            this.lockedByKey = true;
        }
        if (this.open) {
            this.Locked = false;
            this.lockedByKey = false;
        }
    }

    public IsoDoor(IsoCell isoCell, IsoGridSquare isoGridSquare, String string, boolean bl) {
        this.OutlineOnMouseover = true;
        this.PushedStrength = 2500;
        this.PushedMaxStrength = 2500;
        this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 0);
        this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 2);
        this.sprite = this.closedSprite;
        String string2 = this.closedSprite.getProperties().Val("GarageDoor");
        if (string2 != null) {
            int n = Integer.parseInt(string2);
            if (n <= 3) {
                this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 8);
            } else {
                this.openSprite = this.sprite;
                this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, -8);
            }
        }
        this.square = isoGridSquare;
        this.north = bl;
        switch (this.type) {
            case WeakWooden: {
                this.Health = 500;
                this.MaxHealth = 500;
                break;
            }
            case StrongWooden: {
                this.Health = 800;
                this.MaxHealth = 800;
            }
        }
        if (this.getSprite().getName() != null && this.getSprite().getName().contains("fences")) {
            this.Health = 100;
            this.MaxHealth = 100;
        }
    }

    public IsoDoor(IsoCell isoCell, IsoGridSquare isoGridSquare, String string, boolean bl, KahluaTable kahluaTable) {
        this.OutlineOnMouseover = true;
        this.PushedStrength = 2500;
        this.PushedMaxStrength = 2500;
        this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 0);
        this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 2);
        this.table = kahluaTable;
        this.sprite = this.closedSprite;
        String string2 = this.sprite.getProperties().Val("GarageDoor");
        if (string2 != null) {
            int n = Integer.parseInt(string2);
            if (n <= 3) {
                this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 8);
            } else {
                this.openSprite = this.sprite;
                this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, -8);
            }
        }
        this.square = isoGridSquare;
        this.north = bl;
        switch (this.type) {
            case WeakWooden: {
                this.Health = 500;
                this.MaxHealth = 500;
                break;
            }
            case StrongWooden: {
                this.Health = 800;
                this.MaxHealth = 800;
            }
        }
        if (this.getSprite().getName() != null && this.getSprite().getName().contains("fences")) {
            this.Health = 100;
            this.MaxHealth = 100;
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        byte by;
        super.load(byteBuffer, n, bl);
        this.open = byteBuffer.get() == 1;
        this.Locked = byteBuffer.get() == 1;
        this.north = byteBuffer.get() == 1;
        this.Health = byteBuffer.getInt();
        this.MaxHealth = byteBuffer.getInt();
        this.closedSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
        this.openSprite = IsoSprite.getSprite(IsoSpriteManager.instance, byteBuffer.getInt());
        this.OutlineOnMouseover = true;
        this.PushedStrength = 2500;
        this.PushedMaxStrength = 2500;
        if (n >= 57) {
            this.keyId = byteBuffer.getInt();
            boolean bl2 = this.lockedByKey = byteBuffer.get() == 1;
        }
        if (n >= 80 && ((by = byteBuffer.get()) & 1) != 0) {
            this.bHasCurtain = true;
            this.bCurtainOpen = (by & 2) != 0;
            boolean bl3 = this.bCurtainInside = (by & 4) != 0;
        }
        if (SystemDisabler.doObjectStateSyncEnable && GameClient.bClient) {
            GameClient.instance.objectSyncReq.putRequestLoad(this.square);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.put(this.open ? (byte)1 : 0);
        byteBuffer.put(this.Locked ? (byte)1 : 0);
        byteBuffer.put(this.north ? (byte)1 : 0);
        byteBuffer.putInt(this.Health);
        byteBuffer.putInt(this.MaxHealth);
        byteBuffer.putInt(this.closedSprite.ID);
        byteBuffer.putInt(this.openSprite.ID);
        byteBuffer.putInt(this.getKeyId());
        byteBuffer.put(this.isLockedByKey() ? (byte)1 : 0);
        byte by = 0;
        if (this.bHasCurtain) {
            by = (byte)(by | 1);
            if (this.bCurtainOpen) {
                by = (byte)(by | 2);
            }
            if (this.bCurtainInside) {
                by = (byte)(by | 4);
            }
        }
        byteBuffer.put(by);
    }

    @Override
    public void saveState(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put((byte)(this.open ? 1 : 0));
        byteBuffer.put((byte)(this.Locked ? 1 : 0));
        byteBuffer.put((byte)(this.lockedByKey ? 1 : 0));
    }

    @Override
    public void loadState(ByteBuffer byteBuffer) throws IOException {
        boolean bl;
        boolean bl2 = byteBuffer.get() == 1;
        boolean bl3 = byteBuffer.get() == 1;
        boolean bl4 = bl = byteBuffer.get() == 1;
        if (bl2 != this.open) {
            this.open = bl2;
            IsoSprite isoSprite = this.sprite = bl2 ? this.openSprite : this.closedSprite;
        }
        if (bl3 != this.Locked) {
            this.Locked = bl3;
        }
        if (bl != this.lockedByKey) {
            this.lockedByKey = bl;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean IsOpen() {
        return this.open;
    }

    public boolean IsStrengthenedByPushedItems() {
        return false;
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        return false;
    }

    @Override
    public boolean TestPathfindCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        boolean bl = this.north;
        if (!this.isBarricaded()) {
            return false;
        }
        if (isoMovingObject instanceof IsoSurvivor && ((IsoSurvivor)isoMovingObject).getInventory().contains("Hammer")) {
            return false;
        }
        if (this.open) {
            boolean bl2 = bl = !bl;
        }
        if (isoGridSquare == this.square) {
            if (bl && isoGridSquare2.getY() < isoGridSquare.getY()) {
                return true;
            }
            if (!bl && isoGridSquare2.getX() < isoGridSquare.getX()) {
                return true;
            }
        } else {
            if (bl && isoGridSquare2.getY() > isoGridSquare.getY()) {
                return true;
            }
            if (!bl && isoGridSquare2.getX() > isoGridSquare.getX()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        boolean bl = this.north;
        if (this.open) {
            return false;
        }
        if (isoGridSquare == this.square) {
            if (bl && isoGridSquare2.getY() < isoGridSquare.getY()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
            if (!bl && isoGridSquare2.getX() < isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
        } else {
            if (bl && isoGridSquare2.getY() > isoGridSquare.getY()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
            if (!bl && isoGridSquare2.getX() > isoGridSquare.getX()) {
                if (isoMovingObject != null) {
                    isoMovingObject.collideWith(this);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        boolean bl;
        boolean bl2 = bl = this.sprite != null && this.sprite.getProperties().Is("doorTrans");
        if (this.sprite != null && this.sprite.getProperties().Is("GarageDoor") && this.open) {
            bl = true;
        }
        if (this.open) {
            bl = true;
        } else if (this.bHasCurtain && !this.bCurtainOpen) {
            bl = false;
        }
        boolean bl3 = this.north;
        if (this.open) {
            boolean bl4 = bl3 = !bl3;
        }
        if (isoGridSquare2.getZ() != isoGridSquare.getZ()) {
            return IsoObject.VisionResult.NoEffect;
        }
        if (isoGridSquare == this.square) {
            if (bl3 && isoGridSquare2.getY() < isoGridSquare.getY()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
            if (!bl3 && isoGridSquare2.getX() < isoGridSquare.getX()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
        } else {
            if (bl3 && isoGridSquare2.getY() > isoGridSquare.getY()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
            if (!bl3 && isoGridSquare2.getX() > isoGridSquare.getX()) {
                if (bl) {
                    return IsoObject.VisionResult.Unblocked;
                }
                return IsoObject.VisionResult.Blocked;
            }
        }
        return IsoObject.VisionResult.NoEffect;
    }

    @Override
    public void Thump(IsoMovingObject isoMovingObject) {
        if (this.isDestroyed()) {
            return;
        }
        if (isoMovingObject instanceof IsoGameCharacter) {
            Thumpable thumpable = this.getThumpableFor((IsoGameCharacter)isoMovingObject);
            if (thumpable == null) {
                return;
            }
            if (thumpable != this) {
                thumpable.Thump(isoMovingObject);
                return;
            }
        }
        if (isoMovingObject instanceof IsoZombie) {
            if (!(((IsoZombie)isoMovingObject).cognition != 1 || this.open || this.Locked && (isoMovingObject.getCurrentSquare() == null || isoMovingObject.getCurrentSquare().Is(IsoFlagType.exterior)))) {
                this.ToggleDoor((IsoGameCharacter)isoMovingObject);
                if (this.open) {
                    return;
                }
            }
            int n = isoMovingObject.getCurrentSquare().getMovingObjects().size();
            if (isoMovingObject.getCurrentSquare().getW() != null) {
                n += isoMovingObject.getCurrentSquare().getW().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getE() != null) {
                n += isoMovingObject.getCurrentSquare().getE().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getS() != null) {
                n += isoMovingObject.getCurrentSquare().getS().getMovingObjects().size();
            }
            if (isoMovingObject.getCurrentSquare().getN() != null) {
                n += isoMovingObject.getCurrentSquare().getN().getMovingObjects().size();
            }
            int n2 = ThumpState.getFastForwardDamageMultiplier();
            int n3 = ((IsoZombie)isoMovingObject).strength;
            if (n >= 2) {
                this.DirtySlice();
                this.Damage(((IsoZombie)isoMovingObject).strength * n2);
                if (SandboxOptions.instance.Lore.Strength.getValue() == 1) {
                    this.Damage(n * 2 * n2);
                }
            }
            if (Core.GameMode.equals("LastStand")) {
                this.Damage(1 * n2);
            }
            WorldSoundManager.instance.addSound(isoMovingObject, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
            this.setRenderEffect(RenderEffectType.Hit_Door, true);
        }
        if (this.Health <= 0) {
            if (this.getSquare().getBuilding() != null) {
                this.getSquare().getBuilding().forceAwake();
            }
            this.playDoorSound(((IsoGameCharacter)isoMovingObject).getEmitter(), "Break");
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer((IsoGameCharacter)isoMovingObject, "BreakDoor", false, isoMovingObject.getCurrentSquare(), 0.2f, 20.0f, 1.1f, true);
            }
            WorldSoundManager.instance.addSound(null, this.square.getX(), this.square.getY(), this.square.getZ(), 10, 20, true, 4.0f, 15.0f);
            isoMovingObject.setThumpTarget(null);
            if (IsoDoor.destroyDoubleDoor(this)) {
                return;
            }
            if (IsoDoor.destroyGarageDoor(this)) {
                return;
            }
            this.destroy();
        }
    }

    @Override
    public Thumpable getThumpableFor(IsoGameCharacter isoGameCharacter) {
        IsoBarricade isoBarricade = this.getBarricadeForCharacter(isoGameCharacter);
        if (isoBarricade != null) {
            return isoBarricade;
        }
        isoBarricade = this.getBarricadeOppositeCharacter(isoGameCharacter);
        if (isoBarricade != null) {
            return isoBarricade;
        }
        if (this.isDestroyed() || this.IsOpen()) {
            return null;
        }
        return this;
    }

    @Override
    public float getThumpCondition() {
        if (this.getMaxHealth() <= 0) {
            return 0.0f;
        }
        return (float)PZMath.clamp(this.getHealth(), 0, this.getMaxHealth()) / (float)this.getMaxHealth();
    }

    @Override
    public void WeaponHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (GameClient.bClient) {
            if (isoPlayer != null) {
                GameClient.instance.sendWeaponHit(isoPlayer, handWeapon, this);
            }
            this.setRenderEffect(RenderEffectType.Hit_Door, true);
            return;
        }
        Thumpable thumpable = this.getThumpableFor(isoGameCharacter);
        if (thumpable == null) {
            return;
        }
        if (thumpable instanceof IsoBarricade) {
            ((IsoBarricade)thumpable).WeaponHit(isoGameCharacter, handWeapon);
            return;
        }
        LuaEventManager.triggerEvent("OnWeaponHitThumpable", isoGameCharacter, handWeapon, this);
        if (this.open) {
            return;
        }
        if (this.isDestroyed()) {
            return;
        }
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength);
        float f = 1.0f;
        if (n == 0) {
            f = 0.5f;
        } else if (n == 1) {
            f = 0.63f;
        } else if (n == 2) {
            f = 0.76f;
        } else if (n == 3) {
            f = 0.89f;
        } else if (n == 4) {
            f = 1.02f;
        }
        if (n == 6) {
            f = 1.15f;
        } else if (n == 7) {
            f = 1.27f;
        } else if (n == 8) {
            f = 1.3f;
        } else if (n == 9) {
            f = 1.45f;
        } else if (n == 10) {
            f = 1.7f;
        }
        this.Damage((int)((float)handWeapon.getDoorDamage() * 2.0f * f));
        this.setRenderEffect(RenderEffectType.Hit_Door, true);
        if (Rand.Next(10) == 0) {
            this.Damage((int)((float)handWeapon.getDoorDamage() * 6.0f * f));
        }
        float f2 = GameTime.getInstance().getMultiplier() / 1.6f;
        switch (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Fitness)) {
            case 0: {
                isoGameCharacter.exert(0.01f * f2);
                break;
            }
            case 1: {
                isoGameCharacter.exert(0.007f * f2);
                break;
            }
            case 2: {
                isoGameCharacter.exert(0.0065f * f2);
                break;
            }
            case 3: {
                isoGameCharacter.exert(0.006f * f2);
                break;
            }
            case 4: {
                isoGameCharacter.exert(0.005f * f2);
                break;
            }
            case 5: {
                isoGameCharacter.exert(0.004f * f2);
                break;
            }
            case 6: {
                isoGameCharacter.exert(0.0035f * f2);
                break;
            }
            case 7: {
                isoGameCharacter.exert(0.003f * f2);
                break;
            }
            case 8: {
                isoGameCharacter.exert(0.0025f * f2);
                break;
            }
            case 9: {
                isoGameCharacter.exert(0.002f * f2);
            }
        }
        this.DirtySlice();
        if (handWeapon.getDoorHitSound() != null) {
            if (isoPlayer != null) {
                isoPlayer.setMeleeHitSurface(this.getSoundPrefix());
            }
            isoGameCharacter.getEmitter().playSound(handWeapon.getDoorHitSound(), this);
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer(isoGameCharacter, handWeapon.getDoorHitSound(), false, this.getSquare(), 1.0f, 20.0f, 2.0f, false);
            }
        }
        WorldSoundManager.instance.addSound(isoGameCharacter, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, false, 0.0f, 15.0f);
        if (!this.IsStrengthenedByPushedItems() && this.Health <= 0 || this.IsStrengthenedByPushedItems() && this.Health <= -this.PushedMaxStrength) {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Break");
            if (GameServer.bServer) {
                GameServer.PlayWorldSoundServer(isoGameCharacter, "BreakDoor", false, this.getSquare(), 0.2f, 20.0f, 1.1f, true);
            }
            WorldSoundManager.instance.addSound(isoGameCharacter, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, false, 0.0f, 15.0f);
            if (IsoDoor.destroyDoubleDoor(this)) {
                return;
            }
            if (IsoDoor.destroyGarageDoor(this)) {
                return;
            }
            this.destroy();
            LuaEventManager.triggerEvent("OnContainerUpdate");
        }
    }

    public void destroy() {
        int n;
        if (this.sprite != null && this.sprite.getProperties().Is("GarageDoor")) {
            this.destroyed = true;
            this.square.transmitRemoveItemFromSquare(this);
            return;
        }
        PropertyContainer propertyContainer = this.getProperties();
        if (propertyContainer == null) {
            return;
        }
        String string = propertyContainer.Val("Material");
        String string2 = propertyContainer.Val("Material2");
        String string3 = propertyContainer.Val("Material3");
        if (!(StringUtils.isNullOrEmpty(string) && StringUtils.isNullOrEmpty(string2) && StringUtils.isNullOrEmpty(string3))) {
            this.addItemsFromProperties();
        } else {
            int n2 = Rand.Next(2) + 1;
            for (n = 0; n < n2; ++n) {
                this.square.AddWorldInventoryItem("Base.Plank", 0.0f, 0.0f, 0.0f);
            }
        }
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem("Base.Doorknob");
        inventoryItem.setKeyId(this.checkKeyId());
        this.square.AddWorldInventoryItem(inventoryItem, 0.0f, 0.0f, 0.0f);
        n = Rand.Next(3);
        for (int i = 0; i < n; ++i) {
            this.square.AddWorldInventoryItem("Base.Hinge", 0.0f, 0.0f, 0.0f);
        }
        if (this.bHasCurtain) {
            this.square.AddWorldInventoryItem("Base.Sheet", 0.0f, 0.0f, 0.0f);
        }
        this.destroyed = true;
        this.square.transmitRemoveItemFromSquare(this);
    }

    public IsoGridSquare getOtherSideOfDoor(IsoGameCharacter isoGameCharacter) {
        if (this.north) {
            if (isoGameCharacter.getCurrentSquare().getRoom() == this.square.getRoom()) {
                return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY() - 1, this.square.getZ());
            }
            return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY(), this.square.getZ());
        }
        if (isoGameCharacter.getCurrentSquare().getRoom() == this.square.getRoom()) {
            return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX() - 1, this.square.getY(), this.square.getZ());
        }
        return IsoWorld.instance.CurrentCell.getGridSquare(this.square.getX(), this.square.getY(), this.square.getZ());
    }

    @Deprecated
    public boolean isExteriorDoor(IsoGameCharacter isoGameCharacter) {
        return this.isExterior();
    }

    public boolean isExterior() {
        IsoGridSquare isoGridSquare = this.getSquare();
        IsoGridSquare isoGridSquare2 = this.getOppositeSquare();
        if (isoGridSquare2 == null) {
            return false;
        }
        if (isoGridSquare.Is(IsoFlagType.exterior) && isoGridSquare2.getBuilding() != null && isoGridSquare2.getBuilding().getDef() != null) {
            return true;
        }
        return isoGridSquare.getBuilding() != null && isoGridSquare.getBuilding().getDef() != null && isoGridSquare2.Is(IsoFlagType.exterior);
    }

    @Override
    public boolean isHoppable() {
        if (this.IsOpen()) {
            return false;
        }
        if (this.closedSprite == null) {
            return false;
        }
        PropertyContainer propertyContainer = this.closedSprite.getProperties();
        return propertyContainer.Is(IsoFlagType.HoppableN) || propertyContainer.Is(IsoFlagType.HoppableW);
    }

    public boolean canClimbOver(IsoGameCharacter isoGameCharacter) {
        if (this.square == null) {
            return false;
        }
        if (!this.isHoppable()) {
            return false;
        }
        return isoGameCharacter == null || IsoWindow.canClimbThroughHelper(isoGameCharacter, this.getSquare(), this.getOppositeSquare(), this.north);
    }

    public void ToggleDoorActual(IsoGameCharacter isoGameCharacter) {
        int n;
        boolean bl;
        if (Core.bDebug && DebugOptions.instance.CheatDoorUnlock.getValue()) {
            this.Locked = false;
            this.setLockedByKey(false);
        }
        if (this.isHoppable()) {
            this.Locked = false;
            this.setLockedByKey(false);
        }
        if (this.isBarricaded()) {
            if (isoGameCharacter != null) {
                this.playDoorSound(isoGameCharacter.getEmitter(), "Blocked");
                isoGameCharacter.setHaloNote(Translator.getText("IGUI_PlayerText_DoorBarricaded"), 255, 255, 255, 256.0f);
                this.setRenderEffect(RenderEffectType.Hit_Door, true);
            }
            return;
        }
        this.checkKeyId();
        if (this.Locked && !this.lockedByKey && this.getKeyId() != -1) {
            this.lockedByKey = true;
        }
        if (!this.open && isoGameCharacter instanceof IsoPlayer) {
            ((IsoPlayer)isoGameCharacter).TimeSinceOpenDoor = 0.0f;
        }
        this.DirtySlice();
        IsoGridSquare.RecalcLightTime = -1;
        GameTime.instance.lightSourceUpdate = 100.0f;
        this.square.InvalidateSpecialObjectPaths();
        if (this.isLockedByKey() && isoGameCharacter != null && isoGameCharacter instanceof IsoPlayer && (isoGameCharacter.getCurrentSquare().Is(IsoFlagType.exterior) || this.getProperties().Is("forceLocked") || this.getModData().rawget("CustomLock") != null && this.getModData().rawget("CustomLock") instanceof Boolean && ((Boolean)this.getModData().rawget("CustomLock")).booleanValue()) && !this.open) {
            if (isoGameCharacter.getInventory().haveThisKeyId(this.getKeyId()) == null) {
                this.playDoorSound(isoGameCharacter.getEmitter(), "Locked");
                this.setRenderEffect(RenderEffectType.Hit_Door, true);
                return;
            }
            this.playDoorSound(isoGameCharacter.getEmitter(), "Unlock");
            this.playDoorSound(isoGameCharacter.getEmitter(), "Open");
            this.Locked = false;
            this.setLockedByKey(false);
        }
        boolean bl2 = bl = isoGameCharacter instanceof IsoPlayer && !isoGameCharacter.getCurrentSquare().isOutside();
        if ("Tutorial".equals(Core.getInstance().getGameMode()) && this.isLockedByKey()) {
            bl = false;
        }
        if (isoGameCharacter instanceof IsoPlayer && this.getSprite().getProperties().Is("GarageDoor")) {
            n = this.getSprite().getProperties().Is("InteriorSide");
            if (n != 0) {
                bl = this.north ? isoGameCharacter.getY() >= this.getY() : isoGameCharacter.getX() >= this.getX();
            } else {
                boolean bl3 = this.north ? isoGameCharacter.getY() < this.getY() : (bl = isoGameCharacter.getX() < this.getX());
            }
        }
        if (this.Locked && !bl && !this.open) {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Locked");
            this.setRenderEffect(RenderEffectType.Hit_Door, true);
            return;
        }
        if (this.getSprite().getProperties().Is("DoubleDoor")) {
            if (IsoDoor.isDoubleDoorObstructed(this)) {
                if (isoGameCharacter != null) {
                    this.playDoorSound(isoGameCharacter.getEmitter(), "Blocked");
                    isoGameCharacter.setHaloNote(Translator.getText("IGUI_PlayerText_DoorBlocked"), 255, 255, 255, 256.0f);
                }
                return;
            }
            n = this.open;
            IsoDoor.toggleDoubleDoor(this, true);
            if (n != this.open) {
                this.playDoorSound(isoGameCharacter.getEmitter(), this.open ? "Open" : "Close");
            }
            return;
        }
        if (this.getSprite().getProperties().Is("GarageDoor")) {
            if (IsoDoor.isGarageDoorObstructed(this)) {
                if (isoGameCharacter != null) {
                    this.playDoorSound(isoGameCharacter.getEmitter(), "Blocked");
                    isoGameCharacter.setHaloNote(Translator.getText("IGUI_PlayerText_DoorBlocked"), 255, 255, 255, 256.0f);
                }
                return;
            }
            n = this.open;
            IsoDoor.toggleGarageDoor(this, true);
            if (n != this.open) {
                this.playDoorSound(isoGameCharacter.getEmitter(), this.open ? "Open" : "Close");
            }
            return;
        }
        if (this.isObstructed()) {
            if (isoGameCharacter != null) {
                this.playDoorSound(isoGameCharacter.getEmitter(), "Blocked");
                isoGameCharacter.setHaloNote(Translator.getText("IGUI_PlayerText_DoorBlocked"), 255, 255, 255, 256.0f);
            }
            return;
        }
        this.Locked = false;
        this.setLockedByKey(false);
        if (isoGameCharacter instanceof IsoPlayer) {
            for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                LosUtil.cachecleared[n] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
        }
        this.open = !this.open;
        WeatherFxMask.forceMaskUpdateAll();
        this.sprite = this.closedSprite;
        if (this.open) {
            if (isoGameCharacter != null) {
                this.playDoorSound(isoGameCharacter.getEmitter(), "Open");
            }
            this.sprite = this.openSprite;
        } else if (isoGameCharacter != null) {
            this.playDoorSound(isoGameCharacter.getEmitter(), "Close");
        }
        this.square.RecalcProperties();
        this.syncIsoObject(false, this.open ? (byte)1 : 0, null, null);
        PolygonalMap2.instance.squareChanged(this.square);
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte((byte)0);
        byteBufferWriter.putBoolean(this.open);
        byteBufferWriter.putBoolean(this.Locked);
        byteBufferWriter.putBoolean(this.lockedByKey);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        if (this.square == null) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " square is null");
            return;
        }
        if (this.getObjectIndex() == -1) {
            System.out.println("ERROR: " + this.getClass().getSimpleName() + " not found on square " + this.square.getX() + "," + this.square.getY() + "," + this.square.getZ());
            return;
        }
        boolean bl2 = byteBuffer != null && byteBuffer.get() == 1;
        boolean bl3 = byteBuffer != null && byteBuffer.get() == 1;
        boolean bl4 = byteBuffer != null && byteBuffer.get() == 1;
        short s = -1;
        if ((GameServer.bServer || GameClient.bClient) && byteBuffer != null) {
            s = byteBuffer.getShort();
        }
        if (GameClient.bClient && !bl) {
            s = IsoPlayer.getInstance().getOnlineID();
            var9_9 = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncIsoObject.doPacket((ByteBufferWriter)((Object)var9_9));
            this.syncIsoObjectSend((ByteBufferWriter)((Object)var9_9));
            ((ByteBufferWriter)((Object)var9_9)).putShort(s);
            PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
        } else if (GameServer.bServer && !bl) {
            for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                var11_12 = udpConnection2.startPacket();
                PacketTypes.PacketType.SyncIsoObject.doPacket(var11_12);
                this.syncIsoObjectSend(var11_12);
                var11_12.putShort(s);
                PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
            }
        } else if (bl) {
            if (GameClient.bClient && s != -1 && (var9_9 = GameClient.IDToPlayerMap.get(s)) != null) {
                ((IsoPlayer)((Object)var9_9)).networkAI.setNoCollision(1000L);
            }
            if (IsoDoor.getDoubleDoorIndex(this) != -1) {
                if (bl2 != this.open) {
                    IsoDoor.toggleDoubleDoor(this, false);
                }
            } else if (bl2) {
                this.open = true;
                this.sprite = this.openSprite;
            } else {
                this.open = false;
                this.sprite = this.closedSprite;
            }
            this.Locked = bl3;
            this.lockedByKey = bl4;
            if (GameServer.bServer) {
                for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                    if ((udpConnection == null || udpConnection2.getConnectedGUID() == udpConnection.getConnectedGUID()) && udpConnection != null) continue;
                    var11_12 = udpConnection2.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(var11_12);
                    this.syncIsoObjectSend(var11_12);
                    var11_12.putShort(s);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
                }
            }
        }
        this.square.InvalidateSpecialObjectPaths();
        this.square.RecalcProperties();
        this.square.RecalcAllWithNeighbours(true);
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            LosUtil.cachecleared[i] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        GameTime.instance.lightSourceUpdate = 100.0f;
        LuaEventManager.triggerEvent("OnContainerUpdate");
        WeatherFxMask.forceMaskUpdateAll();
    }

    public void ToggleDoor(IsoGameCharacter isoGameCharacter) {
        this.ToggleDoorActual(isoGameCharacter);
    }

    public void ToggleDoorSilent() {
        if (this.isBarricaded()) {
            return;
        }
        this.square.InvalidateSpecialObjectPaths();
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            LosUtil.cachecleared[i] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        this.open = !this.open;
        this.sprite = this.closedSprite;
        if (this.open) {
            this.sprite = this.openSprite;
        }
    }

    void Damage(int n) {
        this.DirtySlice();
        this.Health -= n;
    }

    @Override
    public IsoBarricade getBarricadeOnSameSquare() {
        return IsoBarricade.GetBarricadeOnSquare(this.square, this.north ? IsoDirections.N : IsoDirections.W);
    }

    @Override
    public IsoBarricade getBarricadeOnOppositeSquare() {
        return IsoBarricade.GetBarricadeOnSquare(this.getOppositeSquare(), this.north ? IsoDirections.S : IsoDirections.E);
    }

    @Override
    public boolean isBarricaded() {
        IsoBarricade isoBarricade = this.getBarricadeOnSameSquare();
        if (isoBarricade == null) {
            isoBarricade = this.getBarricadeOnOppositeSquare();
        }
        return isoBarricade != null;
    }

    @Override
    public boolean isBarricadeAllowed() {
        return this.getSprite() != null && !this.getSprite().getProperties().Is("DoubleDoor") && !this.getSprite().getProperties().Is("GarageDoor");
    }

    @Override
    public IsoBarricade getBarricadeForCharacter(IsoGameCharacter isoGameCharacter) {
        return IsoBarricade.GetBarricadeForCharacter(this, isoGameCharacter);
    }

    @Override
    public IsoBarricade getBarricadeOppositeCharacter(IsoGameCharacter isoGameCharacter) {
        return IsoBarricade.GetBarricadeOppositeCharacter(this, isoGameCharacter);
    }

    public boolean isLocked() {
        return this.Locked;
    }

    public void setLocked(boolean bl) {
        this.Locked = bl;
    }

    @Override
    public boolean getNorth() {
        return this.north;
    }

    @Override
    public Vector2 getFacingPosition(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        if (this.north) {
            return vector22.set(this.getX() + 0.5f, this.getY());
        }
        return vector22.set(this.getX(), this.getY() + 0.5f);
    }

    @Override
    public Vector2 getFacingPositionAlt(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        switch (this.getSpriteEdge(false)) {
            case N: {
                return vector22.set(this.getX() + 0.5f, this.getY());
            }
            case S: {
                return vector22.set(this.getX() + 0.5f, this.getY() + 1.0f);
            }
            case W: {
                return vector22.set(this.getX(), this.getY() + 0.5f);
            }
            case E: {
                return vector22.set(this.getX() + 1.0f, this.getY() + 0.5f);
            }
        }
        throw new IllegalStateException();
    }

    public void setIsLocked(boolean bl) {
        this.Locked = bl;
    }

    public IsoSprite getOpenSprite() {
        return this.openSprite;
    }

    public void setOpenSprite(IsoSprite isoSprite) {
        this.openSprite = isoSprite;
    }

    @Override
    public int getKeyId() {
        return this.keyId;
    }

    public void syncDoorKey() {
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.SyncDoorKey.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byte by = (byte)this.square.getObjects().indexOf(this);
        if (by == -1) {
            System.out.println("ERROR: Door not found on square " + this.square.getX() + ", " + this.square.getY() + ", " + this.square.getZ());
            GameClient.connection.cancelPacket();
            return;
        }
        byteBufferWriter.putByte(by);
        byteBufferWriter.putInt(this.getKeyId());
        PacketTypes.PacketType.SyncDoorKey.send(GameClient.connection);
    }

    @Override
    public void setKeyId(int n) {
        if (this.keyId != n && GameClient.bClient) {
            this.keyId = n;
            this.syncDoorKey();
        } else {
            this.keyId = n;
        }
    }

    public boolean isLockedByKey() {
        return this.lockedByKey;
    }

    public void setLockedByKey(boolean bl) {
        boolean bl2 = bl != this.lockedByKey;
        this.lockedByKey = bl;
        this.Locked = bl;
        if (!GameServer.bServer && bl2) {
            if (bl) {
                this.syncIsoObject(false, (byte)3, null, null);
            } else {
                this.syncIsoObject(false, (byte)4, null, null);
            }
        }
    }

    public boolean haveKey() {
        return this.haveKey;
    }

    public void setHaveKey(boolean bl) {
        this.haveKey = bl;
        if (GameServer.bServer) {
            return;
        }
        if (bl) {
            this.syncIsoObject(false, (byte)-1, null, null);
        } else {
            this.syncIsoObject(false, (byte)-2, null, null);
        }
    }

    @Override
    public IsoGridSquare getOppositeSquare() {
        if (this.getNorth()) {
            return this.getCell().getGridSquare(this.getX(), this.getY() - 1.0f, this.getZ());
        }
        return this.getCell().getGridSquare(this.getX() - 1.0f, this.getY(), this.getZ());
    }

    public boolean isAdjacentToSquare(IsoGridSquare isoGridSquare) {
        IsoGridSquare isoGridSquare2 = this.getSquare();
        if (isoGridSquare2 == null || isoGridSquare == null) {
            return false;
        }
        boolean bl = !this.IsOpen();
        IsoGridSquare isoGridSquare3 = isoGridSquare2.getAdjacentSquare(IsoDirections.NW);
        IsoGridSquare isoGridSquare4 = isoGridSquare2.getAdjacentSquare(IsoDirections.N);
        IsoGridSquare isoGridSquare5 = isoGridSquare2.getAdjacentSquare(IsoDirections.NE);
        IsoGridSquare isoGridSquare6 = isoGridSquare2.getAdjacentSquare(IsoDirections.W);
        IsoGridSquare isoGridSquare7 = isoGridSquare2.getAdjacentSquare(IsoDirections.E);
        IsoGridSquare isoGridSquare8 = isoGridSquare2.getAdjacentSquare(IsoDirections.SW);
        IsoGridSquare isoGridSquare9 = isoGridSquare2.getAdjacentSquare(IsoDirections.S);
        IsoGridSquare isoGridSquare10 = isoGridSquare2.getAdjacentSquare(IsoDirections.SE);
        switch (this.getSpriteEdge(false)) {
            case N: {
                if (isoGridSquare == isoGridSquare3) {
                    if (isoGridSquare3.isWallTo(isoGridSquare4) || isoGridSquare3.isWindowTo(isoGridSquare4) || isoGridSquare3.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare4.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    if (isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare4) {
                    if (isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare5) {
                    if (isoGridSquare5.isWallTo(isoGridSquare4) || isoGridSquare5.isWindowTo(isoGridSquare4) || isoGridSquare5.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare4.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    if (isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare6) {
                    if (isoGridSquare6.isWallTo(isoGridSquare2) || isoGridSquare6.isWindowTo(isoGridSquare2) || isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.N);
                }
                if (isoGridSquare != isoGridSquare7) break;
                if (isoGridSquare7.isWallTo(isoGridSquare2) || isoGridSquare7.isWindowTo(isoGridSquare2) || isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.E, false)) {
                    return false;
                }
                return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.N);
            }
            case S: {
                if (isoGridSquare == isoGridSquare6) {
                    if (isoGridSquare6.isWallTo(isoGridSquare2) || isoGridSquare6.isWindowTo(isoGridSquare2) || isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.S);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.S);
                }
                if (isoGridSquare == isoGridSquare7) {
                    if (isoGridSquare7.isWallTo(isoGridSquare2) || isoGridSquare7.isWindowTo(isoGridSquare2) || isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.S);
                }
                if (isoGridSquare == isoGridSquare8) {
                    if (isoGridSquare8.isWallTo(isoGridSquare9) || isoGridSquare8.isWindowTo(isoGridSquare9) || isoGridSquare8.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare9.hasDoorOnEdge(IsoDirections.W, false)) {
                        return false;
                    }
                    return !isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false);
                }
                if (isoGridSquare == isoGridSquare9) {
                    return !isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false);
                }
                if (isoGridSquare != isoGridSquare10) break;
                if (isoGridSquare10.isWallTo(isoGridSquare9) || isoGridSquare10.isWindowTo(isoGridSquare9) || isoGridSquare10.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare9.hasDoorOnEdge(IsoDirections.E, false)) {
                    return false;
                }
                return !isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false);
            }
            case W: {
                if (isoGridSquare == isoGridSquare3) {
                    if (isoGridSquare3.isWallTo(isoGridSquare6) || isoGridSquare3.isWindowTo(isoGridSquare6) || isoGridSquare3.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare6.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    if (bl && isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare6) {
                    if (bl && isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare8) {
                    if (isoGridSquare8.isWallTo(isoGridSquare6) || isoGridSquare8.isWindowTo(isoGridSquare6) || isoGridSquare8.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare6.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    if (bl && isoGridSquare6.hasDoorOnEdge(IsoDirections.E, false)) {
                        return false;
                    }
                    return !this.IsOpen() || !isoGridSquare2.hasClosedDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare4) {
                    if (isoGridSquare4.isWallTo(isoGridSquare2) || isoGridSquare4.isWindowTo(isoGridSquare2) || isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.W);
                }
                if (isoGridSquare != isoGridSquare9) break;
                if (isoGridSquare9.isWallTo(isoGridSquare2) || isoGridSquare9.isWindowTo(isoGridSquare2) || isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.S, false)) {
                    return false;
                }
                return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.W);
            }
            case E: {
                if (isoGridSquare == isoGridSquare4) {
                    if (isoGridSquare4.isWallTo(isoGridSquare2) || isoGridSquare4.isWindowTo(isoGridSquare2) || isoGridSquare4.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.E);
                }
                if (isoGridSquare == isoGridSquare2) {
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.E);
                }
                if (isoGridSquare == isoGridSquare9) {
                    if (isoGridSquare9.isWallTo(isoGridSquare2) || isoGridSquare9.isWindowTo(isoGridSquare2) || isoGridSquare9.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.S, false)) {
                        return false;
                    }
                    return !bl || !isoGridSquare2.hasOpenDoorOnEdge(IsoDirections.E);
                }
                if (isoGridSquare == isoGridSquare5) {
                    if (isoGridSquare5.isWallTo(isoGridSquare7) || isoGridSquare5.isWindowTo(isoGridSquare7) || isoGridSquare5.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare6.hasDoorOnEdge(IsoDirections.N, false)) {
                        return false;
                    }
                    return !isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false);
                }
                if (isoGridSquare == isoGridSquare7) {
                    return !isoGridSquare7.hasDoorOnEdge(IsoDirections.W, false);
                }
                if (isoGridSquare != isoGridSquare10) break;
                if (isoGridSquare10.isWallTo(isoGridSquare7) || isoGridSquare10.isWindowTo(isoGridSquare7) || isoGridSquare10.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare7.hasDoorOnEdge(IsoDirections.S, false)) {
                    return false;
                }
                return !isoGridSquare7.hasDoorOnEdge(IsoDirections.E, false);
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public int checkKeyId() {
        BuildingDef buildingDef;
        if (this.getKeyId() != -1) {
            return this.getKeyId();
        }
        IsoGridSquare isoGridSquare = this.getSquare();
        IsoGridSquare isoGridSquare2 = this.getOppositeSquare();
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return -1;
        }
        BuildingDef buildingDef2 = isoGridSquare.getBuilding() == null ? null : isoGridSquare.getBuilding().getDef();
        BuildingDef buildingDef3 = buildingDef = isoGridSquare2.getBuilding() == null ? null : isoGridSquare2.getBuilding().getDef();
        if (buildingDef2 == null && buildingDef != null) {
            this.setKeyId(buildingDef.getKeyId());
        } else if (buildingDef2 != null && buildingDef == null) {
            this.setKeyId(buildingDef2.getKeyId());
        } else if (this.getProperties().Is("forceLocked") && buildingDef2 != null) {
            this.setKeyId(buildingDef2.getKeyId());
        }
        if (this.Locked && !this.lockedByKey && this.getKeyId() != -1) {
            this.lockedByKey = true;
        }
        return this.getKeyId();
    }

    public void setHealth(int n) {
        this.Health = n;
    }

    private void initCurtainSprites() {
        if (this.curtainN != null) {
            return;
        }
        this.curtainW = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainW.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_16");
        this.curtainW.def.setScale(0.8f, 0.8f);
        this.curtainWopen = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainWopen.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_20");
        this.curtainWopen.def.setScale(0.8f, 0.8f);
        this.curtainE = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainE.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_17");
        this.curtainE.def.setScale(0.8f, 0.8f);
        this.curtainEopen = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainEopen.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_21");
        this.curtainEopen.def.setScale(0.8f, 0.8f);
        this.curtainN = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainN.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_18");
        this.curtainN.def.setScale(0.8f, 0.8f);
        this.curtainNopen = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainNopen.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_22");
        this.curtainNopen.def.setScale(0.8f, 0.8f);
        this.curtainS = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainS.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_19");
        this.curtainS.def.setScale(0.8f, 0.8f);
        this.curtainSopen = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        this.curtainSopen.LoadFramesNoDirPageSimple("fixtures_windows_curtains_01_23");
        this.curtainSopen.def.setScale(0.8f, 0.8f);
    }

    public IsoDoor HasCurtains() {
        return this.bHasCurtain ? this : null;
    }

    public boolean isCurtainOpen() {
        return this.bHasCurtain && this.bCurtainOpen;
    }

    public void setCurtainOpen(boolean bl) {
        if (!this.bHasCurtain) {
            return;
        }
        this.bCurtainOpen = bl;
        if (!GameServer.bServer) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            GameTime.instance.lightSourceUpdate = 100.0f;
            IsoGridSquare.setRecalcLightTime(-1);
            if (this.square != null) {
                this.square.RecalcProperties();
                this.square.RecalcAllWithNeighbours(true);
            }
        }
    }

    public void transmitSetCurtainOpen(boolean bl) {
        if (!this.bHasCurtain) {
            return;
        }
        if (GameServer.bServer) {
            this.sendObjectChange("setCurtainOpen", "open", bl);
        }
        if (GameClient.bClient) {
            GameClient.instance.sendClientCommandV(null, "object", "openCloseCurtain", "x", Float.valueOf(this.getX()), "y", Float.valueOf(this.getY()), "z", Float.valueOf(this.getZ()), "index", this.getObjectIndex(), "open", !this.bCurtainOpen);
        }
    }

    public void toggleCurtain() {
        if (!this.bHasCurtain) {
            return;
        }
        if (GameClient.bClient) {
            this.transmitSetCurtainOpen(!this.isCurtainOpen());
        } else {
            this.setCurtainOpen(!this.isCurtainOpen());
            if (GameServer.bServer) {
                this.transmitSetCurtainOpen(this.isCurtainOpen());
            }
        }
    }

    public void addSheet(IsoGameCharacter isoGameCharacter) {
        if (this.bHasCurtain || isoGameCharacter == null || isoGameCharacter.getCurrentSquare() == null) {
            return;
        }
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        IsoGridSquare isoGridSquare2 = this.getSquare();
        this.addSheet(switch (this.getSpriteEdge(false)) {
            case IsoDirections.N -> this.north == isoGridSquare.getY() >= isoGridSquare2.getY();
            case IsoDirections.S -> isoGridSquare.getY() > isoGridSquare2.getY();
            case IsoDirections.W -> this.north == isoGridSquare.getX() < isoGridSquare2.getX();
            case IsoDirections.E -> isoGridSquare.getX() > isoGridSquare2.getX();
            default -> throw new IllegalStateException();
        }, isoGameCharacter);
    }

    public void addSheet(boolean bl, IsoGameCharacter isoGameCharacter) {
        if (this.bHasCurtain) {
            return;
        }
        this.bHasCurtain = true;
        this.bCurtainInside = bl;
        this.bCurtainOpen = true;
        if (GameServer.bServer) {
            this.sendObjectChange("addSheet", "inside", bl);
            if (isoGameCharacter != null) {
                isoGameCharacter.sendObjectChange("removeOneOf", "type", "Sheet");
            }
        } else if (isoGameCharacter != null) {
            isoGameCharacter.getInventory().RemoveOneOf("Sheet");
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            GameTime.instance.lightSourceUpdate = 100.0f;
            IsoGridSquare.setRecalcLightTime(-1);
            if (this.square != null) {
                this.square.RecalcProperties();
            }
        }
    }

    public void removeSheet(IsoGameCharacter isoGameCharacter) {
        if (!this.bHasCurtain) {
            return;
        }
        this.bHasCurtain = false;
        if (GameServer.bServer) {
            this.sendObjectChange("removeSheet");
            if (isoGameCharacter != null) {
                isoGameCharacter.sendObjectChange("addItemOfType", "type", "Base.Sheet");
            }
        } else if (isoGameCharacter != null) {
            isoGameCharacter.getInventory().AddItem("Base.Sheet");
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            GameTime.instance.lightSourceUpdate = 100.0f;
            IsoGridSquare.setRecalcLightTime(-1);
            if (this.square != null) {
                this.square.RecalcProperties();
            }
        }
    }

    public IsoGridSquare getAddSheetSquare(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.getCurrentSquare() == null) {
            return null;
        }
        IsoGridSquare isoGridSquare = isoGameCharacter.getCurrentSquare();
        IsoGridSquare isoGridSquare2 = this.getSquare();
        switch (this.getSpriteEdge(false)) {
            case N: {
                return isoGridSquare.getY() >= isoGridSquare2.getY() ? isoGridSquare2 : this.getCell().getGridSquare(isoGridSquare2.x, isoGridSquare2.y - 1, isoGridSquare2.z);
            }
            case S: {
                return isoGridSquare.getY() <= isoGridSquare2.getY() ? isoGridSquare2 : this.getCell().getGridSquare(isoGridSquare2.x, isoGridSquare2.y + 1, isoGridSquare2.z);
            }
            case W: {
                return isoGridSquare.getX() >= isoGridSquare2.getX() ? isoGridSquare2 : this.getCell().getGridSquare(isoGridSquare2.x - 1, isoGridSquare2.y, isoGridSquare2.z);
            }
            case E: {
                return isoGridSquare.getX() <= isoGridSquare2.getX() ? isoGridSquare2 : this.getCell().getGridSquare(isoGridSquare2.x + 1, isoGridSquare2.y, isoGridSquare2.z);
            }
        }
        throw new IllegalStateException();
    }

    public IsoGridSquare getSheetSquare() {
        if (!this.bHasCurtain) {
            return null;
        }
        switch (this.getSpriteEdge(false)) {
            case N: {
                if (this.open) {
                    return this.bCurtainInside ? this.getCell().getGridSquare(this.getX(), this.getY() - 1.0f, this.getZ()) : this.getSquare();
                }
                return this.bCurtainInside ? this.getSquare() : this.getCell().getGridSquare(this.getX(), this.getY() - 1.0f, this.getZ());
            }
            case S: {
                return this.bCurtainInside ? this.getCell().getGridSquare(this.getX(), this.getY() + 1.0f, this.getZ()) : this.getSquare();
            }
            case W: {
                if (this.open) {
                    return this.bCurtainInside ? this.getCell().getGridSquare(this.getX() - 1.0f, this.getY(), this.getZ()) : this.getSquare();
                }
                return this.bCurtainInside ? this.getSquare() : this.getCell().getGridSquare(this.getX() - 1.0f, this.getY(), this.getZ());
            }
            case E: {
                return this.bCurtainInside ? this.getCell().getGridSquare(this.getX() + 1.0f, this.getY(), this.getZ()) : this.getSquare();
            }
        }
        throw new IllegalStateException();
    }

    public int getHealth() {
        return this.Health;
    }

    public int getMaxHealth() {
        return this.MaxHealth;
    }

    public boolean isFacingSheet(IsoGameCharacter isoGameCharacter) {
        if (!this.bHasCurtain || isoGameCharacter == null || isoGameCharacter.getCurrentSquare() != this.getSheetSquare()) {
            return false;
        }
        IsoDirections isoDirections = this.bCurtainInside ? (this.open ? (this.north ? IsoDirections.E : IsoDirections.S) : (this.north ? IsoDirections.N : IsoDirections.W)) : (this.open ? (this.north ? IsoDirections.W : IsoDirections.N) : (this.north ? IsoDirections.S : IsoDirections.E));
        IsoDirections isoDirections2 = this.getSpriteEdge(false);
        if (isoDirections2 == IsoDirections.E) {
            IsoDirections isoDirections3 = isoDirections = this.bCurtainInside ? IsoDirections.W : IsoDirections.E;
        }
        if (isoDirections2 == IsoDirections.S) {
            isoDirections = this.bCurtainInside ? IsoDirections.N : IsoDirections.S;
        }
        return isoGameCharacter.getDir() == isoDirections || isoGameCharacter.getDir() == IsoDirections.RotLeft(isoDirections) || isoGameCharacter.getDir() == IsoDirections.RotRight(isoDirections);
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("addSheet".equals(string)) {
            if (kahluaTable != null && kahluaTable.rawget("inside") instanceof Boolean) {
                byteBuffer.put((Boolean)kahluaTable.rawget("inside") != false ? (byte)1 : 0);
            }
        } else if (!"removeSheet".equals(string)) {
            if ("setCurtainOpen".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget("open") instanceof Boolean) {
                    byteBuffer.put((Boolean)kahluaTable.rawget("open") != false ? (byte)1 : 0);
                }
            } else {
                super.saveChange(string, kahluaTable, byteBuffer);
            }
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("addSheet".equals(string)) {
            this.addSheet(byteBuffer.get() == 1, null);
        } else if ("removeSheet".equals(string)) {
            this.removeSheet(null);
        } else if ("setCurtainOpen".equals(string)) {
            this.setCurtainOpen(byteBuffer.get() == 1);
        } else {
            super.loadChange(string, byteBuffer);
        }
    }

    public void addRandomBarricades() {
        boolean bl;
        IsoBarricade isoBarricade;
        IsoGridSquare isoGridSquare;
        IsoGridSquare isoGridSquare2 = isoGridSquare = this.square.getRoom() == null ? this.square : this.getOppositeSquare();
        if (isoGridSquare != null && isoGridSquare.getRoom() == null && (isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)this, bl = isoGridSquare != this.square)) != null) {
            int n = Rand.Next(1, 4);
            for (int i = 0; i < n; ++i) {
                isoBarricade.addPlank(null, null);
            }
        }
    }

    public boolean isObstructed() {
        return IsoDoor.isDoorObstructed(this);
    }

    public static boolean isDoorObstructed(IsoObject isoObject) {
        IsoThumpable isoThumpable;
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable2 = isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        if (isoDoor == null && isoThumpable == null) {
            return false;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (isoGridSquare == null) {
            return false;
        }
        if (isoGridSquare.isSolid() || isoGridSquare.isSolidTrans() || isoGridSquare.Has(IsoObjectType.tree)) {
            return true;
        }
        int n = (isoGridSquare.x - 1) / 10;
        int n2 = (isoGridSquare.y - 1) / 10;
        int n3 = (int)Math.ceil(((float)isoGridSquare.x + 1.0f) / 10.0f);
        int n4 = (int)Math.ceil(((float)isoGridSquare.y + 1.0f) / 10.0f);
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (!baseVehicle.isIntersectingSquareWithShadow(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void toggleDoubleDoor(IsoObject isoObject, boolean bl) {
        int n = IsoDoor.getDoubleDoorIndex(isoObject);
        if (n == -1) {
            return;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl2 = isoDoor == null ? isoThumpable.north : isoDoor.north;
        boolean bl3 = isoDoor == null ? isoThumpable.open : isoDoor.open;
        IsoObject isoObject2 = IsoDoor.getDoubleDoorObject(isoObject, 1);
        IsoObject isoObject3 = IsoDoor.getDoubleDoorObject(isoObject, 2);
        IsoObject isoObject4 = IsoDoor.getDoubleDoorObject(isoObject, 3);
        IsoObject isoObject5 = IsoDoor.getDoubleDoorObject(isoObject, 4);
        if (isoObject2 != null) {
            IsoDoor.toggleDoubleDoorObject(isoObject2);
        }
        if (isoObject3 != null) {
            IsoDoor.toggleDoubleDoorObject(isoObject3);
        }
        if (isoObject4 != null) {
            IsoDoor.toggleDoubleDoorObject(isoObject4);
        }
        if (isoObject5 != null) {
            IsoDoor.toggleDoubleDoorObject(isoObject5);
        }
        LuaEventManager.triggerEvent("OnContainerUpdate");
        if (bl) {
            if (isoObject2 != null) {
                isoObject2.syncIsoObject(false, bl3 ? (byte)1 : 0, null, null);
            } else if (isoObject5 != null) {
                isoObject5.syncIsoObject(false, bl3 ? (byte)1 : 0, null, null);
            }
        }
    }

    private static void toggleDoubleDoorObject(IsoObject isoObject) {
        int n;
        int n2 = IsoDoor.getDoubleDoorIndex(isoObject);
        if (n2 == -1) {
            return;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl = isoDoor == null ? isoThumpable.north : isoDoor.north;
        boolean bl2 = isoDoor == null ? isoThumpable.open : isoDoor.open;
        int n3 = -1;
        if (isoDoor != null) {
            isoDoor.open = !bl2;
            isoDoor.setLockedByKey(false);
            n3 = isoDoor.checkKeyId();
        }
        if (isoThumpable != null) {
            isoThumpable.open = !bl2;
            isoThumpable.setLockedByKey(false);
            n3 = isoThumpable.getKeyId();
        }
        IsoSprite isoSprite = isoObject.getSprite();
        int n4 = n = bl ? DoubleDoorNorthSpriteOffset[n2 - 1] : DoubleDoorWestSpriteOffset[n2 - 1];
        if (bl2) {
            n *= -1;
        }
        isoObject.sprite = IsoSprite.getSprite(IsoSpriteManager.instance, isoSprite.getName(), n);
        isoObject.getSquare().RecalcAllWithNeighbours(true);
        if (n2 == 2 || n2 == 3) {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int[] nArray4;
            IsoGridSquare isoGridSquare = isoObject.getSquare();
            if (bl) {
                if (bl2) {
                    nArray4 = DoubleDoorNorthOpenXOffset;
                    nArray3 = DoubleDoorNorthOpenYOffset;
                    nArray2 = DoubleDoorNorthClosedXOffset;
                    nArray = DoubleDoorNorthClosedYOffset;
                } else {
                    nArray4 = DoubleDoorNorthClosedXOffset;
                    nArray3 = DoubleDoorNorthClosedYOffset;
                    nArray2 = DoubleDoorNorthOpenXOffset;
                    nArray = DoubleDoorNorthOpenYOffset;
                }
            } else if (bl2) {
                nArray4 = DoubleDoorWestOpenXOffset;
                nArray3 = DoubleDoorWestOpenYOffset;
                nArray2 = DoubleDoorWestClosedXOffset;
                nArray = DoubleDoorWestClosedYOffset;
            } else {
                nArray4 = DoubleDoorWestClosedXOffset;
                nArray3 = DoubleDoorWestClosedYOffset;
                nArray2 = DoubleDoorWestOpenXOffset;
                nArray = DoubleDoorWestOpenYOffset;
            }
            int n5 = isoGridSquare.getX() - nArray4[n2 - 1];
            int n6 = isoGridSquare.getY() - nArray3[n2 - 1];
            int n7 = n5 + nArray2[n2 - 1];
            int n8 = n6 + nArray[n2 - 1];
            isoGridSquare.RemoveTileObject(isoObject);
            PolygonalMap2.instance.squareChanged(isoGridSquare);
            isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n7, n8, isoGridSquare.getZ());
            if (isoGridSquare == null) {
                return;
            }
            if (isoThumpable != null) {
                IsoThumpable isoThumpable2 = new IsoThumpable(isoGridSquare.getCell(), isoGridSquare, isoObject.getSprite().getName(), bl, isoThumpable.getTable());
                isoThumpable2.setModData(isoThumpable.getModData());
                isoThumpable2.setCanBeLockByPadlock(isoThumpable.canBeLockByPadlock());
                isoThumpable2.setCanBePlastered(isoThumpable.canBePlastered());
                isoThumpable2.setIsHoppable(isoThumpable.isHoppable());
                isoThumpable2.setIsDismantable(isoThumpable.isDismantable());
                isoThumpable2.setName(isoThumpable.getName());
                isoThumpable2.setIsDoor(true);
                isoThumpable2.setIsThumpable(isoThumpable.isThumpable());
                isoThumpable2.setThumpDmg(isoThumpable.getThumpDmg());
                isoThumpable2.setThumpSound(isoThumpable.getThumpSound());
                isoThumpable2.open = !bl2;
                isoThumpable2.keyId = n3;
                isoGridSquare.AddSpecialObject(isoThumpable2);
            } else {
                IsoDoor isoDoor2 = new IsoDoor(isoGridSquare.getCell(), isoGridSquare, isoObject.getSprite().getName(), bl);
                isoDoor2.open = !bl2;
                isoDoor2.keyId = n3;
                isoGridSquare.getObjects().add(isoDoor2);
                isoGridSquare.getSpecialObjects().add(isoDoor2);
                isoGridSquare.RecalcProperties();
            }
            if (!GameClient.bClient) {
                isoGridSquare.restackSheetRope();
            }
            PolygonalMap2.instance.squareChanged(isoGridSquare);
        } else {
            PolygonalMap2.instance.squareChanged(isoObject.getSquare());
        }
    }

    public static int getDoubleDoorIndex(IsoObject isoObject) {
        boolean bl;
        IsoThumpable isoThumpable;
        if (isoObject == null || isoObject.getSquare() == null) {
            return -1;
        }
        PropertyContainer propertyContainer = isoObject.getProperties();
        if (propertyContainer == null || !propertyContainer.Is("DoubleDoor")) {
            return -1;
        }
        int n = Integer.parseInt(propertyContainer.Val("DoubleDoor"));
        if (n < 1 || n > 8) {
            return -1;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable2 = isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        if (isoDoor == null && isoThumpable == null) {
            return -1;
        }
        boolean bl2 = bl = isoDoor == null ? isoThumpable.open : isoDoor.open;
        if (bl) {
            if (n >= 5) {
                return n - 4;
            }
            return -1;
        }
        return n;
    }

    public static IsoObject getDoubleDoorObject(IsoObject isoObject, int n) {
        IsoObject isoObject2;
        int n2;
        int[] nArray;
        int[] nArray2;
        int n3 = IsoDoor.getDoubleDoorIndex(isoObject);
        if (n3 == -1) {
            return null;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl = isoDoor == null ? isoThumpable.north : isoDoor.north;
        boolean bl2 = isoDoor == null ? isoThumpable.open : isoDoor.open;
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (bl) {
            if (bl2) {
                nArray2 = DoubleDoorNorthOpenXOffset;
                nArray = DoubleDoorNorthOpenYOffset;
            } else {
                nArray2 = DoubleDoorNorthClosedXOffset;
                nArray = DoubleDoorNorthClosedYOffset;
            }
        } else if (bl2) {
            nArray2 = DoubleDoorWestOpenXOffset;
            nArray = DoubleDoorWestOpenYOffset;
        } else {
            nArray2 = DoubleDoorWestClosedXOffset;
            nArray = DoubleDoorWestClosedYOffset;
        }
        int n4 = isoGridSquare.getX() - nArray2[n3 - 1];
        int n5 = isoGridSquare.getY() - nArray[n3 - 1];
        int n6 = n4 + nArray2[n - 1];
        int n7 = n5 + nArray[n - 1];
        isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n6, n7, isoGridSquare.getZ());
        if (isoGridSquare == null) {
            return null;
        }
        ArrayList<IsoObject> arrayList = isoGridSquare.getSpecialObjects();
        if (isoDoor != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                isoObject2 = arrayList.get(n2);
                if (!(isoObject2 instanceof IsoDoor) || ((IsoDoor)isoObject2).north != bl || IsoDoor.getDoubleDoorIndex(isoObject2) != n) continue;
                return isoObject2;
            }
        }
        if (isoThumpable != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                isoObject2 = arrayList.get(n2);
                if (!(isoObject2 instanceof IsoThumpable) || ((IsoThumpable)isoObject2).north != bl || IsoDoor.getDoubleDoorIndex(isoObject2) != n) continue;
                return isoObject2;
            }
        }
        return null;
    }

    public static boolean isDoubleDoorObstructed(IsoObject isoObject) {
        int n;
        int n2;
        int[] nArray;
        int[] nArray2;
        int n3 = IsoDoor.getDoubleDoorIndex(isoObject);
        if (n3 == -1) {
            return false;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl = isoDoor == null ? isoThumpable.north : isoDoor.north;
        boolean bl2 = isoDoor == null ? isoThumpable.open : isoDoor.open;
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (bl) {
            if (bl2) {
                nArray2 = DoubleDoorNorthOpenXOffset;
                nArray = DoubleDoorNorthOpenYOffset;
            } else {
                nArray2 = DoubleDoorNorthClosedXOffset;
                nArray = DoubleDoorNorthClosedYOffset;
            }
        } else if (bl2) {
            nArray2 = DoubleDoorWestOpenXOffset;
            nArray = DoubleDoorWestOpenYOffset;
        } else {
            nArray2 = DoubleDoorWestClosedXOffset;
            nArray = DoubleDoorWestClosedYOffset;
        }
        int n4 = isoGridSquare.getX() - nArray2[n3 - 1];
        int n5 = isoGridSquare.getY() - nArray[n3 - 1];
        int n6 = n4;
        int n7 = n5 + (bl ? 0 : -3);
        int n8 = n6 + (bl ? 4 : 2);
        int n9 = n7 + (bl ? 2 : 4);
        int n10 = isoGridSquare.getZ();
        for (n2 = n7; n2 < n9; ++n2) {
            for (n = n6; n < n8; ++n) {
                IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n10);
                if (isoGridSquare2 == null || !isoGridSquare2.isSolid() && !isoGridSquare2.isSolidTrans() && !isoGridSquare2.Has(IsoObjectType.tree)) continue;
                return true;
            }
        }
        if (bl) {
            if (IsoDoor.hasSomething4x4(n4, n5, n4 + 1, n5 + 1, n10)) {
                return true;
            }
            if (IsoDoor.hasSomething4x4(n4 + 2, n5, n4 + 3, n5 + 1, n10)) {
                return true;
            }
        } else {
            if (IsoDoor.hasSomething4x4(n4, n5 - 1, n4 + 1, n5, n10)) {
                return true;
            }
            if (IsoDoor.hasSomething4x4(n4, n5 - 3, n4 + 1, n5 - 2, n10)) {
                return true;
            }
        }
        n2 = (n6 - 4) / 10;
        n = (n7 - 4) / 10;
        int n11 = (int)Math.ceil((n8 + 4) / 10);
        int n12 = (int)Math.ceil((n9 + 4) / 10);
        for (int i = n; i <= n12; ++i) {
            for (int j = n2; j <= n11; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    for (int i2 = n7; i2 < n9; ++i2) {
                        for (int i3 = n6; i3 < n8; ++i3) {
                            if (!baseVehicle.isIntersectingSquare(i3, i2, n10)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean isSomethingTo(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return false;
        }
        if (isoGridSquare2 == isoGridSquare.getAdjacentSquare(IsoDirections.E) && (isoGridSquare.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare2.getProperties().Is(IsoFlagType.DoorWallW))) {
            return true;
        }
        if (isoGridSquare2 == isoGridSquare.getAdjacentSquare(IsoDirections.SE) && (isoGridSquare.hasDoorOnEdge(IsoDirections.E, false) || isoGridSquare.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.W, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare2.getProperties().Is(IsoFlagType.DoorWallN) || isoGridSquare2.getProperties().Is(IsoFlagType.DoorWallW))) {
            return true;
        }
        if (isoGridSquare2 == isoGridSquare.getAdjacentSquare(IsoDirections.S) && (isoGridSquare.hasDoorOnEdge(IsoDirections.S, false) || isoGridSquare2.hasDoorOnEdge(IsoDirections.N, false) || isoGridSquare2.getProperties().Is(IsoFlagType.DoorWallN))) {
            return true;
        }
        return isoGridSquare.isWallTo(isoGridSquare2) || isoGridSquare.isWindowTo(isoGridSquare2);
    }

    private static boolean hasSomething4x4(int n, int n2, int n3, int n4, int n5) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n5);
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n3, n2, n5);
        IsoGridSquare isoGridSquare3 = IsoWorld.instance.CurrentCell.getGridSquare(n3, n4, n5);
        IsoGridSquare isoGridSquare4 = IsoWorld.instance.CurrentCell.getGridSquare(n, n4, n5);
        if (IsoDoor.isSomethingTo(isoGridSquare, isoGridSquare2)) {
            return true;
        }
        if (IsoDoor.isSomethingTo(isoGridSquare, isoGridSquare3)) {
            return true;
        }
        return IsoDoor.isSomethingTo(isoGridSquare, isoGridSquare4);
    }

    public static boolean destroyDoubleDoor(IsoObject isoObject) {
        int n = IsoDoor.getDoubleDoorIndex(isoObject);
        if (n == -1) {
            return false;
        }
        if (n == 1 || n == 4) {
            IsoObject isoObject2 = IsoDoor.getDoubleDoorObject(isoObject, n == 1 ? 2 : 3);
            if (isoObject2 instanceof IsoDoor) {
                ((IsoDoor)isoObject2).destroy();
            } else if (isoObject2 instanceof IsoThumpable) {
                ((IsoThumpable)isoObject2).destroy();
            }
        }
        if (isoObject instanceof IsoDoor) {
            ((IsoDoor)isoObject).destroy();
        } else if (isoObject instanceof IsoThumpable) {
            ((IsoThumpable)isoObject).destroy();
        }
        LuaEventManager.triggerEvent("OnContainerUpdate");
        return true;
    }

    public static int getGarageDoorIndex(IsoObject isoObject) {
        boolean bl;
        IsoThumpable isoThumpable;
        if (isoObject == null || isoObject.getSquare() == null) {
            return -1;
        }
        PropertyContainer propertyContainer = isoObject.getProperties();
        if (propertyContainer == null || !propertyContainer.Is("GarageDoor")) {
            return -1;
        }
        int n = Integer.parseInt(propertyContainer.Val("GarageDoor"));
        if (n < 1 || n > 6) {
            return -1;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable2 = isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        if (isoDoor == null && isoThumpable == null) {
            return -1;
        }
        boolean bl2 = bl = isoDoor == null ? isoThumpable.open : isoDoor.open;
        if (bl) {
            if (n >= 4) {
                return n - 3;
            }
            return -1;
        }
        return n;
    }

    public static IsoObject getGarageDoorPrev(IsoObject isoObject) {
        IsoObject isoObject2;
        int n;
        int n2;
        int n3 = IsoDoor.getGarageDoorIndex(isoObject);
        if (n3 == -1) {
            return null;
        }
        if (n3 == 1) {
            return null;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl = isoDoor == null ? isoThumpable.north : isoDoor.north;
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        int n4 = isoGridSquare.x - (bl ? 1 : 0);
        isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n4, n2 = isoGridSquare.y + (bl ? 0 : 1), isoGridSquare.getZ());
        if (isoGridSquare == null) {
            return null;
        }
        ArrayList<IsoObject> arrayList = isoGridSquare.getSpecialObjects();
        if (isoDoor != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                isoObject2 = arrayList.get(n);
                if (!(isoObject2 instanceof IsoDoor) || ((IsoDoor)isoObject2).north != bl || IsoDoor.getGarageDoorIndex(isoObject2) > n3) continue;
                return isoObject2;
            }
        }
        if (isoThumpable != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                isoObject2 = arrayList.get(n);
                if (!(isoObject2 instanceof IsoThumpable) || ((IsoThumpable)isoObject2).north != bl || IsoDoor.getGarageDoorIndex(isoObject2) > n3) continue;
                return isoObject2;
            }
        }
        return null;
    }

    public static IsoObject getGarageDoorNext(IsoObject isoObject) {
        IsoObject isoObject2;
        int n;
        int n2;
        int n3 = IsoDoor.getGarageDoorIndex(isoObject);
        if (n3 == -1) {
            return null;
        }
        if (n3 == 3) {
            return null;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl = isoDoor == null ? isoThumpable.north : isoDoor.north;
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        int n4 = isoGridSquare.x + (bl ? 1 : 0);
        isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n4, n2 = isoGridSquare.y - (bl ? 0 : 1), isoGridSquare.getZ());
        if (isoGridSquare == null) {
            return null;
        }
        ArrayList<IsoObject> arrayList = isoGridSquare.getSpecialObjects();
        if (isoDoor != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                isoObject2 = arrayList.get(n);
                if (!(isoObject2 instanceof IsoDoor) || ((IsoDoor)isoObject2).north != bl || IsoDoor.getGarageDoorIndex(isoObject2) < n3) continue;
                return isoObject2;
            }
        }
        if (isoThumpable != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                isoObject2 = arrayList.get(n);
                if (!(isoObject2 instanceof IsoThumpable) || ((IsoThumpable)isoObject2).north != bl || IsoDoor.getGarageDoorIndex(isoObject2) < n3) continue;
                return isoObject2;
            }
        }
        return null;
    }

    public static IsoObject getGarageDoorFirst(IsoObject isoObject) {
        int n = IsoDoor.getGarageDoorIndex(isoObject);
        if (n == -1) {
            return null;
        }
        if (n == 1) {
            return isoObject;
        }
        IsoObject isoObject2 = IsoDoor.getGarageDoorPrev(isoObject);
        while (isoObject2 != null) {
            if (IsoDoor.getGarageDoorIndex(isoObject2) == 1) {
                return isoObject2;
            }
            isoObject2 = IsoDoor.getGarageDoorPrev(isoObject2);
        }
        return isoObject;
    }

    private static void toggleGarageDoorObject(IsoObject isoObject) {
        boolean bl;
        int n = IsoDoor.getGarageDoorIndex(isoObject);
        if (n == -1) {
            return;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl2 = bl = isoDoor == null ? isoThumpable.open : isoDoor.open;
        if (isoDoor != null) {
            isoDoor.open = !bl;
            isoDoor.setLockedByKey(false);
            IsoSprite isoSprite = isoDoor.sprite = isoDoor.open ? isoDoor.openSprite : isoDoor.closedSprite;
        }
        if (isoThumpable != null) {
            isoThumpable.open = !bl;
            isoThumpable.setLockedByKey(false);
            isoThumpable.sprite = isoThumpable.open ? isoThumpable.openSprite : isoThumpable.closedSprite;
        }
        isoObject.getSquare().RecalcAllWithNeighbours(true);
        isoObject.syncIsoObject(false, bl ? (byte)0 : 1, null, null);
        PolygonalMap2.instance.squareChanged(isoObject.getSquare());
    }

    public static void toggleGarageDoor(IsoObject isoObject, boolean bl) {
        int n = IsoDoor.getGarageDoorIndex(isoObject);
        if (n == -1) {
            return;
        }
        IsoDoor.toggleGarageDoorObject(isoObject);
        IsoObject isoObject2 = IsoDoor.getGarageDoorPrev(isoObject);
        while (isoObject2 != null) {
            IsoDoor.toggleGarageDoorObject(isoObject2);
            isoObject2 = IsoDoor.getGarageDoorPrev(isoObject2);
        }
        IsoObject isoObject3 = IsoDoor.getGarageDoorNext(isoObject);
        while (isoObject3 != null) {
            IsoDoor.toggleGarageDoorObject(isoObject3);
            isoObject3 = IsoDoor.getGarageDoorNext(isoObject3);
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            LosUtil.cachecleared[i] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    private static boolean isGarageDoorObstructed(IsoObject isoObject) {
        boolean bl;
        int n = IsoDoor.getGarageDoorIndex(isoObject);
        if (n == -1) {
            return false;
        }
        IsoDoor isoDoor = isoObject instanceof IsoDoor ? (IsoDoor)isoObject : null;
        IsoThumpable isoThumpable = isoObject instanceof IsoThumpable ? (IsoThumpable)isoObject : null;
        boolean bl2 = isoDoor == null ? isoThumpable.north : isoDoor.north;
        boolean bl3 = bl = isoDoor == null ? isoThumpable.open : isoDoor.open;
        if (!bl) {
            return false;
        }
        int n2 = isoObject.square.x;
        int n3 = isoObject.square.y;
        int n4 = n2;
        int n5 = n3;
        if (bl2) {
            var10_10 = IsoDoor.getGarageDoorPrev(isoObject);
            while (var10_10 != null) {
                --n2;
                var10_10 = IsoDoor.getGarageDoorPrev(var10_10);
            }
            var11_12 = IsoDoor.getGarageDoorNext(isoObject);
            while (var11_12 != null) {
                ++n4;
                var11_12 = IsoDoor.getGarageDoorNext(var11_12);
            }
        } else {
            var10_10 = IsoDoor.getGarageDoorPrev(isoObject);
            while (var10_10 != null) {
                ++n5;
                var10_10 = IsoDoor.getGarageDoorPrev(var10_10);
            }
            var11_12 = IsoDoor.getGarageDoorNext(isoObject);
            while (var11_12 != null) {
                --n3;
                var11_12 = IsoDoor.getGarageDoorNext(var11_12);
            }
        }
        int n6 = (n2 - 4) / 10;
        int n7 = (n3 - 4) / 10;
        int n8 = (int)Math.ceil((n4 + 4) / 10);
        int n9 = (int)Math.ceil((n5 + 4) / 10);
        int n10 = isoObject.square.z;
        for (int i = n7; i <= n9; ++i) {
            for (int j = n6; j <= n8; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    for (int i2 = n3; i2 <= n5; ++i2) {
                        for (int i3 = n2; i3 <= n4; ++i3) {
                            if (!baseVehicle.isIntersectingSquare(i3, i2, n10) || !baseVehicle.isIntersectingSquare(i3 - (bl2 ? 0 : 1), i2 - (bl2 ? 1 : 0), n10)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean destroyGarageDoor(IsoObject isoObject) {
        IsoObject isoObject2;
        int n = IsoDoor.getGarageDoorIndex(isoObject);
        if (n == -1) {
            return false;
        }
        IsoObject isoObject3 = IsoDoor.getGarageDoorPrev(isoObject);
        while (isoObject3 != null) {
            isoObject2 = IsoDoor.getGarageDoorPrev(isoObject3);
            if (isoObject3 instanceof IsoDoor) {
                ((IsoDoor)isoObject3).destroy();
            } else if (isoObject3 instanceof IsoThumpable) {
                ((IsoThumpable)isoObject3).destroy();
            }
            isoObject3 = isoObject2;
        }
        isoObject2 = IsoDoor.getGarageDoorNext(isoObject);
        while (isoObject2 != null) {
            IsoObject isoObject4 = IsoDoor.getGarageDoorNext(isoObject2);
            if (isoObject2 instanceof IsoDoor) {
                ((IsoDoor)isoObject2).destroy();
            } else if (isoObject2 instanceof IsoThumpable) {
                ((IsoThumpable)isoObject2).destroy();
            }
            isoObject2 = isoObject4;
        }
        if (isoObject instanceof IsoDoor) {
            ((IsoDoor)isoObject).destroy();
        } else if (isoObject instanceof IsoThumpable) {
            ((IsoThumpable)isoObject).destroy();
        }
        LuaEventManager.triggerEvent("OnContainerUpdate");
        return true;
    }

    @Override
    public IsoObject getRenderEffectMaster() {
        int n = IsoDoor.getDoubleDoorIndex(this);
        if (n != -1) {
            IsoObject isoObject = null;
            if (n == 2) {
                isoObject = IsoDoor.getDoubleDoorObject(this, 1);
            } else if (n == 3) {
                isoObject = IsoDoor.getDoubleDoorObject(this, 4);
            }
            if (isoObject != null) {
                return isoObject;
            }
        } else {
            IsoObject isoObject = IsoDoor.getGarageDoorFirst(this);
            if (isoObject != null) {
                return isoObject;
            }
        }
        return this;
    }

    public String getThumpSound() {
        switch (this.getSoundPrefix()) {
            case "GarageDoor": {
                return "ZombieThumpGarageDoor";
            }
            case "MetalDoor": 
            case "MetalGate": 
            case "PrisonMetalDoor": {
                return "ZombieThumpMetal";
            }
            case "SlidingGlassDoor": {
                return "ZombieThumpWindow";
            }
        }
        return "ZombieThumpGeneric";
    }

    private String getSoundPrefix() {
        if (this.closedSprite == null) {
            return "WoodDoor";
        }
        PropertyContainer propertyContainer = this.closedSprite.getProperties();
        if (propertyContainer.Is("DoorSound")) {
            return propertyContainer.Val("DoorSound");
        }
        return "WoodDoor";
    }

    private void playDoorSound(BaseCharacterSoundEmitter baseCharacterSoundEmitter, String string) {
        baseCharacterSoundEmitter.playSound(this.getSoundPrefix() + string, this);
    }

    public static enum DoorType {
        WeakWooden,
        StrongWooden;

    }
}

